//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "ErrorList_Form.h"
#include "Message_Form.h"
#include "MultiLanguage.h"
#include <windows.h>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntExtCtrls"
#pragma link "TntGrids"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"

#define ERROR_MAX_COUNT			4096
#define SAVE_DATA_MAX_COUNT     2048
#define ERROR_READ_MAX_COUNT	16
TErrorListForm *ErrorListForm;
//---------------------------------------------------------------------------
__fastcall TErrorListForm::TErrorListForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

	DataCount = 0;
}
//---------------------------------------------------------------------------
void __fastcall TErrorListForm::ExitButtonClick(TObject *Sender)
{
	Close();	
}
//---------------------------------------------------------------------------
void __fastcall TErrorListForm::ResizeComponents(void)
{
	ErrorStringGrid->ColWidths[0] = 20;
    ErrorStringGrid->Cells[1][0] = "Board";
    ErrorStringGrid->Cells[2][0] = "Time";
    ErrorStringGrid->Cells[3][0] = "Type";
    ErrorStringGrid->Cells[4][0] = "Code";
    ErrorStringGrid->Cells[5][0] = "Value 1";
    ErrorStringGrid->Cells[6][0] = "Value 2";
    ErrorStringGrid->Cells[7][0] = "Value 3";
    ErrorStringGrid->Cells[8][0] = "Message";
    ErrorStringGrid->ColWidths[1] = 100;
    ErrorStringGrid->ColWidths[4] = 200; 
    ErrorStringGrid->ColWidths[8] = ErrorStringGrid->Width - ErrorStringGrid->CellRect(7, 0).Right - 5;
}
//---------------------------------------------------------------------------
void __fastcall TErrorListForm::FormResize(TObject *Sender)
{
	ResizeComponents();
}
//---------------------------------------------------------------------------
void __fastcall TErrorListForm::FormCreate(TObject *Sender)
{
	ResizeComponents();
}
//---------------------------------------------------------------------------
void __fastcall TErrorListForm::ReadButtonClick(TObject *Sender)
{
	ReadError();
}
//---------------------------------------------------------------------------
bool __fastcall TErrorListForm::ReadError(void)
{
    bool returnValue = true;
	struct
    {
    	int count;
		TErrorUnit errorUnit[ERROR_READ_MAX_COUNT];
    } errorListData;
	try
    {
    	int maxReadCount;
    	maxReadCount = ERROR_READ_MAX_COUNT;
	Comm_SetMaxWaitingTime(COMM_HCB, 1000);
        if (Comm_Request(COMM_HCB, CMD_READ_ERROR_LIST, &maxReadCount, sizeof(int),
        	&errorListData, sizeof(errorListData)))
        {
        	if (errorListData.count > 0)
            {
                if (errorListData.count > ERROR_READ_MAX_COUNT)
                {
                    ShowMessageFA("HCB - Error Count Overflow " + IntToStr(errorListData.count));
                }
                else
                {
                    if (errorListData.errorUnit->troubleBoard == 444)   //sjm
                    {
                            ShowMessage(errorListData.errorUnit->value[2]);
                    }
	            	ErrorList.insert(ErrorList.end(), errorListData.errorUnit, errorListData.errorUnit + errorListData.count);
	                UpdateErrorList();
                }
            }
        }
        else
        {
            //ShowMessageFA("HCB - " + HCBConnection.GetLastErrorMessage());
            return false;
        }
	Comm_SetDefaultMaxWaitingTime(COMM_HCB);
	
	Comm_SetMaxWaitingTime(COMM_TPB, 1000);
        if (Comm_IsConnected(COMM_TPB))
        {
	        if (Comm_Request(COMM_TPB, CMD_READ_ERROR_LIST, &maxReadCount, sizeof(int),
	        	&errorListData, sizeof(errorListData)))
	        {
	        	if (errorListData.count > 0)
	            {
                    if (errorListData.count > ERROR_READ_MAX_COUNT)
                    {
                        ShowMessageFA("HCB - Error Count Overflow " + IntToStr(errorListData.count));
                    }
                    else
                    {
                        if (errorListData.errorUnit->troubleBoard == 444)   //sjm
                        {
                                ShowMessage(errorListData.errorUnit->value[2]);
                        }
    	            	ErrorList.insert(ErrorList.end(), errorListData.errorUnit, errorListData.errorUnit + errorListData.count);
    	                UpdateErrorList();
                    }
	            }
            }
            else
            {
                //ShowMessageFA("HCB - " + HCBConnection.GetLastErrorMessage());
                return false;
            }
        }
	Comm_SetDefaultMaxWaitingTime(COMM_TPB);	

    	for (int spbIndex = 0; spbIndex < MachineSetupData.IPB_BoardCount; spbIndex++)
        {
        	if(!Comm_IsConnected(COMM_SPB + spbIndex)) continue;
		Comm_SetMaxWaitingTime(COMM_SPB + spbIndex, 1000);
		if (Comm_Request(COMM_SPB + spbIndex, CMD_READ_ERROR_LIST, &maxReadCount, sizeof(int),&errorListData, sizeof(errorListData)))
		{
			if (errorListData.count > 0)
			{
				if (errorListData.count > ERROR_READ_MAX_COUNT)
				{
					ShowMessageFA("SPB" + IntToStr(spbIndex + 1) + " - Error Count Overflow " + IntToStr(errorListData.count));
				}
				else
				{
					ErrorList.insert(ErrorList.end(), errorListData.errorUnit, errorListData.errorUnit + errorListData.count);
					UpdateErrorList();
				}
			}
		}
		else
		{
			//ShowMessageFA("SPB" + IntToStr(spbIndex + 1) + " - " + SPBConnection[spbIndex].GetLastErrorMessage());
			return false;
	
		}
		Comm_SetDefaultMaxWaitingTime(COMM_SPB + spbIndex);
        }
       
    }
    catch (...)
    {

    }
    
    return returnValue;
}
//---------------------------------------------------------------------------
void __fastcall TErrorListForm::UpdateErrorList(void)
{
	int rowIndex = 1;
    vector<TErrorUnit>::iterator it;
    if (ErrorList.size() > ERROR_MAX_COUNT)
    {
		SaveErrorList();
    }


    ErrorStringGrid->RowCount = ErrorList.size() + 1;
	for (it = ErrorList.begin(); it < ErrorList.end(); it++)
    {
    	ErrorStringGrid->Cells[1][rowIndex] = BoardIDToStr(it->troubleBoard);
        ErrorStringGrid->Cells[2][rowIndex] = IntToStr(it->time);
        ErrorStringGrid->Cells[3][rowIndex] = ErrorTypeToStr(it->type);
        ErrorStringGrid->Cells[4][rowIndex] = ErrorCodeToStr(it->code);
        ErrorStringGrid->Cells[5][rowIndex] = IntToStr(it->value[0]);
        ErrorStringGrid->Cells[6][rowIndex] = IntToStr(it->value[1]);
        ErrorStringGrid->Cells[7][rowIndex] = IntToStr(it->value[2]);
        ErrorStringGrid->Cells[8][rowIndex] = ErrorUnitToMessage(it);

		rowIndex++;
    }
}
//---------------------------------------------------------------------------
void __fastcall TErrorListForm::SaveErrorList(void)
{
    // get errorlist filename
    unsigned short year;
    unsigned short month;
    unsigned short day;
    Now().DecodeDate(&year, &month, &day);
    AnsiString dateStr = Format("%04d-%02d-%02d", ARRAYOFCONST((year, month, day)));
    int fileIndex = 1;
    AnsiString logFileName;
    ForceDirectories(ProgramPath.Log + "\\Error Log");
    while (true)
    {
        logFileName = ProgramPath.Log + "\\Error Log\\" + dateStr + "_" + IntToStr(fileIndex) + ".log";
        if (!FileExists(logFileName))
        {
            break;
        }
        else
        {
            fileIndex++;
        }
    }

    int logDataVersion = 100;
    int saveDataCount = min(SAVE_DATA_MAX_COUNT, ErrorList.size());
    TFileStream *fileStream = new TFileStream(logFileName, fmCreate);
    if (fileStream)
    {
        fileStream->Write(&logDataVersion, sizeof(int));
        fileStream->Write(&saveDataCount, sizeof(int));
        vector<TErrorUnit>::iterator it;
        int dataCount = 0;
        for (it = ErrorList.begin(); it < ErrorList.end(); it++)
        {
            fileStream->Write(it, sizeof(TErrorUnit));
            dataCount++;
            if (dataCount == saveDataCount)
            {
                break;
            }
        }
        delete fileStream;
        ErrorList.erase(ErrorList.begin(), ErrorList.begin() + saveDataCount);
    }
    else
    {
        ErrorList.erase(ErrorList.begin(), ErrorList.begin() + saveDataCount);
    }

/*
	vector<TErrorUnit>::iterator it;

    AnsiString saveFileName = Folder.

    it = ErrorList.begin();
	for (int errorIndex = 0; errorIndex < ERROR_MAX_COUNT / 2; errorIndex++)
    {
		ErrorList.
*/        
}
//---------------------------------------------------------------------------
AnsiString __fastcall BoardIDToStr(int boardID)
{
    if (boardID == 0x2000)  // hcb
    {
        return "HCB";
    }
	else if ((boardID & 0xFC0) && ((boardID & 0x3F) == 0))	// spb
    {
		return "SPB " + IntToStr((boardID & 0xFC0) >> 6);
    }
    else if ((boardID & 0xFC0) && ((boardID & 0x3F) != 0))	// cpb
    {
		return "SPB " + IntToStr((boardID & 0xFC0) >> 6) + ", CPB " + IntToStr((boardID & 0x3F));
    }
    else
    {
    	AnsiString temp;
        return "0x" + temp.sprintf("%x", boardID);
    }
}
//---------------------------------------------------------------------------
AnsiString __fastcall ErrorTypeToStr(int errorType)
{
	AnsiString message = "";
    switch (errorType)
    {
		case ERROR_TYPE_CRITICAL:
        	message = "Critical";
            break;
        case ERROR_TYPE_MESSAGE:
        	message = "Message";
            break;
        case ERROR_TYPE_WARNING:
        	message = "Warning";
            break;
        case ERROR_TYPE_DEBUG:
        	message = "Debug";
            break;
        default:
        	message = IntToStr(errorType);
            break;
    }
    return message;
}
//---------------------------------------------------------------------------
AnsiString __fastcall ErrorCodeToStr(int errorCode)
{
	AnsiString returnStr = "";
    switch(errorCode)
    {
		case ERROR_CODE_CHECKSUM:
			returnStr = "ERROR_CODE_CHECKSUM";
            break;
		case ERROR_CODE_ALREADY_PACKET:
			returnStr = "ERROR_CODE_ALREADY_PACKET";
            break;
		case ERROR_CODE_WRONG_SIZE:
			returnStr = "ERROR_CODE_WRONG_SIZE";
            break;
		case ERROR_CODE_NOTMATCH:
			returnStr = "ERROR_CODE_NOTMATCH";
            break;
		case ERROR_CODE_OVERFLOW:
			returnStr = "ERROR_CODE_OVERFLOW";
            break;
		case ERROR_CODE_FLASH_OPEN:
			returnStr = "ERROR_CODE_FLASH_OPEN";
            break;
		case ERROR_CODE_FLASH_READ:
			returnStr = "ERROR_CODE_FLASH_READ";
            break;
		case ERROR_CODE_FLASH_WRITE:
			returnStr = "ERROR_CODE_FLASH_WRITE";
            break;
		case ERROR_CODE_ENVIRONMENT_NOT_MATCH:
			returnStr = "ERROR_CODE_ENVIRONMENT_NOT_MATCH";
            break;
		case ERROR_CODE_TIMER_OVERLAP:
			returnStr = "ERROR_CODE_TIMER_OVERLAP";
            break;
		case ERROR_CODE_MCBSP_WRONG_SIZE:
			returnStr = "ERROR_CODE_MCBSP_WRONG_SIZE";
            break;
		case ERROR_CODE_MCBSP_MULTIPLE_RESPONSE:
			returnStr = "ERROR_CODE_MCBSP_MULTIPLE_RESPONSE";
            break;
		case ERROR_CODE_MCBSP_TX_NOT_EMPTY:
			returnStr = "ERROR_CODE_MCBSP_TX_NOT_EMPTY";
            break;
		case ERROR_CODE_MCBSP_TX_CANNOT_WRITE:
			returnStr = "ERROR_CODE_MCBSP_TX_CANNOT_WRITE";
            break;
		case ERROR_CODE_MCBSP_TRANSMIT_TIMEOUT:
			returnStr = "ERROR_CODE_MCBSP_TRANSMIT_TIMEOUT";
            break;
		case ERROR_CODE_MCBSP_BUFFER_OVERFLOW:
			returnStr = "ERROR_CODE_MCBSP_BUFFER_OVERFLOW";
            break;
		case ERROR_CODE_MCBSP_RETRY_COUNT_OVER:
			returnStr = "ERROR_CODE_MCBSP_RETRY_COUNT_OVER";
            break;
		case ERROR_CODE_HPI_CPB_INT_STATE:
			returnStr = "ERROR_CODE_HPI_CPB_INT_STATE";
            break;
		case ERROR_CODE_HPI_READ_TIMEOUT:
			returnStr = "ERROR_CODE_HPI_READ_TIMEOUT";
            break;
		case ERROR_CODE_HPI_RETRY_EXCEEDED:
			returnStr = "ERROR_CODE_HPI_RETRY_EXCEEDED";
            break;
		case ERROR_CODE_HPI_RLI_TIMEOUT:
			returnStr = "ERROR_CODE_HPI_RLI_TIMEOUT";
            break;
		case ERROR_CODE_HPI_SI_TIMEOUT:
			returnStr = "ERROR_CODE_HPI_SI_TIMEOUT";
            break;
		case ERROR_CODE_HPI_SLI_TIMEOUT:
			returnStr = "ERROR_CODE_HPI_SLI_TIMEOUT";
            break;
		case ERROR_CODE_CAPTURE_TIMEOUT:
			returnStr = "ERROR_CODE_CAPTURE_TIMEOUT";
            break;
		case ERROR_CODE_CAPTURE_UNWANTED_INT:
			returnStr = "ERROR_CODE_CAPTURE_UNWANTED_INT";
            break;
		case ERROR_CODE_CAPTURE_JOB_FULL:
			returnStr = "ERROR_CODE_CAPTURE_JOB_FULL";
            break;
		case ERROR_CODE_CAPTURE_DMA_TABLE_OVERFLOW:
			returnStr = "ERROR_CODE_CAPTURE_DMA_TABLE_OVERFLOW";
            break;
		case ERROR_CODE_CPB_BOARD_DOWN:
			returnStr = "ERROR_CODE_CPB_BOARD_DOWN";
            break;
		case ERROR_CODE_CPB_PROCESS_TIMEOUT:
			returnStr = "ERROR_CODE_CPB_PROCESS_TIMEOUT";
            break;
		case ERROR_CODE_SERVO_NAK:
			returnStr = "ERROR_CODE_SERVO_NAK";
            break;
		case ERROR_CODE_SERVO_ALRAM:
			returnStr = "ERROR_CODE_SERVO_ALRAM";
            break;
		case ERROR_CODE_SERVO_COM_TIMEOUT:
			returnStr = "ERROR_CODE_SERVO_COM_TIMEOUT";
            break;
		case ERROR_CODE_SERVO_WRONG_CODE:
			returnStr = "ERROR_CODE_SERVO_WRONG_CODE";
            break;
		case ERROR_CODE_STEPMOTOR_BUSY:
			returnStr = "ERROR_CODE_STEPMOTOR_BUSY";
            break;
        default:
			returnStr = "0x" + returnStr.sprintf("%x", errorCode);
    }
    return returnStr;
}
//---------------------------------------------------------------------------
WideString __fastcall ErrorUnitToMessage(TErrorUnit *errorUnit)
{
	WideString message;
  WCHAR tempmessage[100];
    switch(errorUnit->code)
    {
		case ERROR_CODE_CAPTURE_TIMEOUT:
      wsprintfW(tempmessage, ERRORLISTFORM_MSG_04, errorUnit->value[0] + 1, errorUnit->value[1]);
      
			break;
        case ERROR_CODE_FLASH_OPEN:
        	message = ERRORLISTFORM_MSG_05;
            break;
        case ERROR_CODE_SERVO_NAK:
        	message = ERRORLISTFORM_MSG_06;
            break;
        case ERROR_CODE_SERVO_COM_TIMEOUT:
            if (errorUnit->value[1] == 0)
            {
              wsprintfW(tempmessage, ERRORLISTFORM_MSG_02, errorUnit->value[0]);
              message = tempmessage;
            }
            else if (errorUnit->value[1] == 1)
            {
              wsprintfW(tempmessage, ERRORLISTFORM_MSG_01, errorUnit->value[0]);
              message = tempmessage;
            }
            else
            {
              wsprintfW(tempmessage, ERRORLISTFORM_MSG_03, errorUnit->value[0]);
              message = tempmessage;
            }
            break;
    }

    return message;
}
//---------------------------------------------------------------------------
void __fastcall TErrorListForm::ErrorReadTimerTimer(TObject *Sender)
{
  if(!bSystemStatusCheckSW) return;
  
	bool timerEnabled = ErrorReadTimer->Enabled;
	ErrorReadTimer->Enabled = false;
	if (!ReadError())
	{
		//timerEnabled = false;
	}
	ErrorReadTimer->Enabled = timerEnabled;
}
//---------------------------------------------------------------------------
void __fastcall TErrorListForm::FormDestroy(TObject *Sender)
{
    while (ErrorList.size() != 0)
    {
        SaveErrorList();
    }    
}
//---------------------------------------------------------------------------

