//---------------------------------------------------------------------------
#ifndef ErrorList_FormH
#define ErrorList_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Grids.hpp>
#include <ExtCtrls.hpp>
#include <vector.h>

#include "Environment.h"
#include "TntExtCtrls.hpp"
#include "TntGrids.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
//---------------------------------------------------------------------------
class TErrorListForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntStringGrid *ErrorStringGrid;
	TTntPanel *Panel1;
	TTntPanel *Panel2;
	TTntButton *ExitButton;
	TTntButton *ReadButton;
	TTimer *ErrorReadTimer;
	void __fastcall ExitButtonClick(TObject *Sender);
	void __fastcall FormResize(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall ReadButtonClick(TObject *Sender);
	void __fastcall ErrorReadTimerTimer(TObject *Sender);
    void __fastcall FormDestroy(TObject *Sender);
private:	// User declarations
	int DataCount;
	vector<TErrorUnit> ErrorList;
	void __fastcall ResizeComponents(void);
    void __fastcall UpdateErrorList(void);
    void __fastcall SaveErrorList(void);
    bool __fastcall ReadError(void);

public:		// User declarations
	__fastcall TErrorListForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TErrorListForm *ErrorListForm;

extern AnsiString __fastcall BoardIDToStr(int boardID);
extern AnsiString __fastcall ErrorTypeToStr(int errorType);
extern AnsiString __fastcall ErrorCodeToStr(int errorCode);
extern WideString __fastcall ErrorUnitToMessage(TErrorUnit *errorUnit);
//---------------------------------------------------------------------------
#endif
