//---------------------------------------------------------------------------
// For SELMA200, 20180228, moon,  
//---------------------------------------------------------------------------


#pragma hdrstop

#include "FileContainer.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------

#pragma package(smart_init)

//---------------------------------------------------------------------------
__fastcall TFileContainer::TFileContainer()
{
	FMaxFileCount = 0;
	FContainerFileName = "";
	FCurrentFileIndex = 0;
	FFilePackHeaderList = NULL;
	EOFPosition = 0;
	FOpened = false;
}
//---------------------------------------------------------------------------
__fastcall TFileContainer::~TFileContainer()
{
	if (FFilePackHeaderList) delete[] FFilePackHeaderList;
}
//---------------------------------------------------------------------------
bool __fastcall TFileContainer::Create(AnsiString fileName, int maxFileCount)
{
	if (FOpened) Close();
	TFileStream *containerFileStream = new TFileStream(fileName, fmCreate);
	if (containerFileStream)
	{
		FMaxFileCount = maxFileCount;
		FCurrentFileIndex = 0;
		
		memset(&FFACFileHeader, 0, sizeof(TFACFileHeader));
		strcpy(FFACFileHeader.HeaderName, FAC_FILE_HEADER_NAME);
		FFACFileHeader.Version = FAC_FILE_HEADER_VERSION;
		FFACFileHeader.MaxFileCount = FMaxFileCount;
		FFACFileHeader.ContainFileCount = 0;
                          
	    if (FFilePackHeaderList) delete[] FFilePackHeaderList;       //cik add 20170329
		FFilePackHeaderList = new TFilePackHeader[FMaxFileCount];
		memset(FFilePackHeaderList, 0, FMaxFileCount * sizeof(TFilePackHeader));

		containerFileStream->Write(&FFACFileHeader, sizeof(TFACFileHeader));
		containerFileStream->Write(FFilePackHeaderList, FMaxFileCount * sizeof(TFilePackHeader));

		EOFPosition = sizeof(TFACFileHeader) + FMaxFileCount * sizeof(TFilePackHeader);
		FContainerFileName = fileName;
		delete containerFileStream;
		FOpened = true;
		return true;
	}
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------
bool __fastcall TFileContainer::Open(AnsiString fileName, bool bCanCreate, int maxFileCount)
{
	if (FOpened) Close();
	if (!FileExists(fileName))
	{
		if (bCanCreate)
		{
			return Create(fileName, maxFileCount);
		}
		else
		{
			return false;
		}
	}
	else
	{
		if (!ReadContainerDataFromFile(fileName))
		{
			return false;
		}
		else
		{
			FContainerFileName = fileName;
			FOpened = true;
		}
	}
	return true;
}
//---------------------------------------------------------------------------
void __fastcall TFileContainer::Close(void)
{
	if (FFilePackHeaderList) delete[] FFilePackHeaderList;
	FFilePackHeaderList = NULL;
	FOpened = false;
}
//---------------------------------------------------------------------------
bool __fastcall TFileContainer::ReadContainerDataFromFile(AnsiString fileName)
{
	TFileStream *containerFileStream = NULL;
	try
	{
		containerFileStream = new TFileStream(fileName, fmOpenRead);
		if (containerFileStream)
		{
			memset(&FFACFileHeader, 0, sizeof(TFACFileHeader));
			containerFileStream->Read(&FFACFileHeader, sizeof(TFACFileHeader));
			if (AnsiString(FFACFileHeader.HeaderName) != FAC_FILE_HEADER_NAME) throw Exception("File header does not match");
			if (FFACFileHeader.Version > FAC_FILE_HEADER_VERSION) throw Exception("File version is too high");
			FMaxFileCount = FFACFileHeader.MaxFileCount;
			FCurrentFileIndex = FFACFileHeader.ContainFileCount;

			if (FFilePackHeaderList) delete[] FFilePackHeaderList;
			FFilePackHeaderList = new TFilePackHeader[FMaxFileCount];
			memset(FFilePackHeaderList, 0, FMaxFileCount * sizeof(TFilePackHeader));
			containerFileStream->Read(FFilePackHeaderList, FMaxFileCount * sizeof(TFilePackHeader));
			EOFPosition = containerFileStream->Size;
			delete containerFileStream;
		}
	}
	catch (...)
	{
		if (containerFileStream) delete containerFileStream;
		if (FFilePackHeaderList) {delete[] FFilePackHeaderList; FFilePackHeaderList = NULL;}
		return false;
	}
	return true;
}
//---------------------------------------------------------------------------
bool __fastcall TFileContainer::AddFileToContainer(AnsiString storageFileName, AnsiString packFileName, ECompressMethod cm)
{
	if (!FOpened) return false;
	if (FCurrentFileIndex == FMaxFileCount) return false;

	TFileStream *containerFileStream = NULL;
	TFileStream *srcFileStream = NULL;
	unsigned char *srcData = NULL, *compData = NULL;
	try
	{
		containerFileStream = new TFileStream(FContainerFileName, fmOpenWrite);
		srcFileStream = new TFileStream(storageFileName, fmOpenRead);
		if (srcFileStream == NULL) throw (Exception("File can not read"));
		if (containerFileStream == NULL) throw (Exception("File can not write"));
		int srcFileSize = srcFileStream->Size;
		srcData = new unsigned char[srcFileSize];
		if (srcData == NULL) throw (Exception("Can Not Allocate Memory"));
		srcFileStream->Read(srcData, srcFileSize);
		compData = new unsigned char[srcFileSize];
		if (compData == NULL) throw (Exception("Can Not Allocate Memory"));
		int compDataLength;

		strncpy(FFilePackHeaderList[FCurrentFileIndex].FileName, packFileName.c_str(), FAC_MAX_FILE_NAME_LENGTH);

		FFilePackHeaderList[FCurrentFileIndex].DataKind = EDK_FILE;
		FFilePackHeaderList[FCurrentFileIndex].SourceLength = srcFileSize;
		if (cm == ECM_ZIP)
		{
			if (Compress(compData, &compDataLength, srcData, srcFileSize))
			{
				FFilePackHeaderList[FCurrentFileIndex].CompressedLength = compDataLength;
				FFilePackHeaderList[FCurrentFileIndex].StreamPosition = EOFPosition;
				FFilePackHeaderList[FCurrentFileIndex].CompressMethod = cm;
				containerFileStream->Seek(EOFPosition, soFromBeginning);
				containerFileStream->Write(compData, compDataLength);
				EOFPosition += compDataLength;
			}
			else
			{
				FFilePackHeaderList[FCurrentFileIndex].CompressedLength = srcFileSize;
				FFilePackHeaderList[FCurrentFileIndex].StreamPosition = EOFPosition;
				FFilePackHeaderList[FCurrentFileIndex].CompressMethod = ECM_NONE;
				containerFileStream->Seek(EOFPosition, soFromBeginning);
				containerFileStream->Write(srcData, srcFileSize);
				EOFPosition += srcFileSize;
			}
		}
		else
		{
			FFilePackHeaderList[FCurrentFileIndex].CompressedLength = srcFileSize;
			FFilePackHeaderList[FCurrentFileIndex].StreamPosition = EOFPosition;
			FFilePackHeaderList[FCurrentFileIndex].CompressMethod = ECM_NONE;
			containerFileStream->Seek(EOFPosition, soFromBeginning);
			containerFileStream->Write(srcData, srcFileSize);
			EOFPosition += srcFileSize;
		}
		FFACFileHeader.ContainFileCount++;
		containerFileStream->Seek(0, soFromBeginning);
		containerFileStream->Write(&FFACFileHeader, sizeof(TFACFileHeader));
		containerFileStream->Write(FFilePackHeaderList, FMaxFileCount * sizeof(TFilePackHeader));

		FCurrentFileIndex++;

		delete srcFileStream;
		delete containerFileStream;
		delete[] srcData;
		delete[] compData;
		return true;
	}
	catch (Exception &ec)
	{
		if (srcFileStream) delete srcFileStream;
		if (containerFileStream) delete containerFileStream;
		if (srcData) delete[] srcData;
		if (compData) delete[] compData;
		return false;
	}
}
//---------------------------------------------------------------------------
/*
bool __fastcall TFileContainer::SaveBitmapToContainer(AnsiString bitmapName, int bitsPerPixel, unsigned char *bitmapData, int width, int height, ECompressMethod cm)
{
	if (FileStream == NULL) return false;
	// search existing bitmap name
	bool bFileExists = false;
	int writingFileIndex = FCurrentFileIndex;
	for (int fileIndex = 0; fileIndex < FCurrentFileIndex; fileIndex++)
	{
		if (strncmp(FFilePackHeaderList[fileIndex].FileName, bitmapName.c_str(), FAC_MAX_FILE_NAME_LENGTH) == 0)
		{
			writingFileIndex = fileIndex;
			oldDataLength = FFilePackHeaderList[FCurrentFileIndex].CompressedLength;
			bFileExists = true;
			break;
		}
	}
	if (writingFileIndex == FMaxFileCount) return false;


	unsigned char *compData = NULL;
	bool bCompressed = false;
	try
	{
		int srcDataSize = width * height * bitsPerPixel / 8;
		compData = new unsigned char[srcDataSize];
		if (compData == NULL) throw (Exception("Cannot allocate memory"));
		int compDataLength = 0;

		strncpy(FFilePackHeaderList[writingFileIndex].FileName, bitmapName.c_str(), FAC_MAX_FILE_NAME_LENGTH);

		FFilePackHeaderList[writingFileIndex].SourceLength = srcDataSize;
		if (cm == ECM_ZIP)
		{
			if (Compress(compData, &compDataLength, bitmapData, srcDataSize))
			{
				bCompressed = true;

				FFilePackHeaderList[FCurrentFileIndex].CompressedLength = compDataLength;
				FFilePackHeaderList[FCurrentFileIndex].StreamPosition = EOFPosition;
				FFilePackHeaderList[FCurrentFileIndex].CompressMethod = cm;
				FileStream->Seek(EOFPosition, soFromBeginning);
				FileStream->Write(compData, compDataLength);
				EOFPosition += compDataLength;
			}
			else
			{
				FFilePackHeaderList[FCurrentFileIndex].CompressedLength = srcFileSize;
				FFilePackHeaderList[FCurrentFileIndex].StreamPosition = EOFPosition;
				FFilePackHeaderList[FCurrentFileIndex].CompressMethod = ECM_NONE;
				FileStream->Seek(EOFPosition, soFromBeginning);
				FileStream->Write(srcData, srcFileSize);
				EOFPosition += srcFileSize;
			}
		}
		else
		{
			FFilePackHeaderList[FCurrentFileIndex].CompressedLength = srcFileSize;
			FFilePackHeaderList[FCurrentFileIndex].StreamPosition = EOFPosition;
			FFilePackHeaderList[FCurrentFileIndex].CompressMethod = ECM_NONE;
			FileStream->Seek(EOFPosition, soFromBeginning);
			FileStream->Write(srcData, srcFileSize);
			EOFPosition += srcFileSize;
		}


		if (bFileExists)
		{
			int fileAddressShiftValue = compDataLength - oldDataLength;
			if (fileAddressShiftValue > 0)
			{
				for (int fileIndex = FCurrentFileIndex - 1; fileIndex >= writingFileIndex + 1; fileIndex--)
				{

				}
			}
		}



		FileStream->Seek(0, soFromBeginning);
		FFACFileHeader.ContainFileCount++;
		FileStream->Write(&FFACFileHeader, sizeof(TFACFileHeader));
		FileStream->Write(FFilePackHeaderList, FMaxFileCount * sizeof(TFilePackHeader));

		FCurrentFileIndex++;

		delete srcFileStream;
		delete[] srcData;
		delete[] compData;
		return true;
	}
	catch (Exception &ec)
	{
		if (srcFileStream) delete srcFileStream;
		if (srcData) delete[] srcData;
		if (compData) delete[] compData;
		return false;
	}













	TFileStream *srcFileStream = NULL;
	unsigned char *srcData = NULL, *compData = NULL;
	try
	{
		srcFileStream = new TFileStream(storageFileName, fmOpenRead);
		if (srcFileStream == NULL) throw (Exception("File cannot read"));
		int srcFileSize = srcFileStream->Size;
		srcData = new unsigned char[srcFileSize];
		if (srcData == NULL) throw (Exception("Cannot allocate memory"));
		srcFileStream->Read(srcData, srcFileSize);
		compData = new unsigned char[srcFileSize];
		if (compData == NULL) throw (Exception("Cannot allocate memory"));
		int compDataLength;

		strncpy(FFilePackHeaderList[FCurrentFileIndex].FileName, containerFileName.c_str(), FAC_MAX_FILE_NAME_LENGTH);

		FFilePackHeaderList[FCurrentFileIndex].SourceLength = srcFileSize;
		if (cm == ECM_ZIP)
		{
			if (Compress(compData, &compDataLength, srcData, srcFileSize))
			{
				FFilePackHeaderList[FCurrentFileIndex].CompressedLength = compDataLength;
				FFilePackHeaderList[FCurrentFileIndex].StreamPosition = EOFPosition;
				FFilePackHeaderList[FCurrentFileIndex].CompressMethod = cm;
				FileStream->Seek(EOFPosition, soFromBeginning);
				FileStream->Write(compData, compDataLength);
				EOFPosition += compDataLength;
			}
			else
			{
				FFilePackHeaderList[FCurrentFileIndex].CompressedLength = srcFileSize;
				FFilePackHeaderList[FCurrentFileIndex].StreamPosition = EOFPosition;
				FFilePackHeaderList[FCurrentFileIndex].CompressMethod = ECM_NONE;
				FileStream->Seek(EOFPosition, soFromBeginning);
				FileStream->Write(srcData, srcFileSize);
				EOFPosition += srcFileSize;
			}
		}
		else
		{
			FFilePackHeaderList[FCurrentFileIndex].CompressedLength = srcFileSize;
			FFilePackHeaderList[FCurrentFileIndex].StreamPosition = EOFPosition;
			FFilePackHeaderList[FCurrentFileIndex].CompressMethod = ECM_NONE;
			FileStream->Seek(EOFPosition, soFromBeginning);
			FileStream->Write(srcData, srcFileSize);
			EOFPosition += srcFileSize;
		}
		FileStream->Seek(0, soFromBeginning);
		FFACFileHeader.ContainFileCount++;
		FileStream->Write(&FFACFileHeader, sizeof(TFACFileHeader));
		FileStream->Write(FFilePackHeaderList, FMaxFileCount * sizeof(TFilePackHeader));

		FCurrentFileIndex++;

		delete srcFileStream;
		delete[] srcData;
		delete[] compData;
		return true;
	}
	catch (Exception &ec)
	{
		if (srcFileStream) delete srcFileStream;
		if (srcData) delete[] srcData;
		if (compData) delete[] compData;
		return false;
	}
}
//---------------------------------------------------------------------------
*/
bool __fastcall TFileContainer::FileContains(AnsiString fileName)
{
	if (!FOpened) return false;	// container file was not opened
	for (int fileIndex = 0; fileIndex < FFACFileHeader.ContainFileCount; fileIndex++)
	{
		if (AnsiString(FFilePackHeaderList[fileIndex].FileName) == fileName) return true;
	}
	return false;
}
//--------------------------------------------------------------------------
bool __fastcall TFileContainer::ExtractFile(AnsiString srcFileName, AnsiString destFileName)
{
	if (!FOpened) return false;	// container file was not opened
	int srcFileContainerIndex = -1;
	for (int fileIndex = 0; fileIndex < FFACFileHeader.ContainFileCount; fileIndex++)
	{
		if (AnsiString(FFilePackHeaderList[fileIndex].FileName) == srcFileName)
		{
			srcFileContainerIndex = fileIndex;
			break;
		}
	}
	if (srcFileContainerIndex == -1)
	{
		return false;
	}

	unsigned char *compData = NULL, *srcData = NULL;
	TFileStream *containerFileStream = NULL;
	TFileStream *destFileStream = NULL;
	try
	{
		compData = new unsigned char[FFilePackHeaderList[srcFileContainerIndex].CompressedLength];
		if (compData == NULL) throw (Exception("Can not allocate memory"));
		srcData = new unsigned char[FFilePackHeaderList[srcFileContainerIndex].SourceLength];
		if (srcData == NULL) throw (Exception("Can not allocate memory"));
		containerFileStream = new TFileStream(FContainerFileName, fmOpenRead);
		if (containerFileStream == NULL) throw (Exception("File can not read"));
		containerFileStream->Seek(FFilePackHeaderList[srcFileContainerIndex].StreamPosition, soFromBeginning);
		containerFileStream->Read(compData, FFilePackHeaderList[srcFileContainerIndex].CompressedLength);
		//if (FFilePackHeaderList[srcFileContainerIndex].CompressedLength < FFilePackHeaderList[srcFileContainerIndex].SourceLength)
		if (FFilePackHeaderList[srcFileContainerIndex].CompressMethod == ECM_ZIP)
		{
			DWORD srcLength = FFilePackHeaderList[srcFileContainerIndex].SourceLength;
			Uncompress(srcData, &srcLength, compData, FFilePackHeaderList[srcFileContainerIndex].CompressedLength);
		}
		else
		{
			memcpy(srcData, compData, FFilePackHeaderList[srcFileContainerIndex].SourceLength);
		}

		destFileStream = new TFileStream(destFileName, fmCreate);
		if (destFileStream)
		{
			destFileStream->Write(srcData, FFilePackHeaderList[srcFileContainerIndex].SourceLength);
		}
		else
		{
			throw (Exception("File can not create"));
		}

		delete containerFileStream;
		delete destFileStream;
		delete[] srcData;
		delete[] compData;
		return true;
	}
	catch (...)
	{
		if (containerFileStream) delete containerFileStream;
		if (destFileStream) delete destFileStream;
		if (srcData) delete[] srcData;
		if (compData) delete[] compData;
		return false;
	}
}
//--------------------------------------------------------------------------
int __fastcall TFileContainer::GetContainerIndex(AnsiString fileName)
{
	int containerIndex = -1;
	for (int fileIndex = 0; fileIndex < FFACFileHeader.ContainFileCount; fileIndex++)
	{
		if (AnsiString(FFilePackHeaderList[fileIndex].FileName) == fileName)
		{
			containerIndex = fileIndex;
			break;
		}
	}
	return containerIndex;
}
//--------------------------------------------------------------------------
bool __fastcall TFileContainer::ReadData(AnsiString srcFileName, unsigned char *data)
{
	if (!FOpened) return false;	// container file was not opened
	int srcFileContainerIndex = GetContainerIndex(srcFileName);
	if (srcFileContainerIndex < 0)
	{
		return false;
	}

	TFileStream *containerFileStream = NULL;
	try
	{
		containerFileStream = new TFileStream(FContainerFileName, fmOpenRead);
		if (containerFileStream == NULL) throw (Exception("File can not read"));
		containerFileStream->Seek(FFilePackHeaderList[srcFileContainerIndex].StreamPosition, soFromBeginning);
		containerFileStream->Read(data, FFilePackHeaderList[srcFileContainerIndex].CompressedLength);
		delete containerFileStream;
		return true;
	}
	catch (...)
	{
		if (containerFileStream) delete containerFileStream;
		return false;
	}
}
//--------------------------------------------------------------------------
bool __fastcall TFileContainer::ExtractData(AnsiString srcFileName, void *data, int maxDataLength)
{
	if (!FOpened) return false;	// container file was not opened
	int srcFileContainerIndex = GetContainerIndex(srcFileName);
	if (srcFileContainerIndex < 0)
	{
		return false;
	}

	unsigned char *compData = NULL;
	TFileStream *containerFileStream = NULL;
	try
	{
		containerFileStream = new TFileStream(FContainerFileName, fmOpenRead);
		if (containerFileStream == NULL) throw (Exception("File can not read"));
		if (FFilePackHeaderList[srcFileContainerIndex].DataKind == EDK_FILE)
		{
			compData = new unsigned char[FFilePackHeaderList[srcFileContainerIndex].CompressedLength];
			if (compData == NULL) throw (Exception("Can not allocate memory"));
			containerFileStream->Seek(FFilePackHeaderList[srcFileContainerIndex].StreamPosition, soFromBeginning);
			containerFileStream->Read(compData, FFilePackHeaderList[srcFileContainerIndex].CompressedLength);
		//if (FFilePackHeaderList[srcFileContainerIndex].CompressedLength < FFilePackHeaderList[srcFileContainerIndex].SourceLength)
			if (FFilePackHeaderList[srcFileContainerIndex].CompressMethod == ECM_ZIP)
			{
				DWORD srcLength = FFilePackHeaderList[srcFileContainerIndex].SourceLength;
				Uncompress(data, &srcLength, compData, FFilePackHeaderList[srcFileContainerIndex].CompressedLength);
			}
			else
			{
				memcpy(data, compData, FFilePackHeaderList[srcFileContainerIndex].SourceLength);
			}
		}
		else if (FFilePackHeaderList[srcFileContainerIndex].DataKind == EDK_BITMAP)
		{
			compData = new unsigned char[FFilePackHeaderList[srcFileContainerIndex].CompressedLength - sizeof(TBitmapHeader)];
			if (compData == NULL) throw (Exception("Can not allocate memory"));
			containerFileStream->Seek(FFilePackHeaderList[srcFileContainerIndex].StreamPosition + sizeof(TBitmapHeader), soFromBeginning);
			containerFileStream->Read(compData, FFilePackHeaderList[srcFileContainerIndex].CompressedLength - sizeof(TBitmapHeader));
			if (FFilePackHeaderList[srcFileContainerIndex].CompressMethod == ECM_ZIP)
			{
				DWORD srcLength = FFilePackHeaderList[srcFileContainerIndex].SourceLength;
				Uncompress(data, &srcLength, compData, FFilePackHeaderList[srcFileContainerIndex].CompressedLength - sizeof(TBitmapHeader));
			}
			else
			{
				memcpy(data, compData, FFilePackHeaderList[srcFileContainerIndex].SourceLength);
			}
		}
		else if (FFilePackHeaderList[srcFileContainerIndex].DataKind == EDK_DATA)
		{
			if (maxDataLength < FFilePackHeaderList[srcFileContainerIndex].SourceLength)
			{
				throw Exception("data size too large");
			}
			compData = new unsigned char[FFilePackHeaderList[srcFileContainerIndex].CompressedLength];
			if (compData == NULL) throw (Exception("Can not allocate memory"));
			containerFileStream->Seek(FFilePackHeaderList[srcFileContainerIndex].StreamPosition, soFromBeginning);
			containerFileStream->Read(compData, FFilePackHeaderList[srcFileContainerIndex].CompressedLength);
			if (FFilePackHeaderList[srcFileContainerIndex].CompressMethod == ECM_ZIP)
			{
				DWORD srcLength = FFilePackHeaderList[srcFileContainerIndex].SourceLength;
				Uncompress(data, &srcLength, compData, FFilePackHeaderList[srcFileContainerIndex].CompressedLength);
			}
			else
			{
				memcpy(data, compData, FFilePackHeaderList[srcFileContainerIndex].SourceLength);
			}
		}
		delete[] compData;
		delete containerFileStream;
		return true;
	}
	catch (...)
	{
		if (compData) delete[] compData;
		if (containerFileStream) delete containerFileStream;
		return false;
	}
}
//--------------------------------------------------------------------------
TFilePackHeader *__fastcall TFileContainer::GetFilePackHeader(AnsiString fileName)
{
	if (!FOpened) return NULL;	// container file was not opened
	int containerIndex = GetContainerIndex(fileName);
	if (containerIndex < 0)
	{
		return NULL;
	}
	else
	{
		return &FFilePackHeaderList[containerIndex];
	}
}
//--------------------------------------------------------------------------
TFilePackHeader *__fastcall TFileContainer::GetFilePackHeaderByIndex(int containerIndex)
{
	if (!FOpened) return NULL;	// container file was not opened
	if (containerIndex < 0)
	{
		return NULL;
	}
	else
	{
		return &FFilePackHeaderList[containerIndex];
	}
}
//--------------------------------------------------------------------------
bool __fastcall TFileContainer::GetBitmapHeader(TBitmapHeader *bitmapHeader, AnsiString fileName)
{
	if (!FOpened) return false;	// container file was not opened
	TFileStream *containerFileStream = NULL;

	int containerIndex = GetContainerIndex(fileName);
	if (containerIndex < 0)
	{
		return false;
	}
	else
	{
		if (FFilePackHeaderList[containerIndex].DataKind != EDK_BITMAP)
		{
			return false;
		}
		containerFileStream = new TFileStream(FContainerFileName, fmOpenRead);
		if (containerFileStream)
		{
			containerFileStream->Seek(FFilePackHeaderList[containerIndex].StreamPosition, soFromBeginning);
			containerFileStream->Read(bitmapHeader, sizeof(TBitmapHeader));
			delete containerFileStream;
			return true;
		}
		else
		{
			return false;
		}
	}
}
//--------------------------------------------------------------------------
bool __fastcall TFileContainer::MoveContainerData(TFileContainer *srcContainer, AnsiString fileName)
{
	if (!FOpened) return false;	// container file was not opened
	if (FCurrentFileIndex == FMaxFileCount) return false;
	TFilePackHeader *filePackHeader;
	filePackHeader = srcContainer->GetFilePackHeader(fileName);
	if (filePackHeader == NULL) return false;
	unsigned char *srcData = NULL;
	TFileStream *containerFileStream = NULL;
	try
	{
		containerFileStream = new TFileStream(FContainerFileName, fmOpenWrite);
		if (containerFileStream == NULL) throw (Exception("File can not write"));
		srcData = new unsigned char[filePackHeader->CompressedLength];
		if (!srcContainer->ReadData(fileName, srcData)) throw ("data cannot read");
		memcpy(&FFilePackHeaderList[FCurrentFileIndex], filePackHeader, sizeof(TFilePackHeader));
		FFilePackHeaderList[FCurrentFileIndex].StreamPosition = EOFPosition;
		containerFileStream->Seek(EOFPosition, soFromBeginning);
		containerFileStream->Write(srcData, filePackHeader->CompressedLength);
		EOFPosition += filePackHeader->CompressedLength;

		FFACFileHeader.ContainFileCount++;
		containerFileStream->Seek(0, soFromBeginning);
		containerFileStream->Write(&FFACFileHeader, sizeof(TFACFileHeader));
		containerFileStream->Write(FFilePackHeaderList, FMaxFileCount * sizeof(TFilePackHeader));

		FCurrentFileIndex++;
		delete containerFileStream;
		delete[] srcData;
	}
	catch (...)
	{
		if (srcData) delete[] srcData;
		if (containerFileStream) delete containerFileStream;
		return false;
	}
	return true;
}
//--------------------------------------------------------------------------
bool __fastcall TFileContainer::SaveData(AnsiString fileName, ECompressMethod cm, void *data, int dataLength)
{
	if (!FOpened) return false;	// container file was not opened
	if (FCurrentFileIndex == FMaxFileCount) return false;

	unsigned char *compData = NULL;
	TFileStream *containerFileStream = NULL;
	bool bCompressed = false;
	try
	{
		int srcDataSize = dataLength;
		compData = new unsigned char[srcDataSize];
		if (compData == NULL) throw (Exception("Can not allocate memory"));
		int compDataLength = 0;
		containerFileStream = new TFileStream(FContainerFileName, fmOpenWrite);
		if (containerFileStream == NULL) throw (Exception("File can not read"));

		strncpy(FFilePackHeaderList[FCurrentFileIndex].FileName, fileName.c_str(), FAC_MAX_FILE_NAME_LENGTH);

		FFilePackHeaderList[FCurrentFileIndex].DataKind = EDK_DATA;
		FFilePackHeaderList[FCurrentFileIndex].SourceLength = srcDataSize;
		FFilePackHeaderList[FCurrentFileIndex].StreamPosition = EOFPosition;

		if (cm == ECM_ZIP)
		{
			if (Compress(compData, &compDataLength, data, srcDataSize))
			{
				bCompressed = true;
				FFilePackHeaderList[FCurrentFileIndex].CompressedLength = sizeof(TBitmapHeader) + compDataLength;
				FFilePackHeaderList[FCurrentFileIndex].CompressMethod = ECM_ZIP;
				containerFileStream->Seek(EOFPosition, soFromBeginning);
				containerFileStream->Write(compData, compDataLength);
				EOFPosition += compDataLength;
			}
			else
			{
				FFilePackHeaderList[FCurrentFileIndex].CompressedLength = sizeof(TBitmapHeader) + srcDataSize;
				FFilePackHeaderList[FCurrentFileIndex].CompressMethod = ECM_NONE;
				containerFileStream->Seek(EOFPosition, soFromBeginning);
				containerFileStream->Write(data, srcDataSize);
				EOFPosition += srcDataSize;
			}
		}
		else
		{
			FFilePackHeaderList[FCurrentFileIndex].CompressedLength = sizeof(TBitmapHeader) + srcDataSize;
			FFilePackHeaderList[FCurrentFileIndex].CompressMethod = ECM_NONE;
			containerFileStream->Seek(EOFPosition, soFromBeginning);
			containerFileStream->Write(data, srcDataSize);
			EOFPosition += srcDataSize;
		}

		containerFileStream->Seek(0, soFromBeginning);
		FFACFileHeader.ContainFileCount++;
		containerFileStream->Write(&FFACFileHeader, sizeof(TFACFileHeader));
		containerFileStream->Write(FFilePackHeaderList, FMaxFileCount * sizeof(TFilePackHeader));

		FCurrentFileIndex++;
		delete[] compData;
		delete containerFileStream;
		return true;
	}
	catch (Exception &ec)
	{
		if (compData) delete[] compData;
		if (containerFileStream) delete containerFileStream;
		return false;
	}
}
//--------------------------------------------------------------------------
bool __fastcall TFileContainer::SaveBitmapData(AnsiString fileName, ECompressMethod cm,
	unsigned char *data, int width, int height, unsigned char bpp, unsigned char cameraIndex, EBitmapKind bitmapKind)
{
	if (!FOpened) return false;	// container file was not opened
	if (FCurrentFileIndex == FMaxFileCount) return false;

	unsigned char *compData = NULL;
	TFileStream *containerFileStream = NULL;
	bool bCompressed = false;
	try
	{
		int srcDataSize = width * height * bpp / 8;
		compData = new unsigned char[srcDataSize];
		if (compData == NULL) throw (Exception("Can not allocate memory"));
		int compDataLength = 0;
		containerFileStream = new TFileStream(FContainerFileName, fmOpenWrite);
		if (containerFileStream == NULL) throw (Exception("File can not read"));
		
		strncpy(FFilePackHeaderList[FCurrentFileIndex].FileName, fileName.c_str(), FAC_MAX_FILE_NAME_LENGTH);

		FFilePackHeaderList[FCurrentFileIndex].DataKind = EDK_BITMAP;
		FFilePackHeaderList[FCurrentFileIndex].SourceLength = srcDataSize;
		FFilePackHeaderList[FCurrentFileIndex].StreamPosition = EOFPosition;

		TBitmapHeader bitmapHeader;
		bitmapHeader.Rev = BITMAP_HEADER_REV;
		bitmapHeader.Width = width;
		bitmapHeader.Height = height;
		bitmapHeader.BitsPerPixel = bpp;
		bitmapHeader.CameraIndex = cameraIndex;
		bitmapHeader.BitmapKind = bitmapKind;
		if (cm == ECM_ZIP)
		{
			if (Compress(compData, &compDataLength, data, srcDataSize))
			{
				bCompressed = true;
				FFilePackHeaderList[FCurrentFileIndex].CompressedLength = sizeof(TBitmapHeader) + compDataLength;
				FFilePackHeaderList[FCurrentFileIndex].CompressMethod = ECM_ZIP;
				containerFileStream->Seek(EOFPosition, soFromBeginning);
				containerFileStream->Write(&bitmapHeader, sizeof(TBitmapHeader));
				containerFileStream->Write(compData, compDataLength);
				EOFPosition += compDataLength;
			}
			else
			{
				FFilePackHeaderList[FCurrentFileIndex].CompressedLength = sizeof(TBitmapHeader) + srcDataSize;
				FFilePackHeaderList[FCurrentFileIndex].CompressMethod = ECM_NONE;
				containerFileStream->Seek(EOFPosition, soFromBeginning);
				containerFileStream->Write(&bitmapHeader, sizeof(TBitmapHeader));
				containerFileStream->Write(data, srcDataSize);
				EOFPosition += srcDataSize;
			}
		}
		else
		{
			FFilePackHeaderList[FCurrentFileIndex].CompressedLength = sizeof(TBitmapHeader) + srcDataSize;
			FFilePackHeaderList[FCurrentFileIndex].CompressMethod = ECM_NONE;
			containerFileStream->Seek(EOFPosition, soFromBeginning);
			containerFileStream->Write(&bitmapHeader, sizeof(TBitmapHeader));
			containerFileStream->Write(data, srcDataSize);
			EOFPosition += srcDataSize;
		}

		containerFileStream->Seek(0, soFromBeginning);
		FFACFileHeader.ContainFileCount++;
		containerFileStream->Write(&FFACFileHeader, sizeof(TFACFileHeader));
		containerFileStream->Write(FFilePackHeaderList, FMaxFileCount * sizeof(TFilePackHeader));

		FCurrentFileIndex++;
		delete[] compData;
		delete containerFileStream;
		return true;
	}
	catch (Exception &ec)
	{
		if (compData) delete[] compData;
		if (containerFileStream) delete containerFileStream;
		return false;
	}
}
//--------------------------------------------------------------------------
int __fastcall TFileContainer::GetContainFileCount(void)
{
	if (!FOpened) return 0;
	return FCurrentFileIndex;
}
//--------------------------------------------------------------------------
bool __fastcall TFileContainer::RemoveFromLast(int removeCount)
{
	if (!FOpened) return false;	// container file was not opened
	if (removeCount == 0) return true;

	TFileStream *containerFileStream = NULL;
	try
	{
		containerFileStream = new TFileStream(FContainerFileName, fmOpenWrite);
		if (containerFileStream == NULL) throw (Exception("File can not read"));


		int newEOFPosition = 0;
		if (FCurrentFileIndex - removeCount > 0)
		{
			newEOFPosition = FFilePackHeaderList[FCurrentFileIndex - removeCount].StreamPosition;
		}

		int currentHeaderIndex = FCurrentFileIndex - 1;

		for (int removeIndex = 0; removeIndex < removeCount; removeIndex++)
		{
			if (currentHeaderIndex < 0) break;
			memset(&FFilePackHeaderList[currentHeaderIndex], 0, sizeof(TFilePackHeader));
			currentHeaderIndex--;
		}

		FCurrentFileIndex -= removeCount;
		if (FCurrentFileIndex <= 0)
		{
			FCurrentFileIndex = 0;
		}

		EOFPosition = newEOFPosition;

		containerFileStream->Size = EOFPosition;
		containerFileStream->Seek(0, soFromBeginning);
		FFACFileHeader.ContainFileCount = FCurrentFileIndex;
		containerFileStream->Write(&FFACFileHeader, sizeof(TFACFileHeader));
		containerFileStream->Write(FFilePackHeaderList, FMaxFileCount * sizeof(TFilePackHeader));

		delete containerFileStream;
		return true;
	}
	catch (Exception &ec)
	{
		if (containerFileStream) delete containerFileStream;
		return false;
	}
}
//---------------------------------------------------------------------------
typedef int WINAPI (*TZLibCompress)(void *dest, DWORD *destLen, const void *source, DWORD sourceLen);
typedef int WINAPI (*TZLibUncompress)(void *dest, DWORD *destLen, const void *source, DWORD sourceLen);
//---------------------------------------------------------------------------
bool __fastcall Compress(void *dst, int *compLength, void *src, int length)
{
	DWORD dwWrite;
	HINSTANCE hLibrary = NULL;
	TZLibCompress ZLibCompress;
	DWORD sourceLength, destLength;
	int retComp;
	bool returnValue = true;
	try
	{
		destLength = sourceLength = length;
		hLibrary = LoadLibraryA("zlib.dll");
		if (hLibrary)
		{
			ZLibCompress = (TZLibCompress)GetProcAddress(hLibrary, "compress");
			if (ZLibCompress)
			{
				retComp = ZLibCompress(dst, &destLength, src, sourceLength);
				if (retComp == 0)
				{
					*compLength = destLength;
				}
				else
				{
					memcpy(dst, src, sourceLength);
					*compLength = sourceLength;
				}
			}
			else
			{
				memcpy(dst, src, sourceLength);
				*compLength = sourceLength;
			}
			FreeLibrary(hLibrary); hLibrary = NULL;
		}
		else
		{
			memcpy(dst, src, sourceLength);
			*compLength = sourceLength;
		}
	}
	catch (...)
	{
		if (hLibrary)
		{
			FreeLibrary(hLibrary);
		}
		returnValue = false;
	}
	return returnValue;
}
//--------------------------------------------------------------------------
bool __fastcall Uncompress(void *dest, DWORD *destLength, void *src, int srcLength)
{
	HINSTANCE hLibrary = NULL;
	TZLibUncompress ZLibUncompress;
	bool returnValue = true;
	try
	{
		if (srcLength < *destLength)	// compressed
		{
			hLibrary = LoadLibraryA("zlib.dll");
			if (hLibrary == NULL)
			{
				throw Exception ("Can not load library");
			}
			ZLibUncompress = (TZLibUncompress)GetProcAddress(hLibrary, "uncompress");
			if (ZLibUncompress == NULL)
			{
				throw Exception ("Can not load library");
			}
			ZLibUncompress(dest, destLength, src, srcLength);
			FreeLibrary(hLibrary);
		}
		else
		{
			memcpy(dest, src, *destLength);
		}
	}
	catch (Exception &ec)
	{
		if (hLibrary) FreeLibrary(hLibrary);
		returnValue = false;
	}
	catch (...)
	{
		if (hLibrary) FreeLibrary(hLibrary);
		returnValue = false;
	}
	return returnValue;
}
//---------------------------------------------------------------------------
bool __fastcall SaveBitmapData(AnsiString fileName, unsigned char *data, int width, int height, int bpp, EBitmapKind bitmapKind)
{
	TFileStream *saveFileStream = new TFileStream(fileName, fmCreate);
	if (saveFileStream)
	{
		TBitmapHeader header;
		header.Rev = BITMAP_HEADER_REV;
		header.Width = width;
		header.Height = height;
		header.BitsPerPixel = bpp;
		header.BitmapKind = bitmapKind;
//		saveFileStream->Write(&header, sizeof(TBitmapHeader));
		saveFileStream->Write(data, width * height * bpp / 8);

		delete saveFileStream;
		return true;
	}
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------


