//---------------------------------------------------------------------------

#ifndef FileContainerH
#define FileContainerH

#include <vcl.h>
//---------------------------------------------------------------------------
#define FAC_FILE_HEADER_NAME		"FA Electronics Package File"
#define FAC_FILE_HEADER_VERSION		100
#define FAC_MAX_FILE_NAME_LENGTH	128
//---------------------------------------------------------------------------
typedef enum {ECM_NONE, ECM_ZIP} ECompressMethod;
typedef enum {EDK_FILE, EDK_BITMAP, EDK_DATA} EDataKind;
typedef enum {EBK_2D, EBK_3D} EBitmapKind;
//---------------------------------------------------------------------------
typedef struct
{
	char HeaderName[32];
	unsigned int Version;
	unsigned int MaxFileCount;
	unsigned int ContainFileCount;
}
TFACFileHeader;

typedef struct
{
	char FileName[FAC_MAX_FILE_NAME_LENGTH];
	unsigned char DataKind;
	unsigned char reserved1[3];
	int CompressMethod;
	int SourceLength;
	int CompressedLength;
	int StreamPosition;
	int reserved2[3];
} TFilePackHeader;

#define BITMAP_HEADER_REV		100
typedef struct
{
	int Rev;
	unsigned char BitsPerPixel;
	unsigned char CameraIndex;
	unsigned char BitmapKind;
	unsigned char reserved1[1];
	int Width;
	int Height;
} TBitmapHeader;

//---------------------------------------------------------------------------
class TFileContainer
{
private:
//	TFileStream *FileStream;
	bool FOpened;
	int EOFPosition;
	int FMaxFileCount;
	int FCurrentFileIndex;
	AnsiString FContainerFileName;
	TFACFileHeader FFACFileHeader;
	TFilePackHeader *FFilePackHeaderList;
private:
	int __fastcall GetContainerIndex(AnsiString fileName);
public:
	__fastcall TFileContainer();
	__fastcall ~TFileContainer();
	bool __fastcall Create(AnsiString fileName, int maxFileCount);
	bool __fastcall Open(AnsiString fileName, bool bCanCreate = false, int maxFileCount = 0);
	void __fastcall Close(void);
	bool __fastcall ReadContainerDataFromFile(AnsiString fileName);
	bool __fastcall AddFileToContainer(AnsiString storageFileName, AnsiString packFileName, ECompressMethod cm);
//	bool __fastcall SaveBitmapToContainer(AnsiString bitmapName, int bitsPerPixel, unsigned char *bitmapData, int width, int height, ECompressMethod cm);
	bool __fastcall SaveData(AnsiString fileName, ECompressMethod cm, void *data, int dataLength);
	bool __fastcall SaveBitmapData(AnsiString fileName, ECompressMethod cm, unsigned char *data, int width, int height, unsigned char bpp, unsigned char cameraIndex, EBitmapKind bitmapKind = EBK_2D);
	bool __fastcall FileContains(AnsiString fileName);
	bool __fastcall ExtractFile(AnsiString srcFileName, AnsiString destFileName);
	bool __fastcall ReadData(AnsiString srcFileName, unsigned char *data);
	bool __fastcall ExtractData(AnsiString srcFileName, void *data, int maxDataLength = 0);
	TFilePackHeader *__fastcall GetFilePackHeader(AnsiString fileName);
	TFilePackHeader *__fastcall GetFilePackHeaderByIndex(int containerIndex);
	bool __fastcall GetBitmapHeader(TBitmapHeader *bitmapHeader, AnsiString fileName);
	bool __fastcall MoveContainerData(TFileContainer *srcContainer, AnsiString fileName);
	int __fastcall GetContainFileCount(void);
	bool __fastcall RemoveFromLast(int removeCount);
};


//---------------------------------------------------------------------------
bool __fastcall Compress(void *dst, int *compLength, void *src, int length);
bool __fastcall Uncompress(void *dest, DWORD *destLength, void *src, int srcLength);

bool __fastcall SaveBitmapData(AnsiString fileName, unsigned char *data, int width, int height, int bpp);
#endif
