#include <vcl.h>
#pragma hdrstop

#include "GradeSetting.h"
#include "stdlib.h"
#include "Environment.h"
#include "MultiLanguage.h"
#include "ThreeDPrintMask_Form.h"
#include "InspectionAreaRevision_Form.h"
#include "PreviewInspection_Form.h"
#include "Keyboard_Form.h"
#include "math.h"
#include "TabletCharacterExtract.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntComCtrls"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TGradeSettingForm *GradeSettingForm;
//---------------------------------------------------------------------------
__fastcall TGradeSettingForm::TGradeSettingForm(TComponent* Owner)
	: TTntForm(Owner)
{
	if (DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
		ComponentSetFontName(this, "SimSun");
	else if (DefaultLCID == 1041)
		ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

	GetDefaultString();

	if (ProductData.EngraveType == ENGRAVE_TYPE_PRINT)
	{
		GradeButton14->Visible = true;
		Panel13->Visible = true;

		GradeBtnForMarvelTablet6->Visible = true;
		TntPanel21->Visible = true;

		TntPanel24->Visible = false;
	}
	else
	{
		GradeButton14->Visible = false;
		Panel13->Visible = false;

		GradeBtnForMarvelTablet6->Visible = false;
		TntPanel21->Visible = false;

		TntPanel24->Visible = true;
	}

  if(ProductData.EngraveType == ENGRAVE_TYPE_INTAGLIO)
  {
    StampErrorSettingOptionButton->Visible = true;
  }
  else
  {
    StampErrorSettingOptionButton->Visible = false;
  }

  Apply2DEngraveMatchingOption_LimitRange->Visible = false;
  if(ProductData.EngraveType == ENGRAVE_TYPE_INTAGLIO && ProductData.TabletShape == TABLET_SHAPE_ETC)
  {
    if(ProductData.Arrange == false && ProductData.SymmetricLineCount == 3) // ľȵǴ Ÿ 
    {
      Apply2DEngraveMatchingOption_LimitRange->Visible = true;
    }
  }

  Apply2DEngraveMatchingOption_LightEngrave->Visible = false;
  /*if(ProductData.EngraveType == ENGRAVE_TYPE_INTAGLIO && ProductData.EngravePos == ENGRAVE_POS_DIFF) //  δٸ  
  {
    if(ProductData.TabletShape == TABLET_SHAPE_ETC && ProductData.Arrange == false && ProductData.SymmetricLineCount == 3)
    {
      Apply2DEngraveMatchingOption_LightEngrave->Visible = true;
    }
    else if(ProductData.TabletShape == TABLET_SHAPE_CIRCLE || ProductData.TabletShape == TABLET_SHAPE_SQUARE || ProductData.TabletShape == TABLET_SHAPE_HEXAGON || ProductData.TabletShape == TABLET_SHAPE_TRIANGLE)
    {
      Apply2DEngraveMatchingOption_LightEngrave->Visible = true;
    } 
  }*/
  if(ProductData.EngraveType == ENGRAVE_TYPE_INTAGLIO)
  {
	Apply2DEngraveMatchingOption_LightEngrave->Visible = true;	
  }

  Apply3DShapeCheck->Visible = false;
  if (ProductData.TabletType == TABLET_TYPE_SUGAR_COATED)
  {
    Apply3DShapeCheck->Visible = true;
  }

	if ((ProductData.EngraveType == ENGRAVE_TYPE_INTAGLIO && (ProductData.EngravePos == ENGRAVE_POS_ONESIDE || ProductData.EngravePos == ENGRAVE_POS_SAME)) || ProductData.EngraveType == ENGRAVE_TYPE_PRINT)
	{
		TntGroupBox1->Visible = true;
	}
	else
	{
		TntGroupBox1->Visible = false;
	}

	if (ProductData.TabletType == TABLET_TYPE_SUGAR_COATED)
	{
		/*
		TntLabel10->Visible = true;
		TntLabel11->Visible = true;

		TntScrollBar1->Visible = true;
		TntPanel7->Visible = true;
		*/

		TntLabel10->Visible = false;
		TntLabel11->Visible = false;

		TntScrollBar1->Visible = false;
		TntPanel7->Visible = false;
	}
	else
	{
		TntLabel10->Visible = false;
		TntLabel11->Visible = false;

		TntScrollBar1->Visible = false;
		TntPanel7->Visible = false;
	}

	if (ProductData.TabletLayerCount < 2)
	{
		TntLabel22->Visible = false;
		TntLabel23->Visible = false;
		TntScrollBar4->Visible = false;
		TntPanel5->Visible = false;
	}

	if (ProductData.MarvelingTabletSW)
	{
		FrontFaceGradeGroupBoxForMarvelingTablet->Visible = true;
		FrontFaceGradeGroupBox->Visible = false;

		TntGroupBox2->Visible = false;
		ColorDirtyControlBtn->Visible = false;

    //EnforcementStainDefectCheckAlgorithmCheckBox->Visible = true;
	}
	else
	{
		FrontFaceGradeGroupBoxForMarvelingTablet->Visible = false;
		FrontFaceGradeGroupBox->Visible = true;

		TntGroupBox2->Visible = true;
		ColorDirtyControlBtn->Visible = true;

    //EnforcementStainDefectCheckAlgorithmCheckBox->Visible = false;
	}

  // 21/07/13
  //    ҷ  ȭ  Ұ· 
  EnforcementStainDefectCheckAlgorithmCheckBox->Visible = false;
  // end

  if(ProductData.SubSamplingMode == IMAGE_FULL_SCALE_MODE)
  {
    TntGroupBox2->Visible = false;
  }

  if(ProductData.TabletType == TABLET_TYPE_SUGAR_COATED)
  {
    TntGroupBox2->Visible = false;
	  ColorDirtyControlBtn->Visible = false;
    TntPanel14->Visible = true;
  }
  else
  {
    TntPanel14->Visible = false;
  }

  bUserMakingGradeData = false;

  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
  {
    TntLabel34->Height = TntPanel27->Height;
    TntLabel42->Height = TntPanel27->Height;
    TntLabel14->Height = TntPanel27->Height;

    TntLabel34->Alignment = taCenter;
    TntLabel42->Alignment = taCenter;
    TntLabel14->Alignment = taCenter;

    TntLabel34->Layout = tlCenter;
    TntLabel42->Layout = tlCenter;
    TntLabel14->Layout = tlCenter;

    TntLabel34->Font->Size = 12;
    TntLabel42->Font->Size = 12;
    TntLabel14->Font->Size = 12;

    TntLabel35->Visible = false;
    TntLabel43->Visible = false;
    TntLabel17->Visible = false;
  }
#ifdef PC_SIM
  ShowHintByName(this);
#endif

}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::GetDefaultString()
{
	GradeButton2->Caption = GRADESETTING_BITBTN_CAPTION_01;
	BitBtn8->Caption = GRADESETTING_BITBTN_CAPTION_02;
	GradeButton1->Caption = GRADESETTING_BITBTN_CAPTION_03;
	BitBtn10->Caption = GRADESETTING_BITBTN_CAPTION_04;
	GradeButton16->Caption = GRADESETTING_BITBTN_CAPTION_05;
	BitBtn9->Caption = GRADESETTING_BITBTN_CAPTION_06;
	BitBtn2->Caption = GRADESETTING_BITBTN_CAPTION_07;
	BitBtn1->Caption = GRADESETTING_BITBTN_CAPTION_08;
	GradeButton12->Caption = GRADESETTING_BUTTON_CAPTION_01;
  
	GradeButton15->Caption = GRADESETTING_BUTTON_CAPTION_02;
	GradeButton7->Caption = GRADESETTING_BUTTON_CAPTION_03;
	GradeButton6->Caption = GRADESETTING_BUTTON_CAPTION_04;
  GradeButton32->Caption = GRADESETTING_TEXT_CAPTION_11;
	GradeButton14->Caption = GRADESETTING_BUTTON_CAPTION_05;
	GradeButton8->Caption = GRADESETTING_BUTTON_CAPTION_07;
	CheckBox2->Caption = GRADESETTING_CHECKBOX_CAPTION_01;
	GroupBox10->Caption = GRADESETTING_GROUPBOX_CAPTION_02;
	GroupBox11->Caption = GRADESETTING_GROUPBOX_CAPTION_03;
	GroupBox4->Caption = GRADESETTING_GROUPBOX_CAPTION_04;
	GroupBox15->Caption = GRADESETTING_GROUPBOX_CAPTION_05;
	GroupBox9->Caption = GRADESETTING_GROUPBOX_CAPTION_06;

	TntStaticText3->Caption = "Brightness Difference";
	if (ProductData.EngraveType == ENGRAVE_TYPE_PRINT)
	{
		GroupBox7->Caption = GRADESETTING_GROUPBOX_CAPTION_08;
		GradeButton13->Caption = GRADESETTING_BUTTON_CAPTION_06;
		GradeButton14->Caption = GRADESETTING_BUTTON_CAPTION_05;

		TntGroupBox7->Caption = GRADESETTING_GROUPBOX_CAPTION_08;
		GradeBtnForMarvelTablet5->Caption = GRADESETTING_BUTTON_CAPTION_06;
		GradeBtnForMarvelTablet6->Caption = GRADESETTING_BUTTON_CAPTION_05;
	}
	else
	{
		GroupBox7->Caption = NEW_ADD_STRING_08;
		GradeButton13->Caption = NEW_ADD_STRING_09;
		GradeButton14->Caption = NEW_ADD_STRING_10;

		TntGroupBox7->Caption = NEW_ADD_STRING_08;
		GradeBtnForMarvelTablet5->Caption = NEW_ADD_STRING_09;
		GradeBtnForMarvelTablet6->Caption = NEW_ADD_STRING_10;
	}
	StaticText7->Caption = NEW_ADD_STRING_18;
	GroupBox13->Caption = GRADESETTING_GROUPBOX_CAPTION_09;
	GroupBox14->Caption = GRADESETTING_GROUPBOX_CAPTION_11;
	GradeButton9->Caption = GRADESETTING_GROUPBOX_CAPTION_12;
	Label31->Caption = GRADESETTING_LABEL_CAPTION_01;
	Label54->Caption = GRADESETTING_LABEL_CAPTION_02;
	StaticText3->Caption = GRADESETTING_TEXT_CAPTION_01;
	StaticText5->Caption = GRADESETTING_TEXT_CAPTION_02;
	StaticText1->Caption = GRADESETTING_TEXT_CAPTION_03;
	StaticText2->Caption = GRADESETTING_TEXT_CAPTION_07;
	TntStaticText39->Caption = GRADESETTING_TEXT_CAPTION_20;
	TntStaticText41->Caption = GRADESETTING_TEXT_CAPTION_07;  

	GradeButton4->Caption = GRADESETTING_BITBTN_CAPTION_02;
	GradeButton3->Caption = GRADESETTING_BITBTN_CAPTION_03;
	GradeButton5->Caption = GRADESETTING_BITBTN_CAPTION_02;
	GradeButton11->Caption = GRADESETTINGUSER_GROUPBOX_CAPTION_05;
	StaticText6->Caption = GRADESETTING_TEXT_CAPTION_07;

	GroupBox12->Caption = GRADESETTINGUSER_GROUPBOX_CAPTION_01;
	BitBtn3->Caption = GRADESETTINGUSER_GROUPBOX_CAPTION_01;
	GradeButton28->Caption = GRADESETTING_BITBTN_CAPTION_06;

	Label38->Caption = GRADESETTING_LABEL_CAPTION_02;

	Label46->Caption = GRADESETTING_LABEL_CAPTION_02;
	Label44->Caption = GRADESETTING_LABEL_CAPTION_01;
	BitBtn4->Caption = GRADESETTING_BITBTN_CAPTION_03;
	BitBtn7->Caption = GRADESETTING_BITBTN_CAPTION_03;
	BitBtn5->Caption = GRADESETTING_BITBTN_CAPTION_01;
	BitBtn6->Caption = GRADESETTING_BITBTN_CAPTION_02;

	GradeButton29->Caption = NEW_ADD_STRING_16;
	GradeButton30->Caption = NEW_ADD_STRING_74;

  GradeButton31->Caption = NEW_ADD_STRING_81;

	TntStaticText8->Caption = GRADESETTING_TEXT_CAPTION_07;

	//ID, ӽ
	GroupBox6->Caption = INSPECTIONFORM_PANEL_CAPTION_45;
	GroupBox5->Caption = DEFECTINFOFORM_PANEL_CAPTION_15;

	TntStaticText2->Caption = GRADESETTING_TEXT_CAPTION_06;
	TntStaticText1->Caption = NEW_ADD_STRING_11;

	TntGroupBox1->Caption = NEW_ADD_STRING_38;
	TntLabel4->Caption = NEW_ADD_STRING_39;
	TntLabel5->Caption = NEW_ADD_STRING_40;
	TntLabel6->Caption = NEW_ADD_STRING_41;
	TntLabel7->Caption = NEW_ADD_STRING_40;

	UnPrintDefectCheckBox->Caption = NEW_ADD_STRING_33;

	TntGroupBox2->Caption = NEW_ADD_STRING_42;
	GradeSensitivityPanel1->Caption = NEW_ADD_STRING_43;
	GradeSensitivityPanel2->Caption = NEW_ADD_STRING_44;

	ColorDefectPassAlgorithmCB->Caption = NEW_ADD_STRING_48;
	ColoDefectOptionGB->Caption = NEW_ADD_STRING_49;
	Label68->Caption = NEW_ADD_STRING_50;
	Label69->Caption = NEW_ADD_STRING_51;
	Label71->Caption = NEW_ADD_STRING_56;

	EraseThreeDEngraveBtn->Caption = GRADESETTING_ETC_CAPTION_06;
	CheckBox3->Caption = GRADESETTING_ETC_CAPTION_07;
	CheckBox5->Caption = GRADESETTING_ETC_CAPTION_08;

	CheckBox7->Caption = GRADESETTING_ETC_CAPTION_11;
	Button3->Caption = TABLETCHARACTEREXTRACTFORM_BITBTN_CAPTION_23;

	ColorDirtyControlBtn->Caption = NEW_ADD_STRING_48;
	TntLabel23->Caption = GRADESETTING_ETC_CAPTION_20;

	CheckBox8->Caption = GRADESETTING_ETC_CAPTION_27;

	TntGroupBox9->Caption = GRADESETTING_ETC_CAPTION_28;
	TntGroupBox10->Caption = GRADESETTING_ETC_CAPTION_30;

	TntGroupBox5->Caption = DEFECTINFOFORM_PANEL_CAPTION_15;
	TntGroupBox4->Caption = INSPECTIONFORM_PANEL_CAPTION_45;
	GradeBtnForMarvelTablet1->Caption = GRADESETTING_BITBTN_CAPTION_03;
	GradeBtnForMarvelTablet2->Caption = GRADESETTING_BITBTN_CAPTION_01;
	GradeBtnForMarvelTablet3->Caption = GRADESETTING_BITBTN_CAPTION_03;
	GradeButton3->Caption = GRADESETTING_BITBTN_CAPTION_03;
	TntGroupBox8->Caption = GRADESETTING_GROUPBOX_CAPTION_03;
	GradeBtnForMarvelTablet7->Caption = GRADESETTINGUSER_GROUPBOX_CAPTION_05;

	TntStaticText14->Caption = GRADESETTING_TEXT_CAPTION_07;
	TntStaticText11->Caption = GRADESETTING_TEXT_CAPTION_07;

	Panel38->Caption = GRADESETTING_ETC_CAPTION_31;
	Panel36->Caption = GRADESETTING_ETC_CAPTION_32;
	TntStaticText10->Caption = GRADESETTING_ETC_CAPTION_33;
	TntStaticText13->Caption = GRADESETTING_ETC_CAPTION_33;

	TntStaticText20->Caption = GRADESETTING_ETC_CAPTION_33;
	TntStaticText21->Caption = GRADESETTING_TEXT_CAPTION_07;

	InspectionAreaSettingBtn->Caption = CALIBRATIONFORM_BUTTON_CAPTION_03;

	WhiteEngraveMatchingCheckBox->Caption = GRADESETTING_ETC_CAPTION_35;
	DirtyDefectCheckInNeighborPrintCheckBox->Caption = GRADESETTING_ETC_CAPTION_36;
  
	SpecialFunctionCheckBox->Caption = GRADESETTING_ETC_CAPTION_37;

  SideBreakGradeGroupBox->Caption = NEW_ADD_STRING_67;
	GroupBox1->Caption = NEW_ADD_STRING_67;
	GroupBox16->Caption = NEW_ADD_STRING_68;
	TntLabel34->Caption = NEW_ADD_STRING_69;
	TntLabel35->Caption = NEW_ADD_STRING_71;
	TntLabel42->Caption = NEW_ADD_STRING_70;
	TntLabel43->Caption = NEW_ADD_STRING_71;
	TntLabel30->Caption = NEW_ADD_STRING_73;
  TntLabel17->Caption = NEW_ADD_STRING_71;
  TntLabel14->Caption = NEW_ADD_STRING_72;

  TntLabel35->Caption = NEW_ADD_STRING_71;
	TntLabel43->Caption = NEW_ADD_STRING_71;
  TntLabel17->Caption = NEW_ADD_STRING_71;

	TntStaticText3->Caption = NEW_ADD_STRING_75;
	TntStaticText4->Caption = NEW_ADD_STRING_76;
	TntStaticText16->Caption = NEW_ADD_STRING_77;
	TntStaticText17->Caption = NEW_ADD_STRING_78;

	CheckBox6->Caption = GRADESETTING_ETC_CAPTION_09;
	SideEdgeColorNoneInspectionCheckBox->Caption = GRADESETTING_ETC_CAPTION_55;  

  SideBreakMinDepthSettingGroupBox->Caption = NEW_ADD_STRING_82;
  DepthSettingLabel1->Caption = NEW_ADD_STRING_83;
  DepthSettingLabel2->Caption = NEW_ADD_STRING_84;
  
  NoneHorizontalityTabletCheckBox->Caption = GRADESETTING_ETC_CAPTION_38;
  SplitLineUnInspectionAreaSettingCheckBox->Caption = GRADESETTING_ETC_CAPTION_39;
  SideRemovalAlgorithm3DCheckBox->Caption = "3D   ˰  ";
  TntStaticText23->Caption = GRADESETTING_ETC_CAPTION_41;
  TntStaticText24->Caption = GRADESETTING_ETC_CAPTION_42;

  EngraveWhiteDefectCheckBox->Caption = GRADESETTING_ETC_CAPTION_43;
  TntLabel29->Caption = GRADESETTING_ETC_CAPTION_44;

  FrontFaceSplitLineRecognizationBtn->Caption = GRADESETTING_TEXT_CAPTION_08;
  FrontFaceSplitLineOptionCheckBox->Caption = GRADESETTING_TEXT_CAPTION_09;
  Label28->Caption = GRADESETTING_TEXT_CAPTION_10;
  Button1->Caption = TABLETCHARACTEREXTRACTFORM_BITBTN_CAPTION_23;
  Button2->Caption = TABLETCHARACTEREXTRACTFORM_BITBTN_CAPTION_23;

  TntStaticText33->Caption = GRADESETTING_TEXT_CAPTION_12;
  TntLabel20->Caption = GRADESETTING_TEXT_CAPTION_13;
  TntLabel25->Caption = GRADESETTING_TEXT_CAPTION_14;

  TntStaticText6->Caption = GRADESETTING_TEXT_CAPTION_15;

  Apply3DShapeCheck->Caption = GRADESETTING_TEXT_CAPTION_16;
  GradeButton33->Caption = GRADESETTING_TEXT_CAPTION_17;

  if(DefaultLCID != 1042)
  {
    EnforcementStainDefectCheckAlgorithmCheckBox->Caption = "Test Function";
    Apply2DEngraveMatchingOption_LimitRange->Caption = "Test Function";
    Apply2DEngraveMatchingOption_LightEngrave->Caption = "Test Function";
  }

  GroupBox2->Caption = GRADESETTING_GROUPBOX_CAPTION_10;
  if(GlobalProgramID == PROGRAM_ID_200)
  {
    FrontFaceGradeGroupBox->Caption = GRADESETTING_GROUPBOX_CAPTION_07;
	  FrontFaceGradeGroupBoxForMarvelingTablet->Caption = GRADESETTING_GROUPBOX_CAPTION_07;
    GroupBox3->Caption = GRADESETTING_GROUPBOX_CAPTION_01;
  }
  else
  {
    FrontFaceGradeGroupBox->Caption = GRADESETTING_TEXT_CAPTION_18;
	  FrontFaceGradeGroupBoxForMarvelingTablet->Caption = GRADESETTING_TEXT_CAPTION_18;
    GroupBox3->Caption = GRADESETTING_TEXT_CAPTION_19;
  }

  TntStaticText34->Caption = GRADESETTING_ETC_CAPTION_45;
  TntStaticText35->Caption = GRADESETTING_ETC_CAPTION_46;

  TntStaticText37->Caption = GRADESETTING_ETC_CAPTION_47;

  TntStaticText36->Caption = NEW_ADD_STRING_11;
  TntStaticText38->Caption = GRADESETTING_TEXT_CAPTION_07;
  TntSpeedButton5->Caption = TABLETCHARACTEREXTRACTFORM_BITBTN_CAPTION_14;

  SideEdgeDirtyGradeSettingButton->Caption = GRADESETTING_ETC_CAPTION_48;
  SideEdgeDirtyCheckBox->Caption = GRADESETTING_ETC_CAPTION_49;
  TntGroupBox3->Caption = INSPECTIONFORM_BUTTON_CAPTION_05;
  Label36->Caption = GRADESETTING_ETC_CAPTION_15;
  Label51->Caption = GRADESETTING_ETC_CAPTION_16;

  TntGroupBox6->Caption = GRADESETTING_ETC_CAPTION_50;
  TntLabel54->Caption = GRADESETTING_ETC_CAPTION_51;
  TntLabel57->Caption = GRADESETTING_ETC_CAPTION_52;
  TntLabel55->Caption = GRADESETTING_ETC_CAPTION_53;
  TntLabel58->Caption = GRADESETTING_ETC_CAPTION_53;

  SetupDataSettingButton->Caption = GRADESETTING_ETC_CAPTION_54;

  GroupBox8->Caption 	= GRADESETTING_GROUPBOX_CAPTION_13;
  TntLabel61->Caption	= GRADESETTING_LABEL_CAPTION_03;
}
//---------------------------------------------------------------------------

bool __fastcall TGradeSettingForm::Read3DSetupData(TTablet3DSetupData *tablet3DSetupData)
{
	AnsiString setupDataFileName = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\" + ProductData.ProductCode + ".sdt_3D";
	if (FileExists(setupDataFileName))
	{
		TFileStream *fileStream = new TFileStream(setupDataFileName, fmOpenRead);
		if (fileStream)
		{
			fileStream->Read(tablet3DSetupData, sizeof(TTablet3DSetupData));
			delete fileStream;
			return true;
		}
		else
		{
			return false;
		}
	}
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------

bool __fastcall TGradeSettingForm::ReadSetupData(TTabletSetupData *tabletSetupData)
{
	//   AnsiString setupDataFileName = "C:\\DVS-500T_SVN\\PC_SIM\\setup_round.dat";
	AnsiString setupDataFileName = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\" + ProductData.ProductCode + ".sdt";
	if (FileExists(setupDataFileName))
	{
		TFileStream *fileStream = new TFileStream(setupDataFileName, fmOpenRead);
		if (fileStream)
		{
			memset(tabletSetupData, 0, sizeof(TTabletSetupData));
			fileStream->Read(tabletSetupData, fileStream->Size);
			delete fileStream;
			return true;
		}
		else
		{
			return false;
		}
	}
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------
bool __fastcall TGradeSettingForm::ReadStudyData(TTabletStudyData *tabletStudyData)
{
	AnsiString studyDataFileName = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\" + ProductData.ProductCode + ".stu";
	if (FileExists(studyDataFileName))
	{
		TFileStream *fileStream = new TFileStream(studyDataFileName, fmOpenRead);
		if (fileStream)
		{
			fileStream->Read(tabletStudyData, sizeof(TTabletStudyData));
			delete fileStream;
			return true;
		}
		else
		{
			return false;
		}
	}
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------
bool __fastcall TGradeSettingForm::ReadGradeData(TTabletGradeData *tabletGradeData)
{
	AnsiString gradeFileName = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\" + ProductData.ProductCode + ".grd";
	if (FileExists(gradeFileName))
	{
		TFileStream *fileStream = new TFileStream(gradeFileName, fmOpenRead);
		if (fileStream)
		{
			fileStream->Read(tabletGradeData, sizeof(TTabletGradeData));
			delete fileStream;
			return true;
		}
		else
		{
			return false;
		}
	}
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::DisplayTabletShapeData(int option, int settingArea, int front_OR_rear)
{

	Byte *ptr;
	int randomValue;
	int tempX, tempY;

	int tabletColorR;
	int tabletColorG;
	int tabletColorB;
	int tr, tg, tb;
	unsigned char FrontFaceEachAreaData[480 * 640];

	memset(FrontFaceEachAreaData, 0, 640 * 480);


	Graphics::TBitmap *tabletBitmap;
	tabletBitmap = new Graphics::TBitmap();

	if (front_OR_rear == DISPLAY_FRONT)
	{
		if (TabletSetupData.protoStudyColorB)
			tabletColorB = TabletSetupData.protoStudyColorB;
		else
			tabletColorB = 100;
		if (TabletSetupData.protoStudyColorG)
			tabletColorG = TabletSetupData.protoStudyColorG;
		else
			tabletColorG = 100;
		if (TabletSetupData.protoStudyColorR)
			tabletColorR = TabletSetupData.protoStudyColorR;
		else
			tabletColorR = 100;
	}
	else
	{
		if (TabletSetupData.rear_protoStudyColorB)
			tabletColorB = TabletSetupData.rear_protoStudyColorB;
		else
			tabletColorB = 100;
		if (TabletSetupData.rear_protoStudyColorG)
			tabletColorG = TabletSetupData.rear_protoStudyColorG;
		else
			tabletColorG = 100;
		if (TabletSetupData.rear_protoStudyColorR)
			tabletColorR = TabletSetupData.rear_protoStudyColorR;
		else
			tabletColorR = 100;
	}

	for (int y = 0; y < 480; y++)
	{
		for (int x = 0; x < 640; x++)
		{
			if (TabletSetupData.FrontshapeAreaData[(y / 2) * HALF_IMAGE_WIDTH + (x / 2)])
			{
				FrontFaceEachAreaData[640 * y + x] = NOT_PRINT_AREA;
			}
		}
	}

	if (front_OR_rear == DISPLAY_REAR)
	{
		for (int m = 0; m < TabletSetupData.printData2Count; m++)
		{
			tempX = TabletSetupData.position_printData2[m][0];
			tempY = TabletSetupData.position_printData2[m][1];
			FrontFaceEachAreaData[640 * tempY + tempX] = PRINT_AREA;
		}
	}
	else
	{
		for (int m = 0; m < TabletSetupData.printData1Count; m++)
		{
			tempX = TabletSetupData.position_printData1[m][0];
			tempY = TabletSetupData.position_printData1[m][1];
			FrontFaceEachAreaData[640 * tempY + tempX] = PRINT_AREA;
		}
	}
	for (int m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
	{
		tempX = TabletSetupData.FrontShapeEdgePoint[m][0];
		tempY = TabletSetupData.FrontShapeEdgePoint[m][1];
		for (int y = tempY - 15; y <= tempY + 15; y++)
		{
			for (int x = tempX - 15; x <= tempX + 15; x++)
			{
				if (FrontFaceEachAreaData[640 * y + x])
				{
					FrontFaceEachAreaData[640 * y + x] = EDGE_AREA;
				}
			}
		}
	}



	if (option == FRONT_SHAPE)
	{
		ImageHeight = 480;
		ImageWidth = 640;
		tabletBitmap->Width = ImageWidth;
		tabletBitmap->Height = ImageHeight;
		tabletBitmap->PixelFormat = pf24bit;

		for (int y = 0; y < ImageHeight; y++)
		{
			ptr = (byte*)tabletBitmap->ScanLine[y];
			for (int x = 0; x < ImageWidth; x++)
			{
				randomValue = random(5) + 1;
				if (TabletSetupData.FrontshapeAreaData[(y / 2) * HALF_IMAGE_WIDTH + (x / 2)])
				{
					tr = tabletColorR + tabletColorR * randomValue / 100;
					tg = tabletColorG + tabletColorG * randomValue / 100;
					tb = tabletColorB + tabletColorB * randomValue / 100;
					if (tr > 255) tr = 255;
					if (tg > 255) tg = 255;
					if (tb > 255) tb = 255;
					ptr[x * 3] = tb;
					ptr[x * 3 + 1] = tg;
					ptr[x * 3 + 2] = tr;
				}
				else
				{
					ptr[x * 3] = 0;
					ptr[x * 3 + 1] = 0;
					ptr[x * 3 + 2] = 0;
				}
			}
		}

		if (front_OR_rear == DISPLAY_REAR)
		{
			for (int m = 0; m < TabletSetupData.printData2Count; m++)
			{
				tempX = TabletSetupData.position_printData2[m][0];
				tempY = TabletSetupData.position_printData2[m][1];
				randomValue = random(5);
				ptr = (byte*)tabletBitmap->ScanLine[tempY];
				tr = tabletColorR - tabletColorR * randomValue / 100;
				tg = tabletColorG - tabletColorG * randomValue / 100;
				tb = tabletColorB - tabletColorB * randomValue / 100;
				if (tr < 0) tr = 0;
				if (tg < 0) tg = 0;
				if (tb < 0) tb = 0;

				ptr[tempX * 3] = tb;
				ptr[tempX * 3 + 1] = tg;
				ptr[tempX * 3 + 2] = tr;
			}


			for (int m = 0; m < TabletSetupData.expansion_printData2Count; m++)
			{
				tempX = TabletSetupData.expansion_position_printData2[m][0];
				tempY = TabletSetupData.expansion_position_printData2[m][1];
				randomValue = random(5);
				ptr = (byte*)tabletBitmap->ScanLine[tempY];

				tr = tabletColorR + tabletColorR * randomValue / 100 + 10;
				tg = tabletColorG + tabletColorG * randomValue / 100 + 10;
				tb = tabletColorB + tabletColorB * randomValue / 100 + 10;
				if (tr > 255) tr = 255;
				if (tg > 255) tg = 255;
				if (tb > 255) tb = 255;

				ptr[tempX * 3] = tb;
				ptr[tempX * 3 + 1] = tg;
				ptr[tempX * 3 + 2] = tr;
			}
		}
		else
		{
			for (int m = 0; m < TabletSetupData.printData1Count; m++)
			{
				tempX = TabletSetupData.position_printData1[m][0];
				tempY = TabletSetupData.position_printData1[m][1];
				randomValue = random(5);
				ptr = (byte*)tabletBitmap->ScanLine[tempY];
				tr = tabletColorR - tabletColorR * randomValue / 100;
				tg = tabletColorG - tabletColorG * randomValue / 100;
				tb = tabletColorB - tabletColorB * randomValue / 100;
				if (tr < 0) tr = 0;
				if (tg < 0) tg = 0;
				if (tb < 0) tb = 0;

				ptr[tempX * 3] = tb;
				ptr[tempX * 3 + 1] = tg;
				ptr[tempX * 3 + 2] = tr;
			}


			for (int m = 0; m < TabletSetupData.expansion_printData1Count; m++)
			{
				tempX = TabletSetupData.expansion_position_printData1[m][0];
				tempY = TabletSetupData.expansion_position_printData1[m][1];
				randomValue = random(5);
				ptr = (byte*)tabletBitmap->ScanLine[tempY];

				tr = tabletColorR + tabletColorR * randomValue / 100 + 10;
				tg = tabletColorG + tabletColorG * randomValue / 100 + 10;
				tb = tabletColorB + tabletColorB * randomValue / 100 + 10;
				if (tr > 255) tr = 255;
				if (tg > 255) tg = 255;
				if (tb > 255) tb = 255;

				ptr[tempX * 3] = tb;
				ptr[tempX * 3 + 1] = tg;
				ptr[tempX * 3 + 2] = tr;
			}
		}

		if (settingArea == PRINT_AREA)
		{
			for (int y = 0; y < 480; y++)
			{
				ptr = (byte*)tabletBitmap->ScanLine[y];
				for (int x = 0; x < 640; x++)
				{
					//                    if(y % 3 == 0 && x %3 == 0)
					{
						if (FrontFaceEachAreaData[y * 640 + x] == PRINT_AREA)
						{
							//     ptr[x*3] = 255;
							//     ptr[x*3+1] = 255;
							ptr[x * 3 + 2] = 200;
						}
					}
				}
			}

		}
		else if (settingArea == NOT_PRINT_AREA)
		{
			for (int y = 0; y < 480; y++)
			{
				ptr = (byte*)tabletBitmap->ScanLine[y];
				for (int x = 0; x < 640; x++)
				{
					//                    if(y % 4 == 0 && x %4 == 0)
					{
						if (FrontFaceEachAreaData[y * 640 + x] == NOT_PRINT_AREA)
						{
							//    ptr[x*3] = 255;
							//    ptr[x*3+1] = 255;
							ptr[x * 3 + 2] = 200;
						}
					}
				}
			}
		}
		else if (settingArea == EDGE_AREA)
		{
			for (int y = 0; y < 480; y++)
			{
				ptr = (byte*)tabletBitmap->ScanLine[y];
				for (int x = 0; x < 640; x++)
				{
					//                    if(y % 4 == 0 && x %4 == 0)
					{
						if (FrontFaceEachAreaData[y * 640 + x] == EDGE_AREA)
						{
							//    ptr[x*3] = 255;
							//    ptr[x*3+1] = 255;
							ptr[x * 3 + 2] = 200;
						}
					}
				}
			}
		}
		else if (settingArea == NOT_EDGE_AREA)
		{
			for (int y = 0; y < 480; y++)
			{
				ptr = (byte*)tabletBitmap->ScanLine[y];
				for (int x = 0; x < 640; x++)
				{
					//                    if(y % 4 == 0 && x %4 == 0)
					{
						if (FrontFaceEachAreaData[y * 640 + x])
						{
							//       ptr[x*3] = 255;
							//       ptr[x*3+1] = 255;
							ptr[x * 3 + 2] = 200;
						}
					}
				}
			}
		}
	}
	else if (option == SIDE_SHAPE)
	{
		AnsiString fileName = ProgramPath.Env + "\\Round_Side_ForGradeSetting.bmp";
		if (FileExists(fileName))
		{
			tabletBitmap->LoadFromFile(fileName);
		}

		for (int y = 0; y < tabletBitmap->Height; y++)
		{
			ptr = (byte*)tabletBitmap->ScanLine[y];
			for (int x = 0; x < tabletBitmap->Width; x++)
			{
				randomValue = random(5) + 1;
				if (ptr[x * 3])
				{
					tr = ptr[3 * x + 2] * tabletColorR / tabletColorG + tabletColorR * randomValue / 100;
					tg = ptr[3 * x + 1] + tabletColorG * randomValue / 100;
					tb = ptr[3 * x] * tabletColorB / tabletColorG + tabletColorB * randomValue / 100;
					if (tr > 255) tr = 255;
					if (tg > 255) tg = 255;
					if (tb > 255) tb = 255;
					ptr[x * 3] = tb;
					ptr[x * 3 + 1] = tg;
					ptr[x * 3 + 2] = tr;
				}
				else
				{
					ptr[x * 3] = 0;
					ptr[x * 3 + 1] = 0;
					ptr[x * 3 + 2] = 0;
				}
			}
		}

		if (settingArea == EDGE_AREA)
		{
			Image1->Canvas->Pen->Color = clRed;
			Image1->Canvas->Brush->Color = clRed;
			Image1->Canvas->Brush->Style = bsDiagCross;
			Image1->Canvas->Rectangle(133, 137, 459, 157);
			Image1->Canvas->Rectangle(133, 237, 459, 257);


		}

	}

	if (front_OR_rear == DISPLAY_FRONT)
	{
		Image1->Picture->Bitmap->Assign(tabletBitmap);
		Image1->Refresh();
	}
	else
	{
		Image9->Picture->Bitmap->Assign(tabletBitmap);
		Image9->Refresh();
	}
	if (tabletBitmap) delete tabletBitmap;

}
void __fastcall TGradeSettingForm::DisplayNotInspectionAera(int option, int settingArea)
{

	Byte *ptr;
	int randomValue;
	int tempX, tempY;

	int tabletColorR;
	int tabletColorG;
	int tabletColorB;
	int tr, tg, tb;
	unsigned char FrontFaceEachAreaData[480 * 640];

	memset(FrontFaceEachAreaData, 0, 640 * 480);


	Graphics::TBitmap *tabletBitmap;
	tabletBitmap = new Graphics::TBitmap();

	if (TabletSetupData.protoStudyColorB)
		tabletColorB = TabletSetupData.protoStudyColorB;
	else
		tabletColorB = 100;
	if (TabletSetupData.protoStudyColorG)
		tabletColorG = TabletSetupData.protoStudyColorG;
	else
		tabletColorG = 100;
	if (TabletSetupData.protoStudyColorR)
		tabletColorR = TabletSetupData.protoStudyColorR;
	else
		tabletColorR = 100;
	for (int y = 0; y < 480; y++)
	{
		for (int x = 0; x < 640; x++)
		{
			if (TabletSetupData.FrontshapeAreaData[(y / 2) * HALF_IMAGE_WIDTH + (x / 2)])
			{
				FrontFaceEachAreaData[640 * y + x] = NOT_PRINT_AREA;
			}
		}
	}

	for (int m = 0; m < TabletSetupData.printData1Count; m++)
	{
		tempX = TabletSetupData.position_printData1[m][0];
		tempY = TabletSetupData.position_printData1[m][1];
		FrontFaceEachAreaData[640 * tempY + tempX] = PRINT_AREA;
	}

	int tempValue = 0;
	if (option == FRONT_SHAPE)
	{
		if (TabletCharacter.shape == ROUND)
			TabletGradeData.frontShapeEdgeNeighborRange = 22 * (TabletCharacter.width * 37) / 12000 + IntensityValue[26];
		else if (TabletCharacter.shape == OBLONG || TabletCharacter.shape == OVAL)
			TabletGradeData.frontShapeEdgeNeighborRange = 15 + ((TabletCharacter.width * 37 - 5000) * 5 + 500) / 1000 + IntensityValue[26];
		else
			TabletGradeData.frontShapeEdgeNeighborRange = 15 + IntensityValue[26];

		tempValue = TabletGradeData.frontShapeEdgeNeighborRange;
	}
	else
	{
		tempValue = IntensityValue[29] + 17;
	}

	for (int m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
	{
		tempX = TabletSetupData.FrontShapeEdgePoint[m][0];
		tempY = TabletSetupData.FrontShapeEdgePoint[m][1];
		for (int y = tempY - tempValue; y <= tempY + tempValue; y++)
		{
			for (int x = tempX - tempValue; x <= tempX + tempValue; x++)
			{
				if (FrontFaceEachAreaData[640 * y + x])
				{
					FrontFaceEachAreaData[640 * y + x] = EDGE_AREA;
				}
			}
		}
	}

	if (option == FRONT_SHAPE || option == FRONT_3D_SHAPE)
	{
		ImageHeight = 480;
		ImageWidth = 640;
		tabletBitmap->Width = ImageWidth;
		tabletBitmap->Height = ImageHeight;
		tabletBitmap->PixelFormat = pf24bit;

		for (int y = 0; y < ImageHeight; y++)
		{
			ptr = (byte*)tabletBitmap->ScanLine[y];
			for (int x = 0; x < ImageWidth; x++)
			{
				randomValue = random(5) + 1;
				if (TabletSetupData.FrontshapeAreaData[(y / 2) * HALF_IMAGE_WIDTH + (x / 2)])
				{
					tr = tabletColorR + tabletColorR * randomValue / 100;
					tg = tabletColorG + tabletColorG * randomValue / 100;
					tb = tabletColorB + tabletColorB * randomValue / 100;
					if (tr > 255) tr = 255;
					if (tg > 255) tg = 255;
					if (tb > 255) tb = 255;
					ptr[x * 3] = tb;
					ptr[x * 3 + 1] = tg;
					ptr[x * 3 + 2] = tr;
				}
				else
				{
					ptr[x * 3] = 0;
					ptr[x * 3 + 1] = 0;
					ptr[x * 3 + 2] = 0;
				}
			}
		}

		for (int m = 0; m < TabletSetupData.printData1Count; m++)
		{
			tempX = TabletSetupData.position_printData1[m][0];
			tempY = TabletSetupData.position_printData1[m][1];
			randomValue = random(5);
			ptr = (byte*)tabletBitmap->ScanLine[tempY];
			tr = tabletColorR - tabletColorR * randomValue / 100;
			tg = tabletColorG - tabletColorG * randomValue / 100;
			tb = tabletColorB - tabletColorB * randomValue / 100;
			if (tr < 0) tr = 0;
			if (tg < 0) tg = 0;
			if (tb < 0) tb = 0;

			ptr[tempX * 3] = tb;
			ptr[tempX * 3 + 1] = tg;
			ptr[tempX * 3 + 2] = tr;
		}


		for (int m = 0; m < TabletSetupData.expansion_printData1Count; m++)
		{
			tempX = TabletSetupData.expansion_position_printData1[m][0];
			tempY = TabletSetupData.expansion_position_printData1[m][1];
			randomValue = random(5);
			ptr = (byte*)tabletBitmap->ScanLine[tempY];

			tr = tabletColorR + tabletColorR * randomValue / 100 + 10;
			tg = tabletColorG + tabletColorG * randomValue / 100 + 10;
			tb = tabletColorB + tabletColorB * randomValue / 100 + 10;
			if (tr > 255) tr = 255;
			if (tg > 255) tg = 255;
			if (tb > 255) tb = 255;

			ptr[tempX * 3] = tb;
			ptr[tempX * 3 + 1] = tg;
			ptr[tempX * 3 + 2] = tr;
		}


		if (settingArea == PRINT_AREA)
		{
			int checkSW;
			for (int y = 1; y < 480 - 1; y++)
			{
				for (int x = 1; x < 640 - 1; x++)
				{
					{
						if (FrontFaceEachAreaData[y * 640 + x] != PRINT_AREA)
						{
							checkSW = 0;
							for (int i = y - 1; i <= y + 1; i++)
							{
								for (int j = x - 1; j <= x + 1; j++)
								{
									if (FrontFaceEachAreaData[i * 640 + j] == PRINT_AREA)
									{
										checkSW = 1;
									}
								}
							}
							if (checkSW == 1)
							{
								for (int i = y - IntensityValue[22]; i <= y + IntensityValue[22]; i++)
								{
									ptr = (byte*)tabletBitmap->ScanLine[i];
									for (int j = x - IntensityValue[22]; j <= x + IntensityValue[22]; j++)
									{
										if (FrontFaceEachAreaData[i * 640 + j] != PRINT_AREA)
										{
											ptr[j * 3 + 2] = 200;
										}
									}
								}
							}
						}
					}
				}
			}

		}
		else if (settingArea == EDGE_AREA)
		{
			for (int m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				tempX = TabletSetupData.FrontShapeEdgePoint[m][0];
				tempY = TabletSetupData.FrontShapeEdgePoint[m][1];
				for (int y = tempY - IntensityValue[23]; y <= tempY + IntensityValue[23]; y++)
				{
					ptr = (byte*)tabletBitmap->ScanLine[y];
					for (int x = tempX - IntensityValue[23]; x <= tempX + IntensityValue[23]; x++)
					{
						if (FrontFaceEachAreaData[640 * y + x] == EDGE_AREA)
						{
							ptr[x * 3 + 2] = 200;
						}
					}
				}
			}
		}
		else if (settingArea == THREED_PRINT_AREA)
		{
			int checkSW;
			for (int y = 1; y < 480 - 1; y++)
			{
				for (int x = 1; x < 640 - 1; x++)
				{
					{
						if (FrontFaceEachAreaData[y * 640 + x] != PRINT_AREA)
						{
							checkSW = 0;
							for (int i = y - 1; i <= y + 1; i++)
							{
								for (int j = x - 1; j <= x + 1; j++)
								{
									if (FrontFaceEachAreaData[i * 640 + j] == PRINT_AREA)
									{
										checkSW = 1;
									}
								}
							}
							if (checkSW == 1)
							{
								for (int i = y - IntensityValue[24]; i <= y + IntensityValue[24]; i++)
								{
									ptr = (byte*)tabletBitmap->ScanLine[i];
									for (int j = x - IntensityValue[24]; j <= x + IntensityValue[24]; j++)
									{
										if (FrontFaceEachAreaData[i * 640 + j] != PRINT_AREA)
										{
											ptr[j * 3 + 2] = 200;
										}
									}
								}
							}
						}
					}
				}
			}

		}
		else if (settingArea == THREED_EDGE_AREA)
		{
			for (int m = 0; m < TabletSetupData.FrontShapeEdgePointCount; m++)
			{
				tempX = TabletSetupData.FrontShapeEdgePoint[m][0];
				tempY = TabletSetupData.FrontShapeEdgePoint[m][1];
				for (int y = tempY - IntensityValue[25]; y <= tempY + IntensityValue[25]; y++)
				{
					ptr = (byte*)tabletBitmap->ScanLine[y];
					for (int x = tempX - IntensityValue[25]; x <= tempX + IntensityValue[25]; x++)
					{
						if (FrontFaceEachAreaData[640 * y + x] == EDGE_AREA)
						{
							ptr[x * 3 + 2] = 200;
						}
					}
				}
			}
		}
		else if (settingArea == NOTHING)
		{
			for (int y = 0; y < 480; y++)
			{
				ptr = (byte*)tabletBitmap->ScanLine[y];
				for (int x = 0; x < 640; x++)
				{
					if (FrontFaceEachAreaData[y * 640 + x] == EDGE_AREA)
					{
						ptr[x * 3 + 2] = 200;
					}
				}
			}
		}
		
		Image9->Picture->Bitmap->Assign(tabletBitmap);
		Image9->Refresh();
		if (tabletBitmap) delete tabletBitmap;
	}
	else if (option == SIDE_SHAPE)
	{
		AnsiString fileName = ProgramPath.Env + "\\Round_Side_ForGradeSetting.bmp";
		if (FileExists(fileName))
		{
			tabletBitmap->LoadFromFile(fileName);
		}

		Image9->Picture->Bitmap->Assign(tabletBitmap);
		Image9->Refresh();
		if (tabletBitmap) delete tabletBitmap;

		if (settingArea == EDGE_AREA)
		{
			Image9->Canvas->Pen->Color = clRed;
			Image9->Canvas->Brush->Color = clRed;
			Image9->Canvas->Brush->Style = bsDiagCross;
			Image9->Canvas->Rectangle(133, 147 - IntensityValue[10], 459, 147 + IntensityValue[10]);
			Image9->Canvas->Rectangle(133, 247 - IntensityValue[55], 459, 247 + IntensityValue[55]);
		}
	}
}




int  __fastcall TGradeSettingForm::PixelToMili(int pixel)
{

	int closeMili = 0;
	int min = 10000000;
	for (int m = 0; m < 1000; m++)
	{
		if (abs(pixel - Table_Interval_PixelAndMeter[m]) < min)
		{
			min = abs(pixel - Table_Interval_PixelAndMeter[m]);
			closeMili = m;
		}
	}
	return(closeMili);
}
int  __fastcall TGradeSettingForm::PixelToMiliForThreeD(int pixel)
{
	int closeMili = 0;
	int min = 10000000;
	for (int m = 0; m < 1000; m++)
	{
		if (abs(pixel - Table_Interval_PixelAndMeterForThreeD[m]) < min)
		{
			min = abs(pixel - Table_Interval_PixelAndMeterForThreeD[m]);
			closeMili = m;
		}
	}
	return(closeMili);
}

//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::FormActivate(TObject *Sender)
{
  SetScreenPosition(this);

	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;
	GroupBox4->Visible = false;

	for (int m = 4; m < 1000; m++)
	{
		Table_Interval_PixelAndMeter[m - 4] = (int)(5.73 * (float)(m* m) / 100.0);   //3.14/4/37/37
	}
	for (int m = 4; m < 1000; m++)
	{
		Table_Interval_PixelAndMeterForThreeD[m - 4] = (int)(5.73 * (float)(m* m) / 100.0);   //3.14/4/40/40
	}

	for (int m = 0; m < 100; m++)
	{
		IntensityValue[m] = 1;
	}
	for (int m = 0; m < 100; m++)
	{
		SizeValue[m] = 10;
	}

	if (!ReadSetupData(&TabletSetupData))
	{
		ShowMessageW(GRADESETTING_MSG_01);
	}

	if (!Read3DSetupData(&Tablet3DSetupData))
	{
		ShowMessageW(GRADESETTING_MSG_01);
	}

	AnsiString studyFileName = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\" + ProductData.ProductCode + ".stu";
	if (!LoadStudyData(studyFileName, TabletStudyData))
	{
		ShowMessageW(GRADESETTING_MSG_02);
	}

	MakeTabletCharacterData(&ProductData, &TabletCharacter, &MachineParams);

  if(!bUserMakingGradeData)
  {
    SetDefaultGradeData(TabletGradeData);
    if (!ReadGradeData(&TabletGradeData))
    {
      ShowMessageW(GRADESETTING_MSG_03);
    }
  }

	GradeDataToVariable();

	DisplayTabletShapeData(FRONT_SHAPE, NOT_SELECT_AREA, DISPLAY_FRONT);
	DisplayEachGradeValue();

  // 21/07/13
  //    ҷ  ȭ  Ұ· 
  /*
  if(TabletGradeData.ETC_EnforcementStainDefectCheckAlgorithm)
  {
    TabletCoatingDefectCheckGroupBox->Visible = true;
  }
  else
  {
    TabletCoatingDefectCheckGroupBox->Visible = false;
  }
  */

  TabletCoatingDefectCheckGroupBox->Visible = false;
  // end
    
  if(bUserMakingGradeData)
  {
    InspectionAreaSettingBtn->Enabled = false;
    ColorDirtyControlBtn->Enabled = false;
    EraseThreeDEngraveBtn->Enabled = false;
  }

  if(!TabletCharacter.MarvelingTablet &&
      TabletCharacter.kind != SUGARCOATING &&
      TabletCharacter.discriminationDisplay_kind == PRINT &&
      TabletCharacter.tabletDivisionLineInfo)
  {
    if(TabletSetupData.tabletSplitLineDataCount)
    {
      FrontFaceSplitLineRecognizationBtn->Visible = true;
    }
    else
    {
      FrontFaceSplitLineRecognizationBtn->Visible = false;
    }
  }
  else
  {
    FrontFaceSplitLineRecognizationBtn->Visible = false;
  }

  if(TabletCharacter.kind == SUGARCOATING && TabletGradeData.ETC_CoatedTablet_ShapeCheck)
  {
    GradeButton33->Visible = true;
    TntPanel17->Visible = true;
  }
  else
  {
    GradeButton33->Visible = false;
    TntPanel17->Visible = false;
  }
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::DisplayEachGradeValue(void)
{
	for (int i = 1; i <= 9; i++)
	{
		((TTntLabel *)FindComponent("IntensityV" + IntToStr(i)))->Font->Size = 10;
		((TTntLabel *)FindComponent("IntensityV" + IntToStr(i)))->Font->Color = clRed;
	}
	for (int i = 11; i <= 15; i++)
	{
    if(i != PRINT_ERASE_GRADE_NUM && i != PRINT_SPREAD_GRADE_NUM)
    {
		  ((TTntLabel *)FindComponent("IntensityV" + IntToStr(i)))->Font->Size = 10;
		  ((TTntLabel *)FindComponent("IntensityV" + IntToStr(i)))->Font->Color = clRed;
    }
	}

	((TTntLabel *)FindComponent("IntensityV" + IntToStr(28)))->Font->Size = 10;
	((TTntLabel *)FindComponent("IntensityV" + IntToStr(28)))->Font->Color = clRed;
	((TTntLabel *)FindComponent("IntensityV" + IntToStr(32)))->Font->Size = 10;
	((TTntLabel *)FindComponent("IntensityV" + IntToStr(32)))->Font->Color = clRed;
	((TTntLabel *)FindComponent("IntensityV" + IntToStr(58)))->Font->Size = 10;
	((TTntLabel *)FindComponent("IntensityV" + IntToStr(58)))->Font->Color = clRed;
	((TTntLabel *)FindComponent("IntensityV" + IntToStr(60)))->Font->Size = 10;
	((TTntLabel *)FindComponent("IntensityV" + IntToStr(60)))->Font->Color = clRed;
	((TTntLabel *)FindComponent("IntensityV" + IntToStr(71)))->Font->Size = 10;
	((TTntLabel *)FindComponent("IntensityV" + IntToStr(71)))->Font->Color = clRed;
	((TTntLabel *)FindComponent("IntensityV" + IntToStr(73)))->Font->Size = 10;
	((TTntLabel *)FindComponent("IntensityV" + IntToStr(73)))->Font->Color = clRed;

	SizeV1->Font->Size = 10;
	SizeV1->Font->Color = clRed;
	SizeV3->Font->Size = 10;
	SizeV3->Font->Color = clRed;
	SizeV4->Font->Size = 10;
	SizeV4->Font->Color = clRed;
	SizeV5->Font->Size = 10;
	SizeV5->Font->Color = clRed;
	SizeV6->Font->Size = 10;
	SizeV6->Font->Color = clRed;
	SizeV7->Font->Size = 10;
	SizeV7->Font->Color = clRed;
	SizeV8->Font->Size = 10;
	SizeV8->Font->Color = clRed;
	SizeV9->Font->Size = 10;
	SizeV9->Font->Color = clRed;
	SizeV15->Font->Size = 10;
	SizeV15->Font->Color = clRed;
	SizeV28->Font->Size = 10;
	SizeV28->Font->Color = clRed;
	SizeV30->Font->Size = 10;
	SizeV30->Font->Color = clRed;
	SizeV31->Font->Size = 10;
	SizeV31->Font->Color = clRed;
	SizeV12->Font->Size = 10;
	SizeV12->Font->Color = clRed;
	SizeV32->Font->Size = 10;
	SizeV32->Font->Color = clRed;
	SizeV58->Font->Size = 10;
	SizeV58->Font->Color = clRed;
	SizeV60->Font->Size = 10;
	SizeV60->Font->Color = clRed;
  SizeV71->Font->Size = 10;
	SizeV71->Font->Color = clRed;
  SizeV73->Font->Size = 10;
	SizeV73->Font->Color = clRed;

  SpreadSizeLabel->Font->Size = 10;
	SpreadSizeLabel->Font->Color = clRed;

  EraseSizeLabel->Font->Size = 10;
	EraseSizeLabel->Font->Color = clRed;

	IntensityV1->Caption = IntToStr(IntensityValue[1]);
	IntensityV2->Caption = IntToStr(IntensityValue[2]);
	IntensityV3->Caption = IntToStr(IntensityValue[3]);
	IntensityV4->Caption = IntToStr(IntensityValue[4]);
	IntensityV5->Caption = IntToStr(IntensityValue[5]);
	IntensityV6->Caption = FloatToStr((float)IntensityValue[6] * 30.0 / 10.0 / 1000.0);
	IntensityV7->Caption = FloatToStr((float)IntensityValue[7] * 30.0 / 10.0 / 1000.0);
  IntensityV71->Caption = FloatToStr((float)IntensityValue[71] * 30.0 / 10.0 / 1000.0);
  IntensityV72->Caption = FloatToStr((IntensityValue[72] - 20) * 0.04) + " mm";
  
	IntensityV8->Caption = IntToStr(IntensityValue[8]);
	IntensityV9->Caption = IntToStr(IntensityValue[9]);
	IntensityV10->Caption = FloatToStr(IntensityValue[10] * 0.04);
	IntensityV11->Caption = IntToStr(IntensityValue[11]);
	IntensityV12->Caption = IntToStr(IntensityValue[12]);

  IntensityV73->Caption = FloatToStr((float)IntensityValue[73] * 30.0 / 10.0 / 1000.0);

  if(TabletCharacter.discriminationDisplay_kind == PRINT)
  {
    SpreadSizeLabel->Caption = FloatToStr(DefectSizePixelToMili((IntensityValue[PRINT_SPREAD_GRADE_NUM] + 1) * (IntensityValue[PRINT_SPREAD_GRADE_NUM])) / 100.0);
    TntLabel15->Left = 56;
    TntLabel15->Caption = "mm";
  }
  else
  {
    SpreadSizeLabel->Caption = IntToStr(IntensityValue[PRINT_SPREAD_GRADE_NUM]);
    TntLabel15->Left = 48;
    TntLabel15->Caption = "Grade";
  }

  EraseSizeLabel->Caption = FloatToStr(DefectSizePixelToMili((IntensityValue[PRINT_ERASE_GRADE_NUM] + 1) * (IntensityValue[PRINT_ERASE_GRADE_NUM])) / 100.0);
  
	IntensityV15->Caption = IntToStr(IntensityValue[15]);
	IntensityV16->Caption = IntToStr(IntensityValue[16]);
	IntensityV17->Caption = IntToStr(IntensityValue[17]);
	IntensityV18->Caption = IntToStr(IntensityValue[18]);
	IntensityV19->Caption = IntToStr(IntensityValue[19]);
	IntensityV20->Caption = IntToStr(IntensityValue[20]);
	IntensityV21->Caption = IntToStr(IntensityValue[21]);
	IntensityV22->Caption = FloatToStr(IntensityValue[22] * 0.04);
	IntensityV23->Caption = FloatToStr(IntensityValue[23] * 0.04);
	IntensityV24->Caption = FloatToStr(IntensityValue[24] * 0.04);
	IntensityV25->Caption = FloatToStr(IntensityValue[25] * 0.04);
	IntensityV26->Caption = FloatToStr(IntensityValue[26] * 0.04) + " mm";
	IntensityV28->Caption = IntToStr(IntensityValue[28]);
	IntensityV29->Caption = FloatToStr(IntensityValue[29] * 0.04) + " mm";
	IntensityV32->Caption = IntToStr(IntensityValue[32]);
	IntensityV58->Caption = IntToStr(IntensityValue[58]);
	IntensityV60->Caption = IntToStr(IntensityValue[60]);

	IntensityV34->Caption = IntToStr(IntensityValue[34]);
	IntensityV35->Caption = FloatToStr(IntensityValue[47] * 0.04);
	IntensityV36->Caption = FloatToStr(IntensityValue[55] * 0.04);
	TntLabel13->Caption = FloatToStr(IntensityValue[39] * 0.04);

	IntensityV37->Caption = FloatToStr(IntensityValue[56] * 0.04);
	IntensityV38->Caption = FloatToStr(IntensityValue[57] * 0.04);

  IntensityV77->Caption = IntToStr(IntensityValue[77]);

  SideBreakDepthSizeLabel->Caption = FloatToStr(ETC_Side_Break_Depth_Size * 0.04);

	if (IntensityValue[35] == GRADE_SENSITIVITY_NORMAL)
	{
		GradeSensitivityPanel1->Color = clBlue;
		GradeSensitivityPanel1->Font->Color = clWhite;
		GradeSensitivityPanel1->Font->Style = GradeSensitivityPanel1->Font->Style << fsBold;

		GradeSensitivityPanel2->Color = clWhite;
		GradeSensitivityPanel2->Font->Color = clBlack;
		GradeSensitivityPanel2->Font->Style = GradeSensitivityPanel2->Font->Style >> fsBold;

		ColorDefectPassAlgorithmCB->Enabled = true;
	}
	else if (IntensityValue[35] == GRADE_SENSITIVITY_HIGH)
	{
		GradeSensitivityPanel1->Color = clWhite;
		GradeSensitivityPanel1->Font->Color = clBlack;
		GradeSensitivityPanel1->Font->Style = GradeSensitivityPanel1->Font->Style >> fsBold;

		GradeSensitivityPanel2->Color = clBlue;
		GradeSensitivityPanel2->Font->Color = clWhite;
		GradeSensitivityPanel2->Font->Style = GradeSensitivityPanel2->Font->Style << fsBold;

		ColorDefectPassAlgorithmCB->Enabled = false;
	}
	else
	{
		GradeSensitivityPanel1->Color = clBlue;
		GradeSensitivityPanel1->Font->Color = clWhite;
		GradeSensitivityPanel1->Font->Style = GradeSensitivityPanel1->Font->Style << fsBold;

		GradeSensitivityPanel2->Color = clWhite;
		GradeSensitivityPanel2->Font->Color = clBlack;
		GradeSensitivityPanel2->Font->Style = GradeSensitivityPanel2->Font->Style >> fsBold;

		IntensityValue[35] = GRADE_SENSITIVITY_NORMAL;

		ColorDefectPassAlgorithmCB->Enabled = true;
	}

	if (IntensityValue[37] == 2)
	{
		RColorBackPanel->Color = clWhite;
		GColorBackPanel->Color = clBlack;
		BColorBackPanel->Color = clBlack;
	}
	else if (IntensityValue[37] == 1)
	{
		RColorBackPanel->Color = clBlack;
		GColorBackPanel->Color = clWhite;
		BColorBackPanel->Color = clBlack;
	}
	else if (IntensityValue[37] == 0)
	{
		RColorBackPanel->Color = clBlack;
		GColorBackPanel->Color = clBlack;
		BColorBackPanel->Color = clWhite;
	}

	SizeV1->Caption = FloatToStr(SizeValue[1] / 1000.0);
	SizeV3->Caption = FloatToStr(SizeValue[3] / 1000.0);
	SizeV4->Caption = FloatToStr(SizeValue[4] / 1000.0);
	SizeV5->Caption = FloatToStr(SizeValue[5] / 1000.0);
	SizeV6->Caption = FloatToStr(SizeValue[6] / 1000.0);
	SizeV7->Caption = FloatToStr(SizeValue[7] / 1000.0);
  SizeV71->Caption = FloatToStr(SizeValue[71] / 1000.0);
	SizeV8->Caption = FloatToStr(SizeValue[8] / 1000.0);
	SizeV9->Caption = FloatToStr(SizeValue[9] / 1000.0);
	SizeV12->Caption = FloatToStr((float)SizeValue[12] * 30.0 / 10.0 / 100.0);
	SizeV15->Caption = FloatToStr(SizeValue[15] / 1000.0);
	SizeV16->Caption = FloatToStr(SizeValue[16] / 1000.0);
	SizeV18->Caption = FloatToStr(SizeValue[18] / 1000.0);
	SizeV19->Caption = FloatToStr(SizeValue[19] / 1000.0);
	SizeV20->Caption = FloatToStr(SizeValue[20] / 1000.0);
	SizeV21->Caption = FloatToStr(SizeValue[21] / 1000.0);
	SizeV28->Caption = FloatToStr(SizeValue[28] / 1000.0);
	SizeV32->Caption = FloatToStr(SizeValue[32] / 1000.0);
	SizeV58->Caption = FloatToStr(SizeValue[58] / 1000.0);
	SizeV60->Caption = FloatToStr(SizeValue[60] / 1000.0);
  SizeV73->Caption = FloatToStr(SizeValue[73] / 1000.0);

	SizeV30->Caption = FloatToStr(-SizeValue[30] * 30 / 1000.0);
	SizeV31->Caption = FloatToStr(SizeValue[31] * 30 / 1000.0);

	if (TabletGradeData.frontBorderIsSW == 1)
	{
		CheckBox1->Checked = true;
	}
	else
	{
		CheckBox1->Checked = false;
	}

	if (TabletGradeData.FrontEdgeAreaExtendSW > 10)
		TabletGradeData.FrontEdgeAreaExtendSW = 0;

  TrackBar3->Position = IntensityValue[72];
	TrackBar1->Position = IntensityValue[26];
	TrackBar2->Position = IntensityValue[29];
	ScrollBar1->Position = IntensityValue[22];
	ScrollBar2->Position = IntensityValue[23];
	ScrollBar3->Position = IntensityValue[24];
	ScrollBar4->Position = IntensityValue[25];
	ScrollBar5->Position = IntensityValue[10];
	ScrollBar6->Position = IntensityValue[55];
	ScrollBar7->Position = IntensityValue[56];
	ScrollBar8->Position = IntensityValue[57];

  EngraveMaskSizeTrackBar->Position = IntensityValue[68];

	TntScrollBar1->Position = IntensityValue[39];
	TntScrollBar4->Position = IntensityValue[47];


  if(IntensityValue[69] == 0)
  {
    PrintPositionDefectSizeLabel->Caption = "Disabled";
    PrintPositionDefectSizeLabel->Font->Color = clRed;
  }
  else
  {
    PrintPositionDefectSizeLabel->Caption = FloatToStr(IntensityValue[69] * 0.04) + " mm";
    PrintPositionDefectSizeLabel->Font->Color = clWhite;
  }

  if(IntensityValue[81] == 0)
  {
    AllowXLabel->Caption = "Disabled";
    AllowXLabel->Font->Color = clRed;
  }
  else
  {
    AllowXLabel->Caption = FloatToStr(IntensityValue[81] * 0.05) + " mm";
    AllowXLabel->Font->Color = clWhite;
  }

  if(IntensityValue[82] == 0)
  {
    AllowYLabel->Caption = "Disabled";
    AllowYLabel->Font->Color = clRed;
  }
  else
  {
    AllowYLabel->Caption = FloatToStr(IntensityValue[82] * 0.05) + " mm";
    AllowYLabel->Font->Color = clWhite;
  }

  if(IntensityValue[83] == 0)
  {
    AllowDegreeLabel->Caption = "Disabled";
    AllowDegreeLabel->Font->Color = clRed;
  }
  else
  {
    AllowDegreeLabel->Caption = FloatToStr(IntensityValue[83] * 5) + "Degree";
    AllowDegreeLabel->Font->Color = clWhite;
  }  
  
  PrintPositionDefectTrackBar->Position = IntensityValue[69];
  AllowXScrollBar->Position = IntensityValue[81];
  AllowYScrollBar->Position = IntensityValue[82];
  AllowDegreeScrollBar->Position = IntensityValue[83];
  

  if(IntensityValue[70] == 0)
  {
    PrintRotationPositionDefectSizeLabel->Caption = "Disabled";
    PrintRotationPositionDefectSizeLabel->Font->Color = clRed;
  }
  else
  {
    PrintRotationPositionDefectSizeLabel->Caption = IntToStr(IntensityValue[70] * 2) + " Degree";
    PrintRotationPositionDefectSizeLabel->Font->Color = clWhite;
  }

  PrintRotationPositionDefectTrackBar->Position = IntensityValue[70];

  SideBreakDepthSettingScrollBar->Position = ETC_Side_Break_Depth_Size;

  Intensity68Label->Caption = FloatToStr(IntensityValue[68] * 0.04) + " mm";

	//20180103 ADD
	IntensityValueForMarvelingTablet1->Caption = IntToStr(IntensityValue[51]);
	IntensityValueForMarvelingTablet2->Caption = IntToStr(IntensityValue[52]);
	IntensityValueForMarvelingTablet3->Caption = IntToStr(IntensityValue[2]);
	IntensityValueForMarvelingTablet4->Caption = IntToStr(IntensityValue[53]);
	IntensityValueForMarvelingTablet5->Caption = IntToStr(IntensityValue[54]);
	IntensityValueForMarvelingTablet7->Caption = FloatToStr(DefectSizePixelToMili((IntensityValue[PRINT_ERASE_GRADE_NUM] + 1) * (IntensityValue[PRINT_ERASE_GRADE_NUM])) / 100.0);

  IntensityValueForMarvelingTablet6->Caption = IntToStr(IntensityValue[64]);
  SizeValueForMarvelingTablet6->Caption = FloatToStr(SizeValue[65] / 1000.0);

  if(TabletCharacter.discriminationDisplay_kind == PRINT)
  {
	  IntensityValueForMarvelingTablet8->Caption = FloatToStr(DefectSizePixelToMili((IntensityValue[PRINT_SPREAD_GRADE_NUM] + 1) * (IntensityValue[PRINT_SPREAD_GRADE_NUM])) / 100.0);
    TntLabel47->Caption = "mm";
  }
  else
  {
    IntensityValueForMarvelingTablet8->Caption = IntToStr(IntensityValue[PRINT_SPREAD_GRADE_NUM]);
    TntLabel47->Caption = "Grade";
  }

	IntensityValueForMarvelingTablet9->Caption = IntToStr(IntensityValue[11]);

	SizeValueForMarvelingTablet1->Caption = FloatToStr(SizeValue[51] / 1000.0);
	SizeValueForMarvelingTablet2->Caption = FloatToStr(SizeValue[52] / 1000.0);
	SizeValueForMarvelingTablet3->Caption = FloatToStr(SizeValue[53] / 1000.0);
	SizeValueForMarvelingTablet4->Caption = FloatToStr(SizeValue[54] / 1000.0);

  ThreeDSideEraseTrackBar->Position = IntensityValue[79];
  ThreeDPositionErrorLimitTrackBar->Position = IntensityValue[80];

  if(IntensityValue[79] == 0)
  {
    SideEraseLevelLabel->Caption = "Disabled";
  }
  else
  {
    SideEraseLevelLabel->Caption = IntToStr(IntensityValue[79]) + " Level";
  }

  if(IntensityValue[80] == 0)
  {
    ThreeDHeightLimitLabel->Caption = "Disabled";
  }
  else
  {
    ThreeDHeightLimitLabel->Caption = FloatToStr(IntensityValue[80] * 0.04) + " mm";
  }

	if (TabletGradeData.DefectSearchForColorDirtyOption == 1)
	{
		DefectSearchForColorDirtyOption->Checked = true;
	}
	else
	{
		DefectSearchForColorDirtyOption->Checked = false;
	}


  SideCamMatchingOptionComboBox->ItemIndex = TabletGradeData.SideCamMathingOption;


  DefectSearchForColorDirtyOptOffsetEdit->Text = FloatToStr(TabletGradeData.DefectSearchForColorDirtyOptOffset);

  BeltPowderSensitivityScrollBar->Position = IntensityValue[85];
  IntensityV39->Caption = IntToStr(IntensityValue[85]);

	if (TabletGradeData.EngravePrintMatching2DInActive == 1)
	{
		EngravePrintMatching2DInActiveCheckBox->Checked = true;
	}
	else
	{
		EngravePrintMatching2DInActiveCheckBox->Checked = false;
	}  
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::VariableToGradeData(void)
{
	TabletGradeData.front_dirty_Intensity = IntensityValue[1];
	TabletGradeData.front_dirty_Size = Table_Interval_PixelAndMeter[SizeValue[1] / 10];

	TabletGradeData.front_print_dirty_Inetensity = IntensityValue[2];
  TabletGradeData.front_print_dirty_Inetensity2 = IntensityValue[74];

	TabletGradeData.front_stain_Intensity = IntensityValue[3];
	TabletGradeData.front_stain_Size = Table_Interval_PixelAndMeter[SizeValue[3] / 10];

	TabletGradeData.front_edge_dirty_Intensity = IntensityValue[4];
	TabletGradeData.front_edge_dirty_Size = Table_Interval_PixelAndMeter[SizeValue[4] / 10];

	TabletGradeData.front_edge_Intensity = IntensityValue[5];
	TabletGradeData.front_edge_Size = Table_Interval_PixelAndMeter[SizeValue[5] / 10];

	TabletGradeData.option_front_edgeBreaking_Intensity_Type1 = IntensityValue[7];
	TabletGradeData.option_front_edgeBreaking_Size_Type1 = Table_Interval_PixelAndMeterForThreeD[SizeValue[7] / 10];

  TabletGradeData.option_front_edgeBreaking_Intensity_Type2 = IntensityValue[71];
	TabletGradeData.option_front_edgeBreaking_Size_Type2 = Table_Interval_PixelAndMeterForThreeD[SizeValue[71] / 10];

	TabletGradeData.option_Breaking_Intensity = IntensityValue[6];
	TabletGradeData.option_PrintMark_Intensity = IntensityValue[12];

	TabletGradeData.option_Breaking_Size = Table_Interval_PixelAndMeterForThreeD[SizeValue[6] / 10];

	TabletGradeData.side_dirty_Intensity = IntensityValue[8];
	TabletGradeData.side_dirty_Size = Table_Interval_PixelAndMeter[SizeValue[8] / 10];

	TabletGradeData.side_stain_Intensity = IntensityValue[9];
	TabletGradeData.side_stain_Size = Table_Interval_PixelAndMeter[SizeValue[9] / 10];

	TabletGradeData.side_Edge_Top_Neighbor_Intensity = IntensityValue[10];
	TabletGradeData.side_Edge_Bottom_Neighbor_Intensity = IntensityValue[55];

	TabletGradeData.SideFaceEdgeAreaSize = IntensityValue[56];
	TabletGradeData.SideFaceEdgeUnInsAreaSize = IntensityValue[57];

	TabletGradeData.front_color_Intensity = IntensityValue[11];
  TabletGradeData.FrontFaceEngraveColorGrade = IntensityValue[61];

  TabletGradeData.FrontFaceEngraveWhiteSpotIntensity = IntensityValue[62];
  TabletGradeData.FrontFaceEngraveWhiteSpotSize = Table_Interval_PixelAndMeter[SizeValue[62] / 10];

  TabletGradeData.EnforcementStainDefectInspectionAreaSize = IntensityValue[63];
  TabletGradeData.EnforcementStainDefectThreshold = IntensityValue[64];
  TabletGradeData.EnforcementStainDefectMaxLabelSize = Table_Interval_PixelAndMeter[SizeValue[65] / 10];
  TabletGradeData.EnforcementStainDefectAllGroupSize = Table_Interval_PixelAndMeter[SizeValue[66] / 10];

	TabletGradeData.front_print_erase_Intensity = IntensityValue[13];

	if (ProductData.EngraveType == ENGRAVE_TYPE_PRINT)
	{
		TabletGradeData.front_print_spread_Intensity = IntensityValue[14];
		TabletGradeData.EngraveDistinguishGrade = 20;
	}
	else
	{
		TabletGradeData.front_print_spread_Intensity = 20;
		TabletGradeData.EngraveDistinguishGrade = IntensityValue[14];
	}

	TabletGradeData.front_Color_Dirty_Intensity = IntensityValue[15];
	TabletGradeData.front_Color_Dirty_Size = Table_Interval_PixelAndMeter[SizeValue[15] / 10];


	TabletGradeData.rear_dirty_Intensity = IntensityValue[16];
	TabletGradeData.rear_dirty_Size = Table_Interval_PixelAndMeter[SizeValue[16] / 10];

	TabletGradeData.rear_print_dirty_Inetensity = IntensityValue[17];

	TabletGradeData.rear_edge_dirty_Intensity = IntensityValue[18];
	TabletGradeData.rear_edge_dirty_Size = Table_Interval_PixelAndMeter[SizeValue[18] / 10];

	TabletGradeData.rear_stain_Intensity = IntensityValue[19];
	TabletGradeData.rear_stain_Size = Table_Interval_PixelAndMeter[SizeValue[19] / 10];

	TabletGradeData.rear_edge_Intensity = IntensityValue[20];
	TabletGradeData.rear_edge_Size = Table_Interval_PixelAndMeter[SizeValue[20] / 10];

	TabletGradeData.rear_Color_Dirty_Intensity = IntensityValue[21];
	TabletGradeData.rear_Color_Dirty_Size = Table_Interval_PixelAndMeter[SizeValue[21] / 10];

	TabletGradeData.front_unInspectionIntensity_ForPrint = IntensityValue[22];
	TabletGradeData.front_unInspectionIntensity_ForEdge = IntensityValue[23];
	TabletGradeData.front_unInspectionIntensity_ForOptionPrint = IntensityValue[24];
	TabletGradeData.front_unInspectionIntensity_ForOptionEdge = IntensityValue[25];
	TabletGradeData.FrontEdgeAreaExtendSW = IntensityValue[26];
  TabletGradeData.CoatedTablet_SideInspectionAreaSize = IntensityValue[72];
	TabletGradeData.ETC_SideFaceMultiTabletUnInspectionSize = IntensityValue[47];

	TabletGradeData.side_Color_Dirty_Intensity = IntensityValue[28];
	TabletGradeData.side_Color_Dirty_Size = Table_Interval_PixelAndMeter[SizeValue[28] / 10];

  TabletGradeData.side_Edge_Color_Dirty_Intensity = IntensityValue[78];
	TabletGradeData.side_Edge_Color_Dirty_Size = Table_Interval_PixelAndMeter[SizeValue[78] / 10];

	TabletGradeData.threeDEdgeAreaExtend = IntensityValue[29];
	TabletGradeData.threeD_Height_Minus_Limit = SizeValue[30];
	TabletGradeData.threeD_Height_Plus_Limit = SizeValue[31];
	TabletGradeData.Saturation_Erase_SW = CheckBox2->Checked;
  TabletGradeData.ETC_Side_None_Horizontality_Tablet = NoneHorizontalityTabletCheckBox->Checked;
  TabletGradeData.ETC_Side_Split_Line_UnInspection_Area_Setting = SplitLineUnInspectionAreaSettingCheckBox->Checked;
  	TabletGradeData.SideRemovalAlgorithm3DPassing = SideRemovalAlgorithm3DCheckBox->Checked;

	TabletGradeData.EngravePositionDefectCheckSW = UnPrintDefectCheckBox->Checked;

	TabletGradeData.EngraveDistinguishGradeFor3D = SizeValue[12];

	TabletGradeData.Side_Edge_Neighbor_Intensity = IntensityValue[32];
	TabletGradeData.Side_Edge_Neighbor_Defect_Size = Table_Interval_PixelAndMeter[SizeValue[32] / 10];

	TabletGradeData.Side_Edge_Dark_Intensity = IntensityValue[58];
	TabletGradeData.Side_Edge_Dark_Defect_Size = Table_Interval_PixelAndMeter[SizeValue[58] / 10];

	TabletGradeData.Side_Edge_Bright_Intensity = IntensityValue[59];
	TabletGradeData.Side_Edge_Bright_Defect_Size = Table_Interval_PixelAndMeter[SizeValue[59] / 10];

  TabletGradeData.Side_Edge_Neighbor_Break_Intensity = IntensityValue[60];
  TabletGradeData.Side_Edge_Neighbor_Break_Size = Table_Interval_PixelAndMeter[SizeValue[60] / 10];
  TabletGradeData.Side_Edge_Neighbor_Min_Break_Depth_Size = ETC_Side_Break_Depth_Size;

	TabletGradeData.EngraveMatchingOrNotValue = IntensityValue[34];

	TabletGradeData.DirtyGradeSensitivity = IntensityValue[35];

  TabletGradeData.SplitLineMatchingSWForPrintTablet = FrontFaceSplitLineOptionCheckBox->Checked;
  TabletGradeData.SplitLineMatchingThreshold = IntensityValue[67];

	TabletGradeData.ETC_ApplyColorDirtyIgnoreAlgorithm = ColorDefectPassAlgorithmCB->Checked;
  TabletGradeData.ETC_ActiveSideEdgeDefectCheck = SideEdgeDirtyCheckBox->Checked;
	TabletGradeData.ETC_InterestedColor = IntensityValue[37];
	TabletGradeData.ETC_ColorDirtyIgnoreLevel = IntensityValue[38];
	TabletGradeData.ETC_AdjustPrintAreaSW = CheckBox3->Checked;
	TabletGradeData.ETC_ColorDirtySize = Table_Interval_PixelAndMeter[SizeValue[38] / 10];

	TabletGradeData.ETC_ThreeDCenterSize = IntensityValue[39];

	TabletGradeData.ETC_FrontFaceEdgeInspectionSW = CheckBox5->Checked;
	TabletGradeData.ETC_AdjustUnalignedTabletAlgorithm = CheckBox6->Checked;
	TabletGradeData.ETC_Partial3DPrintCheckSW = SpecialFunctionCheckBox->Checked;

	TabletGradeData.ETC_RemoveBrightDotSW = CheckBox7->Checked;
	TabletGradeData.ETC_ApplyTiltTabletAlgorithm = CheckBox8->Checked;

	TabletGradeData.DarkSpotDefectIntensityGradeForMarvelingTablet = IntensityValue[51];
	TabletGradeData.DarkSpotDefectSizeGradeForMarvelingTablet = Table_Interval_PixelAndMeter[SizeValue[51] / 10];
	TabletGradeData.BrightSpotDefectIntensityGradeForMarvelingTablet = IntensityValue[52];
	TabletGradeData.BrightSpotDefectSizeGradeForMarvelingTablet = Table_Interval_PixelAndMeter[SizeValue[52] / 10];

	TabletGradeData.DarkStainDefectIntensityGradeForMarvelingTablet = IntensityValue[53];
	TabletGradeData.DarkStainDefectSizeGradeForMarvelingTablet = Table_Interval_PixelAndMeter[SizeValue[53] / 10];
	TabletGradeData.BrightStainDefectIntensityGradeForMarvelingTablet = IntensityValue[54];
	TabletGradeData.BrightStainDefectSizeGradeForMarvelingTablet = Table_Interval_PixelAndMeter[SizeValue[54] / 10];

  TabletGradeData.dummy[0] = IntensityValue[68];

  TabletGradeData.ETC_PrintPositionDefectIntensity = IntensityValue[69];
  TabletGradeData.LaserAllowX = IntensityValue[81];
  TabletGradeData.LaserAllowY = IntensityValue[82];
  TabletGradeData.LaserAllowDegree= IntensityValue[83];

  TabletGradeData.ETC_PrintPositionRotationDefectIntensity = IntensityValue[70];

	if (TabletCharacter.MarvelingTablet)
	{
		TabletGradeData.front_dirty_Intensity = TabletGradeData.DarkSpotDefectIntensityGradeForMarvelingTablet;
		TabletGradeData.front_dirty_Size = TabletGradeData.DarkSpotDefectSizeGradeForMarvelingTablet;

		TabletGradeData.front_stain_Intensity = TabletGradeData.DarkStainDefectIntensityGradeForMarvelingTablet;
		TabletGradeData.front_stain_Size = TabletGradeData.DarkStainDefectSizeGradeForMarvelingTablet;

		TabletGradeData.front_edge_dirty_Intensity = TabletGradeData.DarkSpotDefectIntensityGradeForMarvelingTablet;
		TabletGradeData.front_edge_dirty_Size = TabletGradeData.DarkSpotDefectSizeGradeForMarvelingTablet;

		TabletGradeData.front_edge_Intensity = TabletGradeData.DarkStainDefectIntensityGradeForMarvelingTablet;
		TabletGradeData.front_edge_Size = TabletGradeData.DarkStainDefectSizeGradeForMarvelingTablet;

		TabletGradeData.front_Color_Dirty_Intensity = TabletGradeData.BrightStainDefectIntensityGradeForMarvelingTablet;
		TabletGradeData.front_Color_Dirty_Size = TabletGradeData.BrightStainDefectSizeGradeForMarvelingTablet;
	}
	TabletGradeData.DirtyDefectCheckSWInNeighborPrint = DirtyDefectCheckInNeighborPrintCheckBox->Checked;
  TabletGradeData.ETC_EngraveWhiteDefectCheckAlgorithm = EngraveWhiteDefectCheckBox->Checked;
  TabletGradeData.ETC_EnforcementStainDefectCheckAlgorithm = EnforcementStainDefectCheckAlgorithmCheckBox->Checked;
  
	TabletGradeData.ETC_ApplyWhiteEngraveAlgorithm = WhiteEngraveMatchingCheckBox->Checked;

  TabletGradeData.ETC_EngraveMatchingOption_ReflectedTabletShape = Apply2DEngraveMatchingOption_LimitRange->Checked;
  TabletGradeData.ETC_EngraveMatchingOption_LightEngrave = Apply2DEngraveMatchingOption_LightEngrave->Checked;
  TabletGradeData.ETC_CoatedTablet_ShapeCheck = Apply3DShapeCheck->Checked;

  TabletGradeData.ThreeD_CoatedTablet_ShapeError_Height = IntensityValue[73];
	TabletGradeData.ThreeD_CoatedTablet_ShapeError_Size = Table_Interval_PixelAndMeterForThreeD[SizeValue[73] / 10];

  TabletGradeData.ETC_PartialThreeDStampDefectIntensity = IntensityValue[75];
  TabletGradeData.ETC_PartialThreeDStampDefectSize = Table_Interval_PixelAndMeterForThreeD[SizeValue[75] / 10];

  TabletGradeData.ETC_SideEdgeDefectIntensity = IntensityValue[76];
  TabletGradeData.ETC_SideEdgeDefectSize = Table_Interval_PixelAndMeterForThreeD[SizeValue[76] / 10];

  TabletGradeData.ETC_TabletFrontFaceThreshold = IntensityValue[77];

  TabletGradeData.LIMA_ThreeD_Side_EraseLevel = IntensityValue[79];
  TabletGradeData.LIMA_ThreeD_MaxHeight = IntensityValue[80];
  TabletGradeData.LIMA_ThreeD_OverHeightSize = Table_Interval_PixelAndMeterForThreeD[SizeValue[80] / 10];

  TabletGradeData.DefectSearchForColorDirtyOptOffset = StrToFloat(DefectSearchForColorDirtyOptOffsetEdit->Text);

  TabletGradeData.BeltPowderSensitivity = IntensityValue[85] - 1;

  TabletGradeData.RemoveBeltActive = RemoveBeltActiveCheckBox->Checked;
  TabletGradeData.EngravePrintMatching2DInActive = EngravePrintMatching2DInActiveCheckBox->Checked;  
}

void __fastcall TGradeSettingForm::GradeDataToVariable(void)
{
	IntensityValue[1] = TabletGradeData.front_dirty_Intensity;
	SizeValue[1] = PixelToMili(TabletGradeData.front_dirty_Size) * 10;

	IntensityValue[2] = TabletGradeData.front_print_dirty_Inetensity;
  IntensityValue[74] = TabletGradeData.front_print_dirty_Inetensity2;

	IntensityValue[3] = TabletGradeData.front_stain_Intensity;
	SizeValue[3] = PixelToMili(TabletGradeData.front_stain_Size) * 10;

	IntensityValue[4] = TabletGradeData.front_edge_dirty_Intensity;
	SizeValue[4] = PixelToMili(TabletGradeData.front_edge_dirty_Size) * 10;

	IntensityValue[5] = TabletGradeData.front_edge_Intensity;
	SizeValue[5] = PixelToMili(TabletGradeData.front_edge_Size) * 10;

	IntensityValue[7] = TabletGradeData.option_front_edgeBreaking_Intensity_Type1;
	SizeValue[7] = PixelToMiliForThreeD(TabletGradeData.option_front_edgeBreaking_Size_Type1) * 10;

  IntensityValue[71] = TabletGradeData.option_front_edgeBreaking_Intensity_Type2;
	SizeValue[71] = PixelToMiliForThreeD(TabletGradeData.option_front_edgeBreaking_Size_Type2) * 10;

	IntensityValue[12] = TabletGradeData.option_PrintMark_Intensity;

	IntensityValue[6] = TabletGradeData.option_Breaking_Intensity;
	SizeValue[6] = PixelToMiliForThreeD(TabletGradeData.option_Breaking_Size) * 10;
                                                                                                      
	IntensityValue[8] = TabletGradeData.side_dirty_Intensity;
	SizeValue[8] = PixelToMili(TabletGradeData.side_dirty_Size) * 10;

	IntensityValue[9] = TabletGradeData.side_stain_Intensity;
	SizeValue[9] = PixelToMili(TabletGradeData.side_stain_Size) * 10;

	IntensityValue[10] = TabletGradeData.side_Edge_Top_Neighbor_Intensity;
	IntensityValue[55] = TabletGradeData.side_Edge_Bottom_Neighbor_Intensity;

	IntensityValue[56] = TabletGradeData.SideFaceEdgeAreaSize;
	IntensityValue[57] = TabletGradeData.SideFaceEdgeUnInsAreaSize;

	IntensityValue[11] = TabletGradeData.front_color_Intensity;
  IntensityValue[61] = TabletGradeData.FrontFaceEngraveColorGrade;

  IntensityValue[62] = TabletGradeData.FrontFaceEngraveWhiteSpotIntensity;
  SizeValue[62] = PixelToMili(TabletGradeData.FrontFaceEngraveWhiteSpotSize) * 10;

  IntensityValue[63] = TabletGradeData.EnforcementStainDefectInspectionAreaSize;
  IntensityValue[64] = TabletGradeData.EnforcementStainDefectThreshold;
  SizeValue[65] = PixelToMili(TabletGradeData.EnforcementStainDefectMaxLabelSize) * 10;
  SizeValue[66] = PixelToMili(TabletGradeData.EnforcementStainDefectAllGroupSize) * 10;

	IntensityValue[13] = TabletGradeData.front_print_erase_Intensity;

	if (ProductData.EngraveType == ENGRAVE_TYPE_PRINT)
	{
		IntensityValue[14] = TabletGradeData.front_print_spread_Intensity;
	}
	else
	{
		IntensityValue[14] = TabletGradeData.EngraveDistinguishGrade;
	}

	IntensityValue[15] = TabletGradeData.front_Color_Dirty_Intensity;
	SizeValue[15] = PixelToMili(TabletGradeData.front_Color_Dirty_Size) * 10;

	IntensityValue[16] = TabletGradeData.rear_dirty_Intensity;
	SizeValue[16] = PixelToMili(TabletGradeData.rear_dirty_Size) * 10;

	IntensityValue[17] = TabletGradeData.rear_print_dirty_Inetensity;

	IntensityValue[18] = TabletGradeData.rear_edge_dirty_Intensity;
	SizeValue[18] = PixelToMili(TabletGradeData.rear_edge_dirty_Size) * 10;

	IntensityValue[19] = TabletGradeData.rear_stain_Intensity;
	SizeValue[19] = PixelToMili(TabletGradeData.rear_stain_Size) * 10;

	IntensityValue[20] = TabletGradeData.rear_edge_Intensity;
	SizeValue[20] = PixelToMili(TabletGradeData.rear_edge_Size) * 10;

	IntensityValue[21] = TabletGradeData.rear_Color_Dirty_Intensity;
	SizeValue[21] = PixelToMili(TabletGradeData.rear_Color_Dirty_Size) * 10;

	IntensityValue[22] = TabletGradeData.front_unInspectionIntensity_ForPrint;
	IntensityValue[23] = TabletGradeData.front_unInspectionIntensity_ForEdge;
	IntensityValue[24] = TabletGradeData.front_unInspectionIntensity_ForOptionPrint;
	IntensityValue[25] = TabletGradeData.front_unInspectionIntensity_ForOptionEdge;
	IntensityValue[26] = TabletGradeData.FrontEdgeAreaExtendSW;
  IntensityValue[72] = TabletGradeData.CoatedTablet_SideInspectionAreaSize;
	IntensityValue[47] = TabletGradeData.ETC_SideFaceMultiTabletUnInspectionSize;

	IntensityValue[28] = TabletGradeData.side_Color_Dirty_Intensity;
	SizeValue[28] = PixelToMili(TabletGradeData.side_Color_Dirty_Size) * 10;

  IntensityValue[78] = TabletGradeData.side_Edge_Color_Dirty_Intensity;
	SizeValue[78] = PixelToMili(TabletGradeData.side_Edge_Color_Dirty_Size) * 10;

	IntensityValue[29] = TabletGradeData.threeDEdgeAreaExtend;

	SizeValue[12] = TabletGradeData.EngraveDistinguishGradeFor3D;

	SizeValue[30] = TabletGradeData.threeD_Height_Minus_Limit;
	SizeValue[31] = TabletGradeData.threeD_Height_Plus_Limit;

	IntensityValue[32] = TabletGradeData.Side_Edge_Neighbor_Intensity;
	SizeValue[32] = PixelToMili(TabletGradeData.Side_Edge_Neighbor_Defect_Size) * 10;

	IntensityValue[58] = TabletGradeData.Side_Edge_Dark_Intensity;
	SizeValue[58] = PixelToMili(TabletGradeData.Side_Edge_Dark_Defect_Size) * 10;

	IntensityValue[59] = TabletGradeData.Side_Edge_Bright_Intensity;
	SizeValue[59] = PixelToMili(TabletGradeData.Side_Edge_Bright_Defect_Size) * 10;

  IntensityValue[60] = TabletGradeData.Side_Edge_Neighbor_Break_Intensity;
  SizeValue[60] = PixelToMili(TabletGradeData.Side_Edge_Neighbor_Break_Size) * 10;
  ETC_Side_Break_Depth_Size = TabletGradeData.Side_Edge_Neighbor_Min_Break_Depth_Size;

	IntensityValue[34] = TabletGradeData.EngraveMatchingOrNotValue;

	IntensityValue[35] = TabletGradeData.DirtyGradeSensitivity;

	IntensityValue[37] = TabletGradeData.ETC_InterestedColor;
	IntensityValue[38] = TabletGradeData.ETC_ColorDirtyIgnoreLevel;

	IntensityValue[39] = TabletGradeData.ETC_ThreeDCenterSize;

	SizeValue[38] = PixelToMili(TabletGradeData.ETC_ColorDirtySize) * 10;

	IntensityValue[68] = TabletGradeData.dummy[0];
  
	IntensityValue[69] = TabletGradeData.ETC_PrintPositionDefectIntensity;
	
	IntensityValue[81] = TabletGradeData.LaserAllowX;
	IntensityValue[82] = TabletGradeData.LaserAllowY;
	IntensityValue[83] = TabletGradeData.LaserAllowDegree;
    

  if(ProductData.TabletShape == TABLET_SHAPE_OVAL ||
        ProductData.TabletShape == TABLET_SHAPE_OBLONG ||
        ProductData.TabletShape == TABLET_SHAPE_ETC)
  {
    IntensityValue[70] = TabletGradeData.ETC_PrintPositionRotationDefectIntensity;
  }
  else
  {
    IntensityValue[70] = 0;
  }

	if (TabletGradeData.Saturation_Erase_SW)
		CheckBox2->Checked = true;
	else
		CheckBox2->Checked = false;

  if(TabletGradeData.ETC_Side_None_Horizontality_Tablet)
    NoneHorizontalityTabletCheckBox->Checked = true;
  else
    NoneHorizontalityTabletCheckBox->Checked = false;

  if(TabletGradeData.ETC_Side_Split_Line_UnInspection_Area_Setting)
    SplitLineUnInspectionAreaSettingCheckBox->Checked = true;
  else
    SplitLineUnInspectionAreaSettingCheckBox->Checked = false;

	if(TabletGradeData.SideRemovalAlgorithm3DPassing)
		SideRemovalAlgorithm3DCheckBox->Checked = true;
	else
		SideRemovalAlgorithm3DCheckBox->Checked = false;
	
	if (TabletGradeData.ETC_AdjustPrintAreaSW)
		CheckBox3->Checked = true;
	else
		CheckBox3->Checked = false;

	if (TabletGradeData.ETC_FrontFaceEdgeInspectionSW)
		CheckBox5->Checked = true;
	else
		CheckBox5->Checked = false;

	if (TabletGradeData.ETC_AdjustUnalignedTabletAlgorithm)
		CheckBox6->Checked = true;
	else
		CheckBox6->Checked = false;


	if (TabletGradeData.EngravePositionDefectCheckSW)
		UnPrintDefectCheckBox->Checked = true;
	else
		UnPrintDefectCheckBox->Checked = false;

	if (TabletGradeData.ETC_ApplyColorDirtyIgnoreAlgorithm)
		ColorDefectPassAlgorithmCB->Checked = true;
	else
		ColorDefectPassAlgorithmCB->Checked = false;

  if (TabletGradeData.ETC_ActiveSideEdgeDefectCheck)
    SideEdgeDirtyCheckBox->Checked = true;
  else
    SideEdgeDirtyCheckBox->Checked = false;

	if (TabletGradeData.ETC_Partial3DPrintCheckSW)
		SpecialFunctionCheckBox->Checked = true;
	else
		SpecialFunctionCheckBox->Checked = false;

	if (TabletGradeData.ETC_RemoveBrightDotSW)
		CheckBox7->Checked = true;
	else
		CheckBox7->Checked = false;

	if (TabletGradeData.ETC_ApplyTiltTabletAlgorithm)
		CheckBox8->Checked = true;
	else
		CheckBox8->Checked = false;


  if(TabletGradeData.SplitLineMatchingSWForPrintTablet)
    FrontFaceSplitLineOptionCheckBox->Checked = true;
  else
    FrontFaceSplitLineOptionCheckBox->Checked = false;

  IntensityValue[67] = TabletGradeData.SplitLineMatchingThreshold;

	IntensityValue[51] = TabletGradeData.DarkSpotDefectIntensityGradeForMarvelingTablet;
	SizeValue[51] = PixelToMili(TabletGradeData.DarkSpotDefectSizeGradeForMarvelingTablet) * 10;
	IntensityValue[52] = TabletGradeData.BrightSpotDefectIntensityGradeForMarvelingTablet;
	SizeValue[52] = PixelToMili(TabletGradeData.BrightSpotDefectSizeGradeForMarvelingTablet) * 10;

	IntensityValue[53] = TabletGradeData.DarkStainDefectIntensityGradeForMarvelingTablet;
	SizeValue[53] = PixelToMili(TabletGradeData.DarkStainDefectSizeGradeForMarvelingTablet) * 10;
	IntensityValue[54] = TabletGradeData.BrightStainDefectIntensityGradeForMarvelingTablet;
	SizeValue[54] = PixelToMili(TabletGradeData.BrightStainDefectSizeGradeForMarvelingTablet) * 10;

	if (TabletGradeData.DirtyDefectCheckSWInNeighborPrint)
		DirtyDefectCheckInNeighborPrintCheckBox->Checked = true;
	else
		DirtyDefectCheckInNeighborPrintCheckBox->Checked = false;

	if (TabletGradeData.ETC_ApplyWhiteEngraveAlgorithm)
		WhiteEngraveMatchingCheckBox->Checked = true;
	else
		WhiteEngraveMatchingCheckBox->Checked = false;

  if (TabletGradeData.ETC_EngraveWhiteDefectCheckAlgorithm)
    EngraveWhiteDefectCheckBox->Checked = true;
  else
    EngraveWhiteDefectCheckBox->Checked = false;

  if(TabletGradeData.ETC_EnforcementStainDefectCheckAlgorithm)
    EnforcementStainDefectCheckAlgorithmCheckBox->Checked = true;
  else
    EnforcementStainDefectCheckAlgorithmCheckBox->Checked = false;

  if(TabletGradeData.ETC_EngraveMatchingOption_ReflectedTabletShape)
    Apply2DEngraveMatchingOption_LimitRange->Checked = true;
  else
    Apply2DEngraveMatchingOption_LimitRange->Checked = false;

  if(TabletGradeData.ETC_EngraveMatchingOption_LightEngrave)
    Apply2DEngraveMatchingOption_LightEngrave->Checked = true;
  else
    Apply2DEngraveMatchingOption_LightEngrave->Checked = false;

  if(TabletGradeData.ETC_CoatedTablet_ShapeCheck)
  {
    Apply3DShapeCheck->Checked = true;
  }
  else
  {
    Apply3DShapeCheck->Checked = false;
  }

  if(TabletGradeData.Side_Edge_Color_NoneInspection_Option)
  {
    SideEdgeColorNoneInspectionCheckBox->Checked = true;
  }
  else
  {
    SideEdgeColorNoneInspectionCheckBox->Checked = false;
  }

  IntensityValue[73] = TabletGradeData.ThreeD_CoatedTablet_ShapeError_Height;
	SizeValue[73] = PixelToMiliForThreeD(TabletGradeData.ThreeD_CoatedTablet_ShapeError_Size) * 10;

  IntensityValue[75] = TabletGradeData.ETC_PartialThreeDStampDefectIntensity;
  SizeValue[75] = PixelToMiliForThreeD(TabletGradeData.ETC_PartialThreeDStampDefectSize) * 10;

  IntensityValue[76] = TabletGradeData.ETC_SideEdgeDefectIntensity;
  SizeValue[76] = PixelToMiliForThreeD(TabletGradeData.ETC_SideEdgeDefectSize) * 10;

  IntensityValue[77] = TabletGradeData.ETC_TabletFrontFaceThreshold;

  IntensityValue[79] = TabletGradeData.LIMA_ThreeD_Side_EraseLevel;
  IntensityValue[80] = TabletGradeData.LIMA_ThreeD_MaxHeight;
  SizeValue[80] = PixelToMiliForThreeD(TabletGradeData.LIMA_ThreeD_OverHeightSize) * 10;
  IntensityValue[85] = TabletGradeData.BeltPowderSensitivity + 1;

	if (TabletGradeData.RemoveBeltActive)
		RemoveBeltActiveCheckBox->Checked = true;
	else
		RemoveBeltActiveCheckBox->Checked = false;

	if (TabletGradeData.EngravePrintMatching2DInActive)
		EngravePrintMatching2DInActiveCheckBox->Checked = true;
	else
		EngravePrintMatching2DInActiveCheckBox->Checked = false;
  	
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::BitBtn1Click(TObject *Sender)
{
	VariableToGradeData();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeButton1Click(TObject *Sender)
{
	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = true;
  Panel2->Height = 254;
  PrintGradePanel->Visible = false;

  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	StaticText1->Caption = GRADESETTING_TEXT_CAPTION_03;
	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = true;
	BitBtn14->Visible = true;
	ThreeDEngraveDefectPanel->Visible = false;
	GradeButton1->Font->Color = clRed;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
  SideBreakGradePanel->Visible = false;


	SelectedDefectN = 1;
	SelectedDefectN2 = 0;
	IntensityBarDisplay();
	SizeBarDisplay();
	DisplayTabletShapeData(FRONT_SHAPE, NOT_PRINT_AREA, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::GradeButton3Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clRed;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
  SideBreakGradePanel->Visible = false;
	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = true;
  Panel2->Height = 254;
  PrintGradePanel->Visible = false;

  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	StaticText1->Caption = GRADESETTING_TEXT_CAPTION_03;
	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = true;
	BitBtn14->Visible = true;


	SelectedDefectN = 3;
	SelectedDefectN2 = 0;
	IntensityBarDisplay();
	SizeBarDisplay();
	DisplayTabletShapeData(FRONT_SHAPE, NOT_PRINT_AREA, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeButton4Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clRed;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
  SideBreakGradePanel->Visible = false;
	Panel2->Visible = true;
  Panel2->Height = 254;
  PrintGradePanel->Visible = false;

  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	StaticText1->Caption = GRADESETTING_TEXT_CAPTION_03;
	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = true;
	BitBtn14->Visible = true;

	SelectedDefectN = 4;
	SelectedDefectN2 = 0;
	IntensityBarDisplay();
	SizeBarDisplay();
	DisplayTabletShapeData(FRONT_SHAPE, EDGE_AREA, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeButton5Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clRed;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
  SideBreakGradePanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = true;
  Panel2->Height = 254;
  PrintGradePanel->Visible = false;

  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	StaticText1->Caption = GRADESETTING_TEXT_CAPTION_03;
	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = true;
	BitBtn14->Visible = true;


	SelectedDefectN = 5;
	SelectedDefectN2 = 0;
	IntensityBarDisplay();
	SizeBarDisplay();
	DisplayTabletShapeData(FRONT_SHAPE, EDGE_AREA, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeButton6Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clRed;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	GradeBtnForMarvelTablet1->Font->Color = clMaroon;
	GradeBtnForMarvelTablet2->Font->Color = clMaroon;
	GradeBtnForMarvelTablet3->Font->Color = clMaroon;
  GradeBtnForMarvelTablet4->Font->Color = clMaroon;
	GradeBtnForMarvelTablet5->Font->Color = clMaroon;
	GradeBtnForMarvelTablet6->Font->Color = clMaroon;
	GradeBtnForMarvelTablet7->Font->Color = clMaroon;
	// end. ߰ Btn

	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
	GroupBox15->Visible = false;
	GroupBox8->Visible = true;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
	StaticText5->Caption = GRADESETTING_TEXT_CAPTION_02;
	Image5->Visible = false;
	Image6->Visible = false;
	Image7->Visible = false;
	Image8->Visible = false;

	StaticText5->Visible = false;
	StaticText6->Visible = false;
	BitBtn11->Visible = true;
	BitBtn12->Visible = true;

	GradeSettingPanelForMarvelingTablet1->Visible = false;
	GradeSettingPanelForMarvelingTablet2->Visible = false;
  StainDefectCheckPanel->Visible = false;
	SideBreakGradePanel->Visible = false;
	// end. űԷ 򰡵  г

	SelectedDefectN = 6;
	SelectedDefectN2 = 0;
	ThreeDSizeBarDisplay();
	ThreeDIntensityBarDisplay();
	DisplayTabletShapeData(FRONT_SHAPE, NOT_EDGE_AREA, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeButton7Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clRed;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	GradeBtnForMarvelTablet1->Font->Color = clMaroon;
	GradeBtnForMarvelTablet2->Font->Color = clMaroon;
	GradeBtnForMarvelTablet3->Font->Color = clMaroon;
  GradeBtnForMarvelTablet4->Font->Color = clMaroon;
	GradeBtnForMarvelTablet5->Font->Color = clMaroon;
	GradeBtnForMarvelTablet6->Font->Color = clMaroon;
	GradeBtnForMarvelTablet7->Font->Color = clMaroon;
	// end. ߰ Btn

	SideEdgeGradeSettingPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	ThreeDEngraveDefectPanel->Visible = false;
	GroupBox15->Visible = false;
	GroupBox8->Visible = true;
	StaticText5->Caption = GRADESETTING_TEXT_CAPTION_02;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;

	Image5->Visible = false;
	Image6->Visible = false;
	Image7->Visible = false;
	Image8->Visible = false;

	StaticText5->Visible = false;
	StaticText6->Visible = false;

	BitBtn11->Visible = false;
	BitBtn12->Visible = false;

	GradeSettingPanelForMarvelingTablet1->Visible = false;
	GradeSettingPanelForMarvelingTablet2->Visible = false;
  StainDefectCheckPanel->Visible = false;
	SideBreakGradePanel->Visible = false;
	// end. űԷ 򰡵  г

	SelectedDefectN = 7;
	SelectedDefectN2 = 0;
	ThreeDIntensityBarDisplay();
	ThreeDSizeBarDisplay();
	DisplayTabletShapeData(FRONT_SHAPE, EDGE_AREA, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeButton8Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clRed;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	GradeBtnForMarvelTablet1->Font->Color = clMaroon;
	GradeBtnForMarvelTablet2->Font->Color = clMaroon;
	GradeBtnForMarvelTablet3->Font->Color = clMaroon;
  GradeBtnForMarvelTablet4->Font->Color = clMaroon;
	GradeBtnForMarvelTablet5->Font->Color = clMaroon;
	GradeBtnForMarvelTablet6->Font->Color = clMaroon;
	GradeBtnForMarvelTablet7->Font->Color = clMaroon;
	// end. ߰ Btn

	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = true;
  Panel2->Height = 254;
  PrintGradePanel->Visible = false;

  WhiteEngraveDefectPanel->Visible = false;

	StaticText1->Caption = GRADESETTING_TEXT_CAPTION_03;

	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = true;
	BitBtn14->Visible = true;

	GradeSettingPanelForMarvelingTablet1->Visible = false;
	GradeSettingPanelForMarvelingTablet2->Visible = false;
  StainDefectCheckPanel->Visible = false;
	SideBreakGradePanel->Visible = false;
	// end. űԷ 򰡵  г

	SelectedDefectN = 8;
	SelectedDefectN2 = 0;
	IntensityBarDisplay();
	SizeBarDisplay();

	DisplayTabletShapeData(SIDE_SHAPE, 0, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeButton9Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clRed;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	GradeBtnForMarvelTablet1->Font->Color = clMaroon;
	GradeBtnForMarvelTablet2->Font->Color = clMaroon;
	GradeBtnForMarvelTablet3->Font->Color = clMaroon;
  GradeBtnForMarvelTablet4->Font->Color = clMaroon;
	GradeBtnForMarvelTablet5->Font->Color = clMaroon;
	GradeBtnForMarvelTablet6->Font->Color = clMaroon;
	GradeBtnForMarvelTablet7->Font->Color = clMaroon;
	// end. ߰ Btn

	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = true;
  Panel2->Height = 254;
  PrintGradePanel->Visible = false;

  WhiteEngraveDefectPanel->Visible = false;

	StaticText1->Caption = GRADESETTING_TEXT_CAPTION_03;
	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = true;
	BitBtn14->Visible = true;

	GradeSettingPanelForMarvelingTablet1->Visible = false;
	GradeSettingPanelForMarvelingTablet2->Visible = false;
  StainDefectCheckPanel->Visible = false;
	SideBreakGradePanel->Visible = false;
	// end. űԷ 򰡵  г

	SelectedDefectN = 9;
	SelectedDefectN2 = 0;
	IntensityBarDisplay();
	SizeBarDisplay();

	DisplayTabletShapeData(SIDE_SHAPE, 0, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------


void __fastcall TGradeSettingForm::GradeButton11Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clRed;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
  SideBreakGradePanel->Visible = false;
	Panel2->Visible = true;
  Panel2->Height = 254;
  PrintGradePanel->Visible = false;

  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	StaticText1->Caption = GRADESETTING_TEXT_CAPTION_05;

	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = false;
	BitBtn14->Visible = false;


	SelectedDefectN = 11;
	SelectedDefectN2 = 0;
	IntensityBarDisplay();

	DisplayTabletShapeData(FRONT_SHAPE, 0, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeButton13Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clRed;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
  SideBreakGradePanel->Visible = false;
	Panel2->Visible = true;
  Panel2->Height = 254;
  PrintGradePanel->Visible = false;

  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	StaticText1->Caption = GRADESETTING_TEXT_CAPTION_06;
	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = false;
	BitBtn14->Visible = false;


	SelectedDefectN = 13;
	SelectedDefectN2 = 0;
	IntensityBarDisplay();
	DisplayTabletShapeData(FRONT_SHAPE, PRINT_AREA, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeButton14Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clRed;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
  SideBreakGradePanel->Visible = false;
	Panel2->Visible = true;
  Panel2->Height = 254;
  PrintGradePanel->Visible = false;

  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	if (ProductData.EngraveType == ENGRAVE_TYPE_PRINT)
	{
		StaticText1->Caption = GRADESETTING_TEXT_CAPTION_04;
	}
	else
	{
		StaticText1->Caption = NEW_ADD_STRING_10;
	}
	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = false;
	BitBtn14->Visible = false;


	SelectedDefectN = 14;
	SelectedDefectN2 = 0;
	IntensityBarDisplay();
	DisplayTabletShapeData(FRONT_SHAPE, PRINT_AREA, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::ThreeDIntensityBarDisplay(void)
{
	Image5->Visible = true;
	Image7->Visible = true;
	StaticText5->Visible = true;

	Image7->Canvas->Brush->Style = bsSolid;
	Image7->Canvas->Brush->Color = clBlack;
	Image7->Canvas->Pen->Color = clBlack;
	Image7->Canvas->Rectangle(0, 0, Image7->Width, Image7->Height);

	Image7->Canvas->Brush->Style = bsSolid;
	Image7->Canvas->Brush->Color = (TColor)0x126596;
	Image7->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN] * 6, Image7->Height);
	Image7->Canvas->Font->Color = clBlack;
	Image7->Canvas->Font->Size = 10;
	Image7->Canvas->TextOutW(IntensityValue[SelectedDefectN] * 6 + 20, 15, FloatToStr((float)IntensityValue[SelectedDefectN] * 30.0 / 10.0 / 1000.0) + " mm");
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::IntensityBarDisplay(void)
{
	Image2->Visible = true;
	StaticText1->Visible = true;

  AnsiString grade;
  int textWidth;

  TLabel *tempLabel = new TLabel(this);
  tempLabel->Caption = "";
  tempLabel->Font = Image2->Canvas->Font;
  tempLabel->Font->Size = 10;
  tempLabel->Width = 0;

	Image2->Canvas->Brush->Style = bsSolid;
	Image2->Canvas->Brush->Color = clBlack;
	Image2->Canvas->Pen->Color = clBlack;
	Image2->Canvas->Rectangle(0, 0, Image2->Width, Image2->Height);

	if (SelectedDefectN != PRINT_ERASE_GRADE_NUM && SelectedDefectN != PRINT_SPREAD_GRADE_NUM && SelectedDefectN != 15)
	{
    grade = IntToStr(IntensityValue[SelectedDefectN]) + " Grade";
    tempLabel->Caption = grade;
    textWidth = tempLabel->Width + 4;

		Image2->Canvas->Brush->Style = bsSolid;
		Image2->Canvas->Brush->Color = (TColor)0x126596;
		Image2->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN] * (Image2->Width / 10), Image2->Height);
		Image2->Canvas->Font->Color = clBlack;
		Image2->Canvas->Font->Size = 10;
		Image2->Canvas->TextOutW(IntensityValue[SelectedDefectN] * (Image2->Width / 10) - textWidth, 20, grade);
	}
  else if (SelectedDefectN == PRINT_ERASE_GRADE_NUM)
	{
    float PrintDefectSize = DefectSizePixelToMili((IntensityValue[SelectedDefectN] + 1) * (IntensityValue[SelectedDefectN])) / 100.0;
    grade = FloatToStrF(PrintDefectSize, ffFixed, 10, 2) + " mm";
    tempLabel->Caption = grade;
    textWidth = tempLabel->Width + 4;

    Image2->Canvas->Brush->Style = bsSolid;
		Image2->Canvas->Brush->Color = (TColor)0x126596;
		Image2->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN] * (Image2->Width / 20), Image2->Height);
		Image2->Canvas->Font->Color = clBlack;
		Image2->Canvas->Font->Size = 10;
		Image2->Canvas->TextOutW(IntensityValue[SelectedDefectN] * (Image2->Width / 20) - textWidth, 20, grade);
	}
  else if (SelectedDefectN == PRINT_SPREAD_GRADE_NUM)
	{
    if(TabletCharacter.discriminationDisplay_kind == PRINT)
    {
      float PrintDefectSize = DefectSizePixelToMili((IntensityValue[SelectedDefectN] + 1) * (IntensityValue[SelectedDefectN])) / 100.0;
      grade = FloatToStrF(PrintDefectSize, ffFixed, 10, 2) + " mm";
    }
    else
    {
      grade = IntToStr(IntensityValue[SelectedDefectN]) + " Grade";
    }

    tempLabel->Caption = grade;
    textWidth = tempLabel->Width + 4;

    Image2->Canvas->Brush->Style = bsSolid;
		Image2->Canvas->Brush->Color = (TColor)0x126596;
		Image2->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN] * (Image2->Width / 20), Image2->Height);
		Image2->Canvas->Font->Color = clBlack;
		Image2->Canvas->Font->Size = 10;
		Image2->Canvas->TextOutW(IntensityValue[SelectedDefectN] * (Image2->Width / 20) - textWidth, 20, grade);
	}
	else
	{
    grade = IntToStr(IntensityValue[SelectedDefectN]) + " Grade";
    tempLabel->Caption = grade;
    textWidth = tempLabel->Width + 4;

		Image2->Canvas->Brush->Style = bsSolid;
		Image2->Canvas->Brush->Color = (TColor)0x126596;
		Image2->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN] * (Image2->Width / 20), Image2->Height);
		Image2->Canvas->Font->Color = clBlack;
		Image2->Canvas->Font->Size = 10;
		Image2->Canvas->TextOutW(IntensityValue[SelectedDefectN] * (Image2->Width / 20) - textWidth, 20, grade);
	}

  delete tempLabel;
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::IntensityBarDisplay_ETC(void)
{
	TntImage6->Visible = true;
	TntStaticText7->Visible = true;

	TntImage6->Canvas->Brush->Style = bsSolid;
	TntImage6->Canvas->Brush->Color = clBlack;
	TntImage6->Canvas->Pen->Color = clBlack;
	TntImage6->Canvas->Rectangle(0, 0, TntImage6->Width, TntImage6->Height);

	if (SelectedDefectN != 13 && SelectedDefectN != 14 && SelectedDefectN != 15)
	{
		TntImage6->Canvas->Brush->Style = bsSolid;
		TntImage6->Canvas->Brush->Color = (TColor)0x126596;
		TntImage6->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN] * (TntImage6->Width / 10), TntImage6->Height);
		TntImage6->Canvas->Font->Color = clBlack;
		TntImage6->Canvas->Font->Size = 10;
		TntImage6->Canvas->TextOutW(IntensityValue[SelectedDefectN] * (TntImage6->Width / 10) - TntImage6->Width / 10, 15, IntToStr(IntensityValue[SelectedDefectN]) + " Grade");
	}
	else
	{
		TntImage6->Canvas->Brush->Style = bsSolid;
		TntImage6->Canvas->Brush->Color = (TColor)0x126596;
		TntImage6->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN] * (TntImage6->Width / 20), TntImage6->Height);
		TntImage6->Canvas->Font->Color = clBlack;
		TntImage6->Canvas->Font->Size = 10;
		TntImage6->Canvas->TextOutW(IntensityValue[SelectedDefectN] * (TntImage6->Width / 20) - TntImage6->Width / 20, 15, IntToStr(IntensityValue[SelectedDefectN]) + " Grade");
	}
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::SideEdgeNeighborIntensityBarDisplay(void)
{
	SideIntensityImage1->Visible = true;

	SideIntensityImage1->Canvas->Brush->Style = bsSolid;
	SideIntensityImage1->Canvas->Brush->Color = clBlack;
	SideIntensityImage1->Canvas->Pen->Color = clBlack;
	SideIntensityImage1->Canvas->Rectangle(0, 0, SideIntensityImage1->Width, SideIntensityImage1->Height);

	SideIntensityImage1->Canvas->Brush->Style = bsSolid;
	SideIntensityImage1->Canvas->Brush->Color = (TColor)0x126596;
	SideIntensityImage1->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN] * (SideIntensityImage1->Width / 10), SideIntensityImage1->Height);
	SideIntensityImage1->Canvas->Font->Color = clBlack;
	SideIntensityImage1->Canvas->Font->Size = 10;
	SideIntensityImage1->Canvas->TextOutW(IntensityValue[SelectedDefectN] * (SideIntensityImage1->Width / 10) - SideIntensityImage1->Width / 10, 15, IntToStr(IntensityValue[SelectedDefectN]) + " Grade");
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::SideEdgeNeighborSizeBarDisplay(void)
{
	TntImage7->Visible = true;
	SideDefectSizeImage->Visible = true;

	SideDefectSizeImage->Canvas->Brush->Style = bsSolid;
	SideDefectSizeImage->Canvas->Brush->Color = clBlack;
	SideDefectSizeImage->Canvas->Pen->Color = clBlack;
	SideDefectSizeImage->Canvas->Rectangle(0, 0, SideDefectSizeImage->Width, SideDefectSizeImage->Height);

	SideDefectSizeImage->Canvas->Brush->Style = bsSolid;
	SideDefectSizeImage->Canvas->Brush->Color = (TColor)0x656596;
	SideDefectSizeImage->Canvas->Rectangle(0, 0, SizeValue[SelectedDefectN] / 10 * 3, SideDefectSizeImage->Height);
	SideDefectSizeImage->Canvas->Font->Color = clBlack;
	SideDefectSizeImage->Canvas->Font->Size = 10;
	SideDefectSizeImage->Canvas->TextOutW(SizeValue[SelectedDefectN] / 10 * 3 + 10, 15, FloatToStr((float)SizeValue[SelectedDefectN] / 1000.0) + " mm");
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::IntensityBarDisplayForThreeD(void)
{
	ThreeDEngraveDefectPanel->Visible = true;

	TntImage3->Canvas->Brush->Style = bsSolid;
	TntImage3->Canvas->Brush->Color = clBlack;
	TntImage3->Canvas->Pen->Color = clBlack;
	TntImage3->Canvas->Rectangle(0, 0, TntImage3->Width, TntImage3->Height);

	TntImage2->Canvas->Brush->Style = bsSolid;
	TntImage2->Canvas->Brush->Color = clBlack;
	TntImage2->Canvas->Pen->Color = clBlack;
	TntImage2->Canvas->Rectangle(0, 0, TntImage2->Width, TntImage2->Height);

	TntImage3->Canvas->Brush->Style = bsSolid;
	TntImage3->Canvas->Brush->Color = (TColor)0x126596;
	TntImage3->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN] * (TntImage3->Width / 100), TntImage3->Height);
	TntImage3->Canvas->Font->Color = clBlack;

	TntImage2->Canvas->Brush->Style = bsSolid;
	TntImage2->Canvas->Brush->Color = (TColor)0x126596;
	TntImage2->Canvas->Rectangle(0, 0, SizeValue[SelectedDefectN] * (TntImage2->Width / 10), TntImage2->Height);
	TntImage2->Canvas->Font->Color = clBlack;
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::SizeBarDisplay(void)
{
	Image3->Visible = true;
	Image4->Visible = true;
	StaticText2->Visible = true;
	StaticText4->Visible = true;

	Image3->Canvas->Brush->Style = bsSolid;
	Image3->Canvas->Brush->Color = clBlack;
	Image3->Canvas->Pen->Color = clBlack;
	Image3->Canvas->Rectangle(0, 0, Image3->Width, Image3->Height);

	Image3->Canvas->Brush->Style = bsSolid;
	Image3->Canvas->Brush->Color = (TColor)0x656596;
	Image3->Canvas->Rectangle(0, 0, SizeValue[SelectedDefectN] / 10 * 3, Image3->Height);
	Image3->Canvas->Font->Color = clBlack;
	Image3->Canvas->Font->Size = 10;
	Image3->Canvas->TextOutW(SizeValue[SelectedDefectN] / 10 * 3 + 10, 15, FloatToStr((float)SizeValue[SelectedDefectN] / 1000.0) + " mm");
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::SizeBarDisplay_ETC(void)
{
	TntImage8->Visible = true;
	TntImage9->Visible = true;
	TntStaticText8->Visible = true;
	TntStaticText9->Visible = true;

	TntImage8->Canvas->Brush->Style = bsSolid;
	TntImage8->Canvas->Brush->Color = clBlack;
	TntImage8->Canvas->Pen->Color = clBlack;
	TntImage8->Canvas->Rectangle(0, 0, TntImage8->Width, TntImage8->Height);

	TntImage8->Canvas->Brush->Style = bsSolid;
	TntImage8->Canvas->Brush->Color = (TColor)0x656596;
	TntImage8->Canvas->Rectangle(0, 0, SizeValue[SelectedDefectN] / 10 * 3, TntImage8->Height);
	TntImage8->Canvas->Font->Color = clBlack;
	TntImage8->Canvas->Font->Size = 10;
	TntImage8->Canvas->TextOutW(SizeValue[SelectedDefectN] / 10 * 3 + 10, 15, FloatToStr((float)SizeValue[SelectedDefectN] / 1000.0) + " mm");
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::HeightBarDisplay(void)
{
	Image10->Canvas->Brush->Style = bsSolid;
	Image10->Canvas->Brush->Color = clWhite;
	Image10->Canvas->Rectangle(0, 0, Image10->Width, Image10->Height);

	Image10->Canvas->Brush->Style = bsSolid;


	Image10->Canvas->Brush->Color = clBlue;
	Image10->Canvas->Rectangle(300 - SizeValue[30] * 10, 0, 300, Image8->Height);
	Image10->Canvas->Brush->Color = clRed;
	Image10->Canvas->Rectangle(300, 0, SizeValue[31] * 10 + 300, Image8->Height);

	Image10->Canvas->Brush->Color = clBlue;
	Image10->Canvas->Font->Color = clWhite;
	Image10->Canvas->Font->Size = 10;
	Image10->Canvas->TextOutW(300 - SizeValue[30] * 10, 15, FloatToStr(-(float)SizeValue[30] * 30 / 1000.0) + " mm");

	Image10->Canvas->Brush->Color = clRed;
	Image10->Canvas->Font->Color = clWhite;
	Image10->Canvas->Font->Size = 10;
	Image10->Canvas->TextOutW(300 + SizeValue[31] * 10, 15, FloatToStr((float)SizeValue[31] * 30 / 1000.0) + " mm");

}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::ThreeDSizeBarDisplay(void)
{
	Image6->Visible = true;
	Image8->Visible = true;
	StaticText6->Visible = true;
	//    StaticText4->Visible = true;

	Image8->Canvas->Brush->Style = bsSolid;
	Image8->Canvas->Brush->Color = clBlack;
	Image8->Canvas->Pen->Color = clBlack;
	Image8->Canvas->Rectangle(0, 0, Image8->Width, Image8->Height);

	Image8->Canvas->Brush->Style = bsSolid;
	Image8->Canvas->Brush->Color = (TColor)0x656596;
	Image8->Canvas->Rectangle(0, 0, SizeValue[SelectedDefectN] / 10 * 3, Image8->Height);
	Image8->Canvas->Font->Color = clBlack;
	Image8->Canvas->Font->Size = 10;
	Image8->Canvas->TextOutW(SizeValue[SelectedDefectN] / 10 * 3 + 10, 15, FloatToStr((float)SizeValue[SelectedDefectN] / 1000.0) + " mm");
}


void __fastcall TGradeSettingForm::Image3MouseDown(TObject *Sender,
	TMouseButton Button, TShiftState Shift, int X, int Y)
{
	SizeValue[SelectedDefectN] = X / 3 * 10;
	SizeBarDisplay();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::SetGradeData(TTabletGradeData *tabletGradeData)
{
	TabletGradeData = *tabletGradeData;
  prevTabletGradeData = *tabletGradeData;
	GradeDataToVariable();
	DisplayTabletShapeData(FRONT_SHAPE, 0, DISPLAY_FRONT);
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::GetGradeData(TTabletGradeData *tabletGradeData)
{
	*tabletGradeData = TabletGradeData;
}
//---------------------------------------------------------------------------


void __fastcall TGradeSettingForm::CheckBox1Click(TObject *Sender)
{
	if (CheckBox1->Checked == true)
	{
		TabletGradeData.frontBorderIsSW = 1;
	}
	else
	{
		TabletGradeData.frontBorderIsSW = 0;
	}

}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::CheckBox2Click(TObject *Sender)
{
	TntPanel4->Visible = false;
	SideBreakGradePanel->Visible = false;
	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	if (CheckBox2->Checked == true)
	{
		TabletGradeData.Saturation_Erase_SW = 1;
	}
	else
	{
		TabletGradeData.Saturation_Erase_SW = 0;
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TrackBar1Change(TObject *Sender)
{
	int value;
	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
	SideBreakGradePanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;

  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;
	IntensityValue[26] = TrackBar1->Position;
	DisplayEachGradeValue();
	DisplayNotInspectionAera(FRONT_SHAPE, NOTHING);
                          
	/*    TabletGradeData.FrontEdgeAreaExtendSW = value;
	Label26->Caption  = FloatToStr(value*40.0/1000.0) + " mm";

	*/
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeButton2Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clRed;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;
  SideBreakGradePanel->Visible = false;
	GroupBox15->Visible = false;
	GroupBox8->Visible = false;

  if(TabletCharacter.discriminationDisplay_kind == PRINT)
  {
    Panel2->Visible = false;
    PrintGradePanel->Visible = true;

    PrintIntensityBarDisplay();
  }
  else
  {
    Panel2->Visible = true;
    Panel2->Height = 111;

    PrintGradePanel->Visible = false;
  }

  if(TabletGradeData.ETC_EngraveWhiteDefectCheckAlgorithm)
  {
    WhiteEngraveDefectPanel->Visible = true;
  }
  else
  {
    WhiteEngraveDefectPanel->Visible = false;
  }

  StaticText1->Caption = GRADESETTING_ETC_CAPTION_40;
  
	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = false;
	BitBtn14->Visible = false;

	SelectedDefectN = 2;
	SelectedDefectN2 = 0;
	IntensityBarDisplay();
  EngraveColorIntensityImageDisplay();
  EngraveWhiteSpotIntensityImageDisplay();
  WhiteSpotSizeImageDisplay();
  
	DisplayTabletShapeData(FRONT_SHAPE, PRINT_AREA, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::BitBtn2Click(TObject *Sender)
{
	for (int m = 0; m < 100; m++)
	{
		IntensityValue[m] = 1;
	}
	for (int m = 0; m < 100; m++)
	{
		SizeValue[m] = 10;
	}

	TabletGradeData.frontShapeEdgeNeighborRange = 11;
	//////////////////////////////////////////////////////////////
	TabletGradeData.front_dirty_Intensity = 2;
	TabletGradeData.front_dirty_Size = 13;
	TabletGradeData.front_stain_Intensity = 5;
	TabletGradeData.front_stain_Size = 35;
	TabletGradeData.front_edge_dirty_Intensity = 2;
	TabletGradeData.front_edge_dirty_Size = 10;
	TabletGradeData.front_edge_Intensity = 5;
	TabletGradeData.front_edge_Size = 40;
	/////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////

	TabletGradeData.option_front_edgeBreaking_Intensity_Type1 = 50;
	TabletGradeData.option_front_edgeBreaking_Size_Type1 = 22;

  TabletGradeData.option_front_edgeBreaking_Intensity_Type2 = 50;
	TabletGradeData.option_front_edgeBreaking_Size_Type2 = 22;

	TabletGradeData.option_Breaking_Intensity = 22;
	TabletGradeData.option_PrintMark_Intensity = 20;
	TabletGradeData.option_Breaking_Size = 90;
	////////////////////////////////////////////////////////
	TabletGradeData.front_Color_Dirty_Intensity = 6;

	TabletGradeData.front_unInspectionIntensity_ForPrint = 0;
	TabletGradeData.front_unInspectionIntensity_ForEdge = 0;
	TabletGradeData.front_unInspectionIntensity_ForOptionPrint = 0;
	TabletGradeData.front_unInspectionIntensity_ForOptionEdge = 0;
	TabletGradeData.side_Edge_Top_Neighbor_Intensity = 0;
	TabletGradeData.side_Edge_Bottom_Neighbor_Intensity = 2;
	////////////////////////////////////////////////////////
	TabletGradeData.SideFaceEdgeAreaSize = 6;
	TabletGradeData.SideFaceEdgeUnInsAreaSize = 2;

  TabletGradeData.side_Edge_Color_Dirty_Intensity = 6;
	TabletGradeData.side_Edge_Color_Dirty_Size = 35;  

	TabletGradeData.rear_stain_Intensity = 5;
	TabletGradeData.rear_stain_Size = 35;
	TabletGradeData.rear_dirty_Intensity = 2;
	TabletGradeData.rear_dirty_Size = 13;
	TabletGradeData.rear_edge_dirty_Intensity = 2;
	TabletGradeData.rear_edge_dirty_Size = 10;
	TabletGradeData.rear_edge_Intensity = 5;
	TabletGradeData.rear_edge_Size = 40;
	TabletGradeData.rear_Color_Dirty_Intensity = 2;
	TabletGradeData.rear_Color_Dirty_Size = 35;
	TabletGradeData.rear_print_dirty_Inetensity = 3;
	////////////////////////////////////////////////////////////////
	////////////////////////////////////////////////////////////////
	TabletGradeData.side_dirty_Intensity = 4;
	TabletGradeData.side_dirty_Size = 12;
	TabletGradeData.side_stain_Intensity = 4;
	TabletGradeData.side_stain_Size = 35;
	TabletGradeData.side_height_Intensity = 2;

	TabletGradeData.EngraveDistinguishGradeFor3D = 2;

	TabletGradeData.front_color_Intensity = 3;
	TabletGradeData.frontBorderIsSW = 0;
	TabletGradeData.frontSmallSizeGrade = 2;
	TabletGradeData.sideShapeEdgeMaskRange = 1;
	TabletGradeData.FrontEdgeAreaExtendSW = 0;
  TabletGradeData.CoatedTablet_SideInspectionAreaSize = 10;

	if (ProductData.PlateTablet)
		TabletGradeData.threeDEdgeAreaExtend = 3;
	else
		TabletGradeData.threeDEdgeAreaExtend = 0;

	/////////////////////////////////////////////////////////
	TabletGradeData.front_print_dirty_Inetensity = 6;
  TabletGradeData.front_print_dirty_Inetensity2 = 15;

	if (TabletCharacter.discriminationDisplay_kind == STAMP)
		TabletGradeData.front_print_erase_Intensity = 20;
	else
		TabletGradeData.front_print_erase_Intensity = 5;

	TabletGradeData.front_print_spread_Intensity = 5;
	TabletGradeData.EngraveDistinguishGrade = 2;
	TabletGradeData.threeD_Height_Plus_Limit = 7;
	TabletGradeData.threeD_Height_Minus_Limit = 7;

  TabletGradeData.Saturation_Erase_SW = 0;

  TabletGradeData.ETC_Side_None_Horizontality_Tablet = 0;
  TabletGradeData.ETC_Side_Split_Line_UnInspection_Area_Setting = 0;

	if (TabletCharacter.discriminationDisplay_kind == PRINT)
		TabletGradeData.EngravePositionDefectCheckSW = 1;
	else
		TabletGradeData.EngravePositionDefectCheckSW = 0;

	// 2017-10-30 default enable · д
	TabletGradeData.EngravePositionDefectCheckSW = 1;

	if (PCProgramOption.HIprogram)
		TabletGradeData.EngravePositionDefectCheckSW = 1;

	TabletGradeData.Side_Edge_Neighbor_Intensity = 4;
	TabletGradeData.Side_Edge_Neighbor_Defect_Size = 20;

	TabletGradeData.Side_Edge_Dark_Intensity = 5;
	TabletGradeData.Side_Edge_Dark_Defect_Size = 60;

	TabletGradeData.Side_Edge_Bright_Intensity = 5;
	TabletGradeData.Side_Edge_Bright_Defect_Size = 20;

  TabletGradeData.Side_Edge_Neighbor_Break_Intensity = 5;
  TabletGradeData.Side_Edge_Neighbor_Break_Size = 40;
  TabletGradeData.Side_Edge_Neighbor_Min_Break_Depth_Size = 3;

	TabletGradeData.EngraveMatchingOrNotValue = 0;
	TabletGradeData.DirtyGradeSensitivity = GRADE_SENSITIVITY_NORMAL;

  TabletGradeData.SplitLineMatchingSWForPrintTablet = 0;
  TabletGradeData.SplitLineMatchingThreshold = 10;

	TabletGradeData.ETC_ApplyColorDirtyIgnoreAlgorithm = 0; //  
  TabletGradeData.ETC_ActiveSideEdgeDefectCheck = 0;
	TabletGradeData.ETC_InterestedColor = 2; // RED Color
	TabletGradeData.ETC_ColorDirtyIgnoreLevel = 20;
	TabletGradeData.ETC_AdjustPrintAreaSW = 0;
	TabletGradeData.ETC_ColorDirtySize = 75;
	TabletGradeData.ETC_ThreeDCenterSize = 0;

  TabletGradeData.dummy[0] = 0;
  TabletGradeData.ETC_PrintPositionDefectIntensity = 0;
  TabletGradeData.ETC_PrintPositionRotationDefectIntensity = 0;

	TabletGradeData.ETC_FrontFaceEdgeInspectionSW = 0;

	TabletGradeData.ETC_Partial3DPrintCheckSW = 0;

	TabletGradeData.ETC_RemoveBrightDotSW = 0;
	TabletGradeData.ETC_ApplyTiltTabletAlgorithm = 0;

	TabletGradeData.ETC_SideFaceMultiTabletUnInspectionSize = 0;

	TabletGradeData.DarkSpotDefectIntensityGradeForMarvelingTablet = 4;
	TabletGradeData.DarkSpotDefectSizeGradeForMarvelingTablet = 100;
	TabletGradeData.BrightSpotDefectIntensityGradeForMarvelingTablet = 4;
	TabletGradeData.BrightSpotDefectSizeGradeForMarvelingTablet = 100;

	TabletGradeData.DarkStainDefectIntensityGradeForMarvelingTablet = 6;
	TabletGradeData.DarkStainDefectSizeGradeForMarvelingTablet = 250;
	TabletGradeData.BrightStainDefectIntensityGradeForMarvelingTablet = 6;
	TabletGradeData.BrightStainDefectSizeGradeForMarvelingTablet = 250;

	TabletGradeData.DirtyDefectCheckSWInNeighborPrint = 0;

  TabletGradeData.ETC_EnforcementStainDefectCheckAlgorithm = 0;
  TabletGradeData.ETC_EngraveWhiteDefectCheckAlgorithm = 0;
  TabletGradeData.FrontFaceEngraveColorGrade = 10;

  TabletGradeData.FrontFaceEngraveWhiteSpotIntensity = 10;
  TabletGradeData.FrontFaceEngraveWhiteSpotSize = 100;

  TabletGradeData.EnforcementStainDefectInspectionAreaSize = 50;
  TabletGradeData.EnforcementStainDefectThreshold = 10;
  TabletGradeData.EnforcementStainDefectMaxLabelSize = 100;
  TabletGradeData.EnforcementStainDefectAllGroupSize = 200;

	TabletGradeData.ETC_ApplyWhiteEngraveAlgorithm = 0;

  TabletGradeData.ETC_EngraveMatchingOption_ReflectedTabletShape = 0;
  TabletGradeData.ETC_EngraveMatchingOption_LightEngrave = 0;

  TabletGradeData.ETC_ThreeD_DiffShapeTabletSW = 0;

  TabletGradeData.ThreeD_CoatedTablet_ShapeError_Height = 40;
	TabletGradeData.ThreeD_CoatedTablet_ShapeError_Size = 200;

  TabletGradeData.ETC_CoatedTablet_ShapeCheck = 0;

  TabletGradeData.ETC_PartialThreeDStampDefectIntensity = 2;
  TabletGradeData.ETC_PartialThreeDStampDefectSize = 200;

  TabletGradeData.ETC_SideEdgeDefectIntensity = 40;
  TabletGradeData.ETC_SideEdgeDefectSize = 200;

  TabletGradeData.ETC_TabletFrontFaceThreshold = 0;

  TabletGradeData.LIMA_ThreeD_Side_EraseLevel = 0;
  TabletGradeData.LIMA_ThreeD_MaxHeight = 0;
  TabletGradeData.LIMA_ThreeD_OverHeightSize = 40;
  TabletGradeData.LaserAllowX = 0;
  TabletGradeData.LaserAllowY = 0;
  TabletGradeData.LaserAllowDegree = 0;

	if (!ReadSetupData(&TabletSetupData))
	{
		ShowMessageW(GRADESETTING_MSG_01);
	}
	AnsiString studyFileName = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\" + ProductData.ProductCode + ".stu";
	if (!LoadStudyData(studyFileName, TabletStudyData))
	{
		ShowMessageW(GRADESETTING_MSG_02);
	}
	if (!ReadGradeData(&TabletGradeData))
	{
		ShowMessageW(GRADESETTING_MSG_03);
	}

  if(bUserMakingGradeData)
  {
    TabletGradeData = prevTabletGradeData;
  }

	GradeDataToVariable();

	DisplayTabletShapeData(FRONT_SHAPE, 0, DISPLAY_FRONT);
	DisplayEachGradeValue();

  if (TabletCharacter.MarvelingTablet)
  {
    GradeBtnForMarvelTablet1->Click();
    GradeBtnForMarvelTablet1->Down = true;
  }
  else
  {
	  GradeButton1->Click();
	  GradeButton1->Down = true;
  }

  if(TabletGradeData.ETC_EnforcementStainDefectCheckAlgorithm)
  {
    TabletCoatingDefectCheckGroupBox->Visible = true;
  }
  else
  {
    TabletCoatingDefectCheckGroupBox->Visible = false;
  }

}
//---------------------------------------------------------------------------



void __fastcall TGradeSettingForm::GradeButton12Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clRed;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	GradeBtnForMarvelTablet1->Font->Color = clMaroon;
	GradeBtnForMarvelTablet2->Font->Color = clMaroon;
	GradeBtnForMarvelTablet3->Font->Color = clMaroon;
  GradeBtnForMarvelTablet4->Font->Color = clMaroon;
	GradeBtnForMarvelTablet5->Font->Color = clMaroon;
	GradeBtnForMarvelTablet6->Font->Color = clMaroon;
	GradeBtnForMarvelTablet7->Font->Color = clMaroon;
	// end. ߰ Btn

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;

  WhiteEngraveDefectPanel->Visible = false;

	ThreeDEngraveDefectPanel->Visible = true;
	StaticText1->Caption = GRADESETTING_TEXT_CAPTION_06;
	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = false;
	BitBtn14->Visible = false;

	GradeSettingPanelForMarvelingTablet1->Visible = false;
	GradeSettingPanelForMarvelingTablet2->Visible = false;
  StainDefectCheckPanel->Visible = false;
	SideBreakGradePanel->Visible = false;
	// end. űԷ 򰡵  г

	SelectedDefectN = 12;
	SelectedDefectN2 = 0;

	IntensityBarDisplayForThreeD();

	DisplayTabletShapeData(FRONT_SHAPE, PRINT_AREA, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::Image8MouseDown(TObject *Sender,
	TMouseButton Button, TShiftState Shift, int X, int Y)
{
	SizeValue[SelectedDefectN] = X / 3 * 10;
	ThreeDSizeBarDisplay();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------



void __fastcall TGradeSettingForm::Image7MouseDown(TObject *Sender,
	TMouseButton Button, TShiftState Shift, int X, int Y)
{

	if (SelectedDefectN == 6)
		IntensityValue[SelectedDefectN] = X / 6;
	else
		IntensityValue[SelectedDefectN] = X / 6 / 10 * 10;

	ThreeDIntensityBarDisplay();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeButton15Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clRed;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
  SideBreakGradePanel->Visible = false;
  StainDefectCheckPanel->Visible = false;
	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = true;
  Panel2->Height = 254;
  PrintGradePanel->Visible = false;

  WhiteEngraveDefectPanel->Visible = false;

	StaticText1->Caption = GRADESETTING_TEXT_CAPTION_05;
	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = true;
	BitBtn14->Visible = true;

	SelectedDefectN = 15;
	SelectedDefectN2 = 0;
	IntensityBarDisplay();
	SizeBarDisplay();
	DisplayTabletShapeData(FRONT_SHAPE, NOT_EDGE_AREA, DISPLAY_FRONT);

  if(TabletGradeData.DefectSearchForColorDirtyOption)
  {
    Panel2->Height = 493;
    ColorDirtyOptionPanel->Visible = true;

    if(TabletGradeData.DefectSearchForColorDirtyOption == true)
    {
      DefectSearchForColorDirtyOptOffsetEdit->Text = FloatToStr(TabletGradeData.DefectSearchForColorDirtyOptOffset);
    }
  }
  else
  {
    Panel2->Height = 254;
    ColorDirtyOptionPanel->Visible = false;    
  }
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::FormCreate(TObject *Sender)
{
	if (ProductData.TabletType == TABLET_TYPE_SUGAR_COATED)
	{
		GradeButton29->Visible = false;
		TntPanel1->Visible = false;

    GradeButton31->Visible = false;
    TntPanel26->Visible = false;

    GradeButton30->Visible = false;
    TntPanel29->Visible = false;

    GradeButton28->Top = 148;
    Panel27->Top = 148;
	}
	else
	{
		GradeButton29->Visible = true;
		TntPanel1->Visible = true;

    GradeButton31->Visible = true;
    TntPanel26->Visible = true;

    GradeButton30->Visible = true;
    TntPanel29->Visible = true;

    GradeButton28->Top = 331;
    Panel27->Top = 331;
	}

  bMousedown = false;
  StampErrorSettingOptionPanel->DoubleBuffered = true;
  LIMAPreviewGroupbox->DoubleBuffered = true;
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::BitBtn4Click(TObject *Sender)
{
	TntBitBtn3->Visible = true;
	TntBitBtn4->Visible = true;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;

	TntPanel4->Visible = true;
	TntPanel4->BringToFront();

	TntStaticText7->Caption = GRADESETTING_TEXT_CAPTION_03;
	TntImage6->Visible = false;
	TntImage8->Visible = false;
	TntImage9->Visible = false;
	TntStaticText7->Visible = false;
	TntStaticText8->Visible = false;
	TntStaticText9->Visible = false;

	SelectedDefectN = 16;
	IntensityBarDisplay_ETC();
	SizeBarDisplay_ETC();
	DisplayTabletShapeData(FRONT_SHAPE, NOT_PRINT_AREA, DISPLAY_REAR);

}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::BitBtn5Click(TObject *Sender)
{
	TntBitBtn3->Visible = false;
	TntBitBtn4->Visible = false;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;

	TntPanel4->Visible = true;
	TntPanel4->BringToFront();

	TntStaticText7->Caption = GRADESETTING_TEXT_CAPTION_03;
	TntImage6->Visible = false;
	TntImage8->Visible = false;
	TntImage9->Visible = false;
	TntStaticText7->Visible = false;
	TntStaticText8->Visible = false;
	TntStaticText9->Visible = false;

	SelectedDefectN = 17;
	IntensityBarDisplay_ETC();
	DisplayTabletShapeData(FRONT_SHAPE, PRINT_AREA, DISPLAY_REAR);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::BitBtn6Click(TObject *Sender)
{
	TntBitBtn3->Visible = true;
	TntBitBtn4->Visible = true;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;

	TntPanel4->Visible = true;
	TntPanel4->BringToFront();

	TntStaticText7->Caption = GRADESETTING_TEXT_CAPTION_03;
	TntImage6->Visible = false;
	TntImage8->Visible = false;
	TntImage9->Visible = false;
	TntStaticText7->Visible = false;
	TntStaticText8->Visible = false;
	TntStaticText9->Visible = false;

	SelectedDefectN = 18;
	IntensityBarDisplay_ETC();
	SizeBarDisplay_ETC();
	DisplayTabletShapeData(FRONT_SHAPE, EDGE_AREA, DISPLAY_REAR);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::BitBtn7Click(TObject *Sender)
{
	TntBitBtn3->Visible = true;
	TntBitBtn4->Visible = true;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;

	TntPanel4->Visible = true;
	TntPanel4->BringToFront();

	TntStaticText7->Caption = GRADESETTING_TEXT_CAPTION_03;
	TntImage6->Visible = false;
	TntImage8->Visible = false;
	TntImage9->Visible = false;
	TntStaticText7->Visible = false;
	TntStaticText8->Visible = false;
	TntStaticText9->Visible = false;

	SelectedDefectN = 19;
	IntensityBarDisplay_ETC();
	SizeBarDisplay_ETC();
	DisplayTabletShapeData(FRONT_SHAPE, NOT_PRINT_AREA, DISPLAY_REAR);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::BitBtn8Click(TObject *Sender)
{
	TntBitBtn3->Visible = true;
	TntBitBtn4->Visible = true;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;

	TntPanel4->Visible = true;
	TntPanel4->BringToFront();

	TntStaticText7->Caption = GRADESETTING_TEXT_CAPTION_03;

	TntImage6->Visible = false;
	TntImage8->Visible = false;
	TntImage9->Visible = false;
	TntStaticText7->Visible = false;
	TntStaticText8->Visible = false;
	TntStaticText9->Visible = false;

	SelectedDefectN = 20;
	IntensityBarDisplay_ETC();
	SizeBarDisplay_ETC();

	DisplayTabletShapeData(FRONT_SHAPE, EDGE_AREA, DISPLAY_REAR);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::BitBtn9Click(TObject *Sender)
{
	TntBitBtn3->Visible = true;
	TntBitBtn4->Visible = true;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;

	TntPanel4->Visible = true;
	TntPanel4->BringToFront();

	TntStaticText7->Caption = GRADESETTING_TEXT_CAPTION_05;

	TntImage6->Visible = false;
	TntImage8->Visible = false;
	TntImage9->Visible = false;
	TntStaticText7->Visible = false;
	TntStaticText8->Visible = false;
	TntStaticText9->Visible = false;

	SelectedDefectN = 21;
	IntensityBarDisplay_ETC();
	SizeBarDisplay_ETC();

	DisplayTabletShapeData(FRONT_SHAPE, NOT_EDGE_AREA, DISPLAY_REAR);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::ScrollBar1Change(TObject *Sender)
{
	SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;

	IntensityValue[22] = ScrollBar1->Position;
	DisplayEachGradeValue();
	DisplayNotInspectionAera(FRONT_SHAPE, PRINT_AREA);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::ScrollBar2Change(TObject *Sender)
{
	SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;
	IntensityValue[23] = ScrollBar2->Position;
	DisplayEachGradeValue();
	DisplayNotInspectionAera(FRONT_SHAPE, EDGE_AREA);

}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::ScrollBar3Change(TObject *Sender)
{
	SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;
	IntensityValue[24] = ScrollBar3->Position;
	DisplayEachGradeValue();
	DisplayNotInspectionAera(FRONT_SHAPE, THREED_PRINT_AREA);

}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::ScrollBar4Change(TObject *Sender)
{
	SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;
	IntensityValue[25] = ScrollBar4->Position;
	DisplayEachGradeValue();
	DisplayNotInspectionAera(FRONT_SHAPE, THREED_EDGE_AREA);

}
//---------------------------------------------------------------------------


void __fastcall TGradeSettingForm::ScrollBar5Change(TObject *Sender)
{
	SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;
	IntensityValue[10] = ScrollBar5->Position;
	DisplayEachGradeValue();
	DisplayNotInspectionAera(SIDE_SHAPE, EDGE_AREA);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::BitBtn10Click(TObject *Sender)
{
	if (TabletCharacter.MarvelingTablet)
	{
		FrontFaceGradeGroupBoxForMarvelingTablet->Visible = true;
		FrontFaceGradeGroupBox->Visible = false;
	}
	else
	{
		FrontFaceGradeGroupBoxForMarvelingTablet->Visible = false;
		FrontFaceGradeGroupBox->Visible = true;
	}

	GroupBox2->Visible = true;
	GroupBox3->Visible = true;
	GroupBox12->Visible = true;
	Panel1->Visible = true;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;
	BitBtn1->Visible = true;
	BitBtn2->Visible = true;

	GroupBox4->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
	SideBreakGradePanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

  if(TabletGradeData.ETC_EnforcementStainDefectCheckAlgorithm)
  {
    TabletCoatingDefectCheckGroupBox->Visible = true;
  }
  else
  {
    TabletCoatingDefectCheckGroupBox->Visible = false;
  }

  if(TabletCharacter.kind == SUGARCOATING && TabletGradeData.ETC_CoatedTablet_ShapeCheck)
  {
    GradeButton33->Visible = true;
    TntPanel17->Visible = true;
  }
  else
  {
    GradeButton33->Visible = false;
    TntPanel17->Visible = false;
  }
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::BitBtn3Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;

	GradeBtnForMarvelTablet1->Font->Color = clMaroon;
	GradeBtnForMarvelTablet2->Font->Color = clMaroon;
	GradeBtnForMarvelTablet3->Font->Color = clMaroon;
  GradeBtnForMarvelTablet4->Font->Color = clMaroon;
	GradeBtnForMarvelTablet5->Font->Color = clMaroon;
	GradeBtnForMarvelTablet6->Font->Color = clMaroon;
	GradeBtnForMarvelTablet7->Font->Color = clMaroon;
	// end. ߰ Btn

	GroupBox4->Visible = true;
	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
	FrontFaceGradeGroupBox->Visible = false;
	FrontFaceGradeGroupBoxForMarvelingTablet->Visible = false;
  LIMAGradeSettingPanel->Visible = false;
  
	GroupBox2->Visible = false;
	GroupBox3->Visible = false;
	GroupBox12->Visible = false;
	GroupBox8->Visible = false;
	GroupBox15->Visible = false;
	Panel1->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;

	TntPanel4->Visible = false;
	BitBtn1->Visible = false;
	BitBtn2->Visible = false;

	GradeSettingPanelForMarvelingTablet1->Visible = false;
	GradeSettingPanelForMarvelingTablet2->Visible = false;
  StainDefectCheckPanel->Visible = false;
	// end. űԷ 򰡵  г

	ThresholdBarDisplay();
  TabletThresholdBarDisplay();
	ColorDirtyIntensityBarDisplay();
	ColorDirtySizeBarDisplay();
  SplitLineThresholdBarDisplay();
}
//---------------------------------------------------------------------------



void __fastcall TGradeSettingForm::GradeButton16Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clRed;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	GradeBtnForMarvelTablet1->Font->Color = clMaroon;
	GradeBtnForMarvelTablet2->Font->Color = clMaroon;
	GradeBtnForMarvelTablet3->Font->Color = clMaroon;
  GradeBtnForMarvelTablet4->Font->Color = clMaroon;
	GradeBtnForMarvelTablet5->Font->Color = clMaroon;
	GradeBtnForMarvelTablet6->Font->Color = clMaroon;
	GradeBtnForMarvelTablet7->Font->Color = clMaroon;
	// end. ߰ Btn

	GroupBox15->Visible = true;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  
	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;

	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = false;
	BitBtn14->Visible = false;

	GradeSettingPanelForMarvelingTablet1->Visible = false;
	GradeSettingPanelForMarvelingTablet2->Visible = false;
  StainDefectCheckPanel->Visible = false;
	SideBreakGradePanel->Visible = false;
	// end. űԷ 򰡵  г

	HeightBarDisplay();

	DisplayTabletShapeData(SIDE_SHAPE, 0, DISPLAY_FRONT);

	if (DefaultLCID == 1042 || DefaultLCID == 2066)
	{
		Image11->Visible = true;
		TntImage5->Visible = false;
	}
	else
	{
		Image11->Visible = false;
		TntImage5->Visible = true;
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::BitBtn11Click(TObject *Sender)
{
	if (SizeValue[SelectedDefectN] > 0)
	{
		SizeValue[SelectedDefectN] -= 10;
		ThreeDSizeBarDisplay();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::BitBtn12Click(TObject *Sender)
{
	if (SizeValue[SelectedDefectN] < 2000)
	{
		SizeValue[SelectedDefectN] += 10;
		ThreeDSizeBarDisplay();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::BitBtn13Click(TObject *Sender)
{
	if (SizeValue[SelectedDefectN] > 0)
	{
		SizeValue[SelectedDefectN] -= 10;
		SizeBarDisplay();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::BitBtn14Click(TObject *Sender)
{
	if (SizeValue[SelectedDefectN] < 2000)
	{
		SizeValue[SelectedDefectN] += 10;
		SizeBarDisplay();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeButton28Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clRed;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	GradeBtnForMarvelTablet1->Font->Color = clMaroon;
	GradeBtnForMarvelTablet2->Font->Color = clMaroon;
	GradeBtnForMarvelTablet3->Font->Color = clMaroon;
  GradeBtnForMarvelTablet4->Font->Color = clMaroon;
	GradeBtnForMarvelTablet5->Font->Color = clMaroon;
	GradeBtnForMarvelTablet6->Font->Color = clMaroon;
	GradeBtnForMarvelTablet7->Font->Color = clMaroon;
	// end. ߰ Btn

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = true;
  Panel2->Height = 254;

  if(TabletGradeData.Side_Edge_Color_NoneInspection_Option)
  {
    Panel2->Height = 493;
  }

  PrintGradePanel->Visible = false;
  
  WhiteEngraveDefectPanel->Visible = false;
  
	StaticText1->Caption = GRADESETTING_TEXT_CAPTION_05;
	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;

	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = true;
	BitBtn14->Visible = true;

	GradeSettingPanelForMarvelingTablet1->Visible = false;
	GradeSettingPanelForMarvelingTablet2->Visible = false;
  StainDefectCheckPanel->Visible = false;
	SideBreakGradePanel->Visible = false;
	// end. űԷ 򰡵  г

	SelectedDefectN = 28;
	SelectedDefectN2 = 0;
	IntensityBarDisplay();
	SizeBarDisplay();

  if(TabletGradeData.Side_Edge_Color_NoneInspection_Option)
  {
    SideEdgeBarAndSizeBarDisplay();
  }

	DisplayTabletShapeData(SIDE_SHAPE, 0, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------
void __fastcall SetDefaultGradeData(TTabletGradeData &TabletGradeData)
{
	TabletGradeData.frontShapeEdgeNeighborRange = 11;
	//////////////////////////////////////////////////////////////
	TabletGradeData.front_dirty_Intensity = 2;
	TabletGradeData.front_dirty_Size = 13;
	TabletGradeData.front_stain_Intensity = 5;
	TabletGradeData.front_stain_Size = 35;
	TabletGradeData.front_edge_dirty_Intensity = 2;
	TabletGradeData.front_edge_dirty_Size = 10;
	TabletGradeData.front_edge_Intensity = 5;
	TabletGradeData.front_edge_Size = 40;
	/////////////////////////////////////////////////////////////////

	TabletGradeData.option_front_edgeBreaking_Intensity_Type1 = 50;
	TabletGradeData.option_front_edgeBreaking_Size_Type1 = 22;

  TabletGradeData.option_front_edgeBreaking_Intensity_Type2 = 50;
	TabletGradeData.option_front_edgeBreaking_Size_Type2 = 22;

	TabletGradeData.option_Breaking_Intensity = 22;
	TabletGradeData.option_PrintMark_Intensity = 20;
	TabletGradeData.option_Breaking_Size = 90;
	////////////////////////////////////////////////////////////////
	TabletGradeData.side_dirty_Intensity = 4;
	TabletGradeData.side_dirty_Size = 12;
	TabletGradeData.side_stain_Intensity = 4;
	TabletGradeData.side_stain_Size = 35;
	TabletGradeData.side_Color_Dirty_Intensity = 5;
	TabletGradeData.side_Color_Dirty_Size = 35;

	TabletGradeData.front_color_Intensity = 3;
	TabletGradeData.frontBorderIsSW = 0;
	TabletGradeData.frontSmallSizeGrade = 2;

	TabletGradeData.side_Edge_Top_Neighbor_Intensity = 0;
	TabletGradeData.side_Edge_Bottom_Neighbor_Intensity = 2;

	TabletGradeData.SideFaceEdgeAreaSize = 6;
	TabletGradeData.SideFaceEdgeUnInsAreaSize = 2;

	TabletGradeData.sideShapeEdgeMaskRange = 1;
	TabletGradeData.FrontEdgeAreaExtendSW = 0;
  TabletGradeData.CoatedTablet_SideInspectionAreaSize = 10;

	if (ProductData.PlateTablet)
		TabletGradeData.threeDEdgeAreaExtend = 3;
	else
		TabletGradeData.threeDEdgeAreaExtend = 0;

	/////////////////////////////////////////////////////////
	TabletGradeData.rear_stain_Intensity = 5;
	TabletGradeData.rear_stain_Size = 35;
	TabletGradeData.rear_dirty_Intensity = 2;
	TabletGradeData.rear_dirty_Size = 13;
	TabletGradeData.rear_edge_dirty_Intensity = 2;
	TabletGradeData.rear_edge_dirty_Size = 10;
	TabletGradeData.rear_edge_Intensity = 5;
	TabletGradeData.rear_edge_Size = 40;
	TabletGradeData.rear_Color_Dirty_Intensity = 2;
	TabletGradeData.rear_Color_Dirty_Size = 35;
	TabletGradeData.rear_print_dirty_Inetensity = 3;
	/////////////////////////////////////////////////////////
	TabletGradeData.front_print_dirty_Inetensity = 6;
  TabletGradeData.front_print_dirty_Inetensity2 = 15;

	if (ProductData.EngraveType == ENGRAVE_TYPE_PRINT)
		TabletGradeData.front_print_erase_Intensity = 5;
	else
		TabletGradeData.front_print_erase_Intensity = 20;

	TabletGradeData.front_print_spread_Intensity = 5;
	TabletGradeData.EngraveDistinguishGrade = 2;

	TabletGradeData.front_Color_Dirty_Intensity = 6;
	TabletGradeData.front_Color_Dirty_Size = 35;
	TabletGradeData.side_height_Intensity = 2;

  TabletGradeData.side_Edge_Color_Dirty_Intensity = 6;
	TabletGradeData.side_Edge_Color_Dirty_Size = 35;

	TabletGradeData.EngraveDistinguishGradeFor3D = 2;

	TabletGradeData.front_unInspectionIntensity_ForPrint = 0;
	TabletGradeData.front_unInspectionIntensity_ForEdge = 0;
	TabletGradeData.front_unInspectionIntensity_ForOptionPrint = 0;
	TabletGradeData.front_unInspectionIntensity_ForOptionEdge = 0;

	TabletGradeData.threeD_Height_Plus_Limit = 7;
	TabletGradeData.threeD_Height_Minus_Limit = 7;

	TabletGradeData.Saturation_Erase_SW = 0;

  TabletGradeData.ETC_Side_None_Horizontality_Tablet = 0;
  TabletGradeData.ETC_Side_Split_Line_UnInspection_Area_Setting = 0;

	if (ProductData.EngraveType == ENGRAVE_TYPE_PRINT)
		TabletGradeData.EngravePositionDefectCheckSW = 1;
	else
		TabletGradeData.EngravePositionDefectCheckSW = 0;

	// 2017-10-30 default enable · д
	TabletGradeData.EngravePositionDefectCheckSW = 1;

	if (PCProgramOption.HIprogram)
		TabletGradeData.EngravePositionDefectCheckSW = 1;

	TabletGradeData.Side_Edge_Neighbor_Intensity = 4;
	TabletGradeData.Side_Edge_Neighbor_Defect_Size = 20;

	TabletGradeData.Side_Edge_Dark_Intensity = 5;
	TabletGradeData.Side_Edge_Dark_Defect_Size = 60;

	TabletGradeData.Side_Edge_Bright_Intensity = 5;
	TabletGradeData.Side_Edge_Bright_Defect_Size = 20;

  TabletGradeData.Side_Edge_Neighbor_Break_Intensity = 5;
  TabletGradeData.Side_Edge_Neighbor_Break_Size = 40;
  TabletGradeData.Side_Edge_Neighbor_Min_Break_Depth_Size = 3;

	TabletGradeData.EngraveMatchingOrNotValue = 0;

	TabletGradeData.DirtyGradeSensitivity = GRADE_SENSITIVITY_NORMAL;

  TabletGradeData.SplitLineMatchingSWForPrintTablet = 0;
  TabletGradeData.SplitLineMatchingThreshold = 10;

	TabletGradeData.ETC_ApplyColorDirtyIgnoreAlgorithm = 0; //  
  TabletGradeData.ETC_ActiveSideEdgeDefectCheck = 0;
	TabletGradeData.ETC_InterestedColor = 2; // RED Color
	TabletGradeData.ETC_ColorDirtyIgnoreLevel = 20;
	TabletGradeData.ETC_AdjustPrintAreaSW = 0;
	TabletGradeData.ETC_ColorDirtySize = 75;
	TabletGradeData.ETC_ThreeDCenterSize = 0;

  TabletGradeData.dummy[0] = 0;
  TabletGradeData.ETC_PrintPositionDefectIntensity = 0;
  TabletGradeData.ETC_PrintPositionRotationDefectIntensity = 0;

	TabletGradeData.ETC_FrontFaceEdgeInspectionSW = 0;

	TabletGradeData.ETC_Partial3DPrintCheckSW = 0;

	TabletGradeData.ETC_RemoveBrightDotSW = 0;
	TabletGradeData.ETC_ApplyTiltTabletAlgorithm = 0;
	TabletGradeData.ETC_SideFaceMultiTabletUnInspectionSize = 0;

	TabletGradeData.DarkSpotDefectIntensityGradeForMarvelingTablet = 4;
	TabletGradeData.DarkSpotDefectSizeGradeForMarvelingTablet = 100;
	TabletGradeData.BrightSpotDefectIntensityGradeForMarvelingTablet = 4;
	TabletGradeData.BrightSpotDefectSizeGradeForMarvelingTablet = 100;

	TabletGradeData.DarkStainDefectIntensityGradeForMarvelingTablet = 6;
	TabletGradeData.DarkStainDefectSizeGradeForMarvelingTablet = 250;
	TabletGradeData.BrightStainDefectIntensityGradeForMarvelingTablet = 6;
	TabletGradeData.BrightStainDefectSizeGradeForMarvelingTablet = 250;

	TabletGradeData.DirtyDefectCheckSWInNeighborPrint = 0;

  TabletGradeData.ETC_EnforcementStainDefectCheckAlgorithm = 0;
  TabletGradeData.ETC_EngraveWhiteDefectCheckAlgorithm = 0;

	TabletGradeData.ETC_ApplyWhiteEngraveAlgorithm = 0;
  TabletGradeData.FrontFaceEngraveColorGrade = 10;

  TabletGradeData.FrontFaceEngraveWhiteSpotIntensity = 10;
  TabletGradeData.FrontFaceEngraveWhiteSpotSize = 100;

  TabletGradeData.EnforcementStainDefectInspectionAreaSize = 50;
  TabletGradeData.EnforcementStainDefectThreshold = 10;
  TabletGradeData.EnforcementStainDefectMaxLabelSize = 100;
  TabletGradeData.EnforcementStainDefectAllGroupSize = 200;

  TabletGradeData.ETC_EngraveMatchingOption_ReflectedTabletShape = 0;
  TabletGradeData.ETC_EngraveMatchingOption_LightEngrave = 0;

  TabletGradeData.ETC_ThreeD_DiffShapeTabletSW = 0;

  TabletGradeData.ThreeD_CoatedTablet_ShapeError_Height = 40;
	TabletGradeData.ThreeD_CoatedTablet_ShapeError_Size = 200;

  TabletGradeData.ETC_CoatedTablet_ShapeCheck = 0;

  TabletGradeData.ETC_PartialThreeDStampDefectIntensity = 2;
  TabletGradeData.ETC_PartialThreeDStampDefectSize = 200;

  TabletGradeData.ETC_SideEdgeDefectIntensity = 40;
  TabletGradeData.ETC_SideEdgeDefectSize = 200;

  TabletGradeData.ETC_TabletFrontFaceThreshold = 0;

  TabletGradeData.LIMA_ThreeD_Side_EraseLevel = 0;
  TabletGradeData.LIMA_ThreeD_MaxHeight = 0;
  TabletGradeData.LIMA_ThreeD_OverHeightSize = 40;
  TabletGradeData.LaserAllowX = 0;
  TabletGradeData.LaserAllowY = 0;
  TabletGradeData.LaserAllowDegree = 0;  

  TabletGradeData.DefectSearchForColorDirtyOption = 0;
  TabletGradeData.DefectSearchForColorDirtyOptOffset = 1.5;  

  TabletGradeData.SideCamMathingOption = 0;

  TabletGradeData.BeltPowderSensitivity = 0;
  TabletGradeData.RemoveBeltActive = 0;

}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TrackBar2Change(TObject *Sender)
{
	int value;
	SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;
	IntensityValue[29] = TrackBar2->Position;
	DisplayEachGradeValue();
	DisplayNotInspectionAera(FRONT_3D_SHAPE, NOTHING);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::Image10MouseDown(TObject *Sender,
	TMouseButton Button, TShiftState Shift, int X, int Y)
{
	if (X >= 300)
	{
		SizeValue[31] = (X - 300) / 10;
		HeightBarDisplay();
		ThreeDSizeBarDisplay();
		DisplayEachGradeValue();
	}
	else
	{
		SizeValue[30] = (300 - X) / 10;
		HeightBarDisplay();
		ThreeDSizeBarDisplay();
		DisplayEachGradeValue();
	}

}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::GroupBox7DblClick(TObject *Sender)
{
	if (ProductData.EngraveType != ENGRAVE_TYPE_PRINT)
	{
		if (GradeButton14->Visible)
		{
			GradeButton14->Visible = false;
			Panel13->Visible = false;
		}
		else
		{
			GradeButton14->Visible = true;
			Panel13->Visible = true;
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::TntImage3MouseDown(TObject *Sender,
	TMouseButton Button, TShiftState Shift, int X, int Y)
{
	IntensityValue[SelectedDefectN] = X / (TntImage3->Width / 100) + 1;
	IntensityBarDisplayForThreeD();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::TntImage2MouseDown(TObject *Sender,
	TMouseButton Button, TShiftState Shift, int X, int Y)
{
	SizeValue[SelectedDefectN] = X / (TntImage2->Width / 10) + 1;
	IntensityBarDisplayForThreeD();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeButton29Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clRed;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	GradeBtnForMarvelTablet1->Font->Color = clMaroon;
	GradeBtnForMarvelTablet2->Font->Color = clMaroon;
	GradeBtnForMarvelTablet3->Font->Color = clMaroon;
  GradeBtnForMarvelTablet4->Font->Color = clMaroon;
	GradeBtnForMarvelTablet5->Font->Color = clMaroon;
	GradeBtnForMarvelTablet6->Font->Color = clMaroon;
	GradeBtnForMarvelTablet7->Font->Color = clMaroon;
	// end. ߰ Btn

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  
	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = true;
	SideEdgeGradeSettingPanel->Visible = false;

	StaticText1->Caption = GRADESETTING_TEXT_CAPTION_05;

	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = true;
	BitBtn14->Visible = true;

	GradeSettingPanelForMarvelingTablet1->Visible = false;
	GradeSettingPanelForMarvelingTablet2->Visible = false;
  StainDefectCheckPanel->Visible = false;
	SideBreakGradePanel->Visible = false;
	// end. űԷ 򰡵  г

	SelectedDefectN = 32;

	SideEdgeNeighborIntensityBarDisplay();
	SideEdgeNeighborSizeBarDisplay();

	DisplayTabletShapeData(SIDE_SHAPE, 0, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntBitBtn1Click(TObject *Sender)
{
	if (SizeValue[SelectedDefectN] > 0)
	{
		SizeValue[SelectedDefectN] -= 10;
		SideEdgeNeighborSizeBarDisplay();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntBitBtn2Click(TObject *Sender)
{
	if (SizeValue[SelectedDefectN] < 2000)
	{
		SizeValue[SelectedDefectN] += 10;
		SideEdgeNeighborSizeBarDisplay();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------


void __fastcall TGradeSettingForm::ThresholdBarDisplay(void)
{
	Image13->Canvas->Pen->Color = clBlack;
	Image13->Canvas->Brush->Style = bsSolid;
	Image13->Canvas->Brush->Color = clWhite;
	Image13->Canvas->Rectangle(0, 0, Image13->Width, Image13->Height);

	Image13->Canvas->Brush->Style = bsSolid;

	if (IntensityValue[34] <= 0)
	{
		Image13->Canvas->Brush->Color = clBlue;
		Image13->Canvas->Rectangle(180 + IntensityValue[34] * 6, 0, 180, 30);

		Image13->Canvas->Brush->Color = clBlue;
		Image13->Canvas->Font->Color = clWhite;
		Image13->Canvas->Font->Size = 10;
		Image13->Canvas->TextOut(180 + IntensityValue[34] * 6, 2, IntToStr(IntensityValue[34]) + " L");
	}
	else
	{
		Image13->Canvas->Brush->Color = clRed;
		Image13->Canvas->Rectangle(180, 0, IntensityValue[34] * 6 + 180, 30);

		Image13->Canvas->Brush->Color = clRed;
		Image13->Canvas->Font->Color = clWhite;
		Image13->Canvas->Font->Size = 10;
		Image13->Canvas->TextOut(180 + IntensityValue[34] * 6 - 30, 2, IntToStr(IntensityValue[34]) + " L");
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::Image13MouseDown(TObject *Sender,
	TMouseButton Button, TShiftState Shift, int X, int Y)
{
	IntensityValue[34] = (X - 180) / 6;
	ThresholdBarDisplay();
	VariableToGradeData();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------


void __fastcall TGradeSettingForm::UnPrintDefectCheckBoxClick(
	TObject *Sender)
{
	TntPanel4->Visible = false;
	SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	if (UnPrintDefectCheckBox->Checked == true)
	{
		TabletGradeData.EngravePositionDefectCheckSW = 1;
	}
	else
	{
		TabletGradeData.EngravePositionDefectCheckSW = 0;
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeSensitivityPanel1Click(
	TObject *Sender)
{
	TntPanel4->Visible = false;
	SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	TPanel *tempPanel;
	tempPanel = (TPanel*)Sender;

	int selectedPanel;
	selectedPanel = tempPanel->Tag;
   
	if (selectedPanel == GRADE_SENSITIVITY_NORMAL)
	{
		GradeSensitivityPanel1->Color = clBlue;
		GradeSensitivityPanel1->Font->Color = clWhite;
		GradeSensitivityPanel1->Font->Style = GradeSensitivityPanel1->Font->Style << fsBold;

		GradeSensitivityPanel2->Color = clWhite;
		GradeSensitivityPanel2->Font->Color = clBlack;
		GradeSensitivityPanel2->Font->Style = GradeSensitivityPanel2->Font->Style >> fsBold;

		IntensityValue[35] = GRADE_SENSITIVITY_NORMAL;

		ColorDefectPassAlgorithmCB->Enabled = true;
	}
	else if (selectedPanel == GRADE_SENSITIVITY_HIGH)
	{
		GradeSensitivityPanel1->Color = clWhite;
		GradeSensitivityPanel1->Font->Color = clBlack;
		GradeSensitivityPanel1->Font->Style = GradeSensitivityPanel1->Font->Style >> fsBold;

		GradeSensitivityPanel2->Color = clBlue;
		GradeSensitivityPanel2->Font->Color = clWhite;
		GradeSensitivityPanel2->Font->Style = GradeSensitivityPanel2->Font->Style << fsBold;

		IntensityValue[35] = GRADE_SENSITIVITY_HIGH;

		ColorDefectPassAlgorithmCB->Enabled = false;
		if (ColorDefectPassAlgorithmCB->Checked)
		{
			ColorDefectPassAlgorithmCB->Checked = false;

      ShowMessage("The algorithm can not be applied in color dot remove function.");
		}
	}
	else
	{
		GradeSensitivityPanel1->Color = clWhite;
		GradeSensitivityPanel1->Font->Color = clBlack;
		GradeSensitivityPanel1->Font->Style = GradeSensitivityPanel1->Font->Style >> fsBold;

		GradeSensitivityPanel2->Color = clWhite;
		GradeSensitivityPanel2->Font->Color = clBlack;
		GradeSensitivityPanel2->Font->Style = GradeSensitivityPanel2->Font->Style >> fsBold;

		IntensityValue[35] = GRADE_SENSITIVITY_NORMAL;

		ColorDefectPassAlgorithmCB->Enabled = true;
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntImage6MouseDown(TObject *Sender,
	TMouseButton Button, TShiftState Shift, int X, int Y)
{
	if (SelectedDefectN != 13 && SelectedDefectN != 14 && SelectedDefectN != 15)
		IntensityValue[SelectedDefectN] = X / (TntImage6->Width / 10) + 1;
	else
		IntensityValue[SelectedDefectN] = X / (TntImage6->Width / 20) + 1;

	IntensityBarDisplay();
	DisplayEachGradeValue();

	TntImage6->Canvas->Brush->Style = bsSolid;
	TntImage6->Canvas->Brush->Color = clBlack;
	TntImage6->Canvas->Pen->Color = clBlack;
	TntImage6->Canvas->Rectangle(0, 0, TntImage6->Width, TntImage6->Height);

	if (SelectedDefectN != 13 && SelectedDefectN != 14 && SelectedDefectN != 15)
	{
		TntImage6->Canvas->Brush->Style = bsSolid;
		TntImage6->Canvas->Brush->Color = (TColor)0x126596;
		TntImage6->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN] * (TntImage6->Width / 10), TntImage6->Height);
		TntImage6->Canvas->Font->Color = clBlack;
		TntImage6->Canvas->Font->Size = 10;
		TntImage6->Canvas->TextOutW(IntensityValue[SelectedDefectN] * (TntImage6->Width / 10) - TntImage6->Width / 10, 15, IntToStr(IntensityValue[SelectedDefectN]) + " Grade");
	}
	else
	{
		TntImage6->Canvas->Brush->Style = bsSolid;
		TntImage6->Canvas->Brush->Color = (TColor)0x126596;
		TntImage6->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN] * (TntImage6->Width / 20), TntImage6->Height);
		TntImage6->Canvas->Font->Color = clBlack;
		TntImage6->Canvas->Font->Size = 10;
		TntImage6->Canvas->TextOutW(IntensityValue[SelectedDefectN] * (TntImage6->Width / 20) - TntImage6->Width / 20, 15, IntToStr(IntensityValue[SelectedDefectN]) + " Grade");
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::Image2MouseDown(TObject *Sender,
	TMouseButton Button, TShiftState Shift, int X, int Y)
{
	if (SelectedDefectN != 13 && SelectedDefectN != 14 && SelectedDefectN != 15)
		IntensityValue[SelectedDefectN] = X / (Image2->Width / 10) + 1;
	else
		IntensityValue[SelectedDefectN] = X / (Image2->Width / 20) + 1;

	IntensityBarDisplay();
	DisplayEachGradeValue();

  /*
	Image2->Canvas->Brush->Style = bsSolid;
	Image2->Canvas->Brush->Color = clBlack;
	Image2->Canvas->Pen->Color = clBlack;
	Image2->Canvas->Rectangle(0, 0, Image2->Width, Image2->Height);

	if (SelectedDefectN != 13 && SelectedDefectN != 14 && SelectedDefectN != 15)
	{
		Image2->Canvas->Brush->Style = bsSolid;
		Image2->Canvas->Brush->Color = (TColor)0x126596;
		Image2->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN] * (Image2->Width / 10), Image2->Height);
		Image2->Canvas->Font->Color = clBlack;
		Image2->Canvas->Font->Size = 12;
		Image2->Canvas->TextOutA(IntensityValue[SelectedDefectN] * (Image2->Width / 10) - Image2->Width / 10, 15, IntToStr(IntensityValue[SelectedDefectN]) + " Grade");
	}
	else
	{
		Image2->Canvas->Brush->Style = bsSolid;
		Image2->Canvas->Brush->Color = (TColor)0x126596;
		Image2->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN] * (Image2->Width / 20), Image2->Height);
		Image2->Canvas->Font->Color = clBlack;
		Image2->Canvas->Font->Size = 12;
		Image2->Canvas->TextOutA(IntensityValue[SelectedDefectN] * (Image2->Width / 20) - Image2->Width / 20, 15, IntToStr(IntensityValue[SelectedDefectN]) + " Grade");
	}
  */
}
//---------------------------------------------------------------------------


void __fastcall TGradeSettingForm::TntImage8MouseDown(TObject *Sender,
	TMouseButton Button, TShiftState Shift, int X, int Y)
{
	SizeValue[SelectedDefectN] = X / 3 * 10;
	SizeBarDisplay_ETC();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::ColorDefectPassAlgorithmCBClick(
	TObject *Sender)
{
	TntPanel4->Visible = false;
	SideBreakGradePanel->Visible = false;

	if (ColorDefectPassAlgorithmCB->Checked)
	{
		TabletGradeData.ETC_ApplyColorDirtyIgnoreAlgorithm = 1;
	}
	else
	{
		TabletGradeData.ETC_ApplyColorDirtyIgnoreAlgorithm = 0;
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::RColorFrontPanelClick(TObject *Sender)
{
	TntPanel4->Visible = false;
	SideBreakGradePanel->Visible = false;

	TPanel *tempPanel = (TPanel*)Sender;
	int colorIndex = tempPanel->Tag;

	if (colorIndex == 2)
	{
		RColorBackPanel->Color = clWhite;
		GColorBackPanel->Color = clBlack;
		BColorBackPanel->Color = clBlack;

		IntensityValue[37] = 2;
	}
	else if (colorIndex == 1)
	{
		RColorBackPanel->Color = clBlack;
		GColorBackPanel->Color = clWhite;
		BColorBackPanel->Color = clBlack;

		IntensityValue[37] = 1;
	}
	else if (colorIndex == 0)
	{
		RColorBackPanel->Color = clBlack;
		GColorBackPanel->Color = clBlack;
		BColorBackPanel->Color = clWhite;

		IntensityValue[37] = 0;
	}
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::ColorDirtyIntensityBarDisplay(void)
{
	ColorDirtyIgnoreLevelImg->Canvas->Brush->Style = bsSolid;
	ColorDirtyIgnoreLevelImg->Canvas->Brush->Color = clBlack;
	ColorDirtyIgnoreLevelImg->Canvas->Pen->Color = clBlack;
	ColorDirtyIgnoreLevelImg->Canvas->Rectangle(0, 0, ColorDirtyIgnoreLevelImg->Width, ColorDirtyIgnoreLevelImg->Height);

	ColorDirtyIgnoreLevelImg->Canvas->Brush->Style = bsSolid;
	ColorDirtyIgnoreLevelImg->Canvas->Brush->Color = (TColor)0x126596;
	ColorDirtyIgnoreLevelImg->Canvas->Rectangle(0, 0, IntensityValue[38] * (ColorDirtyIgnoreLevelImg->Width / 50), ColorDirtyIgnoreLevelImg->Height);
	ColorDirtyIgnoreLevelImg->Canvas->Font->Color = clBlack;
	ColorDirtyIgnoreLevelImg->Canvas->Font->Size = 10;

	if (IntensityValue[38] < 7)
		ColorDirtyIgnoreLevelImg->Canvas->TextOutW(IntensityValue[38] * (ColorDirtyIgnoreLevelImg->Width / 50) - ColorDirtyIgnoreLevelImg->Width / 50, 15, IntToStr(IntensityValue[38]) + " Grade");
	else
		ColorDirtyIgnoreLevelImg->Canvas->TextOutW(IntensityValue[38] * (ColorDirtyIgnoreLevelImg->Width / 50) - ColorDirtyIgnoreLevelImg->Width / 50 - 60, 15, IntToStr(IntensityValue[38]) + " Grade");
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::ColorDirtyIgnoreLevelImgMouseDown(
	TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
	int Y)
{
	TntPanel4->Visible = false;
	SideBreakGradePanel->Visible = false;

	IntensityValue[38] = X / (ColorDirtyIgnoreLevelImg->Width / 50) + 1;
	ColorDirtyIntensityBarDisplay();
}
//---------------------------------------------------------------------------


void __fastcall TGradeSettingForm::TntBitBtn4Click(TObject *Sender)
{
	if (SizeValue[SelectedDefectN] < 2000)
	{
		SizeValue[SelectedDefectN] += 10;
		SizeBarDisplay_ETC();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntBitBtn3Click(TObject *Sender)
{
	if (SizeValue[SelectedDefectN] > 0)
	{
		SizeValue[SelectedDefectN] -= 10;
		SizeBarDisplay_ETC();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::CheckBox3Click(TObject *Sender)
{
	if (CheckBox3->Checked == true)
	{
		TabletGradeData.ETC_AdjustPrintAreaSW = 1;
	}
	else
	{
		TabletGradeData.ETC_AdjustPrintAreaSW = 0;
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GroupBox4DblClick(TObject *Sender)
{
  if(!bUserMakingGradeData)
  {
    if (TntPanel6->Visible)
    {
      TntPanel6->Visible = false;
    }
    else
    {
      TntPanel6->Visible = true;
    }

    if (EraseThreeDEngraveBtn->Visible)
    {
      EraseThreeDEngraveBtn->Visible = false;
    }
    else
    {
      EraseThreeDEngraveBtn->Visible = false;
    }

    if (TabletCharacter.shape == ROUND)
    {
      CheckBox8->Visible = false;
    }

    if (TabletCharacter.discriminationDisplay_kind == STAMP)
    {
      DirtyDefectCheckInNeighborPrintCheckBox->Visible = true;
    }
    else
    {
      DirtyDefectCheckInNeighborPrintCheckBox->Visible = false;
    }

    if (MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
    {
      TntPanel11->Visible = true;
	TntPanel34->Visible = true;

      if(ProductData.TabletShape == TABLET_SHAPE_OVAL ||
        ProductData.TabletShape == TABLET_SHAPE_OBLONG ||
        ProductData.TabletShape == TABLET_SHAPE_ETC)
      {
        PrintRotationPositionDefectTrackBar->Enabled = true;
      }
      else
      {
        PrintRotationPositionDefectTrackBar->Enabled = false;
      }
    }

    if(TabletCharacter.kind != SUGARCOATING && TabletCharacter.HighResolutionImage == 0)
    {
      SideEdgeDirtyGradeSettingButton->Visible = !SideEdgeDirtyGradeSettingButton->Visible;
    }

    PreviewInspectionBtn->Visible = !PreviewInspectionBtn->Visible;

    if(MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
    {
      LIMAGradeSettingButton->Visible = !LIMAGradeSettingButton->Visible;
    }
    else
    {
      LIMAGradeSettingButton->Visible = false;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::ColorDirtySizeBarMouseDown(
	TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
	int Y)
{
	TntPanel4->Visible = false;
	SideBreakGradePanel->Visible = false;

	SizeValue[38] = X / 3 * 10;
	ColorDirtySizeBarDisplay();
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::ColorDirtySizeBarDisplay(void)
{
	ColorDirtySizeBar->Canvas->Brush->Style = bsSolid;
	ColorDirtySizeBar->Canvas->Brush->Color = clBlack;
	ColorDirtySizeBar->Canvas->Pen->Color = clBlack;
	ColorDirtySizeBar->Canvas->Rectangle(0, 0, ColorDirtySizeBar->Width, ColorDirtySizeBar->Height);

	ColorDirtySizeBar->Canvas->Brush->Style = bsSolid;
	ColorDirtySizeBar->Canvas->Brush->Color = (TColor)0x656596;
	ColorDirtySizeBar->Canvas->Rectangle(0, 0, SizeValue[38] / 10 * 3, ColorDirtySizeBar->Height);
	ColorDirtySizeBar->Canvas->Font->Color = clBlack;
	ColorDirtySizeBar->Canvas->Font->Size = 10;

	ColorDirtySizeBar->Canvas->TextOutW(SizeValue[38] / 10 * 3, 15, FloatToStr((float)SizeValue[38] / 1000.0) + " mm");
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::TntScrollBar1Change(TObject *Sender)
{
	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;
	IntensityValue[39] = TntScrollBar1->Position;
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------


void __fastcall TGradeSettingForm::CheckBox5Click(TObject *Sender)
{
	if (CheckBox5->Checked == true)
	{
		TabletGradeData.ETC_FrontFaceEdgeInspectionSW = 1;
	}
	else
	{
		TabletGradeData.ETC_FrontFaceEdgeInspectionSW = 0;
	}
}
//---------------------------------------------------------------------------


void __fastcall TGradeSettingForm::EraseThreeDEngraveBtnClick(TObject *Sender)
{
	SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;
	TThreeDPrintMaskForm *threeDPrintMaskForm = new TThreeDPrintMaskForm(this);

	threeDPrintMaskForm->srcTablet3DSetupData = &Tablet3DSetupData;
	threeDPrintMaskForm->srcTabletSetupData = &TabletSetupData;
	threeDPrintMaskForm->ShowModal();

	if (threeDPrintMaskForm->saveFlag)
	{
		memcpy(&TabletSetupData, &threeDPrintMaskForm->dstTabletSetupData, sizeof(TTabletSetupData));
		if (WriteSetupData(&TabletSetupData))
		{
			CPBSetupInfo.InspectionSetupDataValid = false;
			ShowMessageFA(CALIBRATIONFORM_MSG_10);
		}
		else
		{
			ShowMessageFA(CALIBRATIONFORM_MSG_11);
		}
	}
	delete threeDPrintMaskForm;
}
//---------------------------------------------------------------------------

bool __fastcall TGradeSettingForm::WriteSetupData(TTabletSetupData *tabletSetupData)
{
	AnsiString FilePath = ProgramPath.Product + "\\" + ProductData.ProductCode;

	if (DirectoryExists(FilePath))
	{
		AnsiString setupDataFileName = FilePath + "\\" + ProductData.ProductCode + ".sdt";

		TFileStream *fileStream = new TFileStream(setupDataFileName, fmCreate);
		fileStream->Write(tabletSetupData, sizeof(TTabletSetupData));
		delete fileStream;
		return true;
	}
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::SpecialFunctionCheckBoxClick(
	TObject *Sender)
{
	if (SpecialFunctionCheckBox->Checked == true)
	{
		TabletGradeData.ETC_Partial3DPrintCheckSW = 1;
	}
	else
	{
		TabletGradeData.ETC_Partial3DPrintCheckSW = 0;
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::Button2Click(TObject *Sender)
{
	SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::CheckBox7Click(TObject *Sender)
{
	if (CheckBox7->Checked == true)
	{
		TabletGradeData.ETC_RemoveBrightDotSW = 1;
	}
	else
	{
		TabletGradeData.ETC_RemoveBrightDotSW = 0;
	}
}
//---------------------------------------------------------------------------


void __fastcall TGradeSettingForm::CheckBox8Click(TObject *Sender)
{
	if (CheckBox8->Checked == true)
	{
		TabletGradeData.ETC_ApplyTiltTabletAlgorithm = 1;
	}
	else
	{
		TabletGradeData.ETC_ApplyTiltTabletAlgorithm = 0;
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::ColorDirtyControlBtnClick(
	TObject *Sender)
{
	SideBreakGradePanel->Visible = false;
	ColorDirtyControlPanel->Visible = true;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;
	ColorDirtyControlPanel->BringToFront();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntScrollBar4Change(TObject *Sender)
{
	SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;
	IntensityValue[47] = TntScrollBar4->Position;
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeBtnForMarvelTablet1Click(
	TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	GradeBtnForMarvelTablet1->Font->Color = clRed;
	GradeBtnForMarvelTablet2->Font->Color = clMaroon;
	GradeBtnForMarvelTablet3->Font->Color = clMaroon;
  GradeBtnForMarvelTablet4->Font->Color = clMaroon;
	GradeBtnForMarvelTablet5->Font->Color = clMaroon;
	GradeBtnForMarvelTablet6->Font->Color = clMaroon;
	GradeBtnForMarvelTablet7->Font->Color = clMaroon;
	// end. ߰ Btn


	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
  SideBreakGradePanel->Visible = false;
	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  
	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = false;
	BitBtn14->Visible = false;
	// end.  ϴ   г

	GradeSettingPanelForMarvelingTablet1->Visible = true;
	GradeSettingPanelForMarvelingTablet2->Visible = true;
  StainDefectCheckPanel->Visible = false;
	SideBreakGradePanel->Visible = false;
	// end. űԷ 򰡵  г

	SelectedDefectN1ForMarveling = 51;
	SelectedDefectN2ForMarveling = 52;

	IntensityBarDisplayForMarvelingTablet();
	SizeBarDisplayForMarvelingTablet();

	DisplayTabletShapeData(FRONT_SHAPE, NOT_PRINT_AREA, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeBtnForMarvelTablet7Click(
	TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;
	// end.  ϴ Btn

	GradeBtnForMarvelTablet1->Font->Color = clMaroon;
	GradeBtnForMarvelTablet2->Font->Color = clMaroon;
	GradeBtnForMarvelTablet3->Font->Color = clMaroon;
  GradeBtnForMarvelTablet4->Font->Color = clMaroon;
	GradeBtnForMarvelTablet5->Font->Color = clMaroon;
	GradeBtnForMarvelTablet6->Font->Color = clMaroon;
	GradeBtnForMarvelTablet7->Font->Color = clRed;
	// end. ߰ Btn

	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
	Panel2->Visible = true;
  Panel2->Height = 254;
  PrintGradePanel->Visible = false;
  
  WhiteEngraveDefectPanel->Visible = false;
  
	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	StaticText1->Caption = GRADESETTING_TEXT_CAPTION_05;

	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = false;
	BitBtn14->Visible = false;

	GradeSettingPanelForMarvelingTablet1->Visible = false;
	GradeSettingPanelForMarvelingTablet2->Visible = false;
  SideBreakGradePanel->Visible = false;
  StainDefectCheckPanel->Visible = false;
	SideBreakGradePanel->Visible = false;
	// end. űԷ 򰡵  г

	SelectedDefectN = 11;
	SelectedDefectN2 = 0;
	IntensityBarDisplay();

	DisplayTabletShapeData(FRONT_SHAPE, 0, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeBtnForMarvelTablet5Click(
	TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;
	// end.  ϴ Btn

	GradeBtnForMarvelTablet1->Font->Color = clMaroon;
	GradeBtnForMarvelTablet2->Font->Color = clMaroon;
	GradeBtnForMarvelTablet3->Font->Color = clMaroon;
  GradeBtnForMarvelTablet4->Font->Color = clMaroon;
	GradeBtnForMarvelTablet5->Font->Color = clRed;
	GradeBtnForMarvelTablet6->Font->Color = clMaroon;
	GradeBtnForMarvelTablet7->Font->Color = clMaroon;
	// end. ߰ Btn

	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = true;
  Panel2->Height = 254;
  PrintGradePanel->Visible = false;
  
  WhiteEngraveDefectPanel->Visible = false;
  
	StaticText1->Caption = GRADESETTING_TEXT_CAPTION_06;
	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = false;
	BitBtn14->Visible = false;

	GradeSettingPanelForMarvelingTablet1->Visible = false;
	GradeSettingPanelForMarvelingTablet2->Visible = false;
  SideBreakGradePanel->Visible = false;
  StainDefectCheckPanel->Visible = false;
	SideBreakGradePanel->Visible = false;
	// end. űԷ 򰡵  г

	SelectedDefectN = 13;
	SelectedDefectN2 = 0;
	IntensityBarDisplay();
	DisplayTabletShapeData(FRONT_SHAPE, PRINT_AREA, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeBtnForMarvelTablet6Click(
	TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;
	// end.  ϴ Btn

	GradeBtnForMarvelTablet1->Font->Color = clMaroon;
	GradeBtnForMarvelTablet2->Font->Color = clMaroon;
	GradeBtnForMarvelTablet3->Font->Color = clMaroon;
  GradeBtnForMarvelTablet4->Font->Color = clMaroon;
	GradeBtnForMarvelTablet5->Font->Color = clMaroon;
	GradeBtnForMarvelTablet6->Font->Color = clRed;
	GradeBtnForMarvelTablet7->Font->Color = clMaroon;
	// end. ߰ Btn

	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = true;
  Panel2->Height = 254;
  PrintGradePanel->Visible = false;

  WhiteEngraveDefectPanel->Visible = false;
  
	if (ProductData.EngraveType == ENGRAVE_TYPE_PRINT)
	{
		StaticText1->Caption = GRADESETTING_TEXT_CAPTION_04;
	}
	else
	{
		StaticText1->Caption = NEW_ADD_STRING_10;
	}
	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = false;
	BitBtn14->Visible = false;

	GradeSettingPanelForMarvelingTablet1->Visible = false;
	GradeSettingPanelForMarvelingTablet2->Visible = false;
  SideBreakGradePanel->Visible = false;
  StainDefectCheckPanel->Visible = false;
	SideBreakGradePanel->Visible = false;
	// end. űԷ 򰡵  г

	SelectedDefectN = 14;
	SelectedDefectN2 = 0;
	IntensityBarDisplay();
	DisplayTabletShapeData(FRONT_SHAPE, PRINT_AREA, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntGroupBox7DblClick(TObject *Sender)
{
	if (ProductData.EngraveType != ENGRAVE_TYPE_PRINT)
	{
		if (GradeBtnForMarvelTablet6->Visible)
		{
			GradeBtnForMarvelTablet6->Visible = false;
			TntPanel21->Visible = false;
		}
		else
		{
			GradeBtnForMarvelTablet6->Visible = true;
			TntPanel21->Visible = true;
		}
	}
}
//---------------------------------------------------------------------------



void __fastcall TGradeSettingForm::GradeBtnForMarvelTablet2Click(
	TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;
	// end.  ϴ Btn

	GradeBtnForMarvelTablet1->Font->Color = clMaroon;
	GradeBtnForMarvelTablet2->Font->Color = clRed;
	GradeBtnForMarvelTablet3->Font->Color = clMaroon;
  GradeBtnForMarvelTablet4->Font->Color = clMaroon;
	GradeBtnForMarvelTablet5->Font->Color = clMaroon;
	GradeBtnForMarvelTablet6->Font->Color = clMaroon;
	GradeBtnForMarvelTablet7->Font->Color = clMaroon;
	// end. ߰ Btn

	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
	GroupBox15->Visible = false;
	GroupBox8->Visible = false;

  if(TabletCharacter.discriminationDisplay_kind == PRINT)
  {
    Panel2->Visible = false;
    PrintGradePanel->Visible = true;

    PrintIntensityBarDisplay();
  }
  else
  {
    Panel2->Visible = true;
    Panel2->Height = 135;

    PrintGradePanel->Visible = false;
  }

  if(TabletGradeData.ETC_EngraveWhiteDefectCheckAlgorithm)
  {
    WhiteEngraveDefectPanel->Visible = true;
  }
  else
  {
    WhiteEngraveDefectPanel->Visible = false;
  }

  StaticText1->Caption = GRADESETTING_ETC_CAPTION_40;

	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = false;
	BitBtn14->Visible = false;

	GradeSettingPanelForMarvelingTablet1->Visible = false;
	GradeSettingPanelForMarvelingTablet2->Visible = false;
  SideBreakGradePanel->Visible = false;
  StainDefectCheckPanel->Visible = false;
	SideBreakGradePanel->Visible = false;
	// end. űԷ 򰡵  г

	SelectedDefectN = 2;
	SelectedDefectN2 = 0;
	IntensityBarDisplay();
  EngraveColorIntensityImageDisplay();
  EngraveWhiteSpotIntensityImageDisplay();
  WhiteSpotSizeImageDisplay();

	DisplayTabletShapeData(FRONT_SHAPE, PRINT_AREA, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------


void __fastcall TGradeSettingForm::GradeBtnForMarvelTablet3Click(
	TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;
	// end.  ϴ Btn

	GradeBtnForMarvelTablet1->Font->Color = clMaroon;
	GradeBtnForMarvelTablet2->Font->Color = clMaroon;
	GradeBtnForMarvelTablet3->Font->Color = clRed;
  GradeBtnForMarvelTablet4->Font->Color = clMaroon;
	GradeBtnForMarvelTablet5->Font->Color = clMaroon;
	GradeBtnForMarvelTablet6->Font->Color = clMaroon;
	GradeBtnForMarvelTablet7->Font->Color = clMaroon;
	// end. ߰ Btn


	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  
	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = false;
	BitBtn14->Visible = false;
	// end.  ϴ   г

	GradeSettingPanelForMarvelingTablet1->Visible = true;
	GradeSettingPanelForMarvelingTablet2->Visible = true;
  SideBreakGradePanel->Visible = false;
  StainDefectCheckPanel->Visible = false;
	SideBreakGradePanel->Visible = false;
	// end. űԷ 򰡵  г

	SelectedDefectN1ForMarveling = 53;
	SelectedDefectN2ForMarveling = 54;

	IntensityBarDisplayForMarvelingTablet();
	SizeBarDisplayForMarvelingTablet();

	DisplayTabletShapeData(FRONT_SHAPE, NOT_PRINT_AREA, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::IntensityBarDisplayForMarvelingTablet(void)
{
	BrightnessImageBar1->Canvas->Brush->Style = bsSolid;
	BrightnessImageBar1->Canvas->Brush->Color = clBlack;
	BrightnessImageBar1->Canvas->Pen->Color = clBlack;
	BrightnessImageBar1->Canvas->Rectangle(0, 0, BrightnessImageBar1->Width, BrightnessImageBar1->Height);

	BrightnessImageBar1->Canvas->Brush->Style = bsSolid;
	BrightnessImageBar1->Canvas->Brush->Color = (TColor)0x126596;
	BrightnessImageBar1->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN1ForMarveling] * (BrightnessImageBar1->Width / 10), BrightnessImageBar1->Height);
	BrightnessImageBar1->Canvas->Font->Color = clBlack;
	BrightnessImageBar1->Canvas->Font->Size = 10;
	BrightnessImageBar1->Canvas->TextOutW(IntensityValue[SelectedDefectN1ForMarveling] * (BrightnessImageBar1->Width / 10) - BrightnessImageBar1->Width / 10, 15, IntToStr(IntensityValue[SelectedDefectN1ForMarveling]) + " Grade");

	BrightnessImageBar2->Canvas->Brush->Style = bsSolid;
	BrightnessImageBar2->Canvas->Brush->Color = clBlack;
	BrightnessImageBar2->Canvas->Pen->Color = clBlack;
	BrightnessImageBar2->Canvas->Rectangle(0, 0, BrightnessImageBar2->Width, BrightnessImageBar2->Height);

	BrightnessImageBar2->Canvas->Brush->Style = bsSolid;
	BrightnessImageBar2->Canvas->Brush->Color = (TColor)0x126596;
	BrightnessImageBar2->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN2ForMarveling] * (BrightnessImageBar2->Width / 10), BrightnessImageBar2->Height);
	BrightnessImageBar2->Canvas->Font->Color = clBlack;
	BrightnessImageBar2->Canvas->Font->Size = 10;
	BrightnessImageBar2->Canvas->TextOutW(IntensityValue[SelectedDefectN2ForMarveling] * (BrightnessImageBar2->Width / 10) - BrightnessImageBar2->Width / 10, 15, IntToStr(IntensityValue[SelectedDefectN2ForMarveling]) + " Grade");
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::SizeBarDisplayForMarvelingTablet(void)
{
	SizeGradeImageBar1->Canvas->Brush->Style = bsSolid;
	SizeGradeImageBar1->Canvas->Brush->Color = clBlack;
	SizeGradeImageBar1->Canvas->Pen->Color = clBlack;
	SizeGradeImageBar1->Canvas->Rectangle(0, 0, SizeGradeImageBar1->Width, SizeGradeImageBar1->Height);

	SizeGradeImageBar1->Canvas->Brush->Style = bsSolid;
	SizeGradeImageBar1->Canvas->Brush->Color = (TColor)0x656596;
	SizeGradeImageBar1->Canvas->Rectangle(0, 0, SizeValue[SelectedDefectN1ForMarveling] / 10 * 3, SizeGradeImageBar1->Height);
	SizeGradeImageBar1->Canvas->Font->Color = clBlack;
	SizeGradeImageBar1->Canvas->Font->Size = 10;
	SizeGradeImageBar1->Canvas->TextOutW(SizeValue[SelectedDefectN1ForMarveling] / 10 * 3 + 10, 15, FloatToStr((float)SizeValue[SelectedDefectN1ForMarveling] / 1000.0) + " mm");

	SizeGradeImageBar2->Canvas->Brush->Style = bsSolid;
	SizeGradeImageBar2->Canvas->Brush->Color = clBlack;
	SizeGradeImageBar2->Canvas->Pen->Color = clBlack;
	SizeGradeImageBar2->Canvas->Rectangle(0, 0, SizeGradeImageBar2->Width, SizeGradeImageBar2->Height);

	SizeGradeImageBar2->Canvas->Brush->Style = bsSolid;
	SizeGradeImageBar2->Canvas->Brush->Color = (TColor)0x656596;
	SizeGradeImageBar2->Canvas->Rectangle(0, 0, SizeValue[SelectedDefectN2ForMarveling] / 10 * 3, SizeGradeImageBar2->Height);
	SizeGradeImageBar2->Canvas->Font->Color = clBlack;
	SizeGradeImageBar2->Canvas->Font->Size = 10;
	SizeGradeImageBar2->Canvas->TextOutW(SizeValue[SelectedDefectN2ForMarveling] / 10 * 3 + 10, 15, FloatToStr((float)SizeValue[SelectedDefectN2ForMarveling] / 1000.0) + " mm");
}
//---------------------------------------------------------------------------


void __fastcall TGradeSettingForm::BrightnessImageBar1MouseDown(
	TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
	int Y)
{
	IntensityValue[SelectedDefectN1ForMarveling] = X / (BrightnessImageBar1->Width / 10) + 1;

	IntensityBarDisplayForMarvelingTablet();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::BrightnessImageBar2MouseDown(
	TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
	int Y)
{
	IntensityValue[SelectedDefectN2ForMarveling] = X / (BrightnessImageBar2->Width / 10) + 1;

	IntensityBarDisplayForMarvelingTablet();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::SizeGradeImageBar1MouseDown(
	TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
	int Y)
{
	SizeValue[SelectedDefectN1ForMarveling] = X / 3 * 10;
	SizeBarDisplayForMarvelingTablet();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::SizeGradeImageBar2MouseDown(
	TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
	int Y)
{
	SizeValue[SelectedDefectN2ForMarveling] = X / 3 * 10;
	SizeBarDisplayForMarvelingTablet();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntBitBtn7Click(TObject *Sender)
{
	if (SizeValue[SelectedDefectN1ForMarveling] < 2000)
	{
		SizeValue[SelectedDefectN1ForMarveling] += 10;
		SizeBarDisplayForMarvelingTablet();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntBitBtn6Click(TObject *Sender)
{
	if (SizeValue[SelectedDefectN1ForMarveling] < 2000)
	{
		SizeValue[SelectedDefectN1ForMarveling] -= 10;
		SizeBarDisplayForMarvelingTablet();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntBitBtn9Click(TObject *Sender)
{
	if (SizeValue[SelectedDefectN2ForMarveling] < 2000)
	{
		SizeValue[SelectedDefectN2ForMarveling] += 10;
		SizeBarDisplayForMarvelingTablet();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntBitBtn8Click(TObject *Sender)
{
	if (SizeValue[SelectedDefectN2ForMarveling] < 2000)
	{
		SizeValue[SelectedDefectN2ForMarveling] -= 10;
		SizeBarDisplayForMarvelingTablet();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::InspectionAreaSettingBtnClick(
	TObject *Sender)
{
  if(!ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_INSPECTIONFORM_CAMERA_SETUP])
	{
    InspectionAreaSettingBtn->Visible = false;
    ShowMessageFA(NEW_ADD_STRING_88);
    return;
	}
  else
    InspectionAreaSettingBtn->Visible = true;

	SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	TInspectionAreaRevisionForm *InspectionAreaRevisionForm = new TInspectionAreaRevisionForm(this);
	InspectionAreaRevisionForm->srcTabletSetupData = &TabletSetupData;
  InspectionAreaRevisionForm->mode = 1;
	InspectionAreaRevisionForm->ShowModal();

	if (InspectionAreaRevisionForm->saveFlag)
	{
		memcpy(&TabletSetupData, &InspectionAreaRevisionForm->dstTabletSetupData, sizeof(TTabletSetupData));
		if (WriteSetupData(&TabletSetupData))
		{
			AnsiString fileName = GetProductDataFileName(ProductData.ProductCode);

			for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
			{
				ProductData.BoundaryLeft[globalCameraIndex] = TabletSetupData.ImageCutStartX[globalCameraIndex];
				ProductData.BoundaryTop[globalCameraIndex] = TabletSetupData.ImageCutStartY[globalCameraIndex];
				ProductData.BoundaryRight[globalCameraIndex] = TabletSetupData.ImageCutEndX[globalCameraIndex];
				ProductData.BoundaryBottom[globalCameraIndex] = TabletSetupData.ImageCutEndY[globalCameraIndex];
			}

			WriteProductData(fileName, ProductData);
			CPBSetupInfo.InspectionSetupDataValid = false;
			ShowMessage(CAPTUREFORM_MSG_05);
		}
		else
		{
			ShowMessage(CAPTUREFORM_MSG_06);
		}
	}
	delete InspectionAreaRevisionForm;
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::DirtyDefectCheckInNeighborPrintCheckBoxClick(
	TObject *Sender)
{
	if (DirtyDefectCheckInNeighborPrintCheckBox->Checked == true)
	{
		TabletGradeData.DirtyDefectCheckSWInNeighborPrint = 1;
	}
	else
	{
		TabletGradeData.DirtyDefectCheckSWInNeighborPrint = 0;
	}
}
//---------------------------------------------------------------------------


void __fastcall TGradeSettingForm::WhiteEngraveMatchingCheckBoxClick(
	TObject *Sender)
{
	SideBreakGradePanel->Visible = false;
	TntPanel4->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	if (WhiteEngraveMatchingCheckBox->Checked == true)
	{
		TabletGradeData.ETC_ApplyWhiteEngraveAlgorithm = 1;
	}
	else
	{
		TabletGradeData.ETC_ApplyWhiteEngraveAlgorithm = 0;
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::ScrollBar6Change(TObject *Sender)
{
	SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;
	IntensityValue[55] = ScrollBar6->Position;
	DisplayEachGradeValue();
	DisplayNotInspectionAera(SIDE_SHAPE, EDGE_AREA);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::ScrollBar7Change(TObject *Sender)
{
	IntensityValue[56] = ScrollBar7->Position;
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::ScrollBar8Change(TObject *Sender)
{
	IntensityValue[57] = ScrollBar8->Position;
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntTrackBar1Change(TObject *Sender)
{
	SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;
	IntensityValue[10] = ScrollBar5->Position;
	DisplayEachGradeValue();
	DisplayNotInspectionAera(SIDE_SHAPE, EDGE_AREA);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeButton30Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clRed;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	GradeBtnForMarvelTablet1->Font->Color = clMaroon;
	GradeBtnForMarvelTablet2->Font->Color = clMaroon;
	GradeBtnForMarvelTablet3->Font->Color = clMaroon;
  GradeBtnForMarvelTablet4->Font->Color = clMaroon;
	GradeBtnForMarvelTablet5->Font->Color = clMaroon;
	GradeBtnForMarvelTablet6->Font->Color = clMaroon;
	GradeBtnForMarvelTablet7->Font->Color = clMaroon;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  
	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = true;

	StaticText1->Caption = GRADESETTING_TEXT_CAPTION_05;

	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = true;
	BitBtn14->Visible = true;

	GradeSettingPanelForMarvelingTablet1->Visible = false;
	GradeSettingPanelForMarvelingTablet2->Visible = false;
  StainDefectCheckPanel->Visible = false;
	SideBreakGradePanel->Visible = false;

	SelectedDefectN = 58;
	SelectedDefectN2 = 59;

	SideEdgeIntensityBarDisplay();
	SideEdgeSizeBarDisplay();

	DisplayTabletShapeData(SIDE_SHAPE, 0, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::SideEdgeIntensityBarDisplay(void)
{
	SideEdgeDarkIntensityImage->Visible = true;

	SideEdgeDarkIntensityImage->Canvas->Brush->Style = bsSolid;
	SideEdgeDarkIntensityImage->Canvas->Brush->Color = clBlack;
	SideEdgeDarkIntensityImage->Canvas->Pen->Color = clBlack;
	SideEdgeDarkIntensityImage->Canvas->Rectangle(0, 0, SideEdgeDarkIntensityImage->Width, SideEdgeDarkIntensityImage->Height);

	SideEdgeDarkIntensityImage->Canvas->Brush->Style = bsSolid;
	SideEdgeDarkIntensityImage->Canvas->Brush->Color = (TColor)0x126596;
	SideEdgeDarkIntensityImage->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN] * (SideEdgeDarkIntensityImage->Width / 10), SideEdgeDarkIntensityImage->Height);
	SideEdgeDarkIntensityImage->Canvas->Font->Color = clBlack;
	SideEdgeDarkIntensityImage->Canvas->Font->Size = 10;
	SideEdgeDarkIntensityImage->Canvas->TextOutW(IntensityValue[SelectedDefectN] * (SideEdgeDarkIntensityImage->Width / 10) - SideEdgeDarkIntensityImage->Width / 10, 15, IntToStr(IntensityValue[SelectedDefectN]) + " Grade");

	SideEdgeBrightIntensityImage->Visible = true;

	SideEdgeBrightIntensityImage->Canvas->Brush->Style = bsSolid;
	SideEdgeBrightIntensityImage->Canvas->Brush->Color = clBlack;
	SideEdgeBrightIntensityImage->Canvas->Pen->Color = clBlack;
	SideEdgeBrightIntensityImage->Canvas->Rectangle(0, 0, SideEdgeBrightIntensityImage->Width, SideEdgeBrightIntensityImage->Height);

	SideEdgeBrightIntensityImage->Canvas->Brush->Style = bsSolid;
	SideEdgeBrightIntensityImage->Canvas->Brush->Color = (TColor)0x126596;
	SideEdgeBrightIntensityImage->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN2] * (SideEdgeBrightIntensityImage->Width / 10), SideEdgeBrightIntensityImage->Height);
	SideEdgeBrightIntensityImage->Canvas->Font->Color = clBlack;
	SideEdgeBrightIntensityImage->Canvas->Font->Size = 10;
	SideEdgeBrightIntensityImage->Canvas->TextOutW(IntensityValue[SelectedDefectN2] * (SideEdgeBrightIntensityImage->Width / 10) - SideEdgeBrightIntensityImage->Width / 10, 15, IntToStr(IntensityValue[SelectedDefectN2]) + " Grade");
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::SideEdgeSizeBarDisplay(void)
{
	SideEdgeDarkDefectSizeImage->Visible = true;

	SideEdgeDarkDefectSizeImage->Canvas->Brush->Style = bsSolid;
	SideEdgeDarkDefectSizeImage->Canvas->Brush->Color = clBlack;
	SideEdgeDarkDefectSizeImage->Canvas->Pen->Color = clBlack;
	SideEdgeDarkDefectSizeImage->Canvas->Rectangle(0, 0, SideEdgeDarkDefectSizeImage->Width, SideEdgeDarkDefectSizeImage->Height);

	SideEdgeDarkDefectSizeImage->Canvas->Brush->Style = bsSolid;
	SideEdgeDarkDefectSizeImage->Canvas->Brush->Color = (TColor)0x656596;
	SideEdgeDarkDefectSizeImage->Canvas->Rectangle(0, 0, SizeValue[SelectedDefectN] / 10 * 3, SideEdgeDarkDefectSizeImage->Height);
	SideEdgeDarkDefectSizeImage->Canvas->Font->Color = clBlack;
	SideEdgeDarkDefectSizeImage->Canvas->Font->Size = 10;
	SideEdgeDarkDefectSizeImage->Canvas->TextOutW(SizeValue[SelectedDefectN] / 10 * 3 + 10, 15, FloatToStr((float)SizeValue[SelectedDefectN] / 1000.0) + " mm");

	SideEdgeBrightDefectSizeImage->Visible = true;

	SideEdgeBrightDefectSizeImage->Canvas->Brush->Style = bsSolid;
	SideEdgeBrightDefectSizeImage->Canvas->Brush->Color = clBlack;
	SideEdgeBrightDefectSizeImage->Canvas->Pen->Color = clBlack;
	SideEdgeBrightDefectSizeImage->Canvas->Rectangle(0, 0, SideEdgeBrightDefectSizeImage->Width, SideEdgeBrightDefectSizeImage->Height);

	SideEdgeBrightDefectSizeImage->Canvas->Brush->Style = bsSolid;
	SideEdgeBrightDefectSizeImage->Canvas->Brush->Color = (TColor)0x656596;
	SideEdgeBrightDefectSizeImage->Canvas->Rectangle(0, 0, SizeValue[SelectedDefectN2] / 10 * 3, SideEdgeBrightDefectSizeImage->Height);
	SideEdgeBrightDefectSizeImage->Canvas->Font->Color = clBlack;
	SideEdgeBrightDefectSizeImage->Canvas->Font->Size = 10;
	SideEdgeBrightDefectSizeImage->Canvas->TextOutW(SizeValue[SelectedDefectN2] / 10 * 3 + 10, 15, FloatToStr((float)SizeValue[SelectedDefectN2] / 1000.0) + " mm");
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::SizeupBtn1Click(TObject *Sender)
{
	if (SizeValue[SelectedDefectN] < 2000)
	{
		SizeValue[SelectedDefectN] += 10;
		SideEdgeSizeBarDisplay();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::SizedownBtn1Click(TObject *Sender)
{
	if (SizeValue[SelectedDefectN] > 0)
	{
		SizeValue[SelectedDefectN] -= 10;
		SideEdgeSizeBarDisplay();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::Sizeupbtn2Click(TObject *Sender)
{
	if (SizeValue[SelectedDefectN2] < 2000)
	{
		SizeValue[SelectedDefectN2] += 10;
		SideEdgeSizeBarDisplay();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------


void __fastcall TGradeSettingForm::SizedownBtn2Click(TObject *Sender)
{
	if (SizeValue[SelectedDefectN2] > 0)
	{
		SizeValue[SelectedDefectN2] -= 10;
		SideEdgeSizeBarDisplay();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::SideIntensityImage1MouseDown(
	TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
	int Y)
{
	IntensityValue[SelectedDefectN] = X / (SideIntensityImage1->Width / 10) + 1;

	SideEdgeNeighborIntensityBarDisplay();
	DisplayEachGradeValue();

	SideIntensityImage1->Canvas->Brush->Style = bsSolid;
	SideIntensityImage1->Canvas->Brush->Color = clBlack;
	SideIntensityImage1->Canvas->Pen->Color = clBlack;
	SideIntensityImage1->Canvas->Rectangle(0, 0, SideIntensityImage1->Width, SideIntensityImage1->Height);

	SideIntensityImage1->Canvas->Brush->Style = bsSolid;
	SideIntensityImage1->Canvas->Brush->Color = (TColor)0x126596;
	SideIntensityImage1->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN] * (SideIntensityImage1->Width / 10), SideIntensityImage1->Height);
	SideIntensityImage1->Canvas->Font->Color = clBlack;
	SideIntensityImage1->Canvas->Font->Size = 10;
	SideIntensityImage1->Canvas->TextOutW(IntensityValue[SelectedDefectN] * (SideIntensityImage1->Width / 10) - SideIntensityImage1->Width / 10, 15, IntToStr(IntensityValue[SelectedDefectN]) + " Grade");
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::SideDefectSizeImageMouseDown(
	TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
	int Y)
{
	SizeValue[SelectedDefectN] = X / 3 * 10;
	SideEdgeNeighborSizeBarDisplay();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::SideEdgeDarkIntensityImageMouseDown(
	TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
	int Y)
{
	IntensityValue[SelectedDefectN] = X / (SideEdgeDarkIntensityImage->Width / 10) + 1;

	SideEdgeIntensityBarDisplay();
	DisplayEachGradeValue();

	SideEdgeDarkIntensityImage->Canvas->Brush->Style = bsSolid;
	SideEdgeDarkIntensityImage->Canvas->Brush->Color = clBlack;
	SideEdgeDarkIntensityImage->Canvas->Pen->Color = clBlack;
	SideEdgeDarkIntensityImage->Canvas->Rectangle(0, 0, SideEdgeDarkIntensityImage->Width, SideEdgeDarkIntensityImage->Height);

	SideEdgeDarkIntensityImage->Canvas->Brush->Style = bsSolid;
	SideEdgeDarkIntensityImage->Canvas->Brush->Color = (TColor)0x126596;
	SideEdgeDarkIntensityImage->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN] * (SideEdgeDarkIntensityImage->Width / 10), SideEdgeDarkIntensityImage->Height);
	SideEdgeDarkIntensityImage->Canvas->Font->Color = clBlack;
	SideEdgeDarkIntensityImage->Canvas->Font->Size = 10;
	SideEdgeDarkIntensityImage->Canvas->TextOutW(IntensityValue[SelectedDefectN] * (SideEdgeDarkIntensityImage->Width / 10) - SideEdgeDarkIntensityImage->Width / 10, 15, IntToStr(IntensityValue[SelectedDefectN]) + " Grade");
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::SideEdgeDarkDefectSizeImageMouseDown(
	TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
	int Y)
{
	SizeValue[SelectedDefectN] = X / 3 * 10;
	SideEdgeSizeBarDisplay();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::SideEdgeBrightIntensityImageMouseDown(
	TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
	int Y)
{
	IntensityValue[SelectedDefectN2] = X / (SideEdgeBrightIntensityImage->Width / 10) + 1;

	SideEdgeIntensityBarDisplay();
	DisplayEachGradeValue();

	SideEdgeBrightIntensityImage->Canvas->Brush->Style = bsSolid;
	SideEdgeBrightIntensityImage->Canvas->Brush->Color = clBlack;
	SideEdgeBrightIntensityImage->Canvas->Pen->Color = clBlack;
	SideEdgeBrightIntensityImage->Canvas->Rectangle(0, 0, SideEdgeBrightIntensityImage->Width, SideEdgeBrightIntensityImage->Height);

	SideEdgeBrightIntensityImage->Canvas->Brush->Style = bsSolid;
	SideEdgeBrightIntensityImage->Canvas->Brush->Color = (TColor)0x126596;
	SideEdgeBrightIntensityImage->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN2] * (SideEdgeBrightIntensityImage->Width / 10), SideEdgeBrightIntensityImage->Height);
	SideEdgeBrightIntensityImage->Canvas->Font->Color = clBlack;
	SideEdgeBrightIntensityImage->Canvas->Font->Size = 10;
	SideEdgeBrightIntensityImage->Canvas->TextOutW(IntensityValue[SelectedDefectN2] * (SideEdgeBrightIntensityImage->Width / 10) - SideEdgeBrightIntensityImage->Width / 10, 15, IntToStr(IntensityValue[SelectedDefectN2]) + " Grade");
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::SideEdgeBrightDefectSizeImageMouseDown(
	TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
	int Y)
{
	SizeValue[SelectedDefectN2] = X / 3 * 10;
	SideEdgeSizeBarDisplay();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::CheckBox6Click(TObject *Sender)
{
	if (CheckBox6->Checked == true)
	{
		TabletGradeData.ETC_AdjustUnalignedTabletAlgorithm = 1;
	}
	else
	{
		TabletGradeData.ETC_AdjustUnalignedTabletAlgorithm = 0;
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeButton31Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clRed;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	GradeBtnForMarvelTablet1->Font->Color = clMaroon;
	GradeBtnForMarvelTablet2->Font->Color = clMaroon;
	GradeBtnForMarvelTablet3->Font->Color = clMaroon;
  GradeBtnForMarvelTablet4->Font->Color = clMaroon;
	GradeBtnForMarvelTablet5->Font->Color = clMaroon;
	GradeBtnForMarvelTablet6->Font->Color = clMaroon;
	GradeBtnForMarvelTablet7->Font->Color = clMaroon;
	// end. ߰ Btn

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;

	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;

	GradeSettingPanelForMarvelingTablet1->Visible = false;
	GradeSettingPanelForMarvelingTablet2->Visible = false;
  StainDefectCheckPanel->Visible = false;
	SideBreakGradePanel->Visible = true;
	// end. űԷ 򰡵  г

	SideBreakThresholdLabel->Caption = GRADESETTING_ETC_CAPTION_33;
	SideBreakSizeLabel->Caption = GRADESETTING_TEXT_CAPTION_07;

	SelectedDefectN = 60;

  SideEdgeNeighborBreakIntensityBarDisplay();
  SideEdgeNeighborBreakSizeBarDisplay();

	DisplayTabletShapeData(SIDE_SHAPE, 0, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::SideEdgeNeighborBreakIntensityBarDisplay(void)
{
	SideBreakThresholdImage->Visible = true;

	SideBreakThresholdImage->Canvas->Brush->Style = bsSolid;
	SideBreakThresholdImage->Canvas->Brush->Color = clBlack;
	SideBreakThresholdImage->Canvas->Pen->Color = clBlack;
	SideBreakThresholdImage->Canvas->Rectangle(0, 0, SideBreakThresholdImage->Width, SideBreakThresholdImage->Height);

	SideBreakThresholdImage->Canvas->Brush->Style = bsSolid;
	SideBreakThresholdImage->Canvas->Brush->Color = (TColor)0x126596;
	SideBreakThresholdImage->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN] * (SideBreakThresholdImage->Width / 10), SideBreakThresholdImage->Height);
	SideBreakThresholdImage->Canvas->Font->Color = clBlack;
	SideBreakThresholdImage->Canvas->Font->Size = 10;
	SideBreakThresholdImage->Canvas->TextOutW(IntensityValue[SelectedDefectN] * (SideBreakThresholdImage->Width / 10) - SideBreakThresholdImage->Width / 10, 15, IntToStr(IntensityValue[SelectedDefectN]) + " Grade");
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::SideEdgeNeighborBreakSizeBarDisplay(void)
{
	SideBreakDefectSizeImage->Visible = true;

	SideBreakDefectSizeImage->Canvas->Brush->Style = bsSolid;
	SideBreakDefectSizeImage->Canvas->Brush->Color = clBlack;
	SideBreakDefectSizeImage->Canvas->Pen->Color = clBlack;
	SideBreakDefectSizeImage->Canvas->Rectangle(0, 0, SideBreakDefectSizeImage->Width, SideBreakDefectSizeImage->Height);

	SideBreakDefectSizeImage->Canvas->Brush->Style = bsSolid;
	SideBreakDefectSizeImage->Canvas->Brush->Color = (TColor)0x656596;
	SideBreakDefectSizeImage->Canvas->Rectangle(0, 0, SizeValue[SelectedDefectN] / 10 * 3, SideBreakDefectSizeImage->Height);
	SideBreakDefectSizeImage->Canvas->Font->Color = clBlack;
	SideBreakDefectSizeImage->Canvas->Font->Size = 10;
	SideBreakDefectSizeImage->Canvas->TextOutW(SizeValue[SelectedDefectN] / 10 * 3 + 10, 15, FloatToStr((float)SizeValue[SelectedDefectN] / 1000.0) + " mm");
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::SideBreakThresholdImageMouseDown(
	TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
	int Y)
{
	IntensityValue[SelectedDefectN] = X / (SideBreakThresholdImage->Width / 10) + 1;

	SideEdgeNeighborBreakIntensityBarDisplay();
	DisplayEachGradeValue();

	SideBreakThresholdImage->Canvas->Brush->Style = bsSolid;
	SideBreakThresholdImage->Canvas->Brush->Color = clBlack;
	SideBreakThresholdImage->Canvas->Pen->Color = clBlack;
	SideBreakThresholdImage->Canvas->Rectangle(0, 0, SideBreakThresholdImage->Width, SideBreakThresholdImage->Height);

	SideBreakThresholdImage->Canvas->Brush->Style = bsSolid;
	SideBreakThresholdImage->Canvas->Brush->Color = (TColor)0x126596;
	SideBreakThresholdImage->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN] * (SideBreakThresholdImage->Width / 10), SideBreakThresholdImage->Height);
	SideBreakThresholdImage->Canvas->Font->Color = clBlack;
	SideBreakThresholdImage->Canvas->Font->Size = 10;
	SideBreakThresholdImage->Canvas->TextOutW(IntensityValue[SelectedDefectN] * (SideBreakThresholdImage->Width / 10) - SideBreakThresholdImage->Width / 10, 15, IntToStr(IntensityValue[SelectedDefectN]) + " Grade");
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::SideBreakDefectSizeImageMouseDown(
	TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
	int Y)
{
	SizeValue[SelectedDefectN] = X / 3 * 10;
	SideEdgeNeighborBreakSizeBarDisplay();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::AdjustSideBreakDefectSizeMinusButtonClick(
	TObject *Sender)
{
	if (SizeValue[SelectedDefectN] > 0)
	{
		SizeValue[SelectedDefectN] -= 10;
		SideEdgeNeighborBreakSizeBarDisplay();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::AdjustSideBreakDefectSizePlusButtonClick(
	TObject *Sender)
{
	if (SizeValue[SelectedDefectN] < 2000)
	{
		SizeValue[SelectedDefectN] += 10;
		SideEdgeNeighborBreakSizeBarDisplay();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::SideBreakDepthSettingScrollBarChange(
      TObject *Sender)
{
  ETC_Side_Break_Depth_Size = SideBreakDepthSettingScrollBar->Position;
	DisplayEachGradeValue();  
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::NoneHorizontalityTabletCheckBoxClick(
      TObject *Sender)
{
  TntPanel4->Visible = false;
	SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	if (NoneHorizontalityTabletCheckBox->Checked == true)
	{
		TabletGradeData.ETC_Side_None_Horizontality_Tablet = 1;
	}
	else
	{
		TabletGradeData.ETC_Side_None_Horizontality_Tablet = 0;
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::SplitLineUnInspectionAreaSettingCheckBoxClick(
      TObject *Sender)
{
  TntPanel4->Visible = false;
	SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	if (SplitLineUnInspectionAreaSettingCheckBox->Checked == true)
	{
		TabletGradeData.ETC_Side_Split_Line_UnInspection_Area_Setting = 1;
	}
	else
	{
		TabletGradeData.ETC_Side_Split_Line_UnInspection_Area_Setting = 0;
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::EngraveWhiteDefectCheckBoxClick(
      TObject *Sender)
{
  if (EngraveWhiteDefectCheckBox->Checked == true)
	{
		TabletGradeData.ETC_EngraveWhiteDefectCheckAlgorithm = 1;
	}
	else
	{
		TabletGradeData.ETC_EngraveWhiteDefectCheckAlgorithm = 0;
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::EngraveColorIntensityImageDisplay(void)
{
  EngraveColorIntensityImage->Visible = true;

  AnsiString grade;
  int textWidth;

  TLabel *tempLabel = new TLabel(this);
  tempLabel->Caption = "";
  tempLabel->Font = EngraveColorIntensityImage->Canvas->Font;
  tempLabel->Font->Size = 10;
  tempLabel->Width = 0;

  grade = IntToStr(IntensityValue[61]) + " Grade";
  tempLabel->Caption = grade;
  textWidth = tempLabel->Width + 4;

	EngraveColorIntensityImage->Canvas->Brush->Style = bsSolid;
	EngraveColorIntensityImage->Canvas->Brush->Color = clBlack;
	EngraveColorIntensityImage->Canvas->Pen->Color = clBlack;
	EngraveColorIntensityImage->Canvas->Rectangle(0, 0, EngraveColorIntensityImage->Width, EngraveColorIntensityImage->Height);

  EngraveColorIntensityImage->Canvas->Brush->Style = bsSolid;
  EngraveColorIntensityImage->Canvas->Brush->Color = (TColor)0x126596;
  EngraveColorIntensityImage->Canvas->Rectangle(0, 0, IntensityValue[61] * (EngraveColorIntensityImage->Width / 20), EngraveColorIntensityImage->Height);
  EngraveColorIntensityImage->Canvas->Font->Color = clBlack;
  EngraveColorIntensityImage->Canvas->Font->Size = 10;
  EngraveColorIntensityImage->Canvas->TextOutW(IntensityValue[61] * (EngraveColorIntensityImage->Width / 20) - textWidth, 15, grade);
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::EngraveColorIntensityImageMouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  IntensityValue[61] = X / (EngraveColorIntensityImage->Width / 20) + 1;

  EngraveColorIntensityImageDisplay();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::EngraveWhiteSpotIntensityImageDisplay(void)
{
  EngraveWhiteSpotIntensityImage->Visible = true;
  
  AnsiString grade;
  int textWidth;

  TLabel *tempLabel = new TLabel(this);
  tempLabel->Caption = "";
  tempLabel->Font = EngraveWhiteSpotIntensityImage->Canvas->Font;
  tempLabel->Font->Size = 10;
  tempLabel->Width = 0;

  grade = IntToStr(IntensityValue[62]) + " Grade";
  tempLabel->Caption = grade;
  textWidth = tempLabel->Width + 4;

	EngraveWhiteSpotIntensityImage->Canvas->Brush->Style = bsSolid;
	EngraveWhiteSpotIntensityImage->Canvas->Brush->Color = clBlack;
	EngraveWhiteSpotIntensityImage->Canvas->Pen->Color = clBlack;
	EngraveWhiteSpotIntensityImage->Canvas->Rectangle(0, 0, EngraveWhiteSpotIntensityImage->Width, EngraveWhiteSpotIntensityImage->Height);

  EngraveWhiteSpotIntensityImage->Canvas->Brush->Style = bsSolid;
  EngraveWhiteSpotIntensityImage->Canvas->Brush->Color = (TColor)0x126596;
  EngraveWhiteSpotIntensityImage->Canvas->Rectangle(0, 0, IntensityValue[62] * (EngraveWhiteSpotIntensityImage->Width / 20), EngraveWhiteSpotIntensityImage->Height);
  EngraveWhiteSpotIntensityImage->Canvas->Font->Color = clBlack;
  EngraveWhiteSpotIntensityImage->Canvas->Font->Size = 10;
  EngraveWhiteSpotIntensityImage->Canvas->TextOutW(IntensityValue[62] * (EngraveWhiteSpotIntensityImage->Width / 20) - textWidth, 15, grade);
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::EngraveWhiteSpotIntensityImageMouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  IntensityValue[62] = X / (EngraveWhiteSpotIntensityImage->Width / 20) + 1;

  EngraveWhiteSpotIntensityImageDisplay();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntBitBtn11Click(TObject *Sender)
{
  if (SizeValue[62] < 2000)
	{
		SizeValue[62] += 10;
		WhiteSpotSizeImageDisplay();
		DisplayEachGradeValue();
	}  
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntBitBtn10Click(TObject *Sender)
{
  if (SizeValue[62] < 2000)
	{
		SizeValue[62] -= 10;
		WhiteSpotSizeImageDisplay();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::WhiteSpotSizeImageDisplay(void)
{
	EnagraveWhiteSpotSizeImage->Canvas->Brush->Style = bsSolid;
	EnagraveWhiteSpotSizeImage->Canvas->Brush->Color = clBlack;
	EnagraveWhiteSpotSizeImage->Canvas->Pen->Color = clBlack;
	EnagraveWhiteSpotSizeImage->Canvas->Rectangle(0, 0, EnagraveWhiteSpotSizeImage->Width, EnagraveWhiteSpotSizeImage->Height);

	EnagraveWhiteSpotSizeImage->Canvas->Brush->Style = bsSolid;
	EnagraveWhiteSpotSizeImage->Canvas->Brush->Color = (TColor)0x656596;
	EnagraveWhiteSpotSizeImage->Canvas->Rectangle(0, 0, SizeValue[62] / 10 * 3, EnagraveWhiteSpotSizeImage->Height);
	EnagraveWhiteSpotSizeImage->Canvas->Font->Color = clBlack;
	EnagraveWhiteSpotSizeImage->Canvas->Font->Size = 10;
	EnagraveWhiteSpotSizeImage->Canvas->TextOutW(SizeValue[62] / 10 * 3 + 10, 15, FloatToStr((float)SizeValue[62] / 1000.0) + " mm");
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::EnagraveWhiteSpotSizeImageMouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  SizeValue[62] = X / 3 * 10;
	WhiteSpotSizeImageDisplay();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeBtnForMarvelTablet4Click(
      TObject *Sender)
{
  GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;
	// end.  ϴ Btn

	GradeBtnForMarvelTablet1->Font->Color = clMaroon;
	GradeBtnForMarvelTablet2->Font->Color = clMaroon;
	GradeBtnForMarvelTablet3->Font->Color = clMaroon;
  GradeBtnForMarvelTablet4->Font->Color = clRed;
	GradeBtnForMarvelTablet5->Font->Color = clMaroon;
	GradeBtnForMarvelTablet6->Font->Color = clMaroon;
	GradeBtnForMarvelTablet7->Font->Color = clMaroon;
	// end. ߰ Btn

	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  
	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = false;
	BitBtn14->Visible = false;
	// end.  ϴ   г

	GradeSettingPanelForMarvelingTablet1->Visible = false;
	GradeSettingPanelForMarvelingTablet2->Visible = false;
  SideBreakGradePanel->Visible = false;
  StainDefectCheckPanel->Visible = true;
	SideBreakGradePanel->Visible = false;
	// end. űԷ 򰡵  г

  StainDefectCheckAreaSizeImageDisplay();
  StainDefectCheckThresholdImageDisplay();
  StainDefectSizeImageDisplay();

	DisplayTabletShapeData(FRONT_SHAPE, NOT_PRINT_AREA, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::EnforcementStainDefectCheckAlgorithmCheckBoxClick(
      TObject *Sender)
{
  if (EnforcementStainDefectCheckAlgorithmCheckBox->Checked == true)
	{
		TabletGradeData.ETC_EnforcementStainDefectCheckAlgorithm = 1;
	}
	else
	{
		TabletGradeData.ETC_EnforcementStainDefectCheckAlgorithm = 0;
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::InspectionAreaSizeImageMouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  IntensityValue[63] = X / (InspectionAreaSizeImage->Width / 100) + 1;

  StainDefectCheckAreaSizeImageDisplay();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::StainDefectCheckAreaSizeImageDisplay(void)
{
  InspectionAreaSizeImage->Visible = true;

  AnsiString grade;
  int textWidth;

  TLabel *tempLabel = new TLabel(this);
  tempLabel->Caption = "";
  tempLabel->Font = InspectionAreaSizeImage->Canvas->Font;
  tempLabel->Font->Size = 10;
  tempLabel->Width = 0;

  grade = IntToStr(IntensityValue[63]) + " %";
  tempLabel->Caption = grade;
  textWidth = tempLabel->Width + 4;

	InspectionAreaSizeImage->Canvas->Brush->Style = bsSolid;
	InspectionAreaSizeImage->Canvas->Brush->Color = clBlack;
	InspectionAreaSizeImage->Canvas->Pen->Color = clBlack;
	InspectionAreaSizeImage->Canvas->Rectangle(0, 0, InspectionAreaSizeImage->Width, InspectionAreaSizeImage->Height);

  InspectionAreaSizeImage->Canvas->Brush->Style = bsSolid;
  InspectionAreaSizeImage->Canvas->Brush->Color = (TColor)0x126596;
  InspectionAreaSizeImage->Canvas->Rectangle(0, 0, IntensityValue[63] * (InspectionAreaSizeImage->Width / 100), InspectionAreaSizeImage->Height);
  InspectionAreaSizeImage->Canvas->Font->Color = clBlack;
  InspectionAreaSizeImage->Canvas->Font->Size = 10;
  InspectionAreaSizeImage->Canvas->TextOutW(IntensityValue[63] * (InspectionAreaSizeImage->Width / 100) - textWidth, 15, grade);
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::StainDefectThresholdImageMouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  IntensityValue[64] = X / (StainDefectThresholdImage->Width / 20) + 1;

  StainDefectCheckThresholdImageDisplay();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::StainDefectCheckThresholdImageDisplay(void)
{
  StainDefectThresholdImage->Visible = true;

  AnsiString grade;
  int textWidth;

  TLabel *tempLabel = new TLabel(this);
  tempLabel->Caption = "";
  tempLabel->Font = StainDefectThresholdImage->Canvas->Font;
  tempLabel->Font->Size = 10;
  tempLabel->Width = 0;

  grade = IntToStr(IntensityValue[64]) + " Grade";
  tempLabel->Caption = grade;
  textWidth = tempLabel->Width + 4;

	StainDefectThresholdImage->Canvas->Brush->Style = bsSolid;
	StainDefectThresholdImage->Canvas->Brush->Color = clBlack;
	StainDefectThresholdImage->Canvas->Pen->Color = clBlack;
	StainDefectThresholdImage->Canvas->Rectangle(0, 0, StainDefectThresholdImage->Width, StainDefectThresholdImage->Height);

  StainDefectThresholdImage->Canvas->Brush->Style = bsSolid;
  StainDefectThresholdImage->Canvas->Brush->Color = (TColor)0x126596;
  StainDefectThresholdImage->Canvas->Rectangle(0, 0, IntensityValue[64] * (StainDefectThresholdImage->Width / 20), StainDefectThresholdImage->Height);
  StainDefectThresholdImage->Canvas->Font->Color = clBlack;
  StainDefectThresholdImage->Canvas->Font->Size = 10;
  StainDefectThresholdImage->Canvas->TextOutW(IntensityValue[64] * (StainDefectThresholdImage->Width / 20) - textWidth, 15, grade);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::MaxLabelStainDefectSizeImageMouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  SizeValue[65] = X / 3 * 10;
	StainDefectSizeImageDisplay();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::AllGroupStainDefectSizeImageMouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  SizeValue[66] = X / 3 * 10;
	StainDefectSizeImageDisplay();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::StainDefectSizeImageDisplay(void)
{
	MaxLabelStainDefectSizeImage->Canvas->Brush->Style = bsSolid;
	MaxLabelStainDefectSizeImage->Canvas->Brush->Color = clBlack;
	MaxLabelStainDefectSizeImage->Canvas->Pen->Color = clBlack;
	MaxLabelStainDefectSizeImage->Canvas->Rectangle(0, 0, MaxLabelStainDefectSizeImage->Width, MaxLabelStainDefectSizeImage->Height);

	MaxLabelStainDefectSizeImage->Canvas->Brush->Style = bsSolid;
	MaxLabelStainDefectSizeImage->Canvas->Brush->Color = (TColor)0x656596;
	MaxLabelStainDefectSizeImage->Canvas->Rectangle(0, 0, SizeValue[65] / 10 * 3, MaxLabelStainDefectSizeImage->Height);
	MaxLabelStainDefectSizeImage->Canvas->Font->Color = clBlack;
	MaxLabelStainDefectSizeImage->Canvas->Font->Size = 10;
	MaxLabelStainDefectSizeImage->Canvas->TextOutW(SizeValue[65] / 10 * 3 + 10, 15, FloatToStr((float)SizeValue[65] / 1000.0) + " mm");

  AllGroupStainDefectSizeImage->Canvas->Brush->Style = bsSolid;
	AllGroupStainDefectSizeImage->Canvas->Brush->Color = clBlack;
	AllGroupStainDefectSizeImage->Canvas->Pen->Color = clBlack;
	AllGroupStainDefectSizeImage->Canvas->Rectangle(0, 0, AllGroupStainDefectSizeImage->Width, AllGroupStainDefectSizeImage->Height);

	AllGroupStainDefectSizeImage->Canvas->Brush->Style = bsSolid;
	AllGroupStainDefectSizeImage->Canvas->Brush->Color = (TColor)0x656596;
	AllGroupStainDefectSizeImage->Canvas->Rectangle(0, 0, SizeValue[66] / 10 * 3, AllGroupStainDefectSizeImage->Height);
	AllGroupStainDefectSizeImage->Canvas->Font->Color = clBlack;
	AllGroupStainDefectSizeImage->Canvas->Font->Size = 10;
	AllGroupStainDefectSizeImage->Canvas->TextOutW(SizeValue[66] / 10 * 3 + 10, 15, FloatToStr((float)SizeValue[66] / 1000.0) + " mm");
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::TntBitBtn13Click(TObject *Sender)
{
  if (SizeValue[65] < 2000)
	{
		SizeValue[65] += 10;
		StainDefectSizeImageDisplay();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntBitBtn15Click(TObject *Sender)
{
  if (SizeValue[66] < 2000)
	{
		SizeValue[66] += 10;
		StainDefectSizeImageDisplay();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntBitBtn12Click(TObject *Sender)
{
  if (SizeValue[65] < 2000)
	{
		SizeValue[65] -= 10;
		StainDefectSizeImageDisplay();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntBitBtn14Click(TObject *Sender)
{
  if (SizeValue[66] < 2000)
	{
		SizeValue[66] -= 10;
		StainDefectSizeImageDisplay();
		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::FrontFaceSplitLineRecognizationBtnClick(
      TObject *Sender)
{
  SideBreakGradePanel->Visible = false;
	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = true;
  LIMAGradeSettingPanel->Visible = false;
	SplitLineRecognizationOptionPanel->BringToFront();
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::SplitLineThresholdBarDisplay(void)
{
  FrontFaceSplitLineThresholdImage->Canvas->Brush->Style = bsSolid;
	FrontFaceSplitLineThresholdImage->Canvas->Brush->Color = clBlack;
	FrontFaceSplitLineThresholdImage->Canvas->Pen->Color = clBlack;
	FrontFaceSplitLineThresholdImage->Canvas->Rectangle(0, 0, FrontFaceSplitLineThresholdImage->Width, FrontFaceSplitLineThresholdImage->Height);

	FrontFaceSplitLineThresholdImage->Canvas->Brush->Style = bsSolid;
	FrontFaceSplitLineThresholdImage->Canvas->Brush->Color = (TColor)0x126596;
	FrontFaceSplitLineThresholdImage->Canvas->Rectangle(0, 0, IntensityValue[67] * (FrontFaceSplitLineThresholdImage->Width / 20), FrontFaceSplitLineThresholdImage->Height);
	FrontFaceSplitLineThresholdImage->Canvas->Font->Color = clBlack;
	FrontFaceSplitLineThresholdImage->Canvas->Font->Size = 10;

	if (IntensityValue[67] < 4)
		FrontFaceSplitLineThresholdImage->Canvas->TextOutW(IntensityValue[67] * (FrontFaceSplitLineThresholdImage->Width / 20) - FrontFaceSplitLineThresholdImage->Width / 20, 15, IntToStr(IntensityValue[67]) + " Grade");
	else
		FrontFaceSplitLineThresholdImage->Canvas->TextOutW(IntensityValue[67] * (FrontFaceSplitLineThresholdImage->Width / 20) - FrontFaceSplitLineThresholdImage->Width / 20 - 60, 15, IntToStr(IntensityValue[67]) + " Grade");
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::FrontFaceSplitLineOptionCheckBoxClick(
      TObject *Sender)
{
  TntPanel4->Visible = false;
	SideBreakGradePanel->Visible = false;

	if (FrontFaceSplitLineOptionCheckBox->Checked)
	{
		TabletGradeData.SplitLineMatchingSWForPrintTablet = 1;
	}
	else
	{
		TabletGradeData.SplitLineMatchingSWForPrintTablet = 0;
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::FrontFaceSplitLineThresholdImageMouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  TntPanel4->Visible = false;
	SideBreakGradePanel->Visible = false;

	IntensityValue[67] = X / (FrontFaceSplitLineThresholdImage->Width / 20) + 1;
	SplitLineThresholdBarDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::Button3Click(TObject *Sender)
{
  SideBreakGradePanel->Visible = false;
	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::Button1Click(TObject *Sender)
{
  SideBreakGradePanel->Visible = false;
	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::EngraveMaskSizeTrackBarChange(
      TObject *Sender)
{
  IntensityValue[68] = EngraveMaskSizeTrackBar->Position;
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::PrintPositionDefectTrackBarChange(
      TObject *Sender)
{
  int value;
	SideBreakGradePanel->Visible = false;
	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;

	IntensityValue[69] = PrintPositionDefectTrackBar->Position;
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------


void __fastcall TGradeSettingForm::Apply2DEngraveMatchingOption_LimitRangeClick(
      TObject *Sender)
{
  if (Apply2DEngraveMatchingOption_LimitRange->Checked == true)
	{
		TabletGradeData.ETC_EngraveMatchingOption_ReflectedTabletShape = 1;
	}
	else
	{
		TabletGradeData.ETC_EngraveMatchingOption_ReflectedTabletShape = 0;
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::Apply2DEngraveMatchingOption_LightEngraveClick(
      TObject *Sender)
{
  if (Apply2DEngraveMatchingOption_LightEngrave->Checked == true)
	{
		TabletGradeData.ETC_EngraveMatchingOption_LightEngrave = 1;
	}
	else
	{
		TabletGradeData.ETC_EngraveMatchingOption_LightEngrave = 0;
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::PreviewInspectionBtnClick(
      TObject *Sender)
{
  TPreviewInspectionForm *previewInspectionForm = new TPreviewInspectionForm(this);
  MakeGradeDataForPreview(&previewInspectionForm->previewSrcGradeData);
  previewInspectionForm->ShowModal();
  delete previewInspectionForm;
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::MakeGradeDataForPreview(TTabletGradeData *pGradeData)
{
	pGradeData->front_dirty_Intensity = IntensityValue[1];
	pGradeData->front_dirty_Size = Table_Interval_PixelAndMeter[SizeValue[1] / 10];

	pGradeData->front_print_dirty_Inetensity = IntensityValue[2];
  pGradeData->front_print_dirty_Inetensity2 = IntensityValue[74];

	pGradeData->front_stain_Intensity = IntensityValue[3];
	pGradeData->front_stain_Size = Table_Interval_PixelAndMeter[SizeValue[3] / 10];

	pGradeData->front_edge_dirty_Intensity = IntensityValue[4];
	pGradeData->front_edge_dirty_Size = Table_Interval_PixelAndMeter[SizeValue[4] / 10];

	pGradeData->front_edge_Intensity = IntensityValue[5];
	pGradeData->front_edge_Size = Table_Interval_PixelAndMeter[SizeValue[5] / 10];

  pGradeData->option_front_edgeBreaking_Intensity_Type1 = IntensityValue[7];
	pGradeData->option_front_edgeBreaking_Size_Type1 = Table_Interval_PixelAndMeterForThreeD[SizeValue[7] / 10];

  pGradeData->option_front_edgeBreaking_Intensity_Type2 = IntensityValue[71];
	pGradeData->option_front_edgeBreaking_Size_Type2 = Table_Interval_PixelAndMeterForThreeD[SizeValue[71] / 10];

	pGradeData->option_Breaking_Intensity = IntensityValue[6];
	pGradeData->option_PrintMark_Intensity = IntensityValue[12];

	pGradeData->option_Breaking_Size = Table_Interval_PixelAndMeterForThreeD[SizeValue[6] / 10];

	pGradeData->side_dirty_Intensity = IntensityValue[8];
	pGradeData->side_dirty_Size = Table_Interval_PixelAndMeter[SizeValue[8] / 10];

	pGradeData->side_stain_Intensity = IntensityValue[9];
	pGradeData->side_stain_Size = Table_Interval_PixelAndMeter[SizeValue[9] / 10];

	pGradeData->side_Edge_Top_Neighbor_Intensity = IntensityValue[10];
	pGradeData->side_Edge_Bottom_Neighbor_Intensity = IntensityValue[55];

	pGradeData->SideFaceEdgeAreaSize = IntensityValue[56];
	pGradeData->SideFaceEdgeUnInsAreaSize = IntensityValue[57];

	pGradeData->front_color_Intensity = IntensityValue[11];
  pGradeData->FrontFaceEngraveColorGrade = IntensityValue[61];

  pGradeData->FrontFaceEngraveWhiteSpotIntensity = IntensityValue[62];
  pGradeData->FrontFaceEngraveWhiteSpotSize = Table_Interval_PixelAndMeter[SizeValue[62] / 10];

  pGradeData->EnforcementStainDefectInspectionAreaSize = IntensityValue[63];
  pGradeData->EnforcementStainDefectThreshold = IntensityValue[64];
  pGradeData->EnforcementStainDefectMaxLabelSize = Table_Interval_PixelAndMeter[SizeValue[65] / 10];
  pGradeData->EnforcementStainDefectAllGroupSize = Table_Interval_PixelAndMeter[SizeValue[66] / 10];

	pGradeData->front_print_erase_Intensity = IntensityValue[13];

	if (ProductData.EngraveType == ENGRAVE_TYPE_PRINT)
	{
		pGradeData->front_print_spread_Intensity = IntensityValue[14];
		pGradeData->EngraveDistinguishGrade = 20;
	}
	else
	{
		pGradeData->front_print_spread_Intensity = 20;
		pGradeData->EngraveDistinguishGrade = IntensityValue[14];
	}

	pGradeData->front_Color_Dirty_Intensity = IntensityValue[15];
	pGradeData->front_Color_Dirty_Size = Table_Interval_PixelAndMeter[SizeValue[15] / 10];


	pGradeData->rear_dirty_Intensity = IntensityValue[16];
	pGradeData->rear_dirty_Size = Table_Interval_PixelAndMeter[SizeValue[16] / 10];

	pGradeData->rear_print_dirty_Inetensity = IntensityValue[17];

	pGradeData->rear_edge_dirty_Intensity = IntensityValue[18];
	pGradeData->rear_edge_dirty_Size = Table_Interval_PixelAndMeter[SizeValue[18] / 10];

	pGradeData->rear_stain_Intensity = IntensityValue[19];
	pGradeData->rear_stain_Size = Table_Interval_PixelAndMeter[SizeValue[19] / 10];

	pGradeData->rear_edge_Intensity = IntensityValue[20];
	pGradeData->rear_edge_Size = Table_Interval_PixelAndMeter[SizeValue[20] / 10];

	pGradeData->rear_Color_Dirty_Intensity = IntensityValue[21];
	pGradeData->rear_Color_Dirty_Size = Table_Interval_PixelAndMeter[SizeValue[21] / 10];

	pGradeData->front_unInspectionIntensity_ForPrint = IntensityValue[22];
	pGradeData->front_unInspectionIntensity_ForEdge = IntensityValue[23];
	pGradeData->front_unInspectionIntensity_ForOptionPrint = IntensityValue[24];
	pGradeData->front_unInspectionIntensity_ForOptionEdge = IntensityValue[25];
	pGradeData->FrontEdgeAreaExtendSW = IntensityValue[26];
  pGradeData->CoatedTablet_SideInspectionAreaSize = IntensityValue[26];
	pGradeData->ETC_SideFaceMultiTabletUnInspectionSize = IntensityValue[47];

	pGradeData->side_Color_Dirty_Intensity = IntensityValue[28];
	pGradeData->side_Color_Dirty_Size = Table_Interval_PixelAndMeter[SizeValue[28] / 10];

  pGradeData->side_Edge_Color_Dirty_Intensity = IntensityValue[78];
	pGradeData->side_Edge_Color_Dirty_Size = Table_Interval_PixelAndMeter[SizeValue[78] / 10];

	pGradeData->threeDEdgeAreaExtend = IntensityValue[29];
	pGradeData->threeD_Height_Minus_Limit = SizeValue[30];
	pGradeData->threeD_Height_Plus_Limit = SizeValue[31];
	pGradeData->Saturation_Erase_SW = CheckBox2->Checked;
  pGradeData->ETC_Side_None_Horizontality_Tablet = NoneHorizontalityTabletCheckBox->Checked;
  pGradeData->ETC_Side_Split_Line_UnInspection_Area_Setting = SplitLineUnInspectionAreaSettingCheckBox->Checked;
  pGradeData->SideRemovalAlgorithm3DPassing = SideRemovalAlgorithm3DCheckBox->Checked;
	pGradeData->EngravePositionDefectCheckSW = UnPrintDefectCheckBox->Checked;

	pGradeData->EngraveDistinguishGradeFor3D = SizeValue[12];

	pGradeData->Side_Edge_Neighbor_Intensity = IntensityValue[32];
	pGradeData->Side_Edge_Neighbor_Defect_Size = Table_Interval_PixelAndMeter[SizeValue[32] / 10];

	pGradeData->Side_Edge_Dark_Intensity = IntensityValue[58];
	pGradeData->Side_Edge_Dark_Defect_Size = Table_Interval_PixelAndMeter[SizeValue[58] / 10];

	pGradeData->Side_Edge_Bright_Intensity = IntensityValue[59];
	pGradeData->Side_Edge_Bright_Defect_Size = Table_Interval_PixelAndMeter[SizeValue[59] / 10];

  pGradeData->Side_Edge_Neighbor_Break_Intensity = IntensityValue[60];
  pGradeData->Side_Edge_Neighbor_Break_Size = Table_Interval_PixelAndMeter[SizeValue[60] / 10];
  pGradeData->Side_Edge_Neighbor_Min_Break_Depth_Size = ETC_Side_Break_Depth_Size;

	pGradeData->EngraveMatchingOrNotValue = IntensityValue[34];

	pGradeData->DirtyGradeSensitivity = IntensityValue[35];

  pGradeData->SplitLineMatchingSWForPrintTablet = FrontFaceSplitLineOptionCheckBox->Checked;
  pGradeData->SplitLineMatchingThreshold = IntensityValue[67];

	pGradeData->ETC_ApplyColorDirtyIgnoreAlgorithm = ColorDefectPassAlgorithmCB->Checked;
  pGradeData->ETC_ActiveSideEdgeDefectCheck = SideEdgeDirtyCheckBox->Checked;
	pGradeData->ETC_InterestedColor = IntensityValue[37];
	pGradeData->ETC_ColorDirtyIgnoreLevel = IntensityValue[38];
	pGradeData->ETC_AdjustPrintAreaSW = CheckBox3->Checked;
	pGradeData->ETC_ColorDirtySize = Table_Interval_PixelAndMeter[SizeValue[38] / 10];

	pGradeData->ETC_ThreeDCenterSize = IntensityValue[39];

	pGradeData->ETC_FrontFaceEdgeInspectionSW = CheckBox5->Checked;
	pGradeData->ETC_AdjustUnalignedTabletAlgorithm = CheckBox6->Checked;
	pGradeData->ETC_Partial3DPrintCheckSW = SpecialFunctionCheckBox->Checked;

	pGradeData->ETC_RemoveBrightDotSW = CheckBox7->Checked;
	pGradeData->ETC_ApplyTiltTabletAlgorithm = CheckBox8->Checked;

	pGradeData->DarkSpotDefectIntensityGradeForMarvelingTablet = IntensityValue[51];
	pGradeData->DarkSpotDefectSizeGradeForMarvelingTablet = Table_Interval_PixelAndMeter[SizeValue[51] / 10];
	pGradeData->BrightSpotDefectIntensityGradeForMarvelingTablet = IntensityValue[52];
	pGradeData->BrightSpotDefectSizeGradeForMarvelingTablet = Table_Interval_PixelAndMeter[SizeValue[52] / 10];

	pGradeData->DarkStainDefectIntensityGradeForMarvelingTablet = IntensityValue[53];
	pGradeData->DarkStainDefectSizeGradeForMarvelingTablet = Table_Interval_PixelAndMeter[SizeValue[53] / 10];
	pGradeData->BrightStainDefectIntensityGradeForMarvelingTablet = IntensityValue[54];
	pGradeData->BrightStainDefectSizeGradeForMarvelingTablet = Table_Interval_PixelAndMeter[SizeValue[54] / 10];

	pGradeData->dummy[0] = IntensityValue[68];
	pGradeData->ETC_PrintPositionDefectIntensity = IntensityValue[69];
	pGradeData->LaserAllowX= IntensityValue[81];
	pGradeData->LaserAllowY = IntensityValue[82];
	pGradeData->LaserAllowDegree= IntensityValue[83];
	pGradeData->ETC_PrintPositionRotationDefectIntensity = IntensityValue[70];

	if (TabletCharacter.MarvelingTablet)
	{
		pGradeData->front_dirty_Intensity = pGradeData->DarkSpotDefectIntensityGradeForMarvelingTablet;
		pGradeData->front_dirty_Size = pGradeData->DarkSpotDefectSizeGradeForMarvelingTablet;

		pGradeData->front_stain_Intensity = pGradeData->DarkStainDefectIntensityGradeForMarvelingTablet;
		pGradeData->front_stain_Size = pGradeData->DarkStainDefectSizeGradeForMarvelingTablet;

		pGradeData->front_edge_dirty_Intensity = pGradeData->DarkSpotDefectIntensityGradeForMarvelingTablet;
		pGradeData->front_edge_dirty_Size = pGradeData->DarkSpotDefectSizeGradeForMarvelingTablet;

		pGradeData->front_edge_Intensity = pGradeData->DarkStainDefectIntensityGradeForMarvelingTablet;
		pGradeData->front_edge_Size = pGradeData->DarkStainDefectSizeGradeForMarvelingTablet;

		pGradeData->front_Color_Dirty_Intensity = pGradeData->BrightStainDefectIntensityGradeForMarvelingTablet;
		pGradeData->front_Color_Dirty_Size = pGradeData->BrightStainDefectSizeGradeForMarvelingTablet;
	}
	pGradeData->DirtyDefectCheckSWInNeighborPrint = DirtyDefectCheckInNeighborPrintCheckBox->Checked;
  pGradeData->ETC_EngraveWhiteDefectCheckAlgorithm = EngraveWhiteDefectCheckBox->Checked;
  pGradeData->ETC_EnforcementStainDefectCheckAlgorithm = EnforcementStainDefectCheckAlgorithmCheckBox->Checked;
  
	pGradeData->ETC_ApplyWhiteEngraveAlgorithm = WhiteEngraveMatchingCheckBox->Checked;

  pGradeData->ThreeD_CoatedTablet_ShapeError_Height = IntensityValue[73];
	pGradeData->ThreeD_CoatedTablet_ShapeError_Size = Table_Interval_PixelAndMeterForThreeD[SizeValue[73] / 10];
  pGradeData->ETC_CoatedTablet_ShapeCheck = Apply3DShapeCheck->Checked;

  pGradeData->ETC_PartialThreeDStampDefectIntensity = IntensityValue[75];
  pGradeData->ETC_PartialThreeDStampDefectSize = Table_Interval_PixelAndMeterForThreeD[SizeValue[75] / 10];

  pGradeData->ETC_SideEdgeDefectIntensity = IntensityValue[76];
  pGradeData->ETC_SideEdgeDefectSize = Table_Interval_PixelAndMeterForThreeD[SizeValue[76] / 10];

  pGradeData->ETC_TabletFrontFaceThreshold = IntensityValue[77];

  pGradeData->LIMA_ThreeD_Side_EraseLevel = IntensityValue[79];
  pGradeData->LIMA_ThreeD_MaxHeight = IntensityValue[80];
  pGradeData->LIMA_ThreeD_OverHeightSize = Table_Interval_PixelAndMeterForThreeD[SizeValue[80] / 10];

  pGradeData->BeltPowderSensitivity = IntensityValue[85] - 1;
  pGradeData->RemoveBeltActive = RemoveBeltActiveCheckBox->Checked;
  pGradeData->EngravePrintMatching2DInActive = EngravePrintMatching2DInActiveCheckBox->Checked;
}

//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::PrintRotationPositionDefectTrackBarChange(
      TObject *Sender)
{
  int value;
	SideBreakGradePanel->Visible = false;
	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;

	IntensityValue[70] = PrintRotationPositionDefectTrackBar->Position;
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeButton32Click(TObject *Sender)
{
  GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clRed;
  GradeButton33->Font->Color = clMaroon;

	GradeBtnForMarvelTablet1->Font->Color = clMaroon;
	GradeBtnForMarvelTablet2->Font->Color = clMaroon;
	GradeBtnForMarvelTablet3->Font->Color = clMaroon;
  GradeBtnForMarvelTablet4->Font->Color = clMaroon;
	GradeBtnForMarvelTablet5->Font->Color = clMaroon;
	GradeBtnForMarvelTablet6->Font->Color = clMaroon;
	GradeBtnForMarvelTablet7->Font->Color = clMaroon;
	// end. ߰ Btn

	SideEdgeGradeSettingPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	ThreeDEngraveDefectPanel->Visible = false;
	GroupBox15->Visible = false;
	GroupBox8->Visible = true;
	StaticText5->Caption = GRADESETTING_TEXT_CAPTION_02;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;

	Image5->Visible = false;
	Image6->Visible = false;
	Image7->Visible = false;
	Image8->Visible = false;

	StaticText5->Visible = false;
	StaticText6->Visible = false;

	BitBtn11->Visible = false;
	BitBtn12->Visible = false;

	GradeSettingPanelForMarvelingTablet1->Visible = false;
	GradeSettingPanelForMarvelingTablet2->Visible = false;
  StainDefectCheckPanel->Visible = false;
	SideBreakGradePanel->Visible = false;
	// end. űԷ 򰡵  г

	SelectedDefectN = 71;
	SelectedDefectN2 = 0;
	ThreeDIntensityBarDisplay();
	ThreeDSizeBarDisplay();
	DisplayTabletShapeData(FRONT_SHAPE, EDGE_AREA, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TrackBar3Change(TObject *Sender)
{
  int value;
	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
	SideBreakGradePanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;

  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;
	IntensityValue[72] = TrackBar3->Position;
	DisplayEachGradeValue();
	DisplayNotInspectionAera(SIDE_SHAPE, NOTHING);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::Apply3DShapeCheckClick(TObject *Sender)
{
  if(Apply3DShapeCheck->Checked)
  {
    TabletGradeData.ETC_CoatedTablet_ShapeCheck = 1;
  }
  else
  {
    TabletGradeData.ETC_CoatedTablet_ShapeCheck = 0;
  }
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::GradeButton33Click(TObject *Sender)
{
  GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clMaroon;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clRed;

	GradeBtnForMarvelTablet1->Font->Color = clMaroon;
	GradeBtnForMarvelTablet2->Font->Color = clMaroon;
	GradeBtnForMarvelTablet3->Font->Color = clMaroon;
  GradeBtnForMarvelTablet4->Font->Color = clMaroon;
	GradeBtnForMarvelTablet5->Font->Color = clMaroon;
	GradeBtnForMarvelTablet6->Font->Color = clMaroon;
	GradeBtnForMarvelTablet7->Font->Color = clMaroon;
	// end. ߰ Btn

	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
	GroupBox15->Visible = false;
	GroupBox8->Visible = true;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
	StaticText5->Caption = GRADESETTING_TEXT_CAPTION_02;
	Image5->Visible = false;
	Image6->Visible = false;
	Image7->Visible = false;
	Image8->Visible = false;

	StaticText5->Visible = false;
	StaticText6->Visible = false;
	BitBtn11->Visible = true;
	BitBtn12->Visible = true;

	GradeSettingPanelForMarvelingTablet1->Visible = false;
	GradeSettingPanelForMarvelingTablet2->Visible = false;
  StainDefectCheckPanel->Visible = false;
	SideBreakGradePanel->Visible = false;
	// end. űԷ 򰡵  г

	SelectedDefectN = 73;
	SelectedDefectN2 = 0;
	ThreeDSizeBarDisplay();
	ThreeDIntensityBarDisplay();
	DisplayTabletShapeData(FRONT_SHAPE, NOT_EDGE_AREA, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::PrintIntensityBarDisplay(void)
{
  AnsiString grade;
  int textWidth;

  TLabel *tempLabel = new TLabel(this);
  tempLabel->Caption = "";
  tempLabel->Font = TntImage10->Canvas->Font;
  tempLabel->Font->Size = 10;
  tempLabel->Width = 0;

	TntImage10->Canvas->Brush->Style = bsSolid;
	TntImage10->Canvas->Brush->Color = clBlack;
	TntImage10->Canvas->Pen->Color = clBlack;
	TntImage10->Canvas->Rectangle(0, 0, TntImage10->Width, TntImage10->Height);

  grade = IntToStr(IntensityValue[2]) + " Grade";
  tempLabel->Caption = grade;
  textWidth = tempLabel->Width + 4;

  TntImage10->Canvas->Brush->Style = bsSolid;
  TntImage10->Canvas->Brush->Color = (TColor)0x126596;
  TntImage10->Canvas->Rectangle(0, 0, IntensityValue[2] * (TntImage10->Width / 10), TntImage10->Height);
  TntImage10->Canvas->Font->Color = clBlack;
  TntImage10->Canvas->Font->Size = 10;
  TntImage10->Canvas->TextOutW(IntensityValue[2] * (TntImage10->Width / 10) - textWidth, 20, grade);

  tempLabel->Caption = "";
  tempLabel->Font = TntImage13->Canvas->Font;
  tempLabel->Font->Size = 10;
  tempLabel->Width = 0;

	TntImage13->Canvas->Brush->Style = bsSolid;
	TntImage13->Canvas->Brush->Color = clBlack;
	TntImage13->Canvas->Pen->Color = clBlack;
	TntImage13->Canvas->Rectangle(0, 0, TntImage13->Width, TntImage13->Height);

  grade = IntToStr(IntensityValue[74]) + " Grade";
  tempLabel->Caption = grade;
  textWidth = tempLabel->Width + 4;

  TntImage13->Canvas->Brush->Style = bsSolid;
  TntImage13->Canvas->Brush->Color = (TColor)0x126596;
  TntImage13->Canvas->Rectangle(0, 0, IntensityValue[74] * (TntImage13->Width / 30), TntImage13->Height);
  TntImage13->Canvas->Font->Color = clBlack;
  TntImage13->Canvas->Font->Size = 10;
  TntImage13->Canvas->TextOutW(IntensityValue[74] * (TntImage13->Width / 30) - textWidth, 20, grade);

  delete tempLabel;
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::TntImage10MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  IntensityValue[2] = X / (TntImage10->Width / 10) + 1;

	PrintIntensityBarDisplay();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntImage13MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  IntensityValue[74] = X / (TntImage13->Width / 30) + 1;

	PrintIntensityBarDisplay();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::StampErrorSettingOptionButtonClick(
      TObject *Sender)
{
  Panel1->Left += 1000;
  ThreeDEngraveDefectPanel->Left += 1000;
  StampErrorSettingOptionPanel->Visible = true;
  StampErrorSettingOptionPanel->BringToFront();

  Init3DStampSetupMenu();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntBitBtn5Click(TObject *Sender)
{
  AnsiString threeDsetupDataFileName = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\" + ProductData.ProductCode + ".sdt_3D";
  TFileStream *fileStream1 = new TFileStream(threeDsetupDataFileName, fmCreate);
	fileStream1->Write(&Tablet3DSetupData, sizeof(TTablet3DSetupData));
	delete fileStream1;
      
  Panel1->Left -= 1000;
  ThreeDEngraveDefectPanel->Left -= 1000;
  StampErrorSettingOptionPanel->Visible = false;
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::ThreeDPrintSelectionButton1Click(
      TObject *Sender)
{
  TTntSpeedButton *tempBtn = (TTntSpeedButton*) Sender;

  for(int idx = 1; idx <= 4; idx++)
  {
    ((TTntSpeedButton *)FindComponent("ThreeDPrintSelectionButton" + IntToStr(idx)))->Font->Color = clBlack;
  }

  tempBtn->Font->Color = clRed;

  LoadThreeDStampData(tempBtn->Tag);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::Init3DStampSetupMenu()
{
  if (!Read3DSetupData(&Tablet3DSetupData))
	{
		ShowMessageW(GRADESETTING_MSG_01);
	}

  int selectedPrintNum = 0;
  if(Tablet3DSetupData.Disk1printData1Count)
  {
    if(!selectedPrintNum) selectedPrintNum = 1;
    ThreeDPrintSelectionButton1->Enabled = true;
  }
  else
  {
    ThreeDPrintSelectionButton1->Enabled = false;
  }

  if(Tablet3DSetupData.Disk1printData2Count)
  {
    if(!selectedPrintNum) selectedPrintNum = 2;
    ThreeDPrintSelectionButton2->Enabled = true;
  }
  else
  {
    ThreeDPrintSelectionButton2->Enabled = false;
  }

  if(Tablet3DSetupData.Disk2printData1Count)
  {
    if(!selectedPrintNum) selectedPrintNum = 3;
    ThreeDPrintSelectionButton3->Enabled = true;
  }
  else
  {
    ThreeDPrintSelectionButton3->Enabled = false;
  }

  if(Tablet3DSetupData.Disk2printData2Count)
  {
    if(!selectedPrintNum) selectedPrintNum = 4;
    ThreeDPrintSelectionButton4->Enabled = true;
  }
  else
  {
    ThreeDPrintSelectionButton4->Enabled = false;
  }

  ThreeDPrintSelectionButton1Click(((TTntSpeedButton *)FindComponent("ThreeDPrintSelectionButton" + IntToStr(selectedPrintNum))));

  UpDown6->Position = 15;
  int ManualWorkAreaWidth = UpDown6->Position;
  
  Image67->Canvas->Brush->Style = bsSolid;
	Image67->Canvas->Brush->Color = clWhite;
	Image67->Canvas->Rectangle(0, 0, Image67->Width, Image67->Height);
	Image67->Canvas->Pen->Color = clRed;
	Image67->Canvas->Brush->Color = clRed;
	Image67->Canvas->Ellipse(Image67->Width / 2 - (((float)ManualWorkAreaWidth) / 2.0 + 0.5), Image67->Height / 2 - (((float)ManualWorkAreaWidth) / 2.0 + 0.5), Image67->Width / 2 + (((float)ManualWorkAreaWidth) / 2.0 + 0.5), Image67->Height / 2 + (((float)ManualWorkAreaWidth) / 2.0 + 0.5));

  SelectedDefectN = 75;

  PartialThreeDPrintGradeDisplay();
}

//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::LoadThreeDStampData(int printNum)
{
  int diskNumber;
  int printNumber;

  SelectedThreeDPrintNum = printNum;
  diskNumber = printNum / 2;
  printNumber = printNum % 2;

  unsigned char printData[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];
  memset(printData, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
  for (int n = 0; n < Tablet3DSetupData.printLabelCount[diskNumber][printNumber]; n++)
  {
    for (int m = 0; m < Tablet3DSetupData.printLabelDataCnt[diskNumber][printNumber][n]; m++)
    {
      int tempX = Tablet3DSetupData.printLabelData[diskNumber][printNumber][n][m][0];
      int tempY = Tablet3DSetupData.printLabelData[diskNumber][printNumber][n][m][1];

      if(Tablet3DSetupData.printMaskData[diskNumber][printNumber][n][m])
      {
        printData[MAX_IMAGE_WIDTH * tempY + tempX] = 2;
      }
      else
      {
        printData[MAX_IMAGE_WIDTH * tempY + tempX] = 1;
      }
    }
  }

  Graphics::TBitmap *img1;
  img1 = new Graphics::TBitmap();
  img1->Width =  MAX_IMAGE_WIDTH;
  img1->Height =  MAX_IMAGE_HEIGHT;
  img1->PixelFormat = pf24bit;

  Byte *ptr;
  for(int y = 0; y < MAX_IMAGE_HEIGHT; y++)
  {
    ptr = (Byte*) img1->ScanLine[y];
    for(int x = 0; x < MAX_IMAGE_WIDTH; x++)
    {
      if(printData[MAX_IMAGE_WIDTH * y + x] == 1)
      {
        ptr[3*x + 0] = 255;
        ptr[3*x + 1] = 255;
        ptr[3*x + 2] = 255;
      }
      else if(printData[MAX_IMAGE_WIDTH * y + x] == 2)
      {
        ptr[3*x + 0] = 0;
        ptr[3*x + 1] = 0;
        ptr[3*x + 2] = 255;
      }
      else
      {
        ptr[3*x + 0] = 0;
        ptr[3*x + 1] = 0;
        ptr[3*x + 2] = 0;
      }
    }
  }

  ThreeDStampImage->Picture->Bitmap->Assign(img1);
  ThreeDStampImage->Refresh();

  delete img1;
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::UpDown6Click(TObject *Sender,
      TUDBtnType Button)
{
  int ManualWorkAreaWidth = UpDown6->Position;
  Image67->Canvas->Brush->Style = bsSolid;
  Image67->Canvas->Brush->Color = clWhite;
  Image67->Canvas->Rectangle(0, 0, Image67->Width, Image67->Height);
  Image67->Canvas->Pen->Color = clRed;
  Image67->Canvas->Brush->Color = clRed;
  Image67->Canvas->Ellipse(Image67->Width / 2 - (((float)ManualWorkAreaWidth) / 2.0 + 0.5), Image67->Height / 2 - (((float)ManualWorkAreaWidth) / 2.0 + 0.5), Image67->Width / 2 + (((float)ManualWorkAreaWidth) / 2.0 + 0.5), Image67->Height / 2 + (((float)ManualWorkAreaWidth) / 2.0 + 0.5));
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntSpeedButton5Click(TObject *Sender)
{
  int diskNumber = SelectedThreeDPrintNum / 2;
  int printNumber = SelectedThreeDPrintNum % 2;

  memset(Tablet3DSetupData.printMaskData[diskNumber][printNumber], 0, sizeof(short) * THREED_PRINT_MAX_LABEL_COUNT * PRINT_LABEL_DATA_SIZE);

  LoadThreeDStampData(SelectedThreeDPrintNum);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::ThreeDStampImageMouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  bMousedown = true;

  if(bMousedown)
  {
    DrawMask(X, Y);
  }

  LoadThreeDStampData(SelectedThreeDPrintNum);
  cursorDisplay(X, Y);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::ThreeDStampImageMouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  bMousedown = false;  
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::ThreeDStampImageMouseMove(
      TObject *Sender, TShiftState Shift, int X, int Y)
{
  if(bMousedown)
  {
    DrawMask(X, Y);
  }

  LoadThreeDStampData(SelectedThreeDPrintNum);
  cursorDisplay(X, Y);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::cursorDisplay(int x, int y)
{
  int startX, endX, startY, endY;
  int maskSize = max(1, UpDown6->Position / 2);
  
  startX = (x - maskSize);
  endX = (x + maskSize);
  startY = (y - maskSize);
  endY = (y + maskSize);

  ThreeDStampImage->Canvas->Pen->Width = 1;
  ThreeDStampImage->Canvas->Pen->Color = clGreen;
  ThreeDStampImage->Canvas->Brush->Style = bsClear;
  ThreeDStampImage->Canvas->Rectangle(startX, startY, endX, endY);
  ThreeDStampImage->Repaint();
}

//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::DrawMask(int x, int y)
{
  unsigned char maskData[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];
  memset(maskData, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

  int startX, endX, startY, endY;
  int maskSize = max(1, UpDown6->Position / 2);
  
  startX = (x - maskSize);
  endX = (x + maskSize);
  startY = (y - maskSize);
  endY = (y + maskSize);

  for(int y = startY; y < endY; y++)
  {
    for(int x = startX; x < endX; x++)
    {
      int tempAddress = MAX_IMAGE_WIDTH * y + x;

      maskData[tempAddress] = 1;
    }
  }

  int diskNumber;
  int printNumber;

  diskNumber = SelectedThreeDPrintNum / 2;
  printNumber = SelectedThreeDPrintNum % 2;

  unsigned char printData[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];
  memset(printData, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
  for (int n = 0; n < Tablet3DSetupData.printLabelCount[diskNumber][printNumber]; n++)
  {
    for (int m = 0; m < Tablet3DSetupData.printLabelDataCnt[diskNumber][printNumber][n]; m++)
    {
      int tempX = Tablet3DSetupData.printLabelData[diskNumber][printNumber][n][m][0];
      int tempY = Tablet3DSetupData.printLabelData[diskNumber][printNumber][n][m][1];

      if(maskData[MAX_IMAGE_WIDTH * tempY + tempX])
      {
        Tablet3DSetupData.printMaskData[diskNumber][printNumber][n][m] = 1;
      }
    }
  }
}

//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::PartialThreeDPrintGradeDisplay(void)
{
  //   
	TntImage16->Canvas->Brush->Style = bsSolid;
	TntImage16->Canvas->Brush->Color = clBlack;
	TntImage16->Canvas->Pen->Color = clBlack;
	TntImage16->Canvas->Rectangle(0, 0, TntImage16->Width, TntImage16->Height);

	TntImage16->Canvas->Brush->Style = bsSolid;
	TntImage16->Canvas->Brush->Color = (TColor)0x126596;
	TntImage16->Canvas->Rectangle(0, 0, IntensityValue[SelectedDefectN] * (TntImage16->Width / 10), TntImage16->Height);
	TntImage16->Canvas->Font->Color = clBlack;

  // ҷ ũ
  TntImage21->Canvas->Brush->Style = bsSolid;
	TntImage21->Canvas->Brush->Color = clBlack;
	TntImage21->Canvas->Pen->Color = clBlack;
	TntImage21->Canvas->Rectangle(0, 0, TntImage21->Width, TntImage21->Height);

	TntImage21->Canvas->Brush->Style = bsSolid;
	TntImage21->Canvas->Brush->Color = (TColor)0x656596;
	TntImage21->Canvas->Rectangle(0, 0, SizeValue[SelectedDefectN] / 10 * 3, TntImage21->Height);
	TntImage21->Canvas->Font->Color = clBlack;
	TntImage21->Canvas->Font->Size = 10;
	TntImage21->Canvas->TextOutW(SizeValue[SelectedDefectN] / 10 * 3 + 10, 15, FloatToStr((float)SizeValue[SelectedDefectN] / 1000.0) + " mm");
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::TntImage21MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  SizeValue[SelectedDefectN] = X / 3 * 10;
	PartialThreeDPrintGradeDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntBitBtn16Click(TObject *Sender)
{
  if (SizeValue[SelectedDefectN] < 2000)
	{
		SizeValue[SelectedDefectN] += 10;
		PartialThreeDPrintGradeDisplay();
	}  
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntBitBtn17Click(TObject *Sender)
{
  if (SizeValue[SelectedDefectN] > 0)
	{
		SizeValue[SelectedDefectN] -= 10;
		PartialThreeDPrintGradeDisplay();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntImage16MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  IntensityValue[SelectedDefectN] = X / (TntImage16->Width / 10) + 1;
	PartialThreeDPrintGradeDisplay();
}
//---------------------------------------------------------------------------


void __fastcall TGradeSettingForm::SideEdgeDirtyGradeSettingButtonClick(
      TObject *Sender)
{
  SideBreakGradePanel->Visible = false;
	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = true;
  SplitLineRecognizationOptionPanel->Visible = false;
	SideEdgeDirtyGradeSettingPanel->BringToFront();
  SideEdgeGradeDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::SideEdgeDirtyCheckBoxClick(
      TObject *Sender)
{
  if(SideEdgeDirtyCheckBox->Checked)
  {
    TabletGradeData.ETC_ActiveSideEdgeDefectCheck = 1;
  }
  else
  {
    TabletGradeData.ETC_ActiveSideEdgeDefectCheck = 0;
  }
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::SideEdgeGradeDisplay()
{
  TntImage23->Canvas->Brush->Style = bsSolid;
	TntImage23->Canvas->Brush->Color = clBlack;
	TntImage23->Canvas->Pen->Color = clBlack;
	TntImage23->Canvas->Rectangle(0, 0, TntImage23->Width, TntImage23->Height);
	TntImage23->Canvas->Brush->Style = bsSolid;
	TntImage23->Canvas->Brush->Color = (TColor)0x126596;
	TntImage23->Canvas->Rectangle(0, 0, IntensityValue[76] * (TntImage23->Width / 200), TntImage23->Height);
	TntImage23->Canvas->Font->Color = clBlack;
	TntImage23->Canvas->Font->Size = 10;
	TntImage23->Canvas->TextOutW(IntensityValue[76] * (TntImage23->Width / 200) - TntImage23->Width / 200, 15, IntToStr(IntensityValue[76]) + " Grade");

  TntImage24->Canvas->Brush->Style = bsSolid;
	TntImage24->Canvas->Brush->Color = clBlack;
	TntImage24->Canvas->Pen->Color = clBlack;
	TntImage24->Canvas->Rectangle(0, 0, TntImage24->Width, TntImage24->Height);
	TntImage24->Canvas->Brush->Style = bsSolid;
	TntImage24->Canvas->Brush->Color = (TColor)0x656596;
	TntImage24->Canvas->Rectangle(0, 0, SizeValue[76] / 10 * 3, TntImage24->Height);
	TntImage24->Canvas->Font->Color = clBlack;
	TntImage24->Canvas->Font->Size = 10;
	TntImage24->Canvas->TextOutW(SizeValue[76] / 10 * 3, 15, FloatToStr((float)SizeValue[76] / 1000.0) + " mm");
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::TntImage23MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  IntensityValue[76] = X / (TntImage23->Width / 200) + 1;
	SideEdgeGradeDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntImage24MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  SizeValue[76] = X / 3 * 10;
	SideEdgeGradeDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::Image15MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  IntensityValue[77] = (X - 180) / 6;
	TabletThresholdBarDisplay();
	VariableToGradeData();
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TabletThresholdBarDisplay(void)
{
	Image15->Canvas->Pen->Color = clBlack;
	Image15->Canvas->Brush->Style = bsSolid;
	Image15->Canvas->Brush->Color = clWhite;
	Image15->Canvas->Rectangle(0, 0, Image15->Width, Image15->Height);

	Image15->Canvas->Brush->Style = bsSolid;

	if (IntensityValue[77] <= 0)
	{
		Image15->Canvas->Brush->Color = clBlue;
		Image15->Canvas->Rectangle(180 + IntensityValue[77] * 6, 0, 180, 30);

		Image15->Canvas->Brush->Color = clBlue;
		Image15->Canvas->Font->Color = clWhite;
		Image15->Canvas->Font->Size = 10;
		Image15->Canvas->TextOut(180 + IntensityValue[77] * 6, 2, IntToStr(IntensityValue[77]) + " L");
	}
	else
	{
		Image15->Canvas->Brush->Color = clRed;
		Image15->Canvas->Rectangle(180, 0, IntensityValue[77] * 6 + 180, 30);

		Image15->Canvas->Brush->Color = clRed;
		Image15->Canvas->Font->Color = clWhite;
		Image15->Canvas->Font->Size = 10;
		Image15->Canvas->TextOut(180 + IntensityValue[77] * 6 - 30, 2, IntToStr(IntensityValue[77]) + " L");
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::SideEdgeColorNoneInspectionCheckBoxClick(
      TObject *Sender)
{

  if(SideEdgeColorNoneInspectionCheckBox->Checked)
  {
    TabletGradeData.Side_Edge_Color_NoneInspection_Option = 1;
  }
  else
  {
    TabletGradeData.Side_Edge_Color_NoneInspection_Option = 0;
  }

}
//---------------------------------------------------------------------------




void __fastcall TGradeSettingForm::TntImage25MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  IntensityValue[78] = X / (TntImage25->Width / 10) + 1;

  AnsiString grade;
  int textWidth;

  TLabel *tempLabel = new TLabel(this);
  tempLabel->Caption = "";
  tempLabel->Font = TntImage25->Canvas->Font;
  tempLabel->Font->Size = 10;
  tempLabel->Width = 0;

  TntImage25->Canvas->Brush->Style = bsSolid;
	TntImage25->Canvas->Brush->Color = clBlack;
	TntImage25->Canvas->Pen->Color = clBlack;
	TntImage25->Canvas->Rectangle(0, 0, TntImage25->Width, TntImage25->Height);

  grade = IntToStr(IntensityValue[78]) + " Grade";
  tempLabel->Caption = grade;
  textWidth = tempLabel->Width + 4;

  TntImage25->Canvas->Brush->Style = bsSolid;
  TntImage25->Canvas->Brush->Color = (TColor)0x126596;
  TntImage25->Canvas->Rectangle(0, 0, IntensityValue[78] * (TntImage25->Width / 10), TntImage25->Height);
  TntImage25->Canvas->Font->Color = clBlack;
  TntImage25->Canvas->Font->Size = 10;
  TntImage25->Canvas->TextOutW(IntensityValue[78] * (TntImage25->Width / 10) - textWidth, 20, grade);

  TntImage26->Visible = true;
	Image4->Visible = true;
	TntStaticText41->Visible = true;
	TntStaticText42->Visible = true;

	TntImage26->Canvas->Brush->Style = bsSolid;
	TntImage26->Canvas->Brush->Color = clBlack;
	TntImage26->Canvas->Pen->Color = clBlack;
	TntImage26->Canvas->Rectangle(0, 0, TntImage26->Width, TntImage26->Height);

	TntImage26->Canvas->Brush->Style = bsSolid;
	TntImage26->Canvas->Brush->Color = (TColor)0x656596;
	TntImage26->Canvas->Rectangle(0, 0, SizeValue[78] / 10 * 3, TntImage26->Height);
	TntImage26->Canvas->Font->Color = clBlack;
	TntImage26->Canvas->Font->Size = 10;
	TntImage26->Canvas->TextOutW(SizeValue[78] / 10 * 3 + 10, 15, FloatToStr((float)SizeValue[78] / 1000.0) + " mm");

  delete tempLabel;
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntImage26MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
	SizeValue[78] = X / 3 * 10;
  TntImage26->Visible = true;
	TntImage27->Visible = true;
	TntStaticText41->Visible = true;
	TntStaticText42->Visible = true;

	TntImage26->Canvas->Brush->Style = bsSolid;
	TntImage26->Canvas->Brush->Color = clBlack;
	TntImage26->Canvas->Pen->Color = clBlack;
	TntImage26->Canvas->Rectangle(0, 0, TntImage26->Width, TntImage26->Height);

	TntImage26->Canvas->Brush->Style = bsSolid;
	TntImage26->Canvas->Brush->Color = (TColor)0x656596;
	TntImage26->Canvas->Rectangle(0, 0, SizeValue[78] / 10 * 3, TntImage26->Height);
	TntImage26->Canvas->Font->Color = clBlack;
	TntImage26->Canvas->Font->Size = 10;
	TntImage26->Canvas->TextOutW(SizeValue[78] / 10 * 3 + 10, 15, FloatToStr((float)SizeValue[78] / 1000.0) + " mm");

	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::SideEdgeBarAndSizeBarDisplay(void)
{
  AnsiString grade;
  int textWidth;

  TLabel *tempLabel = new TLabel(this);
  tempLabel->Caption = "";
  tempLabel->Font = TntImage25->Canvas->Font;
  tempLabel->Font->Size = 10;
  tempLabel->Width = 0;

  TntImage25->Canvas->Brush->Style = bsSolid;
	TntImage25->Canvas->Brush->Color = clBlack;
	TntImage25->Canvas->Pen->Color = clBlack;
	TntImage25->Canvas->Rectangle(0, 0, TntImage25->Width, TntImage25->Height);

  grade = IntToStr(IntensityValue[78]) + " Grade";
  tempLabel->Caption = grade;
  textWidth = tempLabel->Width + 4;

  TntImage25->Canvas->Brush->Style = bsSolid;
  TntImage25->Canvas->Brush->Color = (TColor)0x126596;
  TntImage25->Canvas->Rectangle(0, 0, IntensityValue[78] * (TntImage25->Width / 10), TntImage25->Height);
  TntImage25->Canvas->Font->Color = clBlack;
  TntImage25->Canvas->Font->Size = 10;
  TntImage25->Canvas->TextOutW(IntensityValue[78] * (TntImage25->Width / 10) - textWidth, 20, grade);

  TntImage26->Visible = true;
	Image4->Visible = true;
	TntStaticText41->Visible = true;
	TntStaticText42->Visible = true;

	TntImage26->Canvas->Brush->Style = bsSolid;
	TntImage26->Canvas->Brush->Color = clBlack;
	TntImage26->Canvas->Pen->Color = clBlack;
	TntImage26->Canvas->Rectangle(0, 0, TntImage26->Width, TntImage26->Height);

	TntImage26->Canvas->Brush->Style = bsSolid;
	TntImage26->Canvas->Brush->Color = (TColor)0x656596;
	TntImage26->Canvas->Rectangle(0, 0, SizeValue[78] / 10 * 3, TntImage26->Height);
	TntImage26->Canvas->Font->Color = clBlack;
	TntImage26->Canvas->Font->Size = 10;
	TntImage26->Canvas->TextOutW(SizeValue[78] / 10 * 3 + 10, 15, FloatToStr((float)SizeValue[78] / 1000.0) + " mm");

	DisplayEachGradeValue();

  delete tempLabel;
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::TntBitBtn18Click(TObject *Sender)
{
	if (SizeValue[78] > 0)
	{
		SizeValue[78] -= 10;

    TntImage26->Visible = true;
    TntImage27->Visible = true;
    TntStaticText41->Visible = true;
    TntStaticText42->Visible = true;

    TntImage26->Canvas->Brush->Style = bsSolid;
    TntImage26->Canvas->Brush->Color = clBlack;
    TntImage26->Canvas->Pen->Color = clBlack;
    TntImage26->Canvas->Rectangle(0, 0, TntImage26->Width, TntImage26->Height);

    TntImage26->Canvas->Brush->Style = bsSolid;
    TntImage26->Canvas->Brush->Color = (TColor)0x656596;
    TntImage26->Canvas->Rectangle(0, 0, SizeValue[78] / 10 * 3, TntImage26->Height);
    TntImage26->Canvas->Font->Color = clBlack;
    TntImage26->Canvas->Font->Size = 10;
    TntImage26->Canvas->TextOutW(SizeValue[78] / 10 * 3 + 10, 15, FloatToStr((float)SizeValue[78] / 1000.0) + " mm");


		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::TntBitBtn19Click(TObject *Sender)
{
	if (SizeValue[78] < 2000)
	{
		SizeValue[78] += 10;
		TntImage26->Visible = true;
    TntImage27->Visible = true;
    TntStaticText41->Visible = true;
    TntStaticText42->Visible = true;

    TntImage26->Canvas->Brush->Style = bsSolid;
    TntImage26->Canvas->Brush->Color = clBlack;
    TntImage26->Canvas->Pen->Color = clBlack;
    TntImage26->Canvas->Rectangle(0, 0, TntImage26->Width, TntImage26->Height);

    TntImage26->Canvas->Brush->Style = bsSolid;
    TntImage26->Canvas->Brush->Color = (TColor)0x656596;
    TntImage26->Canvas->Rectangle(0, 0, SizeValue[78] / 10 * 3, TntImage26->Height);
    TntImage26->Canvas->Font->Color = clBlack;
    TntImage26->Canvas->Font->Size = 10;
    TntImage26->Canvas->TextOutW(SizeValue[78] / 10 * 3 + 10, 15, FloatToStr((float)SizeValue[78] / 1000.0) + " mm");

		DisplayEachGradeValue();
	}
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::LIMAGradeSettingButtonClick(
      TObject *Sender)
{
  LIMAGradeSettingPanel->Visible = true;
  LIMAAutoStudyBtn->Visible = false;

  RefreshThreeDOverHeightSizeBar();

  LIMAThreeDIndexUpDownBtn->Position = 1;
  LIMAPositionProcess(SD1_3D_FRONT_FACE_CAMERA_INDEX, false, NULL, NULL);

  LIMAGradeSettingPanel->BringToFront();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::LIMAGradeSettingCloseButtonClick(
      TObject *Sender)
{
  LIMAGradeSettingPanel->Visible = false;
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::ThreeDSideEraseTrackBarChange(
      TObject *Sender)
{
  SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;

	IntensityValue[79] = ThreeDSideEraseTrackBar->Position;
	DisplayEachGradeValue();

  LIMAPositionProcess(SD1_3D_FRONT_FACE_CAMERA_INDEX, false, NULL, NULL);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::ThreeDPositionErrorLimitTrackBarChange(
      TObject *Sender)
{
  SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;

	IntensityValue[80] = ThreeDPositionErrorLimitTrackBar->Position;
	DisplayEachGradeValue();

  LIMAPositionProcess(SD1_3D_FRONT_FACE_CAMERA_INDEX, false, NULL, NULL);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::ThreeDPositionErrorLimitSizeImageMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;

	SizeValue[80] = X / 3 * 10;
	DisplayEachGradeValue();
  RefreshThreeDOverHeightSizeBar();

  LIMAPositionProcess(SD1_3D_FRONT_FACE_CAMERA_INDEX, false, NULL, NULL);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::RefreshThreeDOverHeightSizeBar(void)
{
  ThreeDPositionErrorLimitSizeImage->Canvas->Brush->Style = bsSolid;
	ThreeDPositionErrorLimitSizeImage->Canvas->Brush->Color = clBlack;
  ThreeDPositionErrorLimitSizeImage->Canvas->Pen->Width = 1;
	ThreeDPositionErrorLimitSizeImage->Canvas->Pen->Color = clWhite;
	ThreeDPositionErrorLimitSizeImage->Canvas->Rectangle(0, 0, ThreeDPositionErrorLimitSizeImage->Width, ThreeDPositionErrorLimitSizeImage->Height);

	ThreeDPositionErrorLimitSizeImage->Canvas->Brush->Style = bsSolid;
	ThreeDPositionErrorLimitSizeImage->Canvas->Brush->Color = (TColor)0x656596;
	ThreeDPositionErrorLimitSizeImage->Canvas->Rectangle(0, 0, SizeValue[80] / 10 * 3, ThreeDPositionErrorLimitSizeImage->Height);
	ThreeDPositionErrorLimitSizeImage->Canvas->Font->Color = clBlack;
	ThreeDPositionErrorLimitSizeImage->Canvas->Font->Size = 10;
	ThreeDPositionErrorLimitSizeImage->Canvas->TextOutW(SizeValue[80] / 10 * 3 + 10, 15, FloatToStr((float)SizeValue[80] / 1000.0) + " mm");
}

//---------------------------------------------------------------------------

bool __fastcall TGradeSettingForm::ThreeDImageLoad(int imageIndex, int cameraIndex)
{
  if(ExtractBayerImage(BayerImage, imageIndex, cameraIndex))
  {
    int x, y;
    int startX, endX, startY, endY;
    int rotateStX, rotateEdX, rotateStY, rotateEdY;
    const int THREE_D_SRC_IMAGE_WIDTH = 480;
    int tempAddress;
    int upperValue;
    int lowerValue;
    int normalized;

    memset(OneColorImage, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
    memset(ThreeD_Data, 0, HALF_MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

    startX = TabletSetupData.ImageCutStartX[cameraIndex - 1];
    endX = TabletSetupData.ImageCutEndX[cameraIndex - 1];
    startY = TabletSetupData.ImageCutStartY[cameraIndex - 1];
    endY = TabletSetupData.ImageCutEndY[cameraIndex - 1];

    if (startX < 0) startX = 0;
    if (endX > MAX_IMAGE_WIDTH) endX = MAX_IMAGE_WIDTH;
    if (startY < 0) startY = 0;
    if (endY > MAX_IMAGE_HEIGHT) endY = MAX_IMAGE_HEIGHT;

    // 90 ȸ ̹Ƿ X, Y  ROI  ݴ Ѵ.
    rotateStX = (startY / 2) * 4;
    rotateEdX = (endY / 2) * 4;
    rotateStY = startX / 2;
    rotateEdY = endX / 2;

    for (y = rotateStY; y < rotateEdY; y++)
    {
      for (x = rotateStX; x < rotateEdX; x += 2)
      {
        tempAddress = THREE_D_SRC_IMAGE_WIDTH * y + x / 2;

        upperValue = (BayerImage[(y * THREE_D_SRC_IMAGE_WIDTH * 2) + x + 1]) << 8;
        lowerValue = (BayerImage[(y * THREE_D_SRC_IMAGE_WIDTH * 2) + x + 0]);

        normalized = min(255, (int)((upperValue + lowerValue) * 255 / 65535));

        if (normalized)
          OneColorImage[tempAddress] = 255 - normalized;
        else
          OneColorImage[tempAddress] = 0;
      }
    }

    startX = TabletSetupData.ImageCutStartX[cameraIndex - 1] / 2;
    endX = TabletSetupData.ImageCutEndX[cameraIndex - 1] / 2;

    if (startX < 0) startX = 0;
    if (endX > MAX_IMAGE_WIDTH / 2) endX = MAX_IMAGE_WIDTH / 2;

    for (y = startY; y < endY; y++)
    {
      for (x = startX; x < endX; x++)
      {
        ThreeD_Data[y * HALF_MAX_IMAGE_WIDTH + x] = OneColorImage[x * THREE_D_SRC_IMAGE_WIDTH + y];
      }
    }

    startX = TabletSetupData.ImageCutStartX[cameraIndex - 1];
    endX = TabletSetupData.ImageCutEndX[cameraIndex - 1];

    int HalfStartX = startX / 2;
    int HalfEndX = endX / 2;
    int tempAddress2;
    int value;

    // half  
    memset(ThreeD_Image, 0, MAX_IMAGE_WIDTH*MAX_IMAGE_HEIGHT);
    for (y = startY; y < endY; y++)
    {
      for (x = HalfStartX; x < HalfEndX; x++)
      {
        tempAddress = HALF_MAX_IMAGE_WIDTH * y + x;
        tempAddress2 = MAX_IMAGE_WIDTH * y + x * 2;

        value = ThreeD_Data[tempAddress];
        if (value >= 10)
        {
          ThreeD_Image[tempAddress2 + 0] = value;
          ThreeD_Image[tempAddress2 + 1] = value;
        }
      }
    }

    return true;
  }
  else
  {
    return false;
  }
}

//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::LIMAPositionProcess(int cameraIndex, bool StudyMode, int param1, int param2)
{
  int ImageIndex = LIMAThreeDIndexUpDownBtn->Position;
  LIMAImageIndexEdit->Text = IntToStr(ImageIndex);

  bool blankSW = false;
  bool OverHeightSW = false;
  int EdgeErrorSW = 0;
  unsigned char OutLineImage[MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT];
  memset(OutLineImage, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

  if(ThreeDImageLoad(ImageIndex, cameraIndex))
  {
    int tempLIMA_ThreeD_Side_EraseLevel;
    int tempLIMA_ThreeD_MaxHeight;
    int tempLIMA_ThreeD_OverHeightSize;
    
    if(StudyMode)
    {
      tempLIMA_ThreeD_Side_EraseLevel = param1;
      tempLIMA_ThreeD_MaxHeight = param2;
      tempLIMA_ThreeD_OverHeightSize = Table_Interval_PixelAndMeterForThreeD[SizeValue[80] / 10];
    }
    else
    {
      tempLIMA_ThreeD_Side_EraseLevel = IntensityValue[79];
      tempLIMA_ThreeD_MaxHeight = IntensityValue[80];
      tempLIMA_ThreeD_OverHeightSize = Table_Interval_PixelAndMeterForThreeD[SizeValue[80] / 10];
    }

    int startX, endX, startY, endY;
    int tempCount;
    int x, y;
    int leftGrad;
    int rightGrad;
    int upGrad;
    int downGrad;
    int tempAddress;
    int tempX, tempY;
    int gradX, gradY;
    int r;
    int neighborSumColor;
    int tempAddress2;
    const int MIN_TABLET_SIZE = 50;
    int halfImageWidth;
    int halfImageHeight;
    int maxImgSize;
    int maxLabelN;
    int HalfStartX, HalfEndX;
    int HalfStartY, HalfEndY;

    startX = TabletSetupData.ImageCutStartX[cameraIndex - 1];
    endX = TabletSetupData.ImageCutEndX[cameraIndex - 1];
    startY = TabletSetupData.ImageCutStartY[cameraIndex - 1];
    endY = TabletSetupData.ImageCutEndY[cameraIndex - 1];

    HalfStartX = startX / 2;
    HalfEndX = endX / 2;
    HalfStartY = startY / 2;
    HalfEndY = endY / 2;

    memcpy(OneColorImage, ThreeD_Image, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

    // hole check
    for (y = startY; y < endY; y++)
    {
      for (x = startX; x < endX; x++)
      {
        tempAddress = MAX_IMAGE_WIDTH * y + x;
        if (OneColorImage[tempAddress] == 0)
        {
          neighborSumColor = tempCount = 0;

          if(OneColorImage[tempAddress - 2])
          {
            neighborSumColor += OneColorImage[tempAddress - 2];
            tempCount++;
          }
          else
          {
            continue; 
          }

          if(OneColorImage[tempAddress + 2])
          {
            neighborSumColor += OneColorImage[tempAddress + 2];
            tempCount++;
          }
          else
          {
            continue; 
          }

          if(OneColorImage[tempAddress - 2 * MAX_IMAGE_WIDTH])
          {
            neighborSumColor += OneColorImage[tempAddress - 2 * MAX_IMAGE_WIDTH];
            tempCount++;
          }
          else
          {
            continue; 
          }

          if(OneColorImage[tempAddress + 2 * MAX_IMAGE_WIDTH])
          {
            neighborSumColor += OneColorImage[tempAddress + 2 * MAX_IMAGE_WIDTH];
            tempCount++;
          }
          else
          {
            continue; 
          }

          ThreeD_Image[tempAddress] = neighborSumColor / tempCount;
        }
      }
    }

    halfImageWidth = MAX_IMAGE_WIDTH / 2;
    halfImageHeight = MAX_IMAGE_HEIGHT / 2;
    maxImgSize = halfImageWidth * halfImageHeight;

    memset(HalfTempImage, 0, maxImgSize);
    memset(HalfLabelImage, 0, 2 * maxImgSize);

    for (y = startY; y < endY; y += 2)
    {
      for (x = startX; x < endX; x += 2)
      {
        tempAddress = (y / 2)* halfImageWidth + (x / 2);

        HalfTempImage[tempAddress] = ThreeD_Image[MAX_IMAGE_WIDTH * y + x];
      }
    }

    maxLabelN = LabellingForTabletImage(HalfLabelImage, HalfTempImage, HalfStartX, HalfEndX, HalfStartY, HalfEndY, halfImageWidth, halfImageHeight);

    if(maxLabelN)
    {
      ProtoTabletCenterX = ProtoTabletCenterY = tempCount = 0;
      for (y = startY; y < endY; y++)
      {
        for (x = startX; x < endX; x++)
        {
          tempAddress = MAX_IMAGE_WIDTH * y + x;
          tempAddress2 = halfImageWidth * (y / 2) + (x / 2);
          if (HalfLabelImage[tempAddress2] == maxLabelN)
          {
            ProtoTabletCenterX += x;
            ProtoTabletCenterY += y;
            tempCount++;
          }
          else
          {
            ThreeD_Image[tempAddress] = 0;
          }
        }
      }

      if(tempCount)
      {
        ProtoTabletCenterX /= tempCount;
        ProtoTabletCenterY /= tempCount;
      }
      else if(tempCount <= MIN_TABLET_SIZE)
      {
        blankSW = true;
      }
    }
    else
    {
      blankSW = true;
    }

    unsigned char *resultImage = OneColorImage;
    memset(resultImage, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);

    memset(GradientImage, 0, MAX_IMAGE_WIDTH * MAX_IMAGE_HEIGHT);
    for (y = startY; y < endY; y++)
    {
      for (x = startX; x < endX; x++)
      {
        tempAddress = y * MAX_IMAGE_WIDTH + x;

        leftGrad = ThreeD_Image[tempAddress] - ThreeD_Image[tempAddress - 4];
        rightGrad = ThreeD_Image[tempAddress] - ThreeD_Image[tempAddress + 4];
        upGrad = ThreeD_Image[tempAddress] - ThreeD_Image[tempAddress - MAX_IMAGE_WIDTH * 4];
        downGrad = ThreeD_Image[tempAddress] - ThreeD_Image[tempAddress + MAX_IMAGE_WIDTH * 4];

        if (leftGrad < 0) leftGrad = 0;
        if (rightGrad < 0) rightGrad = 0;
        if (upGrad < 0) upGrad = 0;
        if (downGrad < 0) downGrad = 0;

        if (x < ProtoTabletCenterX)
        {
          gradX = leftGrad;
        }
        else
        {
          gradX = rightGrad;
        }

        if (y < ProtoTabletCenterY)
        {
          gradY = upGrad;
        }
        else
        {
          gradY = downGrad;
        }

        if (gradX > gradY)
          GradientImage[tempAddress] = gradX;
        else
          GradientImage[tempAddress] = gradY;

        if (GradientImage[tempAddress] < 3) GradientImage[tempAddress] = 0;
      }
    }

    if(tempLIMA_ThreeD_Side_EraseLevel)
    {
      for (y = startY; y < endY; y++)
      {
        for (x = startX; x < endX; x++)
        {
          tempAddress = y * MAX_IMAGE_WIDTH + x;

          if(GradientImage[tempAddress] >= tempLIMA_ThreeD_Side_EraseLevel)
          {
            for(tempY = y - 1; tempY <= y + 1; tempY++)
            {
              for(tempX = x - 1; tempX <= x + 1; tempX++)
              {
                if(tempX >= 0 && tempX < MAX_IMAGE_WIDTH && tempY >= 0 && tempY < MAX_IMAGE_HEIGHT)
                {
                  resultImage[tempY * MAX_IMAGE_WIDTH + tempX] = 1;
                }
              }
            }
          }
        }
      }
    }

    int outlineInfoTable[361][3];
    memset(outlineInfoTable, 0, sizeof(int) * 361 * 3);

    for(int angle = 0; angle <= 360; angle++)
    {
      bool firstSW = true;
      int FirstPositionData;
      int tempData;
      for(int length = 1; length <= 600; length++)
      {
        x = length * cos(angle * PI / 180.0) + ProtoTabletCenterX;
        y = length * sin(angle * PI / 180.0) + ProtoTabletCenterY;

        if(x > 0 && x < MAX_IMAGE_WIDTH && y > 0 && y < MAX_IMAGE_HEIGHT)
        {
          outlineInfoTable[angle][1] = 0xFFFF;
          outlineInfoTable[angle][2] = 0xFFFF;

          if(firstSW)
          {
            FirstPositionData = resultImage[y * MAX_IMAGE_WIDTH + x];
            firstSW = false;
          }
          else
          {
            tempData = resultImage[y * MAX_IMAGE_WIDTH + x];

            if(FirstPositionData != tempData)
            {
              outlineInfoTable[angle][0] = length;
              outlineInfoTable[angle][1] = x;
              outlineInfoTable[angle][2] = y;
              break;
            }
          }
        }
      }
    }

    for(int angle = 0; angle <= 360; angle++)
    {
      x = outlineInfoTable[angle][1];
      y = outlineInfoTable[angle][2];

      for(tempY = y - 2; tempY <= y + 2; tempY++)
      {
        for(tempX = x - 2; tempX <= x + 2; tempX++)
        {
          if(tempX >= 0 && tempX < MAX_IMAGE_WIDTH && tempY >= 0 && tempY < MAX_IMAGE_HEIGHT)
          {
            if(resultImage[tempY * MAX_IMAGE_WIDTH + tempX] == 0)
            {
              OutLineImage[tempY * MAX_IMAGE_WIDTH + tempX] = 2;
            }
          }
        }
      }
    }

    int shortAxisAngle;
    int longAxisAngle;
    int minValue = 0xFFFFFF;
    int maxValue = 0;
    for(int angle = 0; angle < 360; angle++)
    {
      int tempLength = 0;
      bool continueSW = false;
      for(int shift = -30; shift <= 30; shift += 10)
      {
        int tempAngle1 = (angle + shift + 360) % 360;
        int tempAngle2 = (angle + shift + 180 + 360) % 360;

        if(outlineInfoTable[tempAngle1][0] && outlineInfoTable[tempAngle2][0])
        {
          tempLength += outlineInfoTable[tempAngle1][0] + outlineInfoTable[tempAngle2][0];
        }
        else
        {
          continueSW = true;
          break;
        }
      }

      if(tempLength)
      {
        if(minValue > tempLength)
        {
          minValue = tempLength;
          shortAxisAngle = angle;
        }

        if(maxValue < tempLength)
        {
          maxValue = tempLength;
          longAxisAngle = angle;
        }
      }
    }

    int shortAxisAngle1;
    int longAxisAngle1;
    int shortAxisAngle2;
    int longAxisAngle2;

    shortAxisAngle1 = shortAxisAngle;
    shortAxisAngle2 = (shortAxisAngle + 180 + 360) % 360;
    longAxisAngle1 = longAxisAngle;
    longAxisAngle2 = (longAxisAngle + 180 + 360) % 360;

    int range = 0xFFFFFF;
    if(range > abs(longAxisAngle1 - shortAxisAngle1))
    {
      range = abs(longAxisAngle1 - shortAxisAngle1);
    }
    if(range > abs(longAxisAngle1 - shortAxisAngle2))
    {
      range = abs(longAxisAngle1 - shortAxisAngle2);
    }
    if(range > abs(longAxisAngle2 - shortAxisAngle1))
    {
      range = abs(longAxisAngle2 - shortAxisAngle1);
    }
    if(range > abs(longAxisAngle2 - shortAxisAngle2))
    {
      range = abs(longAxisAngle2 - shortAxisAngle2);
    }

    int scaleSW;
    int lengthDiffCount = 0;
    /*
    int thresholdddd[361];
    memset(thresholdddd, 0, 4 * 361);
    for(int angle = 0; angle <= 359; angle++)
    {
      for(int checkPos = 2; checkPos <= 6; checkPos += 2)
      {
        int closedSection;
        int closedCoff;
        int tempMinV;
        int tempMaxV;
        closedCoff = 0xFFFFFF;

        if(closedCoff > abs(angle - shortAxisAngle1))
        {
          closedCoff = abs(angle - shortAxisAngle1);
          closedSection = shortAxisAngle1;
          scaleSW = 0;
        }
        if(closedCoff > abs(359 - angle - shortAxisAngle1))
        {
          closedCoff = abs(359 - angle - shortAxisAngle1);
          closedSection = shortAxisAngle1;
          scaleSW = 1;
        }

        if(closedCoff > abs(angle - shortAxisAngle2))
        {
          closedCoff = abs(angle - shortAxisAngle2);
          closedSection = shortAxisAngle2;
          scaleSW = 0;
        }
        if(closedCoff > abs(359 - angle - shortAxisAngle2))
        {
          closedCoff = abs(359 - angle - shortAxisAngle2);
          closedSection = shortAxisAngle2;
          scaleSW = 1;
        }

        if(closedCoff > abs(angle - longAxisAngle1))
        {
          closedCoff = abs(angle - longAxisAngle1);
          closedSection = longAxisAngle1;
          scaleSW = 0;
        }
        if(closedCoff > abs(359 - angle - longAxisAngle1))
        {
          closedCoff = abs(359 - angle - longAxisAngle1);
          closedSection = longAxisAngle1;
          scaleSW = 1;
        }

        if(closedCoff > abs(angle - longAxisAngle2))
        {
          closedCoff = abs(angle - longAxisAngle2);
          closedSection = longAxisAngle2;
          scaleSW = 0;
        }
        if(closedCoff > abs(359 - angle - longAxisAngle2))
        {
          closedCoff = abs(359 - angle - longAxisAngle2);
          closedSection = longAxisAngle2;
          scaleSW = 1;
        }

        int threshold;
        if(minValue != 0xFFFFFF && maxValue != 0)
        {
          if(scaleSW)
          {
            if(range)
            {
              threshold = 10 * (float)(1.0 + abs(359 - angle - closedSection) / (float)range);
            }
            else
            {
              threshold = 10;
            }
          }
          else
          {
            tempMinV = min(angle, closedSection);
            tempMaxV = max(angle, closedSection);

            if(range)
            {
              threshold = 10 * (float)(1.0 + (tempMaxV - tempMinV) / (float)range);
            }
            else
            {
              threshold = 10;
            }
          }
        }
        else
        {
          threshold = 10;
        }

        thresholdddd[angle] = threshold;

        int tempAngle1 = (angle + checkPos + 360) % 360;
        int tempAngle2 = (angle - checkPos + 360) % 360;

        if(abs(outlineInfoTable[angle][0] - outlineInfoTable[tempAngle1][0]) > threshold &&
          abs(outlineInfoTable[angle][0] - outlineInfoTable[tempAngle1][0]) > threshold)
        {
          lengthDiffCount++;

          x = outlineInfoTable[angle][1];
          y = outlineInfoTable[angle][2];

          for(tempY = y - 2; tempY <= y + 2; tempY++)
          {
            for(tempX = x - 2; tempX <= x + 2; tempX++)
            {
              if(tempX >= 0 && tempX < MAX_IMAGE_WIDTH && tempY >= 0 && tempY < MAX_IMAGE_HEIGHT)
              {
                resultImage[tempY * MAX_IMAGE_WIDTH + tempX] = 2;
              }
            }
          }
        }
      }
    }
    */

    for(int angle = 0; angle <= 359; angle++)
    {
      tempCount = 0;
      int lengthTable[50];
      int lengthModelTable[50];
      int compareAddress;
      memset(lengthTable, 0, sizeof(int) * 50);
      memset(lengthModelTable, 0, sizeof(int) * 50);

      for(int checkPos = -30; checkPos <= 30; checkPos += 3)
      {
        int tempAngle = (angle + checkPos + 360) % 360;

        if(checkPos == 0)
        {
          compareAddress = tempCount;
        }

        lengthTable[tempCount] = outlineInfoTable[tempAngle][0];
        tempCount++;
      }

      ThreeDEdgeModeling(lengthTable, 0, tempCount, lengthModelTable);

      if(abs(lengthTable[compareAddress] - lengthModelTable[compareAddress]) > 10)
      {
        lengthDiffCount++;

        x = outlineInfoTable[angle][1];
        y = outlineInfoTable[angle][2];

        for(tempY = y - 2; tempY <= y + 2; tempY++)
        {
          for(tempX = x - 2; tempX <= x + 2; tempX++)
          {
            if(tempX >= 0 && tempX < MAX_IMAGE_WIDTH && tempY >= 0 && tempY < MAX_IMAGE_HEIGHT)
            {
              resultImage[tempY * MAX_IMAGE_WIDTH + tempX] = 2;
            }
          }
        }
      }
    }

    int noneAreaCount = 0;
    for(int angle = 0; angle <= 359; angle++)
    {
      x = outlineInfoTable[angle][1];
      y = outlineInfoTable[angle][2];

      if(x == 0xFFFF && y == 0xFFFF)
      {
        noneAreaCount++;
      }
    }

    if(tempLIMA_ThreeD_Side_EraseLevel)
    {
      /*if(lengthDiffCount > 4)
      {
        EdgeErrorSW = lengthDiffCount;
      }
      else */
      if(noneAreaCount)
      {
        EdgeErrorSW = noneAreaCount;
      }
    }

    int errorHeightCount = 0;
    int TabletHeight;

    if(tempLIMA_ThreeD_MaxHeight)
    {
      errorHeightCount = 0;
      if(cameraIndex == SD1_3D_FRONT_FACE_CAMERA_INDEX)
      {
        TabletHeight = TabletStudyData.tabletMaxThickForFirstDisk;
      }
      else if(cameraIndex == SD2_3D_FRONT_FACE_CAMERA_INDEX)
      {
        TabletHeight = TabletStudyData.tabletMaxThickForSecondDisk;
      }

      TabletHeight += tempLIMA_ThreeD_MaxHeight;

      for (y = startY; y < endY; y++)
      {
        for (x = startX; x < endX; x++)
        {
          tempAddress = y * MAX_IMAGE_WIDTH + x;

          if(ThreeD_Image[tempAddress] >= TabletHeight)
          {
            errorHeightCount++;
            resultImage[tempAddress] = 2;
          }
        }
      }

      if(errorHeightCount > tempLIMA_ThreeD_OverHeightSize)
      {
        OverHeightSW = true;
      }
    }

    Graphics::TBitmap *img1;
    img1 = new Graphics::TBitmap();
    img1->Width = MAX_IMAGE_WIDTH;
    img1->Height = MAX_IMAGE_HEIGHT;
    img1->PixelFormat = pf24bit;
    int i, j;
    Byte *ptr;

    for(i = 0; i < MAX_IMAGE_HEIGHT; i++)
    {
      ptr = (byte*) img1->ScanLine[i];
      for(j = 0; j < MAX_IMAGE_WIDTH; j++)
      {
        tempAddress = MAX_IMAGE_WIDTH * i + j;

        ptr[3*j + 0] = ThreeD_Image[tempAddress];
        ptr[3*j + 1] = ThreeD_Image[tempAddress];
        ptr[3*j + 2] = ThreeD_Image[tempAddress];

        if(resultImage[tempAddress] == 1)
        {
          ptr[3*j + 1] = 255;
        }
        else if(resultImage[tempAddress] == 2)
        {
          ptr[3*j + 2] = 255;
        }

        if(OutLineImage[tempAddress])
        {
          ptr[3*j + 0] = 255;
          ptr[3*j + 1] = 255;
          ptr[3*j + 2] = 255;
        }
      }
    }

    LIMAThreeDResultImage->Picture->Bitmap->Assign(img1);
    LIMAThreeDResultImage->Refresh();

    delete(img1);
  }
  else
  {
    blankSW = true;
  }

  if(OverHeightSW || blankSW || EdgeErrorSW)
  {
    ThreeDResultLabel->Font->Color = clRed;
    if(blankSW)
    {
      ThreeDResultLabel->Caption = "BLANK";
    }
    else if(EdgeErrorSW)
    {
      ThreeDResultLabel->Caption = "Error(Edge)";
    }
    else
    {
      ThreeDResultLabel->Caption = "Error(Over Height)";
    }
  }
  else
  {
    ThreeDResultLabel->Font->Color = clWhite;
    ThreeDResultLabel->Caption = "PASS";
  }
}

//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::LIMAThreeDIndexUpDownBtnClick(
      TObject *Sender, TUDBtnType Button)
{
  LIMAPositionProcess(SD1_3D_FRONT_FACE_CAMERA_INDEX, false, NULL, NULL);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::LIMAAutoStudyBtnClick(TObject *Sender)
{
  TTntBitBtn *tempBtn = (TTntBitBtn *)Sender;
  int mode = tempBtn->Tag;

  GroupBox4->Enabled = false;
  LIMAStudyStopBtn->Enabled = true;
  LIMAStudyStopBtn->Visible = true;
  LIMAStudyStopBtn->BringToFront();

  LIMAAutoStudyBtn->Visible = false;
  LIMAAutoCheckBtn->Visible = false;
  LIMAGradeSettingCloseButton->Visible = false;
  BitBtn10->Visible = false;

  ThreeDAutoResultLabel1->Visible = true;
  ThreeDAutoResultLabel2->Visible = true;
  ThreeDAutoResultLabel3->Visible = true;
  ThreeDAutoResultLabel4->Visible = true;
  ThreeDAutoResultLabel5->Visible = true;

  LIMA_Params_PassCount = 0;
  LIMA_Params_ImageErrorCount = 0;
  LIMAThresholdErrorCount = 0;
  LIMAHeightLimitErrorCount = 0;

  LIMAStudySW = true;
  
  this->Refresh();

  bool ErrorIndex[100];
  memset(ErrorIndex, false, 100);
  int DefectLastIndex = -1;

  for(int ImageIndex = 1; ImageIndex <= 100; ImageIndex++)
  {
    LIMAThreeDIndexUpDownBtn->Position = ImageIndex;

    if(mode == 1)
    {
      LIMAPositionProcess(SD1_3D_FRONT_FACE_CAMERA_INDEX, true, NULL, NULL);
    }
    else
    {
      LIMAPositionProcess(SD1_3D_FRONT_FACE_CAMERA_INDEX, false, NULL, NULL);
    }

    if(ThreeDResultLabel->Caption == "PASS")
    {
      LIMA_Params_PassCount++;
    }
    else if(ThreeDResultLabel->Caption == "BLANK")
    {
      LIMA_Params_ImageErrorCount++;
    }
    else if(ThreeDResultLabel->Caption == "Error(Over Height)")
    {
      LIMAHeightLimitErrorCount++;
      ErrorIndex[ImageIndex - 1] = true;
      DefectLastIndex = ImageIndex;
    }
    else if(ThreeDResultLabel->Caption == "Error(Edge)")
    {
      LIMAThresholdErrorCount++;
      ErrorIndex[ImageIndex - 1] = true;
      DefectLastIndex = ImageIndex;
    }

    ThreeDAutoResultLabel1->Caption = "Pass : " + IntToStr(LIMA_Params_PassCount);
    ThreeDAutoResultLabel2->Caption = "Th Err : " + IntToStr(LIMAThresholdErrorCount);
    ThreeDAutoResultLabel3->Caption = "Height Err : " + IntToStr(LIMAHeightLimitErrorCount);
    ThreeDAutoResultLabel4->Caption = "Blank : " + IntToStr(LIMA_Params_ImageErrorCount);

    float CurrentPassRatio = 0;
    if(LIMA_Params_PassCount + LIMAThresholdErrorCount + LIMAHeightLimitErrorCount)
    {
      CurrentPassRatio = LIMA_Params_PassCount / (float)(LIMA_Params_PassCount + LIMAThresholdErrorCount + LIMAHeightLimitErrorCount) * 100;
      ThreeDAutoResultLabel5->Caption = "Pass Rate : " + FloatToStrF(CurrentPassRatio, ffFixed, 10, 1) + "%";
    }
    else
    {
      ThreeDAutoResultLabel5->Caption = "Pass Rate : 0.0%";
    }

    Application->ProcessMessages();

    Sleep(10);
    if(LIMAStudySW == false) break;
  }

  AnsiString Str;

  if(DefectLastIndex != -1)
  {
    Str = "Completed\r\n(Error : ";

    for(int ImageIndex = 1; ImageIndex <= 100; ImageIndex++)
    {
      if(ErrorIndex[ImageIndex - 1])
      {
        if(DefectLastIndex != ImageIndex)
        {
          Str += IntToStr(ImageIndex) + ", ";
        }
        else
        {
          Str += IntToStr(ImageIndex) + ")";
        }
      }
    }
  }
  else
  {
    Str = "Completed";
  }

  ShowMessageW(Str);

  GroupBox4->Enabled = true;
  LIMAStudyStopBtn->Enabled = false;
  LIMAStudyStopBtn->Visible = false;

  LIMAAutoStudyBtn->Visible = false;
  LIMAAutoCheckBtn->Visible = true;
  LIMAGradeSettingCloseButton->Visible = true;
  BitBtn10->Visible = true;

  ThreeDAutoResultLabel1->Visible = false;
  ThreeDAutoResultLabel2->Visible = false;
  ThreeDAutoResultLabel3->Visible = false;
  ThreeDAutoResultLabel4->Visible = false;
  ThreeDAutoResultLabel5->Visible = false;

  this->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::LIMAStudyStopBtnClick(TObject *Sender)
{
  LIMAStudySW = false;
}
//---------------------------------------------------------------------------


void __fastcall TGradeSettingForm::LIMAImageIndexEditClick(TObject *Sender)
{
  TTntEdit *theEdit = (TTntEdit *) Sender;

	KeyboardForm->Text = theEdit->Text;
  if (KeyboardForm->ShowKeypad() == mrOk)
  {
    theEdit->Text = IntToStr(StrToInt(KeyboardForm->Text));
  }
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::LIMAImageIndexEditChange(
      TObject *Sender)
{
  if(LIMAImageIndexEdit->Text != "")
  {
    try
    {
      LIMAThreeDIndexUpDownBtn->Position = StrToInt(LIMAImageIndexEdit->Text);
      LIMAPositionProcess(SD1_3D_FRONT_FACE_CAMERA_INDEX, false, NULL, NULL);
    }
    catch(...)
    {

    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::LIMAImageIndexEditKeyPress(
      TObject *Sender, char &Key)
{
  Key = NULL;  
}
//---------------------------------------------------------------------------

void ThreeDEdgeModeling(int *srcData, int stPoint, int endPoint, int *dstData)
{
  long long xPositionMat[50][3];
  long long xPositionTransMat[3][50];
  long long yPositionMat[50];
  long long squareMultipleMat[3][3];
  long long inverseMat[3][3];
  long long resultMultipleMat[3][50];
  long long detA;
  long long modelingConstA, modelingConstB, modelingConstC;
  int tempX, tempY;
  int tempX2, tempY2;
  int k;

  memset(xPositionMat, 0, sizeof(long long) * 50 * 3);
  memset(xPositionTransMat, 0, sizeof(long long) * 50 * 3);
  memset(yPositionMat, 0, sizeof(long long) * 50);
  memset(squareMultipleMat, 0, sizeof(long long) * 3 * 3);
  memset(inverseMat, 0, sizeof(long long) * 3 * 3);
  memset(resultMultipleMat, 0, sizeof(long long) * 3 * 50);

  for(k = stPoint; k < endPoint; k++)
  {
    xPositionMat[k][0] = k * k;
    xPositionMat[k][1] = k;
    xPositionMat[k][2] = 1;

    xPositionTransMat[0][k] = k * k;
    xPositionTransMat[1][k] = k;
    xPositionTransMat[2][k] = 1;

    yPositionMat[k] = srcData[k];
  }

  for(k = stPoint; k < endPoint; k++)
  {
    squareMultipleMat[0][0] += xPositionTransMat[0][k] * xPositionMat[k][0];
    squareMultipleMat[0][1] += xPositionTransMat[0][k] * xPositionMat[k][1];
    squareMultipleMat[0][2] += xPositionTransMat[0][k] * xPositionMat[k][2];

    squareMultipleMat[1][0] += xPositionTransMat[1][k] * xPositionMat[k][0];
    squareMultipleMat[1][1] += xPositionTransMat[1][k] * xPositionMat[k][1];
    squareMultipleMat[1][2] += xPositionTransMat[1][k] * xPositionMat[k][2];

    squareMultipleMat[2][0] += xPositionTransMat[2][k] * xPositionMat[k][0];
    squareMultipleMat[2][1] += xPositionTransMat[2][k] * xPositionMat[k][1];
    squareMultipleMat[2][2] += xPositionTransMat[2][k] * xPositionMat[k][2];
  }
  
  detA =   squareMultipleMat[0][0] * (squareMultipleMat[1][1] * squareMultipleMat[2][2] - squareMultipleMat[1][2] * squareMultipleMat[2][1])
         - squareMultipleMat[0][1] * (squareMultipleMat[1][0] * squareMultipleMat[2][2] - squareMultipleMat[1][2] * squareMultipleMat[2][0])
         + squareMultipleMat[0][2] * (squareMultipleMat[1][0] * squareMultipleMat[2][1] - squareMultipleMat[1][1] * squareMultipleMat[2][0]);

  if(detA == 0)
  {
    return;
  }

  inverseMat[0][0] = (squareMultipleMat[1][1] * squareMultipleMat[2][2] - squareMultipleMat[2][1] * squareMultipleMat[1][2]);
  inverseMat[0][1] = (squareMultipleMat[0][2] * squareMultipleMat[2][1] - squareMultipleMat[0][1] * squareMultipleMat[2][2]);
  inverseMat[0][2] = (squareMultipleMat[0][1] * squareMultipleMat[1][2] - squareMultipleMat[0][2] * squareMultipleMat[1][1]);

  inverseMat[1][0] = (squareMultipleMat[1][2] * squareMultipleMat[2][0] - squareMultipleMat[1][0] * squareMultipleMat[2][2]);
  inverseMat[1][1] = (squareMultipleMat[0][0] * squareMultipleMat[2][2] - squareMultipleMat[0][2] * squareMultipleMat[2][0]);
  inverseMat[1][2] = (squareMultipleMat[1][0] * squareMultipleMat[0][2] - squareMultipleMat[0][0] * squareMultipleMat[1][2]);

  inverseMat[2][0] = (squareMultipleMat[1][0] * squareMultipleMat[2][1] - squareMultipleMat[2][0] * squareMultipleMat[1][1]);
  inverseMat[2][1] = (squareMultipleMat[2][0] * squareMultipleMat[0][1] - squareMultipleMat[0][0] * squareMultipleMat[2][1]);
  inverseMat[2][2] = (squareMultipleMat[0][0] * squareMultipleMat[1][1] - squareMultipleMat[1][0] * squareMultipleMat[0][1]);

  for(k = stPoint; k < endPoint; k++)
  {
    resultMultipleMat[0][k] += (inverseMat[0][0] * xPositionTransMat[0][k] + inverseMat[0][1] * xPositionTransMat[1][k] + inverseMat[0][2] * xPositionTransMat[2][k]);
    resultMultipleMat[1][k] += (inverseMat[1][0] * xPositionTransMat[0][k] + inverseMat[1][1] * xPositionTransMat[1][k] + inverseMat[1][2] * xPositionTransMat[2][k]);
    resultMultipleMat[2][k] += (inverseMat[2][0] * xPositionTransMat[0][k] + inverseMat[2][1] * xPositionTransMat[1][k] + inverseMat[2][2] * xPositionTransMat[2][k]);
  }

  modelingConstA = modelingConstB = modelingConstC = 0;

  for(k = stPoint; k < endPoint; k++)
  {
    modelingConstA += resultMultipleMat[0][k] * yPositionMat[k];
    modelingConstB += resultMultipleMat[1][k] * yPositionMat[k];
    modelingConstC += resultMultipleMat[2][k] * yPositionMat[k];
  }

  for(k = stPoint; k < endPoint; k++)
  {
    tempY = (modelingConstA * k * k + modelingConstB * k + modelingConstC) / detA;
    dstData[k] = tempY;
  }
}

//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::SetupDataSettingButtonClick(
      TObject *Sender)
{
  if(!ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_MAINFORM_FEATURE_EXTRACTION])
	{
    SetupDataSettingButton->Visible = false;
    ShowMessageFA(NEW_ADD_STRING_88);
    return;
	}
  else
    SetupDataSettingButton->Visible = true;

	SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

  TTabletCharacterExtractForm *tabletCharacterExtractForm = new TTabletCharacterExtractForm(this);
  tabletCharacterExtractForm->SetupMode = TABLET_SETUP_MODE_REVISION;
  tabletCharacterExtractForm->ShowModal();
  if(tabletCharacterExtractForm->SetupDataChanged == true)
  {
    CPBSetupInfo.InspectionSetupDataValid = false;
    if (!ReadSetupData(&TabletSetupData))
    {
      ShowMessageW(GRADESETTING_MSG_01);
    }

    if (!Read3DSetupData(&Tablet3DSetupData))
    {
      ShowMessageW(GRADESETTING_MSG_01);
    }

    AnsiString studyFileName = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\" + ProductData.ProductCode + ".stu";
    if (!LoadStudyData(studyFileName, TabletStudyData))
    {
      ShowMessageW(GRADESETTING_MSG_02);
    }

    MakeTabletCharacterData(&ProductData, &TabletCharacter, &MachineParams);
  }

	delete tabletCharacterExtractForm;
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::DefectSearchForColorDirtyOptionClick(
      TObject *Sender)
{
	if (DefectSearchForColorDirtyOption->Checked == true)
	{
		TabletGradeData.DefectSearchForColorDirtyOption = 1;

    if(TabletGradeData.DefectSearchForColorDirtyOptOffset < 0.1)
    {
      TabletGradeData.DefectSearchForColorDirtyOptOffset = 1.5;
    }
	}
	else
	{
		TabletGradeData.DefectSearchForColorDirtyOption = 0;
	}
}
//---------------------------------------------------------------------------


void __fastcall TGradeSettingForm::SideCamMatchingOptionComboBoxChange(
      TObject *Sender)
{
  TabletGradeData.SideCamMathingOption = SideCamMatchingOptionComboBox->ItemIndex;
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::DefectSearchForColorDirtyOptOffsetEditClick(
      TObject *Sender)
{
  int LimitValue = 0;
  float InputValue = 0;
  
  TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
  if (KeyboardForm->ShowKeypad() == mrOk)
  {
    InputValue = StrToFloat(KeyboardForm->Text);

    if(InputValue < LimitValue)
    {
      ShowMessage(" 0 Ŀմϴ ");
      return;
    }
    
		theEdit->Text = KeyboardForm->Text;
	}    
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::OffsetValueInitButton1Click(
      TObject *Sender)
{
  TabletGradeData.DefectSearchForColorDirtyOptOffset = 1.5;
  DefectSearchForColorDirtyOptOffsetEdit->Text = FloatToStr(TabletGradeData.DefectSearchForColorDirtyOptOffset);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::AllowXScrollBarChange(TObject *Sender)
{
	int value;
	SideBreakGradePanel->Visible = false;
	ColorDirtyControlPanel->Visible = false;
	SideEdgeDirtyGradeSettingPanel->Visible = false;
	SplitLineRecognizationOptionPanel->Visible = false;
	LIMAGradeSettingPanel->Visible = false;

	GroupBox8->Visible = false;
	Panel2->Visible = false;
	PrintGradePanel->Visible = false;
	WhiteEngraveDefectPanel->Visible = false;
	StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;

	IntensityValue[81] = AllowXScrollBar->Position;
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::AllowYScrollBarChange(TObject *Sender)
{
	int value;
	SideBreakGradePanel->Visible = false;
	ColorDirtyControlPanel->Visible = false;
	SideEdgeDirtyGradeSettingPanel->Visible = false;
	SplitLineRecognizationOptionPanel->Visible = false;
	LIMAGradeSettingPanel->Visible = false;

	GroupBox8->Visible = false;
	Panel2->Visible = false;
	PrintGradePanel->Visible = false;
	WhiteEngraveDefectPanel->Visible = false;
	StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;

	IntensityValue[82] = AllowYScrollBar->Position;
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::AllowDegreeScrollBarChange(
      TObject *Sender)
{
	int value;
	SideBreakGradePanel->Visible = false;
	ColorDirtyControlPanel->Visible = false;
	SideEdgeDirtyGradeSettingPanel->Visible = false;
	SplitLineRecognizationOptionPanel->Visible = false;
	LIMAGradeSettingPanel->Visible = false;

	GroupBox8->Visible = false;
	Panel2->Visible = false;
	PrintGradePanel->Visible = false;
	WhiteEngraveDefectPanel->Visible = false;
	StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;

	IntensityValue[83] = AllowDegreeScrollBar->Position;
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::GradeButton84Click(TObject *Sender)
{
	GradeButton1->Font->Color = clMaroon;
	GradeButton2->Font->Color = clMaroon;
	GradeButton3->Font->Color = clMaroon;
	GradeButton4->Font->Color = clMaroon;
	GradeButton5->Font->Color = clMaroon;
	GradeButton6->Font->Color = clMaroon;
	GradeButton7->Font->Color = clMaroon;
	GradeButton8->Font->Color = clMaroon;
	GradeButton9->Font->Color = clMaroon;
	GradeButton11->Font->Color = clRed;
	GradeButton12->Font->Color = clMaroon;
	GradeButton13->Font->Color = clMaroon;
	GradeButton14->Font->Color = clMaroon;
	GradeButton15->Font->Color = clMaroon;
	GradeButton16->Font->Color = clMaroon;
	GradeButton28->Font->Color = clMaroon;
	GradeButton29->Font->Color = clMaroon;
	GradeButton30->Font->Color = clMaroon;
	GradeButton31->Font->Color = clMaroon;
  GradeButton32->Font->Color = clMaroon;
  GradeButton33->Font->Color = clMaroon;

	ThreeDEngraveDefectPanel->Visible = false;
	SideEdgeNeighborGradeSettingPanel->Visible = false;
	SideEdgeGradeSettingPanel->Visible = false;
  SideBreakGradePanel->Visible = false;
	Panel2->Visible = true;
  Panel2->Height = 254;
  PrintGradePanel->Visible = false;

  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	StaticText1->Caption = "˻ ";

	Image2->Visible = false;
	Image3->Visible = false;
	Image4->Visible = false;
	StaticText1->Visible = false;
	StaticText2->Visible = false;
	StaticText4->Visible = false;
	BitBtn13->Visible = false;
	BitBtn14->Visible = false;


	SelectedDefectN = 84;
	SelectedDefectN2 = 0;
	IntensityBarDisplay();

	DisplayTabletShapeData(FRONT_SHAPE, 0, DISPLAY_FRONT);
}
//---------------------------------------------------------------------------

void __fastcall TGradeSettingForm::BeltPowderSensitivityScrollBarChange(TObject *Sender)
{
	SideBreakGradePanel->Visible = false;

	ColorDirtyControlPanel->Visible = false;
  SideEdgeDirtyGradeSettingPanel->Visible = false;
  SplitLineRecognizationOptionPanel->Visible = false;
  LIMAGradeSettingPanel->Visible = false;

	GroupBox15->Visible = false;
	GroupBox8->Visible = false;
	Panel2->Visible = false;
  PrintGradePanel->Visible = false;
  WhiteEngraveDefectPanel->Visible = false;
  StainDefectCheckPanel->Visible = false;

	TntPanel4->Visible = false;
	IntensityValue[85] = BeltPowderSensitivityScrollBar->Position;
	DisplayEachGradeValue();
}
//---------------------------------------------------------------------------
void __fastcall TGradeSettingForm::SideRemovalAlgorithm3DCheckBoxClick(
      TObject *Sender)
{
	if(SideRemovalAlgorithm3DCheckBox->Checked == true)
		TabletGradeData.SideRemovalAlgorithm3DPassing = 1;
	else
		TabletGradeData.SideRemovalAlgorithm3DPassing = 0;
}
//---------------------------------------------------------------------------
