//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Graph_Check_Form.h"

#include "Inspection_Form.h"
#include "MachineControl_Form.h"
#include "IniFiles.hpp"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TGraph_CheckForm *Graph_CheckForm;
int BeforeSpeed;
//---------------------------------------------------------------------------
__fastcall TGraph_CheckForm::TGraph_CheckForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  if(DefaultLCID == 1042 || DefaultLCID == 2066)
  {
    Sensor_Chart->BottomAxis->Title->Caption = "ð";
    Sensor_Chart->LeftAxis->Title->Caption = "ӵ";
  }
  else
  {
    Sensor_Chart->BottomAxis->Title->Caption = "Time";
    Sensor_Chart->LeftAxis->Title->Caption = "Speed";
  }

  GetDefaultString();
}
//---------------------------------------------------------------------------
void __fastcall TGraph_CheckForm::Graph_Display(void)
{


}
//---------------------------------------------------------------------------
void __fastcall TGraph_CheckForm::GetDefaultString()
{
  GroupBox2->Caption = GRAPHCHECKFORM_GROUPBOX_CAPTION_01;
  GroupBox1->Caption = GRAPHCHECKFORM_GROUPBOX_CAPTION_02;
  GroupBox3->Caption = GRAPHCHECKFORM_GROUPBOX_CAPTION_03;
  Label2->Caption = GRAPHCHECKFORM_LABEL_CAPTION_01;
  Label3->Caption = GRAPHCHECKFORM_LABEL_CAPTION_02;
  Label4->Caption = GRAPHCHECKFORM_LABEL_CAPTION_03;
  Label6->Caption = GRAPHCHECKFORM_LABEL_CAPTION_04;
  Label5->Caption = GRAPHCHECKFORM_LABEL_CAPTION_05;
  Label1->Caption = GRAPHCHECKFORM_LABEL_CAPTION_06;
}
//---------------------------------------------------------------------------
void __fastcall TGraph_CheckForm::Timer1Timer(TObject *Sender)
{
	bool timerEnabled = Timer1->Enabled;
    Timer1->Enabled = false;
	//if (Comm_Request(COMM_HCB, CMD_VIBRATOR_Chul_INFO, NULL, 0, &Chul_VFInfo, sizeof(TChul_VFInfo)))
	if (Comm_Request(COMM_HCB, CMD_VIBRATOR_INFO, NULL, 0, &RealTime_VFInfo, sizeof(TVibratorInfo)))
    {
        Sensor_Chart->Series[0]->Clear();
        Sensor_Chart->Series[1]->Clear();
        Sensor_Chart->Series[2]->Clear();
                
        int currentVFListIndex = RealTime_VFInfo.CurrentListIndex & VFINFO_LIST_MASK ;
        double VF_NowSpeed[VFINFO_LIST_COUNT];
        double VF_AverageSpeed[VFINFO_LIST_COUNT];
        double VF_Ratio1[VFINFO_LIST_COUNT];
		double VF_Ratio2[VFINFO_LIST_COUNT];

        for ( int vfIndex = 0; vfIndex < VFINFO_LIST_COUNT; vfIndex++ )
        {
            VF_NowSpeed[vfIndex] = RealTime_VFInfo.NowSpeedList[currentVFListIndex];
            VF_AverageSpeed[vfIndex] =RealTime_VFInfo.AverageSpeedList[currentVFListIndex];
            VF_Ratio1[vfIndex] = RealTime_VFInfo.AverageSensor1RatioList[currentVFListIndex];
			VF_Ratio2[vfIndex] = RealTime_VFInfo.AverageSensor2RatioList[currentVFListIndex];
            currentVFListIndex = (currentVFListIndex + 1) & VFINFO_LIST_MASK;
        }

    	Sensor_Chart->Series[0]->AddArray(VF_NowSpeed,VFINFO_LIST_COUNT - 1);
        Sensor_Chart->Series[1]->AddArray(VF_Ratio1, VFINFO_LIST_COUNT - 1);
        Sensor_Chart->Series[2]->AddArray(VF_AverageSpeed, VFINFO_LIST_COUNT - 1);

		//NowSpeed_Label->Caption =  IntToStr(Chul_VFInfo.NowSpeed);
       	Sensor1ON_Label->Caption = IntToStr(RealTime_VFInfo.Sensor1ON_NowRatio);
       	Sensor2ON_Label->Caption = IntToStr(RealTime_VFInfo.Sensor2ON_NowRatio);
       	SetRatio1_Label->Caption = IntToStr(RealTime_VFInfo.SetRatio1);
        SetRatio2_Label->Caption = IntToStr(RealTime_VFInfo.SetRatio2);

        Test_Label1->Caption = IntToStr(RealTime_VFInfo.test1);
        Test_Label2->Caption = IntToStr(RealTime_VFInfo.AverageSensor1Ratio);
        Test_Label3->Caption = IntToStr(RealTime_VFInfo.BeforeSensor1Ratio);
		//Test_Label4->Caption = IntToStr(RealTime_VFInfo.BeforeSensor2Ratio);
       	

        if (RealTime_VFInfo.VFMode == 1)
        {
        	StateLabel->Visible=true;
        	StateLabel->Caption = "Mode : State Check Mode";
        }

        if (RealTime_VFInfo.VFMode == 2)
        {
            StateLabel->Visible=true;
        	StateLabel->Caption = "Mode : Vibrator Auto Mode";
        }

        info.Speed = NowSpeed_Label->Caption;
        info.Ratio = Test_Label2->Caption;

        int BeforeAverageSpeed = StrToInt(NowSpeed_Label->Caption);

        if ( BeforeAverageSpeed != RealTime_VFInfo.NowSpeed )
         {
         	TIniFile *iFile ;
            TIniFile *iFileRatio ;

            ForceDirectories(ProgramPath.Log + "\\Chul");
            iFile = new TIniFile(ProgramPath.Log + "\\Chul\\SpeedList.ini");
          	TStringList *ValList = new TStringList;
          	iFile->ReadSectionValues("SpeedList",ValList);

          	info.count = "List" + IntToStr(ValList->Count);
          	iFile->WriteString("SpeedList", info.count, info.Speed);

            iFileRatio = new TIniFile(ProgramPath.Log + "\\Chul\\RatioList.ini");
            iFileRatio -> WriteString("RatioList", info.count, info.Ratio);

    		delete iFile;
    		delete ValList;
            delete iFileRatio;
         }
            NowSpeed_Label->Caption =  IntToStr(RealTime_VFInfo.NowSpeed);
            BeforeSpeed = RealTime_VFInfo.NowSpeed;
        	//AverageSpeed_Label->Caption = IntToStr(Chul_VFInfo.AverageSpeed);
    }

    else
    {
        //ShowMessageFA("HCB - " + HCBConnection.GetLastErrorMessage());
        //timerEnabled = false;
    }
	Timer1->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TGraph_CheckForm::Sensor1EditClick(TObject *Sender)
{
	KeyboardForm->Text = Sensor1Edit->Text;

    if (KeyboardForm->ShowKeypad() == mrOk)
    {
		Sensor1Edit->Text = KeyboardForm->Text;
    }
   	Sensor1Ratio = StrToInt(Sensor1Edit->Text);
}
//---------------------------------------------------------------------------

void __fastcall TGraph_CheckForm::Sensor2EditClick(TObject *Sender)
{
	KeyboardForm->Text = Sensor2Edit->Text;
    
    if (KeyboardForm->ShowKeypad() == mrOk)
    {
		Sensor2Edit->Text = KeyboardForm->Text;
    }
   	Sensor2Ratio = StrToInt(Sensor2Edit->Text);
}
//---------------------------------------------------------------------------
void __fastcall TGraph_CheckForm::Button1Click(TObject *Sender)
{

   /*	StateLabel->Visible=true;

	StateLabel->Caption = "Mode : Vibrator Auto Mode";  */

	Comm_Request(COMM_HCB, CMD_MACHINE_PARAM_SETUP, &MachineSetupData, sizeof(TMachineSetupData));
}
//---------------------------------------------------------------------------

void __fastcall TGraph_CheckForm::Sensor1RatioButtonClick(TObject *Sender)
{
/*
	MachineControlData_Sensor1Ratio.MachineControlHeader.Target=Chul_Data_Sensor1;
    MachineControlData_Sensor1Ratio.Ratio = Sensor1Ratio;
    MachineControlData_Sensor1Ratio.DisplayMode = 2;
    Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &MachineControlData_Sensor1Ratio, sizeof(TMachineControlData_Sensor1Ratio));
*/
	TMachineControlData_VibrationFeeder machineControlData_VibrationFeeder;

  /*TMachineControlData_SungChulData machineControlData_SungChulData;
  machineControlData_SungChulData.MachineControlHeader.Target = SungChul_Data;
  machineControlData_SungChulData.StartSpeedMode=1;
  Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_SungChulData, sizeof(TMachineControlData_SungChulData)); */

	machineControlData_VibrationFeeder.MachineControlHeader.Target = MACHINE_CONTROL_VIBRATOR;
	machineControlData_VibrationFeeder.Action = 5;
    machineControlData_VibrationFeeder.Sensor1Ratio = Sensor1Ratio;
    machineControlData_VibrationFeeder.DisplayMode = 2;
	Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_VibrationFeeder, sizeof(TMachineControlData_VibrationFeeder));
}
//---------------------------------------------------------------------------

void __fastcall TGraph_CheckForm::Sensor2RatioButtonClick(TObject *Sender)
{
/*
	MachineControlData_Sensor2Ratio.MachineControlHeader.Target=Chul_Data_Sensor2;
    MachineControlData_Sensor2Ratio.Ratio = Sensor2Ratio;
    Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &MachineControlData_Sensor2Ratio, sizeof(TMachineControlData_Sensor2Ratio));
*/
	TMachineControlData_VibrationFeeder machineControlData_VibrationFeeder;

	machineControlData_VibrationFeeder.MachineControlHeader.Target = MACHINE_CONTROL_VIBRATOR;
	machineControlData_VibrationFeeder.Action = 6;
    machineControlData_VibrationFeeder.Sensor2Ratio = Sensor2Ratio;
	Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_VibrationFeeder, sizeof(TMachineControlData_VibrationFeeder));
}
//--------------------------------------------------------------------------

void __fastcall TGraph_CheckForm::Button2Click(TObject *Sender)
{
   /*	StateLabel->Visible=true;
    StateLabel->Caption = "Mode : State Check Mode";   */

/*
	MachineControlData_Sensor1Ratio.MachineControlHeader.Target=Chul_Data_Sensor1;
  	MachineControlData_Sensor1Ratio.DisplayMode = 1;
  	Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &MachineControlData_Sensor1Ratio, sizeof(TMachineControlData_Sensor1Ratio));
*/
	TMachineControlData_VibrationFeeder machineControlData_VibrationFeeder;

	machineControlData_VibrationFeeder.MachineControlHeader.Target = MACHINE_CONTROL_VIBRATOR;
	machineControlData_VibrationFeeder.Action = 5;
    machineControlData_VibrationFeeder.Sensor1Ratio = Sensor1Ratio;
    machineControlData_VibrationFeeder.DisplayMode = 1;
	Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_VibrationFeeder, sizeof(TMachineControlData_VibrationFeeder));
}
//---------------------------------------------------------------------------
void __fastcall TGraph_CheckForm::CloseButtonClick(TObject *Sender)
{
	this->Close();
}
//---------------------------------------------------------------------------
void __fastcall TGraph_CheckForm::FormActivate(TObject *Sender)
{
	Timer1->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TGraph_CheckForm::FormDeactivate(TObject *Sender)
{
	Timer1->Enabled = false;	
}
//---------------------------------------------------------------------------

