//---------------------------------------------------------------------------

#ifndef HCBMonitoring_FormH
#define HCBMonitoring_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include "common.h"
#include "TntGrids.hpp"
#include <ComCtrls.hpp>
#include <Grids.hpp>
#include <vector.h>
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include "Environment.h"
#include <Graphics.hpp>
#include <Buttons.hpp>

//---------------------------------------------------------------------------
#define SENSOR_CHART_WIDTH  1000
#define HCB_MONITORING_DATA_COUNT 1000

#define COUNT_TAG_TOTAL     0
#define COUNT_TAG_GOOD      1
#define COUNT_TAG_DEFECT    2
#define COUNT_TAG_UNINS     3
#define COUNT_TAG_ELSE      4

#define	SENSOR_INTERVAL_LIMIT						100
//---------------------------------------------------------------------------

typedef struct
{
  int DiskSpeed;
  int BaseSpeed;
  int IntervalA;
  int IntervalB;
  TEjectorInfo EjectorInfo;
}THCBSetupData;

class THCBMonitoringForm : public TForm
{
__published:	// IDE-managed Components
  TButton *DataLoadButton;
  TButton *CloseButton;
  TLabel *Label1;
  TLabel *Label2;
  TLabel *Label3;
  TLabel *Label4;
  TLabel *ProductNameLabel;
  TLabel *LOTNameLabel;
  TLabel *InspectionEndTimeLabel;
  TLabel *InspectionStartTimeLabel;
  TPanel *MainPanel;
  TPanel *Panel1;
  TPanel *Panel2;
  TPanel *Panel3;
  TUpDown *PageControl;
  TPanel *PagePanel;
  TPanel *Panel4;
  TTntStringGrid *MonitoringStringGrid;
  TPanel *Panel6;
  TPanel *Panel5;
  TPanel *DataFileNamePanel;
  TPanel *Panel7;
  TImage *Sensor1Image;
  TImage *Sensor2Image;
  TImage *Sensor3Image;
  TPanel *Panel8;
  TPanel *Panel9;
  TLabel *Label5;
  TLabel *DiskSpeedLabel;
  TLabel *IntervalLabel;
  TLabel *Label8;
  TPanel *Panel10;
  TImage *TotalSensorImage;
  TPanel *Panel11;
  TImage *EjectImage;
  TTntGroupBox *ScrollGroupBox;
  TTntImage *ScrollImage;
  TTntImage *upImage;
  TTntImage *downImage;
  TTimer *ScrollTimer;
  TGroupBox *GroupBox1;
  TSpeedButton *ChartScaleOptionBtn1;
  TSpeedButton *ChartScaleOptionBtn2;
  TSpeedButton *ChartScaleOptionBtn3;
  TSpeedButton *ChartScaleOptionBtn4;
  TSpeedButton *ChartScaleOptionBtn5;
  TSpeedButton *ChartScaleOptionBtn6;
  TGroupBox *GroupBox2;
  TLabel *Label6;
  TEdit *NewIntervalAEdit;
  TLabel *Label7;
  TEdit *NewIntervalBEdit;
  TLabel *Label9;
  TEdit *NewDefectSolDelayEdit;
  TEdit *NewUninsSolDelayEdit;
  TLabel *Label10;
  TLabel *Label11;
  TLabel *Label12;
  TLabel *CurrentIntervalALabel;
  TLabel *CurrentIntervalBLabel;
  TLabel *CurrentUninsDelayLabel;
  TLabel *CurrentDefectDelayLabel;
  TButton *SaveDataButton;
  TGroupBox *GroupBox3;
  TLabel *Label13;
  TLabel *Label14;
  TLabel *Label15;
  TLabel *Label16;
  TLabel *Label17;
  TLabel *RealCountInfo1;
  TLabel *RealCountInfo2;
  TLabel *RealCountInfo3;
  TLabel *RealCountInfo4;
  TLabel *RealCountInfo5;
  TGroupBox *GroupBox4;
  TLabel *Label23;
  TLabel *Label24;
  TLabel *Label25;
  TLabel *Label26;
  TLabel *Label27;
  TLabel *AnalysisCountInfo1;
  TLabel *AnalysisCountInfo2;
  TLabel *AnalysisCountInfo3;
  TLabel *AnalysisCountInfo4;
  TLabel *AnalysisCountInfo5;
  TPanel *ProgressPanel;
  TProgressBar *ProgressBar;
  TButton *FindErrorBtn;
  TLabel *ErrorReasonLabel;
  void __fastcall DataLoadButtonClick(TObject *Sender);
  void __fastcall CloseButtonClick(TObject *Sender);
  void __fastcall PageControlClick(TObject *Sender, TUDBtnType Button);
  void __fastcall FormCreate(TObject *Sender);
  void __fastcall MonitoringStringGridClick(TObject *Sender);
  void __fastcall upImageClick(TObject *Sender);
  void __fastcall downImageClick(TObject *Sender);
  void __fastcall ScrollImageMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall ScrollImageMouseMove(TObject *Sender, TShiftState Shift,
          int X, int Y);
  void __fastcall ScrollImageMouseUp(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
  void __fastcall ScrollTimerTimer(TObject *Sender);
  void __fastcall ChartScaleOptionBtn1Click(TObject *Sender);
  void __fastcall NewIntervalAEditClick(TObject *Sender);
  void __fastcall NewIntervalAEditKeyPress(TObject *Sender, char &Key);
  void __fastcall SaveDataButtonClick(TObject *Sender);
  void __fastcall FindErrorBtnClick(TObject *Sender);
  void __fastcall FormActivate(TObject *Sender);
private:	// User declarations
  void __fastcall RefreshDataChart(bool initial);
  void __fastcall ApplyDiskSpeed();
  void __fastcall AnalysisTabletList();
  void __fastcall LoadData(AnsiString RootPath);

  int dataFileCount;
  int CurrentDataPage;

  bool IsScrollImageMouseDown;
  TPoint ScrollImageMouseDownPos;
  TPoint ScrollImageMouseMovePos;
  int StringGridMouseDownPos;
  unsigned int LastScrollTime;

  AnsiString ProductName, LOTName;
  AnsiString DataPath;
  THCBSetupData HCBSetupData;
  THCBSetupData ConvHCBSetupData;
  THCBSetupData NewHCBSetupData;
  THCBSetupData ConvNewHCBSetupData;

  unsigned char S1WriteMask[SENSOR_CHART_WIDTH];
  unsigned char S2WriteMask[SENSOR_CHART_WIDTH];
  unsigned char S3WriteMask[SENSOR_CHART_WIDTH];

  int ChartScale;

  bool bExecutedFindEvent;
  int ShiftRowIndex;

  TProductData tempProductData;

  vector<THCBDisk2TabletUnit> HCBTabletUnitList;
public:		// User declarations
  __fastcall THCBMonitoringForm(TComponent* Owner);

  bool bRecentFileLoad;
  AnsiString RecentFilePath;
};
//---------------------------------------------------------------------------
extern PACKAGE THCBMonitoringForm *HCBMonitoringForm;
//---------------------------------------------------------------------------
#endif
