//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon, 
// CPB05  Ͽ  ߻  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "HPITest_Form.h"
#include "Environment.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntGrids"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
THPITestForm *HPITestForm;
//---------------------------------------------------------------------------
__fastcall THPITestForm::THPITestForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

    SPBIndex = 0;
}
//---------------------------------------------------------------------------
void __fastcall THPITestForm::StartSpeedButtonClick(TObject *Sender)
{
	try
	{
		int testKind = 0;
		if (!Comm_Request(COMM_SPB + SPBIndex, CMD_HPI_TEST, &testKind, sizeof(int)))
		{
			//ShowMessageW(SPBConnection[SPBIndex].GetLastErrorMessage());
        }
    }
    catch (...)
    {

    }
}
//---------------------------------------------------------------------------
void __fastcall THPITestForm::ResultButtonClick(TObject *Sender)
{
	struct
	{
		unsigned int MinTime;
		unsigned int MaxTime;
		unsigned int TotalTime;
		unsigned int AverageTime;
		int ImageSendCount;
        int ErrorCount;
		int ProcessThroughput;
	} hpiTestResult;


	try
	{
		if (!Comm_Request(COMM_SPB + SPBIndex, CMD_HPI_TEST_RESULT, NULL, 0,
			&hpiTestResult, sizeof(hpiTestResult)))
		{
			//ShowMessageW(SPBConnection[SPBIndex].GetLastErrorMessage());
		}
		else
		{
			MinTimeLabel->Caption = FloatToStr(hpiTestResult.MinTime / 20.0) + "ms";
			MaxTimeLabel->Caption = FloatToStr(hpiTestResult.MaxTime / 20.0) + "ms";
			AverageTimeLabel->Caption = FloatToStr(hpiTestResult.AverageTime / 20.0) + "ms";
			ImageSendCountLabel->Caption = IntToStr(hpiTestResult.ImageSendCount);
			ThroughputLabel->Caption = IntToStr(hpiTestResult.ProcessThroughput) + "(KB/S)";
			ErrorCountLabel->Caption = IntToStr(hpiTestResult.ErrorCount);
		}
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------
void __fastcall THPITestForm::StopSpeedButtonClick(TObject *Sender)
{
	try
    {
		if (!Comm_Request(COMM_SPB + SPBIndex, CMD_STOP_SPB_TEST))
		{
			//ShowMessageW(SPBConnection[SPBIndex].GetLastErrorMessage());
		}
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------
void __fastcall THPITestForm::SPBSpeedButtonClick(TObject *Sender)
{
	TTntSpeedButton *theSpeedButton = (TTntSpeedButton *) Sender;
	SPBIndex = theSpeedButton->Tag;
}
//---------------------------------------------------------------------------

void __fastcall THPITestForm::CPBProtocolTestStartButtonClick(
	  TObject *Sender)
{
	struct
	{
		unsigned int func;
		unsigned int cpbIndex;
	} hpiProtocolTestData;
	hpiProtocolTestData.func = 1;
	hpiProtocolTestData.cpbIndex = StrToInt(CPBIndexEdit->Text) - 1;
	Comm_Request(COMM_SPB + SPBIndex, CMD_HPI_PROTOCOL_TEST, &hpiProtocolTestData, sizeof(hpiProtocolTestData));
}
//---------------------------------------------------------------------------

void __fastcall THPITestForm::CPBProtocolTestEndButtonClick(
	  TObject *Sender)
{
	struct
	{
		unsigned int func;
		unsigned int cpbIndex;
	} hpiProtocolTestData;
	hpiProtocolTestData.func = 0;
	hpiProtocolTestData.cpbIndex = StrToInt(CPBIndexEdit->Text) - 1;
	Comm_Request(COMM_SPB + SPBIndex, CMD_HPI_PROTOCOL_TEST, &hpiProtocolTestData, sizeof(hpiProtocolTestData));
}
//---------------------------------------------------------------------------

void __fastcall THPITestForm::ReadTestResultButtonClick(TObject *Sender)
{
	struct
	{
		unsigned int func;
		unsigned int cpbIndex;
	} hpiProtocolTestData;

	struct
	{
		unsigned int TotalSendWord;
		unsigned int TotalErrorWord;
		unsigned int ActualTransferDataWord;
		unsigned int TotalSendCount;
		unsigned int AckPacketCount;
		unsigned int ErrPacketCount;
		unsigned int RetryCount;
		unsigned int ReadErrorCount;
		unsigned int LazeInterruptCount;
		unsigned int CritErrorCount;
		unsigned int RetryExceededCount;
		unsigned int SendTime;
		unsigned int IntStateRetryCount;
		unsigned int CPBErrorPacketCount;
		unsigned int CPBTOPacketCount;
		unsigned int ChecksumErrorPacketCount;
	} hpiStat;

	hpiProtocolTestData.func = 2;
	hpiProtocolTestData.cpbIndex = StrToInt(CPBIndexEdit->Text) - 1;
	if (Comm_Request(COMM_SPB + SPBIndex, CMD_HPI_PROTOCOL_TEST, &hpiProtocolTestData, sizeof(hpiProtocolTestData), &hpiStat, sizeof(hpiStat)))
	{
		ProtocolTestResultStringGrid->Cells[0][0] = "TotalSendWord";
		ProtocolTestResultStringGrid->Cells[0][1] = "TotalErrorWord";
		ProtocolTestResultStringGrid->Cells[0][2] = "ActualTransferDataWord";
		ProtocolTestResultStringGrid->Cells[0][3] = "TotalSendCount";
		ProtocolTestResultStringGrid->Cells[0][4] = "AckPacketCount";
		ProtocolTestResultStringGrid->Cells[0][5] = "ErrPacketCount";
		ProtocolTestResultStringGrid->Cells[0][6] = "RetryCount";
		ProtocolTestResultStringGrid->Cells[0][7] = "ReadErrorCount";
		ProtocolTestResultStringGrid->Cells[0][8] = "LazeInterruptCount";
		ProtocolTestResultStringGrid->Cells[0][9] = "CritErrorCount";
		ProtocolTestResultStringGrid->Cells[0][10] = "RetryExceededCount";
		ProtocolTestResultStringGrid->Cells[0][11] = "SendTime";
		ProtocolTestResultStringGrid->Cells[0][12] = "IntStateRetryCount";
		ProtocolTestResultStringGrid->Cells[0][13] = "CPBErrorPacketCount";
		ProtocolTestResultStringGrid->Cells[0][14] = "CPBTOPacketCount";
		ProtocolTestResultStringGrid->Cells[0][15] = "ChecksumErrorPacketCount";

		ProtocolTestResultStringGrid->Cells[1][0] = IntToStr(hpiStat.TotalSendWord);
		ProtocolTestResultStringGrid->Cells[1][1] = IntToStr(hpiStat.TotalErrorWord);
		ProtocolTestResultStringGrid->Cells[1][2] = IntToStr(hpiStat.ActualTransferDataWord);
		ProtocolTestResultStringGrid->Cells[1][3] = IntToStr(hpiStat.TotalSendCount);
		ProtocolTestResultStringGrid->Cells[1][4] = IntToStr(hpiStat.AckPacketCount);
		ProtocolTestResultStringGrid->Cells[1][5] = IntToStr(hpiStat.ErrPacketCount);
		ProtocolTestResultStringGrid->Cells[1][6] = IntToStr(hpiStat.RetryCount);
		ProtocolTestResultStringGrid->Cells[1][7] = IntToStr(hpiStat.ReadErrorCount);
		ProtocolTestResultStringGrid->Cells[1][8] = IntToStr(hpiStat.LazeInterruptCount);
		ProtocolTestResultStringGrid->Cells[1][9] = IntToStr(hpiStat.CritErrorCount);
		ProtocolTestResultStringGrid->Cells[1][10] = IntToStr(hpiStat.RetryExceededCount);
		ProtocolTestResultStringGrid->Cells[1][11] = IntToStr(hpiStat.SendTime);
		ProtocolTestResultStringGrid->Cells[1][12] = IntToStr(hpiStat.IntStateRetryCount);
		ProtocolTestResultStringGrid->Cells[1][13] = IntToStr(hpiStat.CPBErrorPacketCount);
		ProtocolTestResultStringGrid->Cells[1][14] = IntToStr(hpiStat.CPBTOPacketCount);
		ProtocolTestResultStringGrid->Cells[1][15] = IntToStr(hpiStat.ChecksumErrorPacketCount);

	}
}
//---------------------------------------------------------------------------

void __fastcall THPITestForm::ClearTestResultButtonClick(TObject *Sender)
{
	struct
	{
		unsigned int func;
		unsigned int cpbIndex;
	} hpiProtocolTestData;
	hpiProtocolTestData.func = 3;
	hpiProtocolTestData.cpbIndex = StrToInt(CPBIndexEdit->Text) - 1;
	Comm_Request(COMM_SPB + SPBIndex, CMD_HPI_PROTOCOL_TEST, &hpiProtocolTestData, sizeof(hpiProtocolTestData));
}
//---------------------------------------------------------------------------

void __fastcall THPITestForm::StartSpeedButton2Click(TObject *Sender)
{
	try
	{
		int testKind = 1;
		if (!Comm_Request(COMM_SPB + SPBIndex, CMD_HPI_TEST, &testKind, sizeof(int)))
		{
			//ShowMessageW(SPBConnection[SPBIndex].GetLastErrorMessage());
        }
    }
    catch (...)
    {

	}
}
//---------------------------------------------------------------------------


