//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#include <inifiles.hpp>
#pragma hdrstop

#include "IOSetting_Form.h"
#include "Environment.h"
#include "InputText_Dialog.h"
#include "Message_Form.h"
#include "Keyboard_Form.h"
#include "MultiLanguage.h"

#define max(x, y) (x > y ? x : y)
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntGrids"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TIOSettingForm *IOSettingForm;
//---------------------------------------------------------------------------
__fastcall TIOSettingForm::TIOSettingForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  Label5->Caption = IOSETTINGFORM_LABEL_CAPTION_01;
	MachineInfoExists = false;
	PortMapEditingMode = false;
	ActivePortMap = -1;
}
//---------------------------------------------------------------------------
void __fastcall TIOSettingForm::PortReadTimerTimer(TObject *Sender)
{
	unsigned short port_val[23];   //18 => 19
    
	AnsiString errorMsg;
	unsigned char PIPValue[MAX_PORT_COUNT];
	unsigned char POPValue[MAX_PORT_COUNT];
    WideString TempString;

	if (!Comm_Request(COMM_HCB, CMD_PORT_READ, NULL, 0, port_val, 23 * sizeof(unsigned short)))    //18 => 19
	{
		PortReadTimer->Enabled = false;
	}
	else
	{
		for (int portIndex = 0; portIndex < MAX_PORT_COUNT; portIndex++)
		{
			unsigned int portValIndex = PIPMap[portIndex] / 16;
			unsigned int portValMask = 0x00000001u << (PIPMap[portIndex] % 16);
			if (port_val[portValIndex] & portValMask)
			{
				PortInStringGrid->Cells[portIndex % 16 + 1][portIndex / 16 * 2 + 1] = "1";
				PIPValue[portIndex] = 1;
			}
			else
			{
				PortInStringGrid->Cells[portIndex % 16 + 1][portIndex / 16 * 2 + 1] = "0";
				PIPValue[portIndex] = 0;
			}
		}
    	TempString = "\\";
		if (IPReadPingPongLabel->Caption == TempString)
		{
			IPReadPingPongLabel->Caption = "/";
		}
		else
		{
			IPReadPingPongLabel->Caption = "\\";
		}

		for (int portIndex = 0; portIndex < MAX_PORT_COUNT; portIndex++)
		{
			unsigned int portValIndex = POPMap[portIndex] / 16 + 6;
			unsigned int portValMask = 0x00000001u << (POPMap[portIndex] % 16);
			if (port_val[portValIndex] & portValMask)
			{
				PortOutStringGrid->Cells[portIndex % 16 + 1][portIndex / 16 * 2 + 1] = "1";
				POPValue[portIndex] = 1;
			}
			else
			{
				PortOutStringGrid->Cells[portIndex % 16 + 1][portIndex / 16 * 2 + 1] = "0";
				POPValue[portIndex] = 0;
			}
		}

		for (int encoderIndex = 0; encoderIndex < SYSTEM_ENCODER_COUNT; encoderIndex++)
		{
			EncoderStringGrid->Cells[1][encoderIndex + 1] = IntToStr(port_val[encoderIndex + 12]);
		}

    	TempString = "\\";
		if (OPReadPingPongLabel->Caption == TempString)
		{
			OPReadPingPongLabel->Caption = "/";
		}
		else
		{
			OPReadPingPongLabel->Caption = "\\";
		}


		for (int portIndex = 0; portIndex < MAX_PORT_COUNT; portIndex++)
		{
			if (InputPortMapData[portIndex].PortMapValue < MAX_PORT_COUNT)
			{
				if (PIPValue[InputPortMapData[portIndex].PortMapValue])
				{
					InputPortMappingStringGrid->Cells[4][portIndex + 1] = "ON";
				}
				else
				{
					InputPortMappingStringGrid->Cells[4][portIndex + 1] = "OFF";
				}
			}
			else if (InputPortMapData[portIndex].PortMapValue == PORT_NOT_CONNECTED)
			{
				InputPortMappingStringGrid->Cells[4][portIndex + 1] = "NC";
			}
			else
			{
				InputPortMappingStringGrid->Cells[4][portIndex + 1] = "N/A";
			}
		}

		for (int portIndex = 0; portIndex < MAX_PORT_COUNT; portIndex++)
		{
			if (OutputPortMapData[portIndex].PortMapValue < MAX_PORT_COUNT)
			{
				if (POPValue[OutputPortMapData[portIndex].PortMapValue])
				{
					OutputPortMappingStringGrid->Cells[4][portIndex + 1] = "ON";
				}
				else
				{
					OutputPortMappingStringGrid->Cells[4][portIndex + 1] = "OFF";
				}
			}
			else if (OutputPortMapData[portIndex].PortMapValue == PORT_NOT_CONNECTED)
			{
				OutputPortMappingStringGrid->Cells[4][portIndex + 1] = "NC";
			}
			else
			{
				OutputPortMappingStringGrid->Cells[4][portIndex + 1] = "N/A";
			}
		}
/*
		for (int portIndex = 0; portIndex < 3; portIndex++)
		{
			unsigned short portData = port_val[portIndex];
			for (int i = 0; i < 16; i++)
			{
				PortInStringGrid->Cells[i + 1][portIndex * 2 + 1] = (portData & 1) ? "1" : "0";
				portData >>= 1;
			}
	    }
		for (int portIndex = 0; portIndex < 4; portIndex++)
		{
			unsigned short portData = port_val[portIndex + 3];
			for (int i = 0; i < 16; i++)
			{
				PortOutStringGrid->Cells[i + 1][portIndex * 2 + 1] = (portData & 1) ? "1" : "0";
	            portData >>= 1;
		    }
		}
*/
		// encoder value
	}
}
//---------------------------------------------------------------------------
void __fastcall TIOSettingForm::PortReadStartButtonClick(TObject *Sender)
{
	PortReadTimer->Enabled = true;
}
//---------------------------------------------------------------------------
void __fastcall TIOSettingForm::PortReadStopButtonClick(TObject *Sender)
{
	PortReadTimer->Enabled = false;	
}
//---------------------------------------------------------------------------
void __fastcall TIOSettingForm::PortOnButtonClick(TObject *Sender)
{
	try
	{
		int physicalOPIndex = StrToInt(PortIndexEdit->Text);
		Machine.PortTest(physicalOPIndex, true);
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------
void __fastcall TIOSettingForm::PortOffButtonClick(TObject *Sender)
{
	try
	{
		int physicalOPIndex = StrToInt(PortIndexEdit->Text);
		Machine.PortTest(physicalOPIndex, false);
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------


void __fastcall TIOSettingForm::FormCreate(TObject *Sender)
{
// make physical to system port map (depends on PIO board)
	for (int portIndex = 0; portIndex < MAX_PORT_COUNT; portIndex++) // IP0~IP63 are mapped to SIP0~SIP63
	{
		PIPMap[portIndex] = portIndex;
	}
	for (int portIndex = 0; portIndex < MAX_PORT_COUNT; portIndex++) // OP0~OP63 are mapped to SOP0~SOP63
	{
		POPMap[portIndex] = portIndex;
	}

	for (int portIndex = 0; portIndex < MAX_PORT_COUNT; portIndex++)  //64 => PHYSICAL_OUTPUT_PORT_COUNT
	{
		PortOutStringGrid->Cells[portIndex % 16 + 1][portIndex / 16 * 2] = "OP" + IntToStr(portIndex);
	}
	for (int portIndex = 0; portIndex < MAX_PORT_COUNT; portIndex++)   //64 => PHYSICAL_INPUT_PORT_COUNT
	{
		PortInStringGrid->Cells[portIndex % 16 + 1][portIndex / 16 * 2] = "IP" + IntToStr(portIndex);
	}

	EncoderStringGrid->Cells[1][0] = "Encoder";
	for (int encoderIndex = 0; encoderIndex < SYSTEM_ENCODER_COUNT; encoderIndex++)
	{
		EncoderStringGrid->Cells[0][encoderIndex + 1] = IntToStr(encoderIndex);
	}
	ReadPortMapData();
	RefreshPortMapStringGrid();
}
//---------------------------------------------------------------------------
void __fastcall TIOSettingForm::ReadPortMapData(void)
{
	AnsiString portMapFileName = ProgramPath.Env + "\\MachineInfor.ini";
	try
	{
	if (!FileExists(portMapFileName))
	{
		MachineInfoExists = false;
		PortMapEditSpeedButton->Enabled = false;
		throw Exception("Map File Not Exists");
	}

	TIniFile *iniFile = new TIniFile(ProgramPath.Env + "\\MachineInfor.ini");
	if (iniFile)
	{
		MachineRevisionLabel->Caption = iniFile->ReadString("Machine Information", "Machine Name", "Unknown");
		for (int outputPortIndex = 0; outputPortIndex < MAX_PORT_COUNT; outputPortIndex++)
		{
			OutputPortMapData[outputPortIndex].PortMapValue = iniFile->ReadInteger("Port Mapping", "Output " + IntToStr(outputPortIndex) + " RP", PORT_NOT_EXIST);
			if (OutputPortMapData[outputPortIndex].PortMapValue != PORT_NOT_EXIST)
			{
				OutputPortMapData[outputPortIndex].PortName = iniFile->ReadString("Port Mapping", "Output " + IntToStr(outputPortIndex) + " Name", "OP_NONAME");
				OutputPortMapData[outputPortIndex].Description = iniFile->ReadString("Port Mapping", "Output " + IntToStr(outputPortIndex) + " Desc", "");
			}
			else
			{
				//OutputPortMapData[outputPortIndex].PortMapValue  = outputPortIndex;
				OutputPortMapData[outputPortIndex].PortName = "OP_RESERVED";
				OutputPortMapData[outputPortIndex].Description = "reserved";
			}
		}

		for (int inputPortIndex = 0; inputPortIndex < MAX_PORT_COUNT; inputPortIndex++)
		{
			InputPortMapData[inputPortIndex].PortMapValue = iniFile->ReadInteger("Port Mapping", "Input " + IntToStr(inputPortIndex) + " RP", PORT_NOT_EXIST);
			if (InputPortMapData[inputPortIndex].PortMapValue != PORT_NOT_EXIST)
			{
				InputPortMapData[inputPortIndex].PortName = iniFile->ReadString("Port Mapping", "Input " + IntToStr(inputPortIndex) + " Name", "IP_NONAME");
				InputPortMapData[inputPortIndex].Description = iniFile->ReadString("Port Mapping", "Input " + IntToStr(inputPortIndex) + " Desc", "");
			}
			else
			{
				//InputPortMapData[inputPortIndex].PortMapValue = inputPortIndex;
				InputPortMapData[inputPortIndex].PortName = "IP_RESERVED";
				InputPortMapData[inputPortIndex].Description = "reserved";

			}
		}
		delete iniFile;
		MachineInfoExists = true;
		PortMapEditSpeedButton->Enabled = true;
	}
	else
	{
		MachineInfoExists = false;
		PortMapEditSpeedButton->Enabled = false;
		throw Exception("Map File Can not Load");
	}
	}
	catch (Exception &ec)
	{
		MachineRevisionLabel->Caption = "UNKNOWN";
		for (int outputPortIndex = 0; outputPortIndex < MAX_PORT_COUNT; outputPortIndex++)
		{
			OutputPortMapData[outputPortIndex].PortMapValue = PORT_NOT_EXIST;
			OutputPortMapData[outputPortIndex].PortName = "NA";
			OutputPortMapData[outputPortIndex].Description = "NA";
		}
		for (int inputPortIndex = 0; inputPortIndex < MAX_PORT_COUNT; inputPortIndex++)
		{
			InputPortMapData[inputPortIndex].PortMapValue = PORT_NOT_EXIST;
			InputPortMapData[inputPortIndex].PortName = "NA";
			InputPortMapData[inputPortIndex].Description = "NA";
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TIOSettingForm::WritePortMapData(void)
{
	AnsiString portMapFileName = ProgramPath.Env + "\\MachineInfor.ini";
	try
	{
	if (!FileExists(portMapFileName))
	{
		throw Exception("Map File Not Exists");
	}

	TIniFile *iniFile = new TIniFile(ProgramPath.Env + "\\MachineInfor.ini");
	if (iniFile)
	{
		for (int outputPortIndex = 0; outputPortIndex < MAX_PORT_COUNT; outputPortIndex++)
		{
			iniFile->WriteInteger("Port Mapping", "Output " + IntToStr(outputPortIndex) + " RP", OutputPortMapData[outputPortIndex].PortMapValue);
		}

		for (int inputPortIndex = 0; inputPortIndex < MAX_PORT_COUNT; inputPortIndex++)
		{
			iniFile->WriteInteger("Port Mapping", "Input " + IntToStr(inputPortIndex) + " RP", InputPortMapData[inputPortIndex].PortMapValue);
		}
		delete iniFile;
	}
	}
	catch (Exception &ec)
	{
	}
}
//---------------------------------------------------------------------------
void __fastcall TIOSettingForm::RefreshPortMapStringGrid(void)
{
	OutputPortMappingStringGrid->RowCount = MAX_PORT_COUNT + 1;
	OutputPortMappingStringGrid->Cells[0][0] = "Virtual Port";
	OutputPortMappingStringGrid->Cells[1][0] = "Name";
	OutputPortMappingStringGrid->Cells[2][0] = "Real Port";
	OutputPortMappingStringGrid->Cells[3][0] = "Description";
	OutputPortMappingStringGrid->Cells[4][0] = "Status";
	OutputPortMappingStringGrid->ColWidths[1] = 190;
	OutputPortMappingStringGrid->ColWidths[3] = 230;
	OutputPortMappingStringGrid->ColWidths[4] = 40;

	for (int outputPortIndex = 0; outputPortIndex < MAX_PORT_COUNT; outputPortIndex++)
	{
		OutputPortMappingStringGrid->Cells[0][outputPortIndex + 1] = "VOP" + IntToStr(outputPortIndex);
		OutputPortMappingStringGrid->Cells[1][outputPortIndex + 1] = OutputPortMapData[outputPortIndex].PortName;
		OutputPortMappingStringGrid->Cells[3][outputPortIndex + 1] = OutputPortMapData[outputPortIndex].Description;
		if (OutputPortMapData[outputPortIndex].PortMapValue < MAX_PORT_COUNT)
		{
			OutputPortMappingStringGrid->Cells[2][outputPortIndex + 1] = "OP" + IntToStr(OutputPortMapData[outputPortIndex].PortMapValue);
		}
		else if (OutputPortMapData[outputPortIndex].PortMapValue == PORT_NOT_CONNECTED)
		{
			OutputPortMappingStringGrid->Cells[2][outputPortIndex + 1] = "NC";
		}
		else
		{
			OutputPortMappingStringGrid->Cells[2][outputPortIndex + 1] = "Not Exist";
		}
	}

	InputPortMappingStringGrid->RowCount = MAX_PORT_COUNT + 1;
	InputPortMappingStringGrid->Cells[0][0] = "Virtual Port";
	InputPortMappingStringGrid->Cells[1][0] = "Name";
	InputPortMappingStringGrid->Cells[2][0] = "Real Port";
	InputPortMappingStringGrid->Cells[3][0] = "Description";
	InputPortMappingStringGrid->Cells[4][0] = "Status";
	InputPortMappingStringGrid->ColWidths[1] = 190;
	InputPortMappingStringGrid->ColWidths[3] = 230;
	InputPortMappingStringGrid->ColWidths[4] = 40;

	for (int inputPortIndex = 0; inputPortIndex < MAX_PORT_COUNT; inputPortIndex++)
	{
		InputPortMappingStringGrid->Cells[0][inputPortIndex + 1] = "VIP" + IntToStr(inputPortIndex);
		InputPortMappingStringGrid->Cells[1][inputPortIndex + 1] = InputPortMapData[inputPortIndex].PortName;
		InputPortMappingStringGrid->Cells[3][inputPortIndex + 1] = InputPortMapData[inputPortIndex].Description;
		if (InputPortMapData[inputPortIndex].PortMapValue < MAX_PORT_COUNT)
		{
			InputPortMappingStringGrid->Cells[2][inputPortIndex + 1] = "IP" + IntToStr(InputPortMapData[inputPortIndex].PortMapValue);
		}
		else if (InputPortMapData[inputPortIndex].PortMapValue == PORT_NOT_CONNECTED)
		{
			InputPortMappingStringGrid->Cells[2][inputPortIndex + 1] = "NC";
		}
		else
		{
			InputPortMappingStringGrid->Cells[2][inputPortIndex + 1] = "Not Exist";
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TIOSettingForm::PortMapEditSpeedButtonClick(
	  TObject *Sender)
{
	if (PortMapEditSpeedButton->Down)
	{
		TInputTextDialog *inputTextDialog = new TInputTextDialog(this);
		if (inputTextDialog->ExecutePassword())
		{
			AnsiString passwordStr = inputTextDialog->InputText;
			if (passwordStr == "999999")
			{
				PortMapEditingMode = true;
				PortMapChangeSpeedButton->Enabled = true;
				PortDisconnectSpeedButton->Enabled = true;
				PortMapSetupSpeedButton->Enabled = true;
			}
			else
			{
				PortMapEditSpeedButton->Down = false;
				ShowMessageFA(LOGINFORM_MSG_01);
			}
		}
		else
		{
			PortMapEditSpeedButton->Down = false;
		}
		delete inputTextDialog;
	}
	else
	{
		PortMapEditingMode = false;
		PortMapChangeSpeedButton->Enabled = false;
		PortDisconnectSpeedButton->Enabled = false;
		PortMapSetupSpeedButton->Enabled = false;
	}
}
//---------------------------------------------------------------------------

void __fastcall TIOSettingForm::PortMapChangeSpeedButtonClick(
      TObject *Sender)
{
	TInputTextDialog *inputTextDialog = new TInputTextDialog(this);
	inputTextDialog->Message = IOSETTINGFORM_MSG_05;
	if (inputTextDialog->Execute())
	{
		int newPhysicalPortIndex = StrToInt(inputTextDialog->InputText);
		if (ActivePortMap == 0) // output
		{
			int oldVOPIndex = OutputPortMappingStringGrid->Row - 1;
			if (oldVOPIndex < 0 || oldVOPIndex >= MAX_PORT_COUNT) return;
			if (newPhysicalPortIndex < MAX_PORT_COUNT)
			{		// check port conflict
				for (int portIndex = 0; portIndex < MAX_PORT_COUNT; portIndex++)
				{
					if (oldVOPIndex == portIndex) continue;
					if (OutputPortMapData[portIndex].PortMapValue == newPhysicalPortIndex)
					{
            WCHAR TempString[100];
            wsprintfW(TempString, IOSETTINGFORM_MSG_07, portIndex);
						ShowMessageFA(TempString);
						break;
					}
				}
			}
			OutputPortMapData[oldVOPIndex].PortMapValue = newPhysicalPortIndex;
		}
		else if (ActivePortMap == 1) // input
		{
			int oldVIPIndex = InputPortMappingStringGrid->Row - 1;
			if (oldVIPIndex < 0 || oldVIPIndex >= MAX_PORT_COUNT) return;
			if (newPhysicalPortIndex < MAX_PORT_COUNT)
			{
				for (int portIndex = 0; portIndex < MAX_PORT_COUNT; portIndex++)
				{
					if (oldVIPIndex == portIndex) continue;
					if (InputPortMapData[portIndex].PortMapValue == newPhysicalPortIndex)
					{
            WCHAR TempString[100];
            wsprintfW(TempString, IOSETTINGFORM_MSG_06, portIndex);
						ShowMessageFA(TempString);
						break;
					}
				}
			}
			InputPortMapData[oldVIPIndex].PortMapValue = newPhysicalPortIndex;
		}
		RefreshPortMapStringGrid();
	}
}
//---------------------------------------------------------------------------

void __fastcall TIOSettingForm::OutputPortMappingStringGridClick(
	  TObject *Sender)
{
	ActivePortMap = 0;		// output
}
//---------------------------------------------------------------------------

void __fastcall TIOSettingForm::InputPortMappingStringGridClick(
	  TObject *Sender)
{
	ActivePortMap = 1;		// input
}
//---------------------------------------------------------------------------

void __fastcall TIOSettingForm::PortMapSetupSpeedButtonClick(
      TObject *Sender)
{
	struct
	{
		unsigned char InputPortMap[MAX_PORT_COUNT];
		unsigned char OutputPortMap[MAX_PORT_COUNT];
	} PortMapData;

	for (int inputPortIndex = 0; inputPortIndex < MAX_PORT_COUNT; inputPortIndex++)
	{
		PortMapData.InputPortMap[inputPortIndex] = InputPortMapData[inputPortIndex].PortMapValue;
	}
	for (int outputPortIndex = 0; outputPortIndex < MAX_PORT_COUNT; outputPortIndex++)
	{
		PortMapData.OutputPortMap[outputPortIndex] = OutputPortMapData[outputPortIndex].PortMapValue;
	}
//	memcpy(PortMapData.InputPortMap, InputPortMap, MAX_VIP_COUNT * sizeof(unsigned char));
//	memcpy(PortMapData.OutputPortMap, OutputPortMap, MAX_VOP_COUNT * sizeof(unsigned char));

	if (Comm_Request(COMM_HCB, CMD_PORT_SETUP, &PortMapData, sizeof(PortMapData)))
	{
		ShowMessageFA(IOSETTINGFORM_MSG_03);
	}
	WritePortMapData();
}
//---------------------------------------------------------------------------

void __fastcall TIOSettingForm::NumEditClick(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
    if (KeyboardForm->ShowKeypad() == mrOk)
    {
		theEdit->Text = KeyboardForm->Text;
    }
}
//---------------------------------------------------------------------------


void __fastcall TIOSettingForm::PortDisconnectSpeedButtonClick(
	  TObject *Sender)
{
	if (ActivePortMap == 0) // output
	{
		int oldVOPIndex = OutputPortMappingStringGrid->Row - 1;
		if (oldVOPIndex < 0 || oldVOPIndex >= MAX_PORT_COUNT) return;
		OutputPortMapData[oldVOPIndex].PortMapValue = PORT_NOT_CONNECTED;
	}
	else if (ActivePortMap == 1) // input
	{
		int oldVIPIndex = InputPortMappingStringGrid->Row - 1;
		if (oldVIPIndex < 0 || oldVIPIndex >= MAX_PORT_COUNT) return;
		OutputPortMapData[oldVIPIndex].PortMapValue = PORT_NOT_CONNECTED;
	}

	RefreshPortMapStringGrid();
}
//---------------------------------------------------------------------------

void __fastcall TIOSettingForm::AOWriteButtonClick(TObject *Sender)
{
	TTntButton *theButton = (TTntButton *) Sender;
	int aoIndex = theButton->Tag;
	int aoValue = 0;
	try
	{
		switch (aoIndex)
		{
			case 0:
				aoValue = StrToInt(AO1Edit->Text);
				break;
			case 1:
				aoValue = StrToInt(AO2Edit->Text);
				break;
			case 2:
				aoValue = StrToInt(AO3Edit->Text);
				break;
			case 3:
				aoValue = StrToInt(AO4Edit->Text);
				break;
		}

		struct
		{
			unsigned short AOIndex;
			unsigned short AOValue;
		} AOWriteData;

		AOWriteData.AOIndex = aoIndex;
		AOWriteData.AOValue = aoValue;

		Comm_Request(COMM_HCB, CMD_PORT_AO_WRITE, NULL, 0, &AOWriteData, sizeof(AOWriteData));
	}
	catch (Exception &ec)
	{
		ShowMessageFA(ec.Message);
	}
}
//---------------------------------------------------------------------------
void __fastcall TIOSettingForm::PortBlinkStartButtonClick(TObject *Sender)
{
	TOPTestData opTestData;

	int opIndex = StrToInt(PortIndexEdit->Text);
	opTestData.TestCount = 1;
	opTestData.OPList[0] = opIndex;
	opTestData.IsPhysicalPort[0] = 1;
	opTestData.DelayIntervalList[0] = 0;
	opTestData.OnIntervalList[0] = StrToInt(BlinkOnEdit->Text);
	opTestData.OffIntervalList[0] = StrToInt(BlinkOffEdit->Text);
	Machine.PortTest_Blink(&opTestData);
}
//---------------------------------------------------------------------------
void __fastcall TIOSettingForm::PortBlinkStopButtonClick(TObject *Sender)
{
	TOPTestData opTestData;

	opTestData.TestCount = 0;
	Machine.PortTest_Blink(&opTestData);
}
//---------------------------------------------------------------------------

