//---------------------------------------------------------------------------

#ifndef IOSetting_FormH
#define IOSetting_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Grids.hpp>
#include <ExtCtrls.hpp>
#include <Buttons.hpp>

#include "io_port.h"
#include "TntButtons.hpp"
#include "TntGrids.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"

#define PORT_NOT_CONNECTED				0xFE
#define PORT_NOT_EXIST					0xFF

#define SYSTEM_ENCODER_COUNT			10
//---------------------------------------------------------------------------
typedef struct
{
	unsigned char PortMapValue;
	AnsiString PortName;
	AnsiString Description;
} TPortMapInfoData;
//---------------------------------------------------------------------------
class TIOSettingForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntGroupBox *GroupBox4;
	TTntStringGrid *PortInStringGrid;
	TTntGroupBox *GroupBox5;
	TTntStringGrid *PortOutStringGrid;
	TTimer *PortReadTimer;
	TTntButton *PortReadStartButton;
	TTntButton *PortReadStopButton;
    TTntGroupBox *GroupBox1;
    TTntLabel *Label1;
    TTntEdit *PortIndexEdit;
    TTntButton *PortOnButton;
    TTntButton *PortOffButton;
    TTntButton *PortBlinkStartButton;
    TTntButton *PortBlinkStopButton;
    TTntLabel *Label2;
    TTntLabel *Label3;
    TTntEdit *BlinkOnEdit;
    TTntLabel *Label4;
    TTntEdit *BlinkOffEdit;
    TTntGroupBox *GroupBox2;
    TTntGroupBox *GroupBox3;
    TTntLabel *Label5;
	TTntStringGrid *OutputPortMappingStringGrid;
	TTntSpeedButton *PortMapEditSpeedButton;
	TTntSpeedButton *PortMapChangeSpeedButton;
	TTntLabel *Label6;
	TTntLabel *MachineRevisionLabel;
	TTntLabel *OPReadPingPongLabel;
	TTntSpeedButton *PortMapSetupSpeedButton;
	TTntStringGrid *InputPortMappingStringGrid;
	TTntLabel *IPReadPingPongLabel;
	TTntSpeedButton *PortDisconnectSpeedButton;
	TTntLabel *Label7;
	TTntButton *CloseButton;
	TTntStringGrid *EncoderStringGrid;
	TTntGroupBox *GroupBox6;
	TTntLabel *Label8;
	TTntLabel *Label9;
	TTntLabel *Label10;
	TTntLabel *Label11;
	TTntEdit *AO1Edit;
	TTntButton *AO1WriteButton;
	TTntEdit *AO2Edit;
	TTntEdit *AO3Edit;
	TTntEdit *AO4Edit;
	TTntButton *AO2WriteButton;
	TTntButton *AO3WriteButton;
	TTntButton *AO4WriteButton;
	void __fastcall PortReadTimerTimer(TObject *Sender);
	void __fastcall PortReadStartButtonClick(TObject *Sender);
	void __fastcall PortReadStopButtonClick(TObject *Sender);
    void __fastcall PortOnButtonClick(TObject *Sender);
    void __fastcall PortOffButtonClick(TObject *Sender);
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall PortMapEditSpeedButtonClick(TObject *Sender);
	void __fastcall PortMapChangeSpeedButtonClick(TObject *Sender);
	void __fastcall OutputPortMappingStringGridClick(TObject *Sender);
	void __fastcall InputPortMappingStringGridClick(TObject *Sender);
	void __fastcall PortMapSetupSpeedButtonClick(TObject *Sender);
	void __fastcall NumEditClick(TObject *Sender);
	void __fastcall PortDisconnectSpeedButtonClick(TObject *Sender);
	void __fastcall AOWriteButtonClick(TObject *Sender);
	void __fastcall PortBlinkStartButtonClick(TObject *Sender);
	void __fastcall PortBlinkStopButtonClick(TObject *Sender);
private:	// User declarations
	bool MachineInfoExists;
	bool PortMapEditingMode;
	int ActivePortMap;

	unsigned char PIPMap[MAX_PORT_COUNT];
	unsigned char POPMap[MAX_PORT_COUNT];
	TPortMapInfoData OutputPortMapData[MAX_PORT_COUNT];
	TPortMapInfoData InputPortMapData[MAX_PORT_COUNT];

	void __fastcall ReadPortMapData(void);
	void __fastcall WritePortMapData(void);
	void __fastcall RefreshPortMapStringGrid(void);
public:		// User declarations
	__fastcall TIOSettingForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TIOSettingForm *IOSettingForm;
//---------------------------------------------------------------------------
#endif
