//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "InputText_Dialog.h"
#include "Keyboard_Form.h"
#include "MultiLanguage.h"
#include "Environment.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"


#define TEXT_BLANK				50
#define MIN_FORM_SIZE			360
#define BUTTON_WIDTH			92
#define BUTTON_GAP				8

TInputTextDialog *InputTextDialog;
//---------------------------------------------------------------------------
__fastcall TInputTextDialog::TInputTextDialog(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

    PasswordMode = false;
    CancelBitBtn->Caption = INPUTTEXTDIALOG_BITBTN_CAPTION_01;
    OkBitBtn->Caption = INPUTTEXTDIALOG_BITBTN_CAPTION_02;
}
//---------------------------------------------------------------------------
void __fastcall TInputTextDialog::SetMessage(WideString message)
{
	FMessage = message;
    MessageLabel->Caption = FMessage;
}
//---------------------------------------------------------------------------
WideString __fastcall TInputTextDialog::GetInputText(void)
{
	return TextEdit->Text;
}
//---------------------------------------------------------------------------
bool __fastcall TInputTextDialog::Execute(void)
{
    int formWidth = MessageLabel->Canvas->TextWidth(FMessage) + 2 * TEXT_BLANK;
	if (formWidth < MIN_FORM_SIZE) formWidth = MIN_FORM_SIZE;

    this->Width = formWidth;
    TextEdit->Width = formWidth - 100;
    TextEdit->Left = 50;
    MessageLabel->Left = 50;

    int buttonTotalWidth = OkBitBtn->Width + CancelBitBtn->Width + BUTTON_GAP;
    int buttonLeft = (formWidth - buttonTotalWidth) / 2;
    OkBitBtn->Left = buttonLeft;
    buttonLeft += OkBitBtn->Width + BUTTON_GAP;
    CancelBitBtn->Left = buttonLeft;
	if(this->ShowModal() == mrOk)
    {
		return true;
    }
    else
    {
    	return false;
    }
}
//---------------------------------------------------------------------------
bool __fastcall TInputTextDialog::ExecutePassword(AnsiString message)
{
	if (message == "")
	{
		SetMessage(INPUTTEXTDIALOG_MSG_01);
	}
	else
	{
		SetMessage(message);
	}
    PasswordMode = true;
    TextEdit->PasswordChar = '*';
    return Execute();
}
//---------------------------------------------------------------------------
void __fastcall TInputTextDialog::TextEditClick(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
    if (PasswordMode)
    {
        if (KeyboardForm->ShowPasswordKeyboard() == mrOk)
        {
    		theEdit->Text = KeyboardForm->Text;
        }
    }
    else
    {
        if (KeyboardForm->ShowKeyboard() == mrOk)
        {
    		theEdit->Text = KeyboardForm->Text;
        }
    }
}
//---------------------------------------------------------------------------
