//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "InspectionRecover_Form.h"
#include "Message_Form.h"
#include "MultiLanguage.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TInspectionRecoverForm *InspectionRecoverForm;
//---------------------------------------------------------------------------
__fastcall TInspectionRecoverForm::TInspectionRecoverForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  GetDefaultString();
}
//---------------------------------------------------------------------------
void __fastcall TInspectionRecoverForm::GetDefaultString()
{
  CancelButton->Caption = INSPECTIONRECOVERFORM_BUTTON_CAPTION_01;
  OkButton->Caption = INSPECTIONRECOVERFORM_BUTTON_CAPTION_02;
  this->Caption = INSPECTIONRECOVERFORM_FORM_CAPTION_01;
  GroupBox2->Caption = INSPECTIONRECOVERFORM_GROUPBOX_CAPTION_01;
  GroupBox3->Caption = INSPECTIONRECOVERFORM_GROUPBOX_CAPTION_02;
  GroupBox1->Caption = INSPECTIONRECOVERFORM_GROUPBOX_CAPTION_03;
  Label5->Caption = INSPECTIONRECOVERFORM_LABEL_CAPTION_01;
  Label14->Caption = INSPECTIONRECOVERFORM_LABEL_CAPTION_02;
  Label13->Caption = INSPECTIONRECOVERFORM_LABEL_CAPTION_03;
  Label12->Caption = INSPECTIONRECOVERFORM_LABEL_CAPTION_04;
  Label19->Caption = INSPECTIONRECOVERFORM_LABEL_CAPTION_05;
  Label1->Caption = INSPECTIONRECOVERFORM_LABEL_CAPTION_06;
  Label2->Caption = INSPECTIONRECOVERFORM_LABEL_CAPTION_07;
  Label11->Caption = INSPECTIONRECOVERFORM_LABEL_CAPTION_08;
  Label3->Caption = INSPECTIONRECOVERFORM_LABEL_CAPTION_09;
}
//---------------------------------------------------------------------------
void __fastcall TInspectionRecoverForm::SetProcessingReport(AnsiString userName, double inspectionTime,
	AnsiString recentProductName, AnsiString recentLot, TTerminationInfo *terminationInfo)
{
/*
	UserNameLabel->Caption = "";
	InspectionTimeLabel->Caption = Now().DateTimeString();
	ProductNameLabel->Caption = "1";
	LotNameLabel->Caption = "Test";

	SavedTotalTabletCountLabel->Caption = IntToStr(10000);
	SavedGoodTabletCountLabel->Caption = IntToStr(9000);
	SavedDefectTabletCountLabel->Caption = IntToStr(900);
	SavedUnInsTabletCountLabel->Caption = IntToStr(100);

	HCBTotalTabletCountLabel->Caption = IntToStr(15000);
	HCBGoodTabletCountLabel->Caption = IntToStr(13000);
	HCBDefectTabletCountLabel->Caption = IntToStr(1500);
	HCBUnInsTabletCountLabel->Caption = IntToStr(500);
*/
	RecentUserName = userName;
	RecentInspectionTime.Val = inspectionTime;
	RecentProductName = recentProductName;
	RecentLot = recentLot;
	AnsiString resultDir = ProgramPath.Product + "\\" + recentProductName + "\\Result";
	AnsiString resultFileName = resultDir + "\\" + recentLot + ".dat";

	if (FileExists(resultFileName))
	{
    Read_InspectionReportData(resultFileName,Report);
	}
  else
  {
    memset(&Report,0,sizeof(NFA_INSPECTION_REPORT_STRUCT));
  }
  
	memcpy(&HCBTerminationInfo, terminationInfo, sizeof(TTerminationInfo));

	UserNameLabel->Caption = RecentUserName;
	InspectionTimeLabel->Caption = RecentInspectionTime.DateTimeString();
	ProductNameLabel->Caption = RecentProductName;
	LotNameLabel->Caption = RecentLot;

	SavedTotalTabletCountLabel->Caption = IntToStr(Report.Data.TotalTabletCount);
	SavedGoodTabletCountLabel->Caption = IntToStr(Report.Data.GoodTabletCount);
	SavedDefectTabletCountLabel->Caption = IntToStr(Report.Data.DefectTabletCount);
	SavedUnInsTabletCountLabel->Caption = IntToStr(Report.Data.UnInsTabletCount);

	HCBTotalTabletCountLabel->Caption = IntToStr(HCBTerminationInfo.InspectionInfo.TotalTabletCount);
	HCBGoodTabletCountLabel->Caption = IntToStr(HCBTerminationInfo.InspectionInfo.GoodTabletCount);
	HCBDefectTabletCountLabel->Caption = IntToStr(HCBTerminationInfo.InspectionInfo.DefectTabletCount);
	HCBUnInsTabletCountLabel->Caption = IntToStr(HCBTerminationInfo.InspectionInfo.UnInsTabletCount);
}
//---------------------------------------------------------------------------


void __fastcall TInspectionRecoverForm::OkButtonClick(TObject *Sender)
{
	Report.Data.TotalTabletCount = HCBTerminationInfo.InspectionInfo.TotalTabletCount;
	Report.Data.GoodTabletCount = HCBTerminationInfo.InspectionInfo.GoodTabletCount;
	Report.Data.DefectTabletCount = HCBTerminationInfo.InspectionInfo.DefectTabletCount;
	Report.Data.UnInsTabletCount = HCBTerminationInfo.InspectionInfo.UnInsTabletCount;
	Report.Data.SPBProcessingNCTabletCount = HCBTerminationInfo.InspectionInfo.SPBProcessingNCTabletCount;
	Report.Data.SPBTOTabletCount = HCBTerminationInfo.InspectionInfo.SPBTOTabletCount;
	Report.Data.SPBUnInsTabletCount = HCBTerminationInfo.InspectionInfo.SPBUnInsTabletCount;
	Report.Data.DisappearedTabletCount = HCBTerminationInfo.InspectionInfo.DisappearedTabletCount;
	Report.Data.InsertedTabletCount = HCBTerminationInfo.InspectionInfo.InsertedTabletCount;
	Report.Data.ClosedTabletUninsCount = HCBTerminationInfo.InspectionInfo.ClosedTabletUninsCount;
	Report.Data.ClosedTabletDefectCount = HCBTerminationInfo.InspectionInfo.ClosedTabletDefectCount;
	Report.Data.ClosedTabletCount = HCBTerminationInfo.InspectionInfo.ClosedTabletCount;

	AnsiString resultDir = ProgramPath.Product + "\\" + RecentProductName + "\\Result";
	AnsiString resultFileName = resultDir + "\\" + RecentLot + ".dat";

	Create_Report_Data(Report,resultFileName);

	ShowMessageFA(INSPECTIONRECOVERFORM_MSG_02);
	ModalResult = mrOk;
}
//---------------------------------------------------------------------------

void __fastcall TInspectionRecoverForm::CancelButtonClick(TObject *Sender)
{
	if (MessageDlgFA(INSPECTIONRECOVERFORM_MSG_01, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
	{
		ModalResult = mrCancel;
	}
}
//---------------------------------------------------------------------------
void __fastcall TInspectionRecoverForm::ExecuteRecover(void)
{
	Report.Data.TotalTabletCount = HCBTerminationInfo.InspectionInfo.TotalTabletCount;
	Report.Data.GoodTabletCount = HCBTerminationInfo.InspectionInfo.GoodTabletCount;
	Report.Data.DefectTabletCount = HCBTerminationInfo.InspectionInfo.DefectTabletCount;
	Report.Data.UnInsTabletCount = HCBTerminationInfo.InspectionInfo.UnInsTabletCount;
	Report.Data.SPBProcessingNCTabletCount = HCBTerminationInfo.InspectionInfo.SPBProcessingNCTabletCount;
	Report.Data.SPBTOTabletCount = HCBTerminationInfo.InspectionInfo.SPBTOTabletCount;
	Report.Data.SPBUnInsTabletCount = HCBTerminationInfo.InspectionInfo.SPBUnInsTabletCount;
	Report.Data.DisappearedTabletCount = HCBTerminationInfo.InspectionInfo.DisappearedTabletCount;
	Report.Data.InsertedTabletCount = HCBTerminationInfo.InspectionInfo.InsertedTabletCount;
	Report.Data.ClosedTabletUninsCount = HCBTerminationInfo.InspectionInfo.ClosedTabletUninsCount;
	Report.Data.ClosedTabletDefectCount = HCBTerminationInfo.InspectionInfo.ClosedTabletDefectCount;
	Report.Data.ClosedTabletCount = HCBTerminationInfo.InspectionInfo.ClosedTabletCount;

	AnsiString resultDir = ProgramPath.Product + "\\" + RecentProductName + "\\Result";
	AnsiString resultFileName = resultDir + "\\" + RecentLot + ".dat";

	Create_Report_Data(Report,resultFileName);
}
//---------------------------------------------------------------------------


