//---------------------------------------------------------------------------

#ifndef InspectionReport_FormH
#define InspectionReport_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <ExtCtrls.hpp>
#include <Grids.hpp>
#include <vector.h>

#include "Common_PC.h"
#include <Chart.hpp>
#include <Series.hpp>
#include <TeEngine.hpp>
#include <TeeProcs.hpp>
#include "TntButtons.hpp"
#include "TntExtCtrls.hpp"
#include "TntGrids.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
#include <ComCtrls.hpp>
//---------------------------------------------------------------------------
typedef struct
{
	WideString ProductCode;
	WideString LotName;
    TDateTime InspectionStartTime;
    TDateTime InspectionEndTime;
    int InspectionCount;
    int GoodCount;
	int DefectCount;
	int UnInsCount;
	int ProductionCount;
	double DefectRatio;
	double ProductionDefectRatio;
	AnsiString OperatorName;

	int SPBProcessingNCTabletCount;
	int SPBTOTabletCount;
	int SPBUnInsTabletCount;
	int DisappearedTabletCount;
	int InsertedTabletCount;
	int ClosedTabletDefectCount;
	int ClosedTabletUninsCount;
	int ClosedTabletCount;
	int WrongNumberTabletCount;
	int NumberUndefTabletCount;
	int CaptureNotReadyTabletCount;
	int BufferFullTabletCount;
	int CaptureTimoutTabletCount;
	int ProcessingTimoutTabletCount;
	int CPBFullTabletCount;
	int ProcessingErrorTabletCount;
	int UnPrintTabletCount;
  int PrintMisMatchCount;
	int UnInsTabletPositionCount;
	int UnInsBrightnessDropCount;
	int UnInsBrightnessChaseCount;
	int Sensor1MisFeedingTabletCount;
	int Sensor2MisFeedingTabletCount;
	int Sensor1MultiTabletCount;
	int Sensor2MultiTabletCount;
	int NozzErrorDefectTabletCount;
	int NozzErrorUnInsTabletCount;
} TInspectionListUnit;
//---------------------------------------------------------------------------
class TInspectionReportForm : public TTntForm
{
__published:	// IDE-managed Components
  TTntPanel *Panel2;
	TTntPanel *Panel3;
	TTntBitBtn *OkBitBtn;
	TTntPanel *Panel1;
	TTntPanel *ComplexPanel;
	TTntPanel *InspectionRecordPanel;
	TTntPanel *Panel7;
	TTntPanel *Panel8;
	TTntStringGrid *InspectionReportStringGrid;
	TTntButton *InsertInspectResultButton;
	TTntButton *NavigateDefectImageButton;
	TTntPanel *SimplePanel;
	TTntPanel *HiddenPanel;
	TTntButton *EditInspectResultButton;
	TTntButton *DeleteInspectResultButton;
	TTntButton *PrintButton2;
	TTntButton *PrintButton;
	TTntPanel *UnInsInfoPanel;
	TTntPanel *Panel4;
	TTntGroupBox *GroupBox1;
	TTntLabel *Label9;
	TTntLabel *TotalUnInsCountLabel;
	TTntGroupBox *GroupBox2;
	TTntLabel *Label10;
	TTntLabel *ClosedTabletCountLabel;
	TTntLabel *Label4;
	TTntLabel *UnInsTabletPositionCountLabel;
	TTntGroupBox *GroupBox3;
	TTntLabel *Label11;
	TTntLabel *DisappearedTabletCountLabel;
	TTntLabel *Label13;
	TTntLabel *InsertedTabletCountLabel;
	TTntLabel *Label15;
        TTntLabel *ClosedTabletUninsCountLabel;
	TTntLabel *Label71;
	TTntLabel *MultiTabletCountLabel;
	TTntLabel *Label53;
	TTntLabel *MissFeedingTabletCountLabel;
	TTntLabel *Label47;
        TTntLabel *NozzErrorUnInsTabletCountLabel;
	TTntGroupBox *GroupBox4;
	TTntLabel *Label42;
	TTntLabel *CaptureNotReadyTabletCountLabel;
	TTntLabel *Label46;
	TTntLabel *CaptureTimeoutTabletCountLabel;
	TTntLabel *Label52;
	TTntLabel *BufferFullTabletCountLabel;
	TTntGroupBox *GroupBox5;
	TTntLabel *Label8;
	TTntLabel *SPBTOCountLabel;
	TTntLabel *Label28;
	TTntLabel *WrongNumberTabletCountLabel;
	TTntLabel *NumberUndefTabletCountLabel;
	TTntLabel *Label54;
	TTntGroupBox *GroupBox6;
	TTntLabel *Label48;
	TTntLabel *ProcessingTimeoutTabletCountLabel;
	TTntLabel *Label50;
	TTntLabel *CPBFullTabletCountLabel;
	TTntLabel *Label40;
	TTntLabel *ProcErrorTabletCountLabel;
	TTntGroupBox *GroupBox7;
	TTntLabel *Label34;
	TTntLabel *UnInsBrightnessDropCountLabel;
	TTntLabel *Label44;
	TTntLabel *UnInsBrightnessChaseCountLabel;
	TTntLabel *Label3;
	TTntLabel *Label1;
	TTntLabel *UnPrintTabletCountLabel;
	TTntLabel *SPBPNCCountLabel;
	TChart *ThroughputChart;
	TLineSeries *Series3;
	TTntPanel *DefectChartPanel;
	TChart *DefectChart;
	TPieSeries *Series8;
	TTntPanel *Panel14;
	TTntLabel *DefectNameLabel1;
	TTntLabel *DefectCountLabel1;
	TTntLabel *DefectNameLabel2;
	TTntLabel *DefectCountLabel2;
	TTntLabel *DefectNameLabel3;
	TTntLabel *DefectCountLabel3;
	TTntShape *DefectSeriesShape1;
	TTntShape *DefectSeriesShape2;
	TTntShape *DefectSeriesShape3;
	TTntLabel *DefectNameLabel4;
	TTntLabel *DefectCountLabel4;
	TTntLabel *DefectNameLabel5;
	TTntLabel *DefectCountLabel5;
	TTntShape *DefectSeriesShape4;
	TTntShape *DefectSeriesShape5;
	TTntLabel *DefectNameLabel6;
	TTntLabel *DefectCountLabel6;
	TTntLabel *DefectNameLabel7;
	TTntLabel *DefectCountLabel7;
	TTntLabel *DefectNameLabel8;
	TTntLabel *DefectCountLabel8;
	TTntShape *DefectSeriesShape6;
	TTntShape *DefectSeriesShape7;
	TTntShape *DefectSeriesShape8;
	TTntLabel *DefectNameLabel9;
	TTntLabel *DefectCountLabel9;
	TTntLabel *DefectNameLabel10;
	TTntLabel *DefectCountLabel10;
	TTntShape *DefectSeriesShape9;
	TTntShape *DefectSeriesShape10;
  TTntLabel *TntLabel1;
  TTntLabel *EngraveMisMatchingCountLabel;
  TPanel *ProgressPanel;
  TTntButton *BatchEndBtn;
  TLabel *BatchStatusLabel;
  TTntPanel *RightMenuPanel;
  TTntGroupBox *TntGroupBox2;
  TTntLabel *TntLabel2;
  TTntLabel *BrowseStartDateLabel;
  TTntLabel *TntLabel3;
  TTntLabel *BrowseEndDateLabel;
  TTntLabel *BrowseStartTimeLabel;
  TTntLabel *BrowseEndTimeLabel;
  TTntLabel *TntLabel4;
  TTntLabel *TntLabel5;
  TTntLabel *TntLabel6;
  TTntLabel *TntLabel7;
  TTntButton *BrowseStartDateButton;
  TTntButton *BrowseEndDataButton;
  TTntButton *PeriodButton1;
  TTntButton *PeriodButton2;
  TTntButton *PeriodButton3;
  TTntButton *PeriodButton4;
  TTntEdit *BrowseStartHourEdit;
  TTntEdit *BrowseStartMinEdit;
  TTntEdit *BrowseEndHourEdit;
  TTntEdit *BrowseEndMinEdit;
  TTntGroupBox *TntGroupBox3;
  TTntRadioButton *AllProductRadioButton;
  TTntRadioButton *SpecifiedProductRadioButton;
  TTntEdit *ProductNameEdit;
  TTntButton *BackupButton;
  TTntButton *TntButton1;
        TTntLabel *Label17;
        TTntLabel *ClosedTabletDefectCountLabel;
  TTntLabel *Label12;
  TTntLabel *NozzErrorDefectTabletCountLabel;
	TTntButton *NavigateDefectImageButton_Copy;
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall InsertInspectResultButtonClick(TObject *Sender);
	void __fastcall NavigateDefectImageButtonClick(TObject *Sender);
	void __fastcall HiddenPanelDblClick(TObject *Sender);
	void __fastcall EditInspectResultButtonClick(TObject *Sender);
	void __fastcall DeleteInspectResultButtonClick(TObject *Sender);
	void __fastcall PrintButtonClick(TObject *Sender);
	void __fastcall InspectionReportStringGridSelectCell(TObject *Sender,
          int ACol, int ARow, bool &CanSelect);
	void __fastcall FormDestroy(TObject *Sender);
	void __fastcall ThroughputChartMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall ThroughputChartMouseMove(TObject *Sender,
          TShiftState Shift, int X, int Y);
  void __fastcall BatchEndBtnClick(TObject *Sender);
  void __fastcall InspectionReportStringGridClick(TObject *Sender);
  void __fastcall BrowseStartHourEditClick(TObject *Sender);
  void __fastcall BrowseStartHourEditChange(TObject *Sender);
  void __fastcall ProductNameEditClick(TObject *Sender);
  void __fastcall BrowseStartDateButtonClick(TObject *Sender);
  void __fastcall BrowseEndDataButtonClick(TObject *Sender);
  void __fastcall PeriodButton1Click(TObject *Sender);
  void __fastcall PeriodButton2Click(TObject *Sender);
  void __fastcall PeriodButton3Click(TObject *Sender);
  void __fastcall PeriodButton4Click(TObject *Sender);
  void __fastcall ViewBtnClick(TObject *Sender);
  void __fastcall TntFormActivate(TObject *Sender);
private:	// User declarations
	double *ThroughputChartList;
	int ThroughputChartListSize;
	int ThroughputChartCount;
	int ThroughputChartDownX;
	int DefectSeriesCount[MAX_DEFECT_SERIES_COUNT + 1];

  TDateTime BrowseStartTime,BrowseEndTime;
  TDateTime StartDateTime, EndDateTime;
  
	vector<TInspectionListUnit> InspectionReportList;
	void __fastcall InitInspectionReportList(bool Option= false);
    void __fastcall SortInspectionList(bool Option= false);
	void __fastcall ShowInspectionList(void);
	void __fastcall RefreshDefectsInfo(void);
	void __fastcall RefreshThroughputChart(void);
  void __fastcall GetDefaultString();
  void __fastcall setDefectSeriesCount(AnsiString productCode, AnsiString lotName);
  void __fastcall Ajanta_BatchStatusControl();
  bool __fastcall CheckDateTime(TDateTime StartDate, TDateTime EndDate);
  bool __fastcall AvailableLotNumCheck(AnsiString sr_Name);
  int beforeRowIndex ;
  void __fastcall LoadInspectionResultData(int ARow);
public:		// User declarations
	__fastcall TInspectionReportForm(TComponent* Owner);
  void __fastcall OnUserChange(void);
};
//---------------------------------------------------------------------------
extern PACKAGE TInspectionReportForm *InspectionReportForm;
//---------------------------------------------------------------------------
#endif
