#include <vcl.h>
#pragma hdrstop

#include "InspectionResultInsert_Form.h"
#include "GradeSetting.h"
#include "Keyboard_Form.h"
#include "Message_Form.h"
#include "Environment.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntComCtrls"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TInspectionResultInsertForm *InspectionResultInsertForm;
//---------------------------------------------------------------------------
__fastcall TInspectionResultInsertForm::TInspectionResultInsertForm(TComponent* Owner)
	: TTntForm(Owner)
{
	if (DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
		ComponentSetFontName(this, "SimSun");
	else if (DefaultLCID == 1041)
		ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

	GetDefaultString();

	InspectionTimeIndex = 0;
	InspectionStartDate = TDateTime::CurrentDate();
	InspectionStartTime = TDateTime::CurrentTime();
	InspectionEndDate = TDateTime::CurrentDate();
	InspectionEndTime = TDateTime::CurrentTime();
	InspectionStartTimeEdit->Text = (InspectionStartDate + InspectionStartTime).DateTimeString();
	InspectionEndTimeEdit->Text = (InspectionEndDate + InspectionEndTime).DateTimeString();

  memset(&TabletInspectReport, 0, sizeof(NFA_DATA_REPORT));
  memset(&TabletInspectGradeData, 0, sizeof(NFA_DATA_REPORT_GRADE));

  SetDefaultGradeData(tempTabletGradeData);

	unsigned short year, month, day;
	unsigned short hour, min, sec, msec;
	TDateTime(ProductData.LastInspectionTime).DecodeDate(&year, &month, &day);
	TDateTime(ProductData.LastInspectionTime).DecodeTime(&hour, &min, &sec, &msec);
	LastInspectionDate = TDateTime(year, month, day);
	LastInspectionTime = TDateTime(hour, min, sec, msec);
	if ((LastInspectionDate + LastInspectionTime).Val != 0)
	{
		LastInspectionTimeEdit->Text = (LastInspectionDate + LastInspectionTime).DateTimeString();
	}
	else
	{
		LastInspectionTimeEdit->Text = "";
	}

	TabletInspectReport.InspectionStartTime = Now().Val;
	TabletInspectReport.InspectionEndTime = Now().Val;
	OperatorNameEdit->Text = UserInfo.Name;

  // set grade

	MonthCalendar->Date = Now();
}
//---------------------------------------------------------------------------
void __fastcall TInspectionResultInsertForm::GetDefaultString()
{
  this->Caption = INSPECTIONRESULTINSERTFORM_LABEL_CAPTION_09;
	CancelBitBtn->Caption = INSPECTIONRESULTINSERTFORM_BITBTN_CAPTION_01;
	Label4->Caption = INSPECTIONRESULTINSERTFORM_LABEL_CAPTION_11;
	Label5->Caption = INSPECTIONRESULTINSERTFORM_LABEL_CAPTION_12;
	Label23->Caption = INSPECTIONRESULTINSERTFORM_LABEL_CAPTION_18;
	Label3->Caption = INSPECTIONRESULTINSERTFORM_LABEL_CAPTION_19;
	LastInspectionTimeEraseButton->Caption = INSPECTIONRESULTINSERTFORM_LABEL_CAPTION_20;
  Label22->Caption = INSPECTIONRESULTINSERTFORM_LABEL_CAPTION_28;
	Label2->Caption = INSPECTIONRESULTINSERTFORM_LABEL_CAPTION_29;
	Label9->Caption = INSPECTIONRESULTINSERTFORM_LABEL_CAPTION_30;
	Label54->Caption = INSPECTIONRESULTINSERTFORM_LABEL_CAPTION_31;
	SetToCurrentUserButton->Caption = INSPECTIONRESULTINSERTFORM_LABEL_CAPTION_35;
	OkBitBtn->Caption = INSPECTIONRESULTINSERTFORM_LABEL_CAPTION_36;
	Label6->Caption = NEW_ADD_STRING_34;
	Label7->Caption = NEW_ADD_STRING_35;
	Label8->Caption = NEW_ADD_STRING_36;
}
//---------------------------------------------------------------------------
void __fastcall TInspectionResultInsertForm::LotNameEditClick(
	TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *)Sender;
	KeyboardForm->Text = theEdit->Text;
	if (KeyboardForm->ShowKeyboard() == mrOk)
	{
		theEdit->Text = KeyboardForm->Text;
	}

	InspectionTimeIndex = 0;
	MonthCalendar->Visible = false;
	TimeEditPanel->Visible = false;
}
//---------------------------------------------------------------------------

void __fastcall TInspectionResultInsertForm::NumberEditClick(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *)Sender;
	KeyboardForm->Text = theEdit->Text;
	if (KeyboardForm->ShowKeypad() == mrOk)
	{
		theEdit->Text = KeyboardForm->Text;
	}
}
//---------------------------------------------------------------------------
void __fastcall TInspectionResultInsertForm::MonthCalendarClick(
	TObject *Sender)
{
	if (InspectionTimeIndex == 1)
	{
		InspectionStartDate = MonthCalendar->Date;
		InspectionStartTimeEdit->Text = (InspectionStartDate + InspectionStartTime).DateTimeString();
	}
	else if (InspectionTimeIndex == 2)
	{
		InspectionEndDate = MonthCalendar->Date;
		InspectionEndTimeEdit->Text = (InspectionEndDate + InspectionEndTime).DateTimeString();
	}
	else if (InspectionTimeIndex == 3)
	{
		LastInspectionDate = MonthCalendar->Date;
		LastInspectionTimeEdit->Text = (LastInspectionDate + LastInspectionTime).DateTimeString();
	}
}
//---------------------------------------------------------------------------

void __fastcall TInspectionResultInsertForm::InspectionStartTimeEditClick(
	TObject *Sender)
{
	InspectionTimeIndex = 1;
	MonthCalendar->Visible = true;
	TimeEditPanel->Visible = true;
	unsigned short hour, min, sec, msec;
	InspectionStartTime.DecodeTime(&hour, &min, &sec, &msec);
	HourEdit->Text = IntToStr(hour);
	MinEdit->Text = IntToStr(min);
	SecEdit->Text = IntToStr(sec);
}
//---------------------------------------------------------------------------
void __fastcall TInspectionResultInsertForm::InspectionEndTimeEditClick(
	TObject *Sender)
{
	InspectionTimeIndex = 2;
	MonthCalendar->Visible = true;
	TimeEditPanel->Visible = true;
	unsigned short hour, min, sec, msec;
	InspectionEndTime.DecodeTime(&hour, &min, &sec, &msec);
	HourEdit->Text = IntToStr(hour);
	MinEdit->Text = IntToStr(min);
	SecEdit->Text = IntToStr(sec);
}
//---------------------------------------------------------------------------

void __fastcall TInspectionResultInsertForm::TimeEditChange(
	TObject *Sender)
{
	if (InspectionTimeIndex == 1)
	{
		try
		{
			InspectionStartTime = TDateTime(StrToInt(HourEdit->Text), StrToInt(MinEdit->Text), StrToInt(SecEdit->Text), 0);
			InspectionStartTimeEdit->Text = (InspectionStartDate + InspectionStartTime).DateTimeString();
		}
		catch (...)
		{

		}
	}
	else if (InspectionTimeIndex == 2)
	{
		try
		{
			InspectionEndTime = TDateTime(StrToInt(HourEdit->Text), StrToInt(MinEdit->Text), StrToInt(SecEdit->Text), 0);
			InspectionEndTimeEdit->Text = (InspectionEndDate + InspectionEndTime).DateTimeString();
		}
		catch (...)
		{

		}
	}
	else if (InspectionTimeIndex == 3)
	{
		try
		{
			LastInspectionTime = TDateTime(StrToInt(HourEdit->Text), StrToInt(MinEdit->Text), StrToInt(SecEdit->Text), 0);
			LastInspectionTimeEdit->Text = (LastInspectionDate + LastInspectionTime).DateTimeString();
		}
		catch (...)
		{

		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TInspectionResultInsertForm::OkBitBtnClick(TObject *Sender)
{
	WideString Word;
	if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
	{
		Word = "Please Enter A Batch";
	}
	else
	{
		Word = INSPECTIONRESULTINSERTFORM_LABEL_CAPTION_06;
	}
	if (LotNameEdit->Text == Word)
	{
		ShowMessageFA("");
		return;
	}
	else
	{
    if (LotNameEdit->Text == NULL)
    {
      ShowMessageFA("There is no input value.[LOT]");
		  return;
    }

    if (OperatorNameEdit->Text == NULL)
    {
      ShowMessageFA("There is no input value.[USER]");
		  return;
    }

		LOTName = LotNameEdit->Text;
		TabletInspectReport.ProductionCount = StrToInt(ProductionCountEdit->Text);
		TabletInspectReport.TotalTabletCount = StrToInt(TotalTabletCountEdit->Text);
		TabletInspectReport.DefectTabletCount = StrToInt(DefectTabletCountEdit->Text);
		TabletInspectReport.UnInsTabletCount = StrToInt(UnInsTabletCountEdit->Text);
		TabletInspectReport.GoodTabletCount = TabletInspectReport.TotalTabletCount - TabletInspectReport.DefectTabletCount - TabletInspectReport.UnInsTabletCount;
		TabletInspectReport.InspectionStartTime = (InspectionStartDate + InspectionStartTime).Val;
		TabletInspectReport.InspectionEndTime = (InspectionEndDate + InspectionEndTime).Val;
		strncpy(TabletInspectReport.OperatorName, OperatorNameEdit->Text.c_str(), 32);

    GetGradeInfo(&tempTabletGradeData);

		ProductData.LastInspectionTime = LastInspectionDate + LastInspectionTime;
		AnsiString fileName = GetProductDataFileName(ProductData.ProductCode);
		WriteProductData(fileName, ProductData);
		ModalResult = mrOk;
	}
}
//---------------------------------------------------------------------------
void __fastcall TInspectionResultInsertForm::SetReportEdit(AnsiString lotName,
	NFA_DATA_REPORT tabletInspectReport, NFA_DATA_REPORT_GRADE tabletInspectGradeData)
{
	LOTName = lotName;
	TabletInspectReport = tabletInspectReport;
	TabletInspectGradeData = tabletInspectGradeData;
	LotNameEdit->Text = LOTName;
	ProductionCountEdit->Text = FloatToStr(tabletInspectReport.ProductionCount);
	TotalTabletCountEdit->Text = IntToStr(tabletInspectReport.TotalTabletCount);
	DefectTabletCountEdit->Text = IntToStr(tabletInspectReport.DefectTabletCount);
	UnInsTabletCountEdit->Text = IntToStr(tabletInspectReport.UnInsTabletCount);

	unsigned short year, month, day;
	unsigned short hour, min, sec, msec;
	TDateTime(tabletInspectReport.InspectionStartTime).DecodeDate(&year, &month, &day);
	TDateTime(tabletInspectReport.InspectionStartTime).DecodeTime(&hour, &min, &sec, &msec);

	InspectionStartDate = TDateTime(year, month, day);
	InspectionStartTime = TDateTime(hour, min, sec, msec);

	TDateTime(tabletInspectReport.InspectionEndTime).DecodeDate(&year, &month, &day);
	TDateTime(tabletInspectReport.InspectionEndTime).DecodeTime(&hour, &min, &sec, &msec);

	InspectionEndDate = TDateTime(year, month, day);
	InspectionEndTime = TDateTime(hour, min, sec, msec);

	char operName[33];
	strncpy(operName, tabletInspectReport.OperatorName, 32);
	operName[32] = '\0';
	OperatorNameEdit->Text = AnsiString(operName);

	InspectionStartTimeEdit->Text = (InspectionStartDate + InspectionStartTime).DateTimeString();
	InspectionEndTimeEdit->Text = (InspectionEndDate + InspectionEndTime).DateTimeString();

  SetGradeInfo(&tempTabletGradeData);
}
//---------------------------------------------------------------------------

void __fastcall TInspectionResultInsertForm::TotalTabletCountEditClick(
	TObject *Sender)
{
	InspectionTimeIndex = 0;
	MonthCalendar->Visible = false;
	TimeEditPanel->Visible = false;

	TTntEdit *theEdit = (TTntEdit *)Sender;
	KeyboardForm->Text = theEdit->Text;
	if (KeyboardForm->ShowKeypad() == mrOk)
	{
		theEdit->Text = KeyboardForm->Text;
	}
}
//---------------------------------------------------------------------------

void __fastcall TInspectionResultInsertForm::DefectTabletCountEditClick(
	TObject *Sender)
{
	InspectionTimeIndex = 0;
	MonthCalendar->Visible = false;
	TimeEditPanel->Visible = false;

	TTntEdit *theEdit = (TTntEdit *)Sender;
	KeyboardForm->Text = theEdit->Text;
	if (KeyboardForm->ShowKeypad() == mrOk)
	{
		theEdit->Text = KeyboardForm->Text;
	}
}
//---------------------------------------------------------------------------

void __fastcall TInspectionResultInsertForm::SetToCurrentUserButtonClick(
	TObject *Sender)
{
	OperatorNameEdit->Text = UserInfo.Name;
}
//---------------------------------------------------------------------------

void __fastcall TInspectionResultInsertForm::LastInspectionTimeEditClick(
	TObject *Sender)
{
	InspectionTimeIndex = 3;
	MonthCalendar->Visible = true;
	TimeEditPanel->Visible = true;
	unsigned short hour, min, sec, msec;
	LastInspectionTime.DecodeTime(&hour, &min, &sec, &msec);
	HourEdit->Text = IntToStr(hour);
	MinEdit->Text = IntToStr(min);
	SecEdit->Text = IntToStr(sec);
}
//---------------------------------------------------------------------------

void __fastcall TInspectionResultInsertForm::LastInspectionTimeEraseButtonClick(
	TObject *Sender)
{
	LastInspectionDate.Val = LastInspectionTime.Val = 0;
	LastInspectionTimeEdit->Text = "";
}
//---------------------------------------------------------------------------

void __fastcall TInspectionResultInsertForm::GetGradeInfo(TTabletGradeData *pTabletGradeData)
{
  TabletInspectGradeData.ColorGrade = pTabletGradeData->front_color_Intensity;
  TabletInspectGradeData.FrontNormalDirtyGrade = pTabletGradeData->front_dirty_Intensity;
  TabletInspectGradeData.FrontPrintDirtyGrade = pTabletGradeData->front_print_dirty_Inetensity;
  TabletInspectGradeData.FrontEdgeDirtyGrade = pTabletGradeData->front_edge_dirty_Intensity;
  TabletInspectGradeData.FrontStainGrade = pTabletGradeData->front_stain_Intensity;
  TabletInspectGradeData.FrontEdgeGrade = pTabletGradeData->front_edge_Intensity;
  TabletInspectGradeData.FrontColorDirtyGrade = pTabletGradeData->front_Color_Dirty_Intensity;
  TabletInspectGradeData.OptionBreakingGrade = pTabletGradeData->option_Breaking_Intensity;
  TabletInspectGradeData.OptionFrontStickingGrade_Type1 = pTabletGradeData->option_front_edgeBreaking_Intensity_Type1;
  TabletInspectGradeData.OptionFrontStickingGrade_Type2 = pTabletGradeData->option_front_edgeBreaking_Intensity_Type2;

  TabletInspectGradeData.OptionPrintMarkGrade = pTabletGradeData->option_PrintMark_Intensity;
  TabletInspectGradeData.SideDirtyGrade = pTabletGradeData->side_dirty_Intensity;
  TabletInspectGradeData.SideStainGrade = pTabletGradeData->side_stain_Intensity;
  TabletInspectGradeData.SideHeightGrade = pTabletGradeData->side_height_Intensity;
  TabletInspectGradeData.PrintEraseGrade = pTabletGradeData->front_print_erase_Intensity;
  TabletInspectGradeData.PrintSpreadGrade = pTabletGradeData->front_print_spread_Intensity;
  TabletInspectGradeData.SideColorDirtyGrade = pTabletGradeData->side_Color_Dirty_Intensity;
  TabletInspectGradeData.ThreeDHeightMinusLimit = pTabletGradeData->threeD_Height_Minus_Limit;
  TabletInspectGradeData.ThreeDHeightPlusLimit = pTabletGradeData->threeD_Height_Plus_Limit;
  TabletInspectGradeData.FrontNormalDirtySize = pTabletGradeData->front_dirty_Size;
  TabletInspectGradeData.FrontEdgeDirtySize = pTabletGradeData->front_edge_dirty_Size;
  TabletInspectGradeData.FrontStainSize = pTabletGradeData->front_stain_Size;
  TabletInspectGradeData.FrontEdgeSize = pTabletGradeData->front_edge_Size;
  TabletInspectGradeData.FrontColorDirtySize = pTabletGradeData->front_Color_Dirty_Size;
  TabletInspectGradeData.SideDirtySize = pTabletGradeData->side_dirty_Size;
  TabletInspectGradeData.SideStainSize = pTabletGradeData->side_stain_Size;
  TabletInspectGradeData.SideHeightSize = pTabletGradeData->threeD_Height_Minus_Limit;
  TabletInspectGradeData.OptionBreakingSize = pTabletGradeData->option_Breaking_Size;
  TabletInspectGradeData.OptionFrontStickingSize_Type1 = pTabletGradeData->option_front_edgeBreaking_Size_Type1;
  TabletInspectGradeData.OptionFrontStickingSize_Type2 = pTabletGradeData->option_front_edgeBreaking_Size_Type2;

  TabletInspectGradeData.SideColorDirtySize = pTabletGradeData->side_Color_Dirty_Size;
  TabletInspectGradeData.EngraveDistinguishGradeFor3D = pTabletGradeData->EngraveDistinguishGradeFor3D;
  TabletInspectGradeData.Side_Edge_Neighbor_Intensity = pTabletGradeData->Side_Edge_Neighbor_Intensity;
  TabletInspectGradeData.Side_Edge_Neighbor_Defect_Size = pTabletGradeData->Side_Edge_Neighbor_Defect_Size;
  TabletInspectGradeData.Side_Edge_Dark_Intensity = pTabletGradeData->Side_Edge_Dark_Intensity;
  TabletInspectGradeData.Side_Edge_Dark_Defect_Size = pTabletGradeData->Side_Edge_Dark_Defect_Size;
  TabletInspectGradeData.Side_Edge_Bright_Intensity = pTabletGradeData->Side_Edge_Bright_Intensity;
  TabletInspectGradeData.Side_Edge_Bright_Defect_Size = pTabletGradeData->Side_Edge_Bright_Defect_Size;
  TabletInspectGradeData.Side_Edge_Neighbor_Break_Intensity = pTabletGradeData->Side_Edge_Neighbor_Break_Intensity;
  TabletInspectGradeData.Side_Edge_Neighbor_Break_Size = pTabletGradeData->Side_Edge_Neighbor_Break_Size;
  TabletInspectGradeData.EngraveDistinguishGradeFor2D = pTabletGradeData->EngraveDistinguishGrade;
  TabletInspectGradeData.EngravePositionDefectCheckSW = pTabletGradeData->EngravePositionDefectCheckSW;
}
//---------------------------------------------------------------------------

void __fastcall TInspectionResultInsertForm::SetGradeInfo(TTabletGradeData *pTabletGradeData)
{
  pTabletGradeData->front_color_Intensity = TabletInspectGradeData.ColorGrade;
  pTabletGradeData->front_dirty_Intensity = TabletInspectGradeData.FrontNormalDirtyGrade;
  pTabletGradeData->front_print_dirty_Inetensity = TabletInspectGradeData.FrontPrintDirtyGrade;
  pTabletGradeData->front_edge_dirty_Intensity = TabletInspectGradeData.FrontEdgeDirtyGrade;
  pTabletGradeData->front_stain_Intensity = TabletInspectGradeData.FrontStainGrade;
  pTabletGradeData->front_edge_Intensity = TabletInspectGradeData.FrontEdgeGrade;
  pTabletGradeData->front_Color_Dirty_Intensity = TabletInspectGradeData.FrontColorDirtyGrade;
  pTabletGradeData->option_Breaking_Intensity = TabletInspectGradeData.OptionBreakingGrade;
  pTabletGradeData->option_front_edgeBreaking_Intensity_Type1 = TabletInspectGradeData.OptionFrontStickingGrade_Type1;
  pTabletGradeData->option_front_edgeBreaking_Intensity_Type2 = TabletInspectGradeData.OptionFrontStickingGrade_Type2;

  pTabletGradeData->option_PrintMark_Intensity = TabletInspectGradeData.OptionPrintMarkGrade;
  pTabletGradeData->side_dirty_Intensity = TabletInspectGradeData.SideDirtyGrade;
  pTabletGradeData->side_stain_Intensity = TabletInspectGradeData.SideStainGrade;
  pTabletGradeData->side_height_Intensity = TabletInspectGradeData.SideHeightGrade;
  pTabletGradeData->front_print_erase_Intensity = TabletInspectGradeData.PrintEraseGrade;
  pTabletGradeData->front_print_spread_Intensity = TabletInspectGradeData.PrintSpreadGrade;
  pTabletGradeData->side_Color_Dirty_Intensity = TabletInspectGradeData.SideColorDirtyGrade;
  pTabletGradeData->threeD_Height_Minus_Limit = TabletInspectGradeData.ThreeDHeightMinusLimit;
  pTabletGradeData->threeD_Height_Plus_Limit = TabletInspectGradeData.ThreeDHeightPlusLimit;
  pTabletGradeData->front_dirty_Size = TabletInspectGradeData.FrontNormalDirtySize;
  pTabletGradeData->front_edge_dirty_Size = TabletInspectGradeData.FrontEdgeDirtySize;
  pTabletGradeData->front_stain_Size = TabletInspectGradeData.FrontStainSize;
  pTabletGradeData->front_edge_Size = TabletInspectGradeData.FrontEdgeSize;
  pTabletGradeData->front_Color_Dirty_Size = TabletInspectGradeData.FrontColorDirtySize;
  pTabletGradeData->side_dirty_Size = TabletInspectGradeData.SideDirtySize;
  pTabletGradeData->side_stain_Size = TabletInspectGradeData.SideStainSize;
  pTabletGradeData->threeD_Height_Minus_Limit = TabletInspectGradeData.SideHeightSize;
  pTabletGradeData->option_Breaking_Size = TabletInspectGradeData.OptionBreakingSize;
  pTabletGradeData->option_front_edgeBreaking_Size_Type1 = TabletInspectGradeData.OptionFrontStickingSize_Type1;
  pTabletGradeData->option_front_edgeBreaking_Size_Type2 = TabletInspectGradeData.OptionFrontStickingSize_Type2;

  pTabletGradeData->side_Color_Dirty_Size = TabletInspectGradeData.SideColorDirtySize;
  pTabletGradeData->EngraveDistinguishGradeFor3D = TabletInspectGradeData.EngraveDistinguishGradeFor3D;
  pTabletGradeData->Side_Edge_Neighbor_Intensity = TabletInspectGradeData.Side_Edge_Neighbor_Intensity;
  pTabletGradeData->Side_Edge_Neighbor_Defect_Size = TabletInspectGradeData.Side_Edge_Neighbor_Defect_Size;
  pTabletGradeData->Side_Edge_Dark_Intensity = TabletInspectGradeData.Side_Edge_Dark_Intensity;
  pTabletGradeData->Side_Edge_Dark_Defect_Size = TabletInspectGradeData.Side_Edge_Dark_Defect_Size;
  pTabletGradeData->Side_Edge_Bright_Intensity = TabletInspectGradeData.Side_Edge_Bright_Intensity;
  pTabletGradeData->Side_Edge_Bright_Defect_Size = TabletInspectGradeData.Side_Edge_Bright_Defect_Size;
  pTabletGradeData->Side_Edge_Neighbor_Break_Intensity = TabletInspectGradeData.Side_Edge_Neighbor_Break_Intensity;
  pTabletGradeData->Side_Edge_Neighbor_Break_Size = TabletInspectGradeData.Side_Edge_Neighbor_Break_Size;
  pTabletGradeData->EngraveDistinguishGrade = TabletInspectGradeData.EngraveDistinguishGradeFor2D;
  pTabletGradeData->EngravePositionDefectCheckSW = TabletInspectGradeData.EngravePositionDefectCheckSW;
}
//---------------------------------------------------------------------------

void __fastcall TInspectionResultInsertForm::Button1Click(TObject *Sender)
{
  TGradeSettingForm *gradeSettingForm = new TGradeSettingForm(this);
	gradeSettingForm->SetGradeData(&tempTabletGradeData);
  gradeSettingForm->bUserMakingGradeData = true;
	if (gradeSettingForm->ShowModal() == mrOk)
	{
		gradeSettingForm->GetGradeData(&tempTabletGradeData);
	}
	delete gradeSettingForm;
}
//---------------------------------------------------------------------------

