//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon, 
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "LogViewer_Form.h"
#include "InspectionStatus_Form.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntGrids"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TInspectionStatusForm *InspectionStatusForm;
//---------------------------------------------------------------------------
__fastcall TInspectionStatusForm::TInspectionStatusForm(TComponent* Owner)
	: TTntForm(Owner)
{
	if (DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
		ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

	memset(TabletList, 0, PC_TABLET_LIST_COUNT * sizeof(TPCTabletUnit));
	memset(&PCTabletInfo, 0, sizeof(TPCTabletInfo));
	memset(ProcessingImageBufferData, 0, SYSTEM_SPB_MAX_COUNT * sizeof(TProcessingImageBufferData));
	StatusBoardIndex = 3;
	RefreshStringGrid();
}
//---------------------------------------------------------------------------
void __fastcall TInspectionStatusForm::ReadButtonClick(TObject *Sender)
{
	StatusReadTimer->Enabled = true;
}
//---------------------------------------------------------------------------
void __fastcall TInspectionStatusForm::StopButtonClick(TObject *Sender)
{
	StatusReadTimer->Enabled = false;
}
//---------------------------------------------------------------------------
void __fastcall TInspectionStatusForm::StatusReadTimerTimer(
	TObject *Sender)
{
	int requestNum = 1;
	if (!Comm_Request(COMM_HCB, CMD_TABLET_PROCESS_INFO, &requestNum, sizeof(int),
		&HCBTabletInfo, sizeof(TTabletInfo)))
	{
		StatusReadTimer->Enabled = false;
		//ShowMessageW(HCBConnection.GetLastErrorMessage());
	}

	PCTabletInfo.CurrentSensor1ListIndex = HCBTabletInfo.CurrentSensor1ListIndex;
	PCTabletInfo.CurrentSensor2ListIndex = HCBTabletInfo.CurrentSensor2ListIndex;
	PCTabletInfo.CurrentCapture1ListIndex = HCBTabletInfo.CurrentCapture1ListIndex;
	PCTabletInfo.CurrentCapture2ListIndex = HCBTabletInfo.CurrentCapture2ListIndex;
	PCTabletInfo.PollingResultTabletIndex = HCBTabletInfo.PollingResultTabletIndex;
	PCTabletInfo.PollingBlowTabletIndex = HCBTabletInfo.PollingBlowTabletIndex;

	for (int tabletTableIndex = 0; tabletTableIndex < HCB_TABLET_LIST_COUNT; tabletTableIndex++)
	{
		THCBDisk2TabletUnit *hcbDisk2TabletUnit = &HCBTabletInfo.Disk2TabletList[tabletTableIndex];
		TPCTabletUnit *pcTabletUnit = &TabletList[tabletTableIndex];

		pcTabletUnit->TabletNumber = hcbDisk2TabletUnit->TabletNumber;
		pcTabletUnit->InspectionResult = hcbDisk2TabletUnit->InspectionResult;
		for (int spbIndex = 0; spbIndex < MachineSetupData.IPB_BoardCount; spbIndex++)
		{
			pcTabletUnit->InspectionResult_SPB[spbIndex] = hcbDisk2TabletUnit->InspectionResult_SPB[spbIndex];
		}
		pcTabletUnit->HCBState = hcbDisk2TabletUnit->State;
		pcTabletUnit->Sensor1Time = hcbDisk2TabletUnit->Sensor1Time;
		pcTabletUnit->Sensor1Length = hcbDisk2TabletUnit->Sensor1Length;
		pcTabletUnit->EstimatedSensor2Time = hcbDisk2TabletUnit->EstimatedSensor2Time;
		pcTabletUnit->Sensor2Time = hcbDisk2TabletUnit->Sensor2Time;
		pcTabletUnit->Sensor2Length = hcbDisk2TabletUnit->Sensor2Length;
		for (int captureIndex = 0; captureIndex < SYSTEM_MACHINE_CAPTURE_COUNT; captureIndex++)
		{
			pcTabletUnit->IsLEDOn[captureIndex] = hcbDisk2TabletUnit->IsLEDOn[captureIndex];
		}
	}

	memset(SPBTabletProcessInfo, 0, SYSTEM_SPB_MAX_COUNT * sizeof(TSPBTabletProcessInfo));
	//for (int spbIndex = 2; spbIndex < 3; spbIndex++)

  int spbIndex = StatusBoardIndex - 1;
	{
		if (Comm_IsConnected(COMM_SPB + spbIndex))
		{
			requestNum = 1;
			if (!Comm_Request(COMM_SPB + spbIndex, CMD_TABLET_PROCESS_INFO, &requestNum, sizeof(int),
				&(SPBTabletProcessInfo[spbIndex]), sizeof(TSPBTabletProcessInfo)))
			{
				StatusReadTimer->Enabled = false;
			}
			else
			{
				for (int tabletTableIndex = 0; tabletTableIndex < SPB_TABLET_LIST_COUNT; tabletTableIndex++)
				{
					int spbTabletNumber = SPBTabletProcessInfo[spbIndex].TabletList[tabletTableIndex].TabletNumber;
					for (int tabletTableIndex_PC = 0; tabletTableIndex_PC < PC_TABLET_LIST_COUNT; tabletTableIndex_PC++)
					{
						if (TabletList[tabletTableIndex_PC].TabletNumber == spbTabletNumber)
						{
							TabletList[tabletTableIndex_PC].SPBState[spbIndex] = SPBTabletProcessInfo[spbIndex].TabletList[tabletTableIndex].State;
							break;
						}
					}
				}

				PCTabletInfo.NextCaptureListIndex[spbIndex] = SPBTabletProcessInfo[spbIndex].NextCaptureListIndex;
				PCTabletInfo.NumberingCaptureListIndex[spbIndex] = SPBTabletProcessInfo[spbIndex].NumberingCaptureListIndex;
				PCTabletInfo.PollingCaptureListIndex[spbIndex] = SPBTabletProcessInfo[spbIndex].PollingCaptureListIndex;
				PCTabletInfo.ProcessingTabletListIndex[spbIndex] = SPBTabletProcessInfo[spbIndex].ProcessingResultCheckingListIndex;
			}
		}
	}
	RefreshStringGrid();
}
//---------------------------------------------------------------------------
void __fastcall TInspectionStatusForm::RefreshStringGrid(void)
{
  TTntStringGrid *statusStringGrid;
  int dataPosition;
  
  // HCB
  statusStringGrid = HCBInspectionStatusStringGrid2;
  statusStringGrid->ColCount = 21;
  statusStringGrid->Cells[0][0] = "Num.";
  statusStringGrid->Cells[1][0] = "HCB State";

  statusStringGrid->Cells[2][0] = "S1 Time";
  statusStringGrid->Cells[3][0] = "S2 Time";

  statusStringGrid->Cells[4][0] = "Result";
  statusStringGrid->Cells[5][0] = "SPB1 Prs";
  statusStringGrid->Cells[6][0] = "SPB2 Prs";
  statusStringGrid->Cells[7][0] = "SPB3 Prs";
  statusStringGrid->Cells[8][0] = "SPB4 Prs";
  statusStringGrid->Cells[9][0] = "SPB5 Prs";
  statusStringGrid->Cells[10][0] = "SPB6 Prs";
  statusStringGrid->Cells[11][0] = "SPB7 Prs";
  statusStringGrid->Cells[12][0] = "SPB8 Prs";


  statusStringGrid->Cells[13][0] = "SPB1 State";
  statusStringGrid->Cells[14][0] = "SPB2 State";
  statusStringGrid->Cells[15][0] = "SPB3 State";
  statusStringGrid->Cells[16][0] = "SPB4 State";
  statusStringGrid->Cells[17][0] = "SPB5 State";
  statusStringGrid->Cells[18][0] = "SPB6 State";
  statusStringGrid->Cells[19][0] = "SPB7 State";
  statusStringGrid->Cells[20][0] = "SPB8 State";

  statusStringGrid->ColWidths[0] = 30;
  statusStringGrid->ColWidths[1] = 80;
  statusStringGrid->ColWidths[2] = 65;
  statusStringGrid->ColWidths[3] = 65;
  statusStringGrid->ColWidths[4] = 65;
  statusStringGrid->ColWidths[5] = 65;
  statusStringGrid->ColWidths[6] = 65;
  statusStringGrid->ColWidths[7] = 65;
  statusStringGrid->ColWidths[8] = 65;
  statusStringGrid->ColWidths[9] = 65;
  statusStringGrid->ColWidths[10] = 65;
  statusStringGrid->ColWidths[11] = 65;
  statusStringGrid->ColWidths[12] = 65;
  statusStringGrid->ColWidths[13] = 65;
  statusStringGrid->ColWidths[14] = 65;
  statusStringGrid->ColWidths[15] = 65;
  statusStringGrid->ColWidths[16] = 65;
  statusStringGrid->ColWidths[17] = 65;
  statusStringGrid->ColWidths[18] = 65;
  statusStringGrid->ColWidths[19] = 65;
  statusStringGrid->ColWidths[20] = 65;

  for (int tabletTableIndex = 0; tabletTableIndex < PC_TABLET_LIST_COUNT; tabletTableIndex++)
  {
    TPCTabletUnit *pcTabletUnit = &TabletList[tabletTableIndex];

    dataPosition = (pcTabletUnit->TabletNumber % PC_TABLET_LIST_COUNT) + 1;

    if(pcTabletUnit->TabletNumber > 0)
    {
      statusStringGrid->Cells[0][dataPosition] = IntToStr(pcTabletUnit->TabletNumber);
      statusStringGrid->Cells[2][dataPosition] = IntToStr(pcTabletUnit->Sensor1Time);
      statusStringGrid->Cells[3][dataPosition] = IntToStr(pcTabletUnit->Sensor2Time);

      switch (pcTabletUnit->HCBState)
      {
        case TABLET_STATE_READY:
          statusStringGrid->Cells[1][dataPosition] = "Ready";
          break;
        case TABLET_STATE_SENSOR_1_PASSED:
          statusStringGrid->Cells[1][dataPosition] = "S1 Passed";
          break;
        case TABLET_STATE_CAPTURE_INT_1_TRANSFERRED:
          statusStringGrid->Cells[1][dataPosition] = "Int1 T/F";
          break;
        case TABLET_STATE_CAPTURE_1_COMPLETE:
          statusStringGrid->Cells[1][dataPosition] = "Capture 1 OK";
          break;
        case TABLET_STATE_SENSOR_2_PASSED:
          statusStringGrid->Cells[1][dataPosition] = "S2 Passed";
          break;
        case TABLET_STATE_CAPTURE_INT_2_TRANSFERRED:
          statusStringGrid->Cells[1][dataPosition] = "Int2 T/F";
          break;
        case TABLET_STATE_RESULT_WAITING:
          statusStringGrid->Cells[1][dataPosition] = "Result Waiting";
          break;
        case TABLET_STATE_BLOW_WAITING:
          statusStringGrid->Cells[1][dataPosition] = "Blow Waiting";
          break;
        case TABLET_STATE_NC_WAITING:
          statusStringGrid->Cells[1][dataPosition] = "NC Waiting";
          break;
        case TABLET_STATE_COMPLETE:
          statusStringGrid->Cells[1][dataPosition] = "Complete";
          break;
        case TABLET_STATE_ERROR:
          statusStringGrid->Cells[1][dataPosition] = "Error";
          break;
        default:
          statusStringGrid->Cells[1][dataPosition] = "ETC";
          break;
      }

      if (pcTabletUnit->InspectionResult & TABLET_RESULT_SPB_MASK)
      {
        int spbUnInsResult = (pcTabletUnit->InspectionResult & ~TABLET_RESULT_SPB_MASK);
        switch (spbUnInsResult)
        {
          case SPB_TABLET_RESULT_NONE:
            statusStringGrid->Cells[4][dataPosition] = "(SPB)None";
            break;
          case SPB_TABLET_RESULT_GOOD:
            statusStringGrid->Cells[4][dataPosition] = "(SPB)Good";
            break;
          case SPB_TABLET_RESULT_PROCESSING:
            statusStringGrid->Cells[4][dataPosition] = "(SPB)Processing";
            break;
          case SPB_TABLET_RESULT_DEFECT:
            statusStringGrid->Cells[4][dataPosition] = "(SPB)Defect";
            break;
          case SPB_TABLET_RESULT_UNINS_IMAGE_BUFFER_FULL:
            statusStringGrid->Cells[4][dataPosition] = "(SPB)Buffer Full";
            break;
          case SPB_TABLET_RESULT_UNINS_TABLET_NUMBER_UNDEFINED:
            statusStringGrid->Cells[4][dataPosition] = "(SPB)UNDEF Number";
            break;
          case SPB_TABLET_RESULT_UNINS_WRONG_TABLET_NUMBER:
            statusStringGrid->Cells[4][dataPosition] = "(SPB)Wrong Number";
            break;
          case SPB_TABLET_RESULT_UNINS_CAPTURE_TIMEOUT:
            statusStringGrid->Cells[4][dataPosition] = "(SPB)Capture TO";
            break;
          case SPB_TABLET_RESULT_UNINS_CAPTURE_NOT_READY:
            statusStringGrid->Cells[4][dataPosition] = "(SPB)Capture NR";
            break;
          case SPB_TABLET_RESULT_UNINS_PROCESSING_TIMEOUT:
            statusStringGrid->Cells[4][dataPosition] = "(SPB)Processing TO";
            break;
          case SPB_TABLET_RESULT_UNINS_PROCESSING_ERROR:
            statusStringGrid->Cells[4][dataPosition] = "(SPB)Processing Error";
            break;
          case SPB_TABLET_RESULT_UNINS_CPB_FULL:
            statusStringGrid->Cells[4][dataPosition] = "(SPB)CPB FULL";
            break;
          case SPB_TABLET_RESULT_UNINS_CLOSED_TABLET:
            statusStringGrid->Cells[4][dataPosition] = "(SPB)Closed";
            break;
          case SPB_TABLET_RESULT_UNINS_TABLET_POSITION:
            statusStringGrid->Cells[4][dataPosition] = "(SPB)Position";
            break;
          case SPB_TABLET_RESULT_UNINS_BRIGHTNESS_DROPPED:
            statusStringGrid->Cells[4][dataPosition] = "(SPB)B Drop";
            break;
          case SPB_TABLET_RESULT_UNINS_BRIGHTNESS_CHASE:
            statusStringGrid->Cells[4][dataPosition] = "(SPB)B Chase";
            break;
          default:
            statusStringGrid->Cells[4][dataPosition] = "(SPB)ETC";
            break;
        }
      }
      else
      {
        switch (pcTabletUnit->InspectionResult)
        {
          case TABLET_RESULT_NONE:
            statusStringGrid->Cells[4][dataPosition] = "None";
            break;
          case TABLET_RESULT_GOOD:
            statusStringGrid->Cells[4][dataPosition] = "Good";
            break;
          case TABLET_RESULT_DEFECT:
            statusStringGrid->Cells[4][dataPosition] = "Defect";
            break;
          case TABLET_RESULT_DEFECT_UNPRINT:
            statusStringGrid->Cells[4][dataPosition] = "Defect_Unprint";
            break;
          case TABLET_RESULT_DEFECT_SPB_PROCESSING_NOT_COMPLETE:
            statusStringGrid->Cells[4][dataPosition] = "SPB NC(Defect)";
            break;
          case TABLET_RESULT_UNINS_SPB_TIMEOUT:
            statusStringGrid->Cells[4][dataPosition] = "SPB TO(UnIns)";
            break;
          case TABLET_RESULT_UNINS_SPB_PROCESSING_NOT_COMPLETE:
            statusStringGrid->Cells[4][dataPosition] = "SPB NC";
            break;
          case TABLET_RESULT_INSERTED:
            statusStringGrid->Cells[4][dataPosition] = "Inserted";
            break;
          case TABLET_RESULT_DISAPPEARED:
            statusStringGrid->Cells[4][dataPosition] = "Disappeared";
            break;
          case TABLET_RESULT_CLOSED_UNINS:
            statusStringGrid->Cells[4][dataPosition] = "Closed_U";
            break;
          case TABLET_RESULT_CLOSED_DEFECT:
            statusStringGrid->Cells[4][dataPosition] = "Closed_D";
            break;
          case TABLET_RESULT_SENSOR_1_MISFEEDING:
            statusStringGrid->Cells[4][dataPosition] = "Sensor 1 M/F";
            break;
          case TABLET_RESULT_SENSOR_2_MISFEEDING:
            statusStringGrid->Cells[4][dataPosition] = "Sensor 2 M/F";
            break;
          case TABLET_RESULT_MULTI_TABLET_SENSOR_1:
            statusStringGrid->Cells[4][dataPosition] = "Sensor 1 Multi";
            break;
          case TABLET_RESULT_MULTI_TABLET_SENSOR_2:
            statusStringGrid->Cells[4][dataPosition] = "Sensor 2 Multi";
            break;
          case TABLET_RESULT_UNINTENDED_UNINSPECT:
            statusStringGrid->Cells[4][dataPosition] = "UnIntended";
            break;
          default:
            statusStringGrid->Cells[4][dataPosition] = "ETC";
            break;
        }
      }

      for (int spbIndex = 0; spbIndex < MachineSetupData.IPB_BoardCount; spbIndex++)
      {
        switch (pcTabletUnit->InspectionResult_SPB[spbIndex])
        {
        case SPB_TABLET_RESULT_NONE:
          statusStringGrid->Cells[5 + spbIndex][dataPosition] = "None";
          break;
        case SPB_TABLET_RESULT_GOOD:
          statusStringGrid->Cells[5 + spbIndex][dataPosition] = "Good";
          break;
        case SPB_TABLET_RESULT_PROCESSING:
          statusStringGrid->Cells[5 + spbIndex][dataPosition] = "Processing";
          break;
        case SPB_TABLET_RESULT_DEFECT:
          statusStringGrid->Cells[5 + spbIndex][dataPosition] = "Defect";
          break;
        case SPB_TABLET_RESULT_UNINS_IMAGE_BUFFER_FULL:
          statusStringGrid->Cells[5 + spbIndex][dataPosition] = "Buffer Full";
          break;
        case SPB_TABLET_RESULT_UNINS_TABLET_NUMBER_UNDEFINED:
          statusStringGrid->Cells[5 + spbIndex][dataPosition] = "UNDEF Number";
          break;
        case SPB_TABLET_RESULT_UNINS_WRONG_TABLET_NUMBER:
          statusStringGrid->Cells[5 + spbIndex][dataPosition] = "Wrong Number";
          break;
        case SPB_TABLET_RESULT_UNINS_CAPTURE_TIMEOUT:
          statusStringGrid->Cells[5 + spbIndex][dataPosition] = "Capture TO";
          break;
        case SPB_TABLET_RESULT_UNINS_CAPTURE_NOT_READY:
          statusStringGrid->Cells[5 + spbIndex][dataPosition] = "Capture NR";
          break;
        case SPB_TABLET_RESULT_UNINS_PROCESSING_TIMEOUT:
          statusStringGrid->Cells[5 + spbIndex][dataPosition] = "Processing TO";
          break;
        case SPB_TABLET_RESULT_UNINS_PROCESSING_ERROR:
          statusStringGrid->Cells[5 + spbIndex][dataPosition] = "Processing Error";
          break;
        case SPB_TABLET_RESULT_UNINS_CPB_FULL:
          statusStringGrid->Cells[5 + spbIndex][dataPosition] = "CPB FULL";
          break;
        case SPB_TABLET_RESULT_UNINS_CLOSED_TABLET:
          statusStringGrid->Cells[5 + spbIndex][dataPosition] = "Closed";
          break;
        case SPB_TABLET_RESULT_UNINS_TABLET_POSITION:
          statusStringGrid->Cells[5 + spbIndex][dataPosition] = INSPECTIONSTATUSFORM_STRGRID_CELL_03;
          break;
        case SPB_TABLET_RESULT_UNINS_BRIGHTNESS_DROPPED:
          statusStringGrid->Cells[5 + spbIndex][dataPosition] = INSPECTIONSTATUSFORM_STRGRID_CELL_01;
          break;
        case SPB_TABLET_RESULT_UNINS_BRIGHTNESS_CHASE:
          statusStringGrid->Cells[5 + spbIndex][dataPosition] = INSPECTIONSTATUSFORM_STRGRID_CELL_02;
          break;
        default:
          statusStringGrid->Cells[5 + spbIndex][dataPosition] = "ETC " + IntToStr(pcTabletUnit->InspectionResult_SPB[spbIndex]);
          break;
        }
      }

      for (int spbIndex = 0; spbIndex < MachineSetupData.IPB_BoardCount; spbIndex++)
      {
        switch (pcTabletUnit->SPBState[spbIndex])
        {
        case SPB_TABLET_STATE_NONE:
          statusStringGrid->Cells[13 + spbIndex][dataPosition] = "None";
          break;
        case SPB_TABLET_STATE_FINDING_BUFFER:
          statusStringGrid->Cells[13 + spbIndex][dataPosition] = "Fnd Bfr";
          break;
        case SPB_TABLET_STATE_NUMBERING:
          statusStringGrid->Cells[13 + spbIndex][dataPosition] = "Numbering";
          break;
        case SPB_TABLET_STATE_CAPTURE_READY:
          statusStringGrid->Cells[13 + spbIndex][dataPosition] = "Cpt Rdy";
          break;
        case SPB_TABLET_STATE_ON_CAPTURE:
          statusStringGrid->Cells[13 + spbIndex][dataPosition] = "On Cpt";
          break;
        case SPB_TABLET_STATE_CAPTURED:
          statusStringGrid->Cells[13 + spbIndex][dataPosition] = "Cpted";
          break;
        case SPB_TABLET_STATE_PROCESSING_COMPLETE:
          statusStringGrid->Cells[13 + spbIndex][dataPosition] = "P Cpl";
          break;
        case SPB_TABLET_STATE_ERROR:
          statusStringGrid->Cells[13 + spbIndex][dataPosition] = "Error";
          break;
        default:
          statusStringGrid->Cells[13 + spbIndex][dataPosition] = "ETC " + IntToStr(pcTabletUnit->SPBState[spbIndex]);
          break;
        }
      }
    }
  }

  // SPB
  int spbIndex = StatusBoardIndex - 1;
  statusStringGrid = SPBInspectionStatusStringGrid;
  statusStringGrid->ColCount = 15;
  statusStringGrid->Cells[0][0] = "Num.";
  statusStringGrid->Cells[1][0] = "Result";
  statusStringGrid->Cells[2][0] = "State";
  statusStringGrid->Cells[3][0] = "Ins St1";
  statusStringGrid->Cells[4][0] = "Ins St2";
  statusStringGrid->Cells[5][0] = "Ins St3";
  statusStringGrid->Cells[6][0] = "Ins St4";
  statusStringGrid->Cells[7][0] = "Prs Result1";
  statusStringGrid->Cells[8][0] = "Prs Result2";
  statusStringGrid->Cells[9][0] = "Prs Result3";
  statusStringGrid->Cells[10][0] = "Prs Result4";
  statusStringGrid->Cells[11][0] = "Prt Result1";
  statusStringGrid->Cells[12][0] = "Prt Result2";
  statusStringGrid->Cells[13][0] = "Prt Result3";
  statusStringGrid->Cells[14][0] = "Prt Result4";

  statusStringGrid->ColWidths[0] = 30;
  statusStringGrid->ColWidths[1] = 80;
  statusStringGrid->ColWidths[2] = 120;
  statusStringGrid->ColWidths[3] = 60;
  statusStringGrid->ColWidths[4] = 60;
  statusStringGrid->ColWidths[5] = 60;
  statusStringGrid->ColWidths[6] = 60;
  statusStringGrid->ColWidths[7] = 60;
  statusStringGrid->ColWidths[8] = 60;
  statusStringGrid->ColWidths[9] = 60;
  statusStringGrid->ColWidths[10] = 60;
  statusStringGrid->ColWidths[11] = 60;
  statusStringGrid->ColWidths[12] = 60;
  statusStringGrid->ColWidths[13] = 60;
  statusStringGrid->ColWidths[14] = 60;

  for (int m = 0; m < SPBInspectionStatusStringGrid->RowCount; m++)
  {
    SPBInspectionStatusStringGrid->Cells[0][m] = "";
  }

  for (int tabletTableIndex = 0; tabletTableIndex < SPB_TABLET_LIST_COUNT; tabletTableIndex++)
  {
    TSPBTabletUnit *spbTabletUnit = &(SPBTabletProcessInfo[spbIndex].TabletList[tabletTableIndex]);

    dataPosition = (spbTabletUnit->TabletNumber % PC_TABLET_LIST_COUNT) + 1;
        
    if(spbTabletUnit->TabletNumber)
    {
      statusStringGrid->Cells[0][dataPosition] = IntToStr(spbTabletUnit->TabletNumber);
      switch (spbTabletUnit->Result)
      {
      case SPB_TABLET_RESULT_NONE:
        statusStringGrid->Cells[1][dataPosition] = "None";
        break;
      case SPB_TABLET_RESULT_GOOD:
        statusStringGrid->Cells[1][dataPosition] = "Good";
        break;
      case SPB_TABLET_RESULT_PROCESSING:
        statusStringGrid->Cells[1][dataPosition] = "Processing";
        break;
      case SPB_TABLET_RESULT_DEFECT:
        statusStringGrid->Cells[1][dataPosition] = "Defect";
        break;
      case SPB_TABLET_RESULT_UNINS_IMAGE_BUFFER_FULL:
        statusStringGrid->Cells[1][dataPosition] = "Buffer Full";
        break;
      case SPB_TABLET_RESULT_UNINS_TABLET_NUMBER_UNDEFINED:
        statusStringGrid->Cells[1][dataPosition] = "Number Undef";
        break;
      case SPB_TABLET_RESULT_UNINS_WRONG_TABLET_NUMBER:
        statusStringGrid->Cells[1][dataPosition] = "Wrong Number";
        break;
      case SPB_TABLET_RESULT_UNINS_CAPTURE_TIMEOUT:
        statusStringGrid->Cells[1][dataPosition] = "Capture TO";
        break;
      case SPB_TABLET_RESULT_UNINS_CAPTURE_NOT_READY:
        statusStringGrid->Cells[1][dataPosition] = "Capture NR";
        break;
      case SPB_TABLET_RESULT_UNINS_PROCESSING_TIMEOUT:
        statusStringGrid->Cells[1][dataPosition] = "Processing TO";
        break;
      case SPB_TABLET_RESULT_UNINS_PROCESSING_ERROR:
        statusStringGrid->Cells[1][dataPosition] = "Processing Error";
        break;
      case SPB_TABLET_RESULT_UNINS_CPB_FULL:
        statusStringGrid->Cells[1][dataPosition] = "CPB FULL";
        break;
      case SPB_TABLET_RESULT_UNINS_CLOSED_TABLET:
        statusStringGrid->Cells[1][dataPosition] = "Closed";
        break;
      default:
        statusStringGrid->Cells[1][dataPosition] = "ETC " + IntToStr(spbTabletUnit->Result);
        break;
      }

      switch (spbTabletUnit->State)
      {
      case SPB_TABLET_STATE_NONE:
        statusStringGrid->Cells[2][dataPosition] = "None";
        break;
      case SPB_TABLET_STATE_FINDING_BUFFER:
        statusStringGrid->Cells[2][dataPosition] = "Finding Buffer";
        break;
      case SPB_TABLET_STATE_NUMBERING:
        statusStringGrid->Cells[2][dataPosition] = "Numbering";
        break;
      case SPB_TABLET_STATE_CAPTURE_READY:
        statusStringGrid->Cells[2][dataPosition] = "Capture Ready";
        break;
      case SPB_TABLET_STATE_ON_CAPTURE:
        statusStringGrid->Cells[2][dataPosition] = "On Capture";
        break;
      case SPB_TABLET_STATE_CAPTURED:
        statusStringGrid->Cells[2][dataPosition] = "Captured";
        break;
      case SPB_TABLET_STATE_PROCESSING_COMPLETE:
        statusStringGrid->Cells[2][dataPosition] = "Processing Complete";
        break;
      case SPB_TABLET_STATE_ERROR:
        statusStringGrid->Cells[2][dataPosition] = "Error";
        break;
      default:
        statusStringGrid->Cells[2][dataPosition] = "ETC " + IntToStr(spbTabletUnit->State);
        break;
      }

      for (int camIndex = 0; camIndex < SYSTEM_SPB_CAMERA_COUNT; camIndex++)
      {
        switch (spbTabletUnit->InspectionState[camIndex])
        {
          case TABLET_INSPECTION_STATE_NONE:
            statusStringGrid->Cells[3 + camIndex][dataPosition] = "None";
            break;
          case TABLET_INSPECTION_STATE_CAPTURE_WAITING:
            statusStringGrid->Cells[3 + camIndex][dataPosition] = "Cpt Waiting";
            break;
          case TABLET_INSPECTION_STATE_ON_CAPTURE:
            statusStringGrid->Cells[3 + camIndex][dataPosition] = "On Capture";
            break;
          case TABLET_INSPECTION_STATE_CAPTURED:
            statusStringGrid->Cells[3 + camIndex][dataPosition] = "Captured";
            break;
          case TABLET_INSPECTION_STATE_PROCESSING_READY:
            statusStringGrid->Cells[3 + camIndex][dataPosition] = "Proc Rdy";
            break;
          case TABLET_INSPECTION_STATE_PROCESSING:
            statusStringGrid->Cells[3 + camIndex][dataPosition] = "Processing";
            break;
          case TABLET_INSPECTION_STATE_PROCESSING_COMPLETE:
            statusStringGrid->Cells[3 + camIndex][dataPosition] = "Complete";
            break;
          case TABLET_INSPECTION_STATE_PASSED:
            statusStringGrid->Cells[3 + camIndex][dataPosition] = "Passed";
            break;
          case TABLET_INSPECTION_STATE_CAPTURE_ERROR:
            statusStringGrid->Cells[3 + camIndex][dataPosition] = "Capture Error";
            break;
          case TABLET_INSPECTION_STATE_PROCESSING_ERROR:
            statusStringGrid->Cells[3 + camIndex][dataPosition] = "Processing Error";
            break;
          default:
            statusStringGrid->Cells[3 + camIndex][dataPosition] = "ETC " + IntToStr(spbTabletUnit->InspectionState[camIndex]);
            break;
        }
        switch (spbTabletUnit->ProcessingResult[camIndex])
        {
          case TABLET_PROCESSING_RESULT_UNKNOWN:
            statusStringGrid->Cells[7 + camIndex][dataPosition] = "Unknown";
            break;
          case TABLET_PROCESSING_RESULT_GOOD:
            statusStringGrid->Cells[7 + camIndex][dataPosition] = "Good";
            break;
          case TABLET_PROCESSING_RESULT_DEFECT:
            statusStringGrid->Cells[7 + camIndex][dataPosition] = "Defect";
            break;
          case TABLET_PROCESSING_RESULT_ERROR:
            statusStringGrid->Cells[7 + camIndex][dataPosition] = "Error";
            break;
          default:
            statusStringGrid->Cells[7 + camIndex][dataPosition] = "ETC " + IntToStr(spbTabletUnit->ProcessingResult[camIndex]);
            break;
        }
        switch (spbTabletUnit->PrintResult[camIndex])
        {
          case 0:
            statusStringGrid->Cells[11 + camIndex][dataPosition] = "X";
            break;
          case 1:
            statusStringGrid->Cells[11 + camIndex][dataPosition] = "O";
            break;
          case 2:
            statusStringGrid->Cells[11 + camIndex][dataPosition] = "NONE";
            break;
        }
      }
    }
  }

	CurrentTabletNumberLabel->Caption = IntToStr(HCBTabletInfo.CurrentTabletNumber);
	Sensor1IndexLabel->Caption = IntToStr(HCBTabletInfo.CurrentSensor1ListIndex);
	Sensor2IndexLabel->Caption = IntToStr(HCBTabletInfo.CurrentSensor2ListIndex);
	Int1IndexLabel->Caption = IntToStr(HCBTabletInfo.CurrentInt1ListIndex);
	Int2IndexLabel->Caption = IntToStr(HCBTabletInfo.CurrentInt2ListIndex);
	Capture1IndexLabel->Caption = IntToStr(HCBTabletInfo.CurrentCapture1ListIndex);
	Capture2IndexLabel->Caption = IntToStr(HCBTabletInfo.CurrentCapture2ListIndex);
	CurrentRelatedDisk1ListIndexLabel->Caption = IntToStr(HCBTabletInfo.CurrentRelatedDisk1TabletListIndex);
	ResultIndexLabel->Caption = IntToStr(HCBTabletInfo.PollingResultTabletIndex);
	BlowIndexLabel->Caption = IntToStr(HCBTabletInfo.PollingBlowTabletIndex);

	NextCaptureIndexLabel1->Caption = IntToStr(PCTabletInfo.NextCaptureListIndex[0]);
	NumberingIndexLabel1->Caption = IntToStr(PCTabletInfo.NumberingCaptureListIndex[0]);
	PollingCaptureIndexLabel1->Caption = IntToStr(PCTabletInfo.PollingCaptureListIndex[0]);
	ProcessingIndexLabel1->Caption = IntToStr(PCTabletInfo.ProcessingTabletListIndex[0]);

	NextCaptureIndexLabel2->Caption = IntToStr(PCTabletInfo.NextCaptureListIndex[1]);
	NumberingIndexLabel2->Caption = IntToStr(PCTabletInfo.NumberingCaptureListIndex[1]);
	PollingCaptureIndexLabel2->Caption = IntToStr(PCTabletInfo.PollingCaptureListIndex[1]);
	ProcessingIndexLabel2->Caption = IntToStr(PCTabletInfo.ProcessingTabletListIndex[1]);

	NextCaptureIndexLabel3->Caption = IntToStr(PCTabletInfo.NextCaptureListIndex[2]);
	NumberingIndexLabel3->Caption = IntToStr(PCTabletInfo.NumberingCaptureListIndex[2]);
	PollingCaptureIndexLabel3->Caption = IntToStr(PCTabletInfo.PollingCaptureListIndex[2]);
	ProcessingIndexLabel3->Caption = IntToStr(PCTabletInfo.ProcessingTabletListIndex[2]);

	NextCaptureIndexLabel4->Caption = IntToStr(PCTabletInfo.NextCaptureListIndex[3]);
	NumberingIndexLabel4->Caption = IntToStr(PCTabletInfo.NumberingCaptureListIndex[3]);
	PollingCaptureIndexLabel4->Caption = IntToStr(PCTabletInfo.PollingCaptureListIndex[3]);
	ProcessingIndexLabel4->Caption = IntToStr(PCTabletInfo.ProcessingTabletListIndex[3]);

  NextCaptureIndexLabel5->Caption = IntToStr(PCTabletInfo.NextCaptureListIndex[4]);
	NumberingIndexLabel5->Caption = IntToStr(PCTabletInfo.NumberingCaptureListIndex[4]);
	PollingCaptureIndexLabel5->Caption = IntToStr(PCTabletInfo.PollingCaptureListIndex[4]);
	ProcessingIndexLabel5->Caption = IntToStr(PCTabletInfo.ProcessingTabletListIndex[4]);

  NextCaptureIndexLabel6->Caption = IntToStr(PCTabletInfo.NextCaptureListIndex[5]);
	NumberingIndexLabel6->Caption = IntToStr(PCTabletInfo.NumberingCaptureListIndex[5]);
	PollingCaptureIndexLabel6->Caption = IntToStr(PCTabletInfo.PollingCaptureListIndex[5]);
	ProcessingIndexLabel6->Caption = IntToStr(PCTabletInfo.ProcessingTabletListIndex[5]);

  NextCaptureIndexLabel7->Caption = IntToStr(PCTabletInfo.NextCaptureListIndex[6]);
	NumberingIndexLabel7->Caption = IntToStr(PCTabletInfo.NumberingCaptureListIndex[6]);
	PollingCaptureIndexLabel7->Caption = IntToStr(PCTabletInfo.PollingCaptureListIndex[6]);
	ProcessingIndexLabel7->Caption = IntToStr(PCTabletInfo.ProcessingTabletListIndex[6]);

  NextCaptureIndexLabel8->Caption = IntToStr(PCTabletInfo.NextCaptureListIndex[7]);
	NumberingIndexLabel8->Caption = IntToStr(PCTabletInfo.NumberingCaptureListIndex[7]);
	PollingCaptureIndexLabel8->Caption = IntToStr(PCTabletInfo.PollingCaptureListIndex[7]);
	ProcessingIndexLabel8->Caption = IntToStr(PCTabletInfo.ProcessingTabletListIndex[7]);	
}
//---------------------------------------------------------------------------

void __fastcall TInspectionStatusForm::SPBSpeedButton1Click(
      TObject *Sender)
{
  TTntSpeedButton *theSpeedButton = (TTntSpeedButton *) Sender;
  StatusBoardIndex = theSpeedButton->Tag;
}
//---------------------------------------------------------------------------

void __fastcall TInspectionStatusForm::TntButton1Click(TObject *Sender)
{
  TLogViewerForm *logViewerForm = new TLogViewerForm(this);
	logViewerForm->ShowModal();
	delete logViewerForm;  
}
//---------------------------------------------------------------------------


void __fastcall TInspectionStatusForm::BitBtn1Click(TObject *Sender)
{
  int buff;

    buff = StrToInt(Edit2->Text);

		Comm_Request(COMM_HCB, CMD_VIRTUAL_INSPECTION_REFRESH, &buff, sizeof(int));
}
//---------------------------------------------------------------------------

void __fastcall TInspectionStatusForm::Timer1Timer(TObject *Sender)
{
  bool timerEnabled;
  timerEnabled = Timer1->Enabled;
  Timer1->Enabled = false;

  unsigned int printMatchingResult1[512][3];
  unsigned int printMatchingResult2[512][3];

  if(SpeedButton1->Down)
  {
    PrintResultStringGrid->Cells[0][0] = "Num.";
    PrintResultStringGrid->Cells[1][0] = "HCB Result";
    PrintResultStringGrid->Cells[2][0] = "Fst SPB Print SW";
    PrintResultStringGrid->Cells[3][0] = "Fst SPB Print Type";
    PrintResultStringGrid->Cells[4][0] = "Sec SPB Print SW";
    PrintResultStringGrid->Cells[5][0] = "Sec SPB Print Type";

    PrintResultStringGrid->ColWidths[0] = 100;
    PrintResultStringGrid->ColWidths[1] = 100;
    PrintResultStringGrid->ColWidths[2] = 100;
    PrintResultStringGrid->ColWidths[3] = 100;
    PrintResultStringGrid->ColWidths[4] = 100;
    PrintResultStringGrid->ColWidths[5] = 100;
 
    int smallData = 1;
    int twoDspbIndex;
    int threeDspbIndex;

    twoDspbIndex = CameraMapInfo[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1].SPBIndex;
    threeDspbIndex = CameraMapInfo[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].SPBIndex;

    if (Comm_IsConnected(COMM_SPB + twoDspbIndex))
		{
			if (!Comm_Request(COMM_SPB + twoDspbIndex, CMD_TABLET_PROCESS_INFO, &smallData, sizeof(int),
				&(SPBTabletProcessInfo[twoDspbIndex]), sizeof(TSPBTabletProcessInfo)))
			{
				timerEnabled = false;
        SpeedButton2->Down = true;
			}
		}

    if (Comm_IsConnected(COMM_SPB + threeDspbIndex))
		{
			if (!Comm_Request(COMM_SPB + threeDspbIndex, CMD_TABLET_PROCESS_INFO, &smallData, sizeof(int),
				&(SPBTabletProcessInfo[threeDspbIndex]), sizeof(TSPBTabletProcessInfo)))
			{
				timerEnabled = false;
        SpeedButton2->Down = true;
			}
		}

    twoDspbIndex = CameraMapInfo[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1].SPBIndex;
    threeDspbIndex = CameraMapInfo[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].SPBIndex;

    if (Comm_IsConnected(COMM_SPB + twoDspbIndex))
		{
			if (!Comm_Request(COMM_SPB + twoDspbIndex, CMD_TABLET_PROCESS_INFO, &smallData, sizeof(int),
				&(SPBTabletProcessInfo[twoDspbIndex]), sizeof(TSPBTabletProcessInfo)))
			{
				timerEnabled = false;
        SpeedButton2->Down = true;
			}
		}

    if (Comm_IsConnected(COMM_SPB + threeDspbIndex))
		{
			if (!Comm_Request(COMM_SPB + threeDspbIndex, CMD_TABLET_PROCESS_INFO, &smallData, sizeof(int),
				&(SPBTabletProcessInfo[threeDspbIndex]), sizeof(TSPBTabletProcessInfo)))
			{
				timerEnabled = false;
        SpeedButton2->Down = true;
			}
		}

    for (int tabletTableIndex = 0; tabletTableIndex < HCB_TABLET_LIST_COUNT; tabletTableIndex++)
    {
      THCBDisk2TabletUnit *hcbDisk2TabletUnit = &HCBTabletInfo.Disk2TabletList[tabletTableIndex];
      TPCTabletUnit *pcTabletUnit = &TabletList[tabletTableIndex];

      pcTabletUnit->TabletNumber = hcbDisk2TabletUnit->TabletNumber;
      pcTabletUnit->InspectionResult = hcbDisk2TabletUnit->InspectionResult;
      for (int spbIndex = 0; spbIndex < MachineSetupData.IPB_BoardCount; spbIndex++)
      {
        pcTabletUnit->InspectionResult_SPB[spbIndex] = hcbDisk2TabletUnit->InspectionResult_SPB[spbIndex];
      }
      pcTabletUnit->HCBState = hcbDisk2TabletUnit->State;
      pcTabletUnit->Sensor1Time = hcbDisk2TabletUnit->Sensor1Time;
      pcTabletUnit->Sensor1Length = hcbDisk2TabletUnit->Sensor1Length;
      pcTabletUnit->EstimatedSensor2Time = hcbDisk2TabletUnit->EstimatedSensor2Time;
      pcTabletUnit->Sensor2Time = hcbDisk2TabletUnit->Sensor2Time;
      pcTabletUnit->Sensor2Length = hcbDisk2TabletUnit->Sensor2Length;
      for (int captureIndex = 0; captureIndex < SYSTEM_MACHINE_CAPTURE_COUNT; captureIndex++)
      {
        pcTabletUnit->IsLEDOn[captureIndex] = hcbDisk2TabletUnit->IsLEDOn[captureIndex];
      }

      if(pcTabletUnit->InspectionResult == TABLET_RESULT_DEFECT_UNPRINT)
      {
        bool existSW = false;
        for(int i = 1; i < PrintResultStringGrid->RowCount; i++)
        {
          if(PrintResultStringGrid->Cells[0][i])
          {
            int tempNum = StrToInt(PrintResultStringGrid->Cells[0][i]);

            if(tempNum == pcTabletUnit->TabletNumber)
            {
              existSW = true;
              break;
            }
          }
        }

        if(existSW) continue;

        PrintResultStringGrid->Cells[0][PrintResultStringGrid->RowCount - 1] = IntToStr(pcTabletUnit->TabletNumber);
        PrintResultStringGrid->Cells[1][PrintResultStringGrid->RowCount - 1] = "PRINT DEFECT";

        int checkCameraNum;
        if(ProductData.EngraveType == ENGRAVE_TYPE_PRINT)
        {
          checkCameraNum = CameraMapInfo[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1].CamIndex;
        }
        else
        {
          checkCameraNum = CameraMapInfo[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].CamIndex;
        }
        
        AnsiString ExistPrint, PrintNumber;

        twoDspbIndex = CameraMapInfo[SD1_2D_FRONT_FACE_CAMERA_INDEX - 1].SPBIndex;
        threeDspbIndex = CameraMapInfo[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].SPBIndex;
    
        ExistPrint = "NONE";
        PrintNumber = "NONE";
        for (int tabletTableIndex = 0; tabletTableIndex < SPB_TABLET_LIST_COUNT; tabletTableIndex++)
				{
          if(pcTabletUnit->TabletNumber == SPBTabletProcessInfo[twoDspbIndex].TabletList[tabletTableIndex].TabletNumber &&
              pcTabletUnit->TabletNumber == SPBTabletProcessInfo[threeDspbIndex].TabletList[tabletTableIndex].TabletNumber)
          {
            int printResult;
            int printType;

            if(twoDspbIndex != threeDspbIndex)
            {
              printResult = SPBTabletProcessInfo[twoDspbIndex].TabletList[tabletTableIndex].PrintResult[checkCameraNum] | SPBTabletProcessInfo[threeDspbIndex].TabletList[tabletTableIndex].PrintResult[checkCameraNum];
              printType = SPBTabletProcessInfo[twoDspbIndex].TabletList[tabletTableIndex].PrintType[checkCameraNum] | SPBTabletProcessInfo[threeDspbIndex].TabletList[tabletTableIndex].PrintType[checkCameraNum];
            }
            else
            {
              printResult = SPBTabletProcessInfo[twoDspbIndex].TabletList[tabletTableIndex].PrintResult[checkCameraNum];
              printType = SPBTabletProcessInfo[twoDspbIndex].TabletList[tabletTableIndex].PrintType[checkCameraNum];
            }

            if(printResult)
            {
              ExistPrint = "Exist";
            }
            else
            {
              ExistPrint = "X";
            }

            if(printType == 0)
            {
              PrintNumber = "1";
            }
            else if(printType == 1)
            {
              PrintNumber = "2";
            }

            break;
          }
        }

        PrintResultStringGrid->Cells[2][PrintResultStringGrid->RowCount - 1] = ExistPrint;
        PrintResultStringGrid->Cells[3][PrintResultStringGrid->RowCount - 1] = PrintNumber;

        if(ProductData.EngraveType == ENGRAVE_TYPE_PRINT)
        {
          checkCameraNum = CameraMapInfo[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1].CamIndex;
        }
        else
        {
          checkCameraNum = CameraMapInfo[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].CamIndex;
        }

        twoDspbIndex = CameraMapInfo[SD2_2D_FRONT_FACE_CAMERA_INDEX - 1].SPBIndex;
        threeDspbIndex = CameraMapInfo[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].SPBIndex;
        ExistPrint = "NONE";
        PrintNumber = "NONE";
        for (int tabletTableIndex = 0; tabletTableIndex < SPB_TABLET_LIST_COUNT; tabletTableIndex++)
				{
          if(pcTabletUnit->TabletNumber == SPBTabletProcessInfo[twoDspbIndex].TabletList[tabletTableIndex].TabletNumber &&
              pcTabletUnit->TabletNumber == SPBTabletProcessInfo[threeDspbIndex].TabletList[tabletTableIndex].TabletNumber)
          {
            int printResult;
            int printType;

            if(twoDspbIndex != threeDspbIndex)
            {
              printResult = SPBTabletProcessInfo[twoDspbIndex].TabletList[tabletTableIndex].PrintResult[checkCameraNum] | SPBTabletProcessInfo[threeDspbIndex].TabletList[tabletTableIndex].PrintResult[checkCameraNum];
              printType = SPBTabletProcessInfo[twoDspbIndex].TabletList[tabletTableIndex].PrintType[checkCameraNum] | SPBTabletProcessInfo[threeDspbIndex].TabletList[tabletTableIndex].PrintType[checkCameraNum];
            }
            else
            {
              printResult = SPBTabletProcessInfo[twoDspbIndex].TabletList[tabletTableIndex].PrintResult[checkCameraNum];
              printType = SPBTabletProcessInfo[twoDspbIndex].TabletList[tabletTableIndex].PrintType[checkCameraNum];
            }

            if(printResult)
            {
              ExistPrint = "Exist";
            }
            else
            {
              ExistPrint = "X";
            }

            if(printType == 0)
            {
              PrintNumber = "1";
            }
            else if(printType == 1)
            {
              PrintNumber = "2";
            }

            break;
          }
        }

        PrintResultStringGrid->Cells[4][PrintResultStringGrid->RowCount - 1] = ExistPrint;
        PrintResultStringGrid->Cells[5][PrintResultStringGrid->RowCount - 1] = PrintNumber;

        PrintResultStringGrid->RowCount++;
      }
    }

    spbPrintResultStringGrid1->Cells[0][0] = "Num.";
    spbPrintResultStringGrid1->Cells[1][0] = "Fst SPB Print SW";
    spbPrintResultStringGrid1->Cells[2][0] = "Fst SPB Print Type";
    spbPrintResultStringGrid1->ColWidths[0] = 100;
    spbPrintResultStringGrid1->ColWidths[1] = 100;
    spbPrintResultStringGrid1->ColWidths[2] = 100;

    spbPrintResultStringGrid2->Cells[0][0] = "Num.";
    spbPrintResultStringGrid2->Cells[1][0] = "Sec SPB Print SW";
    spbPrintResultStringGrid2->Cells[2][0] = "Sec SPB Print Type";
    spbPrintResultStringGrid2->ColWidths[0] = 100;
    spbPrintResultStringGrid2->ColWidths[1] = 100;
    spbPrintResultStringGrid2->ColWidths[2] = 100;

    if(CheckBox1->Checked)
    {
      threeDspbIndex = CameraMapInfo[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].SPBIndex;
      if (Comm_IsConnected(COMM_SPB + threeDspbIndex))
      {
        if (!Comm_Request(COMM_SPB + threeDspbIndex, CMD_GET_SPB_PRINT_RESULT, &smallData, sizeof(int), printMatchingResult1, sizeof(unsigned int) * 512 * 3))
        {
          timerEnabled = false;
          SpeedButton2->Down = true;
        }
      }

      threeDspbIndex = CameraMapInfo[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].SPBIndex;
      if (Comm_IsConnected(COMM_SPB + threeDspbIndex))
      {
        if (!Comm_Request(COMM_SPB + threeDspbIndex, CMD_GET_SPB_PRINT_RESULT, &smallData, sizeof(int), printMatchingResult2, sizeof(unsigned int) * 512 * 3))
        {
          timerEnabled = false;
          SpeedButton2->Down = true;
        }
      }

      for(int resultListIndex = 0; resultListIndex < 512; resultListIndex++)
      {
        if(CheckBox2->Checked)
        {
          if(printMatchingResult1[resultListIndex][0] != 0 && printMatchingResult2[resultListIndex][1] != 0)
          {
            if(printMatchingResult1[resultListIndex][0] == printMatchingResult2[resultListIndex][0])
            {
              if(printMatchingResult1[resultListIndex][1] && printMatchingResult2[resultListIndex][1])
              {
                if(printMatchingResult1[resultListIndex][2] == printMatchingResult2[resultListIndex][2])
                {
                  spbPrintResultStringGrid1->Cells[0][resultListIndex + 1] = IntToStr(printMatchingResult1[resultListIndex][0]);
                  spbPrintResultStringGrid2->Cells[0][resultListIndex + 1] = IntToStr(printMatchingResult2[resultListIndex][0]);

                  if(printMatchingResult1[resultListIndex][1] == 2)
                  {
                    spbPrintResultStringGrid1->Cells[1][resultListIndex + 1] = "EXIST";
                  }
                  else
                  {
                    spbPrintResultStringGrid1->Cells[1][resultListIndex + 1] = "X";
                  }

                  if(printMatchingResult1[resultListIndex][2] == 2)
                  {
                    spbPrintResultStringGrid1->Cells[2][resultListIndex + 1] = "2";
                  }
                  else if(printMatchingResult1[resultListIndex][2] == 1)
                  {
                    spbPrintResultStringGrid1->Cells[2][resultListIndex + 1] = "1";
                  }
                  else
                  {
                    spbPrintResultStringGrid1->Cells[2][resultListIndex + 1] = "N/A";
                  }

                  if(printMatchingResult2[resultListIndex][1] == 2)
                  {
                    spbPrintResultStringGrid2->Cells[1][resultListIndex + 1] = "EXIST";
                  }
                  else
                  {
                    spbPrintResultStringGrid2->Cells[1][resultListIndex + 1] = "X";
                  }

                  if(printMatchingResult2[resultListIndex][2] == 2)
                  {
                    spbPrintResultStringGrid2->Cells[2][resultListIndex + 1] = "2";
                  }
                  else if(printMatchingResult2[resultListIndex][2] == 1)
                  {
                    spbPrintResultStringGrid2->Cells[2][resultListIndex + 1] = "1";
                  }
                  else
                  {
                    spbPrintResultStringGrid2->Cells[2][resultListIndex + 1] = "N/A";
                  }
                }
              }
            }
          }
        }
        else
        {
          if(printMatchingResult1[resultListIndex][0] != 0 && printMatchingResult2[resultListIndex][1] != 0)
          {
            spbPrintResultStringGrid1->Cells[0][resultListIndex + 1] = IntToStr(printMatchingResult1[resultListIndex][0]);
            spbPrintResultStringGrid2->Cells[0][resultListIndex + 1] = IntToStr(printMatchingResult2[resultListIndex][0]);

            if(printMatchingResult1[resultListIndex][1] == 2)
            {
              spbPrintResultStringGrid1->Cells[1][resultListIndex + 1] = "EXIST";
            }
            else
            {
              spbPrintResultStringGrid1->Cells[1][resultListIndex + 1] = "X";
            }

            if(printMatchingResult1[resultListIndex][2] == 2)
            {
              spbPrintResultStringGrid1->Cells[2][resultListIndex + 1] = "2";
            }
            else if(printMatchingResult1[resultListIndex][2] == 1)
            {
              spbPrintResultStringGrid1->Cells[2][resultListIndex + 1] = "1";
            }
            else
            {
              spbPrintResultStringGrid1->Cells[2][resultListIndex + 1] = "N/A";
            }

            if(printMatchingResult2[resultListIndex][1] == 2)
            {
              spbPrintResultStringGrid2->Cells[1][resultListIndex + 1] = "EXIST";
            }
            else
            {
              spbPrintResultStringGrid2->Cells[1][resultListIndex + 1] = "X";
            }

            if(printMatchingResult2[resultListIndex][2] == 2)
            {
              spbPrintResultStringGrid2->Cells[2][resultListIndex + 1] = "2";
            }
            else if(printMatchingResult2[resultListIndex][2] == 1)
            {
              spbPrintResultStringGrid2->Cells[2][resultListIndex + 1] = "1";
            }
            else
            {
              spbPrintResultStringGrid2->Cells[2][resultListIndex + 1] = "N/A";
            }
          }
        }
      }
    }
  }

  Timer1->Enabled = timerEnabled;
}
//---------------------------------------------------------------------------

void __fastcall TInspectionStatusForm::SpeedButton1Click(TObject *Sender)
{
  Timer1->Enabled = true;
}
//---------------------------------------------------------------------------

void __fastcall TInspectionStatusForm::SpeedButton2Click(TObject *Sender)
{
  Timer1->Enabled = false;
}
//---------------------------------------------------------------------------

void __fastcall TInspectionStatusForm::CheckBox2Click(TObject *Sender)
{
  if(CheckBox2->Checked)
  {
    for(int resultListIndex = 0; resultListIndex < 512; resultListIndex++)
    {
      spbPrintResultStringGrid1->Cells[0][resultListIndex + 1] = "";
      spbPrintResultStringGrid1->Cells[1][resultListIndex + 1] = "";
      spbPrintResultStringGrid1->Cells[2][resultListIndex + 1] = "";

      spbPrintResultStringGrid2->Cells[0][resultListIndex + 1] = "";
      spbPrintResultStringGrid2->Cells[1][resultListIndex + 1] = "";
      spbPrintResultStringGrid2->Cells[2][resultListIndex + 1] = "";
    }
  }  
}
//---------------------------------------------------------------------------

void __fastcall TInspectionStatusForm::TntFormActivate(TObject *Sender)
{
  SetScreenPosition(this);
}
//---------------------------------------------------------------------------

