//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Keyboard_Form.h"
#include "MultiLanguage.h"
#include "Environment.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"

TKeyboardForm *KeyboardForm;
//---------------------------------------------------------------------------
__fastcall TKeyboardForm::TKeyboardForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  int WindowsOSLanID = GetUserDefaultUILanguage();
    
  if(DefaultLCID == LANGUAGE_ID_KOREAN && WindowsOSLanID == LANGUAGE_ID_KOREAN)
    HangulSpeedButton->Visible = true;
  else
    HangulSpeedButton->Visible = false;

  if(DefaultLCID == 1041)
  {
    //SetJapanKataType();
    //CLockSpeedButton->Visible = false;
    //LShiftSpeedButton->Visible = false;
  }


	FirstKeyButtonList = new TList;
  SecondKeyButtonList = new TList;
  ThirdKeyButtonList = new TList;
  FourthKeyButtonList = new TList;
  FifthKeyButtonList = new TList;
	FIsHangulMode = false;
  ShiftDown = false;
	CompLock = false;
	CapsLock = false;
	CreateKeyButtons();
  SetKeyValues();
	ArrangeKeyButtons();
  CompBufSize = 0;
  OldEditString = "";

  FAEdit = new TFAEdit(this);
  FAEdit->Parent = Panel2;
  FAEdit->Color = clBlack;
  FAEdit->Font->Color = clYellow;
  FAEdit->Font->Size = 25;
  FAEdit->Left = 24;
  FAEdit->Top = 16;
  FAEdit->Height = 45;
  FAEdit->Width = 800;
  FAEdit->OnKeyPress = InputEditKeyPress;
  
  // kskim
  m_nFormClientWidth = this->ClientWidth;
  m_nFormClientHeight = this->ClientHeight;
  // kskim

}
//---------------------------------------------------------------------------
void __fastcall TKeyboardForm::SetWindowsKeyboard()
{
  //ShellExecute(NULL, "open", "OSK.exe", NULL, NULL, SW_SHOW);
}
//---------------------------------------------------------------------------
void __fastcall TKeyboardForm::CreateKeyButtons(void)
{
  ESCSpeedButton->Tag = VK_ESCAPE;
  ESCSpeedButton->OnClick = KeyButtonClick;
  SpaceBarSpeedButton->Tag = VK_SPACE;
  SpaceBarSpeedButton->OnClick = KeyButtonClick;
  HangulSpeedButton->Tag = VK_HANGUL;
  HangulSpeedButton->OnClick = KeyButtonClick;
  EnterSpeedButton->Tag = VK_RETURN;
	EnterSpeedButton->OnClick = KeyButtonClick;
	CLockSpeedButton->Tag = VK_CAPITAL;
	CLockSpeedButton->OnClick = KeyButtonClick;
  LShiftSpeedButton->Tag = VK_SHIFT;
  LShiftSpeedButton->OnClick = KeyButtonClick;

	for (int keyIndex = 0; keyIndex < 10; keyIndex++)
  {
		TTntSpeedButton *aSpeedButton = (TTntSpeedButton *)FindComponent("KeypadSpeedButton_" + IntToStr(keyIndex));
		aSpeedButton->Tag = '0' + keyIndex;
    aSpeedButton->OnClick = KeyButtonClick;
  }
  
  KeypadSpeedButton_Dot->Tag = VK_OEM_PERIOD;
  KeypadSpeedButton_Dot->OnClick = KeyButtonClick;
  KeypadSpeedButton_Esc->Tag = VK_ESCAPE;
  KeypadSpeedButton_Esc->OnClick = KeyButtonClick;
  KeypadSpeedButton_Enter->Tag = VK_RETURN;
  KeypadSpeedButton_Enter->OnClick = KeyButtonClick;
  KeypadSpeedButton_Back->Tag = VK_BACK;
  KeypadSpeedButton_Back->OnClick = KeyButtonClick;

	for (int keyIndex = 0; keyIndex < 15; keyIndex++)
    {
    	TTntSpeedButton *aSpeedButton = new TTntSpeedButton(this);
        aSpeedButton->Parent = KeyBoardPanel;
        aSpeedButton->OnClick = KeyButtonClick;
//        aSpeedButton->OnMouseDown = KeyButtonMouseDown;
        FirstKeyButtonList->Add(aSpeedButton);
    }
	for (int keyIndex = 0; keyIndex < 12; keyIndex++)
    {
    	TTntSpeedButton *aSpeedButton = new TTntSpeedButton(this);
        aSpeedButton->Parent = KeyBoardPanel;
        aSpeedButton->OnClick = KeyButtonClick;
//        aSpeedButton->OnMouseDown = KeyButtonMouseDown;
        SecondKeyButtonList->Add(aSpeedButton);
    }
	for (int keyIndex = 0; keyIndex < 11; keyIndex++)
    {
    	TTntSpeedButton *aSpeedButton = new TTntSpeedButton(this);
        aSpeedButton->Parent = KeyBoardPanel;
        aSpeedButton->OnClick = KeyButtonClick;
		if (keyIndex == 3 || keyIndex == 6)
        {
        	aSpeedButton->Font->Color = clBlue;
        }
        
        ThirdKeyButtonList->Add(aSpeedButton);
    }
	for (int keyIndex = 0; keyIndex < 10; keyIndex++)
    {
    	TTntSpeedButton *aSpeedButton = new TTntSpeedButton(this);
        aSpeedButton->Parent = KeyBoardPanel;
        aSpeedButton->OnClick = KeyButtonClick;
        FourthKeyButtonList->Add(aSpeedButton);
    }
}
//---------------------------------------------------------------------------
void __fastcall TKeyboardForm::SetKeyValues(void)
{
  if(HangulSpeedButton->Visible == false)
  {
    HWND hWnd = InputEdit->Handle;
    SetImeMode(hWnd,imSAlpha);
  }
  
	unsigned char firstKeyValue[] = {VK_OEM_3, '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', VK_OEM_MINUS, VK_OEM_PLUS, VK_OEM_5, VK_BACK};
	WideString fisrtKeyStr[] = {"`", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", "=", "\\", "<-"};
	WideString fisrtKeyHangulStr[] = {"`", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", "=", "\\", "<-"};
  //WCHAR fisrtKeyJPStr[] = {0x30ED, 0x30CC, 0x30D5, 0x30A2, 0x30A6, 0x30A8,0x30AA,0x30E4,0x30E6, 0x30E8,0x30EF,0x30DB, 0x30D8,0x30E0,0x2190};

//    unsigned char firstKeyShiftValue[] = {VK_OEM_3, '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', VK_OEM_MINUS, VK_OEM_PLUS, VK_OEM_5, VK_BACK};
	WideString fisrtKeyShiftStr[] = {"~", "!", "@", "#", "$", "%", "^", "&&", "*", "(", ")", "_", "+", "|", "<-"};
	WideString fisrtKeyCLockStr[] = {"`", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-", "=", "\\", "<-"};
	WideString fisrtKeyHangulShiftStr[] = {"~", "!", "@", "#", "$", "%", "^", "&&", "*", "(", ")", "_", "+", "|", "<-"};
  //WCHAR fisrtKeyJPShiftStr[] = {0x30ED, 0x30CC, 0x30D5, 0x30A1, 0x30A5, 0x30A7,0x30A9,0x30E3,0x30E5, 0x30E7,0x30F2,0x30FC, 0x30D8,0x30E0,0x2190};

	unsigned char secondKeyValue[] = {'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', VK_OEM_4, VK_OEM_6};
	WideString secondKeyStr[] = {"q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "[", "]"};
	WideString secondKeyHangulStr[] = {"", "", "", "", "", "", "", "", "", "", "[", "]"};
  //WCHAR secondKeyJPStr[] = {0x30BF, 0x30C6, 0x30A4, 0x30B9, 0x30AB, 0x30BD, 0x30CA, 0x30CB, 0x30E9, 0x30BB, 0x301D, 0x309C};
     
	WideString secondKeyShiftStr[] = {"Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "{", "}"};
	WideString secondKeyCLockStr[] = {"Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "[", "]"};
  WideString secondKeyHangulShiftStr[] = {"", "", "", "", "", "", "", "", "", "", "{", "}"};
  //WCHAR secondKeyJPShiftStr[] = {0x30BF, 0x30C6, 0x30A4, 0x30B9, 0x30AB, 0x30BD, 0x30CA, 0x30CB, 0x30E9, 0x30BB, 0x300C, 0x300D};

  unsigned char thirdKeyValue[] = {'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', VK_OEM_1, VK_OEM_7};
  WideString thirdKeyStr[] = {"a", "s", "d", "f", "g", "h", "j", "k", "l", ";", "'"};
  WideString thirdKeyHangulStr[] = {"", "", "", "", "", "", "", "", "", ";", "'"};
  //WCHAR thirdKeyJPStr[] = {0x30C1, 0x30C8, 0x30C4, 0x30CF, 0x30AD, 0x30AF, 0x30DE, 0x30CE, 0x30EA, 0x30EC, 0x30B1};

	WideString thirdKeyShiftStr[] = {"A", "S", "D", "F", "G", "H", "J", "K", "L", ":", "\""};
	WideString thirdKeyCLockStr[] = {"A", "S", "D", "F", "G", "H", "J", "K", "L", ";", "'"};
	WideString thirdKeyHangulShiftStr[] = {"", "", "", "", "", "", "", "", "", ":", "\""};
  //WCHAR thirdKeyJPShiftStr[] = {0x30C1, 0x30C8, 0x30C4, 0x30CF, 0x30AD, 0x30AF, 0x30DE, 0x30CE, 0x30EA, 0x30EC, 0x30B1};

	unsigned char fourthKeyValue[] = {'Z', 'X', 'C', 'V', 'B', 'N', 'M', VK_OEM_COMMA, VK_OEM_PERIOD, VK_OEM_2};
	WideString fourthKeyStr[] = {"z", "x", "c", "v", "b", "n", "m", ",", ".", "/"};
	WideString fourthKeyHangulStr[] = {"", "", "", "", "", "", "", ",", ".", "/"};
  //WCHAR fourthKeyJPStr[] = {0x30C4,0x30B5, 0x30BD, 0x30D2, 0x30B3, 0x30DF, 0x30E2, 0x30CD, 0x30EB, 0x30E1};

	WideString fourthKeyShiftStr[] = {"Z", "X", "C", "V", "B", "N", "M", "<", ">", "?"};
	WideString fourthKeyCLockStr[] = {"Z", "X", "C", "V", "B", "N", "M", ",", ".", "/"};
	WideString fourthKeyHangulShiftStr[] = {"", "", "", "", "", "", "", "<", ">", "?"};
  //WCHAR fourthKeyJPShiftStr[] = {0x30C3, 0x30B5, 0x30BD, 0x30D2, 0x30B3, 0x30DF, 0x30E2, 0x2F4, 0x3002, 0x30FB};


	for (int keyIndex = 0; keyIndex < FirstKeyButtonList->Count; keyIndex++)
  {
      TTntSpeedButton *aSpeedButton = (TTntSpeedButton *) FirstKeyButtonList->Items[keyIndex];
          aSpeedButton->Tag = firstKeyValue[keyIndex];
      if (!FIsHangulMode)
      {
          if (CapsLock && !ShiftDown)
          {
            aSpeedButton->Caption = fisrtKeyCLockStr[keyIndex];
          }
          else if (!ShiftDown || (CapsLock && ShiftDown))
          {
            aSpeedButton->Caption = fisrtKeyStr[keyIndex];
          }
          else
          {
            aSpeedButton->Caption = fisrtKeyShiftStr[keyIndex];
          }
      }
      else
      {
        if (!ShiftDown)
        {
          aSpeedButton->Caption = fisrtKeyHangulStr[keyIndex];
        }
        else
        {
          aSpeedButton->Caption = fisrtKeyHangulShiftStr[keyIndex];
        }
      }
  }

	for (int keyIndex = 0; keyIndex < SecondKeyButtonList->Count; keyIndex++)
  {
    TTntSpeedButton *aSpeedButton = (TTntSpeedButton *) SecondKeyButtonList->Items[keyIndex];
        aSpeedButton->Tag = secondKeyValue[keyIndex];
    if (!FIsHangulMode)
    {
        if (CapsLock && !ShiftDown)
        {
          aSpeedButton->Caption = secondKeyCLockStr[keyIndex];
        }
        else if (!ShiftDown || (CapsLock && ShiftDown))
        {
          aSpeedButton->Caption = secondKeyStr[keyIndex];
        }
        else
        {
          aSpeedButton->Caption = secondKeyShiftStr[keyIndex];
        }
    }
    else
    {
      if (!ShiftDown)
      {
        aSpeedButton->Caption = secondKeyHangulStr[keyIndex];
      }
      else
      {
        aSpeedButton->Caption = secondKeyHangulShiftStr[keyIndex];
      }
    }
  }

	for (int keyIndex = 0; keyIndex < ThirdKeyButtonList->Count; keyIndex++)
  {
		TTntSpeedButton *aSpeedButton = (TTntSpeedButton *) ThirdKeyButtonList->Items[keyIndex];
        aSpeedButton->Tag = thirdKeyValue[keyIndex];
		if (!FIsHangulMode)
		{
        if (CapsLock && !ShiftDown)
        {
          aSpeedButton->Caption = thirdKeyCLockStr[keyIndex];
        }
        else if (!ShiftDown || (CapsLock && ShiftDown))
        {
          aSpeedButton->Caption = thirdKeyStr[keyIndex];
        }
        else
        {
          aSpeedButton->Caption = thirdKeyShiftStr[keyIndex];
        }
		}
		else
		{
			if (!ShiftDown)
      {
        aSpeedButton->Caption = thirdKeyHangulStr[keyIndex];
      }
			else
      {
				aSpeedButton->Caption = thirdKeyHangulShiftStr[keyIndex];
      }
    }
  }

	for (int keyIndex = 0; keyIndex < FourthKeyButtonList->Count; keyIndex++)
  {
		TTntSpeedButton *aSpeedButton = (TTntSpeedButton *) FourthKeyButtonList->Items[keyIndex];
        aSpeedButton->Tag = fourthKeyValue[keyIndex];
    if (!FIsHangulMode)
		{
        if (CapsLock && !ShiftDown)
        {
          aSpeedButton->Caption = fourthKeyCLockStr[keyIndex];
        }
        else if (!ShiftDown || (CapsLock && ShiftDown))
        {
          aSpeedButton->Caption = fourthKeyStr[keyIndex];
        }
        else
        {
          aSpeedButton->Caption = fourthKeyShiftStr[keyIndex];
        }
    }
    else
    {
      if (!ShiftDown)
      {
		    aSpeedButton->Caption = fourthKeyHangulStr[keyIndex];
      }
      else
      {
				aSpeedButton->Caption = fourthKeyHangulShiftStr[keyIndex];
      }
		}
	}

	if (CapsLock)
	{
		CLockSpeedButton->Font->Color = clRed;
	}
	else
	{
		CLockSpeedButton->Font->Color = clBlack;
	}
}
//---------------------------------------------------------------------------
void __fastcall TKeyboardForm::ArrangeKeyButtons(void)
{
	const int START_Y_POS = 20 + 64 + 2 + 10;
    const int START_X_POS = 20;
 
	int posX = START_X_POS;
    int posY = START_Y_POS;
	for (int keyIndex = 0; keyIndex < FirstKeyButtonList->Count; keyIndex++)
    {
		TTntSpeedButton *aSpeedButton = (TTntSpeedButton *) FirstKeyButtonList->Items[keyIndex];
        aSpeedButton->Width = 64;
        aSpeedButton->Height = 64;
        aSpeedButton->Top = posY;
        aSpeedButton->Left = posX;
        posX += 66;
    }
    posY = START_Y_POS + 64 + 2;
    posX = START_X_POS + 64 + 2 + 32;
	for (int keyIndex = 0; keyIndex < SecondKeyButtonList->Count; keyIndex++)
    {
		TTntSpeedButton *aSpeedButton = (TTntSpeedButton *) SecondKeyButtonList->Items[keyIndex];
        aSpeedButton->Width = 64;
        aSpeedButton->Height = 64;
        aSpeedButton->Top = posY;
        aSpeedButton->Left = posX;
        posX += 66;
    }
    posY = START_Y_POS + 64 + 2 + 64 + 2;
	posX = START_X_POS + 64 + 2 + 64;

	CLockSpeedButton->Top = posY;
	CLockSpeedButton->Left = 20;

	for (int keyIndex = 0; keyIndex < ThirdKeyButtonList->Count; keyIndex++)
    {
		TTntSpeedButton *aSpeedButton = (TTntSpeedButton *) ThirdKeyButtonList->Items[keyIndex];
        aSpeedButton->Width = 64;
        aSpeedButton->Height = 64;
        aSpeedButton->Top = posY;
        aSpeedButton->Left = posX;
        posX += 66;
    }
    EnterSpeedButton->Top = posY;
    EnterSpeedButton->Left = posX;



    posY = START_Y_POS + 64 + 2 + 64 + 2 + 64 + 2;
    posX = START_X_POS + 64 + 2 + 96;

    LShiftSpeedButton->Top = posY;
    LShiftSpeedButton->Left = 20;
	for (int keyIndex = 0; keyIndex < FourthKeyButtonList->Count; keyIndex++)
    {
		TTntSpeedButton *aSpeedButton = (TTntSpeedButton *) FourthKeyButtonList->Items[keyIndex];
        aSpeedButton->Width = 64;
        aSpeedButton->Height = 64;
        aSpeedButton->Top = posY;
        aSpeedButton->Left = posX;
        posX += 66;
    }

    posY = START_Y_POS + 64 + 2 + 64 + 2 + 64 + 2 + 64 + 2;
    posX = START_X_POS + 64 + 2 + 128;
    SpaceBarSpeedButton->Width = 66 * 6;
    SpaceBarSpeedButton->Height = 64;
    SpaceBarSpeedButton->Top = posY;
    SpaceBarSpeedButton->Left = posX;
    posX += (SpaceBarSpeedButton->Width + 2);
    HangulSpeedButton->Width = 72;
    HangulSpeedButton->Height = 64;
    HangulSpeedButton->Top = posY;
    HangulSpeedButton->Left = posX;



}
//---------------------------------------------------------------------------
void __fastcall TKeyboardForm::KeyButtonClick(TObject *Sender)
{
	TTntSpeedButton *theSpeedButton = (TTntSpeedButton *) Sender;
	if (theSpeedButton->Tag == VK_HANGUL)
	{
		if (!IsPasswordInput)
		{
			IsHangulMode = !IsHangulMode;
			CompBufSize = 0;
			CompStr[0] = '\0';
		}
		else
		{
			return;
		}
    }

	if (theSpeedButton->Tag == VK_CAPITAL)
	{
      if (CapsLock)
      {
        CapsLock = false;
        keybd_event(VK_CAPITAL, 0, 0, 0);
        keybd_event(VK_CAPITAL, 0, KEYEVENTF_KEYUP, 0);
        SetKeyValues();
      }
      else
      {
        CapsLock = true;
        keybd_event(VK_CAPITAL, 0, 0, 0);
        keybd_event(VK_CAPITAL, 0, KEYEVENTF_KEYUP, 0);
        SetKeyValues();
      }
	}
	else if (theSpeedButton->Tag == VK_SHIFT)
    {
		if (ShiftDown)
        {
			LShiftSpeedButton->Font->Color = clBlack;
			ShiftDown = false;
            keybd_event(VK_SHIFT, 0, KEYEVENTF_KEYUP, 0);
            SetKeyValues();
        }
        else
        {
        	LShiftSpeedButton->Font->Color = clRed;
			ShiftDown = true;
			keybd_event(VK_SHIFT, 0, 0, 0);
			SetKeyValues();
        }
    }
    else
    {
//    	if (theSpeedButton->Tag != VK_ESCAPE && theSpeedButton->Tag != VK_RETURN)
        {
	    	keybd_event(theSpeedButton->Tag, 0, 0, 0);
        }
    	if (ShiftDown)
        {
        	LShiftSpeedButton->Font->Color = clBlack;
			ShiftDown = false;
            keybd_event(VK_SHIFT, 0, KEYEVENTF_KEYUP, 0);
            SetKeyValues();
        }
    }
/*
    if (theSpeedButton->Tag == VK_ESCAPE)
    {
//		ModalResult = mrCancel;
    }
    else if (theSpeedButton->Tag == VK_RETURN)
    {
    	TargetText = FAEdit->Text;
//		ModalResult = mrOk;
    }
*/

}
//---------------------------------------------------------------------------

void __fastcall TKeyboardForm::FormDestroy(TObject *Sender)
{
	// delete key button list
    while (FirstKeyButtonList->Count > 0)
    {
		TTntSpeedButton *aSpeedButton = (TTntSpeedButton *)FirstKeyButtonList->First();
        FirstKeyButtonList->Remove(aSpeedButton);
        delete aSpeedButton;
    }
    delete FirstKeyButtonList;
    while (SecondKeyButtonList->Count > 0)
    {
		TTntSpeedButton *aSpeedButton = (TTntSpeedButton *)SecondKeyButtonList->First();
        SecondKeyButtonList->Remove(aSpeedButton);
        delete aSpeedButton;
    }
    delete SecondKeyButtonList;
    while (ThirdKeyButtonList->Count > 0)
    {
		TTntSpeedButton *aSpeedButton = (TTntSpeedButton *)ThirdKeyButtonList->First();
        ThirdKeyButtonList->Remove(aSpeedButton);
        delete aSpeedButton;
    }
    delete ThirdKeyButtonList;
    while (FourthKeyButtonList->Count > 0)
    {
		TTntSpeedButton *aSpeedButton = (TTntSpeedButton *)FourthKeyButtonList->First();
        FourthKeyButtonList->Remove(aSpeedButton);
        delete aSpeedButton;
    }
    delete FourthKeyButtonList;
    while (FifthKeyButtonList->Count > 0)
    {
		TTntSpeedButton *aSpeedButton = (TTntSpeedButton *)FifthKeyButtonList->First();
        FifthKeyButtonList->Remove(aSpeedButton);
        delete aSpeedButton;
    }
    delete FifthKeyButtonList;
}
//---------------------------------------------------------------------------
void __fastcall TKeyboardForm::ImeNotify(TMessage &Message)
{
//
	InputEdit->Text = "";
}
//---------------------------------------------------------------------------
__fastcall TFAEdit::TFAEdit(TComponent* Owner) : TTntEdit(Owner)
{
	WindowProc = EditWndProc;
    bKeyDown = false;
//
}
//---------------------------------------------------------------------------
void __fastcall TFAEdit::EditWndProc(Messages::TMessage &Message)
{
	HIMC imeContext = ImmGetContext(this->Handle);

    switch(Message.Msg)
    {
        case WM_IME_ENDCOMPOSITION:
        	if (!bKeyDown)
            {
        		bufSize = ImmGetCompositionString(imeContext, GCS_RESULTSTR, CompStr, 0);
                if (bufSize > 0)
                {
					ImmGetCompositionString(imeContext, GCS_RESULTSTR, CompStr, bufSize);
                    ImmSetCompositionString(imeContext, SCS_SETSTR, CompStr, bufSize, NULL, 0);
                }
            }
            WndProc(Message);
        	break;
        case WM_KEYDOWN:
            bKeyDown = true;
        	WndProc(Message);
        	break;
        case WM_KEYUP:
        	bKeyDown = false;
        	WndProc(Message);
        	break;
        default:
		    WndProc(Message);
    }
}
//---------------------------------------------------------------------------
void __fastcall TKeyboardForm::SetText(WideString text)
{
	TargetText = text;
    FAEdit->Text = TargetText;
//    FAEdit->SelectAll();
}
//---------------------------------------------------------------------------
WideString __fastcall TKeyboardForm::GetText(void)
{
	return TargetText;
}
//---------------------------------------------------------------------------
int __fastcall TKeyboardForm::ShowKeyboard(void)
{
    // kskim - Ű  
    this->ClientWidth = m_nFormClientWidth;
    this->ClientHeight = m_nFormClientHeight;

    KeyBoardPanel->Visible = true;
    Bevel1->Visible = true;
    Bevel2->Visible = true;
    FAEdit->Width = KeyBoardPanel->Width - FAEdit->Left*2;
    FAEdit->PasswordChar = '\0';
    this->Caption = KEYBOARDFORM_MSG_01;
    this->Left = (Screen->Width - this->Width) / 2;
    this->Top = (Screen->Height - this->Height) / 2;
    IsPasswordInput = false;
    // kskim

    /* kskim close
	KeyBoardPanel->Visible = true;
    this->ClientWidth = KeyPadPanel->Width + 1040;
    this->ClientHeight = 540;
    FAEdit->Width = KeyPadPanel->Width + 1000;
	FAEdit->PasswordChar = '\0';
    this->Caption = KEYBOARDFORM_MSG_01;
    this->Left = (Screen->Width - this->Width) / 2;
    this->Top = (Screen->Height - this->Height) / 2;
    IsPasswordInput = false;
    */
//    IsHangulMode = false;
//    FAEdit->ImeMode = imSAlpha;
//    FAEdit->ImeMode = imDontCare;
    //SetKeyValues();
    //HangulSpeedButton->Visible = true;
    /*if(DefaultLCID == 1041 && JP_IDInputKeyBoard)
    {
      FIsHangulMode = false;
      IsPasswordInput = true;
    }*/
    SetKeyValues();
    FAEdit->SelectAll();
    //if(DefaultLCID == 1041) SetJapanKataType();
    
	return this->ShowModal();
}
//---------------------------------------------------------------------------
void __fastcall TKeyboardForm::HideKeyboard(void)
{
	ModalResult = mrCancel;
	Hide();
}
//---------------------------------------------------------------------------
int __fastcall TKeyboardForm::ShowPasswordKeyboard(void)
{
    // kskim - Ű  
    this->ClientWidth = m_nFormClientWidth;
    this->ClientHeight = m_nFormClientHeight;

	KeyBoardPanel->Visible = true;
    Bevel1->Visible = true;
    Bevel2->Visible = true;
	FAEdit->Width = KeyBoardPanel->Width - FAEdit->Left*2;
	FAEdit->PasswordChar = '*';
	this->Caption = KEYBOARDFORM_MSG_01;
	this->Left = (Screen->Width - this->Width) / 2;
	this->Top = (Screen->Height - this->Height) / 2;
    // kskim

    /* kskim close
	KeyBoardPanel->Visible = true;
	this->ClientWidth = KeyPadPanel->Width + 1040;
	this->ClientHeight = 540;
	FAEdit->Width = KeyPadPanel->Width + 1000;
	FAEdit->PasswordChar = '*';
	this->Caption = KEYBOARDFORM_MSG_01;
	this->Left = (Screen->Width - this->Width) / 2;
	this->Top = (Screen->Height - this->Height) / 2;
	*/
	
	bool oldHangulMode = IsHangulMode;
  bool oldHangulBtn = HangulSpeedButton->Visible;
  HangulSpeedButton->Visible = false;
	IsHangulMode = false;
	IsPasswordInput = true;

	FAEdit->SelectAll();
	int returnValue = this->ShowModal();
	IsHangulMode = oldHangulMode;
  HangulSpeedButton->Visible =  oldHangulBtn; 
	return returnValue;
}
//---------------------------------------------------------------------------
int __fastcall TKeyboardForm::ShowKeypad(void)
{
    // kskim -Űе  
    KeyBoardPanel->Visible = false;
    Bevel1->Visible = false;
    Bevel2->Visible = false;
    this->ClientWidth = KeyPadPanel->Width;
    this->ClientHeight = 410;
    FAEdit->Width = this->ClientWidth - FAEdit->Left*2;
    // kskim

    /* kskim close
	KeyBoardPanel->Visible = false;
    this->ClientWidth = KeyPadPanel->Width;
    this->ClientHeight = 480;
    FAEdit->Width = KeyPadPanel->Width - 40;
    */

    FAEdit->PasswordChar = '\0';
    this->Caption = KEYBOARDFORM_MSG_02;
    this->Left = (Screen->Width - this->Width) / 2;
    this->Top = (Screen->Height - this->Height) / 2;
    IsPasswordInput = false;
//    IsHangulMode = false;
//    FAEdit->ImeMode = imSAlpha;
//    FAEdit->ImeMode = imDontCare;
//    SetKeyValues();
    FAEdit->SelectAll();
  //if(DefaultLCID == 1041)
    //SetJapanKataType();
	return this->ShowModal();
}
//---------------------------------------------------------------------------
void __fastcall TKeyboardForm::InputEditKeyPress(TObject *Sender,
	  char &Key)
{
	if (Key == VK_RETURN)
	{
		TargetText = FAEdit->Text;
		ModalResult = mrOk;
    UserGradeEditMode = false;
	}
	else if (Key == VK_ESCAPE)
	{
		ModalResult = mrCancel;
    UserGradeEditMode = false;
	}
}

//---------------------------------------------------------------------------
void __fastcall TKeyboardForm::SetIsHangulMode(bool value)
{
  if(IsPasswordInput)
  {
    FIsHangulMode = false;
  }
  else
  	FIsHangulMode = value;
	SetKeyValues();
}
//---------------------------------------------------------------------------
void __fastcall TKeyboardForm::SetCapsLock(bool value)
{
	CapsLock = value;
	SetKeyValues();
}
//---------------------------------------------------------------------------
void __fastcall TKeyboardForm::SetJapanKataType(void)
{
    // Set window japanese IME kata
    // japanese KATAKANA
    // ⺻ Ϻ Ű Է±Ⱑ Ȱȭ Ǿ ־ Ѵ .

    /*DWORD dwConv, dwSent;

    HWND hWnd = InputEdit->Handle;
    HWND hWnd = ImmGetContext(InputEdit->Handle);
    ImmGetConversionStatus(hWnd, &dwConv, &dwSent);
    
    if (ImmGetOpenStatus(hWnd))
    {
      ImmSetOpenStatus(hWnd, FALSE);
    }
    else
    {
      ImmSetOpenStatus(hWnd, TRUE);
    }

    if(ImmSetConversionStatus(hWnd, IME_CMODE_NATIVE | IME_CMODE_KATAKANA,dwSent)==0)
      ShowMessage("dd");
    
    ImmSetOpenStatus(hWnd,0);
    ImmReleaseContext(hWnd,0); */


    HWND hWnd = InputEdit->Handle;
    SetImeMode(hWnd,imKata);

    keybd_event(VK_MENU, 0, 0, 0);
    keybd_event(VK_CAPITAL, 0, 0, 0);

		keybd_event(VK_CAPITAL, 0, KEYEVENTF_KEYUP, 0);
    keybd_event(VK_MENU, 0, KEYEVENTF_KEYUP, 0);
}

