//---------------------------------------------------------------------------

#ifndef Keyboard_FormH
#define Keyboard_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <ExtCtrls.hpp>
#include "TntButtons.hpp"
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
//---------------------------------------------------------------------------
class TFAEdit : public TTntEdit
{
private:
	int bufSize;
	char CompStr[16];
    bool bKeyDown;
protected:
	void __fastcall EditWndProc(Messages::TMessage &Message);
public:
	__fastcall TFAEdit(TComponent* Owner);
};
//---------------------------------------------------------------------------
class TKeyboardForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *KeyBoardPanel;
	TTntPanel *Panel2;
	TTntEdit *InputEdit;
	TTntSpeedButton *ESCSpeedButton;
	TTntSpeedButton *SpaceBarSpeedButton;
	TTntSpeedButton *HangulSpeedButton;
	TTntSpeedButton *EnterSpeedButton;
	TTntPanel *KeyPadPanel;
	TTntSpeedButton *LShiftSpeedButton;
	TTntSpeedButton *KeypadSpeedButton_7;
	TTntSpeedButton *KeypadSpeedButton_8;
	TTntSpeedButton *KeypadSpeedButton_9;
	TTntSpeedButton *KeypadSpeedButton_4;
	TTntSpeedButton *KeypadSpeedButton_5;
	TTntSpeedButton *KeypadSpeedButton_6;
	TTntSpeedButton *KeypadSpeedButton_1;
	TTntSpeedButton *KeypadSpeedButton_2;
	TTntSpeedButton *KeypadSpeedButton_3;
	TTntSpeedButton *KeypadSpeedButton_0;
	TTntSpeedButton *KeypadSpeedButton_Dot;
	TTntSpeedButton *KeypadSpeedButton_Enter;
	TTntSpeedButton *KeypadSpeedButton_Esc;
	TTntSpeedButton *KeypadSpeedButton_Back;
	TTntSpeedButton *CLockSpeedButton;
    TBevel *Bevel1;
    TBevel *Bevel2;

	void __fastcall FormDestroy(TObject *Sender);
private:	// User declarations
// kskim Ű 
        int m_nFormClientWidth;
        int m_nFormClientHeight;
// kskim

//    bool OldHangulMode;
	void __fastcall CreateKeyButtons(void);
    void __fastcall ArrangeKeyButtons(void);

    TList *FirstKeyButtonList, *SecondKeyButtonList, *ThirdKeyButtonList, *FourthKeyButtonList, *FifthKeyButtonList;
	WideString EditString;
    WideString OldEditString;
    WideString TargetText;

    TFAEdit *FAEdit;
    void __fastcall KeyButtonClick(TObject *Sender);
	void __fastcall InputEditKeyPress(TObject *Sender, char &Key);
    void __fastcall InputEditKeyUp(TObject *Sender, WORD &Key,
          TShiftState Shift);
	void __fastcall SetIsHangulMode(bool value);
	void __fastcall SetCapsLock(bool value);
protected:
//BEGIN_MESSAGE_MAP
//	MESSAGE_HANDLER(WM_PAINT, TMessage, ImeNotify)
//END_MESSAGE_MAP(TControl)
	void __fastcall EditWndProc(Messages::TMessage &Message);
	void __fastcall ImeNotify(TMessage &Message);
public:		// User declarations
	__fastcall TKeyboardForm(TComponent* Owner);
	void __fastcall SetText(WideString text);
	WideString __fastcall GetText(void);
	int __fastcall ShowKeyboard(void);
	int __fastcall ShowPasswordKeyboard(void);
	int __fastcall ShowKeypad(void);
	void __fastcall HideKeyboard(void);
  void __fastcall SetWindowsKeyboard();

	__property WideString Text = {read = GetText, write = SetText};
	__property bool IsHangulMode = {read = FIsHangulMode, write = SetIsHangulMode};
	__property bool CapsLockState = {read = CapsLock, write = SetCapsLock};

  bool CompLock;
	bool ShiftDown;
	bool CapsLock;
	bool IsPasswordInput;
	bool FIsHangulMode;
  bool UserGradeEditMode;

  char CompStr[16];
  int CompBufSize;

  void __fastcall SetKeyValues(void);
  void __fastcall SetJapanKataType(void);

  bool JP_IDInputKeyBoard;
};
//---------------------------------------------------------------------------
extern PACKAGE TKeyboardForm *KeyboardForm;
//---------------------------------------------------------------------------
#endif



