//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "LaserInspectionMarkingInfo_Form.h"
#include "Message_Form.h"
#include "Environment.h"
#include "MultiLanguage.h"
#include "Calibration_Form.h"
#include "Bayer.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TLaserInspectionMarkingInfoForm *LaserInspectionMarkingInfoForm;
//---------------------------------------------------------------------------
__fastcall TLaserInspectionMarkingInfoForm::TLaserInspectionMarkingInfoForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  Panel1->DoubleBuffered = true;

  _2D_RT_Image->Width = REALTIME_CAMERA_WIDTH;
	_2D_RT_Image->Height = REALTIME_CAMERA_HEIGHT;
	_2D_RT_Image->Picture->Bitmap->Width = REALTIME_CAMERA_WIDTH;
	_2D_RT_Image->Picture->Bitmap->Height = REALTIME_CAMERA_HEIGHT;
	_2D_RT_Image->Picture->Bitmap->PixelFormat = pf24bit;
  
  _3D_RT_Image->Width = REALTIME_CAMERA_WIDTH;
	_3D_RT_Image->Height = REALTIME_CAMERA_HEIGHT;
	_3D_RT_Image->Picture->Bitmap->Width = REALTIME_CAMERA_WIDTH;
	_3D_RT_Image->Picture->Bitmap->Height = REALTIME_CAMERA_HEIGHT;
	_3D_RT_Image->Picture->Bitmap->PixelFormat = pf24bit;
}
//---------------------------------------------------------------------------
void __fastcall TLaserInspectionMarkingInfoForm::SetImage(int FilePageNumber,int tabletNumber, AnsiString Brightness)
{
  int DataSize = REALTIME_CAMERA_WIDTH * REALTIME_CAMERA_HEIGHT;
  AnsiString dirPathName = ProgramPath.Root + "\\Laser Monitoring";
  AnsiString lmFileName2D = dirPathName + "\\Marking" + IntToStr(FilePageNumber) + "_2D.dat";
  AnsiString lmFileName3D = dirPathName + "\\Marking" + IntToStr(FilePageNumber) + "_3D.dat";
  unsigned char * ImageData = new unsigned char[REALTIME_CAMERA_WIDTH*REALTIME_CAMERA_HEIGHT];
  TFileStream *pFileStream = NULL;
  int printdata[4];

  memset(ImageData, 0, REALTIME_CAMERA_WIDTH * REALTIME_CAMERA_HEIGHT);

  TabletNumLabel->Caption = "Tablet Number : " + IntToStr(tabletNumber);

  TwoDResultLabel->Caption = "2D Result : Not exist";
  
  PrintBrightnessLabel->Caption = "Brightness : N/A";
  PrintThetaLabel->Caption = "Marking Theta : N/A";
  PrintXLabel->Caption = "Marking X : N/A";
  PrintYLabel->Caption = "Marking Y : N/A";
  
  if(FileExists(lmFileName2D))
  {
    pFileStream = new TFileStream(lmFileName2D, fmOpenRead);
    if(pFileStream)
    {
      while(true)
      {
        if(pFileStream->Position + DataSize <= pFileStream->Size)
        {
          pFileStream->Read(ImageData, sizeof(char)*(REALTIME_CAMERA_WIDTH*REALTIME_CAMERA_HEIGHT));
          if(*((int*)ImageData + 1) == tabletNumber)
          {
            Graphics::TBitmap *tempImage = new Graphics::TBitmap;
            tempImage->Width = REALTIME_CAMERA_WIDTH;
            tempImage->Height = REALTIME_CAMERA_HEIGHT;
            tempImage->PixelFormat = pf24bit;

            int cameraIndex = *((int*)ImageData + 0);

            /*
            Bayer_Conversion_GBRG(tempImage, ImageData, REALTIME_CAMERA_WIDTH, REALTIME_CAMERA_HEIGHT, 2);
	          ApplyWhiteBalance(cameraIndex - 1, tempImage, _2D_RT_Image->Picture->Bitmap);

            byte *pTempLineT = new byte[_2D_RT_Image->Picture->Bitmap->Width * 3];
            byte *pTempLineB = new byte[_2D_RT_Image->Picture->Bitmap->Width * 3];
            for (int y = 0; y < (_2D_RT_Image->Picture->Bitmap->Height + 1) / 2; y++)
            {
              byte *pBitmapT = (byte *)_2D_RT_Image->Picture->Bitmap->ScanLine[y];
              byte *pBitmapB = (byte *)_2D_RT_Image->Picture->Bitmap->ScanLine[_2D_RT_Image->Picture->Bitmap->Height - 1 - y];

              memcpy(pTempLineT, pBitmapB, _2D_RT_Image->Picture->Bitmap->Width * 3);
              memcpy(pTempLineB, pBitmapT, _2D_RT_Image->Picture->Bitmap->Width * 3);
              memcpy(pBitmapT, pTempLineT, _2D_RT_Image->Picture->Bitmap->Width * 3);
              memcpy(pBitmapB, pTempLineB, _2D_RT_Image->Picture->Bitmap->Width * 3);
            }
            delete[] pTempLineT;
            delete[] pTempLineB;
            */

            for(int y = 0; y < REALTIME_CAMERA_HEIGHT; y++)
            {
              Byte *ptr = (Byte*)_2D_RT_Image->Picture->Bitmap->ScanLine[y];
              for(int x = 0; x < REALTIME_CAMERA_WIDTH; x++)
              {
                if(y == 0 || x == 0 || y == REALTIME_CAMERA_HEIGHT - 1 || x == REALTIME_CAMERA_WIDTH - 1)
                {
                  ptr[3*x + 0] = 0;
                  ptr[3*x + 1] = 0;
                  ptr[3*x + 2] = 0;
                }
                else
                {
                  ptr[3*x + 0] = ImageData[REALTIME_CAMERA_WIDTH * y + x];
                  ptr[3*x + 1] = ImageData[REALTIME_CAMERA_WIDTH * y + x];
                  ptr[3*x + 2] = ImageData[REALTIME_CAMERA_WIDTH * y + x];
                }
              }
            }
            
            _2D_RT_Image->Repaint();

            delete tempImage;

            printdata[0] = *((int*)ImageData + 2);
            printdata[1] = *((int*)ImageData + 3);
            printdata[2] = *((int*)ImageData + 4);
            printdata[3] = *((int*)ImageData + 5);

            if(printdata[0] == 0 && printdata[1] == 0 && printdata[2] == 0 && printdata[3] == 0)
            {
              TwoDResultLabel->Caption = "2D Result : Unprinted";
            }
            else
            {
              TwoDResultLabel->Caption = "2D Result : PASS";

              PrintBrightnessLabel->Caption = "Brightness : " + Brightness;
              PrintThetaLabel->Caption = "Marking Theta : " + IntToStr(printdata[1]) + " ";
              PrintXLabel->Caption = "Marking X : " + FloatToStrF(printdata[2] * MILLIMETER_PER_PIXEL, ffGeneral, 4, 2) + " um";
              PrintYLabel->Caption = "Marking Y : " + FloatToStrF(printdata[3] * MILLIMETER_PER_PIXEL, ffGeneral, 4, 2) + " um";
            }
            
            break;
          }
        }
        else
        {
          break;
        }
      }
    }
  }
  else
  {
  
  }

  if(pFileStream!= NULL)
  {
    delete pFileStream;
    pFileStream = NULL;
  }

  ThreeDResultLabel->Caption = "3D Result : Not exist";
  Print3DThetaLabel->Caption = "Calculated Theta : N/A";
  Print3DXLabel->Caption = "Calculated X : N/A";
  Print3DYLabel->Caption = "Calculated Y : N/A";

  memset(ImageData, 0, REALTIME_CAMERA_WIDTH * REALTIME_CAMERA_HEIGHT);
  if(FileExists(lmFileName3D))
  {
    pFileStream = new TFileStream(lmFileName3D, fmOpenRead);
    if(pFileStream)
    {
      while(true)
      {
        if(pFileStream->Position + DataSize <= pFileStream->Size)
        {
          pFileStream->Read(ImageData, sizeof(char)*(REALTIME_CAMERA_WIDTH * REALTIME_CAMERA_HEIGHT));
          if(*((int*)ImageData + 1) == tabletNumber)
          {
            Graphics::TBitmap *tempBitmap = new Graphics::TBitmap;
            tempBitmap->Width = IMAGE_WIDTH_3D / 4;
            tempBitmap->Height = IMAGE_HEIGHT_3D / 4;
            tempBitmap->PixelFormat = pf8bit;

            ImageConversion_3D(tempBitmap, IMAGE_WIDTH_3D / 4, IMAGE_HEIGHT_3D / 4, ImageData, SYSTEM_CAMERA_WIDTH_3D / 4, SYSTEM_CAMERA_HEIGHT_3D / 4);

            for (int y = 0; y < (IMAGE_HEIGHT_3D / 4); y++)
            {
              byte *pBitmap = (byte *)_3D_RT_Image->Picture->Bitmap->ScanLine[y];
              byte *pSrc = (byte *)tempBitmap->ScanLine[y];

              for (int x = 0; x < (IMAGE_WIDTH_3D / 4) * 2; x++)
              {
                if(y == 0 || (x / 2) == 0 || y == (IMAGE_HEIGHT_3D / 4) - 1 || (x / 2) == (IMAGE_WIDTH_3D / 4) - 1)
                {
                  pBitmap[3 * x + 0] = 0;
                  pBitmap[3 * x + 1] = 0;
                  pBitmap[3 * x + 2] = 0;
                }
                else
                {
                  pBitmap[3 * x + 0] = pSrc[x / 2];
                  pBitmap[3 * x + 1] = pSrc[x / 2];
                  pBitmap[3 * x + 2] = pSrc[x / 2];
                }
              }
            }

            delete tempBitmap;

            printdata[0] = *((int*)ImageData + 2);
            printdata[1] = *((int*)ImageData + 3);
            printdata[2] = *((int*)ImageData + 4);
            printdata[3] = *((int*)ImageData + 5);

            if(printdata[0] == 0 && printdata[1] == 0 && printdata[2] == 0 && printdata[3] == 0)
            {
              ThreeDResultLabel->Caption = "3D Result : Image Blank";
            }
            else
            {
              ThreeDResultLabel->Caption = "3D Result : PASS";

              Print3DThetaLabel->Caption = "Calculated Theta : " + IntToStr(printdata[0]) + " ";
              Print3DXLabel->Caption = "Calculated X : " + FloatToStrF(printdata[1] * MILLIMETER_PER_PIXEL, ffGeneral, 4, 2) + " um";
              Print3DYLabel->Caption = "Calculated Y : " + FloatToStrF(printdata[2] * MILLIMETER_PER_PIXEL, ffGeneral, 4, 2) + " um";
            }

            break;
          }
        }
        else
        {
          break;
        }
      }
    }
  }
  else
  {
  
  }
  
  delete[] ImageData;
  if(pFileStream != NULL)
  {
    delete pFileStream;
    pFileStream = NULL;
  }
}
//---------------------------------------------------------------------------

void __fastcall TLaserInspectionMarkingInfoForm::TntButton1Click(TObject *Sender)
{
  this->Close();  
}
//---------------------------------------------------------------------------


