//---------------------------------------------------------------------------

#ifndef LaserInspectionMarkingInfo_FormH
#define LaserInspectionMarkingInfo_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
#include <Dialogs.hpp>
#include <ExtDlgs.hpp>

#define REALTIME_CAMERA_WIDTH       SYSTEM_CAMERA_WIDTH / 4
#define REALTIME_CAMERA_HEIGHT      SYSTEM_CAMERA_HEIGHT / 4

#define MILLIMETER_PER_PIXEL  46.86f // 30mm FOV
//---------------------------------------------------------------------------
class TLaserInspectionMarkingInfoForm : public TTntForm
{
__published:	// IDE-managed Components
  TPanel *Panel1;
  TTntImage *_2D_RT_Image;
  TSavePictureDialog *SavePictureDialog1;
  TTntImage *_3D_RT_Image;
  TTntButton *TntButton1;
  TTntLabel *TabletNumLabel;
  TTntLabel *TwoDResultLabel;
  TTntLabel *ThreeDResultLabel;
  TTntLabel *PrintBrightnessLabel;
  TTntLabel *PrintThetaLabel;
  TTntLabel *PrintXLabel;
  TTntLabel *PrintYLabel;
  TTntLabel *Print3DThetaLabel;
  TTntLabel *Print3DXLabel;
  TTntLabel *Print3DYLabel;
  void __fastcall TntButton1Click(TObject *Sender);
private:	// User declarations
  int prevX;
  int LeftPos;
  int RightPos;
  int displayImageWidth;
  bool MouseDownSW;
  int shiftX;
  int prevLeftPos;
  int originLeftPos;
  int originRightPos;
public:		// User declarations
	__fastcall TLaserInspectionMarkingInfoForm(TComponent* Owner);
 void  __fastcall SetImage(int FilePageNumber, int tabletNumber, AnsiString Brightness);

};
//---------------------------------------------------------------------------
extern PACKAGE TLaserInspectionMarkingInfoForm *LaserInspectionMarkingInfoForm;
//---------------------------------------------------------------------------
#endif
