//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "LogViewer_Form.h"
#include "ErrorList_Form.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntExtCtrls"
#pragma link "TntGrids"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TLogViewerForm *LogViewerForm;
//---------------------------------------------------------------------------
__fastcall TLogViewerForm::TLogViewerForm(TComponent* Owner)
    : TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  ViewCurrentLogButton->Caption = LOGVIEWERFORM_BUTTON_CAPTION_01;
}
//---------------------------------------------------------------------------
void __fastcall TLogViewerForm::ViewCurrentLogButtonClick(TObject *Sender)
{
    ErrorListForm->Show();    
}
//---------------------------------------------------------------------------
void __fastcall TLogViewerForm::FormCreate(TObject *Sender)
{
    LogFileListBox->Directory = ProgramPath.Log + "\\Error Log";
    ResizeComponents();
}
//---------------------------------------------------------------------------
void __fastcall TLogViewerForm::LogFileListBoxClick(TObject *Sender)
{
    // load log data
    AnsiString logFileName = LogFileListBox->FileName;
    if (!FileExists(logFileName))
    {
        return;
    }

    int logDataVersion;
    int saveDataCount;
    TFileStream *fileStream = new TFileStream(logFileName, fmOpenRead);
    if (fileStream)
    {
        fileStream->Read(&logDataVersion, sizeof(int));
        if (logDataVersion == 100)
        {
            fileStream->Read(&saveDataCount, sizeof(int));
            vector<TErrorUnit>::iterator it;
            int dataCount = 0;

            ErrorList.clear();
            for (int dataCount = 0; dataCount < saveDataCount; dataCount++)
            {
                TErrorUnit errorUnit;
                fileStream->Read(&errorUnit, sizeof(TErrorUnit));
                ErrorList.push_back(errorUnit);
            }
        }
        delete fileStream;
    }
    UpdateErrorList();
}
//---------------------------------------------------------------------------
void __fastcall TLogViewerForm::FormResize(TObject *Sender)
{
    ResizeComponents();
}
//---------------------------------------------------------------------------
void __fastcall TLogViewerForm::ResizeComponents(void)
{
	ErrorStringGrid->ColWidths[0] = 20;
    ErrorStringGrid->Cells[1][0] = "Board";
    ErrorStringGrid->Cells[2][0] = "Time";
    ErrorStringGrid->Cells[3][0] = "Type";
    ErrorStringGrid->Cells[4][0] = "Code";
    ErrorStringGrid->Cells[5][0] = "Value 1";
    ErrorStringGrid->Cells[6][0] = "Value 2";
    ErrorStringGrid->Cells[7][0] = "Value 3";
    ErrorStringGrid->Cells[8][0] = "Message";
    ErrorStringGrid->ColWidths[1] = 100;
    ErrorStringGrid->ColWidths[4] = 200; 
    ErrorStringGrid->ColWidths[8] = ErrorStringGrid->Width - ErrorStringGrid->CellRect(7, 0).Right - 5;
}
//---------------------------------------------------------------------------
void __fastcall TLogViewerForm::UpdateErrorList(void)
{
	int rowIndex = 1;
    vector<TErrorUnit>::iterator it;

    ErrorStringGrid->RowCount = ErrorList.size() + 1;
	for (it = ErrorList.begin(); it < ErrorList.end(); it++)
    {
    	ErrorStringGrid->Cells[1][rowIndex] = BoardIDToStr(it->troubleBoard);
        ErrorStringGrid->Cells[2][rowIndex] = IntToStr(it->time);
        ErrorStringGrid->Cells[3][rowIndex] = ErrorTypeToStr(it->type);
        ErrorStringGrid->Cells[4][rowIndex] = ErrorCodeToStr(it->code);
        ErrorStringGrid->Cells[5][rowIndex] = IntToStr(it->value[0]);
        ErrorStringGrid->Cells[6][rowIndex] = IntToStr(it->value[1]);
        ErrorStringGrid->Cells[7][rowIndex] = IntToStr(it->value[2]);
        ErrorStringGrid->Cells[8][rowIndex] = ErrorUnitToMessage(it);

		rowIndex++;
    }
}
//---------------------------------------------------------------------------
