//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
// HCB05, SPB07    ߻  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "MCBSPTest_Form.h"
#include "Environment.h"
#include "MultiLanguage.h"
//--------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TMCBSPTestForm *MCBSPTestForm;
//---------------------------------------------------------------------------
__fastcall TMCBSPTestForm::TMCBSPTestForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

}
//---------------------------------------------------------------------------
void __fastcall TMCBSPTestForm::EchoTestButtonClick(TObject *Sender)
{
	struct
    {
    	int func;
		int dataSize;
        int frequency;
		int SPBMask;
    } mcbspTestRequestData;
	try
    {
    	mcbspTestRequestData.func = 1;
    	mcbspTestRequestData.dataSize = StrToInt(DataSizeEdit->Text);
        mcbspTestRequestData.frequency = StrToInt(FrequencyEdit->Text);
        mcbspTestRequestData.SPBMask = 0;
        for (int spbIndex = 0; spbIndex < MachineSetupData.IPB_BoardCount; spbIndex++)
        {
			TTntCheckBox *spbCheckBox = (TTntCheckBox *) FindComponent("SPBCheckBox" + IntToStr(spbIndex + 1));
            if (spbCheckBox)
            {
             	if (spbCheckBox->Checked)
                {
					mcbspTestRequestData.SPBMask |= (0x0001 << spbIndex);
                }
/*
				if (!SPBConnection[spbIndex].RequestCommand(CMD_MCBSP_TEST))
                {
					ShowMessageW(SPBConnection[spbIndex].GetLastErrorMessage());
                }
*/
            }
        }

		if (!Comm_Request(COMM_HCB, CMD_MCBSP_TEST, &mcbspTestRequestData, sizeof(mcbspTestRequestData)))
		{
			//ShowMessageW(HCBConnection.GetLastErrorMessage());
        }
        else
        {
         	Timer1->Enabled = true;
        }
    }
    catch (...)
    {

    }
}
//---------------------------------------------------------------------------
void __fastcall TMCBSPTestForm::TestStopButtonClick(TObject *Sender)
{
	int func;
    func = 0;
	if (!Comm_Request(COMM_HCB, CMD_MCBSP_TEST, &func, sizeof(int)))
	{
    	//ShowMessageW(HCBConnection.GetLastErrorMessage());
    }
    Timer1->Enabled = false;
}
//---------------------------------------------------------------------------

void __fastcall TMCBSPTestForm::Timer1Timer(TObject *Sender)
{
	struct
	{
		int TransferCount;
		int ErrorCount_PacketID;
        int ErrorCount_SPB_CheckSum;
		int ErrorCount_CheckSum;
		int ErrorCount_Data;
		int ErrorCount_SendTO;
		int ErrorCount_ReceiveTO;
        int ErrorCount_MSBLost;
        int ErrorCount_LSBLost;
		int OverflowCount;
	} McBSPTestResultData;

	if (!Comm_Request(COMM_HCB, CMD_MCBSP_TEST_RESULT, NULL, 0, &McBSPTestResultData, sizeof(McBSPTestResultData)))
	{
		//ShowMessageW(HCBConnection.GetLastErrorMessage());
		Timer1->Enabled = false;
	}
	else
    {
	    int totalErrorCount = 0;
        totalErrorCount += McBSPTestResultData.ErrorCount_PacketID;
        totalErrorCount += McBSPTestResultData.ErrorCount_CheckSum;
		totalErrorCount += McBSPTestResultData.ErrorCount_SPB_CheckSum;
        totalErrorCount += McBSPTestResultData.ErrorCount_Data;
        totalErrorCount += McBSPTestResultData.ErrorCount_SendTO;
        totalErrorCount += McBSPTestResultData.ErrorCount_ReceiveTO;
        totalErrorCount += McBSPTestResultData.ErrorCount_MSBLost;
        totalErrorCount += McBSPTestResultData.ErrorCount_LSBLost;
		TransferCountLabel->Caption = IntToStr(McBSPTestResultData.TransferCount);
        if (McBSPTestResultData.TransferCount > 0)
        {
            ErrorRateLabel->Caption = FloatToStrF((double)totalErrorCount / McBSPTestResultData.TransferCount * 100, ffGeneral, 4, 2) + "%";
        }
        OverflowCountLabel->Caption = IntToStr(McBSPTestResultData.OverflowCount);
        PacketIDErrorCountLabel->Caption = IntToStr(McBSPTestResultData.ErrorCount_PacketID);
        ChecksumErrorCountLabel->Caption = IntToStr(McBSPTestResultData.ErrorCount_CheckSum);
        SPBChecksumErrorCountLabel->Caption = IntToStr(McBSPTestResultData.ErrorCount_SPB_CheckSum);
        DataErrorCountLabel->Caption = IntToStr(McBSPTestResultData.ErrorCount_Data);
        SendTimeOutCountLabel->Caption = IntToStr(McBSPTestResultData.ErrorCount_SendTO);
        ReceiveTimeoutCountLabel->Caption = IntToStr(McBSPTestResultData.ErrorCount_ReceiveTO);
        MSBLostCountLabel->Caption = IntToStr(McBSPTestResultData.ErrorCount_MSBLost);
        LSBLostCountLabel->Caption = IntToStr(McBSPTestResultData.ErrorCount_LSBLost);
    }
}
//---------------------------------------------------------------------------


void __fastcall TMCBSPTestForm::ReadDebugInfoButtonClick(TObject *Sender)
{
	struct
	{
		unsigned int SendPacketCount[SYSTEM_SPB_MAX_COUNT];
		unsigned int ReceivedPacketCount[SYSTEM_SPB_MAX_COUNT];
		unsigned int SendTimeoutPacketCount[SYSTEM_SPB_MAX_COUNT];
		unsigned int ReceiveTimeoutPacketCount[SYSTEM_SPB_MAX_COUNT];
		char CurrentSPBIndex;
		char dummy[3];
	} McbspDebugInfo;

	if (Comm_Request(COMM_HCB, CMD_MCBSP_DEBUG_INFO, NULL, 0, &McbspDebugInfo, sizeof(McbspDebugInfo)))
	{
		SendPacketCountLabel1->Caption = IntToStr(McbspDebugInfo.SendPacketCount[0]);
		ReceivedPacketCountLabel1->Caption = IntToStr(McbspDebugInfo.ReceivedPacketCount[0]);
		SendTOPacketCountLabel1->Caption = IntToStr(McbspDebugInfo.SendTimeoutPacketCount[0]);
		ReceiveTOPacketCountLabel1->Caption = IntToStr(McbspDebugInfo.ReceiveTimeoutPacketCount[0]);
		SendPacketCountLabel2->Caption = IntToStr(McbspDebugInfo.SendPacketCount[1]);
		ReceivedPacketCountLabel2->Caption = IntToStr(McbspDebugInfo.ReceivedPacketCount[1]);
		SendTOPacketCountLabel2->Caption = IntToStr(McbspDebugInfo.SendTimeoutPacketCount[1]);
		ReceiveTOPacketCountLabel2->Caption = IntToStr(McbspDebugInfo.ReceiveTimeoutPacketCount[1]);
		SendPacketCountLabel3->Caption = IntToStr(McbspDebugInfo.SendPacketCount[2]);
		ReceivedPacketCountLabel3->Caption = IntToStr(McbspDebugInfo.ReceivedPacketCount[2]);
		SendTOPacketCountLabel3->Caption = IntToStr(McbspDebugInfo.SendTimeoutPacketCount[2]);
		ReceiveTOPacketCountLabel3->Caption = IntToStr(McbspDebugInfo.ReceiveTimeoutPacketCount[2]);
		SendPacketCountLabel4->Caption = IntToStr(McbspDebugInfo.SendPacketCount[3]);
		ReceivedPacketCountLabel4->Caption = IntToStr(McbspDebugInfo.ReceivedPacketCount[3]);
		SendTOPacketCountLabel4->Caption = IntToStr(McbspDebugInfo.SendTimeoutPacketCount[3]);
		ReceiveTOPacketCountLabel4->Caption = IntToStr(McbspDebugInfo.ReceiveTimeoutPacketCount[3]);
		SendPacketCountLabel5->Caption = IntToStr(McbspDebugInfo.SendPacketCount[4]);
		ReceivedPacketCountLabel5->Caption = IntToStr(McbspDebugInfo.ReceivedPacketCount[4]);
		SendTOPacketCountLabel5->Caption = IntToStr(McbspDebugInfo.SendTimeoutPacketCount[4]);
		ReceiveTOPacketCountLabel5->Caption = IntToStr(McbspDebugInfo.ReceiveTimeoutPacketCount[4]);
    SendPacketCountLabel6->Caption = IntToStr(McbspDebugInfo.SendPacketCount[5]);
		ReceivedPacketCountLabel6->Caption = IntToStr(McbspDebugInfo.ReceivedPacketCount[5]);
		SendTOPacketCountLabel6->Caption = IntToStr(McbspDebugInfo.SendTimeoutPacketCount[5]);
		ReceiveTOPacketCountLabel6->Caption = IntToStr(McbspDebugInfo.ReceiveTimeoutPacketCount[5]);
    SendPacketCountLabel7->Caption = IntToStr(McbspDebugInfo.SendPacketCount[6]);
		ReceivedPacketCountLabel7->Caption = IntToStr(McbspDebugInfo.ReceivedPacketCount[6]);
		SendTOPacketCountLabel7->Caption = IntToStr(McbspDebugInfo.SendTimeoutPacketCount[6]);
		ReceiveTOPacketCountLabel7->Caption = IntToStr(McbspDebugInfo.ReceiveTimeoutPacketCount[6]);
    SendPacketCountLabel8->Caption = IntToStr(McbspDebugInfo.SendPacketCount[7]);
		ReceivedPacketCountLabel8->Caption = IntToStr(McbspDebugInfo.ReceivedPacketCount[7]);
		SendTOPacketCountLabel8->Caption = IntToStr(McbspDebugInfo.SendTimeoutPacketCount[7]);
		ReceiveTOPacketCountLabel8->Caption = IntToStr(McbspDebugInfo.ReceiveTimeoutPacketCount[7]);
	}
}
