//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------


#pragma hdrstop

#include "MachineControl.h"
#include "Environment.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------

#pragma package(smart_init)

#define PORT_CONTROL_MODE_NORMAL			0
#define PORT_CONTROL_MODE_BLINK				1

__fastcall TMachine::TMachine()
{
  

	NCPosParamMul[0] = NC_POS_PARAM_1_MUL;
	NCPosParamMul[1] = NC_POS_PARAM_2_MUL;
	NCPosParamMul[2] = NC_POS_PARAM_3_MUL;
	NCPosParamMul[3] = NC_POS_PARAM_4_MUL;
	NCPosParamMul[4] = NC_POS_PARAM_5_MUL;

	NCPosParamDiv[0] = NC_POS_PARAM_1_DIV;
	NCPosParamDiv[1] = NC_POS_PARAM_2_DIV;
	NCPosParamDiv[2] = NC_POS_PARAM_3_DIV;
	NCPosParamDiv[3] = NC_POS_PARAM_4_DIV;
	NCPosParamDiv[4] = NC_POS_PARAM_5_DIV;

	for (int servoMotorIndex = 0; servoMotorIndex < MAX_SERVO_MOTOR_COUNT; servoMotorIndex++)
	{
		ServoMotorRPM[servoMotorIndex] = 0;
	}

	FSimulationMode = false;
	ClearMachineStatus();
}
//---------------------------------------------------------------------------
// L0 Operations
//---------------------------------------------------------------------------
bool __fastcall TMachine::PortTest(int physicalOPIndex, bool bOn)
{
	if (Status.ControlMode > MACHINE_MODE_TEST)
	{
		ShowMessageFA(MACHINECONTROL_MSG_01);
		return false; 
	}

	struct
	{
		int Mode;
		int PortIndex;
		int PortValue;
	} portTestCommandData;

	portTestCommandData.Mode = PORT_CONTROL_MODE_NORMAL;
	portTestCommandData.PortIndex = physicalOPIndex;
	if (bOn)
	{
		portTestCommandData.PortValue = 1;
	}
	else
	{
		portTestCommandData.PortValue = 0;
	}
	return Comm_Request(COMM_HCB, CMD_PORT_TEST, &portTestCommandData, sizeof(portTestCommandData));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::PortTest_Blink(TOPTestData *opTestData)
{
	if (Status.ControlMode > MACHINE_MODE_TEST)
	{
		ShowMessageFA(MACHINECONTROL_MSG_01);
		return false; 
	}
	
	struct
	{
		int Mode;
		TOPTestData opTestData;
	} portTestCommandData;

	portTestCommandData.Mode = PORT_CONTROL_MODE_BLINK;
	memcpy(&(portTestCommandData.opTestData), opTestData, sizeof(TOPTestData));
	return Comm_Request(COMM_HCB, CMD_PORT_TEST, &portTestCommandData, sizeof(portTestCommandData));
}
//---------------------------------------------------------------------------
// L1 Operations
//---------------------------------------------------------------------------
bool __fastcall TMachine::RingBlowerOn(int blowerIndex, int speed1, int speed2)
{
	TMachineControlData_RingBlower machineControlData_RingBlower;
	machineControlData_RingBlower.MachineControlHeader.Target = MACHINE_CONTROL_RINGBLOWER;
	machineControlData_RingBlower.Action = 1;
	machineControlData_RingBlower.BlowerIndex = blowerIndex;
	machineControlData_RingBlower.Speed1 = speed1;
	machineControlData_RingBlower.Speed2 = speed2;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_RingBlower, sizeof(TMachineControlData_RingBlower));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::RingBlowerOff(int blowerIndex)
{
	TMachineControlData_RingBlower machineControlData_RingBlower;
	machineControlData_RingBlower.MachineControlHeader.Target = MACHINE_CONTROL_RINGBLOWER;
	machineControlData_RingBlower.Action = 0;
	machineControlData_RingBlower.BlowerIndex = blowerIndex;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_RingBlower, sizeof(TMachineControlData_RingBlower));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::ServoMotorRun(int motorIndex, int baseSpeed, int targetSpeed, int accTime, int dir)
{
	TMachineControlData_ServoMotor machineControlData_ServoMotor;
	machineControlData_ServoMotor.MachineControlHeader.Target = MACHINE_CONTROL_SERVOMOTOR;
	machineControlData_ServoMotor.Action = 1;
	machineControlData_ServoMotor.MotorIndex = motorIndex;
	machineControlData_ServoMotor.BaseSpeed = baseSpeed;
  machineControlData_ServoMotor.TargetSpeed = targetSpeed;
	machineControlData_ServoMotor.AccTime = accTime;
	machineControlData_ServoMotor.Dir = dir;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_ServoMotor, sizeof(TMachineControlData_ServoMotor));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::ServoMotorStop(int motorIndex, int decTime)
{
	TMachineControlData_ServoMotor machineControlData_ServoMotor;
	machineControlData_ServoMotor.MachineControlHeader.Target = MACHINE_CONTROL_SERVOMOTOR;
	machineControlData_ServoMotor.Action = 0;
	machineControlData_ServoMotor.MotorIndex = motorIndex;
	machineControlData_ServoMotor.DecTime = decTime;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_ServoMotor, sizeof(TMachineControlData_ServoMotor));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::ServoMotorHoldOn(int motorIndex)
{
	TMachineControlData_ServoMotor machineControlData_ServoMotor;
	machineControlData_ServoMotor.MachineControlHeader.Target = MACHINE_CONTROL_SERVOMOTOR;
	machineControlData_ServoMotor.Action = 2;
	machineControlData_ServoMotor.MotorIndex = motorIndex;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_ServoMotor, sizeof(TMachineControlData_ServoMotor));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::ServoMotorHoldOff(int motorIndex)
{
	TMachineControlData_ServoMotor machineControlData_ServoMotor;
	machineControlData_ServoMotor.MachineControlHeader.Target = MACHINE_CONTROL_SERVOMOTOR;
	machineControlData_ServoMotor.Action = 3;
	machineControlData_ServoMotor.MotorIndex = motorIndex;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_ServoMotor, sizeof(TMachineControlData_ServoMotor));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::StepMotorMove(int motorIndex, int pulseCount, int dir)
{
	TMachineControlData_StepMotor machineControlData_StepMotor;
	machineControlData_StepMotor.MachineControlHeader.Target = MACHINE_CONTROL_STEPMOTOR;
	machineControlData_StepMotor.Action = 1;
	machineControlData_StepMotor.MotorIndex = motorIndex;
	machineControlData_StepMotor.PulseCount = pulseCount;
	machineControlData_StepMotor.Dir = dir;
	
	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_StepMotor, sizeof(TMachineControlData_StepMotor));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::AirKnifeOn(int akBit)
{
	if (akBit == 0)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 0;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (akBit == 1)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 2;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::AirKnifeOff(int akBit)
{
	if (akBit == 0)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 1;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (akBit == 1)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 3;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::SDBlowerOn(int sdIndex)
{
	if (sdIndex == 0)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 4;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (sdIndex == 1)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 6;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::SDBlowerOff(int sdIndex)
{
	if (sdIndex == 0)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 5;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (sdIndex == 1)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 7;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::EjectorOn(int ejectorIndex)
{
	if (ejectorIndex == 0)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 8;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (ejectorIndex == 1)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 10;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if(ejectorIndex == 2) // SELMA 200 ߰ 
  {
    TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 31;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
  }
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::EjectorOff(int ejectorIndex)
{
	if (ejectorIndex == 0)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 9;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (ejectorIndex == 1)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 11;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
  else if(ejectorIndex == 2) // SELMA 200߰
  {
    TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 32;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
  }
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::DustBlowerOn(int blowerIndex)
{
	if (blowerIndex == 0)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 12;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (blowerIndex == 1)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 14;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (blowerIndex == 2)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 16;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (blowerIndex == 3)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 18;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (blowerIndex == 4)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 20;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (blowerIndex == 5)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 22;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::DustBlowerOff(int blowerIndex)
{
	if (blowerIndex == 0)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 13;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (blowerIndex == 1)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 15;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (blowerIndex == 2)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 17;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (blowerIndex == 3)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 19;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (blowerIndex == 4)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 21;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (blowerIndex == 5)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 23;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::AirBrushIn(int abIndex)
{
	if (abIndex == 0)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 24;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (abIndex == 1)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 26;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::AirBrushOut(int abIndex)
{
	if (abIndex == 0)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 25;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (abIndex == 1)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 2;
		machineControlData_General.Value[0] = 27;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------

bool __fastcall TMachine::InterLockOn(void)
{
  TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 2;
	machineControlData_General.Value[0] = 33;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
bool __fastcall TMachine::InterLockOff(void)
{
  TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 2;
	machineControlData_General.Value[0] = 34;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::MisejectOpen(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 2;
	machineControlData_General.Value[0] = 28;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::MisejectClose(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 2;
	machineControlData_General.Value[0] = 29;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::MisejectStop(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 2;
	machineControlData_General.Value[0] = 30;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::LampOn(int lampIndex)
{
	if (lampIndex == 0)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 4;
		machineControlData_General.Value[0] = 0;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (lampIndex == 1)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 4;
		machineControlData_General.Value[0] = 2;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (lampIndex == 2)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 4;
		machineControlData_General.Value[0] = 4;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::LampOff(int lampIndex)
{
	if (lampIndex == 0)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 4;
		machineControlData_General.Value[0] = 1;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (lampIndex == 1)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 4;
		machineControlData_General.Value[0] = 3;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else if (lampIndex == 2)
	{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 4;
		machineControlData_General.Value[0] = 5;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
	}
	else
	{
		return false;
	}
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::BuzzerOn(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 4;
	machineControlData_General.Value[0] = 6;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::BuzzerOff(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 4;
	machineControlData_General.Value[0] = 7;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::Buzzer2On(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 4;
	machineControlData_General.Value[0] = 14;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::Buzzer2Off(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 4;
	machineControlData_General.Value[0] = 15;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::Buzzer3On(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 4;
	machineControlData_General.Value[0] = 16;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::Buzzer3Off(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 4;
	machineControlData_General.Value[0] = 17;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::RoomLampOn(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 4;
	machineControlData_General.Value[0] = 11;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::RoomLampOff(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 4;
	machineControlData_General.Value[0] = 9;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::VFMagnetOn(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 4;
	machineControlData_General.Value[0] = 10;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::VFMagnetOff(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 4;
	machineControlData_General.Value[0] = 11;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::MELampOn(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 4;
	machineControlData_General.Value[0] = 12;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::MELampOff(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 4;
	machineControlData_General.Value[0] = 13;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::PLCOff(void)
{
	TMachineControlData_General MachineControlData_General;
	MachineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	MachineControlData_General.ActionN = 5;
	MachineControlData_General.Value[0] = 0;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &MachineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::PLCOn(void)
{
	TMachineControlData_General MachineControlData_General;
	MachineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	MachineControlData_General.ActionN = 5;
	MachineControlData_General.Value[0] = 1;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &MachineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
// L2 Operations
//---------------------------------------------------------------------------
bool __fastcall TMachine::SuctionDiskRun(int sd1Speed, int sd2Speed, int sd1InverterSpeed, int sd2InverterSpeed)
{
	TMachineControlData_SuctionDisk machineControlData_SuctionDisk;
	machineControlData_SuctionDisk.MachineControlHeader.Target = MACHINE_CONTROL_SUCTION_DISK;

	machineControlData_SuctionDisk.Action = 1;
	machineControlData_SuctionDisk.DiscSpeed[SD1_MOTOR_INDEX] = sd1Speed;
	machineControlData_SuctionDisk.DiscSpeed[SD2_MOTOR_INDEX] = sd2Speed;

	machineControlData_SuctionDisk.SuctionDisk1InverterSpeed = sd1InverterSpeed;
	machineControlData_SuctionDisk.SuctionDisk2InverterSpeed = sd2InverterSpeed;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_SuctionDisk, sizeof(TMachineControlData_SuctionDisk));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::SuctionDiskStop(void)
{
	TMachineControlData_SuctionDisk machineControlData_SuctionDisk;
	machineControlData_SuctionDisk.MachineControlHeader.Target = MACHINE_CONTROL_SUCTION_DISK;
	machineControlData_SuctionDisk.Action = 0;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_SuctionDisk, sizeof(TMachineControlData_SuctionDisk));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::SuctionDiskMotorStop(void)
{
    TMachineControlData_SuctionDisk machineControlData_SuctionDisk;
    machineControlData_SuctionDisk.MachineControlHeader.Target = MACHINE_CONTROL_SUCTION_DISK;
	machineControlData_SuctionDisk.Action = 2;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_SuctionDisk, sizeof(TMachineControlData_SuctionDisk));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::BowlFeederRun(int bfIDSpeed, int bfOD1Speed, int bfOD2Speed, int airKnifeSpeed)
{
	TMachineControlData_BowlFeeder machineControlData_BowlFeeder;
	machineControlData_BowlFeeder.MachineControlHeader.Target = MACHINE_CONTROL_BOWL_FEEDER;

	machineControlData_BowlFeeder.Action = 1;
	machineControlData_BowlFeeder.InnerDiskSpeed = bfIDSpeed;
	machineControlData_BowlFeeder.OuterDisk1Speed = bfOD1Speed;
	machineControlData_BowlFeeder.OuterDisk2Speed = bfOD2Speed;
	machineControlData_BowlFeeder.AirKnifeSpeed = airKnifeSpeed;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_BowlFeeder, sizeof(TMachineControlData_BowlFeeder));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::BowlFeederStop(void)
{
	TMachineControlData_BowlFeeder machineControlData_BowlFeeder;
	machineControlData_BowlFeeder.MachineControlHeader.Target = MACHINE_CONTROL_BOWL_FEEDER;
	machineControlData_BowlFeeder.Action = 0;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_BowlFeeder, sizeof(TMachineControlData_BowlFeeder));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::BowlFeederAKSpeedChange(int speed)
{
	TMachineControlData_BowlFeeder machineControlData_BowlFeeder;
	machineControlData_BowlFeeder.MachineControlHeader.Target = MACHINE_CONTROL_BOWL_FEEDER;
	machineControlData_BowlFeeder.AirKnifeSpeed = speed;
	machineControlData_BowlFeeder.Action = 2;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_BowlFeeder, sizeof(TMachineControlData_BowlFeeder));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::BowlFeederReset(void)
{
	TMachineControlData_BowlFeeder machineControlData_BowlFeeder;
	machineControlData_BowlFeeder.MachineControlHeader.Target = MACHINE_CONTROL_BOWL_FEEDER;
	machineControlData_BowlFeeder.Action = 3;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_BowlFeeder, sizeof(TMachineControlData_BowlFeeder));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::VFRun(int speed)
{
	TMachineControlData_VibrationFeeder machineControlData_VibrationFeeder;
	machineControlData_VibrationFeeder.MachineControlHeader.Target = MACHINE_CONTROL_VIBRATOR;
	machineControlData_VibrationFeeder.Speed = speed;
	machineControlData_VibrationFeeder.Action = 1;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_VibrationFeeder, sizeof(TMachineControlData_VibrationFeeder));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::VFRun_AutoControl(char trainingMode, int manualModeSpeed, int manualModeSensorIndex, int manualModeSensorActiveRatio,
	int sensor1Ratio, int sensor2Ratio)
{
	TMachineControlData_VibrationFeeder machineControlData_VibrationFeeder;
	machineControlData_VibrationFeeder.MachineControlHeader.Target = MACHINE_CONTROL_VIBRATOR;
	machineControlData_VibrationFeeder.Action = 2;
    machineControlData_VibrationFeeder.TrainingMode = trainingMode;
    machineControlData_VibrationFeeder.Speed = manualModeSpeed;
    machineControlData_VibrationFeeder.ManualModeSensorIndex = manualModeSensorIndex;
    machineControlData_VibrationFeeder.ManualModeSensorActiveRatio = manualModeSensorActiveRatio;
    machineControlData_VibrationFeeder.Sensor1Ratio = sensor1Ratio;
    machineControlData_VibrationFeeder.Sensor2Ratio = sensor2Ratio;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_VibrationFeeder, sizeof(TMachineControlData_VibrationFeeder));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::VFStop(void)
{
	TMachineControlData_VibrationFeeder machineControlData_VibrationFeeder;

	machineControlData_VibrationFeeder.MachineControlHeader.Target = MACHINE_CONTROL_VIBRATOR;
	machineControlData_VibrationFeeder.Action = 0;
	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_VibrationFeeder, sizeof(TMachineControlData_VibrationFeeder));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::DustSuctionOn(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 3;
	machineControlData_General.Value[0] = 2;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::VFStartSpeedMode(int Mode)
{
    TMachineControlData_SungChulData machineControlData_SungChulData;
    machineControlData_SungChulData.MachineControlHeader.Target = SungChul_Data;
    machineControlData_SungChulData.StartSpeedMode = Mode;
    return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_SungChulData, sizeof(TMachineControlData_SungChulData));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::DustSuctionOff(void)
{
	TMachineControlData_General MachineControlData_General;
	MachineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	MachineControlData_General.ActionN = 3;
	MachineControlData_General.Value[0] = 3;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &MachineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::EjectorTestRun(int ejectorIndex, int ejectorMask, int ejectorMaskCount)
{
	TMachineControlData_Ejector machineControlData_Ejector;
	machineControlData_Ejector.MachineControlHeader.Target = MACHINE_CONTROL_EJECTOR;
	machineControlData_Ejector.EjectorIndex = ejectorIndex;
	machineControlData_Ejector.Action = 1;
	machineControlData_Ejector.EjectorMask = ejectorMask;
	machineControlData_Ejector.EjectorMaskCount = ejectorMaskCount;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_Ejector, sizeof(TMachineControlData_Ejector));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::EjectorTestStop(int ejectorIndex)
{
	TMachineControlData_Ejector machineControlData_Ejector;
	machineControlData_Ejector.MachineControlHeader.Target = MACHINE_CONTROL_EJECTOR;
	machineControlData_Ejector.EjectorIndex = ejectorIndex;
	machineControlData_Ejector.Action = 0;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_Ejector, sizeof(TMachineControlData_Ejector));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::MisejectTestRun(int activeDelay, int durationTime)
{
	TMachineControlData_Miseject machineControlData_Miseject;
	machineControlData_Miseject.MachineControlHeader.Target = MACHINE_CONTROL_MISEJECT;
	machineControlData_Miseject.Action = 1;
	machineControlData_Miseject.ActiveDelay = activeDelay;
	machineControlData_Miseject.DurationTime = durationTime;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_Miseject, sizeof(TMachineControlData_Miseject));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::MisejectTestStop(void)
{
	TMachineControlData_Miseject machineControlData_Miseject;
	machineControlData_Miseject.MachineControlHeader.Target = MACHINE_CONTROL_MISEJECT;
	machineControlData_Miseject.Action = 0;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_Miseject, sizeof(TMachineControlData_Miseject));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::NCHomeMoveTest(int motorIndex)
{
	TMachineControlData_StepMotor machineControlData_StepMotor;
	machineControlData_StepMotor.MachineControlHeader.Target = MACHINE_CONTROL_STEPMOTOR;
	machineControlData_StepMotor.Action = 2;
	machineControlData_StepMotor.MotorIndex = motorIndex;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_StepMotor, sizeof(TMachineControlData_StepMotor));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::IlluminatorTestOn(int ledIndex, int mode, int onInterval, int offInterval)
{
	if (ledIndex != 0xFF)
	{
		TMachineControlData_Illuminator machineControlData_Illuminator;
		machineControlData_Illuminator.MachineControlHeader.Target = MACHINE_CONTROL_ILLUMINATOR;
		machineControlData_Illuminator.Action = 1;
		machineControlData_Illuminator.Mode = mode;
		machineControlData_Illuminator.Interval1 = onInterval;
		machineControlData_Illuminator.Interval2 = offInterval;
		machineControlData_Illuminator.LEDIndex = ledIndex;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_Illuminator, sizeof(TMachineControlData_Illuminator));
	}
	else
	{
		TMachineControlData_Illuminator machineControlData_Illuminator;
		machineControlData_Illuminator.MachineControlHeader.Target = MACHINE_CONTROL_ILLUMINATOR;
		machineControlData_Illuminator.Action = 3;
		machineControlData_Illuminator.Mode = mode;
		machineControlData_Illuminator.Interval1 = onInterval;
		machineControlData_Illuminator.Interval2 = offInterval;
		machineControlData_Illuminator.LEDIndex = 0;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_Illuminator, sizeof(TMachineControlData_Illuminator));
	}
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::IlluminatorTestOff(int ledIndex)
{
	if (ledIndex != 0xFF)
	{
		TMachineControlData_Illuminator machineControlData_Illuminator;
		machineControlData_Illuminator.MachineControlHeader.Target = MACHINE_CONTROL_ILLUMINATOR;
		machineControlData_Illuminator.Action = 0;
		machineControlData_Illuminator.LEDIndex = ledIndex;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_Illuminator, sizeof(TMachineControlData_Illuminator));
	}
	else
	{
		TMachineControlData_Illuminator machineControlData_Illuminator;
		machineControlData_Illuminator.MachineControlHeader.Target = MACHINE_CONTROL_ILLUMINATOR;
		machineControlData_Illuminator.Action = 2;
		machineControlData_Illuminator.LEDIndex = 0;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_Illuminator, sizeof(TMachineControlData_Illuminator));
	}
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::DisableBlackOut(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 5;
	machineControlData_General.Value[0] = 2;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::EnableBlackOut(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 5;
	machineControlData_General.Value[0] = 3;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
// L3 Operations
//---------------------------------------------------------------------------
bool __fastcall TMachine::NCHomeMove(void)
{
	TMachineControlData_General MachineControlData_General;
	MachineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	MachineControlData_General.ActionN = 3;
	MachineControlData_General.Value[0] = 4;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &MachineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::AlarmBuzzerON(void)
{
	return Comm_Request(COMM_HCB, CMD_BUZZER_ON);
}
bool __fastcall TMachine::AlarmBuzzerOff(void)
{
	return Comm_Request(COMM_HCB, CMD_BUZZER_OFF);
}
void __fastcall TMachine::Acrocia_Set_AlarmStatus(int Type)
{
  int TYPE = Type;
  Comm_Request(COMM_HCB, CMD_ACROSIA_TO_HCB_ALARM_UPDATE,&TYPE,sizeof(int));
}
//---------------------------------------------------------------------------
// L4 Operations
//---------------------------------------------------------------------------
bool __fastcall TMachine::MachineStop(void)
{
	TMachineControlData_Procedure machineControlData_Procedure;
	machineControlData_Procedure.MachineControlHeader.Target = MACHINE_CONTROL_PROCEDURE;
	machineControlData_Procedure.Action = 0;
	machineControlData_Procedure.Mode = 0;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_Procedure, sizeof(TMachineControlData_Procedure));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::MachineRun(int mode, TMachineRunOption *machineRunOption,
	double *ncMotorPos, int *motorSpeedList)
{
	TMachineControlData_Procedure machineControlData_Procedure;
	machineControlData_Procedure.MachineControlHeader.Target = MACHINE_CONTROL_PROCEDURE;
	machineControlData_Procedure.Action = 1;
	machineControlData_Procedure.Mode = mode;
	machineControlData_Procedure.MaxSpeedTrainingMode = machineRunOption->MaxSpeedTrainingMode;
	machineControlData_Procedure.ManualMaxSpeed = machineRunOption->ManualMaxSpeed;
  machineControlData_Procedure.ManualModeSensorIndex = machineRunOption->ManualModeSensorIndex;
  machineControlData_Procedure.ManualModeSensorActiveRatio = machineRunOption->ManualModeSensorActiveRatio;
	machineControlData_Procedure.ManualLimitSpeed = machineRunOption->ManualLimitSpeed;
  machineControlData_Procedure.ManualModeLimitSensorIndex = machineRunOption->ManualModeLimitSensorIndex;
  machineControlData_Procedure.ManualModeLimitSensorActiveRatio = machineRunOption->ManualModeLimitSensorActiveRatio;
	machineControlData_Procedure.EmptySensorActiveRatio = machineRunOption->EmptySensorActiveRatio;
	machineControlData_Procedure.FullSensorActiveRatio = machineRunOption->FullSensorActiveRatio;
	machineControlData_Procedure.AirKnifeSpeed = machineRunOption->AirKnifeSpeed;
	machineControlData_Procedure.SuctionDisk1InverterSpeed = machineRunOption->SuctionDisk1InverterSpeed;
	machineControlData_Procedure.SuctionDisk2InverterSpeed = machineRunOption->SuctionDisk2InverterSpeed;
  machineControlData_Procedure.adjustEjectoWindStrength = machineRunOption->adjustEjectorWindStrength;

	machineControlData_Procedure.NCMotorPos[0] = (MachineSetupData.ZeroPositionValue[0] + ncMotorPos[0]-0.005) * NC_POS_PARAM_1_MUL / NC_POS_PARAM_1_DIV;
	machineControlData_Procedure.NCMotorPos[1] = (MachineSetupData.ZeroPositionValue[1] + ncMotorPos[1]-0.005) * NC_POS_PARAM_2_MUL / NC_POS_PARAM_2_DIV;
	machineControlData_Procedure.NCMotorPos[2] = (MachineSetupData.ZeroPositionValue[2] + ncMotorPos[2]-0.005) * NC_POS_PARAM_3_MUL / NC_POS_PARAM_3_DIV;
	machineControlData_Procedure.NCMotorPos[3] = (MachineSetupData.ZeroPositionValue[3] + ncMotorPos[3]-0.005) * NC_POS_PARAM_4_MUL / NC_POS_PARAM_4_DIV;
	machineControlData_Procedure.NCMotorPos[4] = (MachineSetupData.ZeroPositionValue[4] + ncMotorPos[4]-0.005) * NC_POS_PARAM_5_MUL / NC_POS_PARAM_5_DIV;

  if(PCProgramOption.SensorOutputSettingOption == 0) // disable
    machineControlData_Procedure.EnabledSensorType = 0; //   Ʈ ̿
  else
    machineControlData_Procedure.EnabledSensorType = machineRunOption->EnabledSensorType; //    Ʈ ̿

	for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
	{
		      machineControlData_Procedure.MotorSpeed[motorIndex] = motorSpeedList[motorIndex];
	}

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_Procedure, sizeof(TMachineControlData_Procedure));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::MachineReady(void)
{
	TMachineControlData_Procedure machineControlData_Procedure;
	machineControlData_Procedure.MachineControlHeader.Target = MACHINE_CONTROL_PROCEDURE;
	machineControlData_Procedure.Action = 2;
	machineControlData_Procedure.NCMotorPos[0] = (MachineSetupData.ZeroPositionValue[0] + ProductData.NCMotorPos[0]-0.005) * NC_POS_PARAM_1_MUL / NC_POS_PARAM_1_DIV;
	machineControlData_Procedure.NCMotorPos[1] = (MachineSetupData.ZeroPositionValue[1] + ProductData.NCMotorPos[1]-0.005) * NC_POS_PARAM_2_MUL / NC_POS_PARAM_2_DIV;
	machineControlData_Procedure.NCMotorPos[2] = (MachineSetupData.ZeroPositionValue[2] + ProductData.NCMotorPos[2]-0.005) * NC_POS_PARAM_3_MUL / NC_POS_PARAM_3_DIV;
	machineControlData_Procedure.NCMotorPos[3] = (MachineSetupData.ZeroPositionValue[3] + ProductData.NCMotorPos[3]-0.005) * NC_POS_PARAM_4_MUL / NC_POS_PARAM_4_DIV;
	machineControlData_Procedure.NCMotorPos[4] = (MachineSetupData.ZeroPositionValue[4] + ProductData.NCMotorPos[4]-0.005) * NC_POS_PARAM_5_MUL / NC_POS_PARAM_5_DIV;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_Procedure, sizeof(TMachineControlData_Procedure));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::MachineCleaning(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 3;
	machineControlData_General.Value[0] = 0;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::EmergencyStop(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 0;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::VibratorSpeedChange(int speed)
{
	TMachineControlData_VibrationFeeder machineControlData_VibrationFeeder;

	machineControlData_VibrationFeeder.MachineControlHeader.Target = MACHINE_CONTROL_VIBRATOR;
	machineControlData_VibrationFeeder.Action = 3;
	machineControlData_VibrationFeeder.Speed = speed;
	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_VibrationFeeder, sizeof(TMachineControlData_VibrationFeeder));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::NCMovePos(int motorIndex, double targetPos)
{
	TMachineControlData_StepMotor machineControlData_StepMotor;
	machineControlData_StepMotor.MachineControlHeader.Target = MACHINE_CONTROL_STEPMOTOR;
	machineControlData_StepMotor.Action = 3;
	machineControlData_StepMotor.MotorIndex = motorIndex;
	machineControlData_StepMotor.TargetEncoderPosition =
		(targetPos + MachineSetupData.ZeroPositionValue[motorIndex]) * NCPosParamMul[motorIndex] / NCPosParamDiv[motorIndex];
	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_StepMotor, sizeof(TMachineControlData_StepMotor));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::VFSpeedChange(TMachineRunOption *machineRunOption)
{
    TMachineControlData_VibrationFeeder machineControlData_VibrationFeeder;

    machineControlData_VibrationFeeder.MachineControlHeader.Target = MACHINE_CONTROL_VIBRATOR;
    machineControlData_VibrationFeeder.Action = 4;
    machineControlData_VibrationFeeder.TrainingMode = machineRunOption->MaxSpeedTrainingMode;
    machineControlData_VibrationFeeder.Speed = machineRunOption->ManualMaxSpeed;
    machineControlData_VibrationFeeder.ManualModeSensorIndex = machineRunOption->ManualModeSensorIndex;
    machineControlData_VibrationFeeder.ManualModeSensorActiveRatio = machineRunOption->ManualModeSensorActiveRatio;
    machineControlData_VibrationFeeder.LimitSpeed = machineRunOption->ManualLimitSpeed;
    machineControlData_VibrationFeeder.ManualModeLimitSensorIndex = machineRunOption->ManualModeLimitSensorIndex;
    machineControlData_VibrationFeeder.ManualModeLimitSensorActiveRatio = machineRunOption->ManualModeLimitSensorActiveRatio;
    machineControlData_VibrationFeeder.Sensor1Ratio = machineRunOption->EmptySensorActiveRatio;
    machineControlData_VibrationFeeder.Sensor2Ratio = machineRunOption->FullSensorActiveRatio;
    machineControlData_VibrationFeeder.StartSpeed = machineRunOption->StartSpeed; 
	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_VibrationFeeder, sizeof(TMachineControlData_VibrationFeeder));
}
//---------------------------------------------------------------------------
// Superviser Control
//---------------------------------------------------------------------------
bool __fastcall TMachine::SetTestMode(void)
{
	int machineMode = MACHINE_MODE_TEST;
	return Comm_Request(COMM_HCB, CMD_SET_MACHINE_MODE, &machineMode, sizeof(int));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::SetFreeMode(void)
{
	int machineMode = MACHINE_MODE_FREE;
	return Comm_Request(COMM_HCB, CMD_SET_MACHINE_MODE, &machineMode, sizeof(int));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::SetInterlockMode(void)
{
	int machineMode = MACHINE_MODE_INTERLOCK;
	return Comm_Request(COMM_HCB, CMD_SET_MACHINE_MODE, &machineMode, sizeof(int));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::SetMachineMode(int machineMode)
{
	return Comm_Request(COMM_HCB, CMD_SET_MACHINE_MODE, &machineMode, sizeof(int));
}
//---------------------------------------------------------------------------
// Status
//---------------------------------------------------------------------------
void __fastcall TMachine::ClearMachineStatus(void)
{
	memset(&Status, 0, sizeof(TMachineStatus));
	Status.OperationState = MACHINE_STATE_STOP;
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::ReadMachineStatus(void)
{
	bool returnValue = true;
	int statusKind = 0;

//	return returnValue;		// imsi


	try
	{
		statusKind = HCB_STATUS_KIND_MACHINE;
		Comm_SetMaxWaitingTime(COMM_HCB, 1500);
		if (!Comm_Request(COMM_HCB, CMD_STATUS, &statusKind, sizeof(int), &Status, sizeof(TMachineStatus)))
		{
	   		return false;
		}
		Comm_SetDefaultMaxWaitingTime(COMM_HCB);
		if (Status.AlarmExist)
		{
			statusKind = HCB_STATUS_KIND_ALARM;
			Comm_SetMaxWaitingTime(COMM_HCB, 1500);
			if (!Comm_Request(COMM_HCB, CMD_STATUS, &statusKind, sizeof(int), &AlarmStatus, sizeof(TMachineAlarmState)))
			{
		 		return false;
			}
		}
		else
		{
			memset(&AlarmStatus, 0, sizeof(TMachineAlarmState));
		}
		Comm_SetDefaultMaxWaitingTime(COMM_HCB);

		if (Status.WarningExist)
		{
			statusKind = HCB_STATUS_KIND_WARNING;
			Comm_SetMaxWaitingTime(COMM_HCB, 1500);
			if (!Comm_Request(COMM_HCB, CMD_STATUS, &statusKind, sizeof(int), &WarningStatus, sizeof(TMachineWarningState)))
			{
				return false;
			}
        }
        else
        {
			memset(&WarningStatus, 0, sizeof(TMachineWarningState));
		}
		Comm_SetDefaultMaxWaitingTime(COMM_HCB);
		ServoMotorRPM[SD1_MOTOR_INDEX] = Status.ServoMotorEncoderDiff[SD1_MOTOR_INDEX] / -8192.0 / 10 * 60;
		ServoMotorRPM[SD2_MOTOR_INDEX] = Status.ServoMotorEncoderDiff[SD2_MOTOR_INDEX] / 8192.0 / 10 * 60;
		ServoMotorRPM[BF_ID_MOTOR_INDEX] = Status.ServoMotorEncoderDiff[BF_ID_MOTOR_INDEX] / 8192.0 / 10 * 60;
		ServoMotorRPM[BF_OD_IN_MOTOR_INDEX] = Status.ServoMotorEncoderDiff[BF_OD_IN_MOTOR_INDEX] / -8192.0 / 10 / 105 * 25 * 60;

		if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
		{
			ServoMotorRPM[BF_OD_OUT_MOTOR_INDEX] = Status.ServoMotorEncoderDiff[BF_OD_OUT_MOTOR_INDEX] / -8192.0 / 10 / 105 * 25 * 60;
		}
	}
	catch (...)
	{
		returnValue = false;
	}

	return returnValue;
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::ReadPortStatus(void)
{
	
	int ret = 1;
	Comm_SetMaxWaitingTime(COMM_HCB, 1500);
	ret = Comm_Request(COMM_HCB, CMD_READ_PORT_STATUS, NULL, 0, &PortStatus, sizeof(TPortStatus));
	Comm_SetDefaultMaxWaitingTime(COMM_HCB);
	return ret;
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::ReadThreeDSensorStatus(void)
{
	int ret = 1;
	Comm_SetMaxWaitingTime(COMM_HCB, 1500);
	ret = Comm_Request(COMM_HCB, CMD_READ_3D_SENSOR_STATUS, NULL, 0, &ThreeDSensorStatus, sizeof(int) * 2);
	Comm_SetDefaultMaxWaitingTime(COMM_HCB);
	return ret;
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::ConfirmSuspend(void)
{
	TMachineControlData_Procedure machineControlData_Procedure;
	machineControlData_Procedure.MachineControlHeader.Target = MACHINE_CONTROL_PROCEDURE;
	machineControlData_Procedure.Action = 4;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_Procedure, sizeof(TMachineControlData_Procedure));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::SpeedChange(int *motorSpeedList)
{
	TMachineControlData_Procedure machineControlData_Procedure;
	machineControlData_Procedure.MachineControlHeader.Target = MACHINE_CONTROL_PROCEDURE;
	machineControlData_Procedure.Action = 5;
	machineControlData_Procedure.MaxSpeedTrainingMode = ProductData.MachineRunOption.MaxSpeedTrainingMode;
	machineControlData_Procedure.ManualMaxSpeed = ProductData.MachineRunOption.ManualMaxSpeed;
	for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
	{
	      machineControlData_Procedure.MotorSpeed[motorIndex] = motorSpeedList[motorIndex];
	}
	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_Procedure, sizeof(TMachineControlData_Procedure));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::MotorSpeedChange(int *motorSpeedList)
{
	TMachineControlData_Procedure machineControlData_Procedure;
	machineControlData_Procedure.MachineControlHeader.Target = MACHINE_CONTROL_PROCEDURE;
	machineControlData_Procedure.Action = 6;
	for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
	{
		machineControlData_Procedure.MotorSpeed[motorIndex] = motorSpeedList[motorIndex];
	}
	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_Procedure, sizeof(TMachineControlData_Procedure));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::InterlockCheck(void)
{
	if (Status.WarningExist &&
		(WarningStatus.FrontDoorOpen || WarningStatus.LeftDoorOpen))
	{
		return false;
	}
	else
	{
		return true;
	}
}
//---------------------------------------------------------------------------
WideString __fastcall TMachine::GetInterlockMessage(void)
{
	WideString doorStr = "";
  WCHAR TempString[100];

  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
  {
    doorStr = MACHINECONTROL_RETURNSTR_14;
  }
  else
  {
    if (WarningStatus.FrontDoorOpen)
    {
      doorStr = MACHINECONTROL_RETURNSTR_11;
    }
    if (WarningStatus.LeftDoorOpen)
    {
      doorStr = MACHINECONTROL_RETURNSTR_12;
    }
    if (WarningStatus.RightDoorOpen)
    {
      doorStr = MACHINECONTROL_RETURNSTR_10;
    }
  }
  wsprintfW(TempString, MACHINECONTROL_RETURNSTR_07, doorStr);
	return WideString(TempString);
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::CanCaptureStart(int lampKind)
{
/*
	if (Status.WarningExist &&
		(WarningStatus.SuctionDisk1LampDisconnected ||
		WarningStatus.SuctionDisk2LampDisconnected))
*/
	if (FSimulationMode || lampKind == MACHINE_LAMP_KIND_DISCONNECTED) return true;
	if (Status.SuctionDisk1LampKind != lampKind || Status.SuctionDisk2LampKind != lampKind)
	{
		return false;
	}
	else
	{
		return true;
	}
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::CanInspectionStart(int lampKind)
{
	if (FSimulationMode || lampKind == MACHINE_LAMP_KIND_DISCONNECTED) return true;
	if (Status.WarningExist &&
		(WarningStatus.BowlFeederSensorDisconnected))
	{
		return false;
	}
	else
	{
		if (Status.SuctionDisk1LampKind != lampKind || Status.SuctionDisk2LampKind != lampKind)
		{
			return false;
		}
		else
		{
			return true;
		}
	}
}
//---------------------------------------------------------------------------
WideString __fastcall TMachine::GetCaptureStartFailMessage(int lampKind)
{
	WideString returnStr = "";
  WCHAR TempString[1000];

	if (Status.SuctionDisk1LampKind != lampKind && lampKind != MACHINE_LAMP_KIND_DISCONNECTED)
	{
		if (Status.SuctionDisk1LampKind == MACHINE_LAMP_KIND_DISCONNECTED)
		{
      return WideString(MACHINECONTROL_RETURNSTR_03);
		}
    else
    {
      wsprintfW(TempString, MACHINECONTROL_RETURNSTR_02, LampKindStr(Status.SuctionDisk1LampKind));
			returnStr = WideString(TempString);
    }
    wsprintfW(TempString, MACHINECONTROL_RETURNSTR_01, LampKindStr(lampKind));
		returnStr += WideString(TempString);
		return returnStr;
	}
	else if (Status.SuctionDisk2LampKind != lampKind && lampKind != MACHINE_LAMP_KIND_DISCONNECTED)
	{
		if (Status.SuctionDisk2LampKind == MACHINE_LAMP_KIND_DISCONNECTED)
		{
      return WideString(MACHINECONTROL_RETURNSTR_05);
		}
    else
    {
      wsprintfW(TempString, MACHINECONTROL_RETURNSTR_04, LampKindStr(Status.SuctionDisk2LampKind));
			returnStr = WideString(TempString);
    }
    wsprintfW(TempString, MACHINECONTROL_RETURNSTR_01, LampKindStr(lampKind));
		returnStr += WideString(TempString);
		return returnStr;
	}
	else
	{
		return WideString(MACHINECONTROL_RETURNSTR_13);
	}
}
//---------------------------------------------------------------------------
WideString __fastcall TMachine::GetInspectionStartFailMessage(int lampKind)
{
	WideString returnStr = "";
  WCHAR TempString[100];

	if (Status.SuctionDisk1LampKind != lampKind && lampKind != MACHINE_LAMP_KIND_DISCONNECTED)
	{
		if (Status.SuctionDisk1LampKind == MACHINE_LAMP_KIND_DISCONNECTED)
		{
			returnStr = WideString(MACHINECONTROL_RETURNSTR_03);
		}
		else
		{
			wsprintfW(TempString, MACHINECONTROL_RETURNSTR_02, LampKindStr(Status.SuctionDisk1LampKind));
			returnStr = WideString(TempString);
		}
		wsprintfW(TempString, MACHINECONTROL_RETURNSTR_01, LampKindStr(lampKind));
		returnStr += WideString(TempString);
		return returnStr;
	}
	else if (Status.SuctionDisk2LampKind != lampKind && lampKind != MACHINE_LAMP_KIND_DISCONNECTED)
	{
		if (Status.SuctionDisk2LampKind == MACHINE_LAMP_KIND_DISCONNECTED)
		{
			returnStr = WideString(MACHINECONTROL_RETURNSTR_05);
		}
		else
		{
			wsprintfW(TempString, MACHINECONTROL_RETURNSTR_04, LampKindStr(Status.SuctionDisk2LampKind));
			returnStr = WideString(TempString);
		}
		wsprintfW(TempString, MACHINECONTROL_RETURNSTR_01, LampKindStr(lampKind));
		returnStr += WideString(TempString);
		return returnStr;
	}
	else if (WarningStatus.BowlFeederSensorDisconnected)
	{
		return WideString(MACHINECONTROL_RETURNSTR_09);
	}
	else
	{
		return WideString(MACHINECONTROL_RETURNSTR_06);
	}
}
//---------------------------------------------------------------------------
double __fastcall TMachine::GetServoMotorRPM(int motorIndex)
{
	return ServoMotorRPM[motorIndex];
}
//---------------------------------------------------------------------------
void __fastcall TMachine::SetSimulationMode(bool simulationMode)
{
	FSimulationMode = simulationMode;
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::OPDistributorOn(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 4;
	machineControlData_General.Value[0] = 14;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::OPDistributorOff(void)
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 4;
	machineControlData_General.Value[0] = 15;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::SafetyCircuitReset(void)
{
		TMachineControlData_General machineControlData_General;
		machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
		machineControlData_General.ActionN = 4;
		machineControlData_General.Value[0] = 18;

		return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));

}
//---------------------------------------------------------------------------

bool __fastcall TMachine::SetUIFlagData(void)
{
    return Comm_Request(COMM_HCB, CMD_PC_FLAG, &PcUiFlag, sizeof(TPcUiFlag));
}

//---------------------------------------------------------------------------
bool __fastcall TMachine::OP2Distributor1On(void)     //2й
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 4;
	machineControlData_General.Value[0] = 19;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::OP2Distributor2On(void)   //2й
{
	TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 4;
	machineControlData_General.Value[0] = 20;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::LaserPowerMeterOn(void)
{
  TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 2;
	machineControlData_General.Value[0] = 35;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
bool __fastcall TMachine::LaserPowerMeterOff(void)
{
  TMachineControlData_General machineControlData_General;
	machineControlData_General.MachineControlHeader.Target = MACHINE_CONTROL_GENERAL;
	machineControlData_General.ActionN = 2;
	machineControlData_General.Value[0] = 36;

	return Comm_Request(COMM_HCB, CMD_MACHINE_CONTROL, &machineControlData_General, sizeof(TMachineControlData_General));
}
//---------------------------------------------------------------------------
