//---------------------------------------------------------------------------

#ifndef MachineControlH
#define MachineControlH
#include <vcl.h>
#include "Common_PC.h"
#include "Command.h"

//---------------------------------------------------------------------------
class TMachine
{
private:
	int NCPosParamMul[MAX_STEP_MOTOR_COUNT];
	int NCPosParamDiv[MAX_STEP_MOTOR_COUNT];

	double ServoMotorRPM[MAX_SERVO_MOTOR_COUNT];
	bool FSimulationMode;
public:
	TMachineStatus Status;
	TMachineAlarmState AlarmStatus;
	TMachineWarningState WarningStatus;
	TPortStatus PortStatus;
  int ThreeDSensorStatus[2];

	__fastcall TMachine();
	// L0 Operations
	bool __fastcall PortTest(int physicalOPIndex, bool bOn);
	bool __fastcall PortTest_Blink(TOPTestData *opTestData);
	// L1 Operations
	bool __fastcall RingBlowerOn(int blowerIndex, int speed1, int speed2);
	bool __fastcall RingBlowerOff(int blowerIndex);
	bool __fastcall ServoMotorRun(int motorIndex, int baseSpeed, int targetSpeed, int accTime, int dir);
	bool __fastcall ServoMotorStop(int motorIndex, int decTime);
	bool __fastcall ServoMotorHoldOn(int motorIndex);
	bool __fastcall ServoMotorHoldOff(int motorIndex);
	bool __fastcall StepMotorMove(int motorIndex, int pulseCount, int dir);
	bool __fastcall AirKnifeOn(int akBit);
	bool __fastcall AirKnifeOff(int akBit);	
	bool __fastcall SDBlowerOn(int sdIndex);
	bool __fastcall SDBlowerOff(int sdIndex);
	bool __fastcall EjectorOn(int ejectorIndex);
	bool __fastcall EjectorOff(int ejectorIndex);
	bool __fastcall DustBlowerOn(int blowerIndex);
	bool __fastcall DustBlowerOff(int blowerIndex);
	bool __fastcall AirBrushIn(int abIndex);
	bool __fastcall AirBrushOut(int abIndex);
	bool __fastcall MisejectOpen(void);
	bool __fastcall MisejectClose(void);
	bool __fastcall MisejectStop(void);
	bool __fastcall LampOn(int lampIndex);
	bool __fastcall LampOff(int lampIndex);
	bool __fastcall BuzzerOn(void);
	bool __fastcall BuzzerOff(void);
	bool __fastcall RoomLampOn(void);
	bool __fastcall RoomLampOff(void);
	bool __fastcall VFMagnetOn(void);
	bool __fastcall VFMagnetOff(void);	
	bool __fastcall MELampOn(void);
	bool __fastcall MELampOff(void);
	bool __fastcall PLCOff(void);
	bool __fastcall PLCOn(void);
  bool __fastcall Buzzer2On(void);
	bool __fastcall Buzzer2Off(void);
  bool __fastcall Buzzer3On(void);
	bool __fastcall Buzzer3Off(void);
  bool __fastcall InterLockOn(void);
	bool __fastcall InterLockOff(void);
  bool __fastcall LaserPowerMeterOn(void);
	bool __fastcall LaserPowerMeterOff(void);


	// L2 Operations
	bool __fastcall SuctionDiskRun(int sd1Speed, int sd2Speed, int sd1InverterSpeed, int sd2InverterSpeed);
	bool __fastcall SuctionDiskStop(void);
	bool __fastcall SuctionDiskMotorStop(void);
	bool __fastcall BowlFeederRun(int bfIDSpeed, int bfOD1Speed,int bfOD2Speed, int airKnifeSpeed);
	bool __fastcall BowlFeederStop(void);
	bool __fastcall BowlFeederAKSpeedChange(int speed);
	bool __fastcall BowlFeederReset(void);
	bool __fastcall VFRun(int speed);
	bool __fastcall VFRun_AutoControl(char trainingMode, int manualModeSpeed, int manualModeSensorIndex, int manualModeSensorActiveRatio,
		int sensor1Ratio, int sensor2Ratio);
	bool __fastcall VFStop(void);
    bool __fastcall VFStartSpeedMode(int Mode);
	bool __fastcall DustSuctionOn(void);
	bool __fastcall DustSuctionOff(void);
	bool __fastcall EjectorTestRun(int ejectorIndex, int ejectorMask, int ejectorMaskCount);
	bool __fastcall EjectorTestStop(int ejectorIndex);
	bool __fastcall MisejectTestRun(int activeDelay, int durationTime);
	bool __fastcall MisejectTestStop(void);
	bool __fastcall NCHomeMoveTest(int motorIndex);
	bool __fastcall IlluminatorTestOn(int ledIndex, int mode, int onInterval, int offInterval);
	bool __fastcall IlluminatorTestOff(int ledIndex);
	bool __fastcall DisableBlackOut(void);
	bool __fastcall EnableBlackOut(void);
	// L3 Operations
	bool __fastcall NCHomeMove(void);
  bool __fastcall AlarmBuzzerON(void);
  bool __fastcall AlarmBuzzerOff(void);


	// L4 Operations
	bool __fastcall MachineStop(void);
	bool __fastcall MachineRun(int mode, TMachineRunOption *machineRunOption,
		double *ncMotorPos, int *motorSpeedList);
	bool __fastcall MachineReady(void);
	bool __fastcall MachineCleaning(void);
	bool __fastcall EmergencyStop(void);
	bool __fastcall SpeedChange(int *motorSpeedList);
	bool __fastcall MotorSpeedChange(int *motorSpeedList);
	bool __fastcall VibratorSpeedChange(int speed);
	bool __fastcall NCMovePos(int motorIndex, double targetPos);
    bool __fastcall VFSpeedChange(TMachineRunOption *machineRunOption);

	// Superviser Control
	bool __fastcall SetTestMode(void);
	bool __fastcall SetFreeMode(void);
	bool __fastcall SetInterlockMode(void);
	bool __fastcall SetMachineMode(int machineMode);
	// Status
	void __fastcall ClearMachineStatus(void);
	bool __fastcall ReadMachineStatus(void);
	bool __fastcall ReadPortStatus(void);
  bool __fastcall ReadThreeDSensorStatus(void);
	
	// ETC
	bool __fastcall ConfirmSuspend(void); 	// machine suspend reset (suspend -> stop)


	bool __fastcall InterlockCheck(void);
	WideString __fastcall GetInterlockMessage(void);
	bool __fastcall CanCaptureStart(int lampKind);
	bool __fastcall CanInspectionStart(int lampKind);
	WideString __fastcall GetCaptureStartFailMessage(int lampKind);
	WideString __fastcall GetInspectionStartFailMessage(int lampKind);

	double __fastcall GetServoMotorRPM(int motorIndex);

	void __fastcall SetSimulationMode(bool simulationMode);

  bool __fastcall TMachine::OPDistributorOn(void);
  bool __fastcall TMachine::OPDistributorOff(void);
  bool __fastcall TMachine::SafetyCircuitReset(void);  //Safety Circuit

  bool __fastcall TMachine::SetUIFlagData(void);
//  bool __fastcall TMachine::SetUVLaserStatus(void);

  //2й Test Button
  bool __fastcall OP2Distributor1On(void);
  bool __fastcall OP2Distributor2On(void);

  void __fastcall Acrocia_Set_AlarmStatus(int Type);  // Alarm Status Flag HCB ϵ
};

//---------------------------------------------------------------------------

#endif
