//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#include <cmath>
#pragma hdrstop

#include "TPBCameraSetting_Form.h"
#include "MachineControl_Form.h"
#include "MotorSetting_Form.h"
#include "MachineParamSetting_Form.h"
#include "Environment.h"
#include "TabletCounter_Form.h"
#include "IntervalSetting_Form.h"
#include "MachineSetting_Form.h"
#include "MotorSpeedSelection_Form.h"
#include "KeyBoard_Form.h"
#include "NewTabletCounter_Form.h"
#include "NCSetting_Form.h"
#include "AdvMachineControl_Form.h"
#include "MachineControl.h"
#include "Graph_Check_Form.h"
#include "MultiLanguage.h"
#include "ThreeDSensorStatusCheck_Form.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TMachineControlForm *MachineControlForm;
static int SLastVFSpeedValue = 100;
//---------------------------------------------------------------------------
__fastcall TMachineControlForm::TMachineControlForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  GetDefaultString();
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::GetDefaultString()
{
  EmergencyStopButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_01;
  MachineSettingButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_02;
  RunSpeedSpeedButton2->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_03;
  RunSpeedSpeedButton1->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_04;
  MainControlReadyButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_05;
  BowlFeederBreakButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_06;
  SDMotorStopSpeedButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_07;
  DustBlowOffButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_08;
  DustBlowOnButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_09;
  MainControlRunButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_10;
  SDRunSpeedButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_10;
  BowlFeederRunButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_10;
  Graph_Check->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_11;
  NCSettingButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_12;
  VFAutoSpeedButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_13;
  AdvMachineControlButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_14;
  MainControlStopButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_15;
  SDStopSpeedButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_15;
  BowlFeederStopButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_15;
  RunSpeedSpeedButton3->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_16;
  MainControlCleaningButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_17;
  VFRunSpeedButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_18;
  GeneralHomeSettingButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_19;
  this->Caption = MACHINECONTROLFORM_FORM_CAPTION_01;
  GroupBox13->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_01;
  GroupBox8->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_02;
  Label15->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_03;
  GroupBox9->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_04;
  GroupBox12->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_05;
  GroupBox5->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_06;
  GroupBox10->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_07;
  GroupBox7->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_08;
  GroupBox3->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_09;
  GroupBox11->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_10;
  GroupBox15->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_11;
  GroupBox16->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_12;
  GroupBox1->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_13;
  GroupBox4->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_14;

  Label24->Caption = MACHINECONTROLFORM_LABEL_CAPTION_01;
  TntLabel2->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_43;
  Label16->Caption = MACHINECONTROLFORM_LABEL_CAPTION_02;

  Label8->Caption = MACHINECONTROLFORM_LABEL_CAPTION_04;
  Label18->Caption = MACHINECONTROLFORM_LABEL_CAPTION_05;
  Label1->Caption = MACHINECONTROLFORM_LABEL_CAPTION_06;
  Label20->Caption = MACHINECONTROLFORM_LABEL_CAPTION_07;
  Label13->Caption = MACHINECONTROLFORM_LABEL_CAPTION_08;
  Label7->Caption = MACHINECONTROLFORM_LABEL_CAPTION_09;
  GroupBox14->Caption = MACHINECONTROLFORM_LABEL_CAPTION_10;
  Label11->Caption = MACHINECONTROLFORM_LABEL_CAPTION_11;
  Label10->Caption = MACHINECONTROLFORM_LABEL_CAPTION_12;
  Label14->Caption = MACHINECONTROLFORM_LABEL_CAPTION_13;
  Label5->Caption = MACHINECONTROLFORM_LABEL_CAPTION_14;
  AirKnifeSpeedRadioButton1->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_01;
  AirKnifeSpeedButton1->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_01;
  AirKnifeSpeedRadioButton2->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_02;
  AirKnifeSpeedButton2->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_02;
  AirKnifeSpeedRadioButton3->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_03;
  AirKnifeSpeedButton3->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_03;
  AirKnifeSpeedRadioButton0->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_04;
  VFManualTrainModeRadioButton->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_04;
  VFStopSpeedButton->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_04;
  AirKnifeSpeedButton0->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_04;

  TntGroupBox1->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_15;
  SensorRadioBtn1->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_05;
  SensorRadioBtn2->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_06;
  //ID , ӽ 
  Label19->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_42;
  Label26->Caption = ADVMACHINECONTROLFORM_LABEL_CAPTION_39;

  VFDelayRunSpeedButton->Caption 		= MACHINECONTROLFORM_BUTTON_CAPTION_27;
  VFAutoTrainModeRadioButton->Caption 	= MACHINECONTROLFORM_BUTTON_CAPTION_27;

  MisejectTestRunButton->Caption	= MACHINECONTROLFORM_BUTTON_CAPTION_28;
  MisejectTestStopButton->Caption	= MACHINECONTROLFORM_BUTTON_CAPTION_29;

  Label29->Caption = MACHINECONTROLFORM_LABEL_CAPTION_19;

  IntervalButton->Caption			= MACHINECONTROLFORM_BUTTON_CAPTION_31;
  TabletCounterButton->Caption		= MACHINECONTROLFORM_BUTTON_CAPTION_32;
  NewTabletCounterButton->Caption	= MACHINECONTROLFORM_BUTTON_CAPTION_33;
  Button1->Caption					= MACHINECONTROLFORM_BUTTON_CAPTION_34;
  ShowTPBButton->Caption			= MACHINECONTROLFORM_BUTTON_CAPTION_35;

  CloseButton->Caption	= MACHINECONTROLFORM_BUTTON_CAPTION_30;

  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
  {
    Label27->Visible = true;
    Label29->Visible = true;
    MisejectTestActiveDelayEdit->Visible = true;
    MisejectTestRunButton->Visible = true;
    MisejectTestStopButton->Visible = true;
  }
  
  if(MachineSetupData.MachineType < 2)
  {
	Label9->Caption = MACHINECONTROLFORM_LABEL_CAPTION_03;
	//TntLabel1->Caption = "ȸ̵  ũ ӵ";
	TntLabel1->Visible = false;
	BFOD2SpeedLabel->Visible = false;
    BFOD2SpeedEdit->Visible = false;
  }
  else // ۾
  {
	Label9->Caption = MACHINECONTROLFORM_LABEL_CAPTION_22;
	TntLabel1->Caption = MACHINECONTROLFORM_LABEL_CAPTION_23;
	TntLabel1->Visible = true;
	BFOD2SpeedLabel->Visible = true;
    BFOD2SpeedEdit->Visible = true;	
  }
  

  SensorRadioBtn3->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_08;

  EjectTestGroupBox->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_16;
  EjectTestButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_36;
  EjectorTestCountLabel->Caption = MACHINECONTROLFORM_LABEL_CAPTION_20;
  EjectTypeLabel->Caption = MACHINECONTROLFORM_LABEL_CAPTION_21;

  EjectTestSettingGroupBox1->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_17;
  EjectTestSettingGroupBox2->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_18;
  EjectTestSettingGroupBox3->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_19;
  EjectTestSettingGroupBox4->Caption = MACHINECONTROLFORM_GROUPBOX_CAPTION_20;

  EjectBlowRadioButton1->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_09;
  EjectBlowRadioButton2->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_09;
  EjectBlowRadioButton3->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_09;
  EjectBlowRadioButton4->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_09;

  EjectPassRadioButton1->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_10;
  EjectPassRadioButton2->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_10;
  EjectPassRadioButton3->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_10;
  EjectPassRadioButton4->Caption = MACHINECONTROLFORM_RADIOBTN_CAPTION_10;

  EjectTestRunButton->Caption = MACHINECONTROLFORM_BUTTON_CAPTION_20;

}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::CheckMachineStatus(void)
{
	if (Machine.Status.VibratorMode == 0)
	{
		VFRunSpeedButton->Down = true;
	}
    else if (Machine.Status.VibratorMode == 1)
    {
		VFStopSpeedButton->Down = true;
    }
    else if (Machine.Status.VibratorMode == 2)
    {
    	VFAutoSpeedButton->Down = true;
    }

	SD1SpeedEdit->Text = IntToStr(MachineOperationInfo.ServoMotorSpeed[SD1_MOTOR_INDEX]);
	SD2SpeedEdit->Text = IntToStr(MachineOperationInfo.ServoMotorSpeed[SD2_MOTOR_INDEX]);

	BFIDSpeedEdit->Text = IntToStr(MachineOperationInfo.ServoMotorSpeed[BF_ID_MOTOR_INDEX]);
	BFOD1SpeedEdit->Text = IntToStr(MachineOperationInfo.ServoMotorSpeed[BF_OD_IN_MOTOR_INDEX]);
	BFOD2SpeedEdit->Text = IntToStr(MachineOperationInfo.ServoMotorSpeed[BF_OD_OUT_MOTOR_INDEX]);
	
	VD1SpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / MachineOperationInfo.ServoMotorSpeed[SD1_MOTOR_INDEX]) + "%";
	VD2SpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / MachineOperationInfo.ServoMotorSpeed[SD2_MOTOR_INDEX]) + "%";

	BFIDSpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / MachineOperationInfo.ServoMotorSpeed[BF_ID_MOTOR_INDEX]) + "%";
	BFOD1SpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / MachineOperationInfo.ServoMotorSpeed[BF_OD_IN_MOTOR_INDEX]) + "%";

    if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
    {
		BFOD2SpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / MachineOperationInfo.ServoMotorSpeed[BF_OD_OUT_MOTOR_INDEX]) + "%";
    }
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::Button1Click(TObject *Sender)
{
	TMachineParamSettingForm *machineParamSettingForm = new TMachineParamSettingForm(this);
  machineParamSettingForm->ShowModal();
  delete machineParamSettingForm;

  if(0)// (MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
	{
    SensorRadioBtn1->Enabled = false;
    SensorRadioBtn2->Enabled = false;
		SensorRadioBtn3->Checked = true;

    TabletCounterButton->Visible = false;

    ViewThreeDSensorInfoBtn->Visible = true;
	}
  else
  {
    SensorRadioBtn1->Enabled = true;
    SensorRadioBtn2->Enabled = true;
    SensorRadioBtn3->Enabled = false;
    SensorRadioBtn1->Checked = true;

    ViewThreeDSensorInfoBtn->Visible = false;
  }
}
//---------------------------------------------------------------------------

void __fastcall TMachineControlForm::TabletCounterButtonClick(
      TObject *Sender)
{
	TabletCounterForm->Show();
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::CloseButtonClick(TObject *Sender)
{
  this->Close();
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::MotorSpeedEditChange(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	int motorIndex = theEdit->Tag;
	try
    {
		//StepMotorInfo[motorIndex].Modifier = StrToInt(theEdit->Text);
        MachineOperationInfo.ServoMotorSpeed[motorIndex] = StrToInt(theEdit->Text);

        switch(motorIndex)
        {
			case 0:
				VD1SpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / MachineOperationInfo.ServoMotorSpeed[motorIndex]) + "%";
				break;
			case 1:
				VD2SpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / MachineOperationInfo.ServoMotorSpeed[motorIndex]) + "%";
				break;
			case 2:
				BFIDSpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / MachineOperationInfo.ServoMotorSpeed[motorIndex]) + "%";
				break;
			case 3:
				BFOD1SpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / MachineOperationInfo.ServoMotorSpeed[motorIndex]) + "%";
			case 4:
				BFOD2SpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / MachineOperationInfo.ServoMotorSpeed[motorIndex]) + "%";				
                break;
        }
    }
    catch(...)
    {

    }
}
//---------------------------------------------------------------------------



void __fastcall TMachineControlForm::EmergencyStopButtonClick(
      TObject *Sender)
{
	Machine.EmergencyStop();
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::MachineSettingButtonClick(
      TObject *Sender)
{
#ifdef TEST_APP
	MachineSettingForm->Show();
#else
	TMachineSettingForm *machineSettingForm = new TMachineSettingForm(this);
    machineSettingForm->ShowModal();
    delete machineSettingForm;
#endif
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::MotorSpeedEditClick(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	int motorIndex = theEdit->Tag;

	TMotorSpeedSelectionForm *motorSpeedSelectionForm = new TMotorSpeedSelectionForm(this);
    motorSpeedSelectionForm->SetSpeed(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed, MachineOperationInfo.ServoMotorSpeed[motorIndex]);
    if (motorSpeedSelectionForm->ShowModal() == mrOk)
    {
		theEdit->Text = IntToStr(motorSpeedSelectionForm->GetSelectedSpeed());
    }
    delete motorSpeedSelectionForm;
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::NumEditClick(TObject *Sender)
{
		TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
  if (KeyboardForm->ShowKeypad() == mrOk)
  {

    if(theEdit->Tag == 999)
    {
      double TempText = StrToFloat(KeyboardForm->Text);
      TempText = floor(TempText*10)/10;
      if(TempText > 60)
        TempText = 60;
      theEdit->Text = FloatToStr(TempText);
    }
    else
  		theEdit->Text = KeyboardForm->Text;

  }
}
//---------------------------------------------------------------------------

void __fastcall TMachineControlForm::NewTabletCounterButtonClick(
      TObject *Sender)
{
	TNewTabletCounterForm *newTabletCounterForm = new TNewTabletCounterForm(this);
	newTabletCounterForm->ShowModal();
	delete newTabletCounterForm;
}
//---------------------------------------------------------------------------

void __fastcall TMachineControlForm::MainControlRunButtonClick(TObject *Sender)
{
	TMachineRunOption machineRunOption;
	int motorSpeedList[MAX_SERVO_MOTOR_COUNT];

  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
  {
    if(!Machine.PortStatus.IPStatus[OP_SAFETY_CIRCUIT_SELECT])
    {
      if (!Machine.InterlockCheck())
      {
        ShowMessageFA(Machine.GetInterlockMessage());
        return;
      }
    }
  }

  if (Machine.Status.OperationState != MACHINE_STATE_STOP &&
			Machine.Status.OperationState != MACHINE_STATE_CLEANING &&
			Machine.Status.OperationState != MACHINE_STATE_ATTACHING &&
			Machine.Status.OperationState != MACHINE_STATE_DETACHING)
  {
    Machine.MachineStop();
    ShowMessageFA(INSPECTIONFORM_MSG_23);
    return;
  }

	try
	{
		if (VFAutoTrainModeRadioButton->Checked)
		{
			machineRunOption.MaxSpeedTrainingMode = MAX_SPEED_TRAINING_MODE_AUTO;
		}
		else
		{
			machineRunOption.MaxSpeedTrainingMode = MAX_SPEED_TRAINING_MODE_MANUAL;
		}
		machineRunOption.ManualMaxSpeed = StrToInt(ManualMaxSpeedEdit->Text);
        machineRunOption.ManualModeSensorIndex = ManualModeSensorIndexComboBox->ItemIndex;
        machineRunOption.ManualModeSensorActiveRatio = StrToInt(ManualModeSensorActiveRatioEdit->Text);
		machineRunOption.EmptySensorActiveRatio = StrToInt(Sensor1RatioEdit->Text);
		machineRunOption.FullSensorActiveRatio = StrToInt(Sensor2RatioEdit->Text);

		machineRunOption.AirKnifeSpeed = 0;
		for (int airKnifeSpeedIndex = 0; airKnifeSpeedIndex < 4; airKnifeSpeedIndex++)
		{
			TTntRadioButton *airKnifeSpeedRadioButton = (TTntRadioButton *) FindComponent("AirKnifeSpeedRadioButton" + IntToStr(airKnifeSpeedIndex));
			if (airKnifeSpeedRadioButton)
			{
				if (airKnifeSpeedRadioButton->Checked)
				{
					machineRunOption.AirKnifeSpeed = airKnifeSpeedRadioButton->Tag;
					break;
				}
			}
		}
		machineRunOption.SuctionDisk1InverterSpeed = StrToInt(SuctionDiskSuctionSpeedEdit1->Text);
		machineRunOption.SuctionDisk2InverterSpeed = StrToInt(SuctionDiskSuctionSpeedEdit2->Text);
    machineRunOption.adjustEjectorWindStrength = MachineSetupData.EjectorInfo.EjectorWindStrength;        //cik add

		motorSpeedList[SD1_MOTOR_INDEX] = StrToInt(SD1SpeedEdit->Text);
		motorSpeedList[SD2_MOTOR_INDEX] = StrToInt(SD2SpeedEdit->Text);
		motorSpeedList[BF_ID_MOTOR_INDEX] = StrToInt(BFIDSpeedEdit->Text);
		motorSpeedList[BF_OD_IN_MOTOR_INDEX] = StrToInt(BFOD1SpeedEdit->Text);

		if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
		{
			motorSpeedList[BF_OD_OUT_MOTOR_INDEX] = StrToInt(BFOD2SpeedEdit->Text);		
		}
		else
		{	
			motorSpeedList[BF_OD_OUT_MOTOR_INDEX] = 0;		
		}
	

    if(SensorRadioBtn1->Checked)
      machineRunOption.EnabledSensorType = 0;
    else if(SensorRadioBtn2->Checked)
      machineRunOption.EnabledSensorType = 1;
    else
      machineRunOption.EnabledSensorType = 0;

		Machine.MachineRun(PROCEDURE_MODE_CAPTURE, &machineRunOption,
			ProductData.NCMotorPos, motorSpeedList);
	}
	catch (Exception &ec)
	{

	}
}
//---------------------------------------------------------------------------

void __fastcall TMachineControlForm::RunSpeedSpeedButtonClick(
      TObject *Sender)
{
	TTntSpeedButton *theButton = (TTntSpeedButton *) Sender;
	int speedIndex = theButton->Tag;
	if (!ProductData.ProductName.IsEmpty())
	{
		SD1SpeedEdit->Text = IntToStr(ProductData.MotorSpeedList[SD1_MOTOR_INDEX][speedIndex]);
		SD2SpeedEdit->Text = IntToStr(ProductData.MotorSpeedList[SD2_MOTOR_INDEX][speedIndex]);
		BFIDSpeedEdit->Text = IntToStr(ProductData.MotorSpeedList[BF_ID_MOTOR_INDEX][speedIndex]);
		BFOD1SpeedEdit->Text = IntToStr(ProductData.MotorSpeedList[BF_OD_IN_MOTOR_INDEX][speedIndex]);
		BFOD2SpeedEdit->Text = IntToStr(ProductData.MotorSpeedList[BF_OD_OUT_MOTOR_INDEX][speedIndex]);
	}
	else
	{
		ShowMessageFA(MACHINECONTROLFORM_MSG_02);
		/*
		SD1SpeedEdit->Text = IntToStr(MachineParams.MotorSpeedList[GetMSTabletTypeIndex(TABLET_TYPE_FILM_COATED)][GetMSTabletShapeIndex(TABLET_SHAPE_CIRCLE)][SD1_MOTOR_INDEX][speedIndex]);
		SD2SpeedEdit->Text = IntToStr(MachineParams.MotorSpeedList[GetMSTabletTypeIndex(TABLET_TYPE_FILM_COATED)][GetMSTabletShapeIndex(TABLET_SHAPE_CIRCLE)][SD2_MOTOR_INDEX][speedIndex]);
		BFIDSpeedEdit->Text = IntToStr(MachineParams.MotorSpeedList[GetMSTabletTypeIndex(TABLET_TYPE_FILM_COATED)][GetMSTabletShapeIndex(TABLET_SHAPE_CIRCLE)][BF_ID_MOTOR_INDEX][speedIndex]);
		BFODSpeedEdit->Text = IntToStr(MachineParams.MotorSpeedList[GetMSTabletTypeIndex(TABLET_TYPE_FILM_COATED)][GetMSTabletShapeIndex(TABLET_SHAPE_CIRCLE)][BF_OD_MOTOR_INDEX][speedIndex]);
		*/
	}
}
//---------------------------------------------------------------------------

void __fastcall TMachineControlForm::MainControlStopButtonClick(
      TObject *Sender)
{
	Machine.MachineStop();
}
//---------------------------------------------------------------------------

void __fastcall TMachineControlForm::MainControlCleaningButtonClick(
	  TObject *Sender)
{
	Machine.MachineCleaning();
}
//---------------------------------------------------------------------------

void __fastcall TMachineControlForm::MainControlReadyButtonClick(
	  TObject *Sender)
{
	Machine.MachineReady();
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::SDRunSpeedButtonClick(TObject *Sender)
{
	try
	{
		int sd1Speed = StrToInt(SD1SpeedEdit->Text);
		int sd2Speed = StrToInt(SD2SpeedEdit->Text);
		int sd1InverterSpeed = StrToInt(SuctionDiskSuctionSpeedEdit1->Text);
		int sd2InverterSpeed = StrToInt(SuctionDiskSuctionSpeedEdit2->Text);
		Machine.SuctionDiskRun(sd1Speed, sd2Speed, sd1InverterSpeed, sd2InverterSpeed);
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::SDStopSpeedButtonClick(
	  TObject *Sender)
{
	Machine.SuctionDiskStop();
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::SDMotorStopSpeedButtonClick(
	  TObject *Sender)
{
	Machine.SuctionDiskMotorStop();
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::BowlFeederRunButtonClick(
	  TObject *Sender)
{
	try
	{
		int bfIDSpeed = StrToInt(BFIDSpeedEdit->Text);
		int bfOD1Speed = StrToInt(BFOD1SpeedEdit->Text);
		int bfOD2Speed = StrToInt(BFOD2SpeedEdit->Text);
		int airKnifeSpeed = 0;
		for (int airKnifeSpeedIndex = 0; airKnifeSpeedIndex < 4; airKnifeSpeedIndex++)
		{
			TTntRadioButton *airKnifeSpeedRadioButton = (TTntRadioButton *) FindComponent("AirKnifeSpeedRadioButton" + IntToStr(airKnifeSpeedIndex));
			if (airKnifeSpeedRadioButton)
			{
				if (airKnifeSpeedRadioButton->Checked)
				{
					airKnifeSpeed = airKnifeSpeedRadioButton->Tag;
					break;
				}
			}
		}

		if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_BASIC || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_BASIC)
		{
			bfOD2Speed = 0;
		}

		Machine.BowlFeederRun(bfIDSpeed, bfOD1Speed, bfOD2Speed, airKnifeSpeed);
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::BowlFeederStopButtonClick(
	  TObject *Sender)
{
	Machine.BowlFeederStop();
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::AirKnifeSpeedButton0Click(TObject *Sender)
{
	Machine.BowlFeederAKSpeedChange(0);
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::AirKnifeSpeedButton1Click(
	  TObject *Sender)
{
	Machine.BowlFeederAKSpeedChange(1);
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::AirKnifeSpeedButton2Click(
	  TObject *Sender)
{
	Machine.BowlFeederAKSpeedChange(2);
}
//---------------------------------------------------------------------------

void __fastcall TMachineControlForm::AirKnifeSpeedButton3Click(
	  TObject *Sender)
{
	Machine.BowlFeederAKSpeedChange(3);
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::BowlFeederBreakButtonClick(
	  TObject *Sender)
{
	Machine.BowlFeederReset();
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::VFRunSpeedButtonClick(TObject *Sender)
{
	try
	{
		int vfSpeed = StrToInt(VFSpeedEdit->Text);
		Machine.VFRun(vfSpeed);
		SLastVFSpeedValue = vfSpeed;
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::VFAutoSpeedButtonClick(
	  TObject *Sender)
{
	TMachineRunOption machineRunOption;

	if (VFAutoTrainModeRadioButton->Checked)
	{
		machineRunOption.MaxSpeedTrainingMode = MAX_SPEED_TRAINING_MODE_AUTO;
	}
	else
	{
		machineRunOption.MaxSpeedTrainingMode = MAX_SPEED_TRAINING_MODE_MANUAL;
	}
	machineRunOption.ManualMaxSpeed = StrToInt(ManualMaxSpeedEdit->Text);
	machineRunOption.ManualModeSensorIndex = ManualModeSensorIndexComboBox->ItemIndex;
	machineRunOption.ManualModeSensorActiveRatio = StrToInt(ManualModeSensorActiveRatioEdit->Text);
	machineRunOption.EmptySensorActiveRatio = StrToInt(Sensor1RatioEdit->Text);
	machineRunOption.FullSensorActiveRatio = StrToInt(Sensor2RatioEdit->Text);

	Machine.VFRun_AutoControl(machineRunOption.MaxSpeedTrainingMode, machineRunOption.ManualMaxSpeed, machineRunOption.ManualModeSensorIndex,
    	machineRunOption.ManualModeSensorActiveRatio, machineRunOption.EmptySensorActiveRatio, machineRunOption.FullSensorActiveRatio);
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::VFStopSpeedButtonClick(
	  TObject *Sender)
{
	Machine.VFStop();
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::DustBlowOnButtonClick(TObject *Sender)
{
	Machine.DustSuctionOn();
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::DustBlowOffButtonClick(
	  TObject *Sender)
{
	Machine.DustSuctionOff();
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::EjectTestRunButtonClick(TObject *Sender)
{
	int ejectorMaskValue[4] = {0,};
	int ejectorMask = 0;
	int ejectorMaskCount = (EjectTestCountComboBox->ItemIndex)+1;
    TEjectorTestSetupData EjectorTestSetupData;

    Machine.EjectorTestStop(EjectType);

	EjectorTestSetupData.SuctionDiskSpeed = StrToInt(SD1SpeedEdit->Text);
	EjectorTestSetupData.StudiedSensorIntervalA = ProductData.StudiedSensorIntervalA;
	EjectorTestSetupData.StudiedSensorIntervalB = ProductData.StudiedSensorIntervalB;
	EjectorTestSetupData.StudiedTabletSensor1Length = ProductData.StudiedSensor1Length;
	EjectorTestSetupData.StudiedTabletSensor2Length = ProductData.StudiedSensor2Length;
	EjectorTestSetupData.StudiedTabletSensor3Length = ProductData.StudiedSensor3Length;
	EjectorTestSetupData.CaptureMode = 0;

    if(EjectBlowRadioButton1->Checked) ejectorMaskValue[0] = 0x1;
    else ejectorMaskValue[0] = 0;

    if(EjectBlowRadioButton2->Checked) ejectorMaskValue[1] = 0x2;
    else ejectorMaskValue[1] = 0;

    if(EjectBlowRadioButton3->Checked) ejectorMaskValue[2] = 0x4;
    else ejectorMaskValue[2] = 0;

    if(EjectBlowRadioButton4->Checked) ejectorMaskValue[3] = 0x8;
    else ejectorMaskValue[3] = 0;

    switch(ejectorMaskCount)
    {             
    	case 1 : 	ejectorMask = ejectorMaskValue[0]; break;
    	case 2 : 	ejectorMask = ejectorMaskValue[0] + ejectorMaskValue[1]; break;
    	case 3 : 	ejectorMask = ejectorMaskValue[0] + ejectorMaskValue[1] + ejectorMaskValue[2]; break;
    	case 4 : 	ejectorMask = ejectorMaskValue[0] + ejectorMaskValue[1] + ejectorMaskValue[2] + ejectorMaskValue[3]; break;
		default : 	ejectorMask = ejectorMaskValue[0]; break;
    }

    Comm_Request(COMM_HCB, CMD_EJECTOR_TEST_SETUP, &EjectorTestSetupData, sizeof(TEjectorTestSetupData));
    
	Machine.EjectorTestRun(EjectType, ejectorMask, ejectorMaskCount);
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::IntervalButtonClick(TObject *Sender)
{
  TIntervalSettingForm *IntervalSettingForm = new TIntervalSettingForm(this);

  IntervalSettingForm->ShowModal();

  delete IntervalSettingForm;
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::NCSettingButtonClick(TObject *Sender)
{
	bool homeDetected = true;
	for (int motorIndex = 0; motorIndex < MAX_STEP_MOTOR_COUNT; motorIndex++)
	{
		if (!Machine.Status.OriginDetected[motorIndex])
		{
			homeDetected = false;
			break;
		}
	}
	if (!homeDetected)
	{
		ShowMessageFA(MACHINECONTROLFORM_MSG_01);
		return;
	}

	TNCSettingForm *ncSettingForm = new TNCSettingForm(this);
	ncSettingForm->ShowModal();
	delete ncSettingForm;
}
//---------------------------------------------------------------------------

void __fastcall TMachineControlForm::GeneralHomeSettingButtonClick(
      TObject *Sender)
{
	Machine.NCHomeMove();
}
//---------------------------------------------------------------------------

void __fastcall TMachineControlForm::VFDelayRunSpeedButtonClick(
	  TObject *Sender)
{
	try
	{
		int vfSpeed = StrToInt(VFSpeedEdit->Text);
		Machine.VFRun(vfSpeed);
		SLastVFSpeedValue = vfSpeed;
		int vibratorRunDelay = StrToInt(VFDelayRunEdit->Text);
		VibratorStopTime = GetTickCount() + vibratorRunDelay * 1000;
		VibratorRunTimer->Enabled = true;
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------

void __fastcall TMachineControlForm::VibratorRunTimerTimer(TObject *Sender)
{
	if (GetTickCount() > VibratorStopTime)
	{
		VFStopSpeedButton->Click();
		VFStopSpeedButton->Down = true;
		VibratorRunTimer->Enabled = false;
	}
}
//---------------------------------------------------------------------------

void __fastcall TMachineControlForm::AdvMachineControlButtonClick(
      TObject *Sender)
{
  if(!ProductData.ProductName.IsEmpty())
  {
    AdvMachineControlForm->ApplyProductInfo();
  }
  else
  {
    AdvMachineControlForm->ApplyDefaultParams();
  }
  
	AdvMachineControlForm->ShowModal();
}
//---------------------------------------------------------------------------


void __fastcall TMachineControlForm::MisejectTestRunButtonClick(
      TObject *Sender)
{
	try
	{
		int misejectActiveDelay = StrToFloat(MisejectTestActiveDelayEdit->Text)*1000.0f;
		int misejectDurationTime = StrToInt(MisejectTestDurationTimeEdit->Text);
		Machine.MisejectTestRun(misejectActiveDelay, misejectDurationTime);
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::MisejectTestStopButtonClick(
	  TObject *Sender)
{
	Machine.MisejectTestStop();
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::Graph_CheckClick(TObject *Sender)
{
	Graph_CheckForm->Show();
}
//---------------------------------------------------------------------------
void __fastcall TMachineControlForm::TntFormCreate(TObject *Sender)
{
  // ӵ ʱⰪ  -  ִ ӵ
  SD1SpeedEdit->Text = IntToStr(MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed);
  SD2SpeedEdit->Text = IntToStr(MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed);
  BFIDSpeedEdit->Text = IntToStr(MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed);
  BFOD1SpeedEdit->Text = IntToStr(MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed);
  BFOD2SpeedEdit->Text = IntToStr(MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed);

  if(!PCProgramOption.SensorOutputSettingOption)
  {
    TntGroupBox1->Visible = false;
  }

	if(0)// (MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
	{
    SensorRadioBtn1->Enabled = false;
    SensorRadioBtn2->Enabled = false;
		SensorRadioBtn3->Checked = true;

    TabletCounterButton->Visible = false;

    ViewThreeDSensorInfoBtn->Visible = true;
	}
  else
  {
    ViewThreeDSensorInfoBtn->Visible = false;
  }

  Machine.MachineStop();
}
//---------------------------------------------------------------------------

/*
*  SELMA 200 ߰ 
*/


void __fastcall TMachineControlForm::ViewThreeDSensorInfoBtnClick(
      TObject *Sender)
{
  ThreeDSensorStatusCheckForm->Show();
}
//---------------------------------------------------------------------------

void __fastcall TMachineControlForm::ShowTPBButtonClick(TObject *Sender)
{
  TPBCameraSettingForm->ShowModal();  
}
//---------------------------------------------------------------------------


void __fastcall TMachineControlForm::EjectSetupButtonClick(TObject *Sender)
{
    MachineSetupData.EjectorInfo.DefectEjectorDelay = StrToInt(DefectEjectorDelayEdit->Text);
    MachineSetupData.EjectorInfo.DefectEjectorLength= StrToInt(DefectEjectorLengthEdit->Text);
    MachineSetupData.EjectorInfo.UnInsEjectorDelay = StrToInt(UnInsEjectorDelayEdit->Text);
    MachineSetupData.EjectorInfo.UnInsEjectorLength= StrToInt(UnInsEjectorLengthEdit->Text);
    MachineSetupData.EjectorInfo.GoodEjectorDelay = StrToInt(GoodEjectorDelayEdit->Text);
    MachineSetupData.EjectorInfo.GoodEjectorLength= StrToInt(GoodEjectorLengthEdit->Text);

    MachineSetupData.EjectorInfo.MisejectActive = MisejectActiveCheckBox->Checked ? 1 : 0;
    
    MachineSetupData.EjectorInfo.MisejectActiveDelay = StrToFloat(MisejectActiveDelayEdit->Text)*20000.0f; // HCB 50us Timer Count 1s = 20000

    //cik add
    MachineSetupData.EjectorInfo.EjectorWindStrength = StrToInt(EjectorWindStrengthEdit->Text);

    WriteMachineSetupData(ProgramPath.Env + "\\SystemInfor.ini",MachineSetupData);

	if (!Comm_Request(COMM_HCB, CMD_MACHINE_PARAM_SETUP, &MachineSetupData, sizeof(TMachineSetupData)))
	{
		//ShowMessageW(HCBConnection.GetLastErrorMessage());
	}
	else
	{
		ShowMessageFA(MACHINEPARAMSETTINGFORM_MSG_01);
	}
}
//---------------------------------------------------------------------------

void __fastcall TMachineControlForm::EjectorSetupCloseButtonClick(TObject *Sender)
{
	EjectorTestPanel->Visible = false;
}
//---------------------------------------------------------------------------

void __fastcall TMachineControlForm::EjectTestButtonClick(TObject *Sender)
{
    DefectEjectorDelayEdit->Text = IntToStr(MachineSetupData.EjectorInfo.DefectEjectorDelay);
    UnInsEjectorDelayEdit->Text = IntToStr(MachineSetupData.EjectorInfo.UnInsEjectorDelay);
    GoodEjectorDelayEdit->Text = IntToStr(MachineSetupData.EjectorInfo.GoodEjectorDelay);
    DefectEjectorLengthEdit->Text = IntToStr(MachineSetupData.EjectorInfo.DefectEjectorLength);
    UnInsEjectorLengthEdit->Text = IntToStr(MachineSetupData.EjectorInfo.UnInsEjectorLength);
    GoodEjectorLengthEdit->Text = IntToStr(MachineSetupData.EjectorInfo.GoodEjectorLength);


EjectorWindStrengthEdit->Text = IntToStr(MachineSetupData.EjectorInfo.EjectorWindStrength);

MisejectActiveCheckBox->Checked = (MachineSetupData.EjectorInfo.MisejectActive != 0);

MisejectActiveDelayEdit->Text = FloatToStr(MachineSetupData.EjectorInfo.MisejectActiveDelay/ 20000.0f) ;

	EjectorTestPanel->Visible = true;

    EjectBlowRadioButton1->Checked = true;
    EjectBlowRadioButton2->Checked = true;
    EjectBlowRadioButton3->Checked = true;
    EjectBlowRadioButton4->Checked = true;
}
//---------------------------------------------------------------------------





void __fastcall TMachineControlForm::EjectTestCountComboBoxChange(
      TObject *Sender)
{
	int testCntNum = (EjectTestCountComboBox->ItemIndex) + 1;

    switch(testCntNum)
    {
    	case 1 :
	        EjectTestSettingGroupBox1->Visible = true;
	        EjectTestSettingGroupBox2->Visible = false;
	        EjectTestSettingGroupBox3->Visible = false;
	        EjectTestSettingGroupBox4->Visible = false;
            break;

    	case 2 :
	        EjectTestSettingGroupBox1->Visible = true;
	        EjectTestSettingGroupBox2->Visible = true;
	        EjectTestSettingGroupBox3->Visible = false;
	        EjectTestSettingGroupBox4->Visible = false;
            break;

    	case 3 :
	        EjectTestSettingGroupBox1->Visible = true;
	        EjectTestSettingGroupBox2->Visible = true;
	        EjectTestSettingGroupBox3->Visible = true;
	        EjectTestSettingGroupBox4->Visible = false;
            break;

    	case 4 :
	        EjectTestSettingGroupBox1->Visible = true;
	        EjectTestSettingGroupBox2->Visible = true;
	        EjectTestSettingGroupBox3->Visible = true;
	        EjectTestSettingGroupBox4->Visible = true;
            break;

        default :
	        EjectTestSettingGroupBox1->Visible = true;
	        EjectTestSettingGroupBox2->Visible = false;
	        EjectTestSettingGroupBox3->Visible = false;
	        EjectTestSettingGroupBox4->Visible = false;
            break;
    }
}
//---------------------------------------------------------------------------


void __fastcall TMachineControlForm::EjectTypeComboBoxChange(TObject *Sender)
{
	EjectType = EjectTypeComboBox->ItemIndex;
}
//---------------------------------------------------------------------------


