//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#include <cmath>
#include <math.h>
#pragma hdrstop

#include "MachineParamSetting_Form.h"
#include "Message_Form.h"
#include "MotorSpeedSelection_Form.h"
#include "Keyboard_Form.h"
#include "MultiLanguage.h"
#include "Main_Form.h"
#include "SystemSetup.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntComCtrls"
#pragma link "TntExtCtrls"
#pragma link "TntGrids"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"


TMachineParamSettingForm *MachineParamSettingForm;
//---------------------------------------------------------------------------
__fastcall TMachineParamSettingForm::TMachineParamSettingForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  GetDefaultString();

  if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED )
  {
	SpeedSettingStringGrid->ColCount = 6;
 	StudySpeedSettingStringGrid->ColCount = 6;
	SpeedSettingStringGrid->Cells[1][0] = "M1";
	SpeedSettingStringGrid->Cells[2][0] = "M2";
	SpeedSettingStringGrid->Cells[3][0] = "M3";
	SpeedSettingStringGrid->Cells[4][0] = "M4";
	SpeedSettingStringGrid->Cells[5][0] = "M5";

	StudySpeedSettingStringGrid->Cells[1][0] = "M1";
	StudySpeedSettingStringGrid->Cells[2][0] = "M2";
	StudySpeedSettingStringGrid->Cells[3][0] = "M3";
	StudySpeedSettingStringGrid->Cells[4][0] = "M4";  
	StudySpeedSettingStringGrid->Cells[5][0] = "M5";  
  }
  else
  {
	SpeedSettingStringGrid->ColCount = 5;
 	StudySpeedSettingStringGrid->ColCount = 5; 
	SpeedSettingStringGrid->Cells[1][0] = "M1";
	SpeedSettingStringGrid->Cells[2][0] = "M2";
	SpeedSettingStringGrid->Cells[3][0] = "M3";
	SpeedSettingStringGrid->Cells[4][0] = "M4";

	StudySpeedSettingStringGrid->Cells[1][0] = "M1";
	StudySpeedSettingStringGrid->Cells[2][0] = "M2";
	StudySpeedSettingStringGrid->Cells[3][0] = "M3";
	StudySpeedSettingStringGrid->Cells[4][0] = "M4";
  }

  for(int i = 0 ; i < 9 ; ++i)
  {
    SimpleSpeedControlStringGrid->Cells[i+1][0] = "No."+IntToStr(i+1);
    SimpleSpeedControlStringGrid2->Cells[i+1][0] = "No."+IntToStr(i+10);
  }

  SimpleSpeedControlCheckBox->Caption = "Enable Step by step speed Function";

	for (int speedIndex = 0; speedIndex < MS_MOTOR_SPEED_STEP_COUNT; speedIndex++)
  {
		SpeedSettingStringGrid->Cells[0][speedIndex + 1] = IntToStr(speedIndex+1);
  }

  //߰  Option ̴.
  if((MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1) || (MachineSetupData.CompanyID == DOMESTIC_MACHINE2))
  {
     if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
     {
       EjectorSpecialModeRadioButton->Visible = false;
       SimpleSpeedControlCheckBox->Visible = true;
       TntGroupBox3->Visible = true;
       GearRatioGroupBox->Visible = false;
     }
  }
  else
  {
     GearRatioGroupBox->Visible = true;
  }

}
//---------------------------------------------------------------------------
void __fastcall TMachineParamSettingForm::GetDefaultString()
{
  TabSheet5->Caption = MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_06;
  TabSheet1->Caption = MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_07;
  TabSheet3->Caption = MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_08;
  TabSheet4->Caption = MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_09;
  TabSheet7->Caption = MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_12;
  TabSheet2->Caption = MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_13;
  TabSheet8->Caption = MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_21;

  SetDefaultSpeedButton->Caption = MACHINEPARAMSETTINGFORM_BUTTON_CAPTION_01;
  SpeedButton1->Caption = MACHINEPARAMSETTINGFORM_BUTTON_CAPTION_02;
  MSTabletTypeSpeedButton3->Caption = MACHINEPARAMSETTINGFORM_BUTTON_CAPTION_03;
  MSTabletTypeSpeedButton2->Caption = MACHINEPARAMSETTINGFORM_BUTTON_CAPTION_04;
  MSTabletShapeSpeedButton1->Caption = MACHINEPARAMSETTINGFORM_BUTTON_CAPTION_05;
  MSTabletTypeSpeedButton1->Caption = MACHINEPARAMSETTINGFORM_BUTTON_CAPTION_06;
  DoorInterlockCheckBox->Caption = MACHINEPARAMSETTINGFORM_CHECKBOX_CAPTION_01;
  GroupBox6->Caption = MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_02;
  Label4->Caption = MACHINEPARAMSETTINGFORM_LABEL_CAPTION_01;
  Label6->Caption = MACHINEPARAMSETTINGFORM_LABEL_CAPTION_02;
  Label8->Caption = MACHINEPARAMSETTINGFORM_LABEL_CAPTION_04;
  Label10->Caption = MACHINEPARAMSETTINGFORM_LABEL_CAPTION_05;
  Label12->Caption = MACHINEPARAMSETTINGFORM_LABEL_CAPTION_06;
  Label1->Caption = MACHINEPARAMSETTINGFORM_LABEL_CAPTION_07;
  Label53->Caption = MACHINEPARAMSETTINGFORM_LABEL_CAPTION_08;
  BuzzerContinuousOnRadioButton->Caption = MACHINEPARAMSETTINGFORM_RADIOBTN_CAPTION_01;
  BuzzerIntervalOnRadioButton->Caption = MACHINEPARAMSETTINGFORM_RADIOBTN_CAPTION_02;
  BowlfeederSensorActiveCheckbox->Caption=MACHINEPARAMSETTINGFORM_LABEL_CAPTION_09;
  Label24->Caption=MACHINEPARAMSETTINGFORM_LABEL_CAPTION_10;
  Label44->Caption=MACHINEPARAMSETTINGFORM_LABEL_CAPTION_11;
  Label43->Caption=MACHINEPARAMSETTINGFORM_LABEL_CAPTION_12;
  HopperEmptyCheckBox->Caption=MACHINEPARAMSETTINGFORM_LABEL_CAPTION_13;
  Label27->Caption=GRAPHCHECKFORM_GROUPBOX_CAPTION_02;
  Label28->Caption=GRAPHCHECKFORM_GROUPBOX_CAPTION_03;

  TntGroupBox2->Caption=MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_14;
  GroupBox4->Caption=MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_15;
//  GroupBox3->Caption=MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_16;
  TntGroupBox1->Caption=MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_05;
  GroupBox7->Caption=MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_18;
  GroupBox1->Caption=MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_19;
  GroupBox2->Caption=MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_20;
  MSTabletShapeSpeedButton2->Caption=PRODUCTINPUTFORM_PANEL_CAPTION_18;
  MSTabletShapeSpeedButton3->Caption=PRODUCTINPUTFORM_PANEL_CAPTION_26;
  StudySpeedSettingStringGrid->Cells[0][1] = MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_17;
  SimpleSpeedControlStringGrid->Cells[0][1] = MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_17;
  SimpleSpeedControlStringGrid2->Cells[0][1] = MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_17;
  EjectorNormalModeButton->Caption = MACHINEPARAMSETTINGFORM_LABEL_CAPTION_14;
  EjectorSpecialModeRadioButton->Caption = MACHINEPARAMSETTINGFORM_LABEL_CAPTION_15;
  MisejectActiveCheckBox->Caption = MACHINEPARAMSETTINGFORM_LABEL_CAPTION_19;
  Label49->Caption = MACHINEPARAMSETTINGFORM_LABEL_CAPTION_20;

  TntLabel15->Caption = MACHINEPARAMSETTINGFORM_LABEL_CAPTION_21;
  SafetyRunRadioBtn->Caption = MACHINEPARAMSETTINGFORM_LABEL_CAPTION_22;
  SafetyMaintenaceRadioBtn->Caption = MACHINEPARAMSETTINGFORM_LABEL_CAPTION_23;
  RingBlowerDelayLabel->Caption = MACHINEPARAMSETTINGFORM_LABEL_CAPTION_24;


  TntLabel23->Caption = MACHINEPARAMSETTINGFORM_LABEL_CAPTION_27;
  ACModeCheckBox->Caption = MACHINEPARAMSETTINGFORM_LABEL_CAPTION_28;

  Label26->Caption 		= MACHINEPARAMSETTINGFORM_LABEL_CAPTION_41;
  TntLabel37->Caption 	= MACHINEPARAMSETTINGFORM_LABEL_CAPTION_42;
  TntLabel20->Caption 	= MACHINEPARAMSETTINGFORM_LABEL_CAPTION_43;
  Label34->Caption 		= MACHINEPARAMSETTINGFORM_LABEL_CAPTION_44;
  TntLabel21->Caption 	= MACHINEPARAMSETTINGFORM_LABEL_CAPTION_45;

  cbAutoDemper->Caption = MACHINEPARAMSETTINGFORM_CHECKBOX_CAPTION_05;
  
  TntGroupBox7->Caption = MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_35;
  CamBootingEnableCheckBox->Caption = MACHINEPARAMSETTINGFORM_CHECKBOX_CAPTION_06;

  this->Caption = MACHINEPARAMSETTINGFORM_LABEL_CAPTION_46;

  GroupBox8->Caption 			= MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_36;
  GroupBox9->Caption 			= MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_37;

  SensorGroupbox->Caption 		= MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_46;
  TntLabel22->Caption 			= MACHINEPARAMSETTINGFORM_LABEL_CAPTION_47;

  GroupBox3->Caption 			= MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_38;
  GroupBox11->Caption 			= MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_39;
  GroupBox12->Caption 			= MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_40;
  GroupBox13->Caption 			= MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_41;

  Label3->Caption 				= MACHINEPARAMSETTINGFORM_LABEL_CAPTION_48;
  Label15->Caption 				= MACHINEPARAMSETTINGFORM_LABEL_CAPTION_48;
  TntLabel4->Caption 			= MACHINEPARAMSETTINGFORM_LABEL_CAPTION_48;

  Label35->Caption 				= MACHINEPARAMSETTINGFORM_LABEL_CAPTION_49;
  Label39->Caption 				= MACHINEPARAMSETTINGFORM_LABEL_CAPTION_49;
  TntLabel11->Caption 			= MACHINEPARAMSETTINGFORM_LABEL_CAPTION_49;

  TntLabel1->Caption 			= MACHINEPARAMSETTINGFORM_LABEL_CAPTION_50;

  GearRatioGroupBox->Caption 	= MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_43;

  TntGroupBox5->Caption 		= MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_44;
  TntGroupBox6->Caption 		= MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_45;
  TntLabel24->Caption 			= MACHINEPARAMSETTINGFORM_LABEL_CAPTION_53;
  TntLabel26->Caption 			= MACHINEPARAMSETTINGFORM_LABEL_CAPTION_53;

  GroupBox10->Caption 			= MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_42;
  TntLabel2->Caption 			= MACHINEPARAMSETTINGFORM_LABEL_CAPTION_51;
  TntLabel3->Caption 			= MACHINEPARAMSETTINGFORM_LABEL_CAPTION_52;

  BitBtn1->Caption				= MACHINEPARAMSETTINGFORM_BUTTON_CAPTION_07;
  BitBtn2->Caption				= MACHINEPARAMSETTINGFORM_BUTTON_CAPTION_08;

  cbAutoDemper->Caption				= MACHINEPARAMSETTINGFORM_CHECKBOX_CAPTION_05;
  TntGroupBox7->Caption 			= MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_35;
  CamBootingEnableCheckBox->Caption	= MACHINEPARAMSETTINGFORM_CHECKBOX_CAPTION_06;

  GroupBox10->Caption				= MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_42;
  TntLabel2->Caption				= MACHINEPARAMSETTINGFORM_LABEL_CAPTION_51;
  TntLabel3->Caption				= MACHINEPARAMSETTINGFORM_LABEL_CAPTION_52;

}
//---------------------------------------------------------------------------

void __fastcall TMachineParamSettingForm::BitBtn1Click(TObject *Sender)
{
  bool LaserComplexValueChange = false;
	// save param
    try
    {
	if ((MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1) || (MachineSetupData.CompanyID == DOMESTIC_MACHINE2))
	{
		if (Laser_complexer_Enable->Checked)
		{
			ShowMessageFA("Invalid option : Laser function is not supported.(CompanyID[INTERNATIONAL_MACHINE1, DOMESTIC_MACHINE2])");
			return;
		}
	}
    MachineSetupData.MachineMode = MachineModeComboBox->ItemIndex;
    MachineSetupData.MachineType = MachineTypeComboBox->ItemIndex; 
    MachineSetupData.PC_Power_Mode = PCPowerModeComboBox->ItemIndex;

    // ldh : Special Mode ǰ  
    MachineSetupData.EjectorInfo.SpModeGoodTabletCollectCount1 = StrToInt(GoodCollect1TntEdit->Text);
    MachineSetupData.EjectorInfo.SpModeGoodTabletCollectCount2 = StrToInt(GoodCollect2TntEdit->Text);

    MachineSetupData.EjectorInfo.DefectEjectorDelay = StrToInt(DefectEjectorDelayEdit->Text);
    MachineSetupData.EjectorInfo.DefectEjectorLength= StrToInt(DefectEjectorLengthEdit->Text);
    MachineSetupData.EjectorInfo.UnInsEjectorDelay = StrToInt(UnInsEjectorDelayEdit->Text);
    MachineSetupData.EjectorInfo.UnInsEjectorLength= StrToInt(UnInsEjectorLengthEdit->Text);
    MachineSetupData.EjectorInfo.GoodEjectorDelay = StrToInt(GoodEjectorDelayEdit->Text);
    MachineSetupData.EjectorInfo.GoodEjectorLength= StrToInt(GoodEjectorLengthEdit->Text);

    MachineSetupData.EjectorInfo.MisejectActive = MisejectActiveCheckBox->Checked ? 1 : 0;

    if(ckbTPB_Active->Checked)
    	MachineSetupData.EjectorInfo.TPB_MisejectActive = 1;
    else
    	MachineSetupData.EjectorInfo.TPB_MisejectActive = 0;
    	
    MachineSetupData.EjectorInfo.TPB_MisejectOpenDelay 		= StrToInt(eTPB_MisOpenDelayTime->Text);
    MachineSetupData.EjectorInfo.TPB_MisejectOpenRunTime 	= StrToInt(eTPB_MisOpenRunTime->Text);
    MachineSetupData.EjectorInfo.TPB_MisCmdValidCnt				= StrToInt(eTPB_MisCmdValidCnt->Text);

    if(ckbMultiMisejectAction->Checked)
    	MachineSetupData.EjectorInfo.IgnoreMultiMisejectAction = 1;
    else
    	MachineSetupData.EjectorInfo.IgnoreMultiMisejectAction = 0;    

    if(ckbTPB_MisejectOperationMode->Checked)
    	MachineSetupData.EjectorInfo.TPB_MisejectOperationMode = TPB_MISEJECT_NO_INSPECTION_MODE;
    else
    	MachineSetupData.EjectorInfo.TPB_MisejectOperationMode = TPB_MISEJECT_NORMAL_MODE;
    
    MachineSetupData.EjectorInfo.MisejectActiveDelay = StrToFloat(MisejectActiveDelayEdit->Text)*20000.0f; // HCB 50us Timer Count 1s = 20000

    //cik add
    MachineSetupData.EjectorInfo.EjectorWindStrength = StrToInt(EjectorWindStrengthEdit->Text);
    MachineSetupData.EjectorInfo.EjectorDefaultMode =  EjectorNormalModeButton->Checked ? 0 : 1; // 0 븻 1 

    MachineSetupData.VFInfo.ManualModeSensorIndex = ManualModeSensroIndexComboBox->ItemIndex;
    MachineSetupData.VFInfo.ManualModeSensorActiveRatio = StrToInt(ManualModeSensorActiveRatioEdit->Text);
    MachineSetupData.VFInfo.EmptySensorActiveRatio = StrToInt(EmptySensorActiveEdit->Text);
    MachineSetupData.VFInfo.FullSensorActiveRatio = StrToInt(FullSensorActiveEdit->Text);
    MachineSetupData.VFInfo.MechanicalMinSpeed = StrToInt(MechanicalMinSpeedEdit->Text);
    MachineSetupData.VFInfo.MechanicalMaxSpeed = StrToInt(MechanicalMaxSpeedEdit->Text);
    MachineSetupData.VFInfo.FeederEmptyAlarmDelayTime = StrToInt(VBSensorWarningDelayAlarmEdit->Text);
    MachineSetupData.InterlockInfo.DoorInterlockEnabled = (DoorInterlockCheckBox->Checked)? 1 : 0;
    MachineSetupData.InterlockInfo.ACdomesticMode = (ACModeCheckBox->Checked)? 1 : 0;

    MachineSetupData.BuzzerInfo.BuzzerContinuousOn = BuzzerContinuousOnRadioButton->Checked;
    MachineSetupData.BuzzerInfo.BuzzerOnTime = StrToInt(BuzzerIntervalEdit->Text);

    MachineSetupData.LEDControlInfo.EyeProtectionModeEnabled = EyeProtectionModeCheckBox->Checked ? 1 : 0;
    MachineSetupData.LEDControlInfo.LEDOnTime = StrToInt(EyeProtectionModeLEDOnTimeEdit->Text);
    MachineSetupData.LEDControlInfo.LEDOffDelay = StrToInt(EyeProtectionModeLEDOffDelayEdit->Text);

    MachineSetupData.AlarmSetupInfo.PressureAlarmLevel = StrToInt(PressureAlarmLevelEdit->Text);
    MachineSetupData.AlarmSetupInfo.VacuumAlarmLevel1 = StrToFloat(VacuumAlarmLevelEdit1->Text) * 100;
    MachineSetupData.AlarmSetupInfo.VacuumAlarmLevel2 = StrToFloat(VacuumAlarmLevelEdit2->Text) * 100;
    MachineSetupData.AlarmSetupInfo.TemperatureAlarmLevel1 = StrToInt(TemperatureAlarmLevelEdit1->Text);
    MachineSetupData.AlarmSetupInfo.TemperatureAlarmLevel2 = StrToInt(TemperatureAlarmLevelEdit2->Text);
    MachineSetupData.AlarmSetupInfo.TemperatureAlarmLevel3 = StrToInt(TemperatureAlarmLevelEdit3->Text);

    MachineSetupData.HopperEmptyEnable = HopperEmptyCheckBox->Checked ? 1 : 0;
    MachineSetupData.Qualis_Machine1_CutomOption = TntCheckBox1->Checked? 1 : 0;
    // khd1994 HCB IPּ  Portó
    strcpy(MachineSetupData.szHCB_IpAddr, Edit_HCB_IpAddr->Text.c_str());
    MachineSetupData.nHCB_TcpPort = StrToIntDef(Edit_HCB_TcpPort->Text, 7000);

    // ձ  ߰
	MachineSetupData.LasercomplexerInfo.Machine_type = MachineTypeComboBox->ItemIndex;
    if(MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable != Laser_complexer_Enable->Checked)
    {
      LaserComplexValueChange = true;
    }
    
    MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable = Laser_complexer_Enable->Checked ? 1 : 0;
    MachineSetupData.LasercomplexerInfo.Laser_Trig_mode = LaserTrigMode->Checked ? 1 : 0;
    MachineSetupData.LasercomplexerInfo.Laser_deley_time = StrToInt(Laser_Deley_Time->Text);
    MachineSetupData.IPB_BoardCount = StrToInt(Ipb_board_count->Text);

    if(SucktionDiskGearRatioComboBox->ItemIndex == 0)
    {
      MachineSetupData.SuctionDiskGearRatio = 10;
    }
    else if(SucktionDiskGearRatioComboBox->ItemIndex == 1)
    {
      MachineSetupData.SuctionDiskGearRatio = 30;
    }

    if(BowlfeederSensorActiveCheckbox->Checked)
      MachineSetupData.BowlFeederSensorOption = 1;
    else
      MachineSetupData.BowlFeederSensorOption = 0;

    if(SafetyMaintenaceRadioBtn->Checked)
    {
      MachineSetupData.SafetyCircuitMode = 1;
      MainForm->SetLastSafetyMode(1);
    }
    else
    {
      MachineSetupData.SafetyCircuitMode = 0;
      MainForm->SetLastSafetyMode(0);
    }

    MachineSetupData.DiskStartDelay = StrToInt(DiskDelayTimeEdit->Text);

    if(SimpleSpeedControlCheckBox->Checked)
      MachineSetupData.SimpleSpeedControlOption = 1;
    else
      MachineSetupData.SimpleSpeedControlOption = 0;

    if(cbAutoDemper->Checked)     MachineSetupData.AutoDemper = 1;
    else                          MachineSetupData.AutoDemper = 0;

    MachineSetupData.DistributorCtrl.InSigOffTimeLength = StrToInt(eIn_Sig_SW_Time->Text);
    MachineSetupData.DistributorCtrl.OutSigOnTimeLength = StrToInt(eOut_Sig_SW_Time->Text);
    MachineSetupData.DistributorCtrl.OutSigDelayTime = StrToInt(DistributorOutSigStartDelayEdit->Text);
    MachineSetupData.DistributorCtrl.WaitChangeBarrelTime = StrToInt(WaitChangeBarrelTimeEdit->Text);

    MachineSetupData.InverterType = InverterTypeComboBox->ItemIndex;

    memcpy(&MachineParams, &TempMachineParams, sizeof(TMachineParams));
    WriteMachineParams(ProgramPath.Env + "\\MachineInfor.ini", MachineParams);

    if(LaserComplexValueChange)
    {
      WriteMachineSetupData(ProgramPath.Env + "\\SystemInfor.ini", MachineSetupData,LaserComplexValueChange);
      ReadMachineSetupData(ProgramPath.Env + "\\SystemInfor.ini", MachineSetupData);
    }
    else
    {
      WriteMachineSetupData(ProgramPath.Env + "\\SystemInfor.ini",MachineSetupData);
    }

    if (!ReadSPBSystemSetupData(ProgramPath.Env + "\\SystemInfor.ini", SPBSystemSetupData, CameraMapInfo))
	  {
		  ShowMessageW("Read Error [SPB Setup Data]");
	  }

		for (int spbIndex = 0; spbIndex < MachineSetupData.IPB_BoardCount; spbIndex++)
		{
			SPBSystemSetupData[spbIndex].Laser_complexer_Enable = MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable;

			if(CamBootingEnableCheckBox->Checked == true)
			{
				SPBSystemSetupData[spbIndex].CamBootEnabled = 1;
			}
			else
			{
				SPBSystemSetupData[spbIndex].CamBootEnabled = 0;			
			}
		}	
		
		WriteSPBSystemSetupData(ProgramPath.Env + "\\SystemInfor.ini", SPBSystemSetupData);
		SendSystemSetupData();

      if (!Comm_Request(COMM_HCB, CMD_MACHINE_PARAM_SETUP, &MachineSetupData, sizeof(TMachineSetupData)))
	    {
          //ShowMessageW(HCBConnection.GetLastErrorMessage());
      }
      else
      {
          ShowMessageFA(MACHINEPARAMSETTINGFORM_MSG_01);
      }
    }
    catch (...)
    {
	    ShowMessageFA(MACHINEPARAMSETTINGFORM_MSG_03);
    }
    ModalResult = mrOk;

}
//---------------------------------------------------------------------------
void __fastcall TMachineParamSettingForm::FormActivate(TObject *Sender)
{
//	DistributorHiddenPanel->Color = clBtnFace;
    
	// load param
    MachineModeComboBox->ItemIndex = MachineSetupData.MachineMode;
    MachineTypeComboBox->ItemIndex = MachineSetupData.MachineType;
    PCPowerModeComboBox->ItemIndex = MachineSetupData.PC_Power_Mode;

    DefectEjectorDelayEdit->Text = IntToStr(MachineSetupData.EjectorInfo.DefectEjectorDelay);
    UnInsEjectorDelayEdit->Text = IntToStr(MachineSetupData.EjectorInfo.UnInsEjectorDelay);
    GoodEjectorDelayEdit->Text = IntToStr(MachineSetupData.EjectorInfo.GoodEjectorDelay);
    DefectEjectorLengthEdit->Text = IntToStr(MachineSetupData.EjectorInfo.DefectEjectorLength);
    UnInsEjectorLengthEdit->Text = IntToStr(MachineSetupData.EjectorInfo.UnInsEjectorLength);
    GoodEjectorLengthEdit->Text = IntToStr(MachineSetupData.EjectorInfo.GoodEjectorLength);

    GoodCollect1TntEdit->Text = IntToStr(MachineSetupData.EjectorInfo.SpModeGoodTabletCollectCount1);// ߰
    GoodCollect2TntEdit->Text = IntToStr(MachineSetupData.EjectorInfo.SpModeGoodTabletCollectCount2);

    MisejectActiveCheckBox->Checked = (MachineSetupData.EjectorInfo.MisejectActive != 0);


    if(MachineSetupData.EjectorInfo.TPB_MisejectActive == 1)
      ckbTPB_Active->Checked = true;
    else
      ckbTPB_Active->Checked = false;

    eTPB_MisOpenDelayTime->Text = IntToStr(MachineSetupData.EjectorInfo.TPB_MisejectOpenDelay);
    eTPB_MisOpenRunTime->Text = IntToStr(MachineSetupData.EjectorInfo.TPB_MisejectOpenRunTime);
    eTPB_MisCmdValidCnt->Text = IntToStr(MachineSetupData.EjectorInfo.TPB_MisCmdValidCnt);

    if(MachineSetupData.EjectorInfo.IgnoreMultiMisejectAction == 1)
      ckbMultiMisejectAction->Checked = true;
    else
      ckbMultiMisejectAction->Checked = false;

    if(MachineSetupData.EjectorInfo.TPB_MisejectOperationMode == TPB_MISEJECT_NO_INSPECTION_MODE)
      ckbTPB_MisejectOperationMode->Checked = true;
    else
      ckbTPB_MisejectOperationMode->Checked = false;

    MisejectActiveDelayEdit->Text = FloatToStr(MachineSetupData.EjectorInfo.MisejectActiveDelay/ 20000.0f) ;
    //cik add
    EjectorWindStrengthEdit->Text = IntToStr(MachineSetupData.EjectorInfo.EjectorWindStrength);

    if(MachineSetupData.EjectorInfo.EjectorDefaultMode == 0)
      EjectorNormalModeButton->Checked = true;
    else
      EjectorSpecialModeRadioButton->Checked = true;

	
    ManualModeSensroIndexComboBox->ItemIndex = MachineSetupData.VFInfo.ManualModeSensorIndex;
    ManualModeSensorActiveRatioEdit->Text = IntToStr(MachineSetupData.VFInfo.ManualModeSensorActiveRatio);
    EmptySensorActiveEdit->Text = IntToStr(MachineSetupData.VFInfo.EmptySensorActiveRatio);
    FullSensorActiveEdit->Text = IntToStr(MachineSetupData.VFInfo.FullSensorActiveRatio);
    MechanicalMinSpeedEdit->Text = IntToStr(MachineSetupData.VFInfo.MechanicalMinSpeed);
    MechanicalMaxSpeedEdit->Text = IntToStr(MachineSetupData.VFInfo.MechanicalMaxSpeed);
    VBSensorWarningDelayAlarmEdit->Text = IntToStr(MachineSetupData.VFInfo.FeederEmptyAlarmDelayTime);

    DoorInterlockCheckBox->Checked = (MachineSetupData.InterlockInfo.DoorInterlockEnabled != 0)? true:false;
    ACModeCheckBox->Checked = (MachineSetupData.InterlockInfo.ACdomesticMode != 0)? true:false;


    if (MachineSetupData.BuzzerInfo.BuzzerContinuousOn)
    {
    	BuzzerContinuousOnRadioButton->Checked = true;
    }
    else
    {
    	BuzzerIntervalOnRadioButton->Checked = true;
    }

    if(MainForm->GetLastSafetyMode() == 0) //MachineSetupData.SafetyCircuitMode == 0)
    {
      SafetyRunRadioBtn->Checked = true;
    }
    else
    {
      SafetyMaintenaceRadioBtn->Checked = true;
    }
    
    BuzzerIntervalEdit->Text = IntToStr(MachineSetupData.BuzzerInfo.BuzzerOnTime);

    EyeProtectionModeCheckBox->Checked = (MachineSetupData.LEDControlInfo.EyeProtectionModeEnabled != 0);
    EyeProtectionModeLEDOnTimeEdit->Text = IntToStr(MachineSetupData.LEDControlInfo.LEDOnTime);
    EyeProtectionModeLEDOffDelayEdit->Text = IntToStr(MachineSetupData.LEDControlInfo.LEDOffDelay);

    PressureAlarmLevelEdit->Text = IntToStr(MachineSetupData.AlarmSetupInfo.PressureAlarmLevel);
    VacuumAlarmLevelEdit1->Text = FloatToStr(MachineSetupData.AlarmSetupInfo.VacuumAlarmLevel1 / 100.0);
    VacuumAlarmLevelEdit2->Text = FloatToStr(MachineSetupData.AlarmSetupInfo.VacuumAlarmLevel2 / 100.0);
    TemperatureAlarmLevelEdit1->Text = IntToStr(MachineSetupData.AlarmSetupInfo.TemperatureAlarmLevel1);
    TemperatureAlarmLevelEdit2->Text = IntToStr(MachineSetupData.AlarmSetupInfo.TemperatureAlarmLevel2);
    TemperatureAlarmLevelEdit3->Text = IntToStr(MachineSetupData.AlarmSetupInfo.TemperatureAlarmLevel3);

    HopperEmptyCheckBox->Checked = MachineSetupData.HopperEmptyEnable;
    TntCheckBox1->Checked = MachineSetupData.Qualis_Machine1_CutomOption;
    BowlfeederSensorActiveCheckbox->Checked = MachineSetupData.BowlFeederSensorOption;
    DiskDelayTimeEdit->Text = IntToStr(MachineSetupData.DiskStartDelay);
    memcpy(&TempMachineParams, &MachineParams, sizeof(TMachineParams));
    MSTabletKindChange();
    PageControl->ActivePageIndex = 0;
    // khd1994 HCB IPּ  Portó
    Edit_HCB_IpAddr->Text  = MachineSetupData.szHCB_IpAddr;
    Edit_HCB_TcpPort->Text = IntToStr(MachineSetupData.nHCB_TcpPort);

	MachineTypeComboBox->ItemIndex = MachineSetupData.LasercomplexerInfo.Machine_type;
	Laser_complexer_Enable->Checked = MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable;
	LaserTrigMode->Checked = MachineSetupData.LasercomplexerInfo.Laser_Trig_mode;
	Laser_Deley_Time->Text = IntToStr(MachineSetupData.LasercomplexerInfo.Laser_deley_time);
    
    if(SPBSystemSetupData[0].CamBootEnabled == 1)
    {
    	CamBootingEnableCheckBox->Checked = true;
    }
    else
    {
    	CamBootingEnableCheckBox->Checked = false;
    }
    
    
	Ipb_board_count->Text = IntToStr(MachineSetupData.IPB_BoardCount);
	HopperEmptyCheckBox->Visible = true;
	SensorGroupbox->Visible = true;
	MisejectActiveDelayEdit->Visible = true;
	Label49->Visible = true;
 

  SimpleSpeedControlCheckBox->Checked = MachineSetupData.SimpleSpeedControlOption;

  if(MachineSetupData.SuctionDiskGearRatio == 30)
  {
    SucktionDiskGearRatioComboBox->ItemIndex = 1;
  }
  else
  {
    SucktionDiskGearRatioComboBox->ItemIndex = 0;
  }

	cbAutoDemper->Checked = MachineSetupData.AutoDemper;

	InverterTypeComboBox->ItemIndex = MachineSetupData.InverterType;	

	eIn_Sig_SW_Time->Text		= IntToStr(MachineSetupData.DistributorCtrl.InSigOffTimeLength);
	eOut_Sig_SW_Time->Text 	= IntToStr(MachineSetupData.DistributorCtrl.OutSigOnTimeLength);
    DistributorOutSigStartDelayEdit->Text 	= IntToStr(MachineSetupData.DistributorCtrl.OutSigDelayTime);
    WaitChangeBarrelTimeEdit->Text = IntToStr(MachineSetupData.DistributorCtrl.WaitChangeBarrelTime);

  CheckTPB_BoardExist();     
}
//---------------------------------------------------------------------------
void __fastcall TMachineParamSettingForm::MSTabletKindSpeedButtonClick(
	  TObject *Sender)
{
	MSTabletKindChange();
}
//---------------------------------------------------------------------------
void __fastcall TMachineParamSettingForm::MSTabletKindChange(void)
{
	int tabletType = 0, tabletShape = 0;
  int STUDY_SPEED_INDEX = 0;
  int speedIndex = 0;

	if (MSTabletTypeSpeedButton1->Down)
	{
		tabletType = TABLET_TYPE_FILM_COATED;
	}
	else if (MSTabletTypeSpeedButton2->Down)
	{
		tabletType = TABLET_TYPE_SUGAR_COATED;
	}
	else if (MSTabletTypeSpeedButton3->Down)
	{
		tabletType = TABLET_TYPE_UNCOATED;
	}
	else
	{
		tabletType = TABLET_TYPE_UNCOATED;
	}

	if (MSTabletShapeSpeedButton1->Down)
	{
		tabletShape = TABLET_SHAPE_CIRCLE;
	}
	else if (MSTabletShapeSpeedButton2->Down)
	{
		tabletShape = TABLET_SHAPE_OBLONG;
	}
	else if (MSTabletShapeSpeedButton3->Down)
	{
		tabletShape = TABLET_SHAPE_OVAL;
	}
	else
	{
		tabletShape = TABLET_SHAPE_ETC;
	}

	//MSTabletTypeIndex = GetMSTabletTypeIndex(tabletType);
	MSTabletShapeIndex = GetMSTabletShapeIndex(tabletShape);

  for (int motorIndex = 0; motorIndex < (SpeedSettingStringGrid->ColCount-1); motorIndex++)
  {
      if(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / TempMachineParams.MotorSpeedList[_STUDY_MS_SPEED_INDEX][_STUDY_MS_SHAPE_INDEX][motorIndex][STUDY_SPEED_INDEX] < 10)
      {
        if(motorIndex == 0 || motorIndex == 1)
        {
          TempMachineParams.MotorSpeedList[_STUDY_MS_SPEED_INDEX][_STUDY_MS_SHAPE_INDEX][motorIndex][STUDY_SPEED_INDEX] = MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / 100;
        }
        else
        {
          TempMachineParams.MotorSpeedList[_STUDY_MS_SPEED_INDEX][_STUDY_MS_SHAPE_INDEX][motorIndex][STUDY_SPEED_INDEX] = MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / 70;
        }
        StudySpeedSettingStringGrid->Cells[motorIndex + 1][STUDY_SPEED_INDEX + 1] =
        IntToStr(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / TempMachineParams.MotorSpeedList[_STUDY_MS_SPEED_INDEX][_STUDY_MS_SHAPE_INDEX][motorIndex][STUDY_SPEED_INDEX])+ "%";
      }
      else
      {
        StudySpeedSettingStringGrid->Cells[motorIndex + 1][STUDY_SPEED_INDEX + 1] =
        IntToStr(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / TempMachineParams.MotorSpeedList[_STUDY_MS_SPEED_INDEX][_STUDY_MS_SHAPE_INDEX][motorIndex][STUDY_SPEED_INDEX])+ "%";
      }
  }


	for (int motorIndex = 0; motorIndex < (SpeedSettingStringGrid->ColCount-1); motorIndex++)
	{
		for (int speedIndex = 0; speedIndex < MS_MOTOR_SPEED_STEP_COUNT; speedIndex++)
		{
			SpeedSettingStringGrid->Cells[motorIndex + 1][speedIndex + 1] =
				IntToStr(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / TempMachineParams.MotorSpeedList[MSTabletTypeIndex][MSTabletShapeIndex][motorIndex][speedIndex]) + "%";
		}
	}

  for (int SimplemotorSpeedIndex = 0; SimplemotorSpeedIndex < 9; SimplemotorSpeedIndex++)
  {
    SimpleSpeedControlStringGrid->Cells[SimplemotorSpeedIndex + 1][1] =
				IntToStr(MachineSetupData.ServoMotorData[0].BaseSpeed * 100 / TempMachineParams.MotorSimpleSpeedList[SimplemotorSpeedIndex]) + "%";
  }
  for (int SimplemotorSpeedIndex = 9; SimplemotorSpeedIndex < 18; SimplemotorSpeedIndex++)
  {
    int CellIndex = SimplemotorSpeedIndex-9;
    SimpleSpeedControlStringGrid2->Cells[CellIndex + 1][1] =
				IntToStr(MachineSetupData.ServoMotorData[0].BaseSpeed * 100 / TempMachineParams.MotorSimpleSpeedList[SimplemotorSpeedIndex]) + "%";
  }

}
//---------------------------------------------------------------------------



//---------------------------------------------------------------------------

void __fastcall TMachineParamSettingForm::SpeedSettingStringGridSelectCell(
      TObject *Sender, int ACol, int ARow, bool &CanSelect)
{
	int motorIndex = ACol - 1;
    int speedIndex = ARow - 1;


	TMotorSpeedSelectionForm *motorSpeedSelectionForm = new TMotorSpeedSelectionForm(this);
//    motorSpeedSelectionForm->SetSpeed(StepMotorInfo[motorIndex].BaseSpeed, StrToInt(SpeedSettingStringGrid->Cells[ACol][ARow]));
	motorSpeedSelectionForm->SetSpeed(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed, TempMachineParams.MotorSpeedList[MSTabletTypeIndex][MSTabletShapeIndex][motorIndex][speedIndex]);
	if (motorSpeedSelectionForm->ShowModal() == mrOk)
	{
		try
		{
			TempMachineParams.MotorSpeedList[MSTabletTypeIndex][MSTabletShapeIndex][motorIndex][speedIndex] = motorSpeedSelectionForm->GetSelectedSpeed();
			SpeedSettingStringGrid->Cells[motorIndex + 1][speedIndex + 1] =
				IntToStr(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / TempMachineParams.MotorSpeedList[MSTabletTypeIndex][MSTabletShapeIndex][motorIndex][speedIndex]) + "%";
		}
		catch (...)
		{

		}
	}
	delete motorSpeedSelectionForm;
}
//---------------------------------------------------------------------------

void __fastcall TMachineParamSettingForm::SetDefaultSpeedButtonClick(
      TObject *Sender)
{
 // MSTabletShapeIndex = GetMSTabletShapeIndex(tabletShape);
	if (MessageDlgFA(MACHINEPARAMSETTINGFORM_MSG_02, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
	{
   // н
    int studySpeedIndex = 0;


		for (int tabletTypeIndex = 0; tabletTypeIndex < MS_TABLET_TYPE_COUNT; tabletTypeIndex++)
		{
			for (int tabletShapeIndex = 0; tabletShapeIndex < MS_TABLET_SHAPE_COUNT; tabletShapeIndex++)
			{
				for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
				{
					for (int speedIndex = 0; speedIndex < MS_MOTOR_SPEED_STEP_COUNT; speedIndex++)
					{
						if (motorIndex == 0 || motorIndex == 1 || motorIndex == 2)
						{
							if (speedIndex == 0)
							{
								TempMachineParams.MotorSpeedList[tabletTypeIndex][tabletShapeIndex][motorIndex][speedIndex] =
									MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / 110;
							}
							else if (speedIndex == 1)
							{
								TempMachineParams.MotorSpeedList[tabletTypeIndex][tabletShapeIndex][motorIndex][speedIndex] =
									MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / 120;
							}
							else
							{
								TempMachineParams.MotorSpeedList[tabletTypeIndex][tabletShapeIndex][motorIndex][speedIndex] =
									MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / 130;
							}
						}
						else if (motorIndex == 3 ||motorIndex == 4)
						{
							if (speedIndex == 0)
							{
								TempMachineParams.MotorSpeedList[tabletTypeIndex][tabletShapeIndex][motorIndex][speedIndex] =
									MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / 90;
							}
							else if (speedIndex == 1)
							{
								TempMachineParams.MotorSpeedList[tabletTypeIndex][tabletShapeIndex][motorIndex][speedIndex] =
									MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / 110;
							}
							else
							{
								TempMachineParams.MotorSpeedList[tabletTypeIndex][tabletShapeIndex][motorIndex][speedIndex] =
									MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / 120;
							}
						}
						else
						{
              // ȵ
							if (speedIndex == 0)
							{
								TempMachineParams.MotorSpeedList[tabletTypeIndex][tabletShapeIndex][motorIndex][speedIndex] =
									MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / 50;
							}
							else if (speedIndex == 1)
							{
								TempMachineParams.MotorSpeedList[tabletTypeIndex][tabletShapeIndex][motorIndex][speedIndex] =
									MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / 90;
							}
							else
							{
								TempMachineParams.MotorSpeedList[tabletTypeIndex][tabletShapeIndex][motorIndex][speedIndex] =
									MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / 100;
							}
						}
					}
				}
			}
		}

    for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
    {
      if (motorIndex == 0 || motorIndex == 1 )
      {
        TempMachineParams.MotorSpeedList[_STUDY_MS_SPEED_INDEX][_STUDY_MS_SHAPE_INDEX][motorIndex][studySpeedIndex] =
          MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / 100;
      }
      else
      {
        TempMachineParams.MotorSpeedList[_STUDY_MS_SPEED_INDEX][_STUDY_MS_SHAPE_INDEX][motorIndex][studySpeedIndex] =
          MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / 70;
      }
    }

		MSTabletKindChange();
	}
}
//---------------------------------------------------------------------------

void __fastcall TMachineParamSettingForm::NumEditClick(
      TObject *Sender)
{
		TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
  if (KeyboardForm->ShowKeypad() == mrOk)
  {

    if(theEdit->Tag == 999)
    {
      double TempText = StrToFloat(KeyboardForm->Text);
      TempText = floor(TempText*10)/10;
      if(TempText > 60)
        TempText = 60;
      theEdit->Text = FloatToStr(TempText);
    }
    else if(theEdit->Tag == 2) // only int
    {
      theEdit->Text = IntToStr(StrToInt(KeyboardForm->Text));
    }
    else
  		theEdit->Text = KeyboardForm->Text;

  }
}
//---------------------------------------------------------------------------

void __fastcall TMachineParamSettingForm::VacuumAlarmLevelEditClick(
      TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
	if (KeyboardForm->ShowKeyboard() == mrOk)
	{
		theEdit->Text = KeyboardForm->Text;
	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineParamSettingForm::SpeedSettingStringGridSetEditText(
      TObject *Sender, int ACol, int ARow, const WideString Value)
{
	int motorIndex = ACol - 1;
    int speedIndex = ARow - 1;
    try
    {
		TempMachineParams.MotorSpeedList[MSTabletTypeIndex][MSTabletShapeIndex][motorIndex][speedIndex] = StrToInt(Value);
    }
    catch (...)
    {

    }  
}
//---------------------------------------------------------------------------


void __fastcall TMachineParamSettingForm::StudySpeedSettingStringGridSelectCell(
      TObject *Sender, int ACol, int ARow, bool &CanSelect)
{
  int motorIndex = ACol - 1;
  int speedIndex = ARow - 1;

  TMotorSpeedSelectionForm *motorSpeedSelectionForm = new TMotorSpeedSelectionForm(this);
  motorSpeedSelectionForm->SetSpeed(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed, TempMachineParams.MotorSpeedList[_STUDY_MS_SPEED_INDEX][_STUDY_MS_SHAPE_INDEX][motorIndex][speedIndex]);
  if (motorSpeedSelectionForm->ShowModal() == mrOk)
  {
    try
    {
      TempMachineParams.MotorSpeedList[_STUDY_MS_SPEED_INDEX][_STUDY_MS_SHAPE_INDEX][motorIndex][speedIndex] = motorSpeedSelectionForm->GetSelectedSpeed();
      StudySpeedSettingStringGrid->Cells[motorIndex + 1][speedIndex + 1] =
        IntToStr(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / TempMachineParams.MotorSpeedList[_STUDY_MS_SPEED_INDEX][_STUDY_MS_SHAPE_INDEX][motorIndex][speedIndex]) + "%";
    }
    catch (...)
    {

    }
  }
  delete motorSpeedSelectionForm;
}
//---------------------------------------------------------------------------
/*
* SELMA 200 SPECIAL_MODE ý ǰ   ۼ  Էâ ´. 
*/
void __fastcall TMachineParamSettingForm::EjectorNormalModeButtonClick(
      TObject *Sender)
{
  GoodCollect1TntLabel->Visible = false;
  GoodCollect2TntLabel->Visible = false;
  GoodCollect1TntEdit->Visible = false;
  GoodCollect2TntEdit->Visible = false;
}
//---------------------------------------------------------------------------

void __fastcall TMachineParamSettingForm::EjectorSpecialModeRadioButtonClick(
      TObject *Sender)
{
  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
  {
    GoodCollect1TntLabel->Visible = true;
    GoodCollect2TntLabel->Visible = true;
    GoodCollect1TntEdit->Visible = true;
    GoodCollect2TntEdit->Visible = true;
  }
}
//---------------------------------------------------------------------------

void __fastcall TMachineParamSettingForm::Panel2DblClick(TObject *Sender)
{
  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
  {
    if(TntCheckBox1->Visible == true)
    {
      TntCheckBox1->Visible = false;
    }
    else
    {
      TntCheckBox1->Visible = true;
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TMachineParamSettingForm::TntCheckBox1Click(
      TObject *Sender)
{
  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
  {
    if(TntCheckBox1->Checked == false)
    {
      TabSheet6->Caption = MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_10;
      SafetyModePanel->Visible = true;
    }
    else
    {
      TabSheet6->Caption = MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_11;
      SafetyModePanel->Visible = false;
    }
  }
  else
  {
    TabSheet6->Caption = MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_11;
    SafetyModePanel->Visible = false;
  }
}
//---------------------------------------------------------------------------

void __fastcall TMachineParamSettingForm::TntFormShow(TObject *Sender)
{
  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
  {
    TntGroupBox4->Visible = false;
    if(TntCheckBox1->Checked == false)
    {
      TabSheet6->Caption = MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_10;
      SafetyModePanel->Visible = true;
    }
    else
    {
      TabSheet6->Caption = MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_11;
      SafetyModePanel->Visible = false;
    }
    TntImage1->Enabled = true;
  }
  else
  {
    TabSheet6->Caption = MACHINEPARAMSETTINGFORM_GROUPBOX_CAPTION_11;
    SafetyModePanel->Visible = false;
    TntImage1->Enabled = false;

  }
}
//---------------------------------------------------------------------------

void __fastcall TMachineParamSettingForm::SimpleSpeedControlStringGridSelectCell(
      TObject *Sender, int ACol, int ARow, bool &CanSelect)
{
  int motorIndex = ACol - 1;
  int speedIndex = motorIndex;//ARow - 1;

  TMotorSpeedSelectionForm *motorSpeedSelectionForm = new TMotorSpeedSelectionForm(this);

  TTntStringGrid* TempGrid = (TTntStringGrid*)Sender;
  if(TempGrid->Name == "SimpleSpeedControlStringGrid")
  {
    motorIndex = 0;
    motorSpeedSelectionForm->SetSpeed(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed, TempMachineParams.MotorSimpleSpeedList[speedIndex]);
    if (motorSpeedSelectionForm->ShowModal() == mrOk)
    {
      try
      {
        TempMachineParams.MotorSimpleSpeedList[speedIndex] = motorSpeedSelectionForm->GetSelectedSpeed();
        SimpleSpeedControlStringGrid->Cells[speedIndex+1][1] =
        IntToStr(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / TempMachineParams.MotorSimpleSpeedList[speedIndex]) + "%";
      }
      catch (...)
      {

      }
    }
  }
  else if(TempGrid->Name == "SimpleSpeedControlStringGrid2")
  {
    int CellSeconSpeedIndex = speedIndex;
    speedIndex+= 9;
    motorIndex = 0;
    motorSpeedSelectionForm->SetSpeed(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed, TempMachineParams.MotorSimpleSpeedList[speedIndex]);
    if (motorSpeedSelectionForm->ShowModal() == mrOk)
    {
      try
      {
        TempMachineParams.MotorSimpleSpeedList[speedIndex] = motorSpeedSelectionForm->GetSelectedSpeed();
        SimpleSpeedControlStringGrid2->Cells[CellSeconSpeedIndex+1][1] =
        IntToStr(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / TempMachineParams.MotorSimpleSpeedList[speedIndex]) + "%";
      }
      catch (...)
      {

      }
    }
  }
  else
  {
    motorSpeedSelectionForm->SetSpeed(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed, TempMachineParams.MotorSimpleSpeedList[speedIndex]);
    if (motorSpeedSelectionForm->ShowModal() == mrOk)
    {
      try
      {
        TempMachineParams.MotorSimpleSpeedList[speedIndex] = motorSpeedSelectionForm->GetSelectedSpeed();
        SimpleSpeedControlStringGrid->Cells[motorIndex + 1][speedIndex + 1] =
        IntToStr(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / TempMachineParams.MotorSimpleSpeedList[speedIndex]) + "%";
      }
      catch (...)
      {

      }
    }
  }

  delete motorSpeedSelectionForm;
}
//---------------------------------------------------------------------------



void __fastcall TMachineParamSettingForm::Laser_Deley_TimeChange(
	TObject *Sender)
{
	try
	{
		int Value = StrToInt(Laser_Deley_Time->Text) * 50;

		TntLabel19->Caption = "x 50us = " + IntToStr(Value) + "us";
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------


void __fastcall TMachineParamSettingForm::ACModeCheckBoxClick(
      TObject *Sender)
{
  if(ACModeCheckBox->Checked)
  {
    MachineSetupData.InterlockInfo.ACdomesticMode = 1;     // ũνþ  
  }
  else
  {
    MachineSetupData.InterlockInfo.ACdomesticMode = 0;   // ũνþ 
  }
}
//---------------------------------------------------------------------------



void __fastcall TMachineParamSettingForm::TntImage1DblClick(
      TObject *Sender)
{

  if(TntLabel23->Visible)
  {
    ACModeCheckBox->Visible = false;
  }
  else
  {
    ACModeCheckBox->Visible = true;
  }
}
//---------------------------------------------------------------------------
void __fastcall TMachineParamSettingForm::HiddenPanelDblClick(
      TObject *Sender)
{
    if (ckbTPB_MisejectOperationMode->Visible)
    {
      ckbTPB_MisejectOperationMode->Visible = false;
    }
    else
    {
      ckbTPB_MisejectOperationMode->Visible = true;
    }  
}
//---------------------------------------------------------------------------
void __fastcall TMachineParamSettingForm::CheckTPB_BoardExist(void)
{
/*
	ReadTPB_BoardExistInfo();

  if(TPBSystemInfo.boardExist == TPB_BOARD_EXSIT)
  {
    TPB_Miseject_Setting_GroupBox->Visible = true;
  }
  else
  {
    TPB_Miseject_Setting_GroupBox->Visible = false;
  }
*/
  TPB_Miseject_Setting_GroupBox->Visible = false;
}

//---------------------------------------------------------------------------

void __fastcall TMachineParamSettingForm::TempOffsetEditClick(
      TObject *Sender)
{
  TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
  if (KeyboardForm->ShowKeypad() == mrOk)
  {
    theEdit->Text = KeyboardForm->Text;
  }
}
//---------------------------------------------------------------------------



