//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "MachineSetting_Form.h"
#include "command.h"
#include "Environment.h"
#include "MotorSetting_Form.h"
#include "IOSetting_Form.h"
#include "MotorSpeedSelection_Form.h"
#include "Keyboard_Form.h"
#include "Message_Form.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"

#define PORT_IN_COUNT	3
#define PORT_OUT_COUNT	3

#define PORT_CONTROL_MODE_NORMAL			0
#define PORT_CONTROL_MODE_BLINK				1

TMachineSettingForm *MachineSettingForm;
//---------------------------------------------------------------------------
__fastcall TMachineSettingForm::TMachineSettingForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  GetDefaultString();
	CurrentStepMotorIndex = -1;

  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
    Machine.MisejectClose();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::GetDefaultString()
{
  IOSettingButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_01;
  StepMotorSpeedButton3->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_02;
  Label50->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_02;
  StepMotorSpeedButton4->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_05;
  Label51->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_05;
  MotorSettingButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_06;
  StepMotorSpeedButton1->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_07;
  Label48->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_07;
  StepMotorSpeedButton2->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_10;
  Label49->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_10;
  StepMotorSpeedButton5->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_11;
  Label52->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_11;
  HomeSearchButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_13;
  GroupBox12->Caption = MACHINESETTINGFORM_GROUPBOX_CAPTION_01;
  GroupBox9->Caption = MACHINESETTINGFORM_GROUPBOX_CAPTION_02;
  GroupBox16->Caption = MACHINESETTINGFORM_GROUPBOX_CAPTION_03;
  Label24->Caption = MACHINESETTINGFORM_LABEL_CAPTION_01;
  Label20->Caption = MACHINESETTINGFORM_LABEL_CAPTION_02;
  Label12->Caption = MACHINESETTINGFORM_LABEL_CAPTION_03;
  Label17->Caption = MACHINESETTINGFORM_LABEL_CAPTION_04;
  Label21->Caption = MACHINESETTINGFORM_LABEL_CAPTION_05;
  Label35->Caption = MACHINESETTINGFORM_LABEL_CAPTION_06;
  Label18->Caption = MACHINESETTINGFORM_LABEL_CAPTION_07;
  Label38->Caption = MACHINESETTINGFORM_LABEL_CAPTION_08;
  Label40->Caption = MACHINESETTINGFORM_LABEL_CAPTION_09;
  Label6->Caption = MACHINESETTINGFORM_LABEL_CAPTION_10;
  Label1->Caption = MACHINESETTINGFORM_LABEL_CAPTION_11;

  ServoMotorStartButton1->Caption 	= MACHINESETTINGFORM_BUTTON_CAPTION_22;
  ServoMotorStartButton2->Caption 	= MACHINESETTINGFORM_BUTTON_CAPTION_23;
  ServoMotorStartButton3->Caption 	= MACHINESETTINGFORM_BUTTON_CAPTION_24;
  ServoMotorStartButton4->Caption 	= MACHINESETTINGFORM_BUTTON_CAPTION_25;
  ServoMotorStartButton5->Caption   = MACHINESETTINGFORM_BUTTON_CAPTION_37;
  StepMotorAllStartButton->Caption 	= MACHINESETTINGFORM_BUTTON_CAPTION_20;

  ServoMotorStopButton1->Caption 	= MACHINESETTINGFORM_BUTTON_CAPTION_26;
  ServoMotorStopButton2->Caption 	= MACHINESETTINGFORM_BUTTON_CAPTION_27;
  ServoMotorStopButton3->Caption 	= MACHINESETTINGFORM_BUTTON_CAPTION_28;
  ServoMotorStopButton4->Caption 	= MACHINESETTINGFORM_BUTTON_CAPTION_29;
  ServoMotorStopButton5->Caption 	= MACHINESETTINGFORM_BUTTON_CAPTION_38;
  StepMotorAllStopButton->Caption 	= MACHINESETTINGFORM_BUTTON_CAPTION_21;

//ON-OFF
  VFOnSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  RBOnSpeedButton1->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  RBOnSpeedButton3->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  RBOnSpeedButton4->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  BlowerAllOnButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  RoomLampOnSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  MELampOnSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  LampOnSpeedButton1->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  LampOnSpeedButton2->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  LampOnSpeedButton3->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  BuzzerOnSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  AirKnifeOnSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  AirKnifeOnSpeedButton2->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  SDBlowerOnSpeedButton1->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  SDBlowerOnSpeedButton2->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  DustBlowerOnSpeedButton1->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  DustBlowerOnSpeedButton2->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  DustBlowerOnSpeedButton3->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  DustBlowerOnSpeedButton4->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  DustBlowerOnSpeedButton5->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  AirBrushOnSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  DefectEjectorOnSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  UnInsEjectorOnSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  TntSpeedButton1->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  DefectSolOnSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  UnInsSolOnSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;
  TntSpeedButton3->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_14;

  VFOffSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  RBOffSpeedButton1->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  RBOffSpeedButton3->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  RBOffSpeedButton4->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  BlowerAllOffButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  RoomLampOffSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  MELampOffSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  LampOffSpeedButton1->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  LampOffSpeedButton2->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  LampOffSpeedButton3->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  BuzzerOffSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  AirKnifeOffSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  AirKnifeOffSpeedButton2->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  SDBlowerOffSpeedButton1->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  SDBlowerOffSpeedButton2->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  DustBlowerOffSpeedButton1->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  DustBlowerOffSpeedButton2->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  DustBlowerOffSpeedButton3->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  DustBlowerOffSpeedButton4->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  DustBlowerOffSpeedButton5->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  AirBrushOffSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  DefectEjectorOffSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  UnInsEjectorOffSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  TntSpeedButton2->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  DefectSolOffSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  UnInsSolOffSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;
  TntSpeedButton4->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_15;

//IN-OUT
	ABRInSpeedButton1->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_16;
    ABRInSpeedButton2->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_16;

    ABROutSpeedButton1->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_17;
    ABROutSpeedButton2->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_17;

//OPEN-CLOSE-STOP
	MEOpenSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_18;
    MECloseSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_19;
    MEStopSpeedButton->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_32;

    CloseBitBtn->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_19;
    RBSpeedSpeedButton1->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_33 + " 1";
    RBSpeedSpeedButton2->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_33 + " 2";
    RBSpeedSpeedButton3->Caption = MACHINESETTINGFORM_BUTTON_CAPTION_33 + " 3";

    Label44->Caption = MACHINESETTINGFORM_LABEL_CAPTION_12; 

    Label26->Caption = MACHINESETTINGFORM_LABEL_CAPTION_13;
    Label27->Caption = MACHINESETTINGFORM_LABEL_CAPTION_14;
    Label33->Caption = MACHINESETTINGFORM_LABEL_CAPTION_15;
    Label31->Caption = MACHINESETTINGFORM_LABEL_CAPTION_16;

    GroupBox11->Caption 					= MACHINESETTINGFORM_GROUPBOX_CAPTION_04;
    SetTestModeSpeedButton->Caption			= MACHINESETTINGFORM_BUTTON_CAPTION_34;
    SetFreeModeSpeedButton->Caption			= MACHINESETTINGFORM_BUTTON_CAPTION_35;
    SetInterlockModeSpeedButton->Caption	= MACHINESETTINGFORM_BUTTON_CAPTION_36;

    GroupBox13->Caption	= MACHINESETTINGFORM_GROUPBOX_CAPTION_05;
    GroupBox2->Caption	= MACHINESETTINGFORM_GROUPBOX_CAPTION_06;
    GroupBox7->Caption	= MACHINESETTINGFORM_GROUPBOX_CAPTION_07;
    GroupBox3->Caption	= MACHINESETTINGFORM_GROUPBOX_CAPTION_08;
    Label2->Caption 	= MACHINESETTINGFORM_LABEL_CAPTION_26 + 1;
    Label4->Caption 	= MACHINESETTINGFORM_LABEL_CAPTION_26 + 2;
    Label30->Caption 	= MACHINESETTINGFORM_LABEL_CAPTION_18;

    GroupBox5->Caption	= MACHINESETTINGFORM_GROUPBOX_CAPTION_09;
    GroupBox8->Caption	= MACHINESETTINGFORM_GROUPBOX_CAPTION_10;
    Label28->Caption 	= MACHINESETTINGFORM_LABEL_CAPTION_26;

    GroupBox10->Caption	= MACHINESETTINGFORM_GROUPBOX_CAPTION_11;
    Label19->Caption	= MACHINESETTINGFORM_LABEL_CAPTION_19;
    Label23->Caption	= MACHINESETTINGFORM_LABEL_CAPTION_20;
    TntLabel3->Caption	= MACHINESETTINGFORM_LABEL_CAPTION_21;
    Label29->Caption	= MACHINESETTINGFORM_LABEL_CAPTION_22;

    GroupBox6->Caption	= MACHINESETTINGFORM_GROUPBOX_CAPTION_12;
    Label10->Caption	= MACHINESETTINGFORM_LABEL_CAPTION_23;
    Label8->Caption		= MACHINESETTINGFORM_LABEL_CAPTION_24;

    GroupBox1->Caption	= MACHINESETTINGFORM_GROUPBOX_CAPTION_13;

    GroupBox14->Caption = MACHINESETTINGFORM_GROUPBOX_CAPTION_14;
    Label46->Caption	= MACHINESETTINGFORM_LABEL_CAPTION_25;

    Label37->Caption	= MACHINESETTINGFORM_LABEL_CAPTION_27;

   if(MachineSetupData.MachineType < 2)
   {
   	ServoMotorStartButton5->Visible = false;
	ServoMotorStopButton5->Visible = false;
	MotorSpeedModEdit5->Visible = false;
	MotorSpeedLabel5->Visible = false;
	Motor5MidTermRPMLabel->Visible = false;
   }
   else
   {
   	ServoMotorStartButton5->Visible = true;
	ServoMotorStopButton5->Visible = true;
	MotorSpeedModEdit5->Visible = true;
	MotorSpeedLabel5->Visible = true;
	Motor5MidTermRPMLabel->Visible = true;   
   }

}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::BlowerOffButtonClick(TObject *Sender)
{
	TTntSpeedButton *theButton = (TTntSpeedButton *)Sender;
	int blowerIndex = 0;
	if (theButton->Tag < 4)
	{
		blowerIndex = theButton->Tag;
	}
	else
	{
		blowerIndex = 0xFF;
	}
	Machine.RingBlowerOff(blowerIndex);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::ServoMotorStartButtonClick(
	  TObject *Sender)
{
	TTntButton *theButton = (TTntButton *)Sender;
	if (theButton->Tag < MAX_SERVO_MOTOR_COUNT)
	{
		int motorIndex = theButton->Tag;
		int baseSpeed = MachineSetupData.ServoMotorData[motorIndex].BaseSpeed;
		int targetSpeed = MachineOperationInfo.ServoMotorSpeed[motorIndex];
		int accTime = MachineSetupData.ServoMotorData[motorIndex].AccTime;
		int dir = 0;
		if (MachineSetupData.ServoMotorData[motorIndex].Dir)
		{
			dir = 1;
		}
		else
		{
			dir = 0;
		}
		Machine.ServoMotorRun(motorIndex, baseSpeed, targetSpeed, accTime, dir);
	}
	else
	{
		for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
		{
			int baseSpeed = MachineSetupData.ServoMotorData[motorIndex].BaseSpeed;
			int targetSpeed = MachineOperationInfo.ServoMotorSpeed[motorIndex];
			int accTime = MachineSetupData.ServoMotorData[motorIndex].AccTime;
			int dir = 0;
			if (MachineSetupData.ServoMotorData[motorIndex].Dir)
			{
				dir = 1;
			}
			else
			{
				dir = 0;
			}
			Machine.ServoMotorRun(motorIndex, baseSpeed, targetSpeed, accTime, dir);
		}
    }
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::ServoMotorStopButtonClick(
      TObject *Sender)
{
	TTntButton *theButton = (TTntButton *)Sender;

    if (theButton->Tag < MAX_SERVO_MOTOR_COUNT)
    {
		int motorIndex = theButton->Tag;
		int decTime = MachineSetupData.ServoMotorData[motorIndex].DecTime;
		Machine.ServoMotorStop(motorIndex, decTime);
	}
	else
	{
		for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
		{
			int decTime = MachineSetupData.ServoMotorData[motorIndex].DecTime;
			Machine.ServoMotorStop(motorIndex, decTime);
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::ServoMotorServoOnButtonClick(
	  TObject *Sender)
{
	TTntButton *theButton = (TTntButton *)Sender;
	int motorIndex = theButton->Tag;
	Machine.ServoMotorHoldOn(motorIndex);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::ServoMotorServoOffButtonClick(
      TObject *Sender)
{
	TTntButton *theButton = (TTntButton *)Sender;
	int motorIndex = theButton->Tag;
	Machine.ServoMotorHoldOff(motorIndex);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::MotorSettingButtonClick(TObject *Sender)
{
	TMotorSettingForm *motorSettingForm = new TMotorSettingForm(this);
	motorSettingForm->ShowModal();
	delete motorSettingForm;
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingForm::MotorSpeedModEditChange(
      TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	int motorIndex = theEdit->Tag;
	try
    {
		//StepMotorInfo[motorIndex].Modifier = StrToInt(theEdit->Text);
        MachineOperationInfo.ServoMotorSpeed[motorIndex] = StrToInt(theEdit->Text);
        TTntLabel *motorSpeedLabel = (TTntLabel *) FindComponent("MotorSpeedLabel" + IntToStr(motorIndex + 1));
        motorSpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / MachineOperationInfo.ServoMotorSpeed[motorIndex]) + "%";
    }
    catch(...)
    {

    }
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::FormActivate(TObject *Sender)
{

	if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
    {
    	MotorSpeedLabel3->Visible = false;
        Motor3MidTermRPMLabel->Visible = false;

    }

	for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
    {
	    	if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_BASIC || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_BASIC)
	    	{
	    		if(motorIndex==4) break;	
	    	}
    		TTntEdit *speedModEdit = (TTntEdit *) FindComponent("MotorSpeedModEdit" + IntToStr(motorIndex + 1));
		speedModEdit->Text = IntToStr(MachineOperationInfo.ServoMotorSpeed[motorIndex]);
		TTntLabel *motorSpeedLabel = (TTntLabel *) FindComponent("MotorSpeedLabel" + IntToStr(motorIndex + 1));
        	motorSpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / MachineOperationInfo.ServoMotorSpeed[motorIndex]) + "%";        
    }
    CheckMachineStatus();
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingForm::IOSettingButtonClick(TObject *Sender)
{
	TIOSettingForm *ioSettingForm = new TIOSettingForm(this);
    ioSettingForm->ShowModal();
    delete ioSettingForm;
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::CheckMachineStatus(void)
{
	WCHAR TempString[100];
	Machine.ReadPortStatus();
	wsprintfW(TempString, L"%S", FloatToStrF( Machine.GetServoMotorRPM(0), ffFixed, 10, 3));
	Motor1MidTermRPMLabel->Caption = TempString;
	wsprintfW(TempString, L"%S", FloatToStrF( Machine.GetServoMotorRPM(1), ffFixed, 10, 3));
	Motor2MidTermRPMLabel->Caption = TempString;
	wsprintfW(TempString, L"%S", FloatToStrF( Machine.GetServoMotorRPM(2), ffFixed, 10, 3));
	Motor3MidTermRPMLabel->Caption = TempString;
	wsprintfW(TempString, L"%S", FloatToStrF( Machine.GetServoMotorRPM(3), ffFixed, 10, 3));
	Motor4MidTermRPMLabel->Caption = TempString;

    if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
	{
		wsprintfW(TempString, L"%S", FloatToStrF( Machine.GetServoMotorRPM(4), ffFixed, 10, 3));
		Motor5MidTermRPMLabel->Caption = TempString;
    }

	if (Machine.PortStatus.IPStatus[IP_NC_1_LIMIT_H])
	{
		StepMotorMinusLimitPanel1->Color = clRed;
	}
	else
	{
		StepMotorMinusLimitPanel1->Color = clWhite;
	}
	if (Machine.PortStatus.IPStatus[IP_NC_1_HOME])
	{
		StepMotorHomePanel1->Color = clRed;
	}
	else
	{
		StepMotorHomePanel1->Color = clWhite;
	}
	if (Machine.PortStatus.IPStatus[IP_NC_1_LIMIT_L])
	{
		StepMotorPlusLimitPanel1->Color = clRed;
	}
	else
	{
		StepMotorPlusLimitPanel1->Color = clWhite;
	}
	
	if (Machine.PortStatus.IPStatus[IP_NC_2_LIMIT_L])
	{
		StepMotorMinusLimitPanel2->Color = clRed;
	}
	else
	{
		StepMotorMinusLimitPanel2->Color = clWhite;
	}
	if (Machine.PortStatus.IPStatus[IP_NC_2_HOME])
	{
		StepMotorHomePanel2->Color = clRed;
	}
	else
	{
		StepMotorHomePanel2->Color = clWhite;
	}
	if (Machine.PortStatus.IPStatus[IP_NC_2_LIMIT_H])
	{
		StepMotorPlusLimitPanel2->Color = clRed;
	}
	else
	{
		StepMotorPlusLimitPanel2->Color = clWhite;
	}
	
	if (Machine.PortStatus.IPStatus[IP_NC_3_LIMIT_L])
	{
		StepMotorMinusLimitPanel3->Color = clRed;
	}
	else
	{
		StepMotorMinusLimitPanel3->Color = clWhite;
	}
	if (Machine.PortStatus.IPStatus[IP_NC_3_HOME])
	{
		StepMotorHomePanel3->Color = clRed;
	}
	else
	{
		StepMotorHomePanel3->Color = clWhite;
	}
	if (Machine.PortStatus.IPStatus[IP_NC_3_LIMIT_H])
	{
		StepMotorPlusLimitPanel3->Color = clRed;
	}
	else
	{
		StepMotorPlusLimitPanel3->Color = clWhite;
	}

	if (Machine.PortStatus.IPStatus[IP_NC_4_LIMIT_L])
	{
		StepMotorMinusLimitPanel4->Color = clRed;
	}
	else
	{
		StepMotorMinusLimitPanel4->Color = clWhite;
	}
	if (Machine.PortStatus.IPStatus[IP_NC_4_HOME])
	{
		StepMotorHomePanel4->Color = clRed;
	}
	else
	{
		StepMotorHomePanel4->Color = clWhite;
	}

	if (Machine.PortStatus.IPStatus[IP_NC_4_LIMIT_H])
	{
		StepMotorPlusLimitPanel4->Color = clRed;
	}
	else
	{
		StepMotorPlusLimitPanel4->Color = clWhite;
	}
	if (Machine.PortStatus.IPStatus[IP_NC_5_LIMIT_L])
	{
		StepMotorMinusLimitPanel5->Color = clRed;
	}
	else
	{
		StepMotorMinusLimitPanel5->Color = clWhite;
	}
	if (Machine.PortStatus.IPStatus[IP_NC_5_HOME])
	{
		StepMotorHomePanel5->Color = clRed;
	}
	else
	{
		StepMotorHomePanel5->Color = clWhite;
	}
	if (Machine.PortStatus.IPStatus[IP_NC_5_LIMIT_H])
	{
		StepMotorPlusLimitPanel5->Color = clRed;
	}
	else
	{
		StepMotorPlusLimitPanel5->Color = clWhite;
	}

	for (int stepMotorIndex = 0; stepMotorIndex < MAX_STEP_MOTOR_COUNT; stepMotorIndex++)
	{
		TTntLabel *stepEncoderLabel = (TTntLabel *) FindComponent("AbsEncoderLabel" + IntToStr(stepMotorIndex + 1));
		if (stepEncoderLabel)
		{
			stepEncoderLabel->Caption = IntToStr(Machine.Status.StepMotorAbsEncoder[stepMotorIndex]);
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::MotorSpeedModEditClick(
      TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	int motorIndex = theEdit->Tag;

	TMotorSpeedSelectionForm *motorSpeedSelectionForm = new TMotorSpeedSelectionForm(this);
    motorSpeedSelectionForm->SetSpeed(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed, MachineOperationInfo.ServoMotorSpeed[motorIndex]);
    if (motorSpeedSelectionForm->ShowModal() == mrOk)
    {
		theEdit->Text = IntToStr(motorSpeedSelectionForm->GetSelectedSpeed());
    }
    delete motorSpeedSelectionForm;
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::CloseBitBtnClick(TObject *Sender)
{
	this->Close();	
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::NumEditClick(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
    if (KeyboardForm->ShowKeypad() == mrOk)
    {
		theEdit->Text = KeyboardForm->Text;
    }	
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::Timer1Timer(TObject *Sender)
{
	CheckMachineStatus();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::ABRInSpeedButton1Click(
      TObject *Sender)
{
	Machine.AirBrushIn(0);
  Machine.AirBrushIn(1);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::ABROutSpeedButton1Click(
	  TObject *Sender)
{
	Machine.AirBrushOut(0);
  Machine.AirBrushOut(1);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingForm::ABRInSpeedButton2Click(
	  TObject *Sender)
{
	Machine.AirBrushIn(1);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingForm::ABROutSpeedButton2Click(
      TObject *Sender)
{
	Machine.AirBrushOut(1);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::AirKnifeOnSpeedButtonClick(
	  TObject *Sender)
{
	Machine.AirKnifeOn(0);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::AirKnifeOffSpeedButtonClick(
	  TObject *Sender)
{
	Machine.AirKnifeOff(0);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::AirKnifeOnSpeedButton2Click(
	  TObject *Sender)
{
	Machine.AirKnifeOn(1);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::AirKnifeOffSpeedButton2Click(
	  TObject *Sender)
{
	Machine.AirKnifeOff(1);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::SDBlowerOnSpeedButton1Click(
      TObject *Sender)
{
	Machine.SDBlowerOn(0);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::SDBlowerOffSpeedButton1Click(
	  TObject *Sender)
{
	Machine.SDBlowerOff(0);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::SDBlowerOnSpeedButton2Click(
	  TObject *Sender)
{
	Machine.SDBlowerOn(1);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingForm::SDBlowerOffSpeedButton2Click(
      TObject *Sender)
{
	Machine.SDBlowerOff(1);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::DustBlowerOnSpeedButton1Click(
	  TObject *Sender)
{
	Machine.DustBlowerOn(0);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::DustBlowerOffSpeedButton1Click(
	  TObject *Sender)
{
	Machine.DustBlowerOff(0);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::DustBlowerOnSpeedButton2Click(
	  TObject *Sender)
{
	Machine.DustBlowerOn(1);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingForm::DustBlowerOffSpeedButton2Click(
	  TObject *Sender)
{
	Machine.DustBlowerOff(1);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::DustBlowerOnSpeedButton3Click(
      TObject *Sender)
{
	Machine.DustBlowerOn(2);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::DustBlowerOffSpeedButton3Click(
	  TObject *Sender)
{
	Machine.DustBlowerOff(2);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::DustBlowerOnSpeedButton4Click(
	  TObject *Sender)
{
	Machine.DustBlowerOn(3);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::DustBlowerOffSpeedButton4Click(
	  TObject *Sender)
{
	Machine.DustBlowerOff(3);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::DustBlowerOnSpeedButton5Click(
	  TObject *Sender)
{
	Machine.DustBlowerOn(4);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::DustBlowerOffSpeedButton5Click(
	  TObject *Sender)
{
	Machine.DustBlowerOff(4);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::AirBrushOnSpeedButtonClick(
	  TObject *Sender)
{
	Machine.DustBlowerOn(5);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::AirBrushOffSpeedButtonClick(
	  TObject *Sender)
{
	Machine.DustBlowerOff(5);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::DefectEjectorOnSpeedButtonClick(
	  TObject *Sender)
{
	Machine.EjectorOn(0);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingForm::DefectEjectorOffSpeedButtonClick(
	  TObject *Sender)
{
	Machine.EjectorOff(0);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingForm::UnInsEjectorOnSpeedButtonClick(
	  TObject *Sender)
{
	Machine.EjectorOn(1);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingForm::UnInsEjectorOffSpeedButtonClick(
      TObject *Sender)
{
	Machine.EjectorOff(1);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::MEOpenSpeedButtonClick(
      TObject *Sender)
{
	Machine.MisejectOpen();
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingForm::MECloseSpeedButtonClick(
	  TObject *Sender)
{
	Machine.MisejectClose();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::MEStopSpeedButtonClick(
	  TObject *Sender)
{
	Machine.MisejectStop();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::LampOnSpeedButton1Click(
	  TObject *Sender)
{
	Machine.LampOn(0);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::LampOffSpeedButton1Click(
	  TObject *Sender)
{
	Machine.LampOff(0);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::LampOnSpeedButton2Click(
	  TObject *Sender)
{
	Machine.LampOn(1);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::LampOffSpeedButton2Click(
	  TObject *Sender)
{
	Machine.LampOff(1);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::LampOnSpeedButton3Click(
	  TObject *Sender)
{
	Machine.LampOn(2);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::LampOffSpeedButton3Click(
	  TObject *Sender)
{
	Machine.LampOff(2);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::BuzzerOnSpeedButtonClick(
	  TObject *Sender)
{
	Machine.BuzzerOn();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::BuzzerOffSpeedButtonClick(
	  TObject *Sender)
{
	Machine.BuzzerOff();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::VFOnSpeedButtonClick(TObject *Sender)
{
	try
	{
		int vfSpeed = StrToInt(VFSpeedEdit->Text);
		Machine.VFRun(vfSpeed);
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::VFOffSpeedButtonClick(TObject *Sender)
{
	Machine.VFStop();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::VFMagnetOnSpeedButtonClick(
	  TObject *Sender)
{
	Machine.VFMagnetOn();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::VFMagnetOffSpeedButtonClick(
      TObject *Sender)
{
	Machine.VFMagnetOff();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::RoomLampOnSpeedButtonClick(
      TObject *Sender)
{
	Machine.RoomLampOn();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::RoomLampOffSpeedButtonClick(
	  TObject *Sender)
{
	Machine.RoomLampOff();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::MELampOnSpeedButtonClick(
      TObject *Sender)
{
	Machine.MELampOn();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::MELampOffSpeedButtonClick(
	  TObject *Sender)
{
	Machine.MELampOff();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::StepMotorSpeedButtonClick(
      TObject *Sender)
{
	TTntSpeedButton *theSpeedButton = (TTntSpeedButton *) Sender;
	CurrentStepMotorIndex = theSpeedButton->Tag;
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingForm::StepMotorUpButtonClick(
      TObject *Sender)
{
	if (CurrentStepMotorIndex < 0)
	{
		ShowMessageFA(MACHINESETTINGFORM_MSG_01);
	}

	int pulseCount = 0;
	TTntSpeedButton *theButton = (TTntSpeedButton *)Sender;
	switch (theButton->Tag)
	{
		case 0:
			if (CurrentStepMotorIndex == BF_UP_DOWN_MOTOR_INDEX || CurrentStepMotorIndex == BF_IN_OUT_MOTOR_INDEX ||
				CurrentStepMotorIndex == SD2_LEFT_RIGHT_MOTOR_INDEX)
			{
				pulseCount = 1000;
			}
			else
			{
				pulseCount = 100;
			}
			break;
		case 1:
			pulseCount = 100;
			break;
		case 2:
		default:
			pulseCount = 10;
			break;
	}

	Machine.StepMotorMove(CurrentStepMotorIndex, pulseCount, 0);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingForm::StepMotorDownButtonClick(
      TObject *Sender)
{
	if (CurrentStepMotorIndex < 0)
	{
		ShowMessageFA(MACHINESETTINGFORM_MSG_01);
	}

	int pulseCount = 0;
	TTntSpeedButton *theButton = (TTntSpeedButton *)Sender;
	switch (theButton->Tag)
	{
		case 0:
			if (CurrentStepMotorIndex == BF_UP_DOWN_MOTOR_INDEX || CurrentStepMotorIndex == BF_IN_OUT_MOTOR_INDEX ||
				CurrentStepMotorIndex == SD2_LEFT_RIGHT_MOTOR_INDEX)
			{
				pulseCount = 1000;
			}
			else
			{
				pulseCount = 100;
			}
			break;
		case 1:
			pulseCount = 100;
			break;
		case 2:
		default:
			pulseCount = 10;
			break;
	}

	Machine.StepMotorMove(CurrentStepMotorIndex, pulseCount, 1);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::EmergencyPLCOffSpeedButtonClick(
	  TObject *Sender)
{
	if (EmergencyPLCOffSpeedButton->Down)
	{
		Machine.PLCOff();
	}
	else
	{
		Machine.PLCOn();
	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::SetTestModeSpeedButtonClick(
	  TObject *Sender)
{
	Machine.SetTestMode();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::SetFreeModeSpeedButtonClick(TObject *Sender)
{
	Machine.SetFreeMode();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::SetInterlockModeSpeedButtonClick(TObject *Sender)
{
	Machine.SetInterlockMode();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::HomeSearchButtonClick(TObject *Sender)
{
	if (CurrentStepMotorIndex < 0)
	{
		ShowMessageFA(MACHINESETTINGFORM_MSG_01);
	}
	Machine.NCHomeMoveTest(CurrentStepMotorIndex);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSettingForm::EjectorSolTestSpeedButtonClick(
	  TObject *Sender)
{
	TOPTestData opTestData;

	int testOPCount = 0;
	if (DefectSolOnSpeedButton->Down)
	{
		opTestData.OPList[testOPCount] = OP_DEFECT_BLOWER;
		opTestData.IsPhysicalPort[testOPCount] = 0;
		opTestData.DelayIntervalList[testOPCount] = 0;
		opTestData.OnIntervalList[testOPCount] = StrToInt(DefectSolOnTimeEdit->Text);
		opTestData.OffIntervalList[testOPCount] = StrToInt(DefectSolOffTimeEdit->Text);
		testOPCount++;
	}

	if (UnInsSolOnSpeedButton->Down)
	{
		opTestData.OPList[testOPCount] = OP_UNINSPECTED_BLOWER;
		opTestData.IsPhysicalPort[testOPCount] = 0;
		opTestData.DelayIntervalList[testOPCount] = 0;
		opTestData.OnIntervalList[testOPCount] = StrToInt(UnInsSolOnTimeEdit->Text);
		opTestData.OffIntervalList[testOPCount] = StrToInt(UnInsSolOffTimeEdit->Text);
		testOPCount++;
	}

  if (TntSpeedButton3->Down) // SELMA 200 ߰ 
	{
		opTestData.OPList[testOPCount] = OP_GOOD_BLOWER;
		opTestData.IsPhysicalPort[testOPCount] = 0;
		opTestData.DelayIntervalList[testOPCount] = 0;
		opTestData.OnIntervalList[testOPCount] = StrToInt(TntEdit2->Text);
		opTestData.OffIntervalList[testOPCount] = StrToInt(TntEdit1->Text);
		testOPCount++;
	}
	opTestData.TestCount = testOPCount;
	Machine.PortTest_Blink(&opTestData);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingForm::RBOnSpeedButton1Click(TObject *Sender)
{
	int blowerIndex = 0;
	int speed1 = StrToInt(RB1SpeedEdit->Text);
	int speed2 = StrToInt(RB2SpeedEdit->Text);

	Machine.RingBlowerOn(blowerIndex, speed1, speed2);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingForm::RBOnSpeedButton3Click(TObject *Sender)
{
  int blowerIndex = 1;
	int speed1 = StrToInt(RB1SpeedEdit->Text);
	int speed2 = StrToInt(RB2SpeedEdit->Text);
	Machine.RingBlowerOn(blowerIndex, speed1, speed2);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingForm::RBOnSpeedButton4Click(TObject *Sender)
{
  int blowerIndex = 2;
	int speed1 = StrToInt(RB1SpeedEdit->Text);
	int speed2 = StrToInt(RB2SpeedEdit->Text);
  Machine.RingBlowerOn(blowerIndex, speed1, speed2);
}
//---------------------------------------------------------------------------



void __fastcall TMachineSettingForm::TntSpeedButton1Click(TObject *Sender)
{
  Machine.EjectorOn(2);
}
//---------------------------------------------------------------------------

void __fastcall TMachineSettingForm::TntSpeedButton2Click(TObject *Sender)
{
 Machine.EjectorOff(2); 
}
//---------------------------------------------------------------------------

