//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#include <inifiles.hpp>
#pragma hdrstop

#include "MachineSetupMenu_Form.h"
#include "MachineSetup_Form.h"
#include "MachineSetupProcess_Form.h"
#include "Environment.h"
#include "MachineSettingTest_Form.h"
#include "LaserCalibration_Form.h"
#include "TabletDataLog_Form.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TMachineSetupMenuForm *MachineSetupMenuForm;
//---------------------------------------------------------------------------
__fastcall TMachineSetupMenuForm::TMachineSetupMenuForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  GetDefaultString();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSetupMenuForm::GetDefaultString()
{
  MachineReSetupStartBitBtn->Caption = MACHINESETUPMENUFORM_BITBTN_CAPTION_01;
  CancelBitBtn->Caption = MACHINESETUPMENUFORM_BITBTN_CAPTION_02;
  MachineSettingLogBitBtn->Caption = MACHINESETUPMENUFORM_BITBTN_CAPTION_03;
  ModifyBitBtn->Caption = MACHINESETUPMENUFORM_BITBTN_CAPTION_04;
  TabletSetupStartBitBtn->Caption = MACHINESETUPMENUFORM_BITBTN_CAPTION_05;
  MachineSettingTestBitBtn->Caption = MACHINESETUPMENUFORM_BITBTN_CAPTION_06;
  this->Caption = MACHINESETUPMENUFORM_FORM_CAPTION_01;
  GroupBox1->Caption = MACHINESETUPMENUFORM_GROUPBOX_CAPTION_01;
  GroupBox2->Caption = MACHINESETUPMENUFORM_GROUPBOX_CAPTION_02;
  Label6->Caption = MACHINESETUPMENUFORM_LABEL_CAPTION_01;
  Label7->Caption = MACHINESETUPMENUFORM_LABEL_CAPTION_02;
  Label5->Caption = MACHINESETUPMENUFORM_LABEL_CAPTION_03;
  Label1->Caption = MACHINESETUPMENUFORM_LABEL_CAPTION_04;
  Label15->Caption = MACHINESETUPMENUFORM_LABEL_CAPTION_05;
  Label14->Caption = MACHINESETUPMENUFORM_LABEL_CAPTION_06;
  Label16->Caption = MACHINESETUPMENUFORM_LABEL_CAPTION_07;
  Label3->Caption = MACHINESETUPMENUFORM_LABEL_CAPTION_08;
  Label4->Caption = MACHINESETUPMENUFORM_LABEL_CAPTION_09;
  Label17->Caption = MACHINESETUPMENUFORM_LABEL_CAPTION_10;
  Label2->Caption = MACHINESETUPMENUFORM_LABEL_CAPTION_11;
  LaserCalibrationButton->Caption = MACHINESETUPMENUFORM_LABEL_CAPTION_12;
  LaserCalibrationHelpLabel->Caption = MACHINESETUPMENUFORM_LABEL_CAPTION_13;
}
//---------------------------------------------------------------------------
void __fastcall TMachineSetupMenuForm::ModifyBitBtnClick(TObject *Sender)
{
	TMachineSetupForm *machineSetupForm = new TMachineSetupForm(this);
	machineSetupForm->ShowModal();
    delete machineSetupForm;
}
//---------------------------------------------------------------------------
void __fastcall TMachineSetupMenuForm::MachineSetupStartBitBtnClick(TObject *Sender)
{
	int modalResult;
	TMachineSetupProcessForm *machineSetupProcessForm = new TMachineSetupProcessForm(this);
	if (Sender == MachineReSetupStartBitBtn)
	{
		machineSetupProcessForm->SetMode(EMSM_RESETUP);
	}
	else
	{
		machineSetupProcessForm->SetMode(EMSM_SETUP);
	}
        modalResult = machineSetupProcessForm->ShowModal();
	delete machineSetupProcessForm;
    if (modalResult == mrOk)
    {
		ModalResult = mrOk;
    }
}
//---------------------------------------------------------------------------
void __fastcall TMachineSetupMenuForm::FormCreate(TObject *Sender)
{
  OnUserChange();
	TabletLengthLabel->Caption = FloatToStr(ProductData.TabletLength) + "mm";
	TabletWidthLabel->Caption = FloatToStr(ProductData.TabletWidth) + "mm";
	TabletHeightLabel->Caption = FloatToStr(ProductData.TabletThick) + "mm";

	RotGuideLabel->Caption = "1 - " + IntToStr(ProductData.RotatingGuideKind);
	PEGuideLabel->Caption = "2 - " + IntToStr(ProductData.FixedGuideKind);
	VerticalGateIndLabel->Caption = "2 - " + IntToStr(ProductData.VerticalGate2Kind);

  if(MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
  {
    LaserCalibrationButton->Visible = true;
    LaserCalibrationGroupbox->Visible = true;
  }
  else
  {
    LaserCalibrationButton->Visible = false;
    LaserCalibrationGroupbox->Visible = false;
  }
}
//---------------------------------------------------------------------------
void __fastcall TMachineSetupMenuForm::OnUserChange(void)
{
  if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_MACHINESETUPFORM_NEW_SETUP])
  {
    TabletSetupStartBitBtn->Visible = true;
    GroupBox4->Visible = true;
  }
  else
  {
    TabletSetupStartBitBtn->Visible = false;
    GroupBox4->Visible = false;
  }

  if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_MACHINESETUPFORM_EXIST_SETUP])
  {
    MachineReSetupStartBitBtn->Visible = true;
    GroupBox3->Visible = true;
  }
  else
  {
    MachineReSetupStartBitBtn->Visible = false;
    GroupBox3->Visible = false;
  }

  if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_MACHINESETUPFORM_ADJUST_VALUE])
  {
    ModifyBitBtn->Visible = true;
    ModifyGroupBox->Visible = true;
    MachineSettingLogBitBtn->Visible = true;
  }
  else
  {
    ModifyBitBtn->Visible = false;
    ModifyGroupBox->Visible = false;
    MachineSettingLogBitBtn->Visible = false;
  }

  if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_MACHINESETUPFORM_TEST])
  {
    MachineSettingTestBitBtn->Visible = true;
    MachineSettingTestGroupBox->Visible = true;
  }
  else
  {
    MachineSettingTestBitBtn->Visible = false;
    MachineSettingTestGroupBox->Visible = false;
  }
}
//---------------------------------------------------------------------------

void __fastcall TMachineSetupMenuForm::MachineSettingTestBitBtnClick(
      TObject *Sender)
{
	TMachineSettingTestForm *machineSettingTestForm = new TMachineSettingTestForm(this);
	machineSettingTestForm->ShowModal();
	delete machineSettingTestForm;
}
//---------------------------------------------------------------------------
void __fastcall TMachineSetupMenuForm::MachineSettingLogBitBtnClick(
	  TObject *Sender)
{
	TTabletDataLogForm *tabletDataLogForm = new TTabletDataLogForm(this);
	tabletDataLogForm->ShowModal();
	delete tabletDataLogForm;
}
//---------------------------------------------------------------------------


void __fastcall TMachineSetupMenuForm::LaserCalibrationButtonClick(
      TObject *Sender)
{
  TLaserCalibrationForm *pLaserCalibrationForm = new TLaserCalibrationForm(this);
  pLaserCalibrationForm->ShowModal();
  delete pLaserCalibrationForm;
}
//---------------------------------------------------------------------------

