//---------------------------------------------------------------------------

#ifndef MachineSetupProcess_FormH
#define MachineSetupProcess_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <Buttons.hpp>
#include <ComCtrls.hpp>
#include <Graphics.hpp>

#include "common.h"
#include "TntButtons.hpp"
#include "TntComCtrls.hpp"
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"

#include "Calibration_Form.h"

const int VISUAL_IMAGE_COUNT = 2;

typedef enum {EMSM_SETUP, EMSM_RESETUP} EMachineSetupMode;
//---------------------------------------------------------------------------
class TMachineSetupProcessForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *Panel1;
	TTntBitBtn *CancelBitBtn;
	TTntBitBtn *NextBitBtn;
	TTntBitBtn *PrevBitBtn;
	TTimer *NCReadTimer;
	TTntPageControl *MachineSettingPageControl;
	TTntTabSheet *MainSettingTabSheet;
	TTntTabSheet *RotateGuideSettingTabSheet;
	TTntPanel *Panel7;
	TTntLabel *Label16;
	TTntLabel *Label14;
	TTntLabel *Label19;
	TTntLabel *Label20;
	TTntPanel *Panel5;
	TTntTabSheet *PEGuideSettingTabSheet;
	TTntTabSheet *VerticalGateSettingTabSheet;
	TTntPanel *Panel4;
	TTntLabel *Label12;
	TTntLabel *Label9;
	TTntImage *PEGuideImage;
	TTntGroupBox *GroupBox1;
	TTntLabel *Label8;
	TTntLabel *Label29;
	TTntLabel *PEGuideSettingTabletWidthLabel;
	TTntLabel *PEGuideLabel;
	TTntPanel *Panel8;
	TTntLabel *Label27;
	TTntLabel *Label28;
	TTntImage *RotGuideImage;
	TTntGroupBox *GroupBox3;
	TTntLabel *Label30;
	TTntLabel *Label31;
	TTntLabel *RotGuideSettingTabletWidthLabel;
	TTntLabel *RotGuideLabel;
	TTntPanel *Panel6;
	TTntLabel *Label10;
	TTntLabel *Label11;
	TTntImage *VerticalGateImage;
	TTntGroupBox *GroupBox2;
	TTntLabel *Label13;
	TTntLabel *VerticalGateIndLabel1;
	TTntLabel *Label34;
	TTntLabel *VerticalGateTabletWidthLabel;
	TTntTabSheet *VerticalGateWarningTabSheet;
	TTntTabSheet *BowlFeederSettingTabSheet;
	TTntPanel *Panel18;
	TTntGroupBox *GroupBox5;
	TTntGroupBox *GroupBox6;
	TTntLabel *Label44;
	TTntLabel *MotorSpeedLabel1;
	TTntButton *BFSpeedChangeButton1;
	TTntSpeedButton *BFRunSpeedButton1;
	TTntSpeedButton *BFStopSpeedButton;
	TTntGroupBox *GroupBox8;
	TTntSpeedButton *BFRunSpeedButton2;
	TTntSpeedButton *BFStopSpeedButton2;
	TTntGroupBox *GroupBox7;
	TTntPanel *NCControlPanel3;
	TTntLabel *NCPosLabel3;
	TTntLabel *Label46;
	TTntPanel *StepMotorMinusLimitPanel3;
	TTntPanel *StepMotorPlusLimitPanel3;
	TTntPanel *NCControlPanel4;
	TTntLabel *NCPosLabel4;
	TTntLabel *Label54;
	TTntPanel *StepMotorMinusLimitPanel4;
	TTntPanel *StepMotorPlusLimitPanel4;
	TTntGroupBox *NCControlGroupBox;
	TTntLabel *NCValueLabel1;
	TTntLabel *NCValueLabel2;
	TTntLabel *NCValueLabel3;
	TTntLabel *NCValueLabel4;
	TTntLabel *Label59;
	TTntButton *NCControlUpButton1;
	TTntButton *NCControlDownButton1;
	TTntButton *NCControlUpButton2;
	TTntButton *NCControlDownButton2;
	TTntButton *NCControlUpButton3;
	TTntButton *NCControlDownButton3;
	TTntPanel *Panel16;
	TTntLabel *Label35;
	TTntLabel *Label37;
	TTntLabel *Label38;
	TTntLabel *Label39;
	TTntPanel *Panel17;
	TTntPanel *Panel28;
	TTntLabel *Label47;
	TTntGroupBox *GroupBox11;
	TTntLabel *Label48;
	TTntGroupBox *GroupBox12;
	TTntLabel *Label49;
	TTntGroupBox *GroupBox13;
	TTntLabel *Label50;
	TTntGroupBox *GroupBox14;
	TTntLabel *Label51;
	TTntLabel *Label17;
	TTntLabel *MotorSpeedLabel2;
	TTntButton *BFSpeedChangeButton2;
	TTntImage *InstructionImage;
	TTntPanel *InstructionImagePanel;
	TTntTabSheet *BowlFeederMoveWarningTabSheet;
	TTntPanel *Panel9;
	TTntLabel *Label18;
	TTntLabel *Label21;
	TTntLabel *Label22;
	TTntLabel *Label23;
	TTntPanel *Panel19;
	TTntTabSheet *DiskDistanceSettingTabSheet;
	TTntPanel *Panel35;
	TTntLabel *Label69;
	TTntGroupBox *GroupBox19;
	TTntLabel *Label70;
	TTntGroupBox *GroupBox20;
	TTntLabel *Label71;
	TTntGroupBox *GroupBox21;
	TTntLabel *Label72;
	TTntGroupBox *GroupBox22;
	TTntLabel *Label73;
	TTntPanel *DSInstructionImagePanel;
	TTntImage *DSInstructionImage;
	TTntPanel *Panel37;
	TTntGroupBox *GroupBox31;
	TTntGroupBox *DSNCControlGroupBox;
	TTntLabel *DSNCValueLabel1;
	TTntLabel *DSNCValueLabel2;
	TTntLabel *DSNCValueLabel3;
	TTntLabel *DSNCValueLabel4;
	TTntLabel *Label92;
	TTntButton *DSNCControlUpButton1;
	TTntButton *DSNCControlDownButton1;
	TTntButton *DSNCControlUpButton2;
	TTntButton *DSNCControlDownButton2;
	TTntButton *DSNCControlUpButton3;
	TTntButton *DSNCControlDownButton3;
	TTntGroupBox *GroupBox23;
	TTntLabel *Label74;
	TTntGroupBox *GroupBox24;
	TTntLabel *Label75;
	TTntGroupBox *GroupBox29;
	TTntSpeedButton *SuctionOnSpeedButton1;
	TTntSpeedButton *SuctionOffSpeedButton1;
	TTntLabel *Label76;
	TTntSpeedButton *SuctionOnSpeedButton2;
	TTntSpeedButton *SuctionOffSpeedButton2;
	TTntLabel *Label77;
	TTntPanel *DSNCControlPanel1;
	TTntLabel *NCPosLabel1;
	TTntLabel *Label78;
	TTntPanel *StepMotorMinusLimitPanel1;
	TTntPanel *StepMotorPlusLimitPanel1;
	TTntPanel *DSNCControlPanel5;
	TTntLabel *NCPosLabel5;
	TTntLabel *Label93;
	TTntPanel *StepMotorMinusLimitPanel5;
	TTntPanel *StepMotorPlusLimitPanel5;
	TTntPanel *NCInterlockAPanel;
	TTntTabSheet *DiskCenterSettingTabSheet;
	TTntTabSheet *ProcessEndTabSheet;
	TTntPanel *Panel10;
	TTntLabel *Label41;
	TTntLabel *Label53;
	TTntPanel *Panel11;
	TTntLabel *Label36;
	TTntPanel *Panel23;
	TTntGroupBox *GroupBox30;
	TTntGroupBox *DCNCControlGroupBox;
	TTntLabel *DCNCValueLabel1;
	TTntLabel *DCNCValueLabel2;
	TTntLabel *DCNCValueLabel3;
	TTntLabel *DCNCValueLabel4;
	TTntLabel *Label58;
	TTntButton *DCNCControlUpButton1;
	TTntButton *DCNCControlDownButton1;
	TTntButton *DCNCControlUpButton2;
	TTntButton *DCNCControlDownButton2;
	TTntButton *DCNCControlUpButton3;
	TTntButton *DCNCControlDownButton3;
	TTntPanel *DCInstructionImagePanel;
	TTntPanel *DCNCControlPanel1;
	TTntLabel *NCPosLabel2;
	TTntLabel *Label79;
	TTntPanel *StepMotorMinusLimitPanel2;
	TTntPanel *StepMotorPlusLimitPanel2;
	TTntGroupBox *GroupBox33;
	TTntSpeedButton *CaptureStartSpeedButton;
	TTntSpeedButton *CaptureStopSpeedButton;
	TTntGroupBox *GroupBox34;
	TTntLabel *Label81;
	TTntLabel *MCBFIDSpeedLabel;
	TTntButton *MCBFIDSpeedChangeButton;
	TTntLabel *Label88;
	TTntLabel *MCBFODInSpeedLabel;
	TTntButton *MCBFODinSpeedChangeButton;
	TTntLabel *Label90;
	TTntLabel *MCSDSpeedLabel;
	TTntButton *MCSDSpeedChangeButton;
	TTntPanel *Panel2;
	TTntShape *Shape1;
	TTntImage *CaptureImage1;
	TTntShape *Shape2;
	TTntImage *CaptureImage2;
	TTntGroupBox *GroupBox4;
	TTimer *CaptureCheckTimer;
	TTntImage *DCInstructionImage;
	TTntGroupBox *GroupBox10;
	TTntLabel *Label1;
	TTntLabel *Label2;
	TTntEdit *ShutterSpeedEdit1;
	TTntEdit *ShutterSpeedEdit2;
	TTntLabel *Label3;
	TTntSpeedButton *VFRunSpeedButton;
	TTntSpeedButton *VFStopSpeedButton;
	TTntLabel *TntLabel1;
	TTntLabel *MCBFODOutSpeedLabel;
	TTntButton *MCBFODoutSpeedChangeButton;
	TTntGroupBox *GroupBox9;
	TTntSpeedButton *AirKnifeOnSpeedButton;
	TTntSpeedButton *AirKnifeOffSpeedButton;
	TTntLabel *Label40;
	TTntPanel *AirKnifePowerPanel1;
	TTntPanel *AirKnifePowerPanel2;
	TTntPanel *AirKnifePowerPanel3;
	TTntGroupBox *TntGroupBox1;
	TTntSpeedButton *BFRunSpeedButton3;
	TTntSpeedButton *BFStopSpeedButton3;
	TTntLabel *TntLabel2;
	TTntLabel *MotorSpeedLabel3;
	TTntButton *BFSpeedChangeButton3;
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall PrevBitBtnClick(TObject *Sender);
	void __fastcall NextBitBtnClick(TObject *Sender);
	void __fastcall NCReadTimerTimer(TObject *Sender);
	void __fastcall BFSpeedChangeButtonClick(TObject *Sender);
	void __fastcall BFRunSpeedButtonClick(TObject *Sender);
	void __fastcall BFStopSpeedButtonClick(TObject *Sender);
	void __fastcall AirKnifePowerPanelClick(TObject *Sender);
	void __fastcall AirKnifeOnSpeedButtonClick(TObject *Sender);
	void __fastcall AirKnifeOffSpeedButtonClick(TObject *Sender);
	void __fastcall NCControlPanelClick(TObject *Sender);
	void __fastcall DSNCControlPanelClick(TObject *Sender);
	void __fastcall NCControlUpButtonClick(TObject *Sender);
	void __fastcall NCControlDownButtonClick(TObject *Sender);
	void __fastcall DSNCControlUpButtonClick(TObject *Sender);
	void __fastcall DSNCControlDownButtonClick(TObject *Sender);
	void __fastcall SuctionOnSpeedButtonClick(TObject *Sender);
	void __fastcall SuctionOffSpeedButtonClick(TObject *Sender);
	void __fastcall CancelBitBtnClick(TObject *Sender);
	void __fastcall DCNCControlPanel1Click(TObject *Sender);
	void __fastcall DCNCControlUpButtonClick(TObject *Sender);
	void __fastcall DCNCControlDownButtonClick(TObject *Sender);
	void __fastcall CaptureStartSpeedButtonClick(TObject *Sender);
	void __fastcall CaptureCheckTimerTimer(TObject *Sender);
	void __fastcall MCBFIDSpeedChangeButtonClick(TObject *Sender);
	void __fastcall MCBFODinSpeedChangeButtonClick(TObject *Sender);
	void __fastcall MCSDSpeedChangeButtonClick(TObject *Sender);
	void __fastcall CaptureStopSpeedButtonClick(TObject *Sender);
	void __fastcall ShutterSpeedEditClick(TObject *Sender);
	void __fastcall VFRunSpeedButtonClick(TObject *Sender);
	void __fastcall VFStopSpeedButtonClick(TObject *Sender);
  void __fastcall TntFormActivate(TObject *Sender);
	void __fastcall MCBFODoutSpeedChangeButtonClick(TObject *Sender);
private:	// User declarations
	EMachineSetupMode MachineSetupMode;

	int SettingStep;
	int FeederMoveLeftTime;

	double MachineSettingNCMotorPos[MAX_STEP_MOTOR_COUNT];
	int ServoMotorSpeed[MAX_SERVO_MOTOR_COUNT];
	double ServoMotorSpeedToRPMParam[MAX_SERVO_MOTOR_COUNT];
	int AirKnifePower;
	int SelectedControlIndex;
	int DSSelectedControlIndex;
	int DCSelectedControlIndex;
	int CurrentNCValue;
	int CurrentNCValueDigit[4];
	int DSCurrentNCValue;
	int DSCurrentNCValueDigit[4];
	int DCCurrentNCValue;
	int DCCurrentNCValueDigit[4];
	int NCPosParamMul[MAX_STEP_MOTOR_COUNT];
	int NCPosParamDiv[MAX_STEP_MOTOR_COUNT];
	int UserMinusLimitPortIndex[MAX_STEP_MOTOR_COUNT];
	int UserPlusLimitPortIndex[MAX_STEP_MOTOR_COUNT];

	int ShutterSpeed[SYSTEM_TOTAL_CAMERA_COUNT];
	bool OnCapture;
	TTntImage *CaptureImage[VISUAL_IMAGE_COUNT];
	int UploadingCameraIndex[VISUAL_IMAGE_COUNT];
	unsigned char CaptureData[SYSTEM_CAMERA_WIDTH * SYSTEM_CAMERA_HEIGHT];
  unsigned char CaptureLargeData[SYSTEM_CAMERA_HD_WIDTH * SYSTEM_CAMERA_HD_HEIGHT];

  int CAM_Width;
  int CAM_Height;
  TCSVMachineSettingChangeData machineSettingChangeData;

  bool __fastcall RefreshCameraInfo(int camIndex, int ShutterSpeed);
	void __fastcall RefreshForm(void);
  void __fastcall GetDefaultString();
public:		// User declarations
	__fastcall TMachineSetupProcessForm(TComponent* Owner);

	void __fastcall SetMode(EMachineSetupMode machineSetupMode);
};
//---------------------------------------------------------------------------
extern PACKAGE TMachineSetupProcessForm *MachineSetupProcessForm;
//---------------------------------------------------------------------------
#endif
