//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#include <inifiles.hpp>
#pragma hdrstop

#include "MachineSetup_Form.h"
#include "Environment.h"
#include "Keyboard_Form.h"
#include "SpeedControl_Form.h"
#include "StudySpeedControl_Form.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TMachineSetupForm *MachineSetupForm;
//---------------------------------------------------------------------------
__fastcall TMachineSetupForm::TMachineSetupForm(TComponent* Owner)
	: TTntForm(Owner)
{
	if (DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
		ComponentSetFontName(this, "SimSun");
	else if (DefaultLCID == 1041)
		ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

	GetDefaultString();
}
//---------------------------------------------------------------------------
void __fastcall TMachineSetupForm::GetDefaultString()
{
	CancelBitBtn->Caption = MACHINESETUPFORM_BITBTN_CAPTION_01;
	LoadDefaultBitBtn->Caption = MACHINESETUPFORM_BITBTN_CAPTION_02;
	OkBitBtn->Caption = MACHINESETUPFORM_BITBTN_CAPTION_03;
	RotGuideInChangeButton->Caption = MACHINESETUPFORM_BUTTON_CAPTION_01;
	RotGuideOutChangeButton->Caption = MACHINESETUPFORM_BUTTON_CAPTION_01;
	SpeedControlButton->Caption = MACHINESETUPFORM_BUTTON_CAPTION_02;
	StudiedSpeedButton->Caption = MACHINESETUPFORM_BUTTON_CAPTION_04;
	CurrentPositionButton->Caption = MACHINESETUPFORM_BUTTON_CAPTION_03;
	LampKindComboBox->Text = MACHINESETUPFORM_COMBOBOX_ITEM_02;
	LampKindComboBox->Items->Strings[0] = MACHINESETUPFORM_COMBOBOX_ITEM_02;
	LampKindComboBox->Items->Strings[1] = MACHINESETUPFORM_COMBOBOX_ITEM_01;
	this->Caption = MACHINESETUPFORM_FORM_CAPTION_01;
	GroupBox3->Caption = MACHINESETUPFORM_GROUPBOX_CAPTION_01;
	GroupBox2->Caption = MACHINESETUPFORM_GROUPBOX_CAPTION_02;
	GroupBox5->Caption = MACHINESETUPFORM_GROUPBOX_CAPTION_04;
	GroupBox1->Caption = MACHINESETUPFORM_GROUPBOX_CAPTION_05;
	GroupBox4->Caption = MACHINESETUPFORM_GROUPBOX_CAPTION_06;
	Label14->Caption = MACHINESETUPFORM_LABEL_CAPTION_01;
	Label15->Caption = MACHINESETUPFORM_LABEL_CAPTION_02;
	Label3->Caption = MACHINESETUPFORM_LABEL_CAPTION_03;
	Label2->Caption = MACHINESETUPFORM_LABEL_CAPTION_04;
	Label12->Caption = MACHINESETUPFORM_LABEL_CAPTION_05;
	Label13->Caption = MACHINESETUPFORM_LABEL_CAPTION_06;
	Label5->Caption = MACHINESETUPFORM_LABEL_CAPTION_07;
	Label9->Caption = MACHINESETUPFORM_LABEL_CAPTION_08;
	Label16->Caption = MACHINESETUPFORM_LABEL_CAPTION_09;
	Label7->Caption = MACHINESETUPFORM_LABEL_CAPTION_10;
	Label8->Caption = MACHINESETUPFORM_LABEL_CAPTION_11;
	Label6->Caption = MACHINESETUPFORM_LABEL_CAPTION_12;
	Label22->Caption = MACHINESETUPFORM_LABEL_CAPTION_13;
	Label4->Caption = MACHINESETUPFORM_LABEL_CAPTION_14;
	Label1->Caption = MACHINESETUPFORM_LABEL_CAPTION_15;
	AirKnifeSpeedRadioButton1->Caption = MACHINESETUPFORM_RADIOBTN_CAPTION_01;
	AirKnifeSpeedRadioButton2->Caption = MACHINESETUPFORM_RADIOBTN_CAPTION_02;
	AirKnifeSpeedRadioButton3->Caption = MACHINESETUPFORM_RADIOBTN_CAPTION_03;
	AirKnifeSpeedRadioButton0->Caption = MACHINESETUPFORM_RADIOBTN_CAPTION_04;

	//add
	PEGuideChangeButton->Caption = MACHINESETUPFORM_BUTTON_CAPTION_01;
	VGate2ChangeButton->Caption = MACHINESETUPFORM_BUTTON_CAPTION_01;
  TntLabel5->Caption =  MACHINESETUPFORM_LABEL_CAPTION_16;
  GroupBox7->Caption =  MACHINESETUPFORM_LABEL_CAPTION_17;
  SensorRadioBtn1->Caption =  MACHINESETUPFORM_LABEL_CAPTION_18;
  SensorRadioBtn2->Caption =  MACHINESETUPFORM_LABEL_CAPTION_19;

  SensorRadioBtn3->Caption = MACHINESETUPFORM_LABEL_CAPTION_20;
  	if(MachineSetupData.MachineType < 2)
	{
		Label1->Caption = MACHINESETUPFORM_LABEL_CAPTION_15;
		TntLabel6->Caption = "ȸ̵ ";
		TntLabel6->Visible = false;
		RotGuideOutLabel->Visible = false;
		RotGuideOutChangeButton->Visible = false;
  	}
	else
	{
		Label1->Caption = MACHINESETUPFORM_LABEL_CAPTION_21;
		TntLabel6->Caption = MACHINESETUPFORM_LABEL_CAPTION_22;
		TntLabel6->Visible = true;
		RotGuideOutLabel->Visible = true;
		RotGuideOutChangeButton->Visible = true;	
  	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineSetupForm::FormCreate(TObject *Sender)
{
	CopyProductData(TempProductData, ProductData);

	TTntRadioButton *airKnifeSpeedRadioButton = (TTntRadioButton *)FindComponent("AirKnifeSpeedRadioButton" + IntToStr(TempProductData.MachineRunOption.AirKnifeSpeed));
	if (airKnifeSpeedRadioButton)
	{
		airKnifeSpeedRadioButton->Checked = true;
	}

	TTntRadioButton *sensorSettingRadioBtn = (TTntRadioButton *)FindComponent("SensorRadioBtn" + IntToStr(TempProductData.MachineRunOption.EnabledSensorType + 1));
	if (sensorSettingRadioBtn)
	{
		sensorSettingRadioBtn->Checked = true;
	}

	SuctionDisk1InverterSpeedEdit->Text = IntToStr(TempProductData.MachineRunOption.SuctionDisk1InverterSpeed);
	SuctionDisk2InverterSpeedEdit->Text = IntToStr(TempProductData.MachineRunOption.SuctionDisk2InverterSpeed);

	StudiedSensor1LengthEdit->Text = IntToStr(TempProductData.StudiedSensor1Length);
	StudiedSensor2LengthEdit->Text = IntToStr(TempProductData.StudiedSensor2Length);

	StudiedSensorIntervalAEdit->Text = IntToStr(TempProductData.StudiedSensorIntervalA);
	StudiedSensorIntervalBEdit->Text = IntToStr(TempProductData.StudiedSensorIntervalB);

	if (TempProductData.MachineRunOption.applyEjectorDelay)
		ApplyEjectorDelayCheckBox->Checked = true;
	else
		ApplyEjectorDelayCheckBox->Checked = false;

	UnInsEjectorDelayEdit->Text = IntToStr(TempProductData.MachineRunOption.adjustUnInsDelay);
	DefectEjectorDelayEdit->Text = IntToStr(TempProductData.MachineRunOption.adjustDefectDelay);
	//Q
	//GoodEjectorDelayEdit->Text  = IntToStr(TempProductData.MachineRunOption.adjustGoodDelay);
	EjectorWindStrengthEdit->Text = IntToStr(TempProductData.MachineRunOption.adjustEjectorWindStrength);
	NCMotorPosEdit1->Text = FloatToStr(TempProductData.NCMotorPos[0]);
	NCMotorPosEdit2->Text = FloatToStr(TempProductData.NCMotorPos[1]);
	NCMotorPosEdit3->Text = FloatToStr(TempProductData.NCMotorPos[2]);
	NCMotorPosEdit4->Text = FloatToStr(TempProductData.NCMotorPos[3]);
	NCMotorPosEdit5->Text = FloatToStr(TempProductData.NCMotorPos[4]);

	switch (TempProductData.LampKind)
	{
	case MACHINE_LAMP_KIND_NORMAL_TABLET:
		LampKindComboBox->ItemIndex = 0;
		break;
	case MACHINE_LAMP_KIND_SUGAR_COATED_TABLET:
		LampKindComboBox->ItemIndex = 1;
		break;
	default:
		LampKindComboBox->ItemIndex = 0;
		break;
	}

  AdvancedSettingPanel->Visible = true;
  MachineSetupPanel->Visible = true;
  this->ClientWidth = 1020;
  this->ClientHeight = 592;
  	if(MachineSetupData.MachineType < 2)
	{
		RotGuideInLabel->Caption = "1 - " + IntToStr(TempProductData.RotatingGuideKind);
		RotGuideOutLabel->Caption = "2 - " + IntToStr(TempProductData.RotatingGuideKind);
		PEGuideLabel->Caption = "2 - " + IntToStr(TempProductData.FixedGuideKind);
  	}
	else
	{
		RotGuideInLabel->Caption = "1 - " + IntToStr(TempProductData.RotatingGuideKind);
		RotGuideOutLabel->Caption = "2 - " + IntToStr(TempProductData.RotatingGuideKind);
		PEGuideLabel->Caption = "3 - " + IntToStr(TempProductData.FixedGuideKind);	
	}
	VGate2Label->Caption = "2 - " + IntToStr(TempProductData.VerticalGate2Kind);

	if (!PCProgramOption.SensorOutputSettingOption)
	{
		GroupBox7->Visible = false;
	}

	  if(0)// (MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
	  {
	    SensorRadioBtn1->Enabled = false;
	    SensorRadioBtn2->Enabled = false;
	    SensorRadioBtn3->Checked = true;
	  }

	//	EmptySensorIndexComboBox->ItemIndex = TempProductData.MachineRunOption.EmptySensorIndex;
	//	EmptySensorActiveEdit->Text = IntToStr(TempProductData.MachineRunOption.EmptySensorActiveRatio);
	//	FullSensorIndexComboBox->ItemIndex = TempProductData.MachineRunOption.FullSensorIndex;
	//	FullSensorActiveEdit->Text = IntToStr(TempProductData.MachineRunOption.FullSensorActiveRatio);

	//    Guide2Label->Caption = AnsiString((char)('A' + GuideValues[1]));
}
//---------------------------------------------------------------------------
void __fastcall TMachineSetupForm::OkBitBtnClick(TObject *Sender)
{
	if (MessageDlgFA(MACHINESETUPFORM_MSG_01, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
	{
		TempProductData.MachineRunOption.SuctionDisk1InverterSpeed = StrToInt(SuctionDisk1InverterSpeedEdit->Text);
		TempProductData.MachineRunOption.SuctionDisk2InverterSpeed = StrToInt(SuctionDisk2InverterSpeedEdit->Text);

		TempProductData.NCMotorPos[0] = StrToFloat(NCMotorPosEdit1->Text);
		TempProductData.NCMotorPos[1] = StrToFloat(NCMotorPosEdit2->Text);
		TempProductData.NCMotorPos[2] = StrToFloat(NCMotorPosEdit3->Text);
		TempProductData.NCMotorPos[3] = StrToFloat(NCMotorPosEdit4->Text);
		TempProductData.NCMotorPos[4] = StrToFloat(NCMotorPosEdit5->Text);

		if (ApplyEjectorDelayCheckBox->Checked)
			TempProductData.MachineRunOption.applyEjectorDelay = 1;
		else
			TempProductData.MachineRunOption.applyEjectorDelay = 0;

		TempProductData.MachineRunOption.adjustUnInsDelay = StrToInt(UnInsEjectorDelayEdit->Text);
		TempProductData.MachineRunOption.adjustDefectDelay = StrToInt(DefectEjectorDelayEdit->Text);
		//Q
		//TempProductData.MachineRunOption.adjustGoodDelay = StrToInt(GoodEjectorDelayEdit->Text);
		TempProductData.MachineRunOption.adjustEjectorWindStrength = StrToInt(EjectorWindStrengthEdit->Text);

		//		TempProductData.MachineRunOption.EmptySensorIndex = EmptySensorIndexComboBox->ItemIndex;
		//		TempProductData.MachineRunOption.EmptySensorActiveRatio = StrToInt(EmptySensorActiveEdit->Text);
		//		TempProductData.MachineRunOption.FullSensorIndex = FullSensorIndexComboBox->ItemIndex;
		//		TempProductData.MachineRunOption.FullSensorActiveRatio = StrToInt(FullSensorActiveEdit->Text);

		TempProductData.StudiedSensor1Length = StrToInt(StudiedSensor1LengthEdit->Text);
		TempProductData.StudiedSensor2Length = StrToInt(StudiedSensor2LengthEdit->Text);
		TempProductData.StudiedSensorIntervalA = StrToInt(StudiedSensorIntervalAEdit->Text);
		TempProductData.StudiedSensorIntervalB = StrToInt(StudiedSensorIntervalBEdit->Text);

		switch (LampKindComboBox->ItemIndex)
		{
		case 0:
			TempProductData.LampKind = MACHINE_LAMP_KIND_NORMAL_TABLET;
			break;
		case 1:
			TempProductData.LampKind = MACHINE_LAMP_KIND_SUGAR_COATED_TABLET;
			break;
		default:
			TempProductData.LampKind = MACHINE_LAMP_KIND_NORMAL_TABLET;
			break;
		}
		for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
		{
			TempProductData.StudyMotorSpeedList[motorIndex][_STUDY_SPEED_CONTROL_INDEX] = ProductData.StudyMotorSpeedList[motorIndex][_STUDY_SPEED_CONTROL_INDEX];
		}
		// write csv log
		TCSVMachineSettingChangeData machineSettingChangeData;
		memset(&machineSettingChangeData, 0, sizeof(TCSVMachineSettingChangeData));
		machineSettingChangeData.OldVerticalGateKind = ProductData.VerticalGate2Kind;
		machineSettingChangeData.NewVerticalGateKind = TempProductData.VerticalGate2Kind;
		machineSettingChangeData.OldRotGuide = ProductData.RotatingGuideKind;
		machineSettingChangeData.NewRotGuide = TempProductData.RotatingGuideKind;
		machineSettingChangeData.OldPEGuide = ProductData.FixedGuideKind;
		machineSettingChangeData.NewPEGuide = TempProductData.FixedGuideKind;
		machineSettingChangeData.OldAirKnifeSpeed = ProductData.MachineRunOption.AirKnifeSpeed;
		machineSettingChangeData.NewAirKnifeSpeed = TempProductData.MachineRunOption.AirKnifeSpeed;
		machineSettingChangeData.OldSuctionDisk1InverterSpeed = ProductData.MachineRunOption.SuctionDisk1InverterSpeed;
		machineSettingChangeData.NewSuctionDisk1InverterSpeed = TempProductData.MachineRunOption.SuctionDisk1InverterSpeed;
		machineSettingChangeData.OldSuctionDisk2InverterSpeed = ProductData.MachineRunOption.SuctionDisk2InverterSpeed;
		machineSettingChangeData.NewSuctionDisk2InverterSpeed = TempProductData.MachineRunOption.SuctionDisk2InverterSpeed;

		for (int stepMotorIndex = 0; stepMotorIndex < MAX_STEP_MOTOR_COUNT; stepMotorIndex++)
		{
			machineSettingChangeData.OldNCPos[stepMotorIndex] = ProductData.NCMotorPos[stepMotorIndex];
			machineSettingChangeData.NewNCPos[stepMotorIndex] = TempProductData.NCMotorPos[stepMotorIndex];
		}
		AddCSVActionLog(ECSV_ACTION_CHANGE_MACHINE_SETTING, UserInfo.Name, ProductData.ProductName, (unsigned char *)&machineSettingChangeData, sizeof(TCSVMachineSettingChangeData));
		CopyProductData(ProductData, TempProductData);
		if (ProductDataModified())
		{
			BackupProductData(EPDBR_MACHINE_SETTING_CHANGE);
		}


		AnsiString fileName = GetProductDataFileName(ProductData.ProductCode);
		WriteProductData(fileName, ProductData);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineSetupForm::RotGuideInChangeButtonClick(TObject *Sender)
{
	TempProductData.RotatingGuideKind++;
	if (TempProductData.RotatingGuideKind > 11) TempProductData.RotatingGuideKind = 6;
	RotGuideInLabel->Caption = "1 - " + IntToStr(TempProductData.RotatingGuideKind);
	RotGuideOutLabel->Caption = "2 - " + IntToStr(TempProductData.RotatingGuideKind);
}

//---------------------------------------------------------------------------
void __fastcall TMachineSetupForm::RotGuideOutChangeButtonClick(
      TObject *Sender)
{
	TempProductData.RotatingGuideKind++;
	if (TempProductData.RotatingGuideKind > 11) TempProductData.RotatingGuideKind = 6;
	RotGuideInLabel->Caption = "1 - " + IntToStr(TempProductData.RotatingGuideKind);
	RotGuideOutLabel->Caption = "2 - " + IntToStr(TempProductData.RotatingGuideKind);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSetupForm::PEGuideChangeButtonClick(
	TObject *Sender)
{
	TempProductData.FixedGuideKind++;
	if (TempProductData.FixedGuideKind > 11) TempProductData.FixedGuideKind = 6;
  	if(MachineSetupData.MachineType < 2)
	{	
		PEGuideLabel->Caption = "2 - " + IntToStr(TempProductData.FixedGuideKind);
  	}
	else
	{
		PEGuideLabel->Caption = "3 - " + IntToStr(TempProductData.FixedGuideKind);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineSetupForm::VGate2ChangeButtonClick(TObject *Sender)
{
	TempProductData.VerticalGate2Kind++;
	if (TempProductData.VerticalGate2Kind > 11) TempProductData.VerticalGate2Kind = 6;
	VGate2Label->Caption = "2 - " + IntToStr(TempProductData.VerticalGate2Kind);
}
//---------------------------------------------------------------------------
void __fastcall TMachineSetupForm::LoadDefaultBitBtnClick(TObject *Sender)
{
	TempProductData.RotatingGuideKind = GetDefaultGuideKind(0, ProductData.TabletWidth);
	TempProductData.FixedGuideKind = GetDefaultGuideKind(1, ProductData.TabletWidth);
	TempProductData.VerticalGate2Kind = GetDefaultVGateKind(1, ProductData.TabletWidth);
  	if(MachineSetupData.MachineType < 2)
	{
		RotGuideInLabel->Caption = "1 - " + IntToStr(TempProductData.RotatingGuideKind);
		RotGuideOutLabel->Caption = "2 - " + IntToStr(TempProductData.RotatingGuideKind);
		PEGuideLabel->Caption = "2 - " + IntToStr(TempProductData.FixedGuideKind);
  	}
	else
	{
		RotGuideInLabel->Caption = "1 - " + IntToStr(TempProductData.RotatingGuideKind);
		RotGuideOutLabel->Caption = "2 - " + IntToStr(TempProductData.RotatingGuideKind);
		PEGuideLabel->Caption = "2 - " + IntToStr(TempProductData.FixedGuideKind);	
	}
	VGate2Label->Caption = "2 - " + IntToStr(TempProductData.VerticalGate2Kind);

	if (UserInfo.AccessLevel == SYSTEM_HIGHEST_ACCESS_LEVEL)
	{
		TempProductData.MachineRunOption.ManualModeSensorIndex = MachineSetupData.VFInfo.ManualModeSensorIndex;
		TempProductData.MachineRunOption.ManualModeSensorActiveRatio = MachineSetupData.VFInfo.ManualModeSensorActiveRatio;
		TempProductData.MachineRunOption.EmptySensorActiveRatio = MachineSetupData.VFInfo.EmptySensorActiveRatio;
		TempProductData.MachineRunOption.FullSensorActiveRatio = MachineSetupData.VFInfo.FullSensorActiveRatio;

		AirKnifeSpeedRadioButton2->Checked = true;

		int suctionSpeed1, suctionSpeed2, suctionSpeed3;
		GetDefaultSuctionSpeed(ProductData, suctionSpeed1, suctionSpeed2);
		SuctionDisk1InverterSpeedEdit->Text = IntToStr(suctionSpeed1);
		SuctionDisk2InverterSpeedEdit->Text = IntToStr(suctionSpeed2);

		TempProductData.MachineRunOption.applyEjectorDelay = 0;
		TempProductData.MachineRunOption.adjustUnInsDelay = MachineSetupData.EjectorInfo.UnInsEjectorDelay;
		TempProductData.MachineRunOption.adjustDefectDelay = MachineSetupData.EjectorInfo.DefectEjectorDelay;
		//Q
		//TempProductData.MachineRunOption.adjustGoodDelay = MachineSetupData.EjectorInfo.GoodEjectorDelay;
		TempProductData.MachineRunOption.adjustEjectorWindStrength = MachineSetupData.EjectorInfo.EjectorWindStrength;

		ApplyEjectorDelayCheckBox->Checked = false;
		UnInsEjectorDelayEdit->Text = IntToStr(TempProductData.MachineRunOption.adjustUnInsDelay);
		DefectEjectorDelayEdit->Text = IntToStr(TempProductData.MachineRunOption.adjustDefectDelay);
		//Q
		//GoodEjectorDelayEdit->Text  = IntToStr(TempProductData.MachineRunOption.adjustGoodDelay); 
		EjectorWindStrengthEdit->Text = IntToStr(TempProductData.MachineRunOption.adjustEjectorWindStrength);

		GetDefaultNCPosition(ProductData, TempProductData.NCMotorPos, MachineSetupData.InterlockInfo.NCInterlockAValue / 100.0 -
			MachineSetupData.ZeroPositionValue[3] + MachineSetupData.ZeroPositionValue[0]);

		NCMotorPosEdit1->Text = FloatToStr(TempProductData.NCMotorPos[0]);
		NCMotorPosEdit2->Text = FloatToStr(TempProductData.NCMotorPos[1]);
		NCMotorPosEdit3->Text = FloatToStr(TempProductData.NCMotorPos[2]);
		NCMotorPosEdit4->Text = FloatToStr(TempProductData.NCMotorPos[3]);
		NCMotorPosEdit5->Text = FloatToStr(TempProductData.NCMotorPos[4]);

		TempProductData.MachineRunOption.EnabledSensorType = 0;
		SensorRadioBtn1->Checked = true;
	}
}
//---------------------------------------------------------------------------

void __fastcall TMachineSetupForm::SpeedControlButtonClick(TObject *Sender)
{
	TSpeedControlForm *speedControlForm = new TSpeedControlForm(this);
	if (speedControlForm->ShowModal() == mrOk)
	{
		for (int speedControlIndex = 0; speedControlIndex < MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT; speedControlIndex++)
		{
			for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
			{
				TempProductData.MotorSpeedList[motorIndex][speedControlIndex] = ProductData.MotorSpeedList[motorIndex][speedControlIndex];
			}
		}

		TempProductData.MachineRunOption.EmptySensorActiveRatio = ProductData.MachineRunOption.EmptySensorActiveRatio;
		TempProductData.MachineRunOption.FullSensorActiveRatio = ProductData.MachineRunOption.FullSensorActiveRatio;
		TempProductData.MachineRunOption.StartSpeed = ProductData.MachineRunOption.StartSpeed;
		TempProductData.MachineRunOption.MaxSpeedTrainingMode = ProductData.MachineRunOption.MaxSpeedTrainingMode;
		TempProductData.MachineRunOption.ManualMaxSpeed = ProductData.MachineRunOption.ManualMaxSpeed;
		TempProductData.MachineRunOption.ManualModeSensorIndex = ProductData.MachineRunOption.ManualModeSensorIndex;
		TempProductData.MachineRunOption.ManualModeSensorActiveRatio = ProductData.MachineRunOption.ManualModeSensorActiveRatio;
		TempProductData.MachineRunOption.ManualModeLimitSensorIndex = ProductData.MachineRunOption.ManualModeLimitSensorIndex;
		TempProductData.MachineRunOption.ManualModeLimitSensorActiveRatio = ProductData.MachineRunOption.ManualModeLimitSensorActiveRatio;
	}
	delete speedControlForm;
}
//---------------------------------------------------------------------------


void __fastcall TMachineSetupForm::NumEditClick(
	TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *)Sender;
	KeyboardForm->Text = theEdit->Text;
	if (KeyboardForm->ShowKeypad() == mrOk)
	{
		theEdit->Text = KeyboardForm->Text;
	}
}
//---------------------------------------------------------------------------

void __fastcall TMachineSetupForm::CurrentPositionButtonClick(
	TObject *Sender)
{
	Machine.ReadMachineStatus();
	try
	{
		//		NCMotorPosEdit1->Text = FloatToStr((machineStatus.StepMotorAbsEncoder[0] - MachineSetupData.ZeroEncoderValue[0]) * 100 / NC_POS_PARAM_1 / 100.0);
		//		NCMotorPosEdit2->Text = FloatToStr((machineStatus.StepMotorAbsEncoder[1] - MachineSetupData.ZeroEncoderValue[1]) * 100 / NC_POS_PARAM_2 / 100.0);
		//  	NCMotorPosEdit3->Text = FloatToStr((machineStatus.StepMotorAbsEncoder[2] - MachineSetupData.ZeroEncoderValue[2]) * 100 / NC_POS_PARAM_3 / 100.0);
		//		NCMotorPosEdit4->Text = FloatToStr((machineStatus.StepMotorAbsEncoder[3] - MachineSetupData.ZeroEncoderValue[3]) * 100 / NC_POS_PARAM_4 / 100.0);
		//		NCMotorPosEdit5->Text = FloatToStr((machineStatus.StepMotorAbsEncoder[4] - MachineSetupData.ZeroEncoderValue[4]) * 100 / NC_POS_PARAM_5 / 100.0);
		NCMotorPosEdit1->Text = FloatToStr(((Machine.Status.StepMotorAbsEncoder[0] * 1000 * NC_POS_PARAM_1_DIV / NC_POS_PARAM_1_MUL + 5) / 10) / 100.0 - MachineSetupData.ZeroPositionValue[0]);
		NCMotorPosEdit2->Text = FloatToStr(((Machine.Status.StepMotorAbsEncoder[1] * 1000 * NC_POS_PARAM_2_DIV / NC_POS_PARAM_2_MUL + 5) / 10) / 100.0 - MachineSetupData.ZeroPositionValue[1]);
		NCMotorPosEdit3->Text = FloatToStr(((Machine.Status.StepMotorAbsEncoder[2] * 1000 * NC_POS_PARAM_3_DIV / NC_POS_PARAM_3_MUL + 5) / 10) / 100.0 - MachineSetupData.ZeroPositionValue[2]);
		NCMotorPosEdit4->Text = FloatToStr(((Machine.Status.StepMotorAbsEncoder[3] * 1000 * NC_POS_PARAM_4_DIV / NC_POS_PARAM_4_MUL + 5) / 10) / 100.0 - MachineSetupData.ZeroPositionValue[3]);
		NCMotorPosEdit5->Text = FloatToStr(((Machine.Status.StepMotorAbsEncoder[4] * 1000 * NC_POS_PARAM_5_DIV / NC_POS_PARAM_5_MUL + 5) / 10) / 100.0 - MachineSetupData.ZeroPositionValue[4]);
	}
	catch (Exception &ec)
	{

	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineSetupForm::AirKnifeSpeedRadioButtonClick(
	TObject *Sender)
{
	TTntRadioButton *theRadioButton = (TTntRadioButton *)Sender;
	TempProductData.MachineRunOption.AirKnifeSpeed = theRadioButton->Tag;
}
//---------------------------------------------------------------------------

void __fastcall TMachineSetupForm::StudiedSpeedButtonClick(TObject *Sender)
{
	TStudySpeedControlForm *studySpeedControlForm = new TStudySpeedControlForm(this);
	if (studySpeedControlForm->ShowModal() == mrOk)
	{
		int StudySpeedIndex = 0;

		for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
		{
			TempProductData.MotorSpeedList[motorIndex][StudySpeedIndex] = ProductData.MotorSpeedList[motorIndex][StudySpeedIndex];
		}

		TempProductData.MachineRunOption.EmptySensorActiveRatio = ProductData.MachineRunOption.EmptySensorActiveRatio;
		TempProductData.MachineRunOption.FullSensorActiveRatio = ProductData.MachineRunOption.FullSensorActiveRatio;
		TempProductData.MachineRunOption.StartSpeed = ProductData.MachineRunOption.StartSpeed;
		TempProductData.MachineRunOption.MaxSpeedTrainingMode = ProductData.MachineRunOption.MaxSpeedTrainingMode;
		TempProductData.MachineRunOption.ManualMaxSpeed = ProductData.MachineRunOption.ManualMaxSpeed;
		TempProductData.MachineRunOption.ManualModeSensorIndex = ProductData.MachineRunOption.ManualModeSensorIndex;
		TempProductData.MachineRunOption.ManualModeSensorActiveRatio = ProductData.MachineRunOption.ManualModeSensorActiveRatio;
	}
	delete studySpeedControlForm;
}
//---------------------------------------------------------------------------

void __fastcall TMachineSetupForm::SensorRadioBtn1Click(TObject *Sender)
{
	TTntRadioButton *theRadioButton = (TTntRadioButton *)Sender;
	TempProductData.MachineRunOption.EnabledSensorType = theRadioButton->Tag;
}
//---------------------------------------------------------------------------




