//---------------------------------------------------------------------------
// For SELMA200, 20180221, moon, 
// Camera Index  Ͽ  Text ؾҰ(Language.dat)
// 귯 ġȮ  ۾ؾ( Ϸ)
//---------------------------------------------------------------------------

#include <vcl.h>
#include <windows.h>
#include <process.h>
#include <iostream>
#include <string>
#include <io.h>
#include <conio.h>

#pragma hdrstop

#include "MachineTest_Form.h"
#include "Environment.h"
#include "Keyboard_Form.h"
#include "Message_Form.h"
#include "MotorSpeedSelection_Form.h"
#include "MultiLanguage.h"
#include "RS232PC.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TMachineTestForm *MachineTestForm;

HANDLE hThreadTT = NULL;
BYTE* pByte = NULL;
BYTE* pTxByte= NULL;
bool SerialOnOff = false;
RS232PC* _RS232Serial;
String CommPortName="";
DWORD dwThreadID;
String Value = "0";
float LastLaserPower = 0;
bool ThreadAbort = false;
bool PowerMeterDisconnectCheck =false;

struct Comport
{
  int Count;
  String Name[30];
}; Comport ComPortList;

//-------------------------------------------- 
unsigned int WINAPI PowerMeterSetAndCommThreadFunction(void *arg)
{
  int i = 0;
  char Length = 0;

  // Init Config Set
  pTxByte = new Byte[30];
  pByte = new Byte[100];

  // Power Mode Set
  if(pTxByte !=NULL)
  {
    Length = 5;
    pTxByte[0] = 0x0d;
    pTxByte[1] =0x24;
    pTxByte[2] = 'F';
    pTxByte[3] = 'P';
    pTxByte[4] = 0x0A;

    _RS232Serial->WriteByte(pTxByte,Length);
    //_RS232Serial->WriteByte(pTxByte,Length);
    memset(pByte,0x00,sizeof(BYTE)*100);
      _RS232Serial->ReadByte(pByte,100);
  }

  if(pTxByte !=NULL)
  {
    // Range
    Length = 8;
    pTxByte[0] = 0x0d;
    pTxByte[1] =0x24;
    pTxByte[2] = 'W';
    pTxByte[3] = 'N';
    pTxByte[4] = ' ';
    pTxByte[5] = '-';
    pTxByte[6] = '1';
    pTxByte[7] = 0x0A;

    _RS232Serial->WriteByte(pTxByte,Length);
    //_RS232Serial->WriteByte(pTxByte,Length);
    memset(pByte,0x00,sizeof(BYTE)*100);
      _RS232Serial->ReadByte(pByte,100);
  }

  if(pTxByte !=NULL)
  {
    // Wave Length
    Length = 10;
    pTxByte[0] = 0x0d;
    pTxByte[1] =0x24;
    pTxByte[2] = 'W';
    pTxByte[3] = 'L';
    pTxByte[4] = ' ';
    pTxByte[5] = '2';
    pTxByte[6] = '3';
    pTxByte[7] = '5';
    pTxByte[8] = '5';
    pTxByte[9] = 0x0A;

    _RS232Serial->WriteByte(pTxByte,Length);
    //_RS232Serial->WriteByte(pTxByte,Length);
    memset(pByte,0x00,sizeof(BYTE)*100);
      _RS232Serial->ReadByte(pByte,100);
  }

  if(pTxByte !=NULL)
  {
    // Average
    Length = 7;
    pTxByte[0] = 0x0d;
    pTxByte[1] =0x24;
    pTxByte[2] = 'A';
    pTxByte[3] = 'Q';
    pTxByte[4] = ' ';
    pTxByte[5] = '1';
    pTxByte[6] = 0x0A;

    _RS232Serial->WriteByte(pTxByte,Length);
    //_RS232Serial->WriteByte(pTxByte,Length);
    memset(pByte,0x00,sizeof(BYTE)*100);
      _RS232Serial->ReadByte(pByte,100);
  }

  while(!ThreadAbort)
  {
    if(SerialOnOff == false)
    {
      SerialOnOff = true;

      Length = 5;
      pTxByte[0] = 0x0d;
      pTxByte[1] =0x24;
      pTxByte[2] = 'S';
      pTxByte[3] = 'P';
      pTxByte[4] = 0x0A;

      _RS232Serial->RXClearBuff();
      _RS232Serial->WriteByte(pTxByte,Length);

      memset(pByte,0x00,sizeof(BYTE)*100);
      _RS232Serial->ReadByte(pByte,20);

      String test =  (char*)pByte;
      Value = test;

      SerialOnOff = false;
    }
    Sleep(10);
  }

}

int TMachineTestForm::FindPowerMeterPort()
{
  int i = 0;
  char Length = 0;

  // Init Config Set
  pTxByte = new Byte[30];
  pByte = new Byte[100];

  // Version Check
  Length = 5;
  pTxByte[0] = 0x0d;
  pTxByte[1] =0x24;
  pTxByte[2] = 'V';
  pTxByte[3] = 'E';
  pTxByte[4] = 0x0A;

  _RS232Serial->ClearBuff();
  _RS232Serial->WriteByte(pTxByte,Length);


  memset(pByte,0,100);
  _RS232Serial->ReadByte(pByte,100);

  String test =  (char*)pByte;

  if(test == "" || (test.Length() > 0 && test.c_str()[0] == '?'))
  {
    _RS232Serial->RXClearBuff();
    //_RS232Serial->ReadByte(pByte,100); // READ BUF CLEAR

    _RS232Serial->WriteByte(pTxByte,Length);
    memset(pByte,0,100);
    _RS232Serial->ReadByte(pByte,100);

    test =  (char*)pByte;
  }

  if(test.Length() > 0  && test.c_str()[0] != (char)0x2A)
  {
    delete[] pTxByte;
    pTxByte = NULL;
    delete[] pByte;
    pByte = NULL;

    if(_RS232Serial != NULL)
    {
      _RS232Serial->ClearBuff();
       _RS232Serial->ClosePort();
       _RS232Serial->State = 0;
    }

    return 0;
  }
  else
  {
    return 1;
  }
}

void TMachineTestForm::RefreshComNameList()
{
   int Result = _RS232Serial->_FindCommPortReg(&ComPortList.Name[0], ComPortList.Count);
}

void TMachineTestForm::SafeDeletePowerMeterResource()
{
  PowerMeterTimer->Enabled = false;
  ThreadAbort = true;
  Sleep(1000);

  if(hThreadTT != NULL)
  {
    CloseHandle(hThreadTT);
    hThreadTT = NULL;
    if(pTxByte != NULL)
    {
      delete[] pTxByte;
      pTxByte = NULL;
    }

    if(pByte != NULL)
    {
      delete[] pByte;
      pByte = NULL;
    }
  }
}

bool  TMachineTestForm::PowerMeterDisconnect()
{

  if(LastLaserPower > 0.015)
  {
    ShowMessageFA("  Դϴ.     õ Ͻʽÿ.");
    return false;
  }
  else
  {
    Machine.LaserPowerMeterOff();
  }

  Label38->Visible = false;
  PowerMeterDisconnectCheck = false;

  SafeDeletePowerMeterResource();

  if(_RS232Serial != NULL)
  {
    _RS232Serial->ClosePort();
    _RS232Serial->State = 0;
  }
  
  Disconnectbtn->Enabled = false;
  Connectionbtn->Enabled = true;

  return true;
}

//---------------------------------------------------------------------------
__fastcall TMachineTestForm::TMachineTestForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  GetDefaultString();
	IsTestMode = false;
	TestWarningPanel->BringToFront();

  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1)
  {
    Buzzer2OffPanel->Visible = true;
    Buzzer2OnPanel->Visible = true;
    Buzzer3OffPanel->Visible = true;
    Buzzer3OnPanel->Visible = true;
    //TntLabel2->Visible = true;
    //TestOnPanel->Visible = true;
    //TestOffPanel->Visible = true;
    TntLabel4->Visible = true;
    InterLockOpenPanel->Visible = true;
    InterLockClosePanel->Visible = true;
    TntLabel2->Visible = true;
    TestOnPanel->Visible = true;
    TestOffPanel->Visible = true;

    TntLabel3->Visible = false;
    LeftDoorSenserOffPanel->Visible = false;
    LeftDoorSenserOnPanel->Visible = false;
    Label36->Caption = MACHINETESTFORM_LABEL_CAPTION_39;

    TntLabel5->Visible = true;
    MisejectSensorClosePanel->Visible = true;
    MisejectSensorJamPanel->Visible = true;
    MisejectSensorOpenPanel->Visible = true;
  }
  else
  {
      Label36->Caption = MACHINETESTFORM_LABEL_CAPTION_35;
  }
  if(MachineSetupData.CompanyID == DOMESTIC_MACHINE2)
  {
    Tnt2DistibutorLabel->Visible = true;
    Tnt2DisPanel1->Visible = true;
    Tnt2DisPanel2->Visible = true;
    TntLabel2->Visible = true;
    TestOnPanel->Visible = true;
    TestOffPanel->Visible = true;
  }
  if(MachineSetupData.CompanyID == INTERNATIONAL_MACHINE1 ||MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
  {
    HopperLabel->Visible = true;
    HopperOffpanel->Visible = true;
    HopperOnpanel->Visible = true;  
  }

  if (MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
	{
    PowerMeterNameLabel->Visible = true;
    PowerMeterSensorOnPanel->Visible = true;
    PowerMeterSensorOffPanel->Visible = true;
    LaserShutterNameLabel->Visible = true;
    LaserShutterSensorOnPanel->Visible = true;
    LaserShutterSensorOffPanel->Visible = true;
		
    PowerMeterGroupBox->Visible = true;

    _RS232Serial = new RS232PC();

    RefreshComNameList();
  }
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::GetDefaultString()
{

  TntLabel2->Caption = MACHINETESTFORM_LABEL_CAPTION_37;
  SetInterlockModeButton->Caption = MACHINETESTFORM_BUTTON_CAPTION_01;
  CloseButton->Caption = MACHINETESTFORM_BUTTON_CAPTION_02;
  SetTestModeButton->Caption = MACHINETESTFORM_BUTTON_CAPTION_03;
  GroupBox6->Caption = MACHINETESTFORM_GROUPBOX_CAPTION_01;
  GroupBox2->Caption = MACHINETESTFORM_GROUPBOX_CAPTION_02;
  GroupBox7->Caption = MACHINETESTFORM_GROUPBOX_CAPTION_03;
  GroupBox11->Caption = MACHINETESTFORM_GROUPBOX_CAPTION_04;
  GroupBox4->Caption = MACHINETESTFORM_GROUPBOX_CAPTION_05;
  GroupBox5->Caption = MACHINETESTFORM_GROUPBOX_CAPTION_06;
  GroupBox12->Caption = MACHINETESTFORM_GROUPBOX_CAPTION_07;
  GroupBox1->Caption = MACHINETESTFORM_GROUPBOX_CAPTION_08;
  GroupBox3->Caption = MACHINETESTFORM_GROUPBOX_CAPTION_09;
  Label52->Caption = MACHINETESTFORM_LABEL_CAPTION_01;
  Label51->Caption = MACHINETESTFORM_LABEL_CAPTION_02;
  Label32->Caption = MACHINETESTFORM_LABEL_CAPTION_03;
  Label15->Caption = MACHINETESTFORM_LABEL_CAPTION_04;
  Label17->Caption = MACHINETESTFORM_LABEL_CAPTION_05;
  Label20->Caption = MACHINETESTFORM_LABEL_CAPTION_06;
  Label18->Caption = MACHINETESTFORM_LABEL_CAPTION_07;
  Label47->Caption = MACHINETESTFORM_LABEL_CAPTION_08;
  Label50->Caption = MACHINETESTFORM_LABEL_CAPTION_09;
  Label12->Caption = MACHINETESTFORM_LABEL_CAPTION_10;
  Label2->Caption = MACHINETESTFORM_LABEL_CAPTION_11;
  Label29->Caption = MACHINETESTFORM_LABEL_CAPTION_12;
  Label30->Caption = MACHINETESTFORM_LABEL_CAPTION_13;
  Label8->Caption = MACHINETESTFORM_LABEL_CAPTION_14;
  Label42->Caption = MACHINETESTFORM_LABEL_CAPTION_15;
  Label1->Caption = MACHINETESTFORM_LABEL_CAPTION_16;
  Label9->Caption = MACHINETESTFORM_LABEL_CAPTION_17;
  Label10->Caption = MACHINETESTFORM_LABEL_CAPTION_18;
  Label35->Caption = MACHINETESTFORM_LABEL_CAPTION_19;
  Label53->Caption = MACHINETESTFORM_LABEL_CAPTION_20;
  Label54->Caption = MACHINETESTFORM_LABEL_CAPTION_21;
  Label11->Caption = MACHINETESTFORM_LABEL_CAPTION_22;
  Label14->Caption = MACHINETESTFORM_LABEL_CAPTION_23;
  Label35->Caption = MACHINETESTFORM_LABEL_CAPTION_24;
  Label55->Caption = MACHINETESTFORM_LABEL_CAPTION_25;
  Label56->Caption = MACHINETESTFORM_LABEL_CAPTION_26;
  Label22->Caption = MACHINETESTFORM_LABEL_CAPTION_27;
  Label24->Caption = MACHINETESTFORM_LABEL_CAPTION_27;
  TntLabel8->Caption = MACHINETESTFORM_LABEL_CAPTION_27;  
  Label21->Caption = MACHINETESTFORM_LABEL_CAPTION_27;
  Label23->Caption = MACHINETESTFORM_LABEL_CAPTION_27;

  Label5->Caption = MACHINETESTFORM_LABEL_CAPTION_28;
  Label16->Caption = MACHINETESTFORM_LABEL_CAPTION_29;
  Label19->Caption = MACHINETESTFORM_LABEL_CAPTION_30;
  Label3->Caption = MACHINETESTFORM_LABEL_CAPTION_31;
  Label4->Caption = MACHINETESTFORM_LABEL_CAPTION_32;
  Label6->Caption = MACHINETESTFORM_LABEL_CAPTION_33;
  Label25->Caption = MACHINETESTFORM_LABEL_CAPTION_34;
  Label26->Caption = MACHINETESTFORM_LABEL_CAPTION_34;

  GreenLightOffLabel->Caption = MACHINETESTFORM_PANEL_CAPTION_01;
  GreenLightOnLabel->Caption = MACHINETESTFORM_PANEL_CAPTION_02;
  BuzzerOffLabel->Caption = MACHINETESTFORM_PANEL_CAPTION_03;
  BuzzerOnLabel->Caption = MACHINETESTFORM_PANEL_CAPTION_04;
  RedLightOffLabel->Caption = MACHINETESTFORM_PANEL_CAPTION_05;
  RedLightOnLabel->Caption = MACHINETESTFORM_PANEL_CAPTION_06;
  YellowLightOffLabel->Caption = MACHINETESTFORM_PANEL_CAPTION_07;
  YellowLightOnLabel->Caption = MACHINETESTFORM_PANEL_CAPTION_08;
  RBOnPanel1->Caption = MACHINETESTFORM_PANEL_CAPTION_09;
  RBOnPanel3->Caption = MACHINETESTFORM_PANEL_CAPTION_09;
  RBOnPanel2->Caption = MACHINETESTFORM_PANEL_CAPTION_09;
  RBOffPanel1->Caption = MACHINETESTFORM_PANEL_CAPTION_10;
  RBOffPanel3->Caption = MACHINETESTFORM_PANEL_CAPTION_10;
  RBOffPanel2->Caption = MACHINETESTFORM_PANEL_CAPTION_10;
  TestWarningPanel->Caption = MACHINETESTFORM_PANEL_CAPTION_11;

  Buzzer2OnLabel->Caption = MACHINETESTFORM_PANEL_CAPTION_14;
  Buzzer2OffLabel->Caption = MACHINETESTFORM_PANEL_CAPTION_15;
  Buzzer3OnLabel->Caption = MACHINETESTFORM_PANEL_CAPTION_16;
  Buzzer3OffLabel->Caption = MACHINETESTFORM_PANEL_CAPTION_17;

  Tnt2DistibutorLabel->Caption =  MACHINETESTFORM_PANEL_CAPTION_19;	//й
  Tnt2DisPanel1->Caption =  MACHINETESTFORM_PANEL_CAPTION_20;	//й 1
  Tnt2DisPanel2->Caption =  MACHINETESTFORM_PANEL_CAPTION_21;	//й 2
  Label13->Caption =  MACHINESETTINGFORM_LABEL_CAPTION_08;

  Label34->Caption = MACHINETESTFORM_LABEL_CAPTION_19;
  Label27->Caption = "Measured RPM";
  Label28->Caption = "Measured RPM";

  TntLabel1->Caption = NEW_ADD_STRING_05;
  TntLabel4->Caption = MACHINETESTFORM_LABEL_CAPTION_42;

  if(DefaultLCID == 1042 || DefaultLCID == 2066)
  {
    TntLabel3->Caption = "  ";
  }
  else
  {
    TntLabel3->Caption = "Left Door Sensor";
  }

  HopperLabel->Caption = MACHINETESTFORM_LABEL_CAPTION_40;
  TntLabel5->Caption = MACHINETESTFORM_LABEL_CAPTION_41;


// ON OFF Panel Button
	AirKnifeOnPanel->Caption				=	MACHINETESTFORM_PANEL_CAPTION_23;
    SDBlower1OnPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_23;
    SDBlower2OnPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_23;
    DefectEjectorOnPanel->Caption		=	MACHINETESTFORM_PANEL_CAPTION_23;
    UnInsEjectorOnPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_23;
    TestOnPanel->Caption					=	MACHINETESTFORM_PANEL_CAPTION_23;
    DustBlowerOnPanel1->Caption			=	MACHINETESTFORM_PANEL_CAPTION_23;
    DustBlowerOnPanel2->Caption			=	MACHINETESTFORM_PANEL_CAPTION_23;
    DustBlowerOnPanel3->Caption			=	MACHINETESTFORM_PANEL_CAPTION_23;
    DustBlowerOnPanel4->Caption			=	MACHINETESTFORM_PANEL_CAPTION_23;
    AirBrushOnPanel->Caption				=	MACHINETESTFORM_PANEL_CAPTION_23;
    SensorBlowerOnPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_23;
    LeftLight1OnPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_23;
    LeftLight2OnPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_23;
    RightLight1OnPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_23;
    RightLight2OnPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_23;
    BFSensor1OnPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_23;
    BFSensor2OnPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_23;
    VDSensor1OnPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_23;
    VDSensor2OnPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_23;
    CounterSensorOnPanel->Caption	   	=	MACHINETESTFORM_PANEL_CAPTION_23;
    EmissionSensorOnPanel->Caption	   	=	MACHINETESTFORM_PANEL_CAPTION_23;
    FrontDoorSensorOnPanel->Caption	   	=	MACHINETESTFORM_PANEL_CAPTION_23;
    HopperOnpanel->Caption				=	MACHINETESTFORM_PANEL_CAPTION_23;
    LeftDoorSenserOnPanel->Caption	   	=	MACHINETESTFORM_PANEL_CAPTION_23;
    PowerMeterSensorOnPanel->Caption	   	=	MACHINETESTFORM_PANEL_CAPTION_23;
    LaserShutterSensorOnPanel->Caption	=	MACHINETESTFORM_PANEL_CAPTION_23;
    MainPowerOnPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_23;
    PCOnPanel->Caption					=	MACHINETESTFORM_PANEL_CAPTION_23;
    EmergencyOnPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_23;
    MonitorSWOnPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_23;
    RB3OLOnPanel->Caption				=	MACHINETESTFORM_PANEL_CAPTION_23;

	AirKnifeOffPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_24;
    SDBlower1OffPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_24;
    SDBlower2OffPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_24;
    DefectEjectorOffPanel->Caption		=	MACHINETESTFORM_PANEL_CAPTION_24;
    UnInsEjectorOffPanel->Caption		=	MACHINETESTFORM_PANEL_CAPTION_24;
    TestOffPanel->Caption				=	MACHINETESTFORM_PANEL_CAPTION_24;
    DustBlowerOffPanel1->Caption			=	MACHINETESTFORM_PANEL_CAPTION_24;
    DustBlowerOffPanel2->Caption			=	MACHINETESTFORM_PANEL_CAPTION_24;
    DustBlowerOffPanel3->Caption			=	MACHINETESTFORM_PANEL_CAPTION_24;
    DustBlowerOffPanel4->Caption			=	MACHINETESTFORM_PANEL_CAPTION_24;
    AirBrushOffPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_24;
    SensorBlowerOffPanel->Caption		=	MACHINETESTFORM_PANEL_CAPTION_24;
    LeftLight1OffPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_24;
    LeftLight2OffPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_24;
    RightLight1OffPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_24;
    RightLight2OffPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_24;
    BFSensor1OffPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_24;
    BFSensor2OffPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_24;
    VDSensor1OffPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_24;
    VDSensor2OffPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_24;
    CounterSensorOffPanel->Caption		=	MACHINETESTFORM_PANEL_CAPTION_24;
    EmissionSensorOffPanel->Caption		=	MACHINETESTFORM_PANEL_CAPTION_24;
    FrontDoorSensorOffPanel->Caption	=	MACHINETESTFORM_PANEL_CAPTION_24;
    HopperOffpanel->Caption				=	MACHINETESTFORM_PANEL_CAPTION_24;
    LeftDoorSenserOffPanel->Caption		=	MACHINETESTFORM_PANEL_CAPTION_24;
    PowerMeterSensorOffPanel->Caption	=	MACHINETESTFORM_PANEL_CAPTION_24;
    LaserShutterSensorOffPanel->Caption	=	MACHINETESTFORM_PANEL_CAPTION_24;
    MainPowerOffPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_24;
    PCOffPanel->Caption					=	MACHINETESTFORM_PANEL_CAPTION_24;
    EmergencyOffPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_24;
    MonitorSWOffPanel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_24;
    RB3OLOffPanel->Caption				=	MACHINETESTFORM_PANEL_CAPTION_24;

// RUN STOP Panel Button
	VFRunPanel->Caption 				=	MACHINETESTFORM_PANEL_CAPTION_29;
    ServoMotorStartPanel3->Caption 		=	MACHINETESTFORM_PANEL_CAPTION_29;
    ServoMotorStartPanel4->Caption 		=	MACHINETESTFORM_PANEL_CAPTION_29;
    ServoMotorStartPanel1->Caption 		=	MACHINETESTFORM_PANEL_CAPTION_29;
    ServoMotorStartPanel2->Caption 		=	MACHINETESTFORM_PANEL_CAPTION_29;

	VFStopPanel->Caption 				=	MACHINETESTFORM_PANEL_CAPTION_30;
    ServoMotorStopPanel3->Caption 		=	MACHINETESTFORM_PANEL_CAPTION_30;
    ServoMotorStopPanel4->Caption 		=	MACHINETESTFORM_PANEL_CAPTION_30;
    ServoMotorStopPanel1->Caption 		=	MACHINETESTFORM_PANEL_CAPTION_30;
    ServoMotorStopPanel2->Caption 		=	MACHINETESTFORM_PANEL_CAPTION_30;

// IN OUT
   	CylinderInPanel1->Caption =	MACHINETESTFORM_PANEL_CAPTION_25;
    CylinderInPanel2->Caption =	MACHINETESTFORM_PANEL_CAPTION_25;

   	CylinderOutPanel1->Caption =	MACHINETESTFORM_PANEL_CAPTION_26;
    CylinderOutPanel2->Caption =	MACHINETESTFORM_PANEL_CAPTION_26;

// OPEN CLOSE
	CylinderOpenPanel3->Caption =	MACHINETESTFORM_PANEL_CAPTION_27;
    InterLockOpenPanel->Caption =	MACHINETESTFORM_PANEL_CAPTION_27;

	CylinderClosePanel3->Caption =	MACHINETESTFORM_PANEL_CAPTION_28;
    InterLockClosePanel->Caption =	MACHINETESTFORM_PANEL_CAPTION_28;

// ON OFF
	RedLightOnLabel->Caption	=	MACHINETESTFORM_PANEL_CAPTION_06;
    YellowLightOnLabel->Caption	=	MACHINETESTFORM_PANEL_CAPTION_08;
    GreenLightOnLabel->Caption	=	MACHINETESTFORM_PANEL_CAPTION_02;
    BuzzerOnLabel->Caption		=	MACHINETESTFORM_PANEL_CAPTION_04;
    Buzzer2OnLabel->Caption		=	MACHINETESTFORM_PANEL_CAPTION_14;
    Buzzer3OnLabel->Caption		=	MACHINETESTFORM_PANEL_CAPTION_16;

	RedLightOffLabel->Caption		=	MACHINETESTFORM_PANEL_CAPTION_05;
    GreenLightOffLabel->Caption		=	MACHINETESTFORM_PANEL_CAPTION_01;
    YellowLightOffLabel->Caption	=	MACHINETESTFORM_PANEL_CAPTION_07;
    BuzzerOffLabel->Caption			=	MACHINETESTFORM_PANEL_CAPTION_03;
    Buzzer2OffLabel->Caption		=	MACHINETESTFORM_PANEL_CAPTION_15;
    Buzzer3OffLabel->Caption		=	MACHINETESTFORM_PANEL_CAPTION_17;

// korean
	RBOnPanel1->Caption		=	"RB 1 " + MACHINETESTFORM_PANEL_CAPTION_09;
    RBOnPanel2->Caption		=	"RB 2 " + MACHINETESTFORM_PANEL_CAPTION_09;
    RBOnPanel3->Caption		=	"RB 3 " + MACHINETESTFORM_PANEL_CAPTION_09;
    Tnt2DisPanel1->Caption	=	MACHINETESTFORM_PANEL_CAPTION_12;

	RBOffPanel1->Caption	=	"RB 1 " + MACHINETESTFORM_PANEL_CAPTION_10;
    RBOffPanel2->Caption	=	"RB 2 " + MACHINETESTFORM_PANEL_CAPTION_10;
    RBOffPanel3->Caption	=	"RB 3 " + MACHINETESTFORM_PANEL_CAPTION_10;
    Tnt2DisPanel2->Caption	=	MACHINETESTFORM_PANEL_CAPTION_13;

    MisejectSensorOpenPanel->Caption 	=	MACHINETESTFORM_PANEL_CAPTION_27;
    MisejectSensorJamPanel->Caption 	= 	MACHINETESTFORM_PANEL_CAPTION_31;
    MisejectSensorClosePanel->Caption	=	MACHINETESTFORM_PANEL_CAPTION_28;

    GroupBox8->Caption = MACHINETESTFORM_GROUPBOX_CAPTION_11;

    GroupBox9->Caption 			= MACHINETESTFORM_GROUPBOX_CAPTION_10;
    SensorARadioBtn->Caption	= MACHINETESTFORM_RADIOBUTTON_CAPTION_01;
    SensorBRadioBtn->Caption	= MACHINETESTFORM_RADIOBUTTON_CAPTION_02;
    SensorCRadioBtn->Caption	= MACHINETESTFORM_RADIOBUTTON_CAPTION_03;

    if(MachineSetupData.MachineType < 2)
    {
  	  Label7->Caption = MACHINETESTFORM_LABEL_CAPTION_36;
	  TntLabel6->Visible = false;
	  TntLabel8->Visible = false;
	  FeederOuterDiskSpeedEdit2->Visible = false;
  	  ServoMotorStartPanel5->Visible = false;
  	  ServoMotorStopPanel5->Visible = false;
    }
    else
    {
   	  Label7->Caption = MACHINETESTFORM_LABEL_CAPTION_45;
	  TntLabel6->Caption = MACHINETESTFORM_LABEL_CAPTION_46;
	  TntLabel6->Visible = true;
	  TntLabel8->Visible = true;
	  FeederOuterDiskSpeedEdit2->Visible = true;
  	  ServoMotorStartPanel5->Visible = true;
  	  ServoMotorStopPanel5->Visible = true;
    }

}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::NumberEditClick(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
    if (KeyboardForm->ShowKeypad() == mrOk)
    {
		theEdit->Text = KeyboardForm->Text;
    }
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::VFRunPanelClick(TObject *Sender)
{
	try
	{
		int vfSpeed = StrToInt(VFSpeedEdit->Text);
		Machine.VFRun(vfSpeed);
		VFRunPanel->Color = (TColor) 0x80FF80;
		VFStopPanel->Color = clWhite;
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::VFStopPanelClick(TObject *Sender)
{
	Machine.VFStop();

	VFStopPanel->Color = (TColor) 0x80FF80;
	VFRunPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::RedLightOnPanelClick(TObject *Sender)
{
	Machine.LampOn(0);

	RedLightOnPanel->Color = (TColor) 0x80FF80;
	RedLightOffPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::RedLightOffPanelClick(TObject *Sender)
{
	Machine.LampOff(0);

	RedLightOffPanel->Color = (TColor) 0x80FF80;
	RedLightOnPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::YellowLightOnPanelClick(TObject *Sender)
{
	Machine.LampOn(1);

	YellowLightOnPanel->Color = (TColor) 0x80FF80;
	YellowLightOffPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::YellowLightOffPanelClick(
	  TObject *Sender)
{
	Machine.LampOff(1);

	YellowLightOffPanel->Color = (TColor) 0x80FF80;
	YellowLightOnPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::GreenLightOnPanelClick(TObject *Sender)
{
	Machine.LampOn(2);

	GreenLightOnPanel->Color = (TColor) 0x80FF80;
	GreenLightOffPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::GreenLightOffPanelClick(TObject *Sender)
{
	Machine.LampOff(2);

	GreenLightOffPanel->Color = (TColor) 0x80FF80;
	GreenLightOnPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::BuzzerOnPanelClick(TObject *Sender)
{
	Machine.BuzzerOn();

	BuzzerOnPanel->Color = (TColor) 0x80FF80;
	BuzzerOffPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::BuzzerOffPanelClick(TObject *Sender)
{
	Machine.BuzzerOff();

	BuzzerOffPanel->Color = (TColor) 0x80FF80;
	BuzzerOnPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::RBOnPanelClick(TObject *Sender)
{
	TTntPanel *thePanel = (TTntPanel *)Sender;

	int blowerIndex = thePanel->Tag;
	int speed1 = 200;
	int speed2 = 200;

	Machine.RingBlowerOn(blowerIndex, speed1, speed2);

	int panelIndex = thePanel->Tag;
	if (panelIndex == 0)
	{
		RBOnPanel1->Color = (TColor) 0x80FF80;
		RBOffPanel1->Color = clWhite;
	}
	else if (panelIndex == 1)
	{
		RBOnPanel2->Color = (TColor) 0x80FF80;
		RBOffPanel2->Color = clWhite;
	}
	else if (panelIndex == 2)
	{
		RBOnPanel3->Color = (TColor) 0x80FF80;
		RBOffPanel3->Color = clWhite;
	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::RBOffPanelClick(TObject *Sender)
{
	TTntPanel *thePanel = (TTntPanel *)Sender;

	int blowerIndex = thePanel->Tag;

	Machine.RingBlowerOff(blowerIndex);

	int panelIndex = thePanel->Tag;
	if (panelIndex == 0)
	{
		RBOffPanel1->Color = (TColor) 0x80FF80;
		RBOnPanel1->Color = clWhite;
	}
	else if (panelIndex == 1)
	{
		RBOffPanel2->Color = (TColor) 0x80FF80;
		RBOnPanel2->Color = clWhite;
	}
	else if (panelIndex == 2)
	{
		RBOffPanel3->Color = (TColor) 0x80FF80;
		RBOnPanel3->Color = clWhite;
	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::AirKnifeOnPanelClick(
	  TObject *Sender)
{
	Machine.AirKnifeOn(0);

	AirKnifeOnPanel->Color = (TColor) 0x80FF80;
	AirKnifeOffPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::AirKnifeOffPanelClick(
      TObject *Sender)
{
	Machine.AirKnifeOff(0);

	AirKnifeOffPanel->Color = (TColor) 0x80FF80;
	AirKnifeOnPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::SDBlower1OnPanelClick(
	  TObject *Sender)
{
	Machine.SDBlowerOn(0);

	SDBlower1OnPanel->Color = (TColor) 0x80FF80;
	SDBlower1OffPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::SDBlower1OffPanelClick(
	  TObject *Sender)
{
	Machine.SDBlowerOff(0);

	SDBlower1OffPanel->Color = (TColor) 0x80FF80;
	SDBlower1OnPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::SDBlower2OnPanelClick(TObject *Sender)
{
	Machine.SDBlowerOn(1);

	SDBlower2OnPanel->Color = (TColor) 0x80FF80;
	SDBlower2OffPanel->Color = clWhite;
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::SDBlower2OffPanelClick(TObject *Sender)
{
	Machine.SDBlowerOff(1);

	SDBlower2OffPanel->Color = (TColor) 0x80FF80;
	SDBlower2OnPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::DefectEjectorOnPanelClick(
	  TObject *Sender)
{
	Machine.EjectorOn(0);

	DefectEjectorOnPanel->Color = (TColor) 0x80FF80;
	DefectEjectorOffPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::DefectEjectorOffPanelClick(
	  TObject *Sender)
{
	Machine.EjectorOff(0);

	DefectEjectorOffPanel->Color = (TColor) 0x80FF80;
	DefectEjectorOnPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::UnInsEjectorOnPanelClick(
	  TObject *Sender)
{
	Machine.EjectorOn(1);

	UnInsEjectorOnPanel->Color = (TColor) 0x80FF80;
	UnInsEjectorOffPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::UnInsEjectorOffPanelClick(
	  TObject *Sender)
{
	Machine.EjectorOff(1);

	UnInsEjectorOffPanel->Color = (TColor) 0x80FF80;
	UnInsEjectorOnPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::CylinderInPanel1Click(
	  TObject *Sender)
{
	Machine.AirBrushIn(0);
  Machine.AirBrushIn(1);

	CylinderInPanel1->Color = (TColor) 0x80FF80;
	CylinderOutPanel1->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::CylinderOutPanel1Click(
	  TObject *Sender)
{
	Machine.AirBrushOut(0);
  Machine.AirBrushOut(1);

	CylinderOutPanel1->Color = (TColor) 0x80FF80;
	CylinderInPanel1->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::CylinderInPanel2Click(
	  TObject *Sender)
{
	Machine.AirBrushIn(1);

	CylinderInPanel2->Color = (TColor) 0x80FF80;
	CylinderOutPanel2->Color = clWhite;
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::CylinderOutPanel2lick(
	  TObject *Sender)
{
	Machine.AirBrushOut(1);

	CylinderOutPanel2->Color = (TColor) 0x80FF80;
	CylinderInPanel2->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::CylinderOpenPanel3Click(TObject *Sender)
{
	Machine.MisejectOpen();

	CylinderOpenPanel3->Color = (TColor) 0x80FF80;
	CylinderClosePanel3->Color = clWhite;
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::CylinderClosePanel3Click(TObject *Sender)
{
	Machine.MisejectClose();

	CylinderClosePanel3->Color = (TColor) 0x80FF80;
	CylinderOpenPanel3->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::ServoMotorStartPanelClick(
	  TObject *Sender)
{
	TTntPanel *thePanel = (TTntPanel *)Sender;

	if (thePanel->Tag < MAX_SERVO_MOTOR_COUNT)
	{
		int motorIndex = thePanel->Tag;
		int baseSpeed = MachineSetupData.ServoMotorData[motorIndex].BaseSpeed;
		int targetSpeed = 0; 
		if (motorIndex == SD1_MOTOR_INDEX)
		{
			targetSpeed = Disk1TargetSpeed;
		}
		else if (motorIndex == SD2_MOTOR_INDEX)
		{
			targetSpeed = Disk2TargetSpeed;
		}
		else if (motorIndex == BF_ID_MOTOR_INDEX)
		{
			targetSpeed = FeederInnerDiskTargetSpeed;
		}
		else if (motorIndex == BF_OD_IN_MOTOR_INDEX)
		{
			targetSpeed = FeederOuterDisk1TargetSpeed;
		}
		else if (motorIndex == BF_OD_OUT_MOTOR_INDEX)
		{
			targetSpeed = FeederOuterDisk2TargetSpeed;
		}		
		int accTime = MachineSetupData.ServoMotorData[motorIndex].AccTime;
		int dir = 0;
		if (MachineSetupData.ServoMotorData[motorIndex].Dir)
		{
			dir = 1;
		}
		else
		{
	    dir = 0;
    }

		Machine.ServoMotorRun(motorIndex, baseSpeed, targetSpeed, accTime, dir);
	}

	int panelIndex = thePanel->Tag;
	if (panelIndex == 0)
	{
		ServoMotorStartPanel1->Color = (TColor) 0x80FF80;
		ServoMotorStopPanel1->Color = clWhite;
	}
	else if (panelIndex == 1)
	{
		ServoMotorStartPanel2->Color = (TColor) 0x80FF80;
		ServoMotorStopPanel2->Color = clWhite;
	}
	else if (panelIndex == 2)
	{
		ServoMotorStartPanel3->Color = (TColor) 0x80FF80;
		ServoMotorStopPanel3->Color = clWhite;
	}
	else if (panelIndex == 3)
	{
		ServoMotorStartPanel4->Color = (TColor) 0x80FF80;
		ServoMotorStopPanel4->Color = clWhite;
	}
	else if (panelIndex == 4)
	{
		ServoMotorStartPanel5->Color = (TColor) 0x80FF80;
		ServoMotorStopPanel5->Color = clWhite;
	}	
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::ServoMotorStopPanelClick(
      TObject *Sender)
{
	TTntPanel *thePanel = (TTntPanel *)Sender;

    if (thePanel->Tag < MAX_SERVO_MOTOR_COUNT)
    {
		int motorIndex = thePanel->Tag;
		int decTime = MachineSetupData.ServoMotorData[motorIndex].DecTime;

		Machine.ServoMotorStop(motorIndex, decTime);
	}

	int panelIndex = thePanel->Tag;
	if (panelIndex == 0)
	{
		ServoMotorStopPanel1->Color = (TColor) 0x80FF80;
		ServoMotorStartPanel1->Color = clWhite;
	}
	else if (panelIndex == 1)
	{
		ServoMotorStopPanel2->Color = (TColor) 0x80FF80;
		ServoMotorStartPanel2->Color = clWhite;
	}
	else if (panelIndex == 2)
	{
		ServoMotorStopPanel3->Color = (TColor) 0x80FF80;
		ServoMotorStartPanel3->Color = clWhite;
	}
	else if (panelIndex == 3)
	{
		ServoMotorStopPanel4->Color = (TColor) 0x80FF80;
		ServoMotorStartPanel4->Color = clWhite;
	}
	else if (panelIndex == 4)
	{
		ServoMotorStopPanel5->Color = (TColor) 0x80FF80;
		ServoMotorStartPanel5->Color = clWhite;
	}	
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::SetTestModeButtonClick(TObject *Sender)
{
	// set free mode
	if (Machine.SetFreeMode())
	{
		TestWarningPanel->SendToBack();
        IsTestMode = true;
		TestClientPanel->Enabled = true;
		StatusTimer->Enabled = true;
    CloseButton->Visible = false;
    ShowMessageFA(MACHINETESTFORM_LABEL_CAPTION_43);
  }
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::SetInterlockModeButtonClick(TObject *Sender)
{
  if(MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
  {
    if(!PowerMeterDisconnect())
    {
      return;
    }
  }

	int machineMode = MACHINE_MODE_INTERLOCK;
	if (Machine.SetInterlockMode())
	{
//    	if (UserInfo.Grade != USER_GRADE_SYSTEM_ENGINEER)
		{
			TestWarningPanel->BringToFront();
			IsTestMode = false;
			TestClientPanel->Enabled = false;
			StatusTimer->Enabled = false;
      CloseButton->Visible = true;
      ShowMessageFA(MACHINETESTFORM_LABEL_CAPTION_44);
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::FormCreate(TObject *Sender)
{

//	if (UserInfo.Grade != USER_GRADE_SYSTEM_ENGINEER)
	{
		TestClientPanel->Enabled = false;
	}

	Disk1TargetSpeed = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 4;		// 25%
	Disk1SpeedEdit->Text = IntToStr(MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / Disk1TargetSpeed) + "%";
	Disk1SpeedRPMLabel->Caption = IntToStr((int)(SUCTION_DISK_100P_RPM * MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed / Disk1TargetSpeed)) + "RPM";
	Disk2TargetSpeed = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 4;		// 25%
	Disk2SpeedEdit->Text = IntToStr(MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / Disk2TargetSpeed) + "%";
	Disk2SpeedRPMLabel->Caption = IntToStr((int)(SUCTION_DISK_100P_RPM * MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed / Disk2TargetSpeed)) + "RPM";
	FeederInnerDiskTargetSpeed = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 4;		// 25%
	FeederInnerDiskSpeedEdit->Text = IntToStr(MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / FeederInnerDiskTargetSpeed) + "%";
	FeederOuterDisk1TargetSpeed = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 4;		// 25%
	FeederOuterDiskSpeedEdit1->Text = IntToStr(MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / FeederOuterDisk1TargetSpeed) + "%";
	if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
	{
		FeederOuterDisk2TargetSpeed = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 4;		// 25%
		FeederOuterDiskSpeedEdit2->Text = IntToStr(MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / FeederOuterDisk2TargetSpeed) + "%";	
	}
  if(!PCProgramOption.SensorOutputSettingOption)
  {
    GroupBox9->Visible = false;
  }

	if(0)//(MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
	{
		SensorARadioBtn->Enabled = false;
		SensorBRadioBtn->Enabled = false;
		SensorCRadioBtn->Checked = true;

		bool bError;
		int SD1ThreeDCameraSPBIndex, SD2ThreeDCameraSPBIndex;

		bError = false;
		SD1ThreeDCameraSPBIndex = CameraMapInfo[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].SPBIndex;
		if (!Comm_IsConnected(COMM_SPB + SD1ThreeDCameraSPBIndex))
		{
			bError = true;
			ShowMessage("#" + IntToStr(SD1ThreeDCameraSPBIndex + 1) + " IPB is not connected.");
		}
		else if (CameraMapInfo[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].CameraInspectPosition != CAMERA_POSITION_3D)
		{
			bError = true;
			ShowMessage("3D Camera(#" + IntToStr(SD1_3D_FRONT_FACE_CAMERA_INDEX) + ") mapping is incorrect.");
		}
		else if (CameraMapInfo[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].CameraInspectPosition == CAMERA_POSITION_DISCONNECT || SystemLinkCameraInfo[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1] == 0)
		{
			bError = true;
			ShowMessage("3D Camera(#" + IntToStr(SD1_3D_FRONT_FACE_CAMERA_INDEX) + ") mapping is incorrect.");
		}
		else
		{
      Set3DCamera_CaptureParameter(SD1_3D_FRONT_FACE_CAMERA_INDEX - 1,ThreeDCameraDefaultInformation[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].AnalogCameraGain,ThreeDCameraDefaultInformation[SD1_3D_FRONT_FACE_CAMERA_INDEX - 1].ExposureTime);
			EnabledThreeDLaserSensor(SD1_3D_FRONT_FACE_CAMERA_INDEX - 1, RANGER_3D_BASE_SHUTTER_SPEED, THREED_SENSOR_CALIB_MODE);
		}

		if (bError)
		{
			ShowMessage("Disk1 Sensor is not avalilable.");
		}

		bError = false;
		SD2ThreeDCameraSPBIndex = CameraMapInfo[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].SPBIndex;
		if (!Comm_IsConnected(COMM_SPB + SD2ThreeDCameraSPBIndex))
		{
			bError = true;
			ShowMessage("#" + IntToStr(SD2ThreeDCameraSPBIndex + 1) + " IPB is not connected.");
		}
		else if (CameraMapInfo[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].CameraInspectPosition != CAMERA_POSITION_3D)
		{
			bError = true;
			ShowMessage("3D Camera(#" + IntToStr(SD2_3D_FRONT_FACE_CAMERA_INDEX) + ") mapping is incorrect.");
		}
		else if (CameraMapInfo[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].CameraInspectPosition == CAMERA_POSITION_DISCONNECT || SystemLinkCameraInfo[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1] == 0)
		{
			bError = true;
			ShowMessage("3D Camera(#" + IntToStr(SD2_3D_FRONT_FACE_CAMERA_INDEX) + ") mapping is incorrect.");
		}
		else
		{
      Set3DCamera_CaptureParameter(SD2_3D_FRONT_FACE_CAMERA_INDEX - 1,ThreeDCameraDefaultInformation[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].AnalogCameraGain,ThreeDCameraDefaultInformation[SD2_3D_FRONT_FACE_CAMERA_INDEX - 1].ExposureTime);
			EnabledThreeDLaserSensor(SD2_3D_FRONT_FACE_CAMERA_INDEX - 1, RANGER_3D_BASE_SHUTTER_SPEED2, THREED_SENSOR_CALIB_MODE);
		}

		if (bError)
		{
			ShowMessage("Disk2 Sensor is not avalilable.");
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::FormClose(TObject *Sender,
      TCloseAction &Action)
{
  if(_RS232Serial != NULL)
  {
    SafeDeletePowerMeterResource();
    delete _RS232Serial;
  }

    if (IsTestMode)
    {
    	// set previous mode
		int machineMode = MachineSetupData.MachineMode;
		if (!Machine.SetMachineMode(machineMode))
		{
        	//ShowMessageW(HCBConnection.GetLastErrorMessage());
        }
        else
        {
    //    	if (UserInfo.Grade != USER_GRADE_SYSTEM_ENGINEER)
            {
    	        TestClientPanel->Enabled = false;
            }
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::DustBlowerOnPanel1Click(
	  TObject *Sender)
{
	Machine.DustBlowerOn(0);

	DustBlowerOnPanel1->Color = (TColor) 0x80FF80;
	DustBlowerOffPanel1->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::DustBlowerOffPanel1Click(
	  TObject *Sender)
{
	Machine.DustBlowerOff(0);

	DustBlowerOffPanel1->Color = (TColor) 0x80FF80;
	DustBlowerOnPanel1->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::DustBlowerOnPanel2Click(
      TObject *Sender)
{
	Machine.DustBlowerOn(1);

	DustBlowerOnPanel2->Color = (TColor) 0x80FF80;
	DustBlowerOffPanel2->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::DustBlowerOffPanel2Click(
	  TObject *Sender)
{
	Machine.DustBlowerOff(1);

	DustBlowerOffPanel2->Color = (TColor) 0x80FF80;
	DustBlowerOnPanel2->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::DustBlowerOnPanel3Click(
      TObject *Sender)
{
	Machine.DustBlowerOn(2);

	DustBlowerOnPanel3->Color = (TColor) 0x80FF80;
	DustBlowerOffPanel3->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::DustBlowerOffPanel3Click(
	  TObject *Sender)
{
	Machine.DustBlowerOff(2);

	DustBlowerOffPanel3->Color = (TColor) 0x80FF80;
	DustBlowerOnPanel3->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::DustBlowerOnPanel4Click(
	  TObject *Sender)
{
	Machine.DustBlowerOn(3);

	DustBlowerOnPanel4->Color = (TColor) 0x80FF80;
	DustBlowerOffPanel4->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::DustBlowerOffPanel4Click(
	  TObject *Sender)
{
	Machine.DustBlowerOff(3);

	DustBlowerOffPanel4->Color = (TColor) 0x80FF80;
	DustBlowerOnPanel4->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::AirBrushOnPanelClick(
	  TObject *Sender)
{
	Machine.DustBlowerOn(5);

	AirBrushOnPanel->Color = (TColor) 0x80FF80;
	AirBrushOffPanel->Color = clWhite;
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::AirBrushOffPanelClick(
	  TObject *Sender)
{
	Machine.DustBlowerOff(5);

	AirBrushOffPanel->Color = (TColor) 0x80FF80;
	AirBrushOnPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::SensorBlowerOnPanelClick(TObject *Sender)
{
	Machine.DustBlowerOn(4);

	SensorBlowerOnPanel->Color = (TColor) 0x80FF80;
	SensorBlowerOffPanel->Color = clWhite;
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::SensorBlowerOffPanelClick(
	  TObject *Sender)
{
	Machine.DustBlowerOff(4);

	SensorBlowerOffPanel->Color = (TColor) 0x80FF80;
	SensorBlowerOnPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::Disk1SpeedEditClick(TObject *Sender)
{
	TMotorSpeedSelectionForm *motorSpeedSelectionForm = new TMotorSpeedSelectionForm(this);
	motorSpeedSelectionForm->SetSpeed(MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed, Disk1TargetSpeed);
	if (motorSpeedSelectionForm->ShowModal() == mrOk)
	{
		Disk1TargetSpeed = motorSpeedSelectionForm->GetSelectedSpeed();
	}
	delete motorSpeedSelectionForm;
	Disk1SpeedEdit->Text = IntToStr(MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / Disk1TargetSpeed) + "%";
	Disk1SpeedRPMLabel->Caption = IntToStr((int)(SUCTION_DISK_100P_RPM * MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed / Disk1TargetSpeed)) + "RPM";
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::Disk2SpeedEditClick(TObject *Sender)
{
	TMotorSpeedSelectionForm *motorSpeedSelectionForm = new TMotorSpeedSelectionForm(this);
	motorSpeedSelectionForm->SetSpeed(MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed, Disk2TargetSpeed);
	if (motorSpeedSelectionForm->ShowModal() == mrOk)
	{
		Disk2TargetSpeed = motorSpeedSelectionForm->GetSelectedSpeed();
	}
	delete motorSpeedSelectionForm;
	Disk2SpeedEdit->Text = IntToStr(MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / Disk2TargetSpeed) + "%";
	Disk2SpeedRPMLabel->Caption = IntToStr((int)(SUCTION_DISK_100P_RPM * MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed / Disk2TargetSpeed)) + "RPM";
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::FeederInnerDiskSpeedEditClick(
	  TObject *Sender)
{
	TMotorSpeedSelectionForm *motorSpeedSelectionForm = new TMotorSpeedSelectionForm(this);
	motorSpeedSelectionForm->SetSpeed(MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed, FeederInnerDiskTargetSpeed);
	if (motorSpeedSelectionForm->ShowModal() == mrOk)
	{
		FeederInnerDiskTargetSpeed = motorSpeedSelectionForm->GetSelectedSpeed();
	}
	delete motorSpeedSelectionForm;
	FeederInnerDiskSpeedEdit->Text = IntToStr(MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / FeederInnerDiskTargetSpeed) + "%";
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::FeederOuterDiskSpeedEdit1Click(
	  TObject *Sender)
{
	TMotorSpeedSelectionForm *motorSpeedSelectionForm = new TMotorSpeedSelectionForm(this);
	motorSpeedSelectionForm->SetSpeed(MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed, FeederOuterDisk1TargetSpeed);
	if (motorSpeedSelectionForm->ShowModal() == mrOk)
	{
		FeederOuterDisk1TargetSpeed = motorSpeedSelectionForm->GetSelectedSpeed();
	}
	delete motorSpeedSelectionForm;
	FeederOuterDiskSpeedEdit1->Text = IntToStr(MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / FeederOuterDisk1TargetSpeed) + "%";
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::FeederOuterDiskSpeedEdit2Click(
      TObject *Sender)
{
	TMotorSpeedSelectionForm *motorSpeedSelectionForm = new TMotorSpeedSelectionForm(this);
	motorSpeedSelectionForm->SetSpeed(MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed, FeederOuterDisk2TargetSpeed);
	if (motorSpeedSelectionForm->ShowModal() == mrOk)
	{
		FeederOuterDisk2TargetSpeed = motorSpeedSelectionForm->GetSelectedSpeed();
	}
	delete motorSpeedSelectionForm;
	FeederOuterDiskSpeedEdit2->Text = IntToStr(MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / FeederOuterDisk2TargetSpeed) + "%";
}
//---------------------------------------------------------------------------


void __fastcall TMachineTestForm::StatusTimerTimer(TObject *Sender)
{
	Machine.ReadPortStatus();

	if (Machine.PortStatus.IPStatus[IP_POWER_ON])
	{
		MainPowerOnPanel->Color = (TColor) 0xFF8080;
		MainPowerOnPanel->Font->Color = clWhite;
		MainPowerOffPanel->Color = clWhite;
		MainPowerOffPanel->Font->Color = clBlack;
	}
	else
	{
		MainPowerOnPanel->Color = clWhite;
		MainPowerOnPanel->Font->Color = clBlack;
		MainPowerOffPanel->Color = (TColor) 0xFF8080;
		MainPowerOffPanel->Font->Color = clWhite;
	}
	if (Machine.PortStatus.IPStatus[IP_EMER_ON])
	{
		EmergencyOnPanel->Color = (TColor) 0xFF8080;
		EmergencyOnPanel->Font->Color = clWhite;
		EmergencyOffPanel->Color = clWhite;
		EmergencyOffPanel->Font->Color = clBlack;
	}
	else
	{
		EmergencyOnPanel->Color = clWhite;
		EmergencyOnPanel->Font->Color = clBlack;
		EmergencyOffPanel->Color = (TColor) 0xFF8080;
		EmergencyOffPanel->Font->Color = clWhite;
	}
/*
	if (Machine.Status.PortStatus.IPStatus[IP_RB_1_OL])
	{
		InverterTripOnPanel1->Color = (TColor) 0xFF8080;
		InverterTripOnPanel1->Font->Color = clWhite;
		InverterTripOffPanel1->Color = clWhite;
		InverterTripOffPanel1->Font->Color = clBlack;
	}
	else
	{
		InverterTripOnPanel1->Color = clWhite;
		InverterTripOnPanel1->Font->Color = clBlack;
		InverterTripOffPanel1->Color = (TColor) 0xFF8080;
		InverterTripOffPanel1->Font->Color = clWhite;
	}
	if (Machine.Status.PortStatus.IPStatus[IP_RB_2_OL])
	{
		InverterTripOnPanel2->Color = (TColor) 0xFF8080;
		InverterTripOnPanel2->Font->Color = clWhite;
		InverterTripOffPanel2->Color = clWhite;
		InverterTripOffPanel2->Font->Color = clBlack;
	}
	else
	{
		InverterTripOnPanel2->Color = clWhite;
		InverterTripOnPanel2->Font->Color = clBlack;
		InverterTripOffPanel2->Color = (TColor) 0xFF8080;
		InverterTripOffPanel2->Font->Color = clWhite;
	}
*/	
	if (Machine.PortStatus.IPStatus[IP_RB_3_OL])
	{
		RB3OLOnPanel->Color = (TColor) 0xFF8080;
		RB3OLOnPanel->Font->Color = clWhite;
		RB3OLOffPanel->Color = clWhite;
		RB3OLOffPanel->Font->Color = clBlack;
	}
	else
	{
		RB3OLOnPanel->Color = clWhite;
		RB3OLOnPanel->Font->Color = clBlack;
		RB3OLOffPanel->Color = (TColor) 0xFF8080;
		RB3OLOffPanel->Font->Color = clWhite;
	}

	if (Machine.PortStatus.IPStatus[IP_BF_SENSOR_1])
	{
		BFSensor1OnPanel->Color = (TColor) 0xFF8080;
		BFSensor1OnPanel->Font->Color = clWhite;
		BFSensor1OffPanel->Color = clWhite;
		BFSensor1OffPanel->Font->Color = clBlack;
	}
	else
	{
		BFSensor1OnPanel->Color = clWhite;
		BFSensor1OnPanel->Font->Color = clBlack;
		BFSensor1OffPanel->Color = (TColor) 0xFF8080;
		BFSensor1OffPanel->Font->Color = clWhite;
	}
	if (Machine.PortStatus.IPStatus[IP_BF_SENSOR_2])
	{
		BFSensor2OnPanel->Color = (TColor) 0xFF8080;
		BFSensor2OnPanel->Font->Color = clWhite;
		BFSensor2OffPanel->Color = clWhite;
		BFSensor2OffPanel->Font->Color = clBlack;
	}
	else
	{
		BFSensor2OnPanel->Color = clWhite;
		BFSensor2OnPanel->Font->Color = clBlack;
		BFSensor2OffPanel->Color = (TColor) 0xFF8080;
		BFSensor2OffPanel->Font->Color = clWhite;
	}

	if (MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
	{
//		Machine.ReadThreeDSensorStatus();
		if (Machine.PortStatus.IPStatus[IP_POWERMETER_SENSOR])
		{
			PowerMeterSensorOnPanel->Color = (TColor) 0xFF8080;
			PowerMeterSensorOnPanel->Font->Color = clWhite;
			PowerMeterSensorOffPanel->Color = clWhite;
			PowerMeterSensorOffPanel->Font->Color = clBlack;
		}
		else
		{
			PowerMeterSensorOnPanel->Color = clWhite;
			PowerMeterSensorOnPanel->Font->Color = clBlack;
			PowerMeterSensorOffPanel->Color = (TColor) 0xFF8080;;
			PowerMeterSensorOffPanel->Font->Color = clWhite;
		}

		if (Machine.PortStatus.IPStatus[IP_LASER_SHUTTER_SENSOR])
		{
			LaserShutterSensorOnPanel->Color = (TColor) 0xFF8080;
			LaserShutterSensorOnPanel->Font->Color = clWhite;
			LaserShutterSensorOnPanel->Color = clWhite;
			LaserShutterSensorOnPanel->Font->Color = clBlack;
		}
		else
		{
			LaserShutterSensorOffPanel->Color = clWhite;
			LaserShutterSensorOffPanel->Font->Color = clBlack;
			LaserShutterSensorOffPanel->Color = (TColor) 0xFF8080;;
			LaserShutterSensorOffPanel->Font->Color = clWhite;
		}
		int SensorIndex;

		if(SensorARadioBtn->Checked)
			SensorIndex = IP_DISK_1_CAPTURE_SENSOR;
		else if(SensorBRadioBtn->Checked)
			SensorIndex = IP_DISK_1_CAPTURE_SENSOR_B;
		else
			SensorIndex = IP_DISK_1_CAPTURE_SENSOR;

		if (Machine.PortStatus.IPStatus[SensorIndex])
		{
			VDSensor1OnPanel->Color = (TColor) 0xFF8080;
			VDSensor1OnPanel->Font->Color = clWhite;
			VDSensor1OffPanel->Color = clWhite;
			VDSensor1OffPanel->Font->Color = clBlack;
		}
		else
		{
			VDSensor1OnPanel->Color = clWhite;
			VDSensor1OnPanel->Font->Color = clBlack;
			VDSensor1OffPanel->Color = (TColor) 0xFF8080;
			VDSensor1OffPanel->Font->Color = clWhite;
		}

		if(SensorARadioBtn->Checked)
			SensorIndex = IP_DISK_2_CAPTURE_SENSOR;
		else if(SensorBRadioBtn->Checked)
			SensorIndex = IP_DISK_2_CAPTURE_SENSOR_B;
		else
			SensorIndex = IP_DISK_2_CAPTURE_SENSOR;
		                          
		if (Machine.PortStatus.IPStatus[SensorIndex])
		{
			VDSensor2OnPanel->Color = (TColor) 0xFF8080;
			VDSensor2OnPanel->Font->Color = clWhite;
			VDSensor2OffPanel->Color = clWhite;
			VDSensor2OffPanel->Font->Color = clBlack;
		}
		else
		{
			VDSensor2OnPanel->Color = clWhite;
			VDSensor2OnPanel->Font->Color = clBlack;
			VDSensor2OffPanel->Color = (TColor) 0xFF8080;
			VDSensor2OffPanel->Font->Color = clWhite;
		}		
/*
		if (Machine.ThreeDSensorStatus[0])
		{
			VDSensor1OnPanel->Color = (TColor)0xFF8080;
			VDSensor1OnPanel->Font->Color = clWhite;
			VDSensor1OffPanel->Color = clWhite;
			VDSensor1OffPanel->Font->Color = clBlack;
		}
		else
		{
			VDSensor1OnPanel->Color = clWhite;
			VDSensor1OnPanel->Font->Color = clBlack;
			VDSensor1OffPanel->Color = (TColor)0xFF8080;
			VDSensor1OffPanel->Font->Color = clWhite;
		}

		if (Machine.ThreeDSensorStatus[1])
		{
			VDSensor2OnPanel->Color = (TColor)0xFF8080;
			VDSensor2OnPanel->Font->Color = clWhite;
			VDSensor2OffPanel->Color = clWhite;
			VDSensor2OffPanel->Font->Color = clBlack;
		}
		else
		{
			VDSensor2OnPanel->Color = clWhite;
			VDSensor2OnPanel->Font->Color = clBlack;
			VDSensor2OffPanel->Color = (TColor)0xFF8080;
			VDSensor2OffPanel->Font->Color = clWhite;
		}
*/		
	}
	else
	{
		int SensorIndex;

		if(SensorARadioBtn->Checked)
			SensorIndex = IP_DISK_1_CAPTURE_SENSOR;
		else if(SensorBRadioBtn->Checked)
			SensorIndex = IP_DISK_1_CAPTURE_SENSOR_B;
		else
			SensorIndex = IP_DISK_1_CAPTURE_SENSOR;

		if (Machine.PortStatus.IPStatus[SensorIndex])
		{
			VDSensor1OnPanel->Color = (TColor) 0xFF8080;
			VDSensor1OnPanel->Font->Color = clWhite;
			VDSensor1OffPanel->Color = clWhite;
			VDSensor1OffPanel->Font->Color = clBlack;
		}
		else
		{
			VDSensor1OnPanel->Color = clWhite;
			VDSensor1OnPanel->Font->Color = clBlack;
			VDSensor1OffPanel->Color = (TColor) 0xFF8080;
			VDSensor1OffPanel->Font->Color = clWhite;
		}

		if(SensorARadioBtn->Checked)
			SensorIndex = IP_DISK_2_CAPTURE_SENSOR;
		else if(SensorBRadioBtn->Checked)
			SensorIndex = IP_DISK_2_CAPTURE_SENSOR_B;
		else
			SensorIndex = IP_DISK_2_CAPTURE_SENSOR;
		                          
		if (Machine.PortStatus.IPStatus[SensorIndex])
		{
			VDSensor2OnPanel->Color = (TColor) 0xFF8080;
			VDSensor2OnPanel->Font->Color = clWhite;
			VDSensor2OffPanel->Color = clWhite;
			VDSensor2OffPanel->Font->Color = clBlack;
		}
		else
		{
			VDSensor2OnPanel->Color = clWhite;
			VDSensor2OnPanel->Font->Color = clBlack;
			VDSensor2OffPanel->Color = (TColor) 0xFF8080;
			VDSensor2OffPanel->Font->Color = clWhite;
		}
	}

	if (Machine.PortStatus.IPStatus[IP_COUNTER_SENSOR_ON])
	{
		CounterSensorOnPanel->Color = (TColor) 0xFF8080;
		CounterSensorOnPanel->Font->Color = clWhite;
		CounterSensorOffPanel->Color = clWhite;
		CounterSensorOffPanel->Font->Color = clBlack;
	}
	else
	{
		CounterSensorOnPanel->Color = clWhite;
		CounterSensorOnPanel->Font->Color = clBlack;
		CounterSensorOffPanel->Color = (TColor) 0xFF8080;
		CounterSensorOffPanel->Font->Color = clWhite;
	}
  if (Machine.PortStatus.IPStatus[IP_EMISSION_SENSOR])
	{
		EmissionSensorOnPanel->Color = (TColor) 0xFF8080;
		EmissionSensorOnPanel->Font->Color = clWhite;
		EmissionSensorOffPanel->Color = clWhite;
		EmissionSensorOffPanel->Font->Color = clBlack;
	}
	else
	{
		EmissionSensorOnPanel->Color = clWhite;
		EmissionSensorOnPanel->Font->Color = clBlack;
		EmissionSensorOffPanel->Color = (TColor) 0xFF8080;
		EmissionSensorOffPanel->Font->Color = clWhite;
	}
	if (Machine.PortStatus.IPStatus[IP_MONITOR_SWITCH_ON])
	{
		MonitorSWOnPanel->Color = (TColor) 0xFF8080;
		MonitorSWOnPanel->Font->Color = clWhite;
		MonitorSWOffPanel->Color = clWhite;
		MonitorSWOffPanel->Font->Color = clBlack;
	}
	else
	{
		MonitorSWOnPanel->Color = clWhite;
		MonitorSWOnPanel->Font->Color = clBlack;
		MonitorSWOffPanel->Color = (TColor) 0xFF8080;
		MonitorSWOffPanel->Font->Color = clWhite;
	}

	if (Machine.PortStatus.IPStatus[IP_INTERLOCK_1])
	{
		FrontDoorSensorOnPanel->Color = (TColor) 0xFF8080;
		FrontDoorSensorOnPanel->Font->Color = clWhite;
		FrontDoorSensorOffPanel->Color = clWhite;
		FrontDoorSensorOffPanel->Font->Color = clBlack;
	}
	else
	{
		FrontDoorSensorOnPanel->Color = clWhite;
		FrontDoorSensorOnPanel->Font->Color = clBlack;
		FrontDoorSensorOffPanel->Color = (TColor) 0xFF8080;
		FrontDoorSensorOffPanel->Font->Color = clWhite;
	}

  if (Machine.PortStatus.IPStatus[IP_INTERLOCK_2])
	{
		LeftDoorSenserOnPanel->Color = (TColor) 0xFF8080;
		LeftDoorSenserOnPanel->Font->Color = clWhite;
		LeftDoorSenserOffPanel->Color = clWhite;
		LeftDoorSenserOffPanel->Font->Color = clBlack;
	}
	else
	{
		LeftDoorSenserOnPanel->Color = clWhite;
		LeftDoorSenserOnPanel->Font->Color = clBlack;
		LeftDoorSenserOffPanel->Color = (TColor) 0xFF8080;
		LeftDoorSenserOffPanel->Font->Color = clWhite;
	}

	if (Machine.PortStatus.IPStatus[IP_PC_ON])
	{
		PCOnPanel->Color = (TColor) 0xFF8080;
		PCOnPanel->Font->Color = clWhite;
		PCOffPanel->Color = clWhite;
		PCOffPanel->Font->Color = clBlack;
	}
	else
	{
		PCOnPanel->Color = clWhite;
		PCOnPanel->Font->Color = clBlack;
		PCOffPanel->Color = (TColor) 0xFF8080;
		PCOffPanel->Font->Color = clWhite;
	}

  if(Machine.PortStatus.IPStatus[IP_VB_SENSOR])
  {
    HopperOnpanel->Color = (TColor) 0xFF8080;
    HopperOnpanel->Font->Color = clWhite;
    HopperOffpanel->Color = clWhite;
    HopperOffpanel->Font->Color = clBlack;
  }
  else
  {
    HopperOnpanel->Color = clWhite;
    HopperOnpanel->Font->Color = clBlack;
    HopperOffpanel->Color = (TColor) 0xFF8080;
    HopperOffpanel->Font->Color = clWhite;
  }

	if(Machine.PortStatus.IPStatus[IP_MISEJECT_CHECK_SENEOR_B] && !Machine.PortStatus.IPStatus[IP_MISEJECT_CHECK_SENEOR_A])
	{
		MisejectSensorOpenPanel->Color = (TColor) 0xFF8080;
		MisejectSensorOpenPanel->Font->Color = clWhite;
    MisejectSensorJamPanel->Color = clWhite;
		MisejectSensorJamPanel->Font->Color = clBlack;
		MisejectSensorClosePanel->Color = clWhite;
		MisejectSensorClosePanel->Font->Color = clBlack;
	}
  else if (Machine.PortStatus.IPStatus[IP_MISEJECT_CHECK_SENEOR_A] && !Machine.PortStatus.IPStatus[IP_MISEJECT_CHECK_SENEOR_B])
  {
    MisejectSensorClosePanel->Color = (TColor) 0xFF8080;
		MisejectSensorClosePanel->Font->Color = clWhite;
    MisejectSensorOpenPanel->Color = clWhite;
		MisejectSensorOpenPanel->Font->Color = clBlack;
		MisejectSensorJamPanel->Color = clWhite;
		MisejectSensorJamPanel->Font->Color = clBlack;
	}
  else if(!Machine.PortStatus.IPStatus[IP_MISEJECT_CHECK_SENEOR_B] && !Machine.PortStatus.IPStatus[IP_MISEJECT_CHECK_SENEOR_A])
  {

                MisejectSensorJamPanel->Color = (TColor) 0xFF8080;
		MisejectSensorJamPanel->Font->Color = clWhite;
    MisejectSensorClosePanel->Color = clWhite;
		MisejectSensorClosePanel->Font->Color = clBlack;
		MisejectSensorOpenPanel->Color = clWhite;
		MisejectSensorOpenPanel->Font->Color = clBlack;
  }


//	Motor1ShortTermRPMLabel->Caption = IntToStr(Machine.Status.Motor1ShortTermRPM);
//	Motor1MidTermRPMLabel->Caption = IntToStr((int)(Machine.GetServoMotorRPM(SD1_MOTOR_INDEX) + 0.5)) + "RPM";
	Motor1MidTermRPMLabel->Caption = IntToStr((int)(Machine.GetServoMotorRPM(SD1_MOTOR_INDEX))) + "RPM";
//	Motor1MidTermRPMLabel->Caption = Motor1MidTermRPMLabel->Caption.sprintf("%.S", FloatToStrF( Machine.Status.Motor1MidTermRPM, ffFixed, 10, 3));
//	Motor2ShortTermRPMLabel->Caption = IntToStr(Machine.Status.Motor2ShortTermRPM);
//	Motor2MidTermRPMLabel->Caption = IntToStr((int)(Machine.GetServoMotorRPM(SD2_MOTOR_INDEX) + 0.5)) + "RPM";
	Motor2MidTermRPMLabel->Caption = IntToStr((int)(Machine.GetServoMotorRPM(SD2_MOTOR_INDEX))) + "RPM";
//	Motor2MidTermRPMLabel->Caption = Motor2MidTermRPMLabel->Caption.sprintf("%.S", FloatToStrF( Machine.Status.Motor2MidTermRPM, ffFixed, 10, 3));		
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::LeftLight1OnPanelClick(
      TObject *Sender)
{
	int mode = 0;//2;		// blink mode
	int onInterval = 20;
	int offInterval = 180;
	Machine.IlluminatorTestOn(0, mode, onInterval, offInterval);
	Machine.IlluminatorTestOn(1, mode, onInterval, offInterval);

	LeftLight1OnPanel->Color = (TColor) 0x80FF80;
	LeftLight1OffPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::LeftLight1OffPanelClick(
	  TObject *Sender)
{
	Machine.IlluminatorTestOff(0);
	Machine.IlluminatorTestOff(1);

	LeftLight1OffPanel->Color = (TColor) 0x80FF80;
	LeftLight1OnPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::LeftLight2OnPanelClick(
	  TObject *Sender)
{
	int mode = 0;//2;		// blink mode
	int onInterval = 20;
	int offInterval = 180;
	Machine.IlluminatorTestOn(2, mode, onInterval, offInterval);
	Machine.IlluminatorTestOn(3, mode, onInterval, offInterval);
    Machine.IlluminatorTestOn(4, mode, onInterval, offInterval);

	LeftLight2OnPanel->Color = (TColor) 0x80FF80;
	LeftLight2OffPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::LeftLight2OffPanelClick(
	  TObject *Sender)
{
	Machine.IlluminatorTestOff(2);
	Machine.IlluminatorTestOff(3);
    Machine.IlluminatorTestOff(4);

	LeftLight2OffPanel->Color = (TColor) 0x80FF80;
	LeftLight2OnPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::RightLight1OnPanelClick(
	  TObject *Sender)
{
	int mode = 0;//2;		// blink mode
	int onInterval = 20;
	int offInterval = 180;
	Machine.IlluminatorTestOn(6, mode, onInterval, offInterval);
	Machine.IlluminatorTestOn(7, mode, onInterval, offInterval);

	RightLight1OnPanel->Color = (TColor) 0x80FF80;
	RightLight1OffPanel->Color = clWhite;
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::RightLight1OffPanelClick(
	  TObject *Sender)
{
	Machine.IlluminatorTestOff(6);
	Machine.IlluminatorTestOff(7);

	RightLight1OffPanel->Color = (TColor) 0x80FF80;
	RightLight1OnPanel->Color = clWhite;
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::RightLight2OnPanelClick(
	  TObject *Sender)
{
	int mode = 0;//2;		// blink mode
	int onInterval = 20;
	int offInterval = 180;
	Machine.IlluminatorTestOn(8, mode, onInterval, offInterval);
	Machine.IlluminatorTestOn(9, mode, onInterval, offInterval);
    Machine.IlluminatorTestOn(10, mode, onInterval, offInterval);

	RightLight2OnPanel->Color = (TColor) 0x80FF80;
	RightLight2OffPanel->Color = clWhite;
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::RightLight2OffPanelClick(
	  TObject *Sender)
{
	Machine.IlluminatorTestOff(8);
	Machine.IlluminatorTestOff(9);
    Machine.IlluminatorTestOff(10);

	RightLight2OffPanel->Color = (TColor) 0x80FF80;
	RightLight2OnPanel->Color = clWhite;
}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::OnUserChange(void)
{
  if(ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_MAINFORM_DEVICE_CONTROL])
	{
		CloseButton->Click();
	}
}
//---------------------------------------------------------------------------
/*
*  SELMA 200 ߰  ۵ ׽Ʈ ̺Ʈ Լ 
*/
void __fastcall TMachineTestForm::TestOnPanelClick(TObject *Sender)
{
 Machine.EjectorOn(2);

 TestOnPanel->Color = (TColor) 0x80FF80;
 TestOffPanel->Color = clWhite;
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::TestOffPanelClick(TObject *Sender)
{
 Machine.EjectorOff(2);

 TestOffPanel->Color = (TColor) 0x80FF80;
 TestOnPanel->Color = clWhite;
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::Buzzer2OnPanelClick(TObject *Sender)
{
	Machine.Buzzer2On();

	Buzzer2OnPanel->Color = (TColor) 0x80FF80;
	Buzzer2OffPanel->Color = clWhite;
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::Buzzer2OffPanelClick(TObject *Sender)
{
	Machine.Buzzer2Off();

	Buzzer2OffPanel->Color = (TColor) 0x80FF80;
	Buzzer2OnPanel->Color = clWhite;
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::Buzzer3OnPanelClick(TObject *Sender)
{
	Machine.Buzzer3On();

	Buzzer3OnPanel->Color = (TColor) 0x80FF80;
	Buzzer3OffPanel->Color = clWhite;
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::Buzzer3OffPanelClick(TObject *Sender)
{
	Machine.Buzzer3Off();

	Buzzer3OffPanel->Color = (TColor) 0x80FF80;
	Buzzer3OnPanel->Color = clWhite;
}
//---------------------------------------------------------------------------


void __fastcall TMachineTestForm::InterLockOpenPanelClick(TObject *Sender)
{
  Machine.InterLockOn();

	InterLockOpenPanel->Color = (TColor) 0x80FF80;
	InterLockClosePanel->Color = clWhite;
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::InterLockClosePanelClick(TObject *Sender)
{
  Machine.InterLockOff();

	InterLockClosePanel->Color = (TColor) 0x80FF80;
	InterLockOpenPanel->Color = clWhite;
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::Tnt2DisPanel1Click(TObject *Sender)
{
	Machine.OP2Distributor1On();

    Tnt2DisPanel1->Color = (TColor) 0x80FF80;
	Tnt2DisPanel2->Color = clWhite;	
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::Tnt2DisPanel2Click(TObject *Sender)
{
	Machine.OP2Distributor2On();

    Tnt2DisPanel2->Color = (TColor) 0x80FF80;
	Tnt2DisPanel1->Color = clWhite;
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::CloseButtonClick(TObject *Sender)
{
  DisabledThreeDLaserSensor(SD1_3D_FRONT_FACE_CAMERA_INDEX - 1);
  DisabledThreeDLaserSensor(SD2_3D_FRONT_FACE_CAMERA_INDEX - 1);
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::ConnectionbtnClick(TObject *Sender)
{
  if(ComPortList.Count <= 0) return;

  Label38->Visible = true;
  Label38->Caption = "Connecting ....";
  Label38->Refresh();
  try
  {
    for(int Portindex = 0; Portindex < ComPortList.Count; ++Portindex)
    {
      if(_RS232Serial->OpenPort(ComPortList.Name[Portindex]))
      {
         bool te = _RS232Serial->ConfigurePort(CBR_38400,8,FALSE,NOPARITY,ONESTOPBIT);
        bool aa = _RS232Serial->SetCommunicationTimeouts(0,10,0,50,0);
        int FindPowerMeter = FindPowerMeterPort();
        if(FindPowerMeter == 1)
        {
          PowerMeterDisconnectCheck = false;
          _RS232Serial->State = 1;
          ThreadAbort = false;
          Connectionbtn->Enabled = false;
          Disconnectbtn->Enabled = true;
          Machine.LaserPowerMeterOn();
          PowerMeterOnbtn->Enabled = false;
          PowerMeterOffbtn->Enabled = false;
          Label38->Caption = "Connect ["+ComPortList.Name[Portindex]+"]";
          break;
        }
      }

    }
    if(_RS232Serial->State == 0)
    {
      Label38->Caption = "Connect Fail";
      PowerMeterDisconnectCheck = true;
      RefreshComNameList();
    }
    else
    {
       hThreadTT = (HANDLE)_beginthreadex(NULL,0,PowerMeterSetAndCommThreadFunction,NULL,0,(unsigned*)&dwThreadID);
       PowerMeterTimer->Enabled = true;
    }
  }
  catch(...)
  {
    Label38->Caption = "Connect Fail";
    PowerMeterDisconnectCheck = true;
    RefreshComNameList();
  }



}
//---------------------------------------------------------------------------
void __fastcall TMachineTestForm::DisconnectbtnClick(TObject *Sender)
{
  if(PowerMeterDisconnect())
  {
    Label38->Visible = false;
    TntLabel13->Caption = "0";
    PowerMeterOnbtn->Enabled = true;
    PowerMeterOffbtn->Enabled = true;
  }
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::PowerMeterTimerTimer(TObject *Sender)
{

  String Temp = Value;
  int StartPos = -1;
  int EndPos = -1;
  int PowerMeterdotPos = -1;
  bool AvailableConvert = true;

  if(Temp != NULL && Temp.c_str()[0] != '?')
  {
    if(Temp != "0")
    {
      if(Temp.Length() >=4)
      {
        for(int i = 0; i < Temp.Length(); ++i)
        {
          if(Temp.c_str()[i] == 0x2A) //"*" Start Pos
          {
            StartPos = i;
          }
          if(Temp.c_str()[i] == 0x45) //"E" End Pos
          {
            PowerMeterdotPos = (int)(Temp.c_str()[i+1]-'0');
            EndPos = i;
          }
        }

        if(StartPos >= 0 && EndPos >=0)
        {
          // *0.001E  *-0.001E
          // 0+2 6  -1      0+2 7  -1
          // *0.605E1 = 6.05
          // *0.605E2
          EndPos-= StartPos;
          String SplitValueStr = Temp.SubString(StartPos+2,EndPos-1);

          try
          {
            if(PowerMeterdotPos > 0)
            {
              double Revalue  = StrToFloat(SplitValueStr)* (10.0*PowerMeterdotPos);
              LastLaserPower = Revalue;
              TntLabel13->Caption =FloatToStr(Revalue);
            }
            else
            {
              LastLaserPower = StrToFloat(SplitValueStr);
              TntLabel13->Caption =SplitValueStr;
            }

          }
          catch(...)
          {
          }
        }
      }
    }
    else
    {
      TntLabel13->Caption = "0";
      LastLaserPower = 0;
    }
  }



  if(PowerMeterDisconnectCheck)
  {
    Label38->Visible = true;
  }
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::sLaseronBtnClick(TObject *Sender)
{
  	AnsiString filepath = "D:\\Project\\sLaser\\sLaser.exe";
	AnsiString PgmName = "NFA sLaser";
	if(IsExistProcess("sLaser.exe"))
	{
		HWND hWnd = FindWindowA(NULL, PgmName.c_str());
		if(sLaseronBtn->Caption.AnsiCompare("SLaser ON") == 0)
		{
			ShowWindowAsync(hWnd, SW_SHOWNORMAL);
			SetActiveWindow (hWnd);
			SetForegroundWindow(hWnd);
			sLaseronBtn->Caption = "SLaser OFF";
		}
		else
		{
			ShowWindow (hWnd, SW_HIDE);
			sLaseronBtn->Caption = "SLaser ON";
		}
	}
	else
	{
		if(sLaseronBtn->Caption.AnsiCompare("SLaser ON") == 0)
		{
			ShellExecuteA(NULL, "open", filepath.c_str(), NULL, "D:\\Project\\sLaser", SW_SHOW);
			sLaseronBtn->Caption = "SLaser OFF";
		}
		else
		{
			sLaseronBtn->Caption = "SLaser ON";
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::PowerMeterOnbtnClick(TObject *Sender)
{
  Machine.LaserPowerMeterOn();
}
//---------------------------------------------------------------------------

void __fastcall TMachineTestForm::PowerMeterOffbtnClick(TObject *Sender)
{
  //     üũ ʿغ
   if(LastLaserPower > 0.015)
  {
    ShowMessageFA("  Դϴ.     õ Ͻʽÿ.");
  }
  else
  {
    Machine.LaserPowerMeterOff();
  }
}
//---------------------------------------------------------------------------

