
#include <vcl.h>
#pragma hdrstop

#include "Message_Form.h"
#include "MultiLanguage.h"
#include "Environment.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntComCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"

#define MAX_BUTTON_COUNT		4
#define TEXT_BLANK				50
#define MIN_FORM_SIZE			360
#define BUTTON_WIDTH			92
#define BUTTON_GAP				8

TMessageForm *MessageForm;
//---------------------------------------------------------------------------
__fastcall TMessageForm::TMessageForm(TComponent* Owner)
	: TTntForm(Owner)
{
	if (DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
		ComponentSetFontName(this, "SimSun");
	else if (DefaultLCID == 1041)
	{
		ComponentSetFontName(this, "Meiryo UI");
		this->Caption = "ACROCIA";
	}
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }
	this->Caption = Application->Title;

	CancelBitBtn->Caption = MESSAGEFORM_BITBTN_CAPTION_02;
	OKBitBtn->Caption = MESSAGEFORM_BITBTN_CAPTION_03;
	MessageLabel->Caption = MESSAGEFORM_LABEL_CAPTION_01;
}
//---------------------------------------------------------------------------
int __fastcall TMessageForm::MessageDlg(const WideString Msg, TMsgDlgType DlgType, TMsgDlgButtons Buttons)
{
	int buttonCount = 0;
	TTntBitBtn *buttonComponents[MAX_BUTTON_COUNT];

	MessageLabel->Caption = Msg;
	OKBitBtn->Visible = false;
	CancelBitBtn->Visible = false;

	if (Buttons.Contains(mbOK))
	{
		buttonComponents[buttonCount] = OKBitBtn;
		buttonCount++;
	}
	if (Buttons.Contains(mbCancel))
	{
		buttonComponents[buttonCount] = CancelBitBtn;
		buttonCount++;
	}

	int formWidth = MessageLabel->Canvas->TextWidth(Msg) + 2 * TEXT_BLANK;
	if (formWidth < MIN_FORM_SIZE) formWidth = MIN_FORM_SIZE;

  int messageWidth = MessageLabel->Width;
  int messageHeight = MessageLabel->Height;

  MessageLabel->Top = Panel1->Height / 2 - messageHeight / 2;

	this->Width = min(1000, formWidth);

  if(buttonCount)
  {
    int WidthCenter = this->Width / 2;

    if(buttonCount == 1)
    {
      buttonComponents[0]->Left = WidthCenter - buttonComponents[0]->Width / 2;
      buttonComponents[0]->Visible = true;
    }
    else // 2
    {
      buttonComponents[0]->Left = WidthCenter - (buttonComponents[0]->Width + 10);
      buttonComponents[0]->Visible = true;

      buttonComponents[1]->Left = WidthCenter + 10;
      buttonComponents[1]->Visible = true;
    }
  }

	this->Position = poScreenCenter;
	return this->ShowModal();
}
//---------------------------------------------------------------------------

int __fastcall MessageDlgFA(const WideString Msg, TMsgDlgType DlgType, TMsgDlgButtons Buttons)
{
	int result;
	TMessageForm *messageForm = new TMessageForm(Application);
	result = messageForm->MessageDlg(Msg, DlgType, Buttons);
	delete messageForm;
	return result;
}
//---------------------------------------------------------------------------
void __fastcall ShowMessageFA(const WideString Msg)
{
	TMessageForm *messageForm = new TMessageForm(Application);
	messageForm->MessageDlg(Msg, mtInformation, TMsgDlgButtons() << mbOK);
	delete messageForm;
}
//---------------------------------------------------------------------------
void ShowMessageW(const WideString Msg)
{
	WideString WMainFormCaption = WideString(Application->MainForm->Caption);
  Windows:MessageBoxW(Application->Handle, PWCHAR(Msg), PWCHAR(WMainFormCaption), MB_OK | MB_SYSTEMMODAL);
}
//---------------------------------------------------------------------------


