//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#include <inifiles.hpp>
#pragma hdrstop

#include "MotorSetting_Form.h"
#include "Environment.h"
#include "Keyboard_Form.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TMotorSettingForm *MotorSettingForm;

#define MOTOR_SPEED_STEP_COUNT			10
int ResTable[16] = {1, 2, 4, 5, 8, 10, 16, 20, 25, 40, 50, 80, 100, 125, 200, 250};
//---------------------------------------------------------------------------
__fastcall TMotorSettingForm::TMotorSettingForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  GetDefaultString();
}
//---------------------------------------------------------------------------
void __fastcall TMotorSettingForm::GetDefaultString()
{
  GroupBox2->Caption = MOTORSETTINGFORM_GROUPBOX_CAPTION_01;
  GroupBox1->Caption = MOTORSETTINGFORM_GROUPBOX_CAPTION_02;
  GroupBox3->Caption = MOTORSETTINGFORM_GROUPBOX_CAPTION_03;
  GroupBox4->Caption = MOTORSETTINGFORM_GROUPBOX_CAPTION_04;
  GroupBox5->Caption = MOTORSETTINGFORM_GROUPBOX_CAPTION_05;
  GroupBox6->Caption = MOTORSETTINGFORM_GROUPBOX_CAPTION_06;
  Label6->Caption = MOTORSETTINGFORM_LABEL_CAPTION_01;
  Label1->Caption = MOTORSETTINGFORM_LABEL_CAPTION_01;
  Label10->Caption = MOTORSETTINGFORM_LABEL_CAPTION_01;
  Label17->Caption = MOTORSETTINGFORM_LABEL_CAPTION_01;
  Label20->Caption = MOTORSETTINGFORM_LABEL_CAPTION_01;
  Label28->Caption = MOTORSETTINGFORM_LABEL_CAPTION_01;
  Label35->Caption = MOTORSETTINGFORM_LABEL_CAPTION_01;
  Label42->Caption = MOTORSETTINGFORM_LABEL_CAPTION_01;
  Label49->Caption = MOTORSETTINGFORM_LABEL_CAPTION_01;
  Label8->Caption = MOTORSETTINGFORM_LABEL_CAPTION_02;
  Label2->Caption = MOTORSETTINGFORM_LABEL_CAPTION_02;
  Label11->Caption = MOTORSETTINGFORM_LABEL_CAPTION_02;
  Label18->Caption = MOTORSETTINGFORM_LABEL_CAPTION_02;
  Label21->Caption = MOTORSETTINGFORM_LABEL_CAPTION_02;
  Label29->Caption = MOTORSETTINGFORM_LABEL_CAPTION_02;
  Label36->Caption = MOTORSETTINGFORM_LABEL_CAPTION_02;
  Label43->Caption = MOTORSETTINGFORM_LABEL_CAPTION_02;
  Label50->Caption = MOTORSETTINGFORM_LABEL_CAPTION_02;
  Label9->Caption = MOTORSETTINGFORM_LABEL_CAPTION_03;
  Label3->Caption = MOTORSETTINGFORM_LABEL_CAPTION_03;
  Label12->Caption = MOTORSETTINGFORM_LABEL_CAPTION_03;
  Label19->Caption = MOTORSETTINGFORM_LABEL_CAPTION_03;
  Label23->Caption = MOTORSETTINGFORM_LABEL_CAPTION_03;
  Label30->Caption = MOTORSETTINGFORM_LABEL_CAPTION_03;
  Label37->Caption = MOTORSETTINGFORM_LABEL_CAPTION_03;
  Label44->Caption = MOTORSETTINGFORM_LABEL_CAPTION_03;
  Label51->Caption = MOTORSETTINGFORM_LABEL_CAPTION_03;
  Label26->Caption = MOTORSETTINGFORM_LABEL_CAPTION_04;
  Label33->Caption = MOTORSETTINGFORM_LABEL_CAPTION_04;
  Label40->Caption = MOTORSETTINGFORM_LABEL_CAPTION_04;
  Label47->Caption = MOTORSETTINGFORM_LABEL_CAPTION_04;
  Label54->Caption = MOTORSETTINGFORM_LABEL_CAPTION_04;

  Label5->Caption 			= MOTORSETTINGFORM_LABEL_CAPTION_05;
  Label13->Caption 			= MOTORSETTINGFORM_LABEL_CAPTION_05;
  Label15->Caption 			= MOTORSETTINGFORM_LABEL_CAPTION_05;
  Label4->Caption 			= MOTORSETTINGFORM_LABEL_CAPTION_05;
  Button1->Caption 			= MOTORSETTINGFORM_BUTTON_CAPTION_01;
  CloseButton->Caption 		= MOTORSETTINGFORM_BUTTON_CAPTION_02;

  //ServoDirectionComboBox1 ׸  ʿ
  //ServoDirectionComboBox2 ׸  ʿ
  //ServoDirectionComboBox3 ׸  ʿ
  //ServoDirectionComboBox4 ׸  ʿ
  ServoDirectionComboBox4->Items->Strings[0] = MOTORSETTINGFORM_CHECKBOX_CAPTION_01;
  ServoDirectionComboBox4->Items->Strings[1] = MOTORSETTINGFORM_CHECKBOX_CAPTION_02;
  
  if(MachineSetupData.MachineType < 2)
  {
	GroupBox4->Caption = MOTORSETTINGFORM_GROUPBOX_CAPTION_04;
	TntGroupBox1->Caption = "ȸ̵  ũ";//MOTORSETTINGFORM_GROUPBOX_CAPTION_04;
	TntGroupBox1->Visible = false;	
  }
  else
  {
	GroupBox4->Caption = "ȸ̵  ũ";//MOTORSETTINGFORM_GROUPBOX_CAPTION_04;
	TntGroupBox1->Caption = "ȸ̵  ũ";//MOTORSETTINGFORM_GROUPBOX_CAPTION_04;
  	TntGroupBox1->Visible = true;	
  }


}
//---------------------------------------------------------------------------
void __fastcall TMotorSettingForm::FormCreate(TObject *Sender)
{
//	ReadSystemInfo();
    ShowMotorInfo();
}
//---------------------------------------------------------------------------
void __fastcall TMotorSettingForm::ShowMotorInfo(void)
{
	for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
    {
    	TTntEdit *servoAccEdit = (TTntEdit *) FindComponent("ServoAccEdit" + IntToStr(motorIndex + 1));
        TTntEdit *servoDecEdit = (TTntEdit *) FindComponent("ServoDecEdit" + IntToStr(motorIndex + 1));
        TTntEdit *servoSpeedEdit = (TTntEdit *) FindComponent("ServoSpeedEdit" + IntToStr(motorIndex + 1));
        TTntComboBox *servoDirectionComboBox = (TTntComboBox *) FindComponent("ServoDirectionComboBox" + IntToStr(motorIndex + 1));

		servoAccEdit->Text = IntToStr(MachineSetupData.ServoMotorData[motorIndex].AccTime);
		servoDecEdit->Text = IntToStr(MachineSetupData.ServoMotorData[motorIndex].DecTime);
//	    servoSpeedEdit->Text = IntToStr(ServoMotorInfo[motorIndex].MoveSpeed);
		servoSpeedEdit->Text = IntToStr(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed);
        if (servoDirectionComboBox)
        {
			if (MachineSetupData.ServoMotorData[motorIndex].Dir)
            {
            	servoDirectionComboBox->ItemIndex = 0;
            }
            else
            {
				servoDirectionComboBox->ItemIndex = 1;
			}
        }

//        int resolution = ResTable[ServoMotorInfo[motorIndex].Resolution];
		TTntLabel *servoRPMLabel = (TTntLabel *) FindComponent("ServoRPMLabel" + IntToStr(motorIndex + 1));
        TTntLabel *servoRPSLabel = (TTntLabel *) FindComponent("ServoRPSLabel" + IntToStr(motorIndex + 1));

    WCHAR TempString[100];
		if (motorIndex == SD1_MOTOR_INDEX || motorIndex == SD2_MOTOR_INDEX)
		{
      wsprintfW(TempString, L"%S RPM", FloatToStrF( 25000000.0 / MachineSetupData.ServoMotorData[motorIndex].BaseSpeed / 3000.0 * 60, ffFixed, 10, 1));
      servoRPMLabel->Caption = TempString;
      wsprintfW(TempString, L"%S RPS", FloatToStrF( 25000000.0 / MachineSetupData.ServoMotorData[motorIndex].BaseSpeed / 3000.0, ffFixed, 10, 3));
      servoRPSLabel->Caption = TempString;
		}
		else if (motorIndex == BF_ID_MOTOR_INDEX)
		{
      wsprintfW(TempString, L"%S RPM", FloatToStrF( 25000000.0 / MachineSetupData.ServoMotorData[motorIndex].BaseSpeed / 3000.0 * 60, ffFixed, 10, 1));
      servoRPMLabel->Caption = TempString;
      wsprintfW(TempString, L"%S RPS", FloatToStrF( 25000000.0 / MachineSetupData.ServoMotorData[motorIndex].BaseSpeed / 3000.0, ffFixed, 10, 3));
      servoRPSLabel->Caption = TempString;
		}
		else
		{
      wsprintfW(TempString, L"%S RPM", FloatToStrF( 25000000.0 / MachineSetupData.ServoMotorData[motorIndex].BaseSpeed / 3000.0 / 21 * 5 * 60, ffFixed, 10, 1));
      servoRPMLabel->Caption = TempString;
      wsprintfW(TempString, L"%S RPS", FloatToStrF( 25000000.0 / MachineSetupData.ServoMotorData[motorIndex].BaseSpeed / 3000.0 / 21 * 5, ffFixed, 10, 3));
      servoRPSLabel->Caption = TempString;
        }
	}
}
//---------------------------------------------------------------------------


void __fastcall TMotorSettingForm::StepAccEditChange(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	int motorIndex = theEdit->Tag;
	try
    {
		MachineSetupData.ServoMotorData[motorIndex].AccTime = StrToInt(theEdit->Text);
    }
    catch(...)
    {

    }
}
//---------------------------------------------------------------------------
void __fastcall TMotorSettingForm::StepDecEditChange(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	int motorIndex = theEdit->Tag;
	try
    {
		MachineSetupData.ServoMotorData[motorIndex].DecTime = StrToInt(theEdit->Text);
    }
    catch(...)
    {

    }
}
//---------------------------------------------------------------------------
void __fastcall TMotorSettingForm::StepSpeedEditChange(
      TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	int motorIndex = theEdit->Tag;
	try
    {
//    	int resolution = ResTable[ServoMotorInfo[motorIndex].Resolution];
//		StepMotorInfo[motorIndex].MoveSpeed = StrToInt(theEdit->Text);
		MachineSetupData.ServoMotorData[motorIndex].BaseSpeed = StrToInt(theEdit->Text);
		TTntLabel *servoRPMLabel = (TTntLabel *) FindComponent("ServoRPMLabel" + IntToStr(motorIndex + 1));
        TTntLabel *servoRPSLabel = (TTntLabel *) FindComponent("ServoRPSLabel" + IntToStr(motorIndex + 1));

//        servoRPMLabel->Caption = servoRPMLabel->Caption.sprintf("%.S RPM", FloatToStrF( StepMotorInfo[motorIndex].MoveSpeed / 500.0 / resolution * 60, ffFixed, 10, 1));
//        servoRPSLabel->Caption = servoRPSLabel->Caption.sprintf("%.S RPS", FloatToStrF( StepMotorInfo[motorIndex].MoveSpeed / 500.0 / resolution, ffFixed, 10, 3));
    WCHAR TempString[100];
		if (motorIndex == SD1_MOTOR_INDEX || motorIndex == SD2_MOTOR_INDEX)
		{
      wsprintfW(TempString, L"%S RPM", FloatToStrF( 25000000.0 / MachineSetupData.ServoMotorData[motorIndex].BaseSpeed / 3000.0 * 60, ffFixed, 10, 1));
      servoRPMLabel->Caption = TempString;
      wsprintfW(TempString, L"%S RPS", FloatToStrF( 25000000.0 / MachineSetupData.ServoMotorData[motorIndex].BaseSpeed / 3000.0, ffFixed, 10, 3));
      servoRPSLabel->Caption = TempString;
		}
		else if (motorIndex == BF_ID_MOTOR_INDEX)
		{
      wsprintfW(TempString, L"%S RPM", FloatToStrF( 25000000.0 / MachineSetupData.ServoMotorData[motorIndex].BaseSpeed / 3000.0 * 60, ffFixed, 10, 1));
      servoRPMLabel->Caption = TempString;
      wsprintfW(TempString, L"%S RPS", FloatToStrF( 25000000.0 / MachineSetupData.ServoMotorData[motorIndex].BaseSpeed / 3000.0, ffFixed, 10, 3));
      servoRPSLabel->Caption = TempString;
		}
		else
		{
      wsprintfW(TempString, L"%S RPM", FloatToStrF( 25000000.0 / MachineSetupData.ServoMotorData[motorIndex].BaseSpeed / 3000.0 / 21 * 5 * 60, ffFixed, 10, 1));
      servoRPMLabel->Caption = TempString;
      wsprintfW(TempString, L"%S RPS", FloatToStrF( 25000000.0 / MachineSetupData.ServoMotorData[motorIndex].BaseSpeed / 3000.0 / 21 * 5, ffFixed, 10, 3));
      servoRPSLabel->Caption = TempString;
		}

		this->Repaint();
    }
    catch(...)
    {

    }
}
//---------------------------------------------------------------------------
void __fastcall TMotorSettingForm::FormDestroy(TObject *Sender)
{
//	WriteSystemInfo();	
}
//---------------------------------------------------------------------------
void __fastcall TMotorSettingForm::StepDirectionComboBoxChange(
      TObject *Sender)
{
	TTntComboBox *theComboBox = (TTntComboBox *) Sender;
	int motorIndex = theComboBox->Tag;
	try
    {
        if (theComboBox->ItemIndex == 0)
        {
			MachineSetupData.ServoMotorData[motorIndex].Dir = 1;
		}
		else
		{
			MachineSetupData.ServoMotorData[motorIndex].Dir = 0;
        }
    }
    catch(...)
    {

    }
}
//---------------------------------------------------------------------------

void __fastcall TMotorSettingForm::CloseButtonClick(TObject *Sender)
{
	Close();	
}
//---------------------------------------------------------------------------
void __fastcall TMotorSettingForm::Button1Click(TObject *Sender)
{
	Comm_Request(COMM_HCB, CMD_MACHINE_PARAM_SETUP, &MachineSetupData, sizeof(TMachineSetupData));
	WriteMachineSetupData(ProgramPath.Env + "\\SystemInfor.ini", MachineSetupData);
/*
	// send motor setup data
	THCBSystemSetupInfo HCBSystemSetupInfo;

	for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
	{
		HCBSystemSetupInfo.ServoMotorData[motorIndex].AccTime = ServoMotorInfo[motorIndex].AccTime;
		HCBSystemSetupInfo.ServoMotorData[motorIndex].DecTime = ServoMotorInfo[motorIndex].DecTime;
		HCBSystemSetupInfo.ServoMotorData[motorIndex].Dir = ServoMotorInfo[motorIndex].IsPositiveDirection ? 1 : 0;
		HCBSystemSetupInfo.ServoMotorData[motorIndex].BaseSpeed = ServoMotorInfo[motorIndex].BaseSpeed;
	}

	if (!Comm_Request(COMM_HCB, CMD_SYSTEM_SETUP, &HCBSystemSetupInfo, sizeof(THCBSystemSetupInfo)))
	{
		//ShowMessageW(HCBConnection.GetLastErrorMessage());
	}
	else
	{
		ShowMessageW("Setup Ϸ");
	}
*/
}
//---------------------------------------------------------------------------


void __fastcall TMotorSettingForm::NumEditClick(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
    if (KeyboardForm->ShowKeypad() == mrOk)
    {
		theEdit->Text = KeyboardForm->Text;
    }	
}
//---------------------------------------------------------------------------

