//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "MotorSpeedSelection_Form.h"
#include "MultiLanguage.h"
#include "Environment.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntGrids"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"

#define MOTOR_SPEED_ROW_COUNT		20
//#define MOTOR_SPEED_COL_COUNT		10//15
TMotorSpeedSelectionForm *MotorSpeedSelectionForm;
//---------------------------------------------------------------------------
__fastcall TMotorSpeedSelectionForm::TMotorSpeedSelectionForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  this->Caption = MOTORSPEEDSELECTIONFORM_FORM_CAPTION_01;
	BaseSpeed = 100;
}
//---------------------------------------------------------------------------
void __fastcall TMotorSpeedSelectionForm::SetSpeed(int baseSpeed, int currentSpeed)
{
	BaseSpeed = baseSpeed;
    CurrentSpeed = currentSpeed;
    SelectedSpeed = CurrentSpeed;
/*
	SpeedValueStringGrid->Cells[0][0] = "ӵ ";
	SpeedValueStringGrid->Cells[1][0] = "ӵ ";
	SpeedValueStringGrid->Cells[2][0] = "ӵ ";
	SpeedValueStringGrid->Cells[3][0] = "ӵ ";
	SpeedValueStringGrid->Cells[4][0] = "ӵ ";
	SpeedValueStringGrid->Cells[5][0] = "ӵ ";
	SpeedValueStringGrid->Cells[6][0] = "ӵ ";
	SpeedValueStringGrid->Cells[7][0] = "ӵ ";

	for (int listIndex = 0; listIndex < 56; listIndex++)
	{
		int speedMod = listIndex * 2.5 + 3;
		SpeedList[listIndex] = baseSpeed * 100 / speedMod;
		SpeedValueStringGrid->Cells[listIndex / 14 * 2][listIndex % 14 + 1] = IntToStr(SpeedList[listIndex]);
		SpeedValueStringGrid->Cells[listIndex / 14 * 2 + 1][listIndex % 14 + 1] = IntToStr(BaseSpeed * 100 / SpeedList[listIndex]) + "%";
	}
*/

/*
	for (int listIndex = 0; listIndex < 56; listIndex++)
	{
		double speedMod = listIndex * 2.5 + 2.5;
		SpeedList[listIndex] = baseSpeed * 100 / speedMod;
//		SpeedValueStringGrid->Cells[listIndex / 14 * 2][listIndex % 14 + 1] = IntToStr(SpeedList[listIndex]);
		SpeedValueStringGrid->Cells[listIndex / 14][listIndex % 14 + 1] = IntToStr(BaseSpeed * 100 / SpeedList[listIndex]) + "%";
	}
*/

	for (int listIndex = 0; listIndex < 300; listIndex++)
	{
		double speedMod = listIndex + 1;
		SpeedList[listIndex] = baseSpeed * 100 / speedMod;
		SpeedValueStringGrid->Cells[listIndex / MOTOR_SPEED_ROW_COUNT][listIndex % MOTOR_SPEED_ROW_COUNT] = IntToStr(BaseSpeed * 100 / SpeedList[listIndex]) + "%";
	}

    SpeedValueStringGrid->Repaint();
}
//---------------------------------------------------------------------------


void __fastcall TMotorSpeedSelectionForm::SpeedValueStringGridDrawCell(
      TObject *Sender, int ACol, int ARow, TRect &Rect,
      TGridDrawState State)
{
	if (ARow == 0) return;

	int listIndex = ACol * MOTOR_SPEED_ROW_COUNT + ARow;

	if (SpeedList[listIndex] == CurrentSpeed)
	{
		TColor oldColor = SpeedValueStringGrid->Canvas->Brush->Color;
		SpeedValueStringGrid->Canvas->Brush->Color = clLime;
		SpeedValueStringGrid->Canvas->Brush->Style = bsSolid;
		SpeedValueStringGrid->Canvas->FillRect(Rect);
		SpeedValueStringGrid->Canvas->Brush->Color = oldColor;
	}
	else
	{
		TColor oldColor = SpeedValueStringGrid->Canvas->Brush->Color;
		SpeedValueStringGrid->Canvas->Brush->Color = clWhite;
		SpeedValueStringGrid->Canvas->Brush->Style = bsSolid;
		SpeedValueStringGrid->Canvas->FillRect(Rect);
		SpeedValueStringGrid->Canvas->Brush->Color = oldColor;
	}
	SpeedValueStringGrid->Canvas->Brush->Style = bsClear;
	SpeedValueStringGrid->Canvas->Font->Color = clBlack;
    SpeedValueStringGrid->Canvas->TextRect(Rect, Rect.left + 8, Rect.top + 8, SpeedValueStringGrid->Cells[ACol][ARow]);
}
//---------------------------------------------------------------------------
void __fastcall TMotorSpeedSelectionForm::SpeedValueStringGridSelectCell(
      TObject *Sender, int ACol, int ARow, bool &CanSelect)
{
	int listIndex = ACol * MOTOR_SPEED_ROW_COUNT + ARow;

	SelectedSpeed = SpeedList[listIndex];

	ModalResult = mrOk;
}
//---------------------------------------------------------------------------
int __fastcall TMotorSpeedSelectionForm::GetSelectedSpeed(void)
{
	return SelectedSpeed;
}
//---------------------------------------------------------------------------


