//---------------------------------------------------------------------------

#ifndef NCControl_FormH
#define NCControl_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <Buttons.hpp>

#include "common.h"
#include <Graphics.hpp>
#include "TntExtCtrls.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
#include "Calibration_Form.h"
//---------------------------------------------------------------------------
class TNCControlForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *MenuPanel;
	TTntGroupBox *NCControlGroupBox;
	TTntLabel *NCValueLabel1;
	TTntLabel *NCValueLabel2;
	TTntLabel *NCValueLabel3;
	TTntLabel *NCValueLabel4;
	TTntLabel *Label6;
	TTntButton *NCControlUpButton1;
	TTntButton *NCControlDownButton1;
	TTntButton *NCControlUpButton2;
	TTntButton *Button4;
	TTntButton *NCControlUpButton3;
	TTntButton *Button6;
	TTntPanel *ControlPanel1;
	TTntLabel *NCPosLabel1;
	TTntLabel *Label1;
	TTntPanel *ControlPanel2;
	TTntLabel *NCPosLabel2;
	TTntLabel *Label9;
	TTntPanel *ControlPanel3;
	TTntLabel *NCPosLabel3;
	TTntLabel *Label11;
	TTntPanel *ControlPanel4;
	TTntLabel *NCPosLabel4;
	TTntLabel *Label13;
	TTntPanel *ControlPanel5;
	TTntLabel *NCPosLabel5;
	TTntLabel *Label15;
	TTntButton *SaveProductDataButton;
	TTntButton *CloseButton;
	TTimer *Timer1;
	TTntPanel *ImagePanel;
	TTntImage *InstructionImage;
	TTntGroupBox *HMEGroupBox;
	TTntImage *Image1;
	TTntPanel *StepMotorMinusLimitPanel1;
	TTntPanel *StepMotorPlusLimitPanel1;
	TTntPanel *StepMotorMinusLimitPanel2;
	TTntPanel *StepMotorPlusLimitPanel2;
	TTntPanel *StepMotorMinusLimitPanel3;
	TTntPanel *StepMotorPlusLimitPanel3;
	TTntPanel *StepMotorMinusLimitPanel4;
	TTntPanel *StepMotorPlusLimitPanel4;
	TTntPanel *StepMotorMinusLimitPanel5;
	TTntPanel *StepMotorPlusLimitPanel5;
	TTntPanel *NCInterlockAPanel;
	TTntPanel *Panel1;
	TTntPanel *OriginWarningPanel;
	void __fastcall ControlPanelClick(TObject *Sender);
	void __fastcall CloseButtonClick(TObject *Sender);
	void __fastcall Timer1Timer(TObject *Sender);
	void __fastcall NCControlUpButtonClick(TObject *Sender);
	void __fastcall NCControlDownButtonClick(TObject *Sender);
	void __fastcall SaveProductDataButtonClick(TObject *Sender);
	void __fastcall FormActivate(TObject *Sender);
	void __fastcall FormDeactivate(TObject *Sender);
private:	// User declarations
	int SelectedControlIndex;
	int NCPosParamMul[MAX_STEP_MOTOR_COUNT];
	int NCPosParamDiv[MAX_STEP_MOTOR_COUNT];
	int CurrentNCValue;
	int CurrentNCValueDigit[4];
	bool FIsMEMode;
	int UserMinusLimitPortIndex[MAX_STEP_MOTOR_COUNT];
	int UserPlusLimitPortIndex[MAX_STEP_MOTOR_COUNT];

  void __fastcall GetDefaultString();

	bool FNCOriginDetected;
	TCSVMachineSettingChangeData machineSettingChangeData;    
public:		// User declarations
	__fastcall TNCControlForm(TComponent* Owner);

	__property bool IsMEMode = {read = FIsMEMode, write = FIsMEMode};
};
//---------------------------------------------------------------------------
extern PACKAGE TNCControlForm *NCControlForm;
//---------------------------------------------------------------------------
#endif
