//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "NCSetting_Form.h"
#include "Environment.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TNCSettingForm *NCSettingForm;
//---------------------------------------------------------------------------
__fastcall TNCSettingForm::TNCSettingForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  GetDefaultString();
}
//---------------------------------------------------------------------------
void __fastcall TNCSettingForm::StepMotorHomeButtonClick(TObject *Sender)
{

	TTntButton *theButton = (TTntButton *)Sender;

	int motorIndex = theButton->Tag;
	Machine.NCHomeMoveTest(motorIndex);
}
//---------------------------------------------------------------------------
void __fastcall TNCSettingForm::GetDefaultString()
{
  StepMotorHomeButton1->Caption = NCSETTINGFORM_BUTTON_CAPTION_01;
  StepMotorHomeButton2->Caption = NCSETTINGFORM_BUTTON_CAPTION_01;
  StepMotorHomeButton3->Caption = NCSETTINGFORM_BUTTON_CAPTION_01;
  StepMotorHomeButton4->Caption = NCSETTINGFORM_BUTTON_CAPTION_01;
  StepMotorHomeButton5->Caption = NCSETTINGFORM_BUTTON_CAPTION_01;
  Button5->Caption = NCSETTINGFORM_BUTTON_CAPTION_02;
  SetZeroPositionButton1->Caption = NCSETTINGFORM_BUTTON_CAPTION_03;
  SetZeroPositionButton2->Caption = NCSETTINGFORM_BUTTON_CAPTION_03;
  SetZeroPositionButton3->Caption = NCSETTINGFORM_BUTTON_CAPTION_03;
  SetZeroPositionButton4->Caption = NCSETTINGFORM_BUTTON_CAPTION_03;
  SetZeroPositionButton5->Caption = NCSETTINGFORM_BUTTON_CAPTION_03;
  Button1->Caption = NCSETTINGFORM_BUTTON_CAPTION_04;
  Button8->Caption = NCSETTINGFORM_BUTTON_CAPTION_04;
  Button11->Caption = NCSETTINGFORM_BUTTON_CAPTION_04;
  Button4->Caption = NCSETTINGFORM_BUTTON_CAPTION_05;
  Button14->Caption = NCSETTINGFORM_BUTTON_CAPTION_06;
  Button2->Caption = NCSETTINGFORM_BUTTON_CAPTION_07;
  Button7->Caption = NCSETTINGFORM_BUTTON_CAPTION_07;
  Button10->Caption = NCSETTINGFORM_BUTTON_CAPTION_07;
  Button13->Caption = NCSETTINGFORM_BUTTON_CAPTION_08;
  InterlockASettingButton->Caption = NCSETTINGFORM_BUTTON_CAPTION_09;
  this->Caption = NCSETTINGFORM_FORM_CAPTION_01;

  GroupBox4->Caption = NCSETTINGFORM_GROUPBOX_CAPTION_01;
  GroupBox5->Caption = NCSETTINGFORM_GROUPBOX_CAPTION_02;
  GroupBox2->Caption = NCSETTINGFORM_GROUPBOX_CAPTION_03;
  GroupBox3->Caption = NCSETTINGFORM_GROUPBOX_CAPTION_04;
  GroupBox6->Caption = NCSETTINGFORM_GROUPBOX_CAPTION_05;
  GroupBox1->Caption = NCSETTINGFORM_GROUPBOX_CAPTION_06;
  GroupBox8->Caption = NCSETTINGFORM_GROUPBOX_CAPTION_07;
  GroupBox9->Caption = NCSETTINGFORM_GROUPBOX_CAPTION_09;

  Label16->Caption = NCSETTINGFORM_LABEL_CAPTION_01;
  Label1->Caption = NCSETTINGFORM_LABEL_CAPTION_02;
  Label4->Caption = NCSETTINGFORM_LABEL_CAPTION_02;
  Label6->Caption = NCSETTINGFORM_LABEL_CAPTION_02;
  Label8->Caption = NCSETTINGFORM_LABEL_CAPTION_02;
  Label10->Caption = NCSETTINGFORM_LABEL_CAPTION_02;
  Label13->Caption = NCSETTINGFORM_LABEL_CAPTION_03;
  Label14->Caption = NCSETTINGFORM_LABEL_CAPTION_04;
  Label11->Caption = NCSETTINGFORM_LABEL_CAPTION_05;
  Label12->Caption = NCSETTINGFORM_LABEL_CAPTION_06;
  Label15->Caption = NCSETTINGFORM_LABEL_CAPTION_07;
  Label2->Caption = NCSETTINGFORM_LABEL_CAPTION_08;
  Label3->Caption = NCSETTINGFORM_LABEL_CAPTION_08;
  Label5->Caption = NCSETTINGFORM_LABEL_CAPTION_08;
  Label7->Caption = NCSETTINGFORM_LABEL_CAPTION_08;
  Label9->Caption = NCSETTINGFORM_LABEL_CAPTION_08;
}
//---------------------------------------------------------------------------
void __fastcall TNCSettingForm::SetZeroPositionButtonClick(
	  TObject *Sender)
{
	TTntButton *theButton = (TTntButton *)Sender;
	int stepMotorIndex = theButton->Tag;
	float settingBaseValue = StrToFloat(((TTntEdit *) FindComponent("SettingBaseValueEdit" + IntToStr(stepMotorIndex + 1)))->Text);

	try
	{
		if (!Machine.ReadMachineStatus())
		{
			throw Exception("Communication error");
		}
		int encoderValue = Machine.Status.StepMotorAbsEncoder[stepMotorIndex];
		//int zeroEncoderValue = 0;
		double zeroPositionValue = 0;
		if (stepMotorIndex == 0)
		{
			zeroPositionValue = (double)encoderValue * NC_POS_PARAM_1_DIV / NC_POS_PARAM_1_MUL - settingBaseValue;
		}
		else if (stepMotorIndex == 1)
		{
			zeroPositionValue = (double)encoderValue * NC_POS_PARAM_2_DIV / NC_POS_PARAM_2_MUL - settingBaseValue;
		}
		else if (stepMotorIndex == 2)
		{
			zeroPositionValue = (double)encoderValue * NC_POS_PARAM_3_DIV / NC_POS_PARAM_3_MUL - settingBaseValue;
		}
		else if (stepMotorIndex == 3)
		{
			zeroPositionValue = (double)encoderValue * NC_POS_PARAM_4_DIV / NC_POS_PARAM_4_MUL - settingBaseValue;
		}
		else if (stepMotorIndex == 4)
		{
			zeroPositionValue = (double)encoderValue * NC_POS_PARAM_5_DIV / NC_POS_PARAM_5_MUL - settingBaseValue;
		}

		//MachineInfo.ZeroEncoderValue[stepMotorIndex] = zeroEncoderValue;
		MachineSetupData.ZeroPositionValue[stepMotorIndex] = zeroPositionValue;
		WriteMachineSetupData(ProgramPath.Env + "\\SystemInfor.ini", MachineSetupData);
	}
	catch (Exception &ec)
	{

	}
}
//---------------------------------------------------------------------------
void __fastcall TNCSettingForm::MachineStatusTimerTimer(TObject *Sender)
{
	Machine.ReadMachineStatus();

	NCPosLabel1->Caption = FloatToStr(((Machine.Status.StepMotorAbsEncoder[0] * 1000 * NC_POS_PARAM_1_DIV / NC_POS_PARAM_1_MUL + 5) / 10) / 100.0 - MachineSetupData.ZeroPositionValue[0]);
	NCPosLabel2->Caption = FloatToStr(((Machine.Status.StepMotorAbsEncoder[1] * 1000 * NC_POS_PARAM_2_DIV / NC_POS_PARAM_2_MUL + 5) / 10) / 100.0 - MachineSetupData.ZeroPositionValue[1]);
	NCPosLabel3->Caption = FloatToStr(((Machine.Status.StepMotorAbsEncoder[2] * 1000 * NC_POS_PARAM_3_DIV / NC_POS_PARAM_3_MUL + 5) / 10) / 100.0 - MachineSetupData.ZeroPositionValue[2]);
	NCPosLabel4->Caption = FloatToStr(((Machine.Status.StepMotorAbsEncoder[3] * 1000 * NC_POS_PARAM_4_DIV / NC_POS_PARAM_4_MUL + 5) / 10) / 100.0 - MachineSetupData.ZeroPositionValue[3]);
	NCPosLabel5->Caption = FloatToStr(((Machine.Status.StepMotorAbsEncoder[4] * 1000 * NC_POS_PARAM_5_DIV / NC_POS_PARAM_5_MUL + 5) / 10) / 100.0 - MachineSetupData.ZeroPositionValue[4]);
}
//---------------------------------------------------------------------------

void __fastcall TNCSettingForm::InterlockASettingButtonClick(
	  TObject *Sender)
{
	if (!Machine.Status.OriginDetected[BF_UP_DOWN_MOTOR_INDEX] ||
		!Machine.Status.OriginDetected[VG2_UP_DOWN_MOTOR_INDEX])
	{
		ShowMessageFA(NCSETTINGFORM_MSG_01);
		return;
	}


	TTntButton *theButton = (TTntButton *)Sender;
	int stepMotorIndex = theButton->Tag;
	float settingBaseValue = StrToFloat(((TTntEdit *) FindComponent("SettingBaseValueEdit" + IntToStr(stepMotorIndex + 1)))->Text);

	try
	{
		if (!Machine.ReadMachineStatus())
		{
			throw Exception("Communication error");
		}
		int bowlFeederUDEncoderValue = Machine.Status.StepMotorAbsEncoder[BF_UP_DOWN_MOTOR_INDEX];
		int verticalGate2EncoderValue = Machine.Status.StepMotorAbsEncoder[VG2_UP_DOWN_MOTOR_INDEX];

//		MachineSetupData.InterlockInfo.NCInterlockAValue = verticalGate2EncoderValue * 100 / NC_POS_PARAM_4 - bowlFeederUDEncoderValue * 100 / NC_POS_PARAM_1;
		MachineSetupData.InterlockInfo.NCInterlockAValue = verticalGate2EncoderValue * 100 * NC_POS_PARAM_4_DIV / NC_POS_PARAM_4_MUL -
			bowlFeederUDEncoderValue * 100 * NC_POS_PARAM_1_DIV / NC_POS_PARAM_1_MUL;
		WriteMachineSetupData(ProgramPath.Env + "\\SystemInfor.ini", MachineSetupData);
		if (!Comm_Request(COMM_HCB, CMD_MACHINE_PARAM_SETUP, &MachineSetupData, sizeof(TMachineSetupData)))
		{
			throw Exception("Communication error");
		}

		ShowMessageFA(NCSETTINGFORM_MSG_02);
	}
	catch (Exception &ec)
	{
		ShowMessageFA(NCSETTINGFORM_MSG_03);
	}
}
//---------------------------------------------------------------------------



void __fastcall TNCSettingForm::NumEditClick(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
	if (KeyboardForm->ShowKeypad() == mrOk)
	{
		theEdit->Text = KeyboardForm->Text;
	}
}
//---------------------------------------------------------------------------

