//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#include <inifiles.hpp>
#pragma hdrstop

#include "NewTabletCounter_Form.h"
#include "SpeedControl_Form.h"
#include "MachineControl.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TNewTabletCounterForm *NewTabletCounterForm;
//---------------------------------------------------------------------------
__fastcall TNewTabletCounterForm::TNewTabletCounterForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  GetDefaultString();
	Disk1TabletList = new THCBDisk1TabletUnit[PC_TABLET_LONG_LIST_COUNT];
	Disk2TabletList = new THCBDisk2TabletUnit[PC_TABLET_LONG_LIST_COUNT];
	Zoom = 10;
	this->DoubleBuffered = true;
}
//---------------------------------------------------------------------------
void __fastcall TNewTabletCounterForm::GetDefaultString()
{
	SCSpeedButton2->Caption = NEWTABLETCOUNTERFORM_BUTTON_CAPTION_01;
	SCSpeedButton1->Caption = NEWTABLETCOUNTERFORM_BUTTON_CAPTION_02;
	SpeedControlButton->Caption = NEWTABLETCOUNTERFORM_BUTTON_CAPTION_03;
	StartButton->Caption = NEWTABLETCOUNTERFORM_BUTTON_CAPTION_04;
	StopButton->Caption = NEWTABLETCOUNTERFORM_BUTTON_CAPTION_05;
	CloseButton->Caption = NEWTABLETCOUNTERFORM_BUTTON_CAPTION_06;
	ZoomOutButton->Caption = NEWTABLETCOUNTERFORM_BUTTON_CAPTION_07;
	ZoomInButton->Caption = NEWTABLETCOUNTERFORM_BUTTON_CAPTION_08;
	SCSpeedButton3->Caption = NEWTABLETCOUNTERFORM_BUTTON_CAPTION_09;
	TimerStopButton->Caption = NEWTABLETCOUNTERFORM_BUTTON_CAPTION_10;
	DefectGenEnabledCheckBox->Caption = NEWTABLETCOUNTERFORM_CHECKBOX_CAPTION_01;
  UnInsGenEnabledCheckBox->Caption = NEWTABLETCOUNTERFORM_CHECKBOX_CAPTION_01;
	GroupBox5->Caption = NEWTABLETCOUNTERFORM_GROUPBOX_CAPTION_01;
	GroupBox3->Caption = NEWTABLETCOUNTERFORM_GROUPBOX_CAPTION_02;
	GroupBox4->Caption = NEWTABLETCOUNTERFORM_GROUPBOX_CAPTION_03;
	GroupBox1->Caption = NEWTABLETCOUNTERFORM_GROUPBOX_CAPTION_04;
	Label10->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_01;
	Label38->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_03;
	Label26->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_04;
	Label34->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_05;
	Label30->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_06;
	Label16->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_07;
	Label21->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_08;
  Label27->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_08;
	Label32->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_09;
	Label36->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_10;
	Label1->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_11;
	Label5->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_12;
	Label3->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_13;
	Label31->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_14;
	Label24->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_15;
	Label22->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_16;
	Label18->Caption = INSPECTIONREPORTFORM_LABEL_CAPTION_15;
	Label11->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_18;

    Label7->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_21;//""; //NEWTABLETCOUNTERFORM_LABEL_CAPTION_19;
	Label15->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_22;//"ī"; //NEWTABLETCOUNTERFORM_LABEL_CAPTION_20;
	Label14->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_19;//" "; //NEWTABLETCOUNTERFORM_LABEL_CAPTION_21;
	Label9->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_20;//" "; //NEWTABLETCOUNTERFORM_LABEL_CAPTION_22;

	Label2->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_23;
    Label6->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_23;

    Label8->Caption = INSPECTIONRESULTINSERTFORM_LABEL_CAPTION_29;//"TOTAL "; //NEWTABLETCOUNTERFORM_LABEL_CAPTION_23;
    Label4->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_23;
    Label17->Caption = NEWTABLETCOUNTERFORM_LABEL_CAPTION_23;
  
	DefectGenKindRadioButton1->Caption = NEWTABLETCOUNTERFORM_RADIOBTN_CAPTION_01;
    UnInsGenKindRadioButton1->Caption = NEWTABLETCOUNTERFORM_RADIOBTN_CAPTION_01;
	DefectGenKindRadioButton2->Caption = NEWTABLETCOUNTERFORM_RADIOBTN_CAPTION_02;
	UnInsGenKindRadioButton2->Caption = NEWTABLETCOUNTERFORM_RADIOBTN_CAPTION_02;

    GroupBox2->Caption 					= NEWTABLETCOUNTERFORM_GROUPBOX_CAPTION_05;
    AirKnifeOnSpeedButton->Caption 		= NEWTABLETCOUNTERFORM_BUTTON_CAPTION_11;
    AirKnifeOffSpeedButton->Caption 	= NEWTABLETCOUNTERFORM_BUTTON_CAPTION_12;

}
//---------------------------------------------------------------------------
void __fastcall TNewTabletCounterForm::SpeedControlButtonClick(
	  TObject *Sender)
{
	TSpeedControlForm *speedControlForm = new TSpeedControlForm(this);
	speedControlForm->ShowModal();
	delete speedControlForm;
}
//---------------------------------------------------------------------------
void __fastcall TNewTabletCounterForm::StartButtonClick(TObject *Sender)
{
  if (Machine.Status.OperationState != MACHINE_STATE_STOP &&
			Machine.Status.OperationState != MACHINE_STATE_CLEANING &&
			Machine.Status.OperationState != MACHINE_STATE_ATTACHING &&
			Machine.Status.OperationState != MACHINE_STATE_DETACHING)
  {
    Machine.MachineStop();
    ShowMessageFA(INSPECTIONFORM_MSG_23);
    return;
  }
  
	int speedControlIndex = 0;

	if (SCSpeedButton1->Down)
	{
		speedControlIndex = 0;
	}
	else if (SCSpeedButton2->Down)
	{
		speedControlIndex = 1;
	}
	else
	{
		speedControlIndex = 2;
	}

	struct
	{
		int SuctionDiskSpeed;
		int StudiedTabletSensor1Length;
		int StudiedTabletSensor2Length;
		int StudiedSensorIntervalA;
		int StudiedSensorIntervalB;
		char defectGenEnabled;
		char defectGenKind;
		char uninsGenEnabled;
		char uninsGenKind;
		unsigned int defectGenMask;
		int defectGenMaskCount;
		int defectGenRatio;
		unsigned int uninsGenMask;
		int uninsGenMaskCount;
		int uninsGenRatio;
	} hcbTabletCounterData;

	hcbTabletCounterData.SuctionDiskSpeed = ProductData.MotorSpeedList[0][speedControlIndex];
	hcbTabletCounterData.StudiedTabletSensor1Length = ProductData.StudiedSensor1Length;
	hcbTabletCounterData.StudiedTabletSensor2Length = ProductData.StudiedSensor2Length;
	hcbTabletCounterData.StudiedSensorIntervalA = ProductData.StudiedSensorIntervalA;
	hcbTabletCounterData.StudiedSensorIntervalB = ProductData.StudiedSensorIntervalB;

	hcbTabletCounterData.defectGenEnabled = DefectGenEnabledCheckBox->Checked ? 1 : 0;
	hcbTabletCounterData.defectGenKind = DefectGenKindRadioButton1->Checked ? 1 : 0;
	if (hcbTabletCounterData.defectGenKind == 0)
	{
		int ejectorMaskValue = StrToInt(DefectGenMaskEdit->Text);
		unsigned int ejectorMask = 0;
		int maskGenCount = 0;
		while (true)
		{
			if (ejectorMaskValue == 0) break;
			ejectorMask <<= 1;
			if (ejectorMaskValue % 10 != 0)
			{
				ejectorMask |= 0x1;
			}
			ejectorMaskValue /= 10;
			maskGenCount++;
		}
		int ejectorMaskCount = DefectGenMaskEdit->Text.Length();
		if (ejectorMaskCount == 0) ejectorMaskCount = 1;
		for (int i = maskGenCount; i < ejectorMaskCount; i++)
		{
			ejectorMask <<= 1;
		}
		hcbTabletCounterData.defectGenMask = ejectorMask;
		hcbTabletCounterData.defectGenMaskCount = ejectorMaskCount;
		hcbTabletCounterData.defectGenRatio = 0;
	}
	else
	{
		hcbTabletCounterData.defectGenMask = 0;
		hcbTabletCounterData.defectGenMaskCount = 1;
		hcbTabletCounterData.defectGenRatio = StrToInt(DefectGenRatioEdit->Text);
	}

	hcbTabletCounterData.uninsGenEnabled = UnInsGenEnabledCheckBox->Checked ? 1 : 0;
	hcbTabletCounterData.uninsGenKind = UnInsGenKindRadioButton1->Checked ? 1 : 0;
	if (hcbTabletCounterData.uninsGenKind == 0)
	{
		int ejectorMaskValue = StrToInt(UnInsGenMaskEdit->Text);
		unsigned int ejectorMask = 0;
		int maskGenCount = 0;
		while (true)
		{
			if (ejectorMaskValue == 0) break;
			ejectorMask <<= 1;
			if (ejectorMaskValue % 10 != 0)
			{
				ejectorMask |= 0x1;
			}
			ejectorMaskValue /= 10;
			maskGenCount++;
		}
		int ejectorMaskCount = UnInsGenMaskEdit->Text.Length();
		if (ejectorMaskCount == 0) ejectorMaskCount = 1;
		for (int i = maskGenCount; i < ejectorMaskCount; i++)
		{
			ejectorMask <<= 1;
		}		
		hcbTabletCounterData.uninsGenMask = ejectorMask;
		hcbTabletCounterData.uninsGenMaskCount = ejectorMaskCount;
		hcbTabletCounterData.uninsGenRatio = 0;
	}
	else
	{
		hcbTabletCounterData.uninsGenMask = 0;
		hcbTabletCounterData.uninsGenMaskCount = 1;
		hcbTabletCounterData.uninsGenRatio = StrToInt(UnInsGenRatioEdit->Text);
	}
	
	Comm_Request(COMM_HCB, CMD_TABLET_COUNTER_READY, &hcbTabletCounterData, sizeof(hcbTabletCounterData));


	int motorSpeedList[MAX_SERVO_MOTOR_COUNT];
	for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
	{
		motorSpeedList[motorIndex] = ProductData.MotorSpeedList[motorIndex][speedControlIndex];
	}

	Machine.MachineRun(PROCEDURE_MODE_INSPECTION, &ProductData.MachineRunOption,
		ProductData.NCMotorPos, motorSpeedList);

	CurrentList1Index = 0;
	CurrentList2Index = 0;
	LastPCList1Index = 0;
	LastPCList2Index = 0;
	CurrentList1TabletNumber = 0;
	CurrentList2TabletNumber = 0;
	CurrentList1TabletNumber_Add = 0;
	CurrentList2TabletNumber_Add = 0;
	AnalysisIndex = 0;
	ValidDataIndex = 0;
	ErrCount1 = 0;
	ErrCount2 = 0;
	ForceDirectories(ProgramPath.Log + "\\EvalData");


	TimingGap = ProductData.StudiedSensorIntervalA * ProductData.MotorSpeedList[SD1_MOTOR_INDEX][speedControlIndex] / MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed;
	TimingGap2 = ProductData.StudiedSensorIntervalB * ProductData.MotorSpeedList[SD1_MOTOR_INDEX][speedControlIndex] / MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed;

	TabletInfoTimer->Enabled = true;
}
//---------------------------------------------------------------------------
void __fastcall TNewTabletCounterForm::TabletInfoTimerTimer(
	  TObject *Sender)
{
	int requestNum = 1;

	Comm_Request(COMM_HCB, CMD_TABLET_PROCESS_INFO, &requestNum, sizeof(int), &HCBTabletInfo, sizeof(TTabletInfo));

	if (HCBTabletInfo.CurrentSensor1ListIndex != CurrentList1Index)
	{
		int newTabletCount = HCBTabletInfo.CurrentSensor1ListIndex - CurrentList1Index;
		if (CurrentList1Index > HCBTabletInfo.CurrentSensor1ListIndex)
		{
			newTabletCount += HCB_TABLET_LIST_COUNT;
		}

		int currentListIndex = CurrentList1Index - 16;
		if (currentListIndex < 0)
		{
			currentListIndex += HCB_TABLET_LIST_COUNT;
			CurrentList1TabletNumber_Add -= HCB_TABLET_LIST_COUNT;
		}
		for (int listIndex = -16; listIndex < newTabletCount; listIndex++)
		{
			if (CurrentList1TabletNumber_Add + currentListIndex < PC_TABLET_LONG_LIST_COUNT && CurrentList1TabletNumber_Add + currentListIndex >= 0)
			{
				memcpy(&Disk1TabletList[CurrentList1TabletNumber_Add + currentListIndex], &HCBTabletInfo.Disk1TabletList[currentListIndex], sizeof(THCBDisk1TabletUnit));
			}
			currentListIndex++;
			if (currentListIndex >= HCB_TABLET_LIST_COUNT)
			{
				currentListIndex = 0;
				CurrentList1TabletNumber_Add += HCB_TABLET_LIST_COUNT;
			}
		}
		LastPCList1Index = CurrentList1TabletNumber_Add + currentListIndex;
		CurrentList1Index = HCBTabletInfo.CurrentSensor1ListIndex;
	}


	int checkListIndex = CurrentList2Index;
	int newTabletCount = 0;
	for (int index = 0; index < HCB_TABLET_LIST_COUNT; index++)
	{
		//if (HCBTabletInfo.Disk2TabletList[checkListIndex].State == TABLET_STATE_COMPLETE ||
		//	HCBTabletInfo.Disk2TabletList[checkListIndex].State == TABLET_STATE_ERROR)

		if (HCBTabletInfo.Disk2TabletList[checkListIndex].EjectionCheck != TABLET_EJECTION_CHECK_NONE)
		{
			checkListIndex = (checkListIndex + 1) & HCB_TABLET_LIST_MASK;
			newTabletCount++;
		}
		else
		{
			break;
		}
	}

	//if (HCBTabletInfo.CurrentSensor2ListIndex != CurrentList2Index)
	if (newTabletCount > 0)
	{
		//int newTabletCount = HCBTabletInfo.CurrentSensor2ListIndex - CurrentList2Index;
		//if (CurrentList2Index > HCBTabletInfo.CurrentSensor2ListIndex)
		//{
		//	newTabletCount += HCB_TABLET_LIST_COUNT;
		//}

		/*
		int currentListIndex = CurrentList2Index - 16;
		if (currentListIndex < 0)
		{
			currentListIndex += HCB_TABLET_LIST_COUNT;
			CurrentList2TabletNumber_Add -= HCB_TABLET_LIST_COUNT;
		}
		for (int listIndex = -16; listIndex < newTabletCount; listIndex++)
		*/
		int currentListIndex = CurrentList2Index;

		for (int listIndex = 0; listIndex < newTabletCount; listIndex++)
		{
			if (CurrentList2TabletNumber_Add + currentListIndex < PC_TABLET_LONG_LIST_COUNT && CurrentList2TabletNumber_Add + currentListIndex >= 0)
			{
				memcpy(&Disk2TabletList[CurrentList2TabletNumber_Add + currentListIndex], &HCBTabletInfo.Disk2TabletList[currentListIndex], sizeof(THCBDisk2TabletUnit));
			}
			currentListIndex++;
			if (currentListIndex >= HCB_TABLET_LIST_COUNT)
			{
				currentListIndex = 0;
				CurrentList2TabletNumber_Add += HCB_TABLET_LIST_COUNT;
			}
		}
		//CurrentList2Index = HCBTabletInfo.CurrentSensor2ListIndex;
		CurrentList2Index = currentListIndex;

		LastPCList2Index = CurrentList2TabletNumber_Add + currentListIndex;
	}

	while (AnalysisIndex < ValidDataIndex - 1)
	{
		if (Disk2TabletList[AnalysisIndex].InspectionResult != TABLET_RESULT_GOOD &&
			Disk2TabletList[AnalysisIndex].InspectionResult != TABLET_RESULT_DEFECT &&
			Disk2TabletList[AnalysisIndex].InspectionResult != TABLET_RESULT_UNINS_SPB_PROCESSING_NOT_COMPLETE &&
			Disk2TabletList[AnalysisIndex].InspectionResult != TABLET_RESULT_NONE)
		{
			// save analysisInfo
			unsigned int analysisTime = Disk2TabletList[AnalysisIndex].Sensor2Time;
			unsigned int analysisStartTime = analysisTime - 200 * 20;		// previous 200ms
			int sensor2startTime = analysisStartTime;
			int sensor1startTime = sensor2startTime - TimingGap;

			Graphics::TBitmap *saveBitmap = new Graphics::TBitmap;
			saveBitmap->Width = 400;
			saveBitmap->Height = 300;
			saveBitmap->PixelFormat = pf24bit;

			saveBitmap->Canvas->Brush->Style = bsSolid;
			saveBitmap->Canvas->Brush->Color = clBlack;
			saveBitmap->Canvas->FillRect(Rect(0, 0, saveBitmap->Width, saveBitmap->Height));

			saveBitmap->Canvas->Pen->Color = clRed;
			saveBitmap->Canvas->Pen->Color = clRed;
			saveBitmap->Canvas->MoveTo(0, 90);

			int LastPosX = 0;
			for (int pcListIndex = AnalysisIndex - 10; pcListIndex < AnalysisIndex + 10; pcListIndex++)
			{
				Application->ProcessMessages();
				if (pcListIndex >= PC_TABLET_LONG_LIST_COUNT || pcListIndex < 0) continue;
				/*
				if (Disk1TabletList[pcListIndex].Sensor1Time + Disk1TabletList[pcListIndex].Sensor1Length < sensor1startTime) continue;
				if (Disk1TabletList[pcListIndex].Sensor1Time > sensor1endTime)
				{
					if (LastPosX < SensorImage1->Width)
					{
						saveBitmap->Canvas->LineTo((Disk1TabletList[pcListIndex].Sensor1Time - sensor1startTime) / Zoom, 90);
						LastPosX = (Disk1TabletList[pcListIndex].Sensor1Time - sensor1startTime) / Zoom;
					}
					continue;
				}
				*/
				saveBitmap->Canvas->LineTo((Disk1TabletList[pcListIndex].Sensor1Time - sensor1startTime) / 20, 90);
				saveBitmap->Canvas->LineTo((Disk1TabletList[pcListIndex].Sensor1Time - sensor1startTime) / 20, 30);
				saveBitmap->Canvas->LineTo((Disk1TabletList[pcListIndex].Sensor1Time + Disk1TabletList[pcListIndex].Sensor1Length - sensor1startTime) / 20, 30);
				saveBitmap->Canvas->LineTo((Disk1TabletList[pcListIndex].Sensor1Time + Disk1TabletList[pcListIndex].Sensor1Length - sensor1startTime) / 20, 90);
				//LastPosX = (Disk1TabletList[pcListIndex].Sensor1Time + Disk1TabletList[pcListIndex].Sensor1Length - sensor1startTime) / 20;
			}

			saveBitmap->Canvas->MoveTo(0, 270);
			for (int pcListIndex = AnalysisIndex - 10; pcListIndex < AnalysisIndex + 10; pcListIndex++)
			{
				Application->ProcessMessages();
				if (pcListIndex >= PC_TABLET_LONG_LIST_COUNT || pcListIndex < 0) continue;
				/*
				if (Disk1TabletList[pcListIndex].Sensor1Time + Disk1TabletList[pcListIndex].Sensor1Length < sensor1startTime) continue;
				if (Disk1TabletList[pcListIndex].Sensor1Time > sensor1endTime)
				{
					if (LastPosX < SensorImage1->Width)
					{
						saveBitmap->Canvas->LineTo((Disk1TabletList[pcListIndex].Sensor1Time - sensor1startTime) / 20, 90);
						LastPosX = (Disk1TabletList[pcListIndex].Sensor1Time - sensor1startTime) / 20;
					}
					continue;
				}
				*/
				saveBitmap->Canvas->LineTo((Disk1TabletList[pcListIndex].Sensor1Time - sensor1startTime) / 20, 270);
				saveBitmap->Canvas->LineTo((Disk1TabletList[pcListIndex].Sensor1Time - sensor1startTime) / 20, 210);
				saveBitmap->Canvas->LineTo((Disk1TabletList[pcListIndex].Sensor1Time + Disk1TabletList[pcListIndex].Sensor1Length - sensor1startTime) / 20, 210);
				saveBitmap->Canvas->LineTo((Disk1TabletList[pcListIndex].Sensor1Time + Disk1TabletList[pcListIndex].Sensor1Length - sensor1startTime) / 20, 270);
			}

			saveBitmap->Canvas->Pen->Color = clLime;
			saveBitmap->Canvas->Font->Color = clLime;
			saveBitmap->Canvas->MoveTo(0, 180);

			LastPosX = 0;
			for (int pcListIndex = AnalysisIndex - 10; pcListIndex < AnalysisIndex + 10; pcListIndex++)
			{
				Application->ProcessMessages();
				if (pcListIndex >= PC_TABLET_LONG_LIST_COUNT || pcListIndex < 0) continue;
				/*
				if (Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length < sensor2startTime) continue;
				if (Disk2TabletList[pcListIndex].Sensor2Time > sensor2endTime)
				{
					if (LastPosX < SensorImage2->Width)
					{
						SensorImage2->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / 20, 90);
						SensorImage_Match->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / 20, 90);
						LastPosX = (Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / 20;
					}
					continue;
				}
				*/
				if (Disk2TabletList[pcListIndex].InspectionResult != TABLET_RESULT_DISAPPEARED)
				{
					saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / 20, 180);
					saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / 20, 120);
					saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / 20, 120);
					saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / 20, 180);
				}
				//LastPosX = (Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / 20;
			}

			saveBitmap->Canvas->MoveTo(0, 270);
			for (int pcListIndex = AnalysisIndex - 10; pcListIndex < AnalysisIndex + 10; pcListIndex++)
			{
				Application->ProcessMessages();
				if (pcListIndex >= PC_TABLET_LONG_LIST_COUNT || pcListIndex < 0) continue;
				/*
				if (Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length < sensor2startTime) continue;
				if (Disk2TabletList[pcListIndex].Sensor2Time > sensor2endTime)
				{
					if (LastPosX < SensorImage2->Width)
					{
						SensorImage2->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / 20, 90);
						SensorImage_Match->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / 20, 90);
						LastPosX = (Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / 20;
					}
					continue;
				}
				*/
				saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / 20, 270);
				saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / 20, 210);
				saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / 20, 210);
				saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / 20, 270);
				//LastPosX = (Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / 20;

				AnsiString text;

				switch(Disk2TabletList[pcListIndex].InspectionResult)
				{
					case TABLET_RESULT_GOOD:
						text = "G";
						break;
					case TABLET_RESULT_DEFECT:
						text = "D";
						break;
					case TABLET_RESULT_INSERTED:
						text = "I";
						break;
					case TABLET_RESULT_DISAPPEARED:
						text = "P";
						break;
					case TABLET_RESULT_CLOSED_UNINS:
						text = "E";
						break;
					case TABLET_RESULT_CLOSED_DEFECT:
						text = "L";
						break;
					case TABLET_RESULT_SENSOR_1_MISFEEDING:
					case TABLET_RESULT_SENSOR_2_MISFEEDING:
						text = "M/F";
						break;
					case TABLET_RESULT_MULTI_TABLET_SENSOR_1:
					case TABLET_RESULT_MULTI_TABLET_SENSOR_2:
						text = "C";
						break;
					case TABLET_RESULT_UNINTENDED_UNINSPECT:
					case TABLET_RESULT_UNINS_SPB_PROCESSING_NOT_COMPLETE:
						text = "U";
						break;
					default:
						text = "?";
						break;
				}
				if (Disk2TabletList[pcListIndex].InspectionResult != TABLET_RESULT_GOOD)
				{
					saveBitmap->Canvas->Font->Color = clFuchsia;
					saveBitmap->Canvas->TextOut((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / 20 + 2, 220, text);
					saveBitmap->Canvas->Font->Color = clLime;
				}
				else
				{
					saveBitmap->Canvas->TextOut((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / 20 + 2, 220, text);
				}
				saveBitmap->Canvas->MoveTo((Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / Zoom, 270);
			}
			saveBitmap->SaveToFile(ProgramPath.Log + "\\EvalData\\" + IntToStr(ErrCount1) + ".bmp");
			delete saveBitmap;
			AnsiString iniFileName = ProgramPath.Log + "\\EvalData\\" + IntToStr(ErrCount1) + ".dat";
			if (FileExists(iniFileName))
			{
				DeleteFile(iniFileName);
			}
			TIniFile *iniFile = new TIniFile(iniFileName);
			for (int pcListIndex = AnalysisIndex - 10; pcListIndex < AnalysisIndex + 10; pcListIndex++)
			{
				if (pcListIndex >= PC_TABLET_LONG_LIST_COUNT || pcListIndex < 0) continue;
				iniFile->WriteInteger("Sensor 1 Time", IntToStr(pcListIndex), Disk1TabletList[pcListIndex].Sensor1Time);
				iniFile->WriteInteger("Sensor 1 Length", IntToStr(pcListIndex), Disk1TabletList[pcListIndex].Sensor1Length);

				iniFile->WriteInteger("Sensor 2 Time", IntToStr(pcListIndex), Disk2TabletList[pcListIndex].Sensor2Time);
				iniFile->WriteInteger("Sensor 2 Length", IntToStr(pcListIndex), Disk2TabletList[pcListIndex].Sensor2Length);
				iniFile->WriteInteger("Sensor 2 Time Estimated", IntToStr(pcListIndex), Disk2TabletList[pcListIndex].EstimatedSensor2Time);
				iniFile->WriteInteger("Related Sensor 1 Time", IntToStr(pcListIndex), Disk2TabletList[pcListIndex].Sensor1Time);
				iniFile->WriteInteger("Related Sensor 1 Length", IntToStr(pcListIndex), Disk2TabletList[pcListIndex].Sensor1Length);
				iniFile->WriteInteger("UnIns Time", IntToStr(pcListIndex), Disk2TabletList[pcListIndex].UnInsEjectorTime);
			}



			delete iniFile;
			ErrCount1++;
		}





		bool ejectionMatched = true;
		if (Disk2TabletList[AnalysisIndex].InspectionResult == TABLET_RESULT_GOOD)
		{
			if (Disk2TabletList[AnalysisIndex].EjectionCheck != TABLET_EJECTION_CHECK_EXIST)
			{
				ejectionMatched = false;
			}
		}
		else
		{
			if (Disk2TabletList[AnalysisIndex].EjectionCheck == TABLET_EJECTION_CHECK_EXIST)
			{
				ejectionMatched = false;
			}
		}

		if (!ejectionMatched)
		{
			// save analysisInfo
			unsigned int analysisTime = Disk2TabletList[AnalysisIndex].Sensor2Time;
			unsigned int analysisStartTime = analysisTime - 200 * 20;		// previous 200ms
			int sensor2startTime = analysisStartTime;
			int sensor3startTime = sensor2startTime + TimingGap2;

			Graphics::TBitmap *saveBitmap = new Graphics::TBitmap;
			saveBitmap->Width = 400;
			saveBitmap->Height = 300;
			saveBitmap->PixelFormat = pf24bit;

			saveBitmap->Canvas->Brush->Style = bsSolid;
			saveBitmap->Canvas->Brush->Color = clBlack;
			saveBitmap->Canvas->FillRect(Rect(0, 0, saveBitmap->Width, saveBitmap->Height));


			saveBitmap->Canvas->Pen->Color = clLime;
			saveBitmap->Canvas->Font->Color = clLime;
			saveBitmap->Canvas->MoveTo(0, 90);

			for (int pcListIndex = AnalysisIndex - 10; pcListIndex < AnalysisIndex + 10; pcListIndex++)
			{
				if (pcListIndex >= PC_TABLET_LONG_LIST_COUNT || pcListIndex < 0) continue;
				if (Disk2TabletList[pcListIndex].InspectionResult != TABLET_RESULT_DISAPPEARED)
				{
					saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / 20, 90);
					saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / 20, 30);
					saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / 20, 30);
					saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / 20, 90);
				}
			}

			saveBitmap->Canvas->MoveTo(0, 270);
			for (int pcListIndex = AnalysisIndex - 10; pcListIndex < AnalysisIndex + 10; pcListIndex++)
			{
				if (pcListIndex >= PC_TABLET_LONG_LIST_COUNT || pcListIndex < 0) continue;
				saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / 20, 270);
				saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / 20, 210);
				saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / 20, 210);
				saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / 20, 270);

				AnsiString text;

				switch(Disk2TabletList[pcListIndex].InspectionResult)
				{
					case TABLET_RESULT_GOOD:
						text = "G";
						break;
					case TABLET_RESULT_DEFECT:
						text = "D";
						break;
					case TABLET_RESULT_INSERTED:
						text = "I";
						break;
					case TABLET_RESULT_DISAPPEARED:
						text = "P";
						break;
					case TABLET_RESULT_CLOSED_UNINS:
						text = "E";
						break;
					case TABLET_RESULT_CLOSED_DEFECT:
						text = "L";
						break;
					case TABLET_RESULT_SENSOR_1_MISFEEDING:
					case TABLET_RESULT_SENSOR_2_MISFEEDING:
						text = "M/F";
						break;
					case TABLET_RESULT_MULTI_TABLET_SENSOR_1:
					case TABLET_RESULT_MULTI_TABLET_SENSOR_2:
						text = "C";
						break;
					case TABLET_RESULT_UNINTENDED_UNINSPECT:
					case TABLET_RESULT_UNINS_SPB_PROCESSING_NOT_COMPLETE:
						text = "U";
						break;
					default:
						text = "?";
						break;
				}
				if (Disk2TabletList[pcListIndex].InspectionResult != TABLET_RESULT_GOOD)
				{
					saveBitmap->Canvas->Font->Color = clFuchsia;
					saveBitmap->Canvas->TextOut((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / 20 + 2, 220, text);
					saveBitmap->Canvas->Font->Color = clLime;
				}
				else
				{
					saveBitmap->Canvas->TextOut((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / 20 + 2, 220, text);
				}
				saveBitmap->Canvas->MoveTo((Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / Zoom, 270);
			}

			saveBitmap->Canvas->Pen->Color = clFuchsia;
			saveBitmap->Canvas->Pen->Color = clFuchsia;
			saveBitmap->Canvas->MoveTo(0, 180);
			for (int pcListIndex = AnalysisIndex - 10; pcListIndex < AnalysisIndex + 10; pcListIndex++)
			{
				if (pcListIndex >= PC_TABLET_LONG_LIST_COUNT || pcListIndex < 0) continue;
				saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor3Time - sensor3startTime) / 20, 180);
				saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor3Time - sensor3startTime) / 20, 120);
				saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor3Time + Disk2TabletList[pcListIndex].Sensor3Length - sensor3startTime) / 20, 120);
				saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor3Time + Disk2TabletList[pcListIndex].Sensor3Length - sensor3startTime) / 20, 180);
			}

			saveBitmap->Canvas->MoveTo(0, 270);
			for (int pcListIndex = AnalysisIndex - 10; pcListIndex < AnalysisIndex + 10; pcListIndex++)
			{
				if (pcListIndex >= PC_TABLET_LONG_LIST_COUNT || pcListIndex < 0) continue;
				saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor3Time - sensor3startTime) / 20, 270);
				saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor3Time - sensor3startTime) / 20, 210);
				saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor3Time + Disk2TabletList[pcListIndex].Sensor3Length - sensor3startTime) / 20, 210);
				saveBitmap->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor3Time + Disk2TabletList[pcListIndex].Sensor3Length - sensor3startTime) / 20, 270);
			}

			saveBitmap->SaveToFile(ProgramPath.Log + "\\EvalData\\" + IntToStr(ErrCount2) + "_ME.bmp");
			delete saveBitmap;
			AnsiString iniFileName = ProgramPath.Log + "\\EvalData\\" + IntToStr(ErrCount2) + "_ME.dat";
			if (FileExists(iniFileName))
			{
				DeleteFile(iniFileName);
			}
			TIniFile *iniFile = new TIniFile(iniFileName);
			for (int pcListIndex = AnalysisIndex - 10; pcListIndex < AnalysisIndex + 10; pcListIndex++)
			{
				if (pcListIndex >= PC_TABLET_LONG_LIST_COUNT || pcListIndex < 0) continue;
				iniFile->WriteInteger("Sensor 2 Time", IntToStr(pcListIndex), Disk2TabletList[pcListIndex].Sensor2Time);
				iniFile->WriteInteger("Sensor 2 Length", IntToStr(pcListIndex), Disk2TabletList[pcListIndex].Sensor2Length);

				iniFile->WriteInteger("Sensor 3 Time", IntToStr(pcListIndex), Disk2TabletList[pcListIndex].Sensor3Time);
				iniFile->WriteInteger("Sensor 3 Length", IntToStr(pcListIndex), Disk2TabletList[pcListIndex].Sensor3Length);
				iniFile->WriteInteger("Sensor 3 Time Estimated", IntToStr(pcListIndex), Disk2TabletList[pcListIndex].EstimatedSensor3Time);

				iniFile->WriteInteger("Ejection", IntToStr(pcListIndex), Disk2TabletList[pcListIndex].Ejection);
				iniFile->WriteInteger("Ejection Check", IntToStr(pcListIndex), Disk2TabletList[pcListIndex].EjectionCheck);
			}

			delete iniFile;
			ErrCount2++;
		}

		AnalysisIndex++;
	}

	ValidDataIndex = LastPCList2Index;



	if (LastPCList2Index != 0)
	{
		StartHCBTime = Disk2TabletList[0].Sensor2Time - 100;
		CurrentHCBTime = Disk2TabletList[LastPCList2Index - 1].Sensor2Time + Disk2TabletList[LastPCList2Index - 1].Sensor2Length + 100;
		ViewingLastTime = CurrentHCBTime;
		//TimingGap = Disk2TabletList[0].EstimatedSensor2Time - Disk2TabletList[0].Sensor1Time;
		//TimingGap2 = Disk2TabletList[0].EstimatedSensor3Time - Disk2TabletList[0].Sensor2Time;
	}
	else
	{
		StartHCBTime = 0;
		CurrentHCBTime = 0;
		ViewingLastTime = 0;
		//TimingGap = 0;
		//TimingGap2 = 0;
	}

	if (StartHCBTime / Zoom < CurrentHCBTime / Zoom)
	{
		ViewingScrollBar->SetParams(ViewingLastTime / Zoom, StartHCBTime / Zoom, CurrentHCBTime / Zoom);
	}
	else
	{
		ViewingScrollBar->SetParams(0, 0, 1);
	}


	requestNum = 1;
	Comm_Request(COMM_HCB, CMD_TABLET_INSPECT_INFO, &requestNum, sizeof(int), &TabletInspectInfo, sizeof(TTabletInspectInfo));
	Sensor1CountLabel->Caption = IntToStr(TabletInspectInfo.Disk1TabletCount);
	Sensor2CountLabel->Caption = IntToStr(TabletInspectInfo.Disk2TabletCount);
	Sensor3CountLabel->Caption = IntToStr(TabletInspectInfo.CounterSensorTabletCount);
	TotalCountLabel->Caption = IntToStr(TabletInspectInfo.TotalTabletCount);
	GoodCountLabel->Caption = IntToStr(TabletInspectInfo.GoodTabletCount);
	DefectCountLabel->Caption = IntToStr(TabletInspectInfo.DefectTabletCount);
	UnInsCountLabel->Caption = IntToStr(TabletInspectInfo.UnInsTabletCount);
	MisFeedingCountLabel->Caption = IntToStr(TabletInspectInfo.Sensor1MisFeedingTabletCount + TabletInspectInfo.Sensor2MisFeedingTabletCount);
	ClosedCountLabel->Caption = IntToStr(TabletInspectInfo.Sensor1MultiTabletCount + TabletInspectInfo.Sensor2MultiTabletCount);
	LostCountLabel->Caption = IntToStr(TabletInspectInfo.DisappearedTabletCount);
	InsertedCountLabel->Caption = IntToStr(TabletInspectInfo.InsertedTabletCount);
	ClosedTabletUninsCountLabel->Caption = IntToStr(TabletInspectInfo.ClosedTabletUninsCount);
	NozzErrorUnInsTabletCountLabel->Caption = IntToStr(TabletInspectInfo.NozzErrorUnInsTabletCount);
	UnInsGenCountLabel->Caption = IntToStr(TabletInspectInfo.SPBProcessingNCTabletCount);

	CountedCountLabel->Caption = IntToStr(TabletInspectInfo.CounterSensorTabletCount);
	GoodTabletLostCountLabel->Caption = IntToStr(TabletInspectInfo.GoodTabletLostCount);
	MisejectTabletInsertCountLabel->Caption = IntToStr(TabletInspectInfo.MisejectTabletInsertCount);
	MisejectDefectTabletCountLabel->Caption = IntToStr(TabletInspectInfo.MisejectDefectTabletCount);
	MisejectUnInsTabletCountLabel->Caption = IntToStr(TabletInspectInfo.MisejectUnInsTabletCount);

//	TPHLabel->Caption = IntToStr(TabletInspectInfo.ThroughPut * 60) + " T/H";
	RefreshGraph();
}
//---------------------------------------------------------------------------
void __fastcall TNewTabletCounterForm::FormDestroy(TObject *Sender)
{
	delete[] Disk1TabletList;
	delete[] Disk2TabletList;
}
//---------------------------------------------------------------------------
void __fastcall TNewTabletCounterForm::RefreshGraph(void)
{
	int sensor2startTime = ViewingLastTime - SensorImage2->Width * Zoom;
	int sensor2endTime = ViewingLastTime;
	int sensor1startTime = sensor2startTime - TimingGap;
	int sensor1endTime = sensor2endTime - TimingGap;
	int sensor3startTime = sensor2startTime + TimingGap2;
	int sensor3endTime = sensor2endTime + TimingGap2;
	const int pulseHighY = SensorImage1->Height / 4;
	const int pulseLowY = SensorImage1->Height * 3 / 4;
	const int textMargin = 10;

	SensorImage1->Canvas->Brush->Style = bsSolid;
	SensorImage1->Canvas->Brush->Color = clBlack;
	SensorImage1->Canvas->FillRect(Rect(0, 0, SensorImage1->Width, SensorImage1->Height));

	SensorImage2->Canvas->Brush->Style = bsSolid;
	SensorImage2->Canvas->Brush->Color = clBlack;
	SensorImage2->Canvas->FillRect(Rect(0, 0, SensorImage2->Width, SensorImage2->Height));

	SensorImage3->Canvas->Brush->Style = bsSolid;
	SensorImage3->Canvas->Brush->Color = clBlack;
	SensorImage3->Canvas->FillRect(Rect(0, 0, SensorImage3->Width, SensorImage3->Height));

	SensorImage_Match->Canvas->Brush->Style = bsSolid;
	SensorImage_Match->Canvas->Brush->Color = clBlack;
	SensorImage_Match->Canvas->FillRect(Rect(0, 0, SensorImage_Match->Width, SensorImage_Match->Height));

	SensorImage_Ejection_Match->Canvas->Brush->Style = bsSolid;
	SensorImage_Ejection_Match->Canvas->Brush->Color = clBlack;
	SensorImage_Ejection_Match->Canvas->FillRect(Rect(0, 0, SensorImage_Ejection_Match->Width, SensorImage_Ejection_Match->Height));

	SensorImage1->Canvas->Pen->Color = clRed;
	SensorImage_Match->Canvas->Pen->Color = clRed;
	SensorImage1->Canvas->MoveTo(0, pulseLowY);
	SensorImage_Match->Canvas->MoveTo(0, pulseLowY);
	int LastPosX = 0;
	for (int pcListIndex = 0; pcListIndex <= LastPCList1Index; pcListIndex++)
	{
		if (pcListIndex >= PC_TABLET_LONG_LIST_COUNT) break;
		if (Disk1TabletList[pcListIndex].Sensor1Time + Disk1TabletList[pcListIndex].Sensor1Length < sensor1startTime) continue;
		if (Disk1TabletList[pcListIndex].Sensor1Time > sensor1endTime)
		{
			if (LastPosX < SensorImage1->Width)
			{
				SensorImage1->Canvas->LineTo((Disk1TabletList[pcListIndex].Sensor1Time - sensor1startTime) / Zoom, pulseLowY);
				LastPosX = (Disk1TabletList[pcListIndex].Sensor1Time - sensor1startTime) / Zoom;
			}
			continue;
		}
		SensorImage1->Canvas->LineTo((Disk1TabletList[pcListIndex].Sensor1Time - sensor1startTime) / Zoom, pulseLowY);
		SensorImage1->Canvas->LineTo((Disk1TabletList[pcListIndex].Sensor1Time - sensor1startTime) / Zoom, pulseHighY);
		SensorImage1->Canvas->LineTo((Disk1TabletList[pcListIndex].Sensor1Time + Disk1TabletList[pcListIndex].Sensor1Length - sensor1startTime) / Zoom, pulseHighY);
		SensorImage1->Canvas->LineTo((Disk1TabletList[pcListIndex].Sensor1Time + Disk1TabletList[pcListIndex].Sensor1Length - sensor1startTime) / Zoom, pulseLowY);
		SensorImage_Match->Canvas->LineTo((Disk1TabletList[pcListIndex].Sensor1Time - sensor1startTime) / Zoom, pulseLowY);
		SensorImage_Match->Canvas->LineTo((Disk1TabletList[pcListIndex].Sensor1Time - sensor1startTime) / Zoom, pulseHighY);
		SensorImage_Match->Canvas->LineTo((Disk1TabletList[pcListIndex].Sensor1Time + Disk1TabletList[pcListIndex].Sensor1Length - sensor1startTime) / Zoom, pulseHighY);
		SensorImage_Match->Canvas->LineTo((Disk1TabletList[pcListIndex].Sensor1Time + Disk1TabletList[pcListIndex].Sensor1Length - sensor1startTime) / Zoom, pulseLowY);
		LastPosX = (Disk1TabletList[pcListIndex].Sensor1Time + Disk1TabletList[pcListIndex].Sensor1Length - sensor1startTime) / Zoom;
	}

	SensorImage2->Canvas->Pen->Color = clLime;
	SensorImage2->Canvas->MoveTo(0, pulseLowY);
	SensorImage_Match->Canvas->Pen->Color = clLime;
	SensorImage_Match->Canvas->Font->Color = clLime;
	SensorImage_Match->Canvas->MoveTo(0, pulseLowY);
	SensorImage_Ejection_Match->Canvas->Pen->Color = clLime;
	SensorImage_Ejection_Match->Canvas->MoveTo(0, pulseLowY);
	LastPosX = 0;
	for (int pcListIndex = 0; pcListIndex <= LastPCList2Index; pcListIndex++)
	{
		if (pcListIndex >= PC_TABLET_LONG_LIST_COUNT) break;
		if (Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length < sensor2startTime) continue;
		if (Disk2TabletList[pcListIndex].Sensor2Time > sensor2endTime)
		{
			if (LastPosX < SensorImage2->Width)
			{
				SensorImage2->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / Zoom, pulseLowY);
				SensorImage_Match->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / Zoom, pulseLowY);
				LastPosX = (Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / Zoom;
			}
			continue;
		}
		if (Disk2TabletList[pcListIndex].InspectionResult != TABLET_RESULT_DISAPPEARED)
		{
			SensorImage2->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / Zoom, pulseLowY);
			SensorImage2->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / Zoom, pulseHighY);
			SensorImage2->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / Zoom, pulseHighY);
			SensorImage2->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / Zoom, pulseLowY);

			SensorImage_Match->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / Zoom, pulseLowY);
			SensorImage_Match->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / Zoom, pulseHighY);
			SensorImage_Match->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / Zoom, pulseHighY);
			SensorImage_Match->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / Zoom, pulseLowY);

			SensorImage_Ejection_Match->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / Zoom, pulseLowY);
			SensorImage_Ejection_Match->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / Zoom, pulseHighY);
			SensorImage_Ejection_Match->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / Zoom, pulseHighY);
			SensorImage_Ejection_Match->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / Zoom, pulseLowY);

			LastPosX = (Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / Zoom;
		}
				
		AnsiString text;

		switch(Disk2TabletList[pcListIndex].InspectionResult)
		{
			case TABLET_RESULT_GOOD:
				text = "G";
				break;
			case TABLET_RESULT_DEFECT:
				text = "D";
				break;				
			case TABLET_RESULT_INSERTED:
				text = "I";
				break;
			case TABLET_RESULT_DISAPPEARED:
				text = "P";
				break;
			case TABLET_RESULT_CLOSED_UNINS:
				text = "E";
				break;
			case TABLET_RESULT_CLOSED_DEFECT:
				text = "L";
				break;
			case TABLET_RESULT_SENSOR_1_MISFEEDING:
			case TABLET_RESULT_SENSOR_2_MISFEEDING:
				text = "M/F";
				break;
			case TABLET_RESULT_MULTI_TABLET_SENSOR_1:
			case TABLET_RESULT_MULTI_TABLET_SENSOR_2:
				text = "C";
				break;
			case TABLET_RESULT_UNINTENDED_UNINSPECT:
			case TABLET_RESULT_UNINS_SPB_PROCESSING_NOT_COMPLETE:
				text = "U";
				break;
			default:
				text = "?";
				break;
		}
		if (Disk2TabletList[pcListIndex].InspectionResult != TABLET_RESULT_GOOD)
		{
			SensorImage_Match->Canvas->Font->Color = clFuchsia;
			SensorImage_Match->Canvas->TextOut((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / Zoom + 2, pulseHighY + textMargin, text);
			SensorImage_Match->Canvas->Font->Color = clLime;
		}
		else
		{
			SensorImage_Match->Canvas->TextOut((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / Zoom + 2, pulseHighY + textMargin, text);
		}
		SensorImage_Match->Canvas->MoveTo((Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / Zoom, pulseLowY);
	}


	SensorImage3->Canvas->Pen->Color = clFuchsia;
	SensorImage3->Canvas->MoveTo(0, pulseLowY);
	SensorImage_Ejection_Match->Canvas->Pen->Color = clFuchsia;
	SensorImage_Ejection_Match->Canvas->Font->Color = clFuchsia;
	SensorImage_Ejection_Match->Canvas->MoveTo(0, pulseLowY);
	LastPosX = 0;
	for (int pcListIndex = 0; pcListIndex <= LastPCList2Index; pcListIndex++)
	{
		if (pcListIndex >= PC_TABLET_LONG_LIST_COUNT) break;
		if (Disk2TabletList[pcListIndex].Sensor3Time + Disk2TabletList[pcListIndex].Sensor3Length < sensor3startTime) continue;
		if (Disk2TabletList[pcListIndex].Sensor3Time > sensor3endTime)
		{
			if (LastPosX < SensorImage3->Width)
			{
				SensorImage3->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor3Time - sensor3startTime) / Zoom, pulseLowY);
				SensorImage_Ejection_Match->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor3Time - sensor3startTime) / Zoom, pulseLowY);
				LastPosX = (Disk2TabletList[pcListIndex].Sensor3Time - sensor3startTime) / Zoom;
			}
			continue;
		}
		if (Disk2TabletList[pcListIndex].EjectionCheck == TABLET_EJECTION_CHECK_EXIST)
		{
			SensorImage3->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor3Time - sensor3startTime) / Zoom, pulseLowY);
			SensorImage3->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor3Time - sensor3startTime) / Zoom, pulseHighY);
			SensorImage3->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor3Time + Disk2TabletList[pcListIndex].Sensor3Length - sensor3startTime) / Zoom, pulseHighY);
			SensorImage3->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor3Time + Disk2TabletList[pcListIndex].Sensor3Length - sensor3startTime) / Zoom, pulseLowY);

			SensorImage_Ejection_Match->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor3Time - sensor3startTime) / Zoom, pulseLowY);
			SensorImage_Ejection_Match->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor3Time - sensor3startTime) / Zoom, pulseHighY);
			SensorImage_Ejection_Match->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor3Time + Disk2TabletList[pcListIndex].Sensor3Length - sensor3startTime) / Zoom, pulseHighY);
			SensorImage_Ejection_Match->Canvas->LineTo((Disk2TabletList[pcListIndex].Sensor3Time + Disk2TabletList[pcListIndex].Sensor3Length - sensor3startTime) / Zoom, pulseLowY);
			LastPosX = (Disk2TabletList[pcListIndex].Sensor3Time + Disk2TabletList[pcListIndex].Sensor3Length - sensor3startTime) / Zoom;
		}		
		AnsiString text;

		switch(Disk2TabletList[pcListIndex].InspectionResult)
		{
			case TABLET_RESULT_GOOD:
				text = "G";
				break;
			case TABLET_RESULT_DEFECT:
				text = "D";
				break;
			case TABLET_RESULT_INSERTED:
				text = "I";
				break;
			case TABLET_RESULT_DISAPPEARED:
				text = "P";
				break;
			case TABLET_RESULT_CLOSED_UNINS:
				text = "E";
				break;
			case TABLET_RESULT_CLOSED_DEFECT:
				text = "L";
				break;
			case TABLET_RESULT_SENSOR_1_MISFEEDING:
			case TABLET_RESULT_SENSOR_2_MISFEEDING:
				text = "M/F";
				break;
			case TABLET_RESULT_MULTI_TABLET_SENSOR_1:
			case TABLET_RESULT_MULTI_TABLET_SENSOR_2:
				text = "C";
				break;
			case TABLET_RESULT_UNINTENDED_UNINSPECT:
			case TABLET_RESULT_UNINS_SPB_PROCESSING_NOT_COMPLETE:
				text = "U";
				break;
			default:
				text = "?";
				break;
		}
		if (Disk2TabletList[pcListIndex].InspectionResult != TABLET_RESULT_GOOD)
		{
			SensorImage_Ejection_Match->Canvas->Font->Color = clFuchsia;
			SensorImage_Ejection_Match->Canvas->TextOut((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / Zoom + 2, pulseHighY + textMargin, text);
			SensorImage_Ejection_Match->Canvas->Font->Color = clLime;
		}
		else
		{
			SensorImage_Ejection_Match->Canvas->TextOut((Disk2TabletList[pcListIndex].Sensor2Time - sensor2startTime) / Zoom + 2, pulseHighY + textMargin, text);
		}
		SensorImage_Ejection_Match->Canvas->MoveTo((Disk2TabletList[pcListIndex].Sensor2Time + Disk2TabletList[pcListIndex].Sensor2Length - sensor2startTime) / Zoom, pulseLowY);
	}

}
//---------------------------------------------------------------------------

void __fastcall TNewTabletCounterForm::ViewingScrollBarScroll(
      TObject *Sender, TScrollCode ScrollCode, int &ScrollPos)
{
	ViewingLastTime = ViewingScrollBar->Position * Zoom;
	RefreshGraph();
}
//---------------------------------------------------------------------------
void __fastcall TNewTabletCounterForm::ZoomInButtonClick(TObject *Sender)
{
	Zoom = Zoom * 0.9;
	//Zoom--;
	if (Zoom < 1) Zoom = 1;
	if (StartHCBTime / Zoom < CurrentHCBTime / Zoom)
	{
		ViewingScrollBar->SetParams(ViewingLastTime / Zoom, StartHCBTime / Zoom, CurrentHCBTime / Zoom);
	}
	else
	{
		ViewingScrollBar->SetParams(0, 0, 1);
	}
	RefreshGraph();
}
//---------------------------------------------------------------------------
void __fastcall TNewTabletCounterForm::ZoomOutButtonClick(TObject *Sender)
{
	Zoom = Zoom * 1.1 + 1;
	if (StartHCBTime / Zoom < CurrentHCBTime / Zoom)
	{
		ViewingScrollBar->SetParams(ViewingLastTime / Zoom, StartHCBTime / Zoom, CurrentHCBTime / Zoom);
	}
	else
	{
		ViewingScrollBar->SetParams(0, 0, 1);
	}	
	//Zoom++;
	RefreshGraph();
}
//---------------------------------------------------------------------------
void __fastcall TNewTabletCounterForm::TimerStopButtonClick(
	  TObject *Sender)
{
	TabletInfoTimer->Enabled = false;
}
//---------------------------------------------------------------------------
void __fastcall TNewTabletCounterForm::StopButtonClick(TObject *Sender)
{
	Machine.MachineStop();
}
//---------------------------------------------------------------------------
void __fastcall TNewTabletCounterForm::CloseButtonClick(TObject *Sender)
{
	Comm_Request(COMM_HCB, CMD_INSPECTION_END);
	ModalResult = mrCancel;
	this->Close();	
}
//---------------------------------------------------------------------------
void __fastcall TNewTabletCounterForm::VFRunSpeedButtonClick(
      TObject *Sender)
{
	try
	{
		int vfSpeed = StrToInt(VFSpeedEdit->Text);
		Machine.VFRun(vfSpeed);
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------
void __fastcall TNewTabletCounterForm::VFStopSpeedButtonClick(
      TObject *Sender)
{
	Machine.VFStop();
}
//---------------------------------------------------------------------------
void __fastcall TNewTabletCounterForm::VFAutoSpeedButtonClick(
      TObject *Sender)
{
	Machine.VFRun_AutoControl(ProductData.MachineRunOption.MaxSpeedTrainingMode, ProductData.MachineRunOption.ManualMaxSpeed, ProductData.MachineRunOption.ManualModeSensorIndex,
    	ProductData.MachineRunOption.ManualModeSensorActiveRatio, ProductData.MachineRunOption.EmptySensorActiveRatio, ProductData.MachineRunOption.FullSensorActiveRatio);
}
//---------------------------------------------------------------------------
void __fastcall TNewTabletCounterForm::AirKnifeOnSpeedButtonClick(
	  TObject *Sender)
{
	Machine.BowlFeederAKSpeedChange(ProductData.MachineRunOption.AirKnifeSpeed);
}
//---------------------------------------------------------------------------
void __fastcall TNewTabletCounterForm::AirKnifeOffSpeedButtonClick(
      TObject *Sender)
{
	Machine.BowlFeederAKSpeedChange(0);
}
//---------------------------------------------------------------------------
void __fastcall TNewTabletCounterForm::NumEditClick(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
    if (KeyboardForm->ShowKeypad() == mrOk)
    {
		theEdit->Text = KeyboardForm->Text;
    }	
}
//---------------------------------------------------------------------------

