//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "PrintAuditTrail_Ajanta_Form.h"
#include "Environment.h"    
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TPrintAuditTrail_Ajanta_Form *PrintAuditTrail_Ajanta_Form;
//---------------------------------------------------------------------------
__fastcall TPrintAuditTrail_Ajanta_Form::TPrintAuditTrail_Ajanta_Form(TComponent* Owner)
    : TForm(Owner)
{
  // Init
  for (int rIndex = 1; rIndex < 16; rIndex++)
  {
      ((TQRLabel*)FindComponent("EOMLabel" + IntToStr(rIndex)))->Caption = "";
      ((TQRLabel*)FindComponent("UserMLabel" + IntToStr(rIndex)))->Caption = "";
      ((TQRLabel*)FindComponent("MemoMLabel" + IntToStr(rIndex)))->Caption = "";
  }
  
  for (int rIndex = 1; rIndex < 26; rIndex++)
  {
      ((TQRLabel*)FindComponent("EOLabel" + IntToStr(rIndex)))->Caption = "";
      ((TQRLabel*)FindComponent("UserLabel" + IntToStr(rIndex)))->Caption = "";
      ((TQRLabel*)FindComponent("MemoLabel" + IntToStr(rIndex)))->Caption = "";
  }

    TntButton2->Caption = V6_REPORT_PRINT_FORM_ADD_04;
    TntButton3->Caption = V6_REPORT_PRINT_FORM_ADD_05;
    TntButton1->Caption = V6_REPORT_PRINT_FORM_ADD_06;
    TntButton4->Caption = V6_REPORT_PRINT_FORM_ADD_07;

    GroupBox1->Caption = AUDITTRAILFORM_STRGRID_CELL_12;
}
//---------------------------------------------------------------------------
void __fastcall TPrintAuditTrail_Ajanta_Form::SetReport(TCSVLogList* csvList, int nValidData, bool bAction, bool bEvent, bool bAlarm, double StartTime, double EndTime, int stLogIndex, int edLogIndex, bool bLimit,AnsiString ProductName , AnsiString CreatorName)
{
	int FirstPageDataCnt = 0;
	int SecPageDataCnt = 0;
	int QRShapeMV_Height = 0;
  int QRShapeV_Height = 0;
	TQRShape* pQRShapeMV = NULL;
  TQRShape* pQRShapeV = NULL;
	TQRShape* pQRShapeMH = NULL;
	TQRShape* pQRShapeH = NULL;    
	
  if (csvList->DataCount <= 0)
    return;
  if (nValidData <= 0)
    return;
    
  allPageDataCnt = nValidData;

  QRNameofmachine->Caption = PCProgramOption.Nameofmachine.c_bstr();
  QRMachineID->Caption = PCProgramOption.MachineID.c_bstr();
  QRStartDateTime->Caption = ((TDateTime)StartTime).FormatString("DD/MM/YYYY    HH:MM:SS");
  QREndDateTime->Caption = ((TDateTime)EndTime).FormatString("DD/MM/YYYY    HH:MM:SS");
  
  if(ProductName =="")
    QRProductCode->Caption = "Target All Products";
  else
    QRProductCode->Caption = ProductName;

  if(CreatorName =="")
    QROperator->Caption = "Target All Operators";
  else
    QROperator->Caption = CreatorName;



  if (bAlarm)
  {
    PrintTitleLabel->Caption = "Alarm's Report";
    PrintTitleLabel2->Caption = "Alarm's Report";
    EventTitleLabel->Caption = "Alarm Occurrence";
    EventTitleLabel2->Caption = "Alarm Occurrence";
    ContentTitleLabel->Caption = "Alarm Name";
    ContentTitleLabel2->Caption = "Alarm Name";

    UserTitleLabel->Visible = false;
    UserTitleLabel->Enabled = false;
    QRShapeMV3->Visible = false;
    QRShapeMV3->Enabled = false;
  }
  else
  {
    UserTitleLabel->Visible = true;
    UserTitleLabel->Enabled = true;
    QRShapeMV3->Visible = true;
    QRShapeMV3->Enabled = true;
  }

  if (nValidData > 15)
  {
    PageNum++;
    PageNum += ((float)nValidData-15.0f) /25.0f;

    if ((nValidData-15) % 25)
      PageNum++;
      
    // 0 ⺻  
    CreateReportPage(PageNum,bAlarm);
    UpDown1->Min = 1;
    UpDown1->Max = PageNum;
    UpDown1->Position = 1;
    UpDown1->Enabled = true;
    ReportPageLabel->Caption = "1 / " + IntToStr(UpDown1->Max);
  }
  else
   PageNum = 1;

  if(PCProgramOption.AjantaLocalNameNum == 1)
  {
    for(int i = 1 ; i <= PageNum ; ++i)
    {
      ((TQRLabel*)FindComponent("PrintCompanyLabel" + IntToStr(i)))->Caption = "AJANTA PHARMA LIMITED - PAITHAN";
    }
  }

  QRLabel1->Caption = UserInfo.Name;

  TDateTime DateOfPrint;
  TDateTime TimeOfPrint;
  DateOfPrint = TDateTime::CurrentDate();
  TimeOfPrint = TDateTime::CurrentTime();
  // Main Date & Time , Page
  QRLabel82->Caption =  DateOfPrint.FormatString("DD/MM/YYYY") + "  " + TimeOfPrint.FormatString("HH:MM:SS");
  QRLabel74->Caption =  IntToStr(1) + " of " + IntToStr(PageNum);
  // Foot Section Date&Time , Page
  for(int i = 1; i < PageNum ; ++i)
  {
    ((TQRLabel*)FindComponent("RepGenUserNameValueLabel" + IntToStr(i)))->Caption = UserInfo.Name;
    ((TQRLabel*)FindComponent("RepGenDateValueLabel" + IntToStr(i)))->Caption = DateOfPrint.FormatString("DD/MM/YYYY") + "  " + TimeOfPrint.FormatString("HH:MM:SS");
    ((TQRLabel*)FindComponent("RepGenPageValueLabel" + IntToStr(i)))->Caption = IntToStr(i + 1) + " of " + IntToStr(PageNum);
  }

  unsigned short year, month, day;
  unsigned short hour, min, sec, msec;
  TDateTime(ProductData.LastInspectionTime).DecodeDate(&year, &month, &day);
  TDateTime(ProductData.LastInspectionTime).DecodeTime(&hour, &min, &sec, &msec);

  int dataCount = csvList->DataCount;

  int DataCount=0;
  int index = 0;

  for (int dataIndex = 0; dataIndex < dataCount; dataIndex++)
  {
    if (!bLimit || (bLimit && dataIndex >= stLogIndex && dataIndex <= edLogIndex))
    {
      bool dataValid = true;

      ECSVLogKind kind = csvList->GetKind(dataIndex);
      if ((kind == ECSV_LOG_KIND_EVENT && bEvent) ||
        (kind == ECSV_LOG_KIND_ACTION && bAction))
      {
        dataValid = true;
      }
      else
      {
        dataValid = false;
      }

      if (bAlarm)
      {
        if (kind == ECSV_LOG_KIND_ACTION)
        {
          dataValid = false;
        }

        if (kind == ECSV_LOG_KIND_EVENT)
        {
          ECSVEvent temp = csvList->GetEventKind(dataIndex);
          if (temp != ECSV_EVENT_ALARM && temp != ECSV_EVENT_ALARM_CLEAR)
          {
            dataValid = false;
          }
        }
      }

      TDateTime date = csvList->GetTimeInfo(dataIndex);
      double diffStart, diffEnd;
      diffStart = StartTime - date;
      if (diffStart > 0)
        dataValid = false;

      diffEnd = date - EndTime;
      if (diffEnd > 0)
        dataValid = false;

      if(DataCount>=nValidData) break;

      if (ProductName != "")
			{
        AnsiString Name = csvList->GetProductName(dataIndex);
        int n_Length = Name.Length();
        if(n_Length == 0)
        {
          dataValid = false;
        }
        else
        {
          int p_Length = ProductName.Length();
          if(p_Length == n_Length)
          {
            if(ProductName.LowerCase() == Name.LowerCase())
              dataValid = true;
            else
              dataValid = false;
          }
          else
          {
            int p_nameIndex = 0;
            for(int i = 0; i < n_Length; ++i)
            {
              if(p_nameIndex > p_Length) p_nameIndex -= 1;
              if(p_nameIndex > 0 && Name.LowerCase().c_str()[i]!= ProductName.LowerCase().c_str()[p_nameIndex])
              {
                dataValid = false;
                break;
              }

              if(Name.LowerCase().c_str()[i]== ProductName.LowerCase().c_str()[p_nameIndex])
                p_nameIndex++;
            }

            if(p_nameIndex == p_Length)
            {
              dataValid = true;
            }
            else
              dataValid = false;
          }
        }

			}
      if(dataValid == true)
      {
        if (CreatorName != "")
        {
          AnsiString Name = csvList->GetCreatorName(dataIndex);
          int n_Length = Name.Length();
          if(Name == 0)
          {
            dataValid = false;
          }
          else
          {
            int c_Length = CreatorName.Length();
            if(c_Length == n_Length)
            {
              if(CreatorName.LowerCase() == Name.LowerCase())
                dataValid = true;
              else
                dataValid = false;
            }
            else
            {
              int c_nameIndex = 0;
              for(int i = 0; i < n_Length; ++i)
              {
                if(c_nameIndex > c_Length) c_nameIndex -= 1;
                if(c_nameIndex > 0 && Name.LowerCase().c_str()[i] != CreatorName.LowerCase().c_str()[c_nameIndex])
                {
                  dataValid = false;
                  break;
                }

                if(Name.LowerCase().c_str()[i] == CreatorName.LowerCase().c_str()[c_nameIndex])
                  c_nameIndex++;
              }

              if(c_nameIndex == c_Length)
                dataValid = true;
              else
                dataValid = false;
            }
          }

        }
      }

      if (dataValid)
      {
        int RealMemoWidth ;
        
        DataCount++;

        if(DataCount <=15)
        {
          ((TQRLabel*)FindComponent("EOMLabel" + IntToStr(index + 1)))->Caption = csvList->GetTimeStr(dataIndex);
          ((TQRLabel*)FindComponent("UserMLabel" + IntToStr(index + 1)))->Caption = csvList->GetCreatorName(dataIndex);
          ((TQRLabel*)FindComponent("MemoMLabel" + IntToStr(index + 1)))->Caption = csvList->GetMessage(dataIndex);
          RealMemoWidth = ((TQRLabel*)FindComponent("MemoMLabel" + IntToStr(index + 1)))->Width;        
        }
        else
        {
          ((TQRLabel*)FindComponent("EOLabel" + IntToStr(index - 15 + 1)))->Caption = csvList->GetTimeStr(dataIndex);
          ((TQRLabel*)FindComponent("UserLabel" + IntToStr(index - 15 + 1)))->Caption = csvList->GetCreatorName(dataIndex);
          ((TQRLabel*)FindComponent("MemoLabel" + IntToStr(index - 15 + 1)))->Caption = csvList->GetMessage(dataIndex);
          RealMemoWidth =((TQRLabel*)FindComponent("MemoLabel" + IntToStr(index - 15 + 1)))->Width;
        }

        const int validWidth = 436;
        if( RealMemoWidth > validWidth)
        {
          TQRLabel *dstLabel = ((TQRLabel*)FindComponent("MemoLabel" + IntToStr(index + 1)));
          dstLabel->Caption = "";

          AnsiString tmpStr = csvList->GetMessage(dataIndex);
          AnsiString applyText = "";
          int textString = tmpStr.Length();

          char *strBuff = new char[textString + 1];
          memset(strBuff, 0, sizeof(char) * textString + 1);
          strcpy(strBuff, tmpStr.c_str());

          int StringOverflowCount = 0;
          for(int strLength = 0; strLength < textString; strLength++)
          {
            if(strBuff[strLength] & 0x80)
            {
              applyText += strBuff[strLength];
              applyText += strBuff[strLength+1];
              ++strLength;
            }
            else
            {
              applyText += strBuff[strLength];
            }

            dstLabel->Caption = applyText;

            if(dstLabel->Width > validWidth)
            {
              StringOverflowCount++;
              if(StringOverflowCount > 1) break;

              applyText.Insert("\r\n", strLength);
            }
          }

          delete strBuff;

          dstLabel->Caption = applyText;
          dstLabel->Top -= 5;
          dstLabel->Height += 11;
        }
        index++;
      }
    }
  }

	if(allPageDataCnt < MAX_FIRST_PAGE_DATA_CNT)
	{
		QRShapeMV_Height = allPageDataCnt * HEIGHT_CHART_ROW + HEIGHT_CHART_ROW;
	}
	else
	{
		QRShapeMV_Height = MAX_FIRST_PAGE_DATA_CNT * HEIGHT_CHART_ROW + HEIGHT_CHART_ROW;

		SecPageDataCnt = allPageDataCnt - MAX_FIRST_PAGE_DATA_CNT;

    if(SecPageDataCnt < MAX_PAGE_DATA_CNT)
    {
      QRShapeV_Height = SecPageDataCnt * HEIGHT_CHART_ROW + HEIGHT_CHART_ROW;
    }
    else
    {
      QRShapeV_Height = MAX_PAGE_DATA_CNT * HEIGHT_CHART_ROW + HEIGHT_CHART_ROW;
    }
	}

	for(index = 0; index < 4; index++)
	{
		pQRShapeMV = ((TQRShape*)FindComponent("QRShapeMV" + IntToStr(index + 1)));
    pQRShapeMV->Height = QRShapeMV_Height;
	}

	for(index = 0; index < 17; index++)
	{
		pQRShapeMH = ((TQRShape*)FindComponent("QRShapeMH" + IntToStr(index + 1)));

		if((allPageDataCnt > 0) && (allPageDataCnt < MAX_FIRST_PAGE_DATA_CNT))
		{
			if(index > (allPageDataCnt+1))
			{
				pQRShapeMH->Visible = false;
				pQRShapeMH->Enabled = false;
			}
		}
	}

	for(index = 0; index < 4; index++)
	{
		pQRShapeV = ((TQRShape*)FindComponent("QRShapeV" + IntToStr(index + 1)));
    pQRShapeV->Height = QRShapeV_Height;
	}

	for(index = 0; index < 27; index++)
	{
		pQRShapeH = ((TQRShape*)FindComponent("QRShapeH" + IntToStr(index + 1)));

		if((SecPageDataCnt > 0) && (SecPageDataCnt < MAX_PAGE_DATA_CNT))
		{
			if(index > (SecPageDataCnt+1))
			{
				pQRShapeH->Visible = false;
				pQRShapeH->Enabled = false;
			}
		}
	}
  
  SubRep1->BringToFront();
}
//---------------------------------------------------------------------------
void __fastcall TPrintAuditTrail_Ajanta_Form::TntButton1Click(TObject *Sender)
{
  QRCompositeReport->Print();
}
//---------------------------------------------------------------------------

void __fastcall TPrintAuditTrail_Ajanta_Form::TntButton3Click(TObject *Sender)
{
    QRCompositeReport->PrinterSetup();
}
//---------------------------------------------------------------------------

void __fastcall TPrintAuditTrail_Ajanta_Form::TntButton2Click(TObject *Sender)
{
    QRCompositeReport->Preview();
}
//---------------------------------------------------------------------------

void __fastcall TPrintAuditTrail_Ajanta_Form::TntButton4Click(TObject *Sender)
{
    int index, cnt, componentIdx;

    for(index = 1; index <= PageNum; index++)
    {
        //frame 
        for(cnt = 0; cnt<7; cnt++)
        {
            componentIdx = 1 + index * 33 + cnt;
            TQRShape *pFrame = (TQRShape*)FindComponent("QRShape" + IntToStr(componentIdx));
            delete pFrame;
        }

        // Frame 
        for (cnt = 0; cnt < 23; cnt++)
        {
            componentIdx = 1 + 7 + index * 33 + cnt;
            TQRShape *pFrame = (TQRShape*)FindComponent("QRShape" + IntToStr(componentIdx));
            delete  pFrame;
        }

        // Title label
        for (cnt = 1; cnt < 7; cnt++)
        {
            componentIdx = 1 + index * 7 + cnt;
            TQRLabel *pLabel = (TQRLabel*)FindComponent("QRLabel" + IntToStr(componentIdx));
            delete pLabel;
        }

         // Label 
        for (cnt = 0; cnt < 21; cnt++)
        {
            componentIdx = index * 24 - 1 + cnt;
            TQRLabel *pLabel;
            //No.
            pLabel = (TQRLabel*)FindComponent("NoLabel" + IntToStr(componentIdx));
            delete pLabel;

            //type
            pLabel = (TQRLabel*)FindComponent("TypeLabel" + IntToStr(componentIdx));
            delete pLabel;

            //Time
            pLabel = (TQRLabel*)FindComponent("TimeLabel1" + IntToStr(componentIdx));
            delete pLabel;

            //User
            pLabel = (TQRLabel*)FindComponent("UserLabel1" + IntToStr(componentIdx));
            delete pLabel;

            //Qname
            pLabel = (TQRLabel*)FindComponent("QnameLabel1" + IntToStr(componentIdx));
            delete pLabel;

            //Memo
            pLabel = (TQRLabel*)FindComponent("MemoLabel1" + IntToStr(componentIdx));
            delete pLabel;
        }

        //signature
        for(cnt = 0; cnt < 7; cnt++)
        {
            componentIdx = 1 + index * 7 + cnt;
            TQRLabel *pLabel;
            pLabel = pLabel = (TQRLabel*)FindComponent("QRLabelBottom" + IntToStr(componentIdx));
            delete pLabel;
        }

        // QRBand
        TQRBand *pBand = (TQRBand*)FindComponent("SummaryBand" + IntToStr(index + 1));
        delete pBand;

        //Report
        TQuickRep *pQR = (TQuickRep*)FindComponent("QuickRep" + IntToStr(index + 1));
        delete pQR;
    }

    this->Close();
}
//---------------------------------------------------------------------------

void __fastcall TPrintAuditTrail_Ajanta_Form::CreateReportPage(int dataCnt,bool FormStyle) 
{
   int newPageIndex, endPage;
    int FrameIndex, tempComponentIndex;

    int endPageDataCnt = 0;

    endPage = dataCnt;

    //Panel2->DoubleBuffered = true;
    
    for(newPageIndex = 3; newPageIndex <= endPage; newPageIndex++)
    {
        //Report
        TQuickRep *pQR = new TQuickRep(this);
        pQR->Name = "SubRep" + IntToStr(newPageIndex);
        pQR->Parent = Panel2;
        pQR->Left = SubRep2->Left;
        pQR->Top = SubRep2->Top;
        pQR->Width = SubRep2->Width;
        pQR->Height = SubRep2->Height;

        //Title QRBand
        TQRBand *pQRBand1 = new TQRBand(this);
        pQRBand1->Parent = pQR;
        pQRBand1->Name = "TitleBand" + IntToStr(newPageIndex);
        pQRBand1->Left = TitleBand1->Left;
        pQRBand1->Top = TitleBand1->Top;
        pQRBand1->Width = TitleBand1->Width;
        pQRBand1->Height = TitleBand1->Height;
        pQRBand1->BandType = TitleBand1->BandType;

        // Company label , Title Label
        {
            TQRLabel *pQRLabel = new TQRLabel(this);
            TQRLabel *pSrcLabel = (TQRLabel*)FindComponent("PrintCompanyLabel2");
            pQRLabel->Parent = pQRBand1;
            pQRLabel->Name = "PrintCompanyLabel" + IntToStr(newPageIndex);
            pQRLabel->AutoSize = false;
            pQRLabel->Left = pSrcLabel->Left;
            pQRLabel->Top = pSrcLabel->Top;
            pQRLabel->Width = pSrcLabel->Width;
            pQRLabel->Height = pSrcLabel->Height;
            pQRLabel->Caption = pSrcLabel->Caption;
            pQRLabel->Font = pSrcLabel->Font;
            pQRLabel->Alignment = pSrcLabel->Alignment;
        }
        {
            TQRLabel *pQRLabel = new TQRLabel(this);
            TQRLabel *pSrcLabel = (TQRLabel*)FindComponent("PrintTitleLabel2");
            pQRLabel->Parent = pQRBand1;
            pQRLabel->Name = "PrintTitleLabel" + IntToStr(newPageIndex);
            pQRLabel->AutoSize = false;
            pQRLabel->Left = pSrcLabel->Left;
            pQRLabel->Top = pSrcLabel->Top;
            pQRLabel->Width = pSrcLabel->Width;
            pQRLabel->Height = pSrcLabel->Height;
            pQRLabel->Caption = pSrcLabel->Caption;
            pQRLabel->Font = pSrcLabel->Font;
            pQRLabel->Alignment = pSrcLabel->Alignment;
        }

        //////////////////////////////////////////////////////////////////////

        //Summary QRBand
        TQRBand *pQRBand2 = new TQRBand(this);
        pQRBand2->Parent = pQR;
        pQRBand2->Name = "SummaryBand" + IntToStr(newPageIndex);
        pQRBand2->Left = SummaryBand1->Left;
        pQRBand2->Top = SummaryBand1->Top;
        pQRBand2->Width = SummaryBand1->Width;
        pQRBand2->Height = SummaryBand1->Height;
        pQRBand2->BandType = SummaryBand1->BandType;

        // Frame 
        for (FrameIndex = 0; FrameIndex < 4; FrameIndex++)
        {
            tempComponentIndex = 1 + ((newPageIndex-2) * 4) + FrameIndex;
            TQRShape *pBaseFrame = new TQRShape(this);
            TQRShape *pSrcFrame = (TQRShape*)FindComponent("QRShapeV" + IntToStr(FrameIndex + 1));
            pBaseFrame->Parent = pQRBand2;
            pBaseFrame->Name = "QRShapeV" + IntToStr(tempComponentIndex);
            pBaseFrame->Left = pSrcFrame->Left;
            pBaseFrame->Top = pSrcFrame->Top;//50;//pSrcFrame->Top;
            pBaseFrame->Width = pSrcFrame->Width;
            pBaseFrame->Height = pSrcFrame->Height;//880;//pSrcFrame->Height;
            if(newPageIndex == endPage)
            {
            	  endPageDataCnt = (allPageDataCnt - MAX_FIRST_PAGE_DATA_CNT) % MAX_PAGE_DATA_CNT;
                if(endPageDataCnt > 0)
                {
            	    pBaseFrame->Height = endPageDataCnt * HEIGHT_CHART_ROW + HEIGHT_CHART_ROW;
                }
                else
                {
                  pBaseFrame->Height = MAX_PAGE_DATA_CNT * HEIGHT_CHART_ROW + HEIGHT_CHART_ROW;
                }
            }
            pBaseFrame->Shape = pSrcFrame->Shape;
            pBaseFrame->Enabled = pSrcFrame->Enabled;
            pBaseFrame->Cursor = pSrcFrame->Cursor;

            pBaseFrame->Frame->Color = pSrcFrame->Frame->Color;
            pBaseFrame->Frame->DrawBottom = pSrcFrame->Frame->DrawBottom;
            pBaseFrame->Frame->DrawLeft = pSrcFrame->Frame->DrawLeft;
            pBaseFrame->Frame->DrawRight = pSrcFrame->Frame->DrawRight;
            pBaseFrame->Frame->DrawTop = pSrcFrame->Frame->DrawTop;
            pBaseFrame->Frame->Style = pSrcFrame->Frame->Style;
            pBaseFrame->Frame->Width = pSrcFrame->Frame->Width;

            pBaseFrame->Brush->Color = pSrcFrame->Brush->Color;
            pBaseFrame->Brush->Style = pSrcFrame->Brush->Style;

            pBaseFrame->Pen->Color = pSrcFrame->Pen->Color;
            pBaseFrame->Pen->Mode = pSrcFrame->Pen->Mode;
            pBaseFrame->Pen->Style = pSrcFrame->Pen->Style;
            pBaseFrame->Pen->Width = pSrcFrame->Pen->Width;
        }

        // Frame 
        for (FrameIndex = 0; FrameIndex < 27; FrameIndex++)
        {
            tempComponentIndex = 1 +(newPageIndex * 27) + FrameIndex;

            TQRShape *pBaseFrame = new TQRShape(this);
            TQRShape *pSrcFrame = (TQRShape*)FindComponent("QRShapeH" + IntToStr(FrameIndex + 1));
            pBaseFrame->Parent = pQRBand2;
            pBaseFrame->Name = "QRShapeH" + IntToStr(tempComponentIndex);
            pBaseFrame->Left = pSrcFrame->Left; //0;
            pBaseFrame->Top = pSrcFrame->Top;//50 + 40 * FrameIndex;//pSrcFrame->Top;
            pBaseFrame->Width = pSrcFrame->Width;
            pBaseFrame->Height = pSrcFrame->Height;//1;//pSrcFrame->Height;
            pBaseFrame->Shape = pSrcFrame->Shape;
            pBaseFrame->Enabled = pSrcFrame->Enabled;
            pBaseFrame->Cursor = pSrcFrame->Cursor;

            pBaseFrame->Frame->Color = pSrcFrame->Frame->Color;
            pBaseFrame->Frame->DrawBottom = pSrcFrame->Frame->DrawBottom;
            pBaseFrame->Frame->DrawLeft = pSrcFrame->Frame->DrawLeft;
            pBaseFrame->Frame->DrawRight = pSrcFrame->Frame->DrawRight;
            pBaseFrame->Frame->DrawTop = pSrcFrame->Frame->DrawTop;
            pBaseFrame->Frame->Style = pSrcFrame->Frame->Style;
            pBaseFrame->Frame->Width = pSrcFrame->Frame->Width;

            pBaseFrame->Brush->Color = pSrcFrame->Brush->Color;
            pBaseFrame->Brush->Style = pSrcFrame->Brush->Style;

            pBaseFrame->Pen->Color = pSrcFrame->Pen->Color;
            pBaseFrame->Pen->Mode = pSrcFrame->Pen->Mode;
            pBaseFrame->Pen->Style = pSrcFrame->Pen->Style;
            pBaseFrame->Pen->Width = pSrcFrame->Pen->Width;

            if(newPageIndex == endPage)
            {
            	  endPageDataCnt = (allPageDataCnt - MAX_FIRST_PAGE_DATA_CNT) % MAX_PAGE_DATA_CNT;

                if(endPageDataCnt > 0)
                {
                  if(FrameIndex > (endPageDataCnt+1))
                  {
            	      pBaseFrame->Visible = false;
            	      pBaseFrame->Enabled = false;
                  }
                }
            }            
        }       

        // Content Title label
        {
          TQRLabel *pQRLabel = new TQRLabel(this);
          TQRLabel *pSrcLabel = (TQRLabel*)FindComponent("EventTitleLabel2");
          pQRLabel->Parent = pQRBand2;
          pQRLabel->Name = "EventTitleLabel" + IntToStr(newPageIndex);
          pQRLabel->AutoSize = pSrcLabel->AutoSize;
          pQRLabel->Left = pSrcLabel->Left;
          pQRLabel->Top = pSrcLabel->Top;
          pQRLabel->Width = pSrcLabel->Width;
          pQRLabel->Height = pSrcLabel->Height;
          pQRLabel->Caption = pSrcLabel->Caption;
          pQRLabel->Font = pSrcLabel->Font;
          pQRLabel->Alignment = pSrcLabel->Alignment;

          TQRLabel *pQRLabel2 = new TQRLabel(this);
          TQRLabel *pSrcLabel2 = (TQRLabel*)FindComponent("ContentTitleLabel2");
          pQRLabel2->Parent = pQRBand2;
          pQRLabel2->Name = "ContentTitleLabel" + IntToStr(newPageIndex);
          pQRLabel2->AutoSize = pSrcLabel2->AutoSize;
          pQRLabel2->Left = pSrcLabel2->Left;
          pQRLabel2->Top = pSrcLabel2->Top;
          pQRLabel2->Width = pSrcLabel2->Width;
          pQRLabel2->Height = pSrcLabel2->Height;
          pQRLabel2->Caption = pSrcLabel2->Caption;
          pQRLabel2->Font = pSrcLabel2->Font;
          pQRLabel2->Alignment = pSrcLabel2->Alignment;

          TQRLabel *pQRLabel3 = new TQRLabel(this);
          TQRLabel *pSrcLabel3 = (TQRLabel*)FindComponent("UserTitleLabel2");
          pQRLabel3->Parent = pQRBand2;
          pQRLabel3->Name = "UserTitleLabel" + IntToStr(newPageIndex);
          pQRLabel3->AutoSize = pSrcLabel3->AutoSize;
          pQRLabel3->Left = pSrcLabel3->Left;
          pQRLabel3->Top = pSrcLabel3->Top;
          pQRLabel3->Width = pSrcLabel3->Width;
          pQRLabel3->Height = pSrcLabel3->Height;
          pQRLabel3->Caption = pSrcLabel3->Caption;
          pQRLabel3->Font = pSrcLabel3->Font;
          pQRLabel3->Alignment = pSrcLabel3->Alignment;
        }

        
        //  Label 
        for (FrameIndex = 0; FrameIndex < 25; FrameIndex++)
        {
            tempComponentIndex = 1+ (newPageIndex-2) * 25 + FrameIndex;
            TQRLabel *pSrcLabel;

            TQRLabel *pQREOLabel = new TQRLabel(this);
            pSrcLabel = (TQRLabel*)FindComponent("EOLabel"+ IntToStr(FrameIndex+1));
            pQREOLabel->Parent = pQRBand2;
            pQREOLabel->Name = "EOLabel" + IntToStr(tempComponentIndex);
            pQREOLabel->Left = pSrcLabel->Left;
            pQREOLabel->Top = pSrcLabel->Top;
            pQREOLabel->Width = pSrcLabel->Width;
            pQREOLabel->Height = pSrcLabel->Height;
            pQREOLabel->Caption = "";
            pQREOLabel->Font = pSrcLabel->Font;
            pQREOLabel->Alignment = pSrcLabel->Alignment;
            pQREOLabel->AutoSize = pSrcLabel->AutoSize;

            TQRLabel *pQRMemoLabel = new TQRLabel(this);
            pSrcLabel = (TQRLabel*)FindComponent("MemoLabel"+ IntToStr(FrameIndex+1));
            pQRMemoLabel->Parent = pQRBand2;
            pQRMemoLabel->Name = "MemoLabel" + IntToStr(tempComponentIndex);
            pQRMemoLabel->Left = pSrcLabel->Left;
            pQRMemoLabel->Top =pSrcLabel->Top;
            pQRMemoLabel->Width = pSrcLabel->Width;
            pQRMemoLabel->Height = pSrcLabel->Height;
            pQRMemoLabel->Caption = "";
            pQRMemoLabel->Font = pSrcLabel->Font;
            pQRMemoLabel->Alignment = pSrcLabel->Alignment;
            pQRMemoLabel->AutoSize = pSrcLabel->AutoSize;

            TQRLabel *pQRUserLabel = new TQRLabel(this);
            pSrcLabel = (TQRLabel*)FindComponent("UserLabel"+ IntToStr(FrameIndex+1));
            pQRUserLabel->Parent = pQRBand2;
            pQRUserLabel->Name = "UserLabel" + IntToStr(tempComponentIndex);
            pQRUserLabel->Left = pSrcLabel->Left;
            pQRUserLabel->Top = pSrcLabel->Top;
            pQRUserLabel->Width = pSrcLabel->Width;
            pQRUserLabel->Height = pSrcLabel->Height;
            pQRUserLabel->Caption = "";
            pQRUserLabel->Font = pSrcLabel->Font;
            pQRUserLabel->Alignment = pSrcLabel->Alignment;
            pQRUserLabel->AutoSize = pSrcLabel->AutoSize;

        }
        // Foot
        {
          tempComponentIndex = (newPageIndex-1) * 3;
          //TQRLabel *pQRLabel = new TQRLabel(this);
          TQRLabel *pSrcLabel;

          TQRLabel *pQRRepGenUserLabel = new TQRLabel(this);
          pSrcLabel = (TQRLabel*)FindComponent("RepGenUserLabel1");
          pQRRepGenUserLabel->Parent = pQRBand2;
          pQRRepGenUserLabel->Name = "RepGenUserLabel" + IntToStr(tempComponentIndex);
          pQRRepGenUserLabel->Left = pSrcLabel->Left;
          pQRRepGenUserLabel->Top = pSrcLabel->Top;
          pQRRepGenUserLabel->Width = pSrcLabel->Width;
          pQRRepGenUserLabel->Height = pSrcLabel->Height;
          pQRRepGenUserLabel->Caption = pSrcLabel->Caption;
          pQRRepGenUserLabel->Font = pSrcLabel->Font;
          pQRRepGenUserLabel->Alignment = pSrcLabel->Alignment;
          pQRRepGenUserLabel->AutoSize = pSrcLabel->AutoSize;

          TQRLabel *pQRRepGenDateLabel = new TQRLabel(this);
          pSrcLabel = (TQRLabel*)FindComponent("RepGenDateLabel1");
          pQRRepGenDateLabel->Parent = pQRBand2;
          pQRRepGenDateLabel->Name = "RepGenDateLabel" + IntToStr(tempComponentIndex);
          pQRRepGenDateLabel->Left = pSrcLabel->Left;
          pQRRepGenDateLabel->Top =pSrcLabel->Top;
          pQRRepGenDateLabel->Width = pSrcLabel->Width;
          pQRRepGenDateLabel->Height = pSrcLabel->Height;
          pQRRepGenDateLabel->Caption = pSrcLabel->Caption;
          pQRRepGenDateLabel->Font = pSrcLabel->Font;
          pQRRepGenDateLabel->Alignment = pSrcLabel->Alignment;
          pQRRepGenDateLabel->AutoSize = pSrcLabel->AutoSize;

          TQRLabel *pQRRepGenPageLabel = new TQRLabel(this);
          pSrcLabel = (TQRLabel*)FindComponent("RepGenPageLabel1");
          pQRRepGenPageLabel->Parent = pQRBand2;
          pQRRepGenPageLabel->Name = "RepGenPageLabel" + IntToStr(tempComponentIndex);
          pQRRepGenPageLabel->Left = pSrcLabel->Left;
          pQRRepGenPageLabel->Top = pSrcLabel->Top;
          pQRRepGenPageLabel->Width = pSrcLabel->Width;
          pQRRepGenPageLabel->Height = pSrcLabel->Height;
          pQRRepGenPageLabel->Caption = pSrcLabel->Caption;
          pQRRepGenPageLabel->Font = pSrcLabel->Font;
          pQRRepGenPageLabel->Alignment = pSrcLabel->Alignment;
          pQRRepGenPageLabel->AutoSize = pSrcLabel->AutoSize;
        }

        // Date , Page x of y
        {
           // Date
          TQRLabel *pSrcLabel;
          tempComponentIndex = newPageIndex-1;
          TQRLabel *pQRRepGenUserNameValueLabel = new TQRLabel(this);
          pSrcLabel = (TQRLabel*)FindComponent("RepGenUserNameValueLabel1");
          pQRRepGenUserNameValueLabel->Parent = pQRBand2;
          pQRRepGenUserNameValueLabel->Name = "RepGenUserNameValueLabel" + IntToStr(tempComponentIndex);
          pQRRepGenUserNameValueLabel->Left = pSrcLabel->Left;
          pQRRepGenUserNameValueLabel->Top = pSrcLabel->Top;
          pQRRepGenUserNameValueLabel->Width = pSrcLabel->Width;
          pQRRepGenUserNameValueLabel->Height = pSrcLabel->Height;
          pQRRepGenUserNameValueLabel->Caption = "";
          pQRRepGenUserNameValueLabel->Font = pSrcLabel->Font;
          pQRRepGenUserNameValueLabel->Alignment = pSrcLabel->Alignment;
          pQRRepGenUserNameValueLabel->AutoSize = pSrcLabel->AutoSize;

          // Date
          tempComponentIndex = newPageIndex-1;
          TQRLabel *pQRRepGenDateValueLabel = new TQRLabel(this);
          pSrcLabel = (TQRLabel*)FindComponent("RepGenDateValueLabel1");
          pQRRepGenDateValueLabel->Parent = pQRBand2;
          pQRRepGenDateValueLabel->Name = "RepGenDateValueLabel" + IntToStr(tempComponentIndex);
          pQRRepGenDateValueLabel->Left = pSrcLabel->Left;
          pQRRepGenDateValueLabel->Top = pSrcLabel->Top;
          pQRRepGenDateValueLabel->Width = pSrcLabel->Width;
          pQRRepGenDateValueLabel->Height = pSrcLabel->Height;
          pQRRepGenDateValueLabel->Caption = "";
          pQRRepGenDateValueLabel->Font = pSrcLabel->Font;
          pQRRepGenDateValueLabel->Alignment = pSrcLabel->Alignment;
          pQRRepGenDateValueLabel->AutoSize = pSrcLabel->AutoSize;

          //Page x of y
          TQRLabel *pQRRepGenPageValueLabel = new TQRLabel(this);
          pSrcLabel = (TQRLabel*)FindComponent("RepGenPageValueLabel1");
          pQRRepGenPageValueLabel->Parent = pQRBand2;
          pQRRepGenPageValueLabel->Name = "RepGenPageValueLabel" + IntToStr(tempComponentIndex);
          pQRRepGenPageValueLabel->Left = pSrcLabel->Left;
          pQRRepGenPageValueLabel->Top = pSrcLabel->Top;
          pQRRepGenPageValueLabel->Width = pSrcLabel->Width;
          pQRRepGenPageValueLabel->Height = pSrcLabel->Height;
          pQRRepGenPageValueLabel->Caption = "";
          pQRRepGenPageValueLabel->Font = pSrcLabel->Font;
          pQRRepGenPageValueLabel->Alignment = pSrcLabel->Alignment;
          pQRRepGenPageValueLabel->AutoSize = pSrcLabel->AutoSize;
        }
    }

}


void __fastcall TPrintAuditTrail_Ajanta_Form::UpDown1Click(TObject *Sender,
      TUDBtnType Button)
{
	  int CurrentPageN = UpDown1->Position;
    AnsiString  ComponentName;
    TQuickRep *pTempRP;
    pTempRP = (TQuickRep*)FindComponent("SubRep" + IntToStr(CurrentPageN));
    ReportPageLabel->Caption = IntToStr(CurrentPageN) + " / " + IntToStr(UpDown1->Max);
    pTempRP->BringToFront();
}
//---------------------------------------------------------------------------

void __fastcall TPrintAuditTrail_Ajanta_Form::QRCompositeReportAddReports(
      TObject *Sender)
{
    QRCompositeReport->Reports->Clear();

    for(int i = 1; i<=PageNum; i++)
    {
        TQuickRep *tempQR;
        tempQR =  (TQuickRep*)FindComponent("SubRep" + IntToStr(i));
        QRCompositeReport->Reports->Add(tempQR);
    }
}
//---------------------------------------------------------------------------


void __fastcall TPrintAuditTrail_Ajanta_Form::FormClose(TObject *Sender,
      TCloseAction &Action)
{
  Action = caFree;  
}
//---------------------------------------------------------------------------



void __fastcall TPrintAuditTrail_Ajanta_Form::Timer1Timer(TObject *Sender)
{
  HWND h_wnd = FindWindowW(NULL,L"Save As");
  if(h_wnd != NULL)
  {
        if(Zorder != 1)
        {
                SetWindowPos(h_wnd, HWND_TOP, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
                CloseHandle(h_wnd);
        }
  }
  else
  {

        if(Zorder != 2)
        {
                SetWindowPos(Handle, HWND_TOP, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
                Zorder = 2;
        }
  }
}
//---------------------------------------------------------------------------

