//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "PrintAuditTrail_Form.h"
#include "Environment.h"    
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntStdCtrls"
#pragma link "TntExtCtrls"
#pragma resource "*.dfm"
TPrintAuditTrailForm *PrintAuditTrailForm;

//---------------------------------------------------------------------------
__fastcall TPrintAuditTrailForm::TPrintAuditTrailForm(TComponent* Owner)
    : TForm(Owner)
{
    if (DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
      ComponentSetFontName(this, "SimSun");
    else if (DefaultLCID == 1041)
		  ComponentSetFontName(this, "Meiryo UI");
    else if(DefaultLCID == 3082)
    {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }
      
    for (int rIndex = 1; rIndex < 20; rIndex++)
    {
        ((TQRLabel*)FindComponent("NoLabel" + IntToStr(rIndex)))->Caption = "";
        ((TQRLabel*)FindComponent("TypeLabel" + IntToStr(rIndex)))->Caption = "";
        ((TQRLabel*)FindComponent("TimeLabel" + IntToStr(rIndex)))->Caption = "";
        ((TQRLabel*)FindComponent("UserLabel" + IntToStr(rIndex)))->Caption = "";
        ((TQRLabel*)FindComponent("QnameLabel" + IntToStr(rIndex)))->Caption = "";
        ((TQRLabel*)FindComponent("MemoLabel" + IntToStr(rIndex)))->Caption = "";
    }

    TntButton2->Caption = V6_REPORT_PRINT_FORM_ADD_04;
    TntButton3->Caption = V6_REPORT_PRINT_FORM_ADD_05;
    TntButton1->Caption = V6_REPORT_PRINT_FORM_ADD_06;
    TntButton4->Caption = V6_REPORT_PRINT_FORM_ADD_07;

    GroupBox1->Caption = AUDITTRAILFORM_STRGRID_CELL_12;
    QRLabel1->Caption = AUDITTRAILFORM_STRGRID_CELL_11;
    QRLabelTitle2->Caption = AUDITTRAILFORM_STRGRID_CELL_06;
    QRLabelTitle4->Caption = AUDITTRAILFORM_STRGRID_CELL_07;
    QRLabelBottom1->Caption = AUDITTRAILFORM_STRGRID_CELL_08;
    QRLabelBottom3->Caption = AUDITTRAILFORM_STRGRID_CELL_09;
    QRLabelBottom5->Caption = AUDITTRAILFORM_STRGRID_CELL_10;
    QRLabelBottom2->Caption = AUDITTRAILFORM_STRGRID_CELL_13;
    QRLabelBottom4->Caption = AUDITTRAILFORM_STRGRID_CELL_13;
    QRLabelBottom6->Caption = AUDITTRAILFORM_STRGRID_CELL_13;


    QRLabel3->Caption = AUDITTRAILFORM_STRGRID_CELL_04;
    QRLabel4->Caption = AUDITTRAILFORM_STRGRID_CELL_02;
    QRLabel5->Caption = AUDITTRAILFORM_STRGRID_CELL_03;
    QRLabel6->Caption = AUDITTRAILFORM_STRGRID_CELL_05;
    QRLabel7->Caption = AUDITTRAILFORM_STRGRID_CELL_01;

}
//---------------------------------------------------------------------------
void __fastcall TPrintAuditTrailForm::SetReport(TCSVLogList* csvList, int nValidData, bool bAction, bool bEvent, bool bAlarm, double StartTime, double EndTime, int stLogIndex, int edLogIndex, bool bLimit,WideString ProductName , AnsiString CreatorName)
{
  if (csvList->DataCount <= 0)
    return;
  if (nValidData <= 0)
    return;

  if (nValidData > 19)
  {
    PageNum = (nValidData - 19) / 21;
    if ((nValidData - 19) % 21)
      PageNum++;
    CreateReportPage(PageNum);
    UpDown1->Min = 1;
    UpDown1->Max = PageNum + 1;
    UpDown1->Position = 1;
    UpDown1->Enabled = true;
    ReportPageLabel->Caption = "1 / " + IntToStr(UpDown1->Max);
  }

  if (bAlarm)
  {
    QRLabel1->Caption = "Alarm's Report";
  }
  TDateTime DateOfPrint;
  TDateTime TimeOfPrint;

  DateOfPrint = TDateTime::CurrentDate();
  TimeOfPrint = TDateTime::CurrentTime();
  QRLabelTitle3->Caption = DateOfPrint.DateTimeString();
  QRLabelTitle5->Caption = TimeOfPrint.TimeString();

  unsigned short year, month, day;
  unsigned short hour, min, sec, msec;
  TDateTime(ProductData.LastInspectionTime).DecodeDate(&year, &month, &day);
  TDateTime(ProductData.LastInspectionTime).DecodeTime(&hour, &min, &sec, &msec);

  int dataCount = csvList->DataCount;

  for (int i = 0; i < (PageNum + 1); i++)
  {
    ((TQRLabel*)FindComponent("QRLabelBottom" + IntToStr(7 + i * 7)))->Caption = "Page " + IntToStr(i + 1) + " of " + IntToStr(PageNum + 1);
  }
  int DataCount=0;
  int index = 0;


  for (int dataIndex = 0; dataIndex < dataCount; dataIndex++)
  {
    if (!bLimit || (bLimit && dataIndex >= stLogIndex && dataIndex <= edLogIndex))
    {
      bool dataValid = true;

      ECSVLogKind kind = csvList->GetKind(dataIndex);
      if ((kind == ECSV_LOG_KIND_EVENT && bEvent) ||
        (kind == ECSV_LOG_KIND_ACTION && bAction))
      {
        dataValid = true;
      }
      else
      {
        dataValid = false;
      }

      if (bAlarm)
      {
        if (kind == ECSV_LOG_KIND_ACTION)
        {
          dataValid = false;
        }

        if (kind == ECSV_LOG_KIND_EVENT)
        {
          ECSVEvent temp = csvList->GetEventKind(dataIndex);
          if (temp != ECSV_EVENT_ALARM && temp != ECSV_EVENT_ALARM_CLEAR)
          {
            dataValid = false;
          }
        }
      }

      TDateTime date = csvList->GetTimeInfo(dataIndex);
      double diffStart, diffEnd;
      diffStart = StartTime - date;
      if (diffStart > 0)
        dataValid = false;

      diffEnd = date - EndTime;
      if (diffEnd > 0)
        dataValid = false;

      if(DataCount>=nValidData) break;

      if (!ProductName.IsEmpty())
			{
        WideString Name = csvList->GetProductName(dataIndex);
        int n_Length = Name.Length();
        if(n_Length == 0)
        {
          dataValid = false;
        }
        else
        {
          int p_Length = ProductName.Length();
          if(p_Length == n_Length)
          {
            WideString ConvertPName = ProductName;
            WideString ConvertName = Name;
            if(_tcscmp(_tcslwr(ConvertPName),_tcslwr(ConvertName)) ==  0)
              dataValid = true;
            else
              dataValid = false;
          }
          else
          {
            int p_nameIndex = 0;
            for(int i = 0; i < n_Length; ++i)
            {
              if(p_nameIndex > p_Length) p_nameIndex -= 1;
              WideString ConvertPName = ProductName;
              WideString ConvertName = Name;
              if(p_nameIndex > 0 && _tcslwr(ConvertName)[i]!= _tcslwr(ConvertPName)[p_nameIndex])
              {
                dataValid = false;
                break;
              }

              ConvertPName = ProductName;
              ConvertName = Name;
              if( _tcslwr(ConvertName)[i] ==_tcslwr(ProductName)[p_nameIndex] )
                p_nameIndex++;
            }

            if(p_nameIndex == p_Length)
            {
              dataValid = true;
            }
            else
              dataValid = false;
          }
        }

			}

      if(dataValid == true)
      {
        if (CreatorName != "")
        {
          AnsiString Name = csvList->GetCreatorName(dataIndex);
          int n_Length = Name.Length();
          if(Name == 0)
          {
            dataValid = false;
          }
          else
          {
            int c_Length = CreatorName.Length();
            if(c_Length == n_Length)
            {
              if(CreatorName.LowerCase() == Name.LowerCase())
                dataValid = true;
              else
                dataValid = false;
            }
            else
            {
              int c_nameIndex = 0;
              for(int i = 0; i < n_Length; ++i)
              {
                if(c_nameIndex > c_Length) c_nameIndex -= 1;
                if(c_nameIndex > 0 && Name.LowerCase().c_str()[i] != CreatorName.LowerCase().c_str()[c_nameIndex])
                {
                  dataValid = false;
                  break;
                }

                if(Name.LowerCase().c_str()[i] == CreatorName.LowerCase().c_str()[c_nameIndex])
                  c_nameIndex++;
              }

              if(c_nameIndex == c_Length)
                dataValid = true;
              else
                dataValid = false;
            }
          }

        }
      }



      if (dataValid)
      {
        DataCount++;
        ((TQRLabel*)FindComponent("NoLabel" + IntToStr(index + 1)))->Caption = IntToStr(index + 1);
        ((TQRLabel*)FindComponent("TypeLabel" + IntToStr(index + 1)))->Caption = csvList->GetKindStr(dataIndex);
        ((TQRLabel*)FindComponent("TimeLabel" + IntToStr(index + 1)))->Caption = csvList->GetTimeStr(dataIndex);
        ((TQRLabel*)FindComponent("UserLabel" + IntToStr(index + 1)))->Caption = csvList->GetCreatorName(dataIndex);
        ((TQRLabel*)FindComponent("QnameLabel" + IntToStr(index + 1)))->Caption = csvList->GetProductName(dataIndex);
        ((TQRLabel*)FindComponent("MemoLabel" + IntToStr(index + 1)))->Caption = csvList->GetMessage(dataIndex);

        int validWidth = 60;

        if(((TQRLabel*)FindComponent("UserLabel" + IntToStr(index + 1)))->Width > validWidth)
        {
          TQRLabel *dstLabel = ((TQRLabel*)FindComponent("UserLabel" + IntToStr(index + 1)));
          dstLabel->Caption = "";

          AnsiString tmpStr = csvList->GetCreatorName(dataIndex);
          AnsiString applyText = "";
          int textString = tmpStr.Length();

          char *strBuff = new char[textString + 1];
          memset(strBuff, 0, sizeof(char) * textString + 1);
          strcpy(strBuff, tmpStr.c_str());

          int StringOverflowCount = 0;
          for(int strLength = 0; strLength < textString; strLength++)
          {
            if(strBuff[strLength] & 0x80)
            {
              applyText += strBuff[strLength];
              applyText += strBuff[strLength+1];
              ++strLength;
            }
            else
            {
              applyText += strBuff[strLength];
            }

            dstLabel->Caption = applyText;

            if(dstLabel->Width > validWidth)
            {
              StringOverflowCount++;
              if(StringOverflowCount > 1) break;

              applyText.Insert("\r\n", strLength);
            }
          }

          delete strBuff;

          dstLabel->Caption = applyText;
          dstLabel->Top -= 2;
          dstLabel->Height += 2;
        }

        validWidth = 70;
        if(((TQRLabel*)FindComponent("QnameLabel" + IntToStr(index + 1)))->Width > validWidth)
        {
          TQRLabel *dstLabel = ((TQRLabel*)FindComponent("QnameLabel" + IntToStr(index + 1)));
          dstLabel->Caption = "";

          AnsiString tmpStr = csvList->GetProductName(dataIndex);
          AnsiString applyText = "";
          int textString = tmpStr.Length();

          char *strBuff = new char[textString + 1];
          memset(strBuff, 0, sizeof(char) * textString + 1);
          strcpy(strBuff, tmpStr.c_str());

          int StringOverflowCount = 0;
          for(int strLength = 0; strLength < textString; strLength++)
          {
            if(strBuff[strLength] & 0x80)
            {
              applyText += strBuff[strLength];
              applyText += strBuff[strLength+1];
              ++strLength;
            }
            else
            {
              applyText += strBuff[strLength];
            }

            dstLabel->Caption = applyText;

            if(dstLabel->Width > validWidth)
            {
              StringOverflowCount++;
              if(StringOverflowCount > 1) break;

              applyText.Insert("\r\n", strLength);
            }
          }

          delete strBuff;

          dstLabel->Caption = applyText;
          dstLabel->Top -= 2;
          dstLabel->Height += 2;
        }

        validWidth = 268;
        if(((TQRLabel*)FindComponent("MemoLabel" + IntToStr(index + 1)))->Width > validWidth)
        {
          TQRLabel *dstLabel = ((TQRLabel*)FindComponent("MemoLabel" + IntToStr(index + 1)));
          dstLabel->Caption = "";

          AnsiString tmpStr = csvList->GetMessage(dataIndex);
          AnsiString applyText = "";
          int textString = tmpStr.Length();

          char *strBuff = new char[textString + 1];
          memset(strBuff, 0, sizeof(char) * textString + 1);
          strcpy(strBuff, tmpStr.c_str());

          int StringOverflowCount = 0;
          for(int strLength = 0; strLength < textString; strLength++)
          {
            if(strBuff[strLength] & 0x80)
            {
              applyText += strBuff[strLength];
              applyText += strBuff[strLength+1];
              ++strLength;
            }
            else
            {
              applyText += strBuff[strLength];
            }

            dstLabel->Caption = applyText;

            if(dstLabel->Width > validWidth)
            {
              StringOverflowCount++;
              if(StringOverflowCount > 1) break;

              applyText.Insert("\r\n", strLength);
            }
          }

          delete strBuff;

          dstLabel->Caption = applyText;
          dstLabel->Top -= 2;
          dstLabel->Height += 2;
        }
        index++;
      }
    }
  }

  QuickRep1->BringToFront();
}
//---------------------------------------------------------------------------
void __fastcall TPrintAuditTrailForm::TntButton1Click(TObject *Sender)
{    
    PrintFlag = 1;
    WaitPrintTimer->Enabled = true;

    QRCompositeReport->Print();
    
    PrintFlag = 2;
}
//---------------------------------------------------------------------------

void __fastcall TPrintAuditTrailForm::TntButton3Click(TObject *Sender)
{
    QRCompositeReport->PrinterSetup();
}
//---------------------------------------------------------------------------

void __fastcall TPrintAuditTrailForm::TntButton2Click(TObject *Sender)
{
    QRCompositeReport->Preview();
}
//---------------------------------------------------------------------------

void __fastcall TPrintAuditTrailForm::TntButton4Click(TObject *Sender)
{
    int index, cnt, componentIdx;

    for(index = 1; index <= PageNum; index++)
    {
        //frame 
        for(cnt = 0; cnt<7; cnt++)
        {
            componentIdx = 1 + index * 33 + cnt;
            TQRShape *pFrame = (TQRShape*)FindComponent("QRShape" + IntToStr(componentIdx));
            delete pFrame;
        }

        // Frame 
        for (cnt = 0; cnt < 23; cnt++)
        {
            componentIdx = 1 + 7 + index * 33 + cnt;
            TQRShape *pFrame = (TQRShape*)FindComponent("QRShape" + IntToStr(componentIdx));
            delete  pFrame;
        }

        // Title label
        for (cnt = 1; cnt < 7; cnt++)
        {
            componentIdx = 1 + index * 7 + cnt;
            TQRLabel *pLabel = (TQRLabel*)FindComponent("QRLabel" + IntToStr(componentIdx));
            delete pLabel;
        }

         // Label 
        for (cnt = 0; cnt < 21; cnt++)
        {
            componentIdx = index * 24 - 1 + cnt;
            TQRLabel *pLabel;
            //No.
            pLabel = (TQRLabel*)FindComponent("NoLabel" + IntToStr(componentIdx));
            delete pLabel;

            //type
            pLabel = (TQRLabel*)FindComponent("TypeLabel" + IntToStr(componentIdx));
            delete pLabel;

            //Time
            pLabel = (TQRLabel*)FindComponent("TimeLabel1" + IntToStr(componentIdx));
            delete pLabel;

            //User
            pLabel = (TQRLabel*)FindComponent("UserLabel1" + IntToStr(componentIdx));
            delete pLabel;

            //Qname
            pLabel = (TQRLabel*)FindComponent("QnameLabel1" + IntToStr(componentIdx));
            delete pLabel;

            //Memo
            pLabel = (TQRLabel*)FindComponent("MemoLabel1" + IntToStr(componentIdx));
            delete pLabel;
        }

        //signature
        for(cnt = 0; cnt < 7; cnt++)
        {
            componentIdx = 1 + index * 7 + cnt;
            TQRLabel *pLabel;
            pLabel = pLabel = (TQRLabel*)FindComponent("QRLabelBottom" + IntToStr(componentIdx));
            delete pLabel;
        }

        // QRBand
        TQRBand *pBand = (TQRBand*)FindComponent("SummaryBand" + IntToStr(index + 1));
        delete pBand;

        //Report
        TQuickRep *pQR = (TQuickRep*)FindComponent("QuickRep" + IntToStr(index + 1));
        delete pQR;
    }

    this->Close();
}
//---------------------------------------------------------------------------

void __fastcall TPrintAuditTrailForm::CreateReportPage(int dataCnt)
{
    int newPageIndex, endPage;
    int FrameIndex, tempComponentIndex;

    endPage = dataCnt;

    Panel2->DoubleBuffered = true;
    for(newPageIndex = 1; newPageIndex <= endPage; newPageIndex++)
    {
        //Report
        TQuickRep *pQR = new TQuickRep(this);
        pQR->Name = "QuickRep" + IntToStr(newPageIndex + 1);
        pQR->Parent = Panel2;
        pQR->Left = QuickRep1->Left;
        pQR->Top = QuickRep1->Top;
        pQR->Width = QuickRep1->Width;
        pQR->Height = QuickRep1->Height;
        
        //Title QRBand
        TQRBand *pQRBand1 = new TQRBand(this);
        pQRBand1->Parent = pQR;
        pQRBand1->Name = "TitleBand" + IntToStr(newPageIndex + 1);
        pQRBand1->Left = TitleBand1->Left;
        pQRBand1->Top = TitleBand1->Top;
        pQRBand1->Width = TitleBand1->Width;
        pQRBand1->Height = TitleBand1->Height;
        pQRBand1->BandType = TitleBand1->BandType;

        //Summary QRBand
        TQRBand *pQRBand2 = new TQRBand(this);
        pQRBand2->Parent = pQR;
        pQRBand2->Name = "SummaryBand" + IntToStr(newPageIndex + 1);
        pQRBand2->Left = SummaryBand1->Left;
        pQRBand2->Top = SummaryBand1->Top;
        pQRBand2->Width = SummaryBand1->Width;
        pQRBand2->Height = SummaryBand1->Height;
        pQRBand2->BandType = SummaryBand1->BandType;

        // Frame 
        for (FrameIndex = 0; FrameIndex < 7; FrameIndex++)
        {
            tempComponentIndex = 1 + newPageIndex * 33 + FrameIndex;
            TQRShape *pBaseFrame = new TQRShape(this);
            TQRShape *pSrcFrame = (TQRShape*)FindComponent("QRShape" + IntToStr(FrameIndex + 1));
            pBaseFrame->Parent = pQRBand2;
            pBaseFrame->Name = "QRShape" + IntToStr(tempComponentIndex);
            pBaseFrame->Left = pSrcFrame->Left;
            pBaseFrame->Top = 50;//pSrcFrame->Top;
            pBaseFrame->Width = pSrcFrame->Width;
            pBaseFrame->Height = 880;//pSrcFrame->Height;
            pBaseFrame->Shape = pSrcFrame->Shape;
            pBaseFrame->Enabled = pSrcFrame->Enabled;
            pBaseFrame->Cursor = pSrcFrame->Cursor;

            pBaseFrame->Frame->Color = pSrcFrame->Frame->Color;
            pBaseFrame->Frame->DrawBottom = pSrcFrame->Frame->DrawBottom;
            pBaseFrame->Frame->DrawLeft = pSrcFrame->Frame->DrawLeft;
            pBaseFrame->Frame->DrawRight = pSrcFrame->Frame->DrawRight;
            pBaseFrame->Frame->DrawTop = pSrcFrame->Frame->DrawTop;
            pBaseFrame->Frame->Style = pSrcFrame->Frame->Style;
            pBaseFrame->Frame->Width = pSrcFrame->Frame->Width;

            pBaseFrame->Brush->Color = pSrcFrame->Brush->Color;
            pBaseFrame->Brush->Style = pSrcFrame->Brush->Style;

            pBaseFrame->Pen->Color = pSrcFrame->Pen->Color;
            pBaseFrame->Pen->Mode = pSrcFrame->Pen->Mode;
            pBaseFrame->Pen->Style = pSrcFrame->Pen->Style;
            pBaseFrame->Pen->Width = pSrcFrame->Pen->Width;
        }
    
        // Frame 
        for (FrameIndex = 0; FrameIndex < 23; FrameIndex++)
        {
            tempComponentIndex = 1 + 7 + newPageIndex * 33 + FrameIndex;

            TQRShape *pBaseFrame = new TQRShape(this);
            TQRShape *pSrcFrame = (TQRShape*)FindComponent("QRShape" + IntToStr(FrameIndex + 1));
            pBaseFrame->Parent = pQRBand2;
            pBaseFrame->Name = "QRShape" + IntToStr(tempComponentIndex);
            pBaseFrame->Left = 0;
            pBaseFrame->Top = 50 + 40 * FrameIndex;//pSrcFrame->Top;
            pBaseFrame->Width = 718;
            pBaseFrame->Height = 1;//pSrcFrame->Height;
            pBaseFrame->Shape = pSrcFrame->Shape;
            pBaseFrame->Enabled = pSrcFrame->Enabled;
            pBaseFrame->Cursor = pSrcFrame->Cursor;

            pBaseFrame->Frame->Color = pSrcFrame->Frame->Color;
            pBaseFrame->Frame->DrawBottom = pSrcFrame->Frame->DrawBottom;
            pBaseFrame->Frame->DrawLeft = pSrcFrame->Frame->DrawLeft;
            pBaseFrame->Frame->DrawRight = pSrcFrame->Frame->DrawRight;
            pBaseFrame->Frame->DrawTop = pSrcFrame->Frame->DrawTop;
            pBaseFrame->Frame->Style = pSrcFrame->Frame->Style;
            pBaseFrame->Frame->Width = pSrcFrame->Frame->Width;

            pBaseFrame->Brush->Color = pSrcFrame->Brush->Color;
            pBaseFrame->Brush->Style = pSrcFrame->Brush->Style;

            pBaseFrame->Pen->Color = pSrcFrame->Pen->Color;
            pBaseFrame->Pen->Mode = pSrcFrame->Pen->Mode;
            pBaseFrame->Pen->Style = pSrcFrame->Pen->Style;
            pBaseFrame->Pen->Width = pSrcFrame->Pen->Width;
        }       

        // Title label
        for (FrameIndex = 1; FrameIndex < 7; FrameIndex++)
        {
            tempComponentIndex = 1 + newPageIndex * 7 + FrameIndex;
            TQRLabel *pQRLabel = new TQRLabel(this);
            TQRLabel *pSrcLabel = (TQRLabel*)FindComponent("QRLabel" + IntToStr(FrameIndex + 1));
            pQRLabel->Parent = pQRBand2;
            pQRLabel->Name = "QRLabel" + IntToStr(tempComponentIndex);
            pQRLabel->AutoSize = pSrcLabel->AutoSize;
            pQRLabel->WordWrap = pSrcLabel->WordWrap;
            pQRLabel->Left = pSrcLabel->Left;
            pQRLabel->Top = 60;
            pQRLabel->Width = pSrcLabel->Width;
            pQRLabel->Height = pSrcLabel->Height;
            pQRLabel->Font = pSrcLabel->Font;
            pQRLabel->Alignment = pSrcLabel->Alignment;
            pQRLabel->Caption = pSrcLabel->Caption;
        }

        // Label 
        for (FrameIndex = 0; FrameIndex < 21; FrameIndex++)
        {
            tempComponentIndex = newPageIndex * 21 - 1 + FrameIndex;
            TQRLabel *pQRLabel = new TQRLabel(this);
            TQRLabel *pSrcLabel;
            //No.
            TQRLabel *pQRNoLabel = new TQRLabel(this);
            pSrcLabel = (TQRLabel*)FindComponent("NoLabel1");
            pQRNoLabel->Parent = pQRBand2;
            pQRNoLabel->Name = "NoLabel" + IntToStr(tempComponentIndex);
            pQRNoLabel->Left = pSrcLabel->Left;
            pQRNoLabel->Top = 100 + 40 * FrameIndex;
            pQRNoLabel->Width = pSrcLabel->Width;
            pQRNoLabel->Height = pSrcLabel->Height;
            pQRNoLabel->Caption = "";   
            pQRNoLabel->Font = pSrcLabel->Font;
            pQRNoLabel->Alignment = pSrcLabel->Alignment;
            pQRNoLabel->AutoSize = pSrcLabel->AutoSize;
            pQRNoLabel->WordWrap = pSrcLabel->WordWrap;

            //type
            TQRLabel *pQRTypeLabel = new TQRLabel(this);
            pSrcLabel = (TQRLabel*)FindComponent("TypeLabel1");
            pQRTypeLabel->Parent = pQRBand2;
            pQRTypeLabel->Name = "TypeLabel" + IntToStr(tempComponentIndex);
            pQRTypeLabel->Left = pSrcLabel->Left;
            pQRTypeLabel->Top = 100 + 40 * FrameIndex;
            pQRTypeLabel->Width = pSrcLabel->Width;
            pQRTypeLabel->Height = pSrcLabel->Height;
            pQRTypeLabel->Caption = "";     
            pQRTypeLabel->Font = pSrcLabel->Font;
            pQRTypeLabel->Alignment = pSrcLabel->Alignment;
            pQRTypeLabel->AutoSize = pSrcLabel->AutoSize;
            pQRTypeLabel->WordWrap = pSrcLabel->WordWrap;

            //Time 
            TQRLabel *pQRTimeLabel = new TQRLabel(this);
            pSrcLabel = (TQRLabel*)FindComponent("TimeLabel1");
            pQRTimeLabel->Parent = pQRBand2;
            pQRTimeLabel->Name = "TimeLabel" + IntToStr(tempComponentIndex);
            pQRTimeLabel->Left = pSrcLabel->Left;
            pQRTimeLabel->Top = 100 + 40 * FrameIndex;
            pQRTimeLabel->Width = pSrcLabel->Width;
            pQRTimeLabel->Height = pSrcLabel->Height;
            pQRTimeLabel->Caption = ""; 
            pQRTimeLabel->Font = pSrcLabel->Font;
            pQRTimeLabel->Alignment = pSrcLabel->Alignment;
            pQRTimeLabel->AutoSize = pSrcLabel->AutoSize;
            pQRTimeLabel->WordWrap = pSrcLabel->WordWrap;

            //User  
            TQRLabel *pQRUserLabel = new TQRLabel(this);
            pSrcLabel = (TQRLabel*)FindComponent("UserLabel1");
            pQRUserLabel->Parent = pQRBand2;
            pQRUserLabel->Name = "UserLabel" + IntToStr(tempComponentIndex);
            pQRUserLabel->Left = pSrcLabel->Left;
            pQRUserLabel->Top = 95 + 40 * FrameIndex;
            pQRUserLabel->Width = pSrcLabel->Width;
            pQRUserLabel->Height = pSrcLabel->Height;
            pQRUserLabel->Caption = "";
            pQRUserLabel->Font = pSrcLabel->Font;
            pQRUserLabel->Alignment = pSrcLabel->Alignment;
            pQRUserLabel->AutoSize = pSrcLabel->AutoSize;
            pQRUserLabel->WordWrap = pSrcLabel->WordWrap;

            //Qname  
            TQRLabel *pQRQnameLabel = new TQRLabel(this);
            pSrcLabel = (TQRLabel*)FindComponent("QnameLabel1");
            pQRQnameLabel->Parent = pQRBand2;
            pQRQnameLabel->Name = "QnameLabel" + IntToStr(tempComponentIndex);
            pQRQnameLabel->Left = pSrcLabel->Left;
            pQRQnameLabel->Top = 95 + 40 * FrameIndex;
            pQRQnameLabel->Width = pSrcLabel->Width;
            pQRQnameLabel->Height = pSrcLabel->Height;
            pQRQnameLabel->Caption = "";      
            pQRQnameLabel->Font = pSrcLabel->Font;
            pQRQnameLabel->Alignment = pSrcLabel->Alignment;
            pQRQnameLabel->AutoSize = pSrcLabel->AutoSize;
            pQRQnameLabel->WordWrap = pSrcLabel->WordWrap;

            //Memo
            TQRLabel *pQRMemoLabel = new TQRLabel(this);
            pSrcLabel = (TQRLabel*)FindComponent("MemoLabel1");
            pQRMemoLabel->Parent = pQRBand2;
            pQRMemoLabel->Name = "MemoLabel" + IntToStr(tempComponentIndex);
            pQRMemoLabel->Left = pSrcLabel->Left;
            pQRMemoLabel->Top = 95 + 40 * FrameIndex;
            pQRMemoLabel->Width = pSrcLabel->Width;
            pQRMemoLabel->Height = pSrcLabel->Height;
            pQRMemoLabel->Caption = "";
            pQRMemoLabel->Font = pSrcLabel->Font;
            pQRMemoLabel->Alignment = pSrcLabel->Alignment;
            pQRMemoLabel->AutoSize = pSrcLabel->AutoSize;
            pQRMemoLabel->WordWrap = pSrcLabel->WordWrap;
        }

        //     
        for (FrameIndex = 0; FrameIndex < 6; FrameIndex++)
        {
            TQRLabel *pSrcLabel;
            tempComponentIndex = 1 + newPageIndex * 7 + FrameIndex;
            //Printed, Checked, Rewiewed by
            TQRLabel *pQRBottomLabel = new TQRLabel(this);
            pSrcLabel = (TQRLabel*)FindComponent("QRLabelBottom"+IntToStr(FrameIndex+1));
            pQRBottomLabel->Parent = pQRBand2;
            pQRBottomLabel->Name = "QRLabelBottom" + IntToStr(tempComponentIndex);
            pQRBottomLabel->Left = pSrcLabel->Left;
            pQRBottomLabel->Top = pSrcLabel->Top;
            pQRBottomLabel->Width = pSrcLabel->Width;
            pQRBottomLabel->Height = pSrcLabel->Height;
            pQRBottomLabel->Caption = pSrcLabel->Caption;
            pQRBottomLabel->Font = pSrcLabel->Font;
            pQRBottomLabel->Alignment = pSrcLabel->Alignment;
            pQRBottomLabel->AutoSize = pSrcLabel->AutoSize;
        }

        //Page x of y    
        TQRLabel *pSrcLabel;
        tempComponentIndex = 1 + newPageIndex * 7 + 6;
        TQRLabel *pQRBottomLabel = new TQRLabel(this);
        pSrcLabel = (TQRLabel*)FindComponent("QRLabelBottom7");
        pQRBottomLabel->Parent = pQRBand2;
        pQRBottomLabel->Name = "QRLabelBottom" + IntToStr(tempComponentIndex);
        pQRBottomLabel->Left = pSrcLabel->Left;
        pQRBottomLabel->Top = pSrcLabel->Top;
        pQRBottomLabel->Width = pSrcLabel->Width;
        pQRBottomLabel->Height = pSrcLabel->Height;
        pQRBottomLabel->Caption = pSrcLabel->Caption;
        pQRBottomLabel->Font = pSrcLabel->Font;
        pQRBottomLabel->Alignment = pSrcLabel->Alignment;
        pQRBottomLabel->AutoSize = pSrcLabel->AutoSize;
    }

}


void __fastcall TPrintAuditTrailForm::UpDown1Click(TObject *Sender,
      TUDBtnType Button)
{
	int CurrentPageN = UpDown1->Position;
    AnsiString  ComponentName;
    TQuickRep *pTempRP;
    pTempRP = (TQuickRep*)FindComponent("QuickRep" + IntToStr(CurrentPageN));
    ReportPageLabel->Caption = IntToStr(CurrentPageN) + " / " + IntToStr(UpDown1->Max);
    pTempRP->BringToFront();
}
//---------------------------------------------------------------------------

void __fastcall TPrintAuditTrailForm::QRCompositeReportAddReports(
      TObject *Sender)
{
    QRCompositeReport->Reports->Clear();

    for(int i = 0; i<=PageNum; i++)
    {
        TQuickRep *tempQR;
        tempQR =  (TQuickRep*)FindComponent("QuickRep" + IntToStr(i+1));
        QRCompositeReport->Reports->Add(tempQR);
    }
}
//---------------------------------------------------------------------------


void __fastcall TPrintAuditTrailForm::Timer1Timer(TObject *Sender)
{
  HWND h_wnd = FindWindowW(NULL,L"Save As");
  if(h_wnd != NULL)
  {
        if(Zorder != 1)
        {
                SetWindowPos(h_wnd, HWND_TOP, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
                CloseHandle(h_wnd);
        }
  }
  else
  {

        if(Zorder != 2)
        {
                SetWindowPos(Handle, HWND_TOP, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
                Zorder = 2;
        }
  }
}
//---------------------------------------------------------------------------

void __fastcall TPrintAuditTrailForm::WaitPrintTimerTimer(TObject *Sender)
{
  if(PrintFlag == 2)
  {
    WaitPrintCompletePanel->Visible = false;
    PrintFlag = 0;

    TntButton2->Enabled = true;
    TntButton3->Enabled = true;
    TntButton1->Enabled = true;
    TntButton4->Enabled = true;
    
    WaitPrintTimer->Enabled = false;    
  }
  else
  {
    WaitPrintCompletePanel->Visible = true;

    TntButton2->Enabled = false;
    TntButton3->Enabled = false;
    TntButton1->Enabled = false;
    TntButton4->Enabled = false;
  }
}
//---------------------------------------------------------------------------

void __fastcall TPrintAuditTrailForm::FormCreate(TObject *Sender)
{
    PrintFlag = 0;
}
//---------------------------------------------------------------------------

