//---------------------------------------------------------------------------

// Skip

#include <vcl.h>     
#include <inifiles.hpp>
#pragma hdrstop

#include "PrintInspectionResult_Ajanta_Form.h"
#include "Environment.h"
#include "MultiLanguage.h"
#include "AbstractDB.h"    
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TPrintInspectionResult_Ajanta_Form *PrintInspectionResult_Ajanta_Form;
//---------------------------------------------------------------------------
__fastcall TPrintInspectionResult_Ajanta_Form::TPrintInspectionResult_Ajanta_Form(TComponent* Owner)
	: TTntForm(Owner)
{
	if (DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
		ComponentSetFontName(this, "SimSun");
	else if (DefaultLCID == 1041)
		ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

	PrintPreviewButton->Caption = V6_REPORT_PRINT_FORM_ADD_04;
	PrinterSetupButton->Caption = V6_REPORT_PRINT_FORM_ADD_05;
	PrintButton->Caption = V6_REPORT_PRINT_FORM_ADD_06;
	CancelButton->Caption = V6_REPORT_PRINT_FORM_ADD_07;
	GroupBox4->Caption = V6_REPORT_PRINT_FORM_ADD_08; // "ǥ ҷ ̹ ";//
	SelectDefectImageButton->Caption = V6_REPORT_PRINT_FORM_ADD_09;  // "̹ ";//    
	DefectImagePrintCheckBox->Caption = V6_REPORT_PRINT_FORM_ADD_13;  // "̹ ";//

	PrintDefectSeriesCheckBox->Caption = PRINTINSPECTIONRESULTFORM_UNKNOWN_23;
	QRPage2Title->Caption = PRINTINSPECTIONRESULTFORM_UNKNOWN_24;
	QRChartLabel->Caption = PRINTINSPECTIONRESULTFORM_UNKNOWN_28;

	QRDefectNameLabel1->Caption = PRINTINSPECTIONRESULTFORM_UNKNOWN_30;
	QRDefectNameLabel2->Caption = PRINTINSPECTIONRESULTFORM_UNKNOWN_30;
	QRDefectNameLabel3->Caption = PRINTINSPECTIONRESULTFORM_UNKNOWN_30;
	QRDefectNameLabel4->Caption = PRINTINSPECTIONRESULTFORM_UNKNOWN_30;
	QRDefectNameLabel5->Caption = PRINTINSPECTIONRESULTFORM_UNKNOWN_30;
	QRDefectNameLabel6->Caption = PRINTINSPECTIONRESULTFORM_UNKNOWN_30;
	QRDefectSizeLabel1->Caption = PRINTINSPECTIONRESULTFORM_UNKNOWN_31;
	QRDefectSizeLabel2->Caption = PRINTINSPECTIONRESULTFORM_UNKNOWN_31;
	QRDefectSizeLabel3->Caption = PRINTINSPECTIONRESULTFORM_UNKNOWN_31;
	QRDefectSizeLabel4->Caption = PRINTINSPECTIONRESULTFORM_UNKNOWN_31;
	QRDefectSizeLabel5->Caption = PRINTINSPECTIONRESULTFORM_UNKNOWN_31;
	QRDefectSizeLabel6->Caption = PRINTINSPECTIONRESULTFORM_UNKNOWN_31;

	QRInspectionSpeedLabel->Caption = PRINTINSPECTIONRESULTFORM_UNKNOWN_32;
	QRLabel107->Caption = PRINTINSPECTIONRESULTFORM_UNKNOWN_33;
	QRLabel108->Caption = PRINTINSPECTIONRESULTFORM_UNKNOWN_34;

	PageList = new TTntStringList();
	PageList->Add("ReportPanel1");
}
//---------------------------------------------------------------------------
void __fastcall TPrintInspectionResult_Ajanta_Form::SetReport(AnsiString productName, AnsiString lotName,
	NFA_INSPECTION_REPORT_STRUCT REPORT,bool isPrintedTablet,int printModeOption, int threeDHeightOption, bool hIprogram)
{
	SetThroughtputChart(ProductData.ProductCode, lotName);
  
  ProductName = ProductData.ProductCode;
	LOTName = lotName;

  Report = REPORT;
  memcpy(DefectSeriesCount,Report.DefectSeriesCount.DefectSeriesCount, (MAX_DEFECT_SERIES_COUNT + 1) * sizeof(int));

 	SetDefectInfoPage2();

  QRProductName->Caption = ProductName;
  QRNameofmachine->Caption = PCProgramOption.Nameofmachine.c_bstr();
  QRMachineID->Caption = PCProgramOption.MachineID.c_bstr();
  QRBatchNum->Caption = AnsiString(LOTName);

  QRBatchSizeInfo->Caption = IntToStr(Report.Data.ProductionCount);
  MachineSpeedLabel->Caption = "Inside Feeder : " + IntToStr(Report.SubData.InDiskSpeed) +" RPM  Rotation Guide : "+ IntToStr(Report.SubData.RotateGuideSpeed)
  +" RPM  Suction Disk : "+ IntToStr(Report.SubData.SucktionDiskSpeed)+" RPM";
  QRStartOper->Caption = Report.Data.OperatorName;
  QREndOper->Caption = Report.SubData.EndOperatorName;

  TDateTime inspectionStartTime = TDateTime(Report.Data.InspectionStartTime);
  TDateTime inspectionEndTime = TDateTime(Report.Data.InspectionEndTime);

  InsStartTimeLabel->Caption = inspectionStartTime.FormatString("DD/MM/YYYY    HH:MM:SS");
  InsEndTimeLabel->Caption = inspectionEndTime.FormatString("DD/MM/YYYY    HH:MM:SS");

  if(PCProgramOption.AjantaLocalNameNum == 1)
  {
    PrintCompanyLabel1->Caption= "AJANTA PHARMA LIMITED - PAITHAN";
  }

  SideEdgeNeighborSizeLabel1->Caption = FloatToStr(DefectSizePixelToMili(Report.GradeData.Side_Edge_Neighbor_Defect_Size) / 100.0) + " mm";

  SideEdgeDarkSizeLabel1->Caption = FloatToStr(DefectSizePixelToMili(Report.GradeData.Side_Edge_Dark_Defect_Size) / 100.0) + " mm";

  SideEdgeBrightSizeLabel1->Caption = FloatToStr(DefectSizePixelToMili(Report.GradeData.Side_Edge_Bright_Defect_Size) / 100.0) + " mm";

  SideEdgeBreakSizeLabel1->Caption = FloatToStr(DefectSizePixelToMili(Report.GradeData.Side_Edge_Neighbor_Break_Size) / 100.0) + " mm";

  SideEdgeNeighborIntensityLabel1->Caption = IntToStr(Report.GradeData.Side_Edge_Neighbor_Intensity) + " grade";
  SideEdgeNeighborIntensityLabel2->Caption = IntToStr(Report.GradeData.Side_Edge_Neighbor_Intensity) + " grade";

  SideEdgeDarkIntensityLabel1->Caption = IntToStr(Report.GradeData.Side_Edge_Dark_Intensity) + " grade";
  SideEdgeDarkIntensityLabel2->Caption = IntToStr(Report.GradeData.Side_Edge_Dark_Intensity) + " grade";

  SideEdgeBrightIntensityLabel1->Caption = IntToStr(Report.GradeData.Side_Edge_Bright_Intensity) + " grade";
  SideEdgeBrightIntensityLabel2->Caption = IntToStr(Report.GradeData.Side_Edge_Bright_Intensity) + " grade";

  SideEdgeBreakIntensityLabel1->Caption = IntToStr(Report.GradeData.Side_Edge_Neighbor_Break_Intensity) + " grade";
  SideEdgeBreakIntensityLabel2->Caption = IntToStr(Report.GradeData.Side_Edge_Neighbor_Break_Intensity) + " grade";

  FrontNormalDirtyGradeQRLabel3->Caption = IntToStr(Report.GradeData.FrontNormalDirtyGrade) + " grade ";
  FrontPrintDirtyGradeQRLabel3->Caption = IntToStr(Report.GradeData.FrontPrintDirtyGrade) + " grade ";
  FrontEdgeDirtyGradeQRLabel3->Caption = IntToStr(Report.GradeData.FrontEdgeDirtyGrade) + " grade ";
  FrontStainGradeQRLabel3->Caption = IntToStr(Report.GradeData.FrontStainGrade) + " grade ";
  FrontEdgeStainGradeQRLabel3->Caption = IntToStr(Report.GradeData.FrontEdgeGrade) + " grade ";
  SideDirtyGradeQRLabel3->Caption = IntToStr(Report.GradeData.SideDirtyGrade) + " grade ";
  SideStainGradeQRLabel3->Caption = IntToStr(Report.GradeData.SideStainGrade) + " grade ";

    PrintEraseGradeQRLabel3->Caption = FloatToStr(DefectSizePixelToMili((Report.GradeData.PrintEraseGrade + 1) * (Report.GradeData.PrintEraseGrade)) / 100.0) + " mm";
  ColorGradeQRLabel3->Caption = IntToStr(Report.GradeData.ColorGrade) + " grade ";
  FrontColorDirtyGradeQRLabel3->Caption = IntToStr(Report.GradeData.FrontColorDirtyGrade) + " grade ";
  SideColorDirtyGradeQRLabel3->Caption = IntToStr(Report.GradeData.SideColorDirtyGrade) + " grade ";
  FrontNormalDirtyGradeQRLabel4->Caption = IntToStr(Report.GradeData.FrontNormalDirtyGrade) + " grade ";
  FrontPrintDirtyGradeQRLabel4->Caption = IntToStr(Report.GradeData.FrontPrintDirtyGrade) + " grade ";
  FrontEdgeDirtyGradeQRLabel4->Caption = IntToStr(Report.GradeData.FrontEdgeDirtyGrade) + " grade ";
  FrontStainGradeQRLabel4->Caption = IntToStr(Report.GradeData.FrontStainGrade) + " grade ";
  FrontEdgeStainGradeQRLabel4->Caption = IntToStr(Report.GradeData.FrontEdgeGrade) + " grade ";
  SideDirtyGradeQRLabel4->Caption = IntToStr(Report.GradeData.SideDirtyGrade) + " grade ";
  SideStainGradeQRLabel4->Caption = IntToStr(Report.GradeData.SideStainGrade) + " grade ";
    PrintEraseGradeQRLabel4->Caption = FloatToStr(DefectSizePixelToMili((Report.GradeData.PrintEraseGrade + 1) * (Report.GradeData.PrintEraseGrade)) / 100.0) + " mm";
  ColorGradeQRLabel4->Caption = IntToStr(Report.GradeData.ColorGrade) + " grade ";
  FrontColorDirtyGradeQRLabel4->Caption = IntToStr(Report.GradeData.FrontColorDirtyGrade) + " grade ";

  SideColorDirtyGradeQRLabel4->Caption = IntToStr(Report.GradeData.SideColorDirtyGrade) + " grade ";

  RefreshDefectsInfo(Report.Data.DefectTabletCount);

  /**************************************************************************/
  DefectSeriesLabel1->Caption = " Main Defect Categories ";
  DefectSeriesLabel11->Caption = " Main Defect Categories ";

  DefectSeriesLabel2->Caption = "Defect Item";
  DefectSeriesLabel22->Caption = "Defect Item";

  DefectSeriesLabel3->Caption = "Q`ty";
  DefectSeriesLabel33->Caption = "Q`ty";

  DefectSeriesLabel4->Caption = "Rate";
  DefectSeriesLabel44->Caption = "Rate";

  DefectSeriesLabel5->Caption = "Defect Item";
  DefectSeriesLabel55->Caption = "Defect Item";

  DefectSeriesLabel6->Caption = "Q`ty";
  DefectSeriesLabel66->Caption = "Q`ty";

  DefectSeriesLabel7->Caption = "Rate";
  DefectSeriesLabel77->Caption = "Rate";


  GroupBox1->Caption = "Grade Print Option";
  PrintGradeAndSizeRadioButton->Caption = "Print Grade and Size";
  PrintGradeOnlyRadioButton->Caption = "Print Only Grade";
  GroupBox3->Caption = "Page Info";
  PrintPreviewButton->Caption = "Page Preview";
  PrinterSetupButton->Caption = "Printer Setup";
  PrintButton->Caption = "Print";
  CancelButton->Caption = COMPUTERSYSTEMSETTINGFORM_BUTTON_CAPTION_03;
    
  /**************************************************************************/
  // panel3  
  // Ins Grade
  QRLabel138->Caption = "  Inspection Grade  ";
  //
  QRLabel140->Caption = "Top Inspection Grade";
  QRLabel94->Caption = "Normal Dark Dirty";
  QRLabel95->Caption = "Carve Dark Dirty";
  QRLabel96->Caption = "Edge Dark Dirty";
  QRLabel98->Caption = "Normal blurred Stain";
  QRLabel121->Caption = "Edge blurred Stain";
  QRLabel119->Caption = "Color Stain";
  //
  QRLabel141->Caption = "Side Inspection Grade";
  QRLabel102->Caption = "Side Dark Dirty";
  QRLabel103->Caption = "Side blurred Stain";
  SideGradeLabel1->Caption = "Edge(N) Blur or Spot";
  SideGradeLabel2->Caption = "Edge Blur or Spot";
  SideGradeLabel3->Caption = "Edge(N) Tablet Break";

  QRLabel104->Caption = "Thickness Defect";
  QRLabel144->Caption = "Color Stain";
  //
  QRLabel139->Caption = "Other Inspection Grade";
  QRLabel105->Caption = "Print Erase";
  //
  QRLabel113->Caption = "3D Cam Inspection Grade";
  QRLabel100->Caption = "Shape Break Except Edge ";
  QRLabel114->Caption = "Edge Shape Break";
  QRLabel116->Caption = "Carve Erase";
  //
  QRLabel124->Caption = "Color";

  // Ins Result
  QRLabel128->Caption = "  Inspection Result  ";

  QRLabel137->Caption = "Quantity";

  QRLabel135->Caption = "Total Quantity Inspection";
  QRLabel129->Caption = "Total Quantity Good";
  QRLabel130->Caption = "Total Quantity Defect";
  QRLabel301->Caption = "Total Quantity Uninspection";
  QRLabel142->Caption = "Defect Percentage";
  QRLabel136->Caption = "Yield ";

  // panel4   ũ
  //Ins Grade
  QRLabel174->Caption = "Inspection Grade";
  //top
  QRLabel179->Caption = "Top Inspection Grade";
  QRLabel180->Caption = "Normal Dark Dirty";
  QRLabel181->Caption = "Carve Dark Dirty";
  QRLabel182->Caption = "Edge Dark Dirty";
  QRLabel183->Caption = "Normal blurred Stain";
  QRLabel208->Caption = "Edge blurred Stain";
  QRLabel206->Caption = "Color Stain";
  //side
  QRLabel185->Caption = "Side Inspection Grade";
  QRLabel186->Caption = "Side Dark Dirty";
  QRLabel187->Caption = "Side blurred Stain";

  SideGradeLabel4->Caption = "Edge(N) Blur or Spot";
  SideGradeLabel5->Caption = "Edge Blur or Spot";
  SideGradeLabel6->Caption = "Edge(N) Tablet Break";

  QRLabel188->Caption = "Thickness Defect";
  QRLabel224->Caption = "Color Stain";
  //print
  QRLabel178->Caption = "Other Inspection Grade";
  QRLabel189->Caption = "Print Erase";
  //3d
  QRLabel200->Caption = "3D Cam Inspection Grade";
  QRLabel184->Caption = "Shape Break Except Edge ";
  QRLabel201->Caption = "Edge Shape Break";
  QRLabel203->Caption = "Carve Erase";
  //color
  QRLabel211->Caption = "Color";

  //Ins Result
  QRLabel156->Caption = "Inspection Result";
  QRLabel173->Caption = "Quantity";
  QRLabel170->Caption = "Total Quantity Inspection";
  QRLabel157->Caption = "Total Quantity Good";
  QRLabel158->Caption = "Total Quantity Defect";
  QRLabel302->Caption = "Total Quantity Uninspection";
  QRLabel198->Caption = "Defect Percentage";
  QRLabel171->Caption = "Yield ";

  char operName[33];
  strncpy(operName, Report.Data.OperatorName, 32);
  operName[32] = '\0';

  PassCntQRLabel3->Caption = Format("%.0n Tab", ARRAYOFCONST(((double)Report.Data.GoodTabletCount)));
  PassCntQRLabel4->Caption = Format("%.0n Tab", ARRAYOFCONST(((double)Report.Data.GoodTabletCount)));


  DefectCntQRLabel3->Caption = Format("%.0n Tab", ARRAYOFCONST(((double)Report.Data.DefectTabletCount)));
  DefectCntQRLabel4->Caption = Format("%.0n Tab", ARRAYOFCONST(((double)Report.Data.DefectTabletCount)));

  UninsCntQRLabel3->Caption = Format("%.0n Tab", ARRAYOFCONST(((double)Report.Data.UnInsTabletCount)));
  UninsCntQRLabel4->Caption = Format("%.0n Tab", ARRAYOFCONST(((double)Report.Data.UnInsTabletCount)));


  // ˻ 
  // ̰ ɼ  ׿   
  int TotalCnt = 0;
  if (PCProgramOption.IncludeUnInsTabletCount)
    TotalCnt = Report.Data.GoodTabletCount + Report.Data.DefectTabletCount + Report.Data.UnInsTabletCount;
  else
    TotalCnt = Report.Data.GoodTabletCount + Report.Data.DefectTabletCount;


  TotalCntQRLabel3->Caption = Format("%.0n Tab", ARRAYOFCONST(((double)(TotalCnt))));
  TotalCntQRLabel4->Caption = Format("%.0n Tab", ARRAYOFCONST(((double)(TotalCnt))));

  bool ValidCheck = false; //  ׸   ǰ ˻  0 ū Ȯ
  if (PCProgramOption.IncludeUnInsTabletCount)
    ValidCheck = (Report.Data.GoodTabletCount + Report.Data.DefectTabletCount + Report.Data.UnInsTabletCount > 0) ? true : false;
  else
    ValidCheck = (Report.Data.GoodTabletCount + Report.Data.DefectTabletCount > 0) ? true : false;

  if (ValidCheck)
  {
    RPassCntQRLabel3->Caption = Format("%.2f %%", ARRAYOFCONST(((double)Report.Data.GoodTabletCount * 100 / TotalCnt)));
    RDefectCntQRLabel3->Caption = Format("%.2f %%", ARRAYOFCONST(((double)Report.Data.DefectTabletCount * 100 / TotalCnt)));

    RPassCntQRLabel4->Caption = Format("%.2f %%", ARRAYOFCONST(((double)Report.Data.GoodTabletCount * 100 / TotalCnt)));
    RDefectCntQRLabel4->Caption = Format("%.2f %%", ARRAYOFCONST(((double)Report.Data.DefectTabletCount * 100 / TotalCnt)));
  }
  else
  {
    RDefectCntQRLabel3->Caption = "0%";
    RPassCntQRLabel3->Caption = "0%";

    RDefectCntQRLabel4->Caption = "0%";
    RPassCntQRLabel4->Caption = "0%";
  }
  /**************************************************************************/


  OptionBreakingGradeQRLabel3->Caption = FloatToStr((float)Report.GradeData.OptionBreakingGrade*30.0 / 10.0 / 1000.0) + " mm";
  OptionFrontStickingGradeType1QRLabel3->Caption = FloatToStr((float)Report.GradeData.OptionFrontStickingGrade_Type1*30.0 / 10.0 / 1000.0) + " mm";
  OptionFrontStickingGradeType2QRLabel3->Caption = FloatToStr((float)Report.GradeData.OptionFrontStickingGrade_Type2*30.0 / 10.0 / 1000.0) + " mm";

  OptionPrintMarkGradeQRLabel3->Caption = IntToStr(Report.GradeData.OptionPrintMarkGrade) + " % ";


  if (isPrintedTablet)
  {
    QRLabel105->Caption = "Print Erase";
  }
  else
  {
    QRLabel105->Caption = "Engrave Erase";
  }


  ThreeDHeightMinusLimitQRLabel3->Caption = "-" + FloatToStr((float)Report.GradeData.ThreeDHeightMinusLimit*0.03) + " mm";
  ThreeDHeightPlusLimitQRLabel3->Caption = "+" + FloatToStr((float)Report.GradeData.ThreeDHeightPlusLimit*0.03) + " mm";
  ThreeDHeightGradeQRLabel3->Caption = IntToStr((int)((Report.GradeData.ThreeDHeightMinusLimit + Report.GradeData.ThreeDHeightPlusLimit) * 0.03 / 2 * 10) + 1) + " grade ";
  /**************************************************************************/

  OptionBreakingGradeQRLabel4->Caption = FloatToStr((float)Report.GradeData.OptionBreakingGrade*30.0 / 10.0 / 1000.0) + " mm";
  OptionFrontStickingGradeType1QRLabel4->Caption = FloatToStr((float)Report.GradeData.OptionFrontStickingGrade_Type1*30.0 / 10.0 / 1000.0) + " mm";
  OptionFrontStickingGradeType2QRLabel4->Caption = FloatToStr((float)Report.GradeData.OptionFrontStickingGrade_Type2*30.0 / 10.0 / 1000.0) + " mm";

  OptionPrintMarkGradeQRLabel4->Caption = IntToStr(Report.GradeData.OptionPrintMarkGrade) + " % ";

  if (isPrintedTablet)
  {
    QRLabel189->Caption = "Print Erase";
  }
  else
  {
    QRLabel189->Caption = "Engrave Erase";
  }

  ThreeDHeightMinusLimitQRLabel4->Caption = "-" + FloatToStr((float)Report.GradeData.ThreeDHeightMinusLimit*0.03) + " mm";
  ThreeDHeightPlusLimitQRLabel4->Caption = "+" + FloatToStr((float)Report.GradeData.ThreeDHeightPlusLimit*0.03) + " mm";
  ThreeDHeightGradeQRLabel4->Caption = IntToStr((int)((Report.GradeData.ThreeDHeightMinusLimit + Report.GradeData.ThreeDHeightPlusLimit) * 0.03 / 2 * 10) + 1) + " grade ";

  FrontNormalDirtySizeQRLabel4->Caption = FloatToStr(DefectSizePixelToMili(Report.GradeData.FrontNormalDirtySize) / 100.0) + " mm";
  FrontEdgeDirtySizeQRLabel4->Caption = FloatToStr(DefectSizePixelToMili(Report.GradeData.FrontEdgeDirtySize) / 100.0) + " mm";
  FrontStainSizeQRLabel4->Caption = FloatToStr(DefectSizePixelToMili(Report.GradeData.FrontStainSize) / 100.0) + " mm";
  FrontEdgeSizeQRLabel4->Caption = FloatToStr(DefectSizePixelToMili(Report.GradeData.FrontEdgeSize) / 100.0) + " mm";
  FrontColorDirtySizeQRLabel4->Caption = FloatToStr(DefectSizePixelToMili(Report.GradeData.FrontColorDirtySize) / 100.0) + " mm";
  SideDirtySizeQRLabel4->Caption = FloatToStr(DefectSizePixelToMili(Report.GradeData.SideDirtySize) / 100.0) + " mm";
  SideStainSizeQRLabel4->Caption = FloatToStr(DefectSizePixelToMili(Report.GradeData.SideStainSize) / 100.0) + " mm";
  OptionBreakingSizeQRLabel4->Caption = FloatToStr(DefectSizePixelToMili(Report.GradeData.OptionBreakingSize) / 100.0) + " mm";
  OptionFrontStickingSizeType1QRLabel4->Caption = FloatToStr(DefectSizePixelToMili(Report.GradeData.OptionFrontStickingSize_Type1) / 100.0) + " mm";
  OptionFrontStickingSizeType2QRLabel4->Caption = FloatToStr(DefectSizePixelToMili(Report.GradeData.OptionFrontStickingSize_Type2) / 100.0) + " mm";

  SideColorDirtySizeQRLabel4->Caption = FloatToStr(DefectSizePixelToMili(Report.GradeData.SideColorDirtySize) / 100.0) + " mm";
  QRLLABEL11->Caption = FloatToStr((float)Report.GradeData.EngraveDistinguishGradeFor3D*30.0 / 10.0 / 100.0) + " mm";

  if (printModeOption == 0) //  
  {
    PrintGradeOnlyRadioButton->Checked = true;

    PrintSize = false;
  }
  else  //  ũ 
  {
    PrintGradeAndSizeRadioButton->Checked = true;

    PrintSize = true;
  }

  if (threeDHeightOption == 0)
  {
    ThreeDHeightMinusLimitQRLabel3->Visible = true;
    ThreeDHeightPlusLimitQRLabel3->Visible = true;
    ThreeDHeightGradeQRLabel3->Visible = false;
    ThreeDHeightGradeQRLabel3->Width = 0;
    ThreeDHeightMinusLimitQRLabel4->Visible = true;
    ThreeDHeightPlusLimitQRLabel4->Visible = true;
    ThreeDHeightGradeQRLabel4->Visible = false;
    ThreeDHeightGradeQRLabel4->Width = 0;
  }
  else
  {
    ThreeDHeightMinusLimitQRLabel3->Visible = false;
    ThreeDHeightMinusLimitQRLabel3->Width = 0;
    ThreeDHeightPlusLimitQRLabel3->Visible = false;
    ThreeDHeightPlusLimitQRLabel3->Width = 0;
    ThreeDHeightGradeQRLabel3->Visible = true;
    ThreeDHeightMinusLimitQRLabel4->Visible = false;
    ThreeDHeightMinusLimitQRLabel4->Width = 0;
    ThreeDHeightPlusLimitQRLabel4->Visible = false;
    ThreeDHeightPlusLimitQRLabel4->Width = 0;
    ThreeDHeightGradeQRLabel4->Visible = true;
  }

  if(ProductData.TabletType == TABLET_TYPE_SUGAR_COATED)
  {
    SideGradeLabel5->Caption = "";
    SideGradeLabel4->Caption = "";
    SideGradeLabel6->Caption = "";
    SideEdgeDarkIntensityLabel2->Caption = "";
    SideEdgeBrightIntensityLabel2->Caption = "";
    SideEdgeNeighborIntensityLabel2->Caption = "";
    SideEdgeBreakIntensityLabel2->Caption = "";

    SideGradeLabel2->Caption = "";
    SideGradeLabel1->Caption = "";
    SideGradeLabel3->Caption = "";
    SideEdgeDarkIntensityLabel1->Caption = "";
    SideEdgeBrightIntensityLabel1->Caption = "";
    SideEdgeNeighborIntensityLabel1->Caption = "";
    SideEdgeBreakIntensityLabel1->Caption = "";
    SideEdgeDarkSizeLabel1->Caption = "";
    SideEdgeBrightSizeLabel1->Caption = "";
    SideEdgeNeighborSizeLabel1->Caption = "";
    SideEdgeBreakSizeLabel1->Caption = "";
  }

	//ǥ ҷ ̹  ۼ
	PrintImageIndexLoad();
	QRLabel122->Caption = V6_REPORT_PRINT_FORM_ADD_10; // "ǥ ҷ ̹"; //

	int i, CountImage;
	CountImage = 0;
	newImagePageIndex = 0;
	for (i = 0; i < 12; i++)
	{
		if (PrintImageIndex.DefectImageIndex[i] != 0xAAAA)
			CountImage++;
	}

	if (CountImage > 6)
	{
		if (CountImage > 12)
			CountImage = 12;

		newImagePageIndex = (CountImage - 1) / 6;
		CreateNewDefectImagePage();
	}

	if (CountImage)
		FillDefectImageReport(ProductName, lotName, CountImage);

  UpdateTotalReportPages(0);
}
//---------------------------------------------------------------------------

void __fastcall TPrintInspectionResult_Ajanta_Form::FormCreate(TObject *Sender)
{
	bYuhanOption = false;
  ControlInspectionResultChart();  
}
//---------------------------------------------------------------------------

void __fastcall TPrintInspectionResult_Ajanta_Form::PrintPreviewButtonClick(
	TObject *Sender)
{
	QRCompositeReport1->Preview();
}
//---------------------------------------------------------------------------

void __fastcall TPrintInspectionResult_Ajanta_Form::CancelButtonClick(
	TObject *Sender)
{

	if (newImagePageIndex > 0)
	{
		TQuickRep *tempQR;
		for (int PIndex = 1; PIndex <= newImagePageIndex; PIndex++)
		{
			tempQR = (TQuickRep*)FindComponent("newImageQR" + IntToStr(PIndex));
			delete tempQR;
		}
	}

	this->Close();
}
//---------------------------------------------------------------------------

void __fastcall TPrintInspectionResult_Ajanta_Form::PrintButtonClick(TObject *Sender)
{
	QRCompositeReport1->Print();
}
//---------------------------------------------------------------------------
void __fastcall TPrintInspectionResult_Ajanta_Form::PrinterSetupButtonClick(
	TObject *Sender)
{
	QRCompositeReport1->PrinterSetup();
}
//---------------------------------------------------------------------------

void __fastcall TPrintInspectionResult_Ajanta_Form::PrintGradeOnlyRadioButtonClick(
	TObject *Sender)
{
	UpdateTotalReportPages(0);
	if (PrintDefectSeriesCheckBox->Checked)
		ReportPanel3->BringToFront();

	PrintSize = false;
}
//---------------------------------------------------------------------------

void __fastcall TPrintInspectionResult_Ajanta_Form::PrintGradeAndSizeRadioButtonClick(
	TObject *Sender)
{
	UpdateTotalReportPages(0);
	if (PrintDefectSeriesCheckBox->Checked)
		ReportPanel4->BringToFront();

	PrintSize = true;
}
//---------------------------------------------------------------------------

void __fastcall TPrintInspectionResult_Ajanta_Form::PrintDefectSeriesCheckBoxClick(
	TObject *Sender)
{
	UpdateTotalReportPages(0);
	if (PrintDefectSeriesCheckBox->Checked)
	{
		if (PrintGradeOnlyRadioButton->Checked)
		{
			//ReportPanel3->BringToFront();
			PrintSize = false;
		}
		else if (PrintGradeAndSizeRadioButton->Checked)
		{
			//ReportPanel4->BringToFront();
			PrintSize = true;
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TPrintInspectionResult_Ajanta_Form::CreateNewDefectImagePage()
{
	int pageIndex;

	for (pageIndex = 1; pageIndex <= newImagePageIndex; pageIndex++)
	{
		//Report
		TQuickRep *tempQR = (TQuickRep*)FindComponent("newImageQR" + IntToStr(pageIndex));
		if (tempQR != NULL)
			continue;

		TQuickRep * pQR = new TQuickRep(this);
		pQR->Name = "newImageQR" + IntToStr(pageIndex);
		pQR->Parent = ReportPanel5;


		// QRBand 
		TQRBand *pQRBand1 = new TQRBand(this);
		pQRBand1->Parent = pQR;
		pQRBand1->Name = "newImageQRBand" + IntToStr(pageIndex * 2 - 1);
		pQRBand1->Left = QRBand9->Left;
		pQRBand1->Top = QRBand9->Top;
		pQRBand1->Width = QRBand9->Width;
		pQRBand1->Height = QRBand9->Height;
		pQRBand1->BandType = QRBand9->BandType;


		//ϴ QRBand
		TQRBand *pQRBand2 = new TQRBand(this);
		pQRBand2->Parent = pQR;
		pQRBand2->Name = "newImageQRBand" + IntToStr(pageIndex * 2);
		pQRBand2->Left = QRBand10->Left;
		pQRBand2->Top = QRBand10->Top;
		pQRBand2->Width = QRBand10->Width;
		pQRBand2->Height = QRBand10->Height;
		pQRBand2->BandType = QRBand10->BandType;



		// Main Title
		TQRLabel *pQRMainTitle = new TQRLabel(this);
		pQRMainTitle->Parent = pQRBand1;
		pQRMainTitle->Name = "ImageQRMainTitle" + IntToStr(pageIndex);
		pQRMainTitle->Left = QRLabel122->Left;
		pQRMainTitle->Top = QRLabel122->Top;
		pQRMainTitle->Width = QRLabel122->Width;
		pQRMainTitle->Caption = QRLabel122->Caption;
		pQRMainTitle->Font = QRLabel122->Font;
		pQRMainTitle->Height = QRLabel122->Height;
		pQRMainTitle->Alignment = pQRMainTitle->Alignment;
		pQRMainTitle->AutoSize = pQRMainTitle->AutoSize;

		//Frame 
		for (int FrameIndex = 1; FrameIndex <= 16; FrameIndex++)
		{
			int tempComponentIndex = pageIndex * 16 - (16 - FrameIndex);
			TQRShape *pBaseFrame = new TQRShape(this);
			pBaseFrame->Parent = pQRBand2;
			pBaseFrame->Name = "newImageBaseFrame" + IntToStr(tempComponentIndex);
			pBaseFrame->Left = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Left;
			pBaseFrame->Top = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Top;
			pBaseFrame->Width = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Width;
			pBaseFrame->Height = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Height;
			pBaseFrame->Shape = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Shape;
			pBaseFrame->Enabled = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Enabled;
			pBaseFrame->Cursor = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Cursor;

			pBaseFrame->Frame->Color = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Frame->Color;
			pBaseFrame->Frame->DrawBottom = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Frame->DrawBottom;
			pBaseFrame->Frame->DrawLeft = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Frame->DrawLeft;
			pBaseFrame->Frame->DrawRight = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Frame->DrawRight;
			pBaseFrame->Frame->DrawTop = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Frame->DrawTop;
			pBaseFrame->Frame->Style = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Frame->Style;
			pBaseFrame->Frame->Width = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Frame->Width;

			pBaseFrame->Brush->Color = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Brush->Color;
			pBaseFrame->Brush->Style = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Brush->Style;

			pBaseFrame->Pen->Color = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Pen->Color;
			pBaseFrame->Pen->Mode = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Pen->Mode;
			pBaseFrame->Pen->Style = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Pen->Style;
			pBaseFrame->Pen->Width = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Pen->Width;

			pBaseFrame->Size->Height = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Size->Height;
			pBaseFrame->Size->Width = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Size->Width;
			pBaseFrame->Size->Top = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Size->Top;
			pBaseFrame->Size->Left = ((TQRShape*)FindComponent("QRImageFrame" + IntToStr(FrameIndex)))->Size->Left;
		}

		// QRDefectNameLabel
		for (int SortIndex = 1; SortIndex <= 6; SortIndex++)
		{
			TQRLabel *pQRDefectNameLabel = new TQRLabel(this);
			pQRDefectNameLabel->Parent = pQRBand2;
			pQRDefectNameLabel->Name = "QRDefectNameLabel" + IntToStr((pageIndex + 1) * 6 - (6 - SortIndex));
			pQRDefectNameLabel->Left = ((TQRLabel*)FindComponent("QRDefectNameLabel" + IntToStr(SortIndex)))->Left;
			pQRDefectNameLabel->Top = ((TQRLabel*)FindComponent("QRDefectNameLabel" + IntToStr(SortIndex)))->Top;
			pQRDefectNameLabel->Width = ((TQRLabel*)FindComponent("QRDefectNameLabel" + IntToStr(SortIndex)))->Width;

			pQRDefectNameLabel->Font = ((TQRLabel*)FindComponent("QRDefectNameLabel" + IntToStr(SortIndex)))->Font;
			pQRDefectNameLabel->Height = ((TQRLabel*)FindComponent("QRDefectNameLabel" + IntToStr(SortIndex)))->Height;
			pQRDefectNameLabel->Alignment = ((TQRLabel*)FindComponent("QRDefectNameLabel" + IntToStr(SortIndex)))->Alignment;
			pQRDefectNameLabel->AutoSize = ((TQRLabel*)FindComponent("QRDefectNameLabel" + IntToStr(SortIndex)))->AutoSize;

			pQRDefectNameLabel->Size->Height = ((TQRLabel*)FindComponent("QRDefectNameLabel" + IntToStr(SortIndex)))->Size->Height;
			pQRDefectNameLabel->Size->Width = ((TQRLabel*)FindComponent("QRDefectNameLabel" + IntToStr(SortIndex)))->Size->Width;
			pQRDefectNameLabel->Size->Top = ((TQRLabel*)FindComponent("QRDefectNameLabel" + IntToStr(SortIndex)))->Size->Top;
			pQRDefectNameLabel->Size->Left = ((TQRLabel*)FindComponent("QRDefectNameLabel" + IntToStr(SortIndex)))->Size->Left;
			pQRDefectNameLabel->Caption = "";
		}

		// QRDefectNameContent
		for (int SortIndex = 1; SortIndex <= 6; SortIndex++)
		{
			TQRLabel *pQRDefectNameContentLabel = new TQRLabel(this);
			pQRDefectNameContentLabel->Parent = pQRBand2;
			pQRDefectNameContentLabel->Name = "QRDefectNameContent" + IntToStr((pageIndex + 1) * 6 - (6 - SortIndex));
			pQRDefectNameContentLabel->Left = ((TQRLabel*)FindComponent("QRDefectNameContent" + IntToStr(SortIndex)))->Left;
			pQRDefectNameContentLabel->Top = ((TQRLabel*)FindComponent("QRDefectNameContent" + IntToStr(SortIndex)))->Top;
			pQRDefectNameContentLabel->Width = ((TQRLabel*)FindComponent("QRDefectNameContent" + IntToStr(SortIndex)))->Width;

			pQRDefectNameContentLabel->Font = ((TQRLabel*)FindComponent("QRDefectNameContent" + IntToStr(SortIndex)))->Font;
			pQRDefectNameContentLabel->Height = ((TQRLabel*)FindComponent("QRDefectNameContent" + IntToStr(SortIndex)))->Height;
			pQRDefectNameContentLabel->Alignment = ((TQRLabel*)FindComponent("QRDefectNameContent" + IntToStr(SortIndex)))->Alignment;
			pQRDefectNameContentLabel->AutoSize = ((TQRLabel*)FindComponent("QRDefectNameContent" + IntToStr(SortIndex)))->AutoSize;

			pQRDefectNameContentLabel->Size->Height = ((TQRLabel*)FindComponent("QRDefectNameContent" + IntToStr(SortIndex)))->Size->Height;
			pQRDefectNameContentLabel->Size->Width = ((TQRLabel*)FindComponent("QRDefectNameContent" + IntToStr(SortIndex)))->Size->Width;
			pQRDefectNameContentLabel->Size->Top = ((TQRLabel*)FindComponent("QRDefectNameContent" + IntToStr(SortIndex)))->Size->Top;
			pQRDefectNameContentLabel->Size->Left = ((TQRLabel*)FindComponent("QRDefectNameContent" + IntToStr(SortIndex)))->Size->Left;
			pQRDefectNameContentLabel->Caption = "";
		}

		// QRDefectSizeLabel
		for (int SortIndex = 1; SortIndex <= 6; SortIndex++)
		{
			TQRLabel *pQRDefectSizeLabel = new TQRLabel(this);
			pQRDefectSizeLabel->Parent = pQRBand2;
			pQRDefectSizeLabel->Name = "QRDefectSizeLabel" + IntToStr((pageIndex + 1) * 6 - (6 - SortIndex));
			pQRDefectSizeLabel->Left = ((TQRLabel*)FindComponent("QRDefectSizeLabel" + IntToStr(SortIndex)))->Left;
			pQRDefectSizeLabel->Top = ((TQRLabel*)FindComponent("QRDefectSizeLabel" + IntToStr(SortIndex)))->Top;
			pQRDefectSizeLabel->Width = ((TQRLabel*)FindComponent("QRDefectSizeLabel" + IntToStr(SortIndex)))->Width;

			pQRDefectSizeLabel->Font = ((TQRLabel*)FindComponent("QRDefectSizeLabel" + IntToStr(SortIndex)))->Font;
			pQRDefectSizeLabel->Height = ((TQRLabel*)FindComponent("QRDefectSizeLabel" + IntToStr(SortIndex)))->Height;
			pQRDefectSizeLabel->Alignment = ((TQRLabel*)FindComponent("QRDefectSizeLabel" + IntToStr(SortIndex)))->Alignment;
			pQRDefectSizeLabel->AutoSize = ((TQRLabel*)FindComponent("QRDefectSizeLabel" + IntToStr(SortIndex)))->AutoSize;

			pQRDefectSizeLabel->Size->Height = ((TQRLabel*)FindComponent("QRDefectSizeLabel" + IntToStr(SortIndex)))->Size->Height;
			pQRDefectSizeLabel->Size->Width = ((TQRLabel*)FindComponent("QRDefectSizeLabel" + IntToStr(SortIndex)))->Size->Width;
			pQRDefectSizeLabel->Size->Top = ((TQRLabel*)FindComponent("QRDefectSizeLabel" + IntToStr(SortIndex)))->Size->Top;
			pQRDefectSizeLabel->Size->Left = ((TQRLabel*)FindComponent("QRDefectSizeLabel" + IntToStr(SortIndex)))->Size->Left;
			pQRDefectSizeLabel->Caption = "";
		}

		// QRDefectSizeContent
		for (int SortIndex = 1; SortIndex <= 6; SortIndex++)
		{
			TQRLabel *pQRDefectSizeContent = new TQRLabel(this);
			pQRDefectSizeContent->Parent = pQRBand2;
			pQRDefectSizeContent->Name = "QRDefectSizeContent" + IntToStr((pageIndex + 1) * 6 - (6 - SortIndex));
			pQRDefectSizeContent->Left = ((TQRLabel*)FindComponent("QRDefectSizeContent" + IntToStr(SortIndex)))->Left;
			pQRDefectSizeContent->Top = ((TQRLabel*)FindComponent("QRDefectSizeContent" + IntToStr(SortIndex)))->Top;
			pQRDefectSizeContent->Width = ((TQRLabel*)FindComponent("QRDefectSizeContent" + IntToStr(SortIndex)))->Width;

			pQRDefectSizeContent->Font = ((TQRLabel*)FindComponent("QRDefectSizeContent" + IntToStr(SortIndex)))->Font;
			pQRDefectSizeContent->Height = ((TQRLabel*)FindComponent("QRDefectSizeContent" + IntToStr(SortIndex)))->Height;
			pQRDefectSizeContent->Alignment = ((TQRLabel*)FindComponent("QRDefectSizeContent" + IntToStr(SortIndex)))->Alignment;
			pQRDefectSizeContent->AutoSize = ((TQRLabel*)FindComponent("QRDefectSizeContent" + IntToStr(SortIndex)))->AutoSize;

			pQRDefectSizeContent->Size->Height = ((TQRLabel*)FindComponent("QRDefectSizeContent" + IntToStr(SortIndex)))->Size->Height;
			pQRDefectSizeContent->Size->Width = ((TQRLabel*)FindComponent("QRDefectSizeContent" + IntToStr(SortIndex)))->Size->Width;
			pQRDefectSizeContent->Size->Top = ((TQRLabel*)FindComponent("QRDefectSizeContent" + IntToStr(SortIndex)))->Size->Top;
			pQRDefectSizeContent->Size->Left = ((TQRLabel*)FindComponent("QRDefectSizeContent" + IntToStr(SortIndex)))->Size->Left;
			pQRDefectSizeContent->Caption = "";
		}


		// QRImage
		for (int SortIndex = 1; SortIndex <= 6; SortIndex++)
		{
			TQRImage *pQRImage = new TQRImage(this);
			pQRImage->Parent = pQRBand2;
			pQRImage->Name = "QRImage" + IntToStr((pageIndex + 1) * 6 - (6 - SortIndex));
			pQRImage->Left = ((TQRImage*)FindComponent("QRImage" + IntToStr(SortIndex)))->Left;
			pQRImage->Top = ((TQRImage*)FindComponent("QRImage" + IntToStr(SortIndex)))->Top;
			pQRImage->Width = ((TQRImage*)FindComponent("QRImage" + IntToStr(SortIndex)))->Width;

			pQRImage->Height = ((TQRImage*)FindComponent("QRImage" + IntToStr(SortIndex)))->Height;
			pQRImage->AutoSize = ((TQRImage*)FindComponent("QRImage" + IntToStr(SortIndex)))->AutoSize;
			pQRImage->Stretch = ((TQRImage*)FindComponent("QRImage" + IntToStr(SortIndex)))->Stretch;

			pQRImage->Size->Height = ((TQRImage*)FindComponent("QRImage" + IntToStr(SortIndex)))->Size->Height;
			pQRImage->Size->Width = ((TQRImage*)FindComponent("QRImage" + IntToStr(SortIndex)))->Size->Width;
			pQRImage->Size->Top = ((TQRImage*)FindComponent("QRImage" + IntToStr(SortIndex)))->Size->Top;
			pQRImage->Size->Left = ((TQRImage*)FindComponent("QRImage" + IntToStr(SortIndex)))->Size->Left;
		}

		TQRLabel * pQRLabel = new TQRLabel(this);
		pQRLabel->Parent = pQRBand2;

		pQRLabel->Left = ((TQRLabel*)FindComponent("QRPageDfImage0"))->Left;
		pQRLabel->Top = ((TQRLabel*)FindComponent("QRPageDfImage0"))->Top;
		pQRLabel->Width = ((TQRLabel*)FindComponent("QRPageDfImage0"))->Width;

		pQRLabel->Font = ((TQRLabel*)FindComponent("QRPageDfImage0"))->Font;
		pQRLabel->Height = ((TQRLabel*)FindComponent("QRPageDfImage0"))->Height;
		pQRLabel->Alignment = ((TQRLabel*)FindComponent("QRPageDfImage0"))->Alignment;
		pQRLabel->AutoSize = ((TQRLabel*)FindComponent("QRPageDfImage0"))->AutoSize;
		pQRLabel->Caption = "";

		pQRLabel->Name = "QRPageDfImage" + IntToStr(pageIndex);
		pQRLabel->Visible = false;
		pQRLabel->Enabled = false;

	}
}
//---------------------------------------------------------------------------
void __fastcall TPrintInspectionResult_Ajanta_Form::RefreshDefectsInfo(int totalDefectCount)
{
	const int DISPLAY_DEFECT_COUNT = 10;
	int DefectCountList[MAX_DEFECT_SERIES_COUNT + 1];
	int DefectSeriesList[MAX_DEFECT_SERIES_COUNT + 1];
  int HCBDefectTabletCount;

  if(MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
  {
    HCBDefectTabletCount = Report.Data.SPBProcessingNCTabletCount + Report.Data.FRMisMatchTabletCount + Report.Data.ClosedTabletDefectCount + Report.Data.NozzErrorDefectTabletCount;
  }
  else
  {
    HCBDefectTabletCount = Report.Data.SPBProcessingNCTabletCount + Report.Data.FRMisMatchTabletCount + Report.Data.ClosedTabletDefectCount + Report.Data.NozzErrorDefectTabletCount + Report.Data.UnPrintTabletCount;
  }

	for (int defectSeriesIndex = 0; defectSeriesIndex < MAX_DEFECT_SERIES_COUNT + 1; defectSeriesIndex++)
	{
		DefectCountList[defectSeriesIndex] = DefectSeriesCount[defectSeriesIndex];
		if (defectSeriesIndex < MAX_CPB_DEFECT_SERIES_COUNT)
		{
			DefectSeriesList[defectSeriesIndex] = defectSeriesIndex;
		}
		else
		{
			DefectSeriesList[defectSeriesIndex] = defectSeriesIndex - MAX_CPB_DEFECT_SERIES_COUNT + THIN_TALBET;
		}
	}

	for (int i = 0; i < MAX_DEFECT_SERIES_COUNT; i++)
	{
		for (int j = i; j < MAX_DEFECT_SERIES_COUNT; j++)
		{
			if (DefectCountList[i] < DefectCountList[j])
			{
				int temp = DefectCountList[i];
				DefectCountList[i] = DefectCountList[j];
				DefectCountList[j] = temp;

				temp = DefectSeriesList[i];
				DefectSeriesList[i] = DefectSeriesList[j];
				DefectSeriesList[j] = temp;
			}
		}
	}

	double defectCountList[DISPLAY_DEFECT_COUNT];
	int defectSeriesList[DISPLAY_DEFECT_COUNT];
	int defectSeriesCount = 0;
	defectCountList[DISPLAY_DEFECT_COUNT - 1] = 0;
	for (int defectSeriesIndex = 0; defectSeriesIndex < MAX_DEFECT_SERIES_COUNT; defectSeriesIndex++)
	{
		if (DefectCountList[defectSeriesIndex] > 0)
		{
			if (defectSeriesCount < DISPLAY_DEFECT_COUNT - 1)
			{
				defectCountList[defectSeriesCount] = DefectCountList[defectSeriesIndex];
				defectSeriesList[defectSeriesCount] = DefectSeriesList[defectSeriesIndex];
				defectSeriesCount++;
			}
			else
			{
				defectCountList[DISPLAY_DEFECT_COUNT - 1] += DefectCountList[defectSeriesIndex];
			}
		}
	}

  defectCountList[DISPLAY_DEFECT_COUNT - 1] += HCBDefectTabletCount;

	defectCountList[defectSeriesCount] = defectCountList[DISPLAY_DEFECT_COUNT - 1];

	int otherSW;
	int defectCount;
	int otherDefectCount;
	int lastDefectSeriesIndex;

	defectCount = 0;
	otherSW = 0;
	otherDefectCount = 0;

	for (int defectSeriesIndex = 0; defectSeriesIndex < DISPLAY_DEFECT_COUNT; defectSeriesIndex++)
	{
		TQRLabel *defectNameLabel = (TQRLabel *)FindComponent("DefectNameLabel" + IntToStr(defectSeriesIndex + 1));
		TQRLabel *defectCountLabel = (TQRLabel *)FindComponent("DefectCountLabel" + IntToStr(defectSeriesIndex + 1));
		TQRLabel *defectRatioLabel = (TQRLabel *)FindComponent("DefectRatioLabel" + IntToStr(defectSeriesIndex + 1));
		if (defectCountList[defectSeriesIndex] > 0 && defectSeriesIndex <= defectSeriesCount)
		{
			if (defectNameLabel)
			{
				if (defectSeriesIndex == defectSeriesCount)
				{
					defectNameLabel->Caption = INSPECTIONREPORTFORM_LABEL_CAPTION_05;
					otherSW = 1;
				}
				else
				{
					defectNameLabel->Caption = GetDefectSeriesStr(defectSeriesList[defectSeriesIndex]);
				}
				defectNameLabel->Visible = true;
			}
			if (defectCountLabel)
			{
				if (otherSW)
				{
					otherDefectCount = totalDefectCount - defectCount;

					if (otherDefectCount > -1)
					{
						defectCountLabel->Caption = FloatToStrF((float)otherDefectCount, ffNumber, 10, 0);
						defectCountLabel->Visible = true;
					}
				}
				else
				{
					defectCountLabel->Caption = FloatToStrF((float)defectCountList[defectSeriesIndex], ffNumber, 10, 0);
					defectCountLabel->Visible = true;

					defectCount += defectCountList[defectSeriesIndex];

					lastDefectSeriesIndex = defectSeriesIndex;
				}
			}
			if (defectRatioLabel)
			{
				if (otherSW)
				{
					if (totalDefectCount)
					{
						if (otherDefectCount > -1)
							defectRatioLabel->Caption = FloatToStrF((otherDefectCount / (float)totalDefectCount) * 100, ffFixed, 10, 2);
					}
					else
						defectRatioLabel->Caption = "0";

					defectRatioLabel->Visible = true;
				}
				else
				{
					if (totalDefectCount)
						defectRatioLabel->Caption = FloatToStrF((defectCountList[defectSeriesIndex] / totalDefectCount) * 100, ffFixed, 10, 2);
					else
						defectRatioLabel->Caption = "0";

					defectRatioLabel->Visible = true;
				}
			}
		}
		else
		{
			if (defectNameLabel)
			{
				defectNameLabel->Caption = GetDefectSeriesStr(defectSeriesList[defectSeriesIndex]);
				defectNameLabel->Caption = "";
			}
			if (defectCountLabel)
			{
				defectCountLabel->Caption = FloatToStrF((float)defectCountList[defectSeriesIndex], ffNumber, 10, 0);
				defectCountLabel->Caption = "";
			}
			if (defectRatioLabel)
			{
				if (totalDefectCount)
					defectRatioLabel->Caption = FloatToStr(defectCountList[defectSeriesIndex] / totalDefectCount);
				else
					defectRatioLabel->Caption = "0";

				defectRatioLabel->Caption = "";
			}
		}
	}

	if (otherSW == 0)
	{
		if (totalDefectCount > defectCount)
		{
			otherDefectCount = totalDefectCount - defectCount;

			TQRLabel *defectNameLabel = (TQRLabel *)FindComponent("DefectNameLabel" + IntToStr(lastDefectSeriesIndex + 1 + 1));
			TQRLabel *defectCountLabel = (TQRLabel *)FindComponent("DefectCountLabel" + IntToStr(lastDefectSeriesIndex + 1 + 1));
			TQRLabel *defectRatioLabel = (TQRLabel *)FindComponent("DefectRatioLabel" + IntToStr(lastDefectSeriesIndex + 1 + 1));

			if (defectNameLabel)
			{
				defectNameLabel->Caption = INSPECTIONREPORTFORM_LABEL_CAPTION_05;
				defectNameLabel->Visible = true;
			}
			if (defectCountLabel)
			{
				defectCountLabel->Caption = FloatToStrF((float)otherDefectCount, ffNumber, 10, 0);
				defectCountLabel->Visible = true;
			}
			if (defectRatioLabel)
			{
				defectRatioLabel->Caption = FloatToStrF((otherDefectCount / (float)totalDefectCount) * 100, ffFixed, 10, 2);
				defectRatioLabel->Visible = true;
			}
		}
	}

	defectCount = 0;
	otherSW = 0;
	otherDefectCount = 0;

	for (int defectSeriesIndex = 0; defectSeriesIndex < DISPLAY_DEFECT_COUNT; defectSeriesIndex++)
	{
		TQRLabel *defectNameLabel = (TQRLabel *)FindComponent("bDefectNameLabel" + IntToStr(defectSeriesIndex + 1));
		TQRLabel *defectCountLabel = (TQRLabel *)FindComponent("bDefectCountLabel" + IntToStr(defectSeriesIndex + 1));
		TQRLabel *defectRatioLabel = (TQRLabel *)FindComponent("bDefectRatioLabel" + IntToStr(defectSeriesIndex + 1));

		if (defectCountList[defectSeriesIndex] > 0 && defectSeriesIndex <= defectSeriesCount)
		{
			if (defectNameLabel)
			{
				if (defectSeriesIndex == defectSeriesCount)
				{
					defectNameLabel->Caption = INSPECTIONREPORTFORM_LABEL_CAPTION_05;
					otherSW = 1;
				}
				else
				{
					defectNameLabel->Caption = GetDefectSeriesStr(defectSeriesList[defectSeriesIndex]);
				}
				defectNameLabel->Visible = true;
			}
			if (defectCountLabel)
			{
				if (otherSW)
				{
					otherDefectCount = totalDefectCount - defectCount;

					if (otherDefectCount > -1)
					{
						defectCountLabel->Caption = FloatToStrF((float)otherDefectCount, ffNumber, 10, 0);
						defectCountLabel->Visible = true;
					}
				}
				else
				{
					defectCountLabel->Caption = FloatToStrF((float)defectCountList[defectSeriesIndex], ffNumber, 10, 0);
					defectCountLabel->Visible = true;

					defectCount += defectCountList[defectSeriesIndex];

					lastDefectSeriesIndex = defectSeriesIndex;
				}
			}
			if (defectRatioLabel)
			{
				if (otherSW)
				{
					if (totalDefectCount)
					{
						if (otherDefectCount > -1)
							defectRatioLabel->Caption = FloatToStrF((otherDefectCount / (float)totalDefectCount) * 100, ffFixed, 10, 2);
					}
					else
						defectRatioLabel->Caption = "0";

					defectRatioLabel->Visible = true;
				}
				else
				{
					if (totalDefectCount)
						defectRatioLabel->Caption = FloatToStrF((defectCountList[defectSeriesIndex] / totalDefectCount) * 100, ffFixed, 10, 2);
					else
						defectRatioLabel->Caption = "0";

					defectRatioLabel->Visible = true;
				}
			}
		}
		else
		{
			if (defectNameLabel)
			{
				defectNameLabel->Caption = GetDefectSeriesStr(defectSeriesList[defectSeriesIndex]);
				defectNameLabel->Caption = "";
			}
			if (defectCountLabel)
			{
				defectCountLabel->Caption = FloatToStrF((float)defectCountList[defectSeriesIndex], ffNumber, 10, 0);
				defectCountLabel->Caption = "";
			}
			if (defectRatioLabel)
			{
				if (totalDefectCount)
					defectRatioLabel->Caption = FloatToStr(defectCountList[defectSeriesIndex] / totalDefectCount);
				else
					defectRatioLabel->Caption = "0";

				defectRatioLabel->Caption = "";
			}
		}
	}

	if (otherSW == 0)
	{
		if (totalDefectCount > defectCount)
		{
			otherDefectCount = totalDefectCount - defectCount;

			TQRLabel *defectNameLabel = (TQRLabel *)FindComponent("bDefectNameLabel" + IntToStr(lastDefectSeriesIndex + 1 + 1));
			TQRLabel *defectCountLabel = (TQRLabel *)FindComponent("bDefectCountLabel" + IntToStr(lastDefectSeriesIndex + 1 + 1));
			TQRLabel *defectRatioLabel = (TQRLabel *)FindComponent("bDefectRatioLabel" + IntToStr(lastDefectSeriesIndex + 1 + 1));

			if (defectNameLabel)
			{
				defectNameLabel->Caption = INSPECTIONREPORTFORM_LABEL_CAPTION_05;
				defectNameLabel->Visible = true;
			}
			if (defectCountLabel)
			{
				defectCountLabel->Caption = FloatToStrF((float)otherDefectCount, ffNumber, 10, 0);
				defectCountLabel->Visible = true;
			}
			if (defectRatioLabel)
			{
				defectRatioLabel->Caption = FloatToStrF((otherDefectCount / (float)totalDefectCount) * 100, ffFixed, 10, 2);
				defectRatioLabel->Visible = true;
			}
		}
	}
}

//---------------------------------------------------------------------------
void __fastcall TPrintInspectionResult_Ajanta_Form::FillDefectImageReport(AnsiString productName, AnsiString lotName, int displayCnt)
{
	AnsiString saveImageFileName;
	AnsiString saveDir = GetDefectDataPath(productName, lotName);

	int DefectCountList[12];
	int DefectSeriesList[12];

	for (int defectSeriesIndex = 0; defectSeriesIndex < displayCnt + 1; defectSeriesIndex++)
	{
		DefectCountList[defectSeriesIndex] = DefectSeriesCount[defectSeriesIndex];
		if (defectSeriesIndex < displayCnt)
		{
			DefectSeriesList[defectSeriesIndex] = defectSeriesIndex;
		}
		else
		{
			DefectSeriesList[defectSeriesIndex] = defectSeriesIndex - displayCnt + THIN_TALBET;
		}
	}

	for (int i = 0; i < displayCnt; i++)
	{
		for (int j = i; j < displayCnt; j++)
		{
			if (DefectCountList[i] < DefectCountList[j])
			{
				int temp = DefectCountList[i];
				DefectCountList[i] = DefectCountList[j];
				DefectCountList[j] = temp;

				temp = DefectSeriesList[i];
				DefectSeriesList[i] = DefectSeriesList[j];
				DefectSeriesList[j] = temp;
			}
		}
	}
	//
	for (int idx = 0; idx < 12; idx++)
	{
		TQRImage *pQRImage;
		pQRImage = (TQRImage*)FindComponent("QRImage" + IntToStr(idx + 1));
		if (pQRImage != NULL)
		{
			pQRImage->Canvas->Brush->Color = clWhite;
			pQRImage->Canvas->FillRect(Rect(0, 0, 640, 480));
			pQRImage->Repaint();

			TQRLabel *pQRDefectNameContent;
			pQRDefectNameContent = (TQRLabel*)FindComponent("QRDefectNameContent" + IntToStr(idx + 1));
			pQRDefectNameContent->Caption = "";

			TQRLabel *pQRDefectSizeContent;
			pQRDefectSizeContent = (TQRLabel*)FindComponent("QRDefectSizeContent" + IntToStr(idx + 1));
			pQRDefectSizeContent->Caption = "";
		}
	}

	//
	for (int idx = 0; idx < displayCnt; idx++)
	{
		TQRImage *pQRImage;
		pQRImage = (TQRImage*)FindComponent("QRImage" + IntToStr(idx + 1));
		saveImageFileName = "Image" + IntToStr(PrintImageIndex.DefectImageIndex[idx] + 1) + ".fbm";
		TTntImage *pBmp = new TTntImage(this);
		if (ExtractImageFromContainer(pQRImage->Picture->Bitmap, GetDefectContainerFileName(PrintImageIndex.DefectImageIndex[idx], productName, lotName), saveImageFileName, false, NULL, ProductData.SubSamplingMode))
		{
      if (pQRImage->Picture->Bitmap->Width == SYSTEM_CAMERA_HD_WIDTH && ProductData.SubSamplingMode == IMAGE_FULL_SCALE_MODE)
      {
        ReductionImageScale(pQRImage->Picture->Bitmap);
      }
      
			TQRLabel *pQRDefectNameLabel;
			pQRDefectNameLabel = (TQRLabel*)FindComponent("QRDefectNameLabel" + IntToStr(idx + 1));
			pQRDefectNameLabel->Caption = V6_REPORT_PRINT_FORM_ADD_11;  //"ҷ ׸";  //

			TQRLabel *pQRDefectSizeLabel;
			pQRDefectNameLabel = (TQRLabel*)FindComponent("QRDefectSizeLabel" + IntToStr(idx + 1));
			pQRDefectNameLabel->Caption = V6_REPORT_PRINT_FORM_ADD_12;   //     "ҷ ũ";  //

			TQRLabel *pQRDefectNameContent;
			pQRDefectNameLabel = (TQRLabel*)FindComponent("QRDefectNameContent" + IntToStr(idx + 1));
			pQRDefectNameLabel->Caption = GetDefectSeriesStr(PrintImageIndex.DefectSeries[idx]);

			TQRLabel *pQRDefectSizeContent;
			pQRDefectNameLabel = (TQRLabel*)FindComponent("QRDefectSizeContent" + IntToStr(idx + 1));
			pQRDefectNameLabel->Caption = FloatToStr(DefectSizePixelToMili(PrintImageIndex.DefectSize[idx]) / 100.0) + "mm";
		} 
	}
}

AnsiString __fastcall TPrintInspectionResult_Ajanta_Form::GetDefectContainerFileName(int defectIndex, AnsiString productName, AnsiString lotName)
{
	int containerIndex = defectIndex / DEFECT_DATA_CONTAINER_SIZE;
	AnsiString saveDir = ProgramPath.Defect + "\\" + productName + "\\" + lotName;
	return saveDir + "\\DefectImage" + IntToStr(containerIndex + 1) + ".FAC";
}

//---------------------------------------------------------------------------
void __fastcall TPrintInspectionResult_Ajanta_Form::UpdateTotalReportPages(int option)
{
	int TotalRP;
	AnsiString str;
	if (option == 0) // ⺻  
	{
		ReportPageLabel->Caption = "1 / 2";

		UpDown1->Min = 1;
		UpDown1->Max = 2;

		UpDown1->Position = 1;
	}
	else //   ̷ + ⺻  
	{
		TotalRP = 2;

		ReportPageLabel->Caption = "1 / " + IntToStr(TotalRP);

		UpDown1->Min = 1;
		UpDown1->Max = TotalRP;

		UpDown1->Position = 1;
	}

	PageList->Clear();
	TotalRP = 1+1;

	bool bReportOption = false;
	bool bReportGridOption = false;
  
	if (PrintGradeOnlyRadioButton->Checked)
	{
		if (PrintDefectSeriesCheckBox->Checked)
		{
      PageList->Add("QuickRep1");
			PageList->Add("QuickRep3");
			if (PCProgramOption.DetailRportView)
			{
				PageList->Add("QuickRep6");
				TotalRP++;

				bReportOption = true;
				bReportGridOption = false;
			}
			else
			{
				bReportOption = false;
				bReportGridOption = true;
			}
		}
		else
		{
			PageList->Add("QuickRep1");
      PageList->Add("QuickRep3");
			if (PCProgramOption.DetailRportView)
			{
				bReportOption = true;
				bReportGridOption = false;
			}
		}
	}
  else if(PrintGradeAndSizeRadioButton->Checked)
  {
    if (PrintDefectSeriesCheckBox->Checked)
		{
      PageList->Add("QuickRep1");
			PageList->Add("QuickRep4");
			if (PCProgramOption.DetailRportView)
			{
				PageList->Add("QuickRep6"); 
				bReportOption = true;
				bReportGridOption = false;
				TotalRP++;
			}
			else
			{
				bReportOption = false;
				bReportGridOption = true;
			}

		}
		else
		{
			if (PCProgramOption.DetailRportView)
			{
				bReportOption = true;
				bReportGridOption = false;
			}
      PageList->Add("QuickRep1");
			PageList->Add("QuickRep4");
		}
  }

  // ǥ ҷ ̹  
	if (DefectImagePrintCheckBox->Checked)
	{
		TotalRP = TotalRP + 1 + newImagePageIndex;

		PageList->Add("QuickRep5");

		for (int i = 1; i <= newImagePageIndex; i++)
		{
			PageList->Add("newImageQR" + IntToStr(i));
		}
	}

	SetDetailReportOption(bReportOption, TotalRP);
	SetDetailReportOptionGridShape(bReportGridOption);
	ReportPageLabel->Caption = "1 / " + IntToStr(TotalRP);

  TDateTime DateOfPrint;
  TDateTime TimeOfPrint;
  DateOfPrint = TDateTime::CurrentDate();
  TimeOfPrint = TDateTime::CurrentTime();
  
	int idx = 1;
	for (int i = 0; i < TotalRP; i++)
	{
    if (PageList->Strings[i] == AnsiString("QuickRep1"))
		{
      RepGenPageValueLabel1->Caption = IntToStr(idx) + " of " + IntToStr(TotalRP);
      RepGenDateValueLabel1->Caption = DateOfPrint.FormatString("DD/MM/YYYY") + "  " + TimeOfPrint.FormatString("HH:MM:SS");
      RepGenUserNameValueLabel1->Caption = UserInfo.Name;
			idx++;
		}
		else if (PageList->Strings[i] == AnsiString("QuickRep3"))
		{
      RepGenPageValueLabel2->Caption = IntToStr(idx) + " of " + IntToStr(TotalRP);
      RepGenDateValueLabel2->Caption = DateOfPrint.FormatString("DD/MM/YYYY") + "  " + TimeOfPrint.FormatString("HH:MM:SS");
      RepGenUserNameValueLabel2->Caption = UserInfo.Name;
			idx++;
		}
		else if (PageList->Strings[i] == AnsiString("QuickRep4"))
		{
      RepGenPageValueLabel3->Caption = IntToStr(idx) + " of " + IntToStr(TotalRP);
      RepGenDateValueLabel3->Caption = DateOfPrint.FormatString("DD/MM/YYYY") + "  " + TimeOfPrint.FormatString("HH:MM:SS");
      RepGenUserNameValueLabel3->Caption = UserInfo.Name;
			idx++;
		}
		else if (PageList->Strings[i] == AnsiString("QuickRep6"))
		{
      RepGenPageValueLabel4->Caption = IntToStr(idx) + " of " + IntToStr(TotalRP);
      RepGenDateValueLabel4->Caption = DateOfPrint.FormatString("DD/MM/YYYY") + "  " + TimeOfPrint.FormatString("HH:MM:SS");
      RepGenUserNameValueLabel4->Caption = UserInfo.Name;
			idx++;
		}
		else if (PageList->Strings[i] == AnsiString("QuickRep5"))
		{
      RepGenDateValueLabel5->Caption = DateOfPrint.FormatString("DD/MM/YYYY") + "  " + TimeOfPrint.FormatString("HH:MM:SS");
      RepGenUserNameValueLabel5->Caption = UserInfo.Name;
			QRPageDfImage0->Caption = IntToStr(idx) + " of " + IntToStr(TotalRP);
			idx++;
		}
		else
		{
			for (int j = 1; j < (newImagePageIndex + 1); j++)
			{
				if (PageList->Strings[i] == AnsiString("newImageQR" + IntToStr(j)))
				{
					TQRLabel *tempLabel = (TQRLabel *)FindComponent("QRPageDfImage" + IntToStr(j));
					tempLabel->Caption = IntToStr(idx) + " of " + IntToStr(TotalRP);
					idx++;
				}
			}
		}
	}

	UpDown1->Min = 1;
	UpDown1->Max = TotalRP;

	UpDown1->Position = 1;
	if (TotalRP > 1)
		UpDown1->Enabled = true;
	else
		UpDown1->Enabled = false;

  ReportPanel1->BringToFront();
}
//---------------------------------------------------------------------------
void __fastcall TPrintInspectionResult_Ajanta_Form::UpDown1Click(TObject *Sender,
	TUDBtnType Button)
{
	int CurrentPageN = UpDown1->Position;
	AnsiString  ComponentName;

	ComponentName = PageList->Strings[CurrentPageN - 1];

  if (ComponentName == "QuickRep1")
		ReportPanel1->BringToFront();
	if (ComponentName == "QuickRep3")
		ReportPanel3->BringToFront();
	else if (ComponentName == "QuickRep4")
		ReportPanel4->BringToFront();
	else if (ComponentName == "QuickRep5")
		ReportPanel5->BringToFront();
	else if (ComponentName == "QuickRep6")
		ReportPanel6->BringToFront();

	//  Label Ʈ
	ReportPageLabel->Caption = IntToStr(CurrentPageN) + " / " + IntToStr(UpDown1->Max);
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------


void __fastcall TPrintInspectionResult_Ajanta_Form::SelectDefectImageButtonClick(
	TObject *Sender)
{
	SelectDefectImageForm = new TSelectDefectImageForm(this);
	//SelectDefectImageForm->ShowModal();
	SelectDefectImageForm->DefectImageLoad(LOTName, DefectSeriesCount);
	SelectDefectImageForm->InitSelectDefect();
	SelectDefectImageForm->ShowModal();

	if (SelectDefectImageForm->ModalStat == mrOk)
	{
		PrintImageIndexLoad();

		int i, CountImage;
		CountImage = 0;
		newImagePageIndex = 0;
		for (i = 0; i < 12; i++)
		{
			if (PrintImageIndex.DefectImageIndex[i] != 0xAAAA)
				CountImage++;
		}

		if (CountImage > 6)
		{
			newImagePageIndex = (CountImage-1) / 6;
			CreateNewDefectImagePage();
		}

		if (CountImage)
			FillDefectImageReport(AnsiString(ProductName), LOTName, CountImage);


		UpdateTotalReportPages(0);

		if (PrintGradeOnlyRadioButton->Checked)
		{
			if (PrintDefectSeriesCheckBox->Checked)
				ReportPanel3->BringToFront();
		}

		if (PrintGradeAndSizeRadioButton->Checked)
		{
			if (PrintDefectSeriesCheckBox->Checked)
				ReportPanel4->BringToFront();
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TPrintInspectionResult_Ajanta_Form::PrintImageIndexLoad()
{

	AnsiString FilePath = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\Report";
	AnsiString SelectDataFileName = FilePath + "\\" + LOTName + ".dsi";

	if (!FileExists(SelectDataFileName))
	{
		TSelectDefectImageForm *tempSelectDefectImageForm;
		tempSelectDefectImageForm = new TSelectDefectImageForm(this);
		tempSelectDefectImageForm->DefectImageLoad(LOTName, DefectSeriesCount);
		tempSelectDefectImageForm->WriteDefectSelectionData(LOTName);

		delete tempSelectDefectImageForm;
	}

	TFileStream *fileStream = new TFileStream(SelectDataFileName, fmOpenRead);
	fileStream->Read(&PrintImageIndex, sizeof(PrintImageIndex));
	delete fileStream;


}


void __fastcall TPrintInspectionResult_Ajanta_Form::DefectImagePrintCheckBoxClick(
	TObject *Sender)
{
	if (!DefectImagePrintCheckBox->Checked && !PrintDefectSeriesCheckBox->Checked) //  
	{
		UpdateTotalReportPages(0);
		UpDown1->Enabled = false;
	}
	else
	{
		UpdateTotalReportPages(1);
		UpDown1->Enabled = true;
	}

	/*if (PrintDefectSeriesCheckBox->Checked)
		ReportPanel3->BringToFront();

	if (PrintDefectSeriesCheckBox->Checked)
		ReportPanel4->BringToFront();*/
}
//---------------------------------------------------------------------------

void __fastcall TPrintInspectionResult_Ajanta_Form::QRCompositeReport1AddReports(
	TObject *Sender)
{
	int PageCnt;
	AnsiString  ComponentName;

	PageCnt = PageList->Count;

	QRCompositeReport1->Reports->Clear();

	for (int cnt = 0; cnt < PageCnt; cnt++)
	{
		ComponentName = PageList->Strings[cnt];
		TQuickRep *tempQR;
		tempQR = (TQuickRep*)FindComponent(ComponentName);
		QRCompositeReport1->Reports->Add(tempQR);
	}
}
//---------------------------------------------------------------------------

void __fastcall TPrintInspectionResult_Ajanta_Form::SetDefectInfoPage2()
{
  int DefectCountList[MAX_DEFECT_SERIES_COUNT + 1];
  int DefectSeriesList[MAX_DEFECT_SERIES_COUNT + 1];
  int DefectCountListSort[MAX_DEFECT_SERIES_COUNT + 1];
  int DefectSeriesListSort[MAX_DEFECT_SERIES_COUNT + 1];
  int defectCount = 0, errorCount = 0;
  int sortIdx;
  int idx;

  TQRLabel *defectNameLabel;
  TQRLabel *defectCountLabel;
  TQRLabel *defectRatioLabel;
  int count;
  int ETCCount;
  int CPBDefectTabletCount;
  int HCBDefectTabletCount;
  int notReceivedTabletCount = 0;

  memset(DefectCountList, 0, sizeof(int) * (MAX_DEFECT_SERIES_COUNT + 1));
  memset(DefectSeriesList, 0, sizeof(int) * (MAX_DEFECT_SERIES_COUNT + 1));
  memset(DefectCountListSort, 0, sizeof(int) * (MAX_DEFECT_SERIES_COUNT + 1));
  memset(DefectSeriesListSort, 0, sizeof(int) * (MAX_DEFECT_SERIES_COUNT + 1));

  for (int defectSeriesIndex = 0; defectSeriesIndex < MAX_DEFECT_SERIES_COUNT + 1; defectSeriesIndex++)
  {
    if (defectSeriesIndex < MAX_CPB_DEFECT_SERIES_COUNT)
		{
			DefectSeriesList[defectSeriesIndex] = defectSeriesIndex;
		}
		else
		{
			DefectSeriesList[defectSeriesIndex] = defectSeriesIndex - MAX_CPB_DEFECT_SERIES_COUNT + THIN_TALBET;
		}

    DefectCountList[defectSeriesIndex] = DefectSeriesCount[defectSeriesIndex];
    defectCount += DefectSeriesCount[defectSeriesIndex];
  }
    
  memcpy(DefectCountListSort, DefectCountList, sizeof(DefectCountListSort));
  memcpy(DefectSeriesListSort, DefectSeriesList, sizeof(DefectCountListSort));
  for (int i = 0; i < MAX_DEFECT_SERIES_COUNT + 1; i++)
  {
    for (int j = i; j < MAX_DEFECT_SERIES_COUNT + 1; j++)
    {
      if (DefectCountListSort[i] < DefectCountListSort[j])
      {
        int temp = DefectCountListSort[i];
        DefectCountListSort[i] = DefectCountListSort[j];
        DefectCountListSort[j] = temp;

        temp = DefectSeriesListSort[i];
        DefectSeriesListSort[i] = DefectSeriesListSort[j];
        DefectSeriesListSort[j] = temp;
      }
    }
  }

	if(MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
  {
    HCBDefectTabletCount = Report.Data.SPBProcessingNCTabletCount + Report.Data.FRMisMatchTabletCount + Report.Data.ClosedTabletDefectCount + Report.Data.NozzErrorDefectTabletCount;
  }
  else
  {
    HCBDefectTabletCount = Report.Data.SPBProcessingNCTabletCount + Report.Data.FRMisMatchTabletCount + Report.Data.ClosedTabletDefectCount + Report.Data.NozzErrorDefectTabletCount + Report.Data.UnPrintTabletCount;
  }

  CPBDefectTabletCount = Report.Data.DefectTabletCount - HCBDefectTabletCount;

  if(CPBDefectTabletCount > defectCount)
  {
    // Ÿ count ó
    notReceivedTabletCount = CPBDefectTabletCount - defectCount;
  }
  else if(CPBDefectTabletCount < defectCount)
  {
    //////ӽ
    // SPB  ̰óǾ HCB ҷ īƮ ö󰡴° (SHILPA)
    int SeriesNumber[10];
    int validDataCount = 1;
    memset(SeriesNumber, 0, sizeof(int) * 10);

    for(int i = 0; i < 10; i++)
    {
      if(DefectCountListSort[i])
      {
        SeriesNumber[i] = DefectSeriesListSort[i];
        validDataCount++;
        if(validDataCount > 10) validDataCount = 10;
      }
    }

    count = defectCount - CPBDefectTabletCount;

    while(1)
    {
      sortIdx = rand() % validDataCount;
      idx = SeriesNumber[sortIdx];

      if(idx >= MAX_CPB_DEFECT_SERIES_COUNT)
      {
        idx = idx - THIN_TALBET + MAX_CPB_DEFECT_SERIES_COUNT;
      }

      if(DefectCountList[idx] - count >= 0)
      {
        DefectCountList[idx] -= count;
        DefectCountListSort[sortIdx] -= count;
        defectCount -= count;

        count = DefectCountList[idx];

        break;
      }
      else
      {
        int tempCount = DefectCountList[idx];

        DefectCountList[idx] -= tempCount;
        DefectCountListSort[sortIdx] -= tempCount;
        defectCount -= tempCount;

        count = defectCount - CPBDefectTabletCount;
      }
    }

    AnsiString resultDir = ProgramPath.Product + "\\" + ProductName + "\\Result";
    AnsiString inspectionReportFileName = resultDir + "\\" + LOTName + ".dat";

    try
    {
      memcpy(DefectSeriesCount, DefectCountList, (MAX_DEFECT_SERIES_COUNT + 1) * sizeof(int));
      memcpy(Report.DefectSeriesCount.DefectSeriesCount,DefectCountList, (MAX_DEFECT_SERIES_COUNT + 1) * sizeof(int));
      Create_Report_Data(Report,inspectionReportFileName);
    }
    catch(...)
    {
      WritePCProgramErrorLog(this->Name, __LINE__);
    }
  }

  for (int i = 0; i < MAX_DEFECT_SERIES_COUNT + 1; i++)
  {
    for (int j = i; j < MAX_DEFECT_SERIES_COUNT + 1; j++)
    {
      if (DefectCountListSort[i] <= DefectCountListSort[j])
      {
        int temp = DefectCountListSort[i];
        DefectCountListSort[i] = DefectCountListSort[j];
        DefectCountListSort[j] = temp;

        temp = DefectSeriesListSort[i];
        DefectSeriesListSort[i] = DefectSeriesListSort[j];
        DefectSeriesListSort[j] = temp;
      }
    }
  }

  for (int i = 0; i < MAX_DEFECT_SERIES_COUNT; i++)
  {
    if (GetDefectSeriesStr(DefectSeriesListSort[i]) == COMMONPC_RETURNSTR_04)
    {
      for (int j = MAX_DEFECT_SERIES_COUNT; j > i ; j--)
      {
        if (GetDefectSeriesStr(DefectSeriesListSort[j]) != COMMONPC_RETURNSTR_04)
        {
          int temp = DefectCountListSort[i];
          DefectCountListSort[i] = DefectCountListSort[j];
          DefectCountListSort[j] = temp;

          temp = DefectSeriesListSort[i];
          DefectSeriesListSort[i] = DefectSeriesListSort[j];
          DefectSeriesListSort[j] = temp;

          break;
        }
      }
    }
  }

  ETCCount = 0;
  for (int defectSeriesIndex = 0; defectSeriesIndex < MAX_DEFECT_SERIES_COUNT + 1; defectSeriesIndex++)
  {
    if(defectSeriesIndex + 1 < ETC_MAX_LIST_NUMBER)
    {
      defectNameLabel = (TQRLabel *) FindComponent("QRItemLabel" + IntToStr(defectSeriesIndex + 1));
      defectCountLabel = (TQRLabel *) FindComponent("QRQuantityLabel" + IntToStr(defectSeriesIndex + 1));
      defectRatioLabel = (TQRLabel *) FindComponent("QRRateLabel" + IntToStr(defectSeriesIndex + 1));

      count = DefectCountListSort[defectSeriesIndex];

      defectNameLabel->Caption = GetDefectSeriesStr(DefectSeriesListSort[defectSeriesIndex]);
      defectCountLabel->Caption = FloatToStrF((float)count, ffNumber, 10, 0);
      if(Report.Data.DefectTabletCount)
        defectRatioLabel->Caption = FloatToStrF(((float)count / (float)Report.Data.DefectTabletCount) * 100, ffFixed, 10, 2);
      else
        defectRatioLabel->Caption = "0";
    }
    else
    {
      defectNameLabel = (TQRLabel *) FindComponent("QRItemLabel" + IntToStr(ETC_MAX_LIST_NUMBER));
      defectCountLabel = (TQRLabel *) FindComponent("QRQuantityLabel" + IntToStr(ETC_MAX_LIST_NUMBER));
      defectRatioLabel = (TQRLabel *) FindComponent("QRRateLabel" + IntToStr(ETC_MAX_LIST_NUMBER));

      ETCCount += DefectCountListSort[defectSeriesIndex];

      defectNameLabel->Caption = GetDefectSeriesStr(0xFF);
      defectCountLabel->Caption = FloatToStrF((float)ETCCount + HCBDefectTabletCount + notReceivedTabletCount, ffNumber, 10, 0);
      if(Report.Data.DefectTabletCount)
        defectRatioLabel->Caption = FloatToStrF(((float)(ETCCount + HCBDefectTabletCount + notReceivedTabletCount) / (float)Report.Data.DefectTabletCount) * 100, ffFixed, 10, 2);
      else
        defectRatioLabel->Caption = "0";
    }
  }

  defectNameLabel = (TQRLabel *) FindComponent("QRItemLabelTotal");
  defectCountLabel = (TQRLabel *) FindComponent("QRQuantityLabelTotal");
  defectRatioLabel = (TQRLabel *) FindComponent("QRRateLabelTotal");
  defectNameLabel->Caption = "Total Quantity";
  defectCountLabel->Caption =  FloatToStrF((float)defectCount + HCBDefectTabletCount + notReceivedTabletCount, ffNumber, 10, 0);

  if(Report.Data.DefectTabletCount)
    defectRatioLabel->Caption =  FloatToStrF((float)(defectCount + HCBDefectTabletCount + notReceivedTabletCount) / (float)Report.Data.DefectTabletCount * 100, ffFixed, 10, 2);
  else
      defectRatioLabel->Caption = "0";

  //chart 
  //QRInspectionChartDB->Title->Text->Strings[0] = "Inspection Info";
  QRInspectionChartDB->Series[0]->Clear();
  QRInspectionChartDB->Series[0]->Add(Report.Data.GoodTabletCount, "Good Tablet", clLime);
  QRInspectionChartDB->Series[0]->Add(Report.Data.DefectTabletCount, "Defect Tablet", clRed);
  QRInspectionChartDB->Series[0]->Add(Report.Data.UnInsTabletCount, "Un-Inspection", clYellow);
}
//-----------------------------------------------------------------------------------------------------------------------------------
void __fastcall TPrintInspectionResult_Ajanta_Form::SetDetailReportOption(bool On, int TotalRP)
{
	if (On)
	{
		/*for (int i = 0; i < TotalRP + 1; ++i)
		{
			TQRLabel* pLabel = (TQRLabel*)FindComponent("QRPageDfImage" + IntToStr(i));
			if (pLabel != NULL)
			{
				pLabel->Visible = true;
				pLabel->Enabled = true;
			}
		}*/
	}
	else
	{
		/*for (int i = 0; i < TotalRP + 1; ++i)
		{
			TQRLabel* pLabel = (TQRLabel*)FindComponent("QRPageDfImage" + IntToStr(i));
			if (pLabel != NULL)
			{
				pLabel->Visible = false;
				pLabel->Enabled = false;
			}
		}*/
	}
}

void __fastcall TPrintInspectionResult_Ajanta_Form::SetDetailReportOptionGridShape(bool On)
{
	if (On)
	{
		DefectSeriesLabel11->Visible = true;
		DefectSeriesLabel22->Visible = true;
		DefectSeriesLabel33->Visible = true;
		DefectSeriesLabel44->Visible = true;
		DefectSeriesLabel55->Visible = true;
		DefectSeriesLabel66->Visible = true;
		DefectSeriesLabel77->Visible = true;

		bDefectNameLabel1->Visible = true;
		bDefectNameLabel2->Visible = true;
		bDefectNameLabel3->Visible = true;
		bDefectNameLabel4->Visible = true;
		bDefectNameLabel5->Visible = true;
		bDefectNameLabel6->Visible = true;
		bDefectNameLabel7->Visible = true;
		bDefectNameLabel8->Visible = true;
		bDefectNameLabel9->Visible = true;
		bDefectNameLabel10->Visible = true;

		bDefectCountLabel1->Visible = true;
		bDefectCountLabel2->Visible = true;
		bDefectCountLabel3->Visible = true;
		bDefectCountLabel4->Visible = true;
		bDefectCountLabel5->Visible = true;
		bDefectCountLabel6->Visible = true;
		bDefectCountLabel7->Visible = true;
		bDefectCountLabel8->Visible = true;
		bDefectCountLabel9->Visible = true;
		bDefectCountLabel10->Visible = true;

		bDefectRatioLabel1->Visible = true;
		bDefectRatioLabel2->Visible = true;
		bDefectRatioLabel3->Visible = true;
		bDefectRatioLabel4->Visible = true;
		bDefectRatioLabel5->Visible = true;
		bDefectRatioLabel6->Visible = true;
		bDefectRatioLabel7->Visible = true;
		bDefectRatioLabel8->Visible = true;
		bDefectRatioLabel9->Visible = true;
		bDefectRatioLabel10->Visible = true;

		QRShape156->Visible = true;
		QRShape157->Visible = true;
		QRShape158->Visible = true;
		QRShape159->Visible = true;
		QRShape160->Visible = true;
		QRShape161->Visible = true;
		QRShape162->Visible = true;
		QRShape163->Visible = true;
		QRShape164->Visible = true;
		QRShape165->Visible = true;
		QRShape166->Visible = true;
		QRShape167->Visible = true;

		//Enabled
		DefectSeriesLabel11->Enabled = true;
		DefectSeriesLabel22->Enabled = true;
		DefectSeriesLabel33->Enabled = true;
		DefectSeriesLabel44->Enabled = true;
		DefectSeriesLabel55->Enabled = true;
		DefectSeriesLabel66->Enabled = true;
		DefectSeriesLabel77->Enabled = true;

		bDefectNameLabel1->Enabled = true;
		bDefectNameLabel2->Enabled = true;
		bDefectNameLabel3->Enabled = true;
		bDefectNameLabel4->Enabled = true;
		bDefectNameLabel5->Enabled = true;
		bDefectNameLabel6->Enabled = true;
		bDefectNameLabel7->Enabled = true;
		bDefectNameLabel8->Enabled = true;
		bDefectNameLabel9->Enabled = true;
		bDefectNameLabel10->Enabled = true;

		bDefectCountLabel1->Enabled = true;
		bDefectCountLabel2->Enabled = true;
		bDefectCountLabel3->Enabled = true;
		bDefectCountLabel4->Enabled = true;
		bDefectCountLabel5->Enabled = true;
		bDefectCountLabel6->Enabled = true;
		bDefectCountLabel7->Enabled = true;
		bDefectCountLabel8->Enabled = true;
		bDefectCountLabel9->Enabled = true;
		bDefectCountLabel10->Enabled = true;

		bDefectRatioLabel1->Enabled = true;
		bDefectRatioLabel2->Enabled = true;
		bDefectRatioLabel3->Enabled = true;
		bDefectRatioLabel4->Enabled = true;
		bDefectRatioLabel5->Enabled = true;
		bDefectRatioLabel6->Enabled = true;
		bDefectRatioLabel7->Enabled = true;
		bDefectRatioLabel8->Enabled = true;
		bDefectRatioLabel9->Enabled = true;
		bDefectRatioLabel10->Enabled = true;

		QRShape156->Enabled = true;
		QRShape157->Enabled = true;
		QRShape158->Enabled = true;
		QRShape159->Enabled = true;
		QRShape160->Enabled = true;
		QRShape161->Enabled = true;
		QRShape162->Enabled = true;
		QRShape163->Enabled = true;
		QRShape164->Enabled = true;
		QRShape165->Enabled = true;
		QRShape166->Enabled = true;
		QRShape167->Enabled = true;
		DefectSeriesLabel1->Visible = true;
		DefectSeriesShape1->Visible = true;
		DefectSeriesLabel2->Visible = true;
		DefectSeriesLabel3->Visible = true;
		DefectSeriesLabel4->Visible = true;
		DefectSeriesLabel5->Visible = true;
		DefectSeriesLabel6->Visible = true;
		DefectSeriesLabel7->Visible = true;

		DefectNameLabel1->Visible = true;
		DefectNameLabel2->Visible = true;
		DefectNameLabel3->Visible = true;
		DefectNameLabel4->Visible = true;
		DefectNameLabel5->Visible = true;
		DefectNameLabel6->Visible = true;
		DefectNameLabel7->Visible = true;
		DefectNameLabel8->Visible = true;
		DefectNameLabel9->Visible = true;
		DefectNameLabel10->Visible = true;

		DefectCountLabel1->Visible = true;
		DefectCountLabel2->Visible = true;
		DefectCountLabel3->Visible = true;
		DefectCountLabel4->Visible = true;
		DefectCountLabel5->Visible = true;
		DefectCountLabel6->Visible = true;
		DefectCountLabel7->Visible = true;
		DefectCountLabel8->Visible = true;
		DefectCountLabel9->Visible = true;
		DefectCountLabel10->Visible = true;

		DefectRatioLabel1->Visible = true;
		DefectRatioLabel2->Visible = true;
		DefectRatioLabel3->Visible = true;
		DefectRatioLabel4->Visible = true;
		DefectRatioLabel5->Visible = true;
		DefectRatioLabel6->Visible = true;
		DefectRatioLabel7->Visible = true;
		DefectRatioLabel8->Visible = true;
		DefectRatioLabel9->Visible = true;
		DefectRatioLabel10->Visible = true;

		DefectSeriesShape2->Visible = true;
		DefectSeriesShape3->Visible = true;
		DefectSeriesShape4->Visible = true;
		DefectSeriesShape5->Visible = true;
		DefectSeriesShape6->Visible = true;

		DefectSeriesShape7->Visible = true;
		DefectSeriesShape8->Visible = true;
		DefectSeriesShape9->Visible = true;
		DefectSeriesShape10->Visible = true;
		DefectSeriesShape11->Visible = true;


		DefectSeriesLabel1->Enabled = true;
		DefectSeriesShape1->Enabled = true;
		DefectSeriesLabel2->Enabled = true;
		DefectSeriesLabel3->Enabled = true;
		DefectSeriesLabel4->Enabled = true;
		DefectSeriesLabel5->Enabled = true;
		DefectSeriesLabel6->Enabled = true;
		DefectSeriesLabel7->Enabled = true;

		DefectNameLabel1->Enabled = true;
		DefectNameLabel2->Enabled = true;
		DefectNameLabel3->Enabled = true;
		DefectNameLabel4->Enabled = true;
		DefectNameLabel5->Enabled = true;
		DefectNameLabel6->Enabled = true;
		DefectNameLabel7->Enabled = true;
		DefectNameLabel8->Enabled = true;
		DefectNameLabel9->Enabled = true;
		DefectNameLabel10->Enabled = true;

		DefectCountLabel1->Enabled = true;
		DefectCountLabel2->Enabled = true;
		DefectCountLabel3->Enabled = true;
		DefectCountLabel4->Enabled = true;
		DefectCountLabel5->Enabled = true;
		DefectCountLabel6->Enabled = true;
		DefectCountLabel7->Enabled = true;
		DefectCountLabel8->Enabled = true;
		DefectCountLabel9->Enabled = true;
		DefectCountLabel10->Enabled = true;

		DefectRatioLabel1->Enabled = true;
		DefectRatioLabel2->Enabled = true;
		DefectRatioLabel3->Enabled = true;
		DefectRatioLabel4->Enabled = true;
		DefectRatioLabel5->Enabled = true;
		DefectRatioLabel6->Enabled = true;
		DefectRatioLabel7->Enabled = true;
		DefectRatioLabel8->Enabled = true;
		DefectRatioLabel9->Enabled = true;
		DefectRatioLabel10->Enabled = true;

		DefectSeriesShape2->Enabled = true;
		DefectSeriesShape3->Enabled = true;
		DefectSeriesShape4->Enabled = true;
		DefectSeriesShape5->Enabled = true;
		DefectSeriesShape6->Enabled = true;

		DefectSeriesShape7->Enabled = true;
		DefectSeriesShape8->Enabled = true;
		DefectSeriesShape9->Enabled = true;
		DefectSeriesShape10->Enabled = true;
		DefectSeriesShape11->Enabled = true;
	}
	else
	{
		DefectSeriesLabel11->Visible = false;
		DefectSeriesLabel22->Visible = false;
		DefectSeriesLabel33->Visible = false;
		DefectSeriesLabel44->Visible = false;
		DefectSeriesLabel55->Visible = false;
		DefectSeriesLabel66->Visible = false;
		DefectSeriesLabel77->Visible = false;

		bDefectNameLabel1->Visible = false;
		bDefectNameLabel2->Visible = false;
		bDefectNameLabel3->Visible = false;
		bDefectNameLabel4->Visible = false;
		bDefectNameLabel5->Visible = false;
		bDefectNameLabel6->Visible = false;
		bDefectNameLabel7->Visible = false;
		bDefectNameLabel8->Visible = false;
		bDefectNameLabel9->Visible = false;
		bDefectNameLabel10->Visible = false;

		bDefectCountLabel1->Visible = false;
		bDefectCountLabel2->Visible = false;
		bDefectCountLabel3->Visible = false;
		bDefectCountLabel4->Visible = false;
		bDefectCountLabel5->Visible = false;
		bDefectCountLabel6->Visible = false;
		bDefectCountLabel7->Visible = false;
		bDefectCountLabel8->Visible = false;
		bDefectCountLabel9->Visible = false;
		bDefectCountLabel10->Visible = false;

		bDefectRatioLabel1->Visible = false;
		bDefectRatioLabel2->Visible = false;
		bDefectRatioLabel3->Visible = false;
		bDefectRatioLabel4->Visible = false;
		bDefectRatioLabel5->Visible = false;
		bDefectRatioLabel6->Visible = false;
		bDefectRatioLabel7->Visible = false;
		bDefectRatioLabel8->Visible = false;
		bDefectRatioLabel9->Visible = false;
		bDefectRatioLabel10->Visible = false;

		QRShape156->Visible = false;
		QRShape157->Visible = false;
		QRShape158->Visible = false;
		QRShape159->Visible = false;
		QRShape160->Visible = false;
		QRShape161->Visible = false;
		QRShape162->Visible = false;
		QRShape163->Visible = false;
		QRShape164->Visible = false;
		QRShape165->Visible = false;
		QRShape166->Visible = false;
		QRShape167->Visible = false;

		//Enabled
		DefectSeriesLabel11->Enabled = false;
		DefectSeriesLabel22->Enabled = false;
		DefectSeriesLabel33->Enabled = false;
		DefectSeriesLabel44->Enabled = false;
		DefectSeriesLabel55->Enabled = false;
		DefectSeriesLabel66->Enabled = false;
		DefectSeriesLabel77->Enabled = false;

		bDefectNameLabel1->Enabled = false;
		bDefectNameLabel2->Enabled = false;
		bDefectNameLabel3->Enabled = false;
		bDefectNameLabel4->Enabled = false;
		bDefectNameLabel5->Enabled = false;
		bDefectNameLabel6->Enabled = false;
		bDefectNameLabel7->Enabled = false;
		bDefectNameLabel8->Enabled = false;
		bDefectNameLabel9->Enabled = false;
		bDefectNameLabel10->Enabled = false;

		bDefectCountLabel1->Enabled = false;
		bDefectCountLabel2->Enabled = false;
		bDefectCountLabel3->Enabled = false;
		bDefectCountLabel4->Enabled = false;
		bDefectCountLabel5->Enabled = false;
		bDefectCountLabel6->Enabled = false;
		bDefectCountLabel7->Enabled = false;
		bDefectCountLabel8->Enabled = false;
		bDefectCountLabel9->Enabled = false;
		bDefectCountLabel10->Enabled = false;

		bDefectRatioLabel1->Enabled = false;
		bDefectRatioLabel2->Enabled = false;
		bDefectRatioLabel3->Enabled = false;
		bDefectRatioLabel4->Enabled = false;
		bDefectRatioLabel5->Enabled = false;
		bDefectRatioLabel6->Enabled = false;
		bDefectRatioLabel7->Enabled = false;
		bDefectRatioLabel8->Enabled = false;
		bDefectRatioLabel9->Enabled = false;
		bDefectRatioLabel10->Enabled = false;

		QRShape156->Enabled = false;
		QRShape157->Enabled = false;
		QRShape158->Enabled = false;
		QRShape159->Enabled = false;
		QRShape160->Enabled = false;
		QRShape161->Enabled = false;
		QRShape162->Enabled = false;
		QRShape163->Enabled = false;
		QRShape164->Enabled = false;
		QRShape165->Enabled = false;
		QRShape166->Enabled = false;
		QRShape167->Enabled = false;
		DefectSeriesLabel1->Visible = false;
		DefectSeriesShape1->Visible = false;
		DefectSeriesLabel2->Visible = false;
		DefectSeriesLabel3->Visible = false;
		DefectSeriesLabel4->Visible = false;
		DefectSeriesLabel5->Visible = false;
		DefectSeriesLabel6->Visible = false;
		DefectSeriesLabel7->Visible = false;

		DefectNameLabel1->Visible = false;
		DefectNameLabel2->Visible = false;
		DefectNameLabel3->Visible = false;
		DefectNameLabel4->Visible = false;
		DefectNameLabel5->Visible = false;
		DefectNameLabel6->Visible = false;
		DefectNameLabel7->Visible = false;
		DefectNameLabel8->Visible = false;
		DefectNameLabel9->Visible = false;
		DefectNameLabel10->Visible = false;

		DefectCountLabel1->Visible = false;
		DefectCountLabel2->Visible = false;
		DefectCountLabel3->Visible = false;
		DefectCountLabel4->Visible = false;
		DefectCountLabel5->Visible = false;
		DefectCountLabel6->Visible = false;
		DefectCountLabel7->Visible = false;
		DefectCountLabel8->Visible = false;
		DefectCountLabel9->Visible = false;
		DefectCountLabel10->Visible = false;

		DefectRatioLabel1->Visible = false;
		DefectRatioLabel2->Visible = false;
		DefectRatioLabel3->Visible = false;
		DefectRatioLabel4->Visible = false;
		DefectRatioLabel5->Visible = false;
		DefectRatioLabel6->Visible = false;
		DefectRatioLabel7->Visible = false;
		DefectRatioLabel8->Visible = false;
		DefectRatioLabel9->Visible = false;
		DefectRatioLabel10->Visible = false;

		DefectSeriesShape2->Visible = false;
		DefectSeriesShape3->Visible = false;
		DefectSeriesShape4->Visible = false;
		DefectSeriesShape5->Visible = false;
		DefectSeriesShape6->Visible = false;

		DefectSeriesShape7->Visible = false;
		DefectSeriesShape8->Visible = false;
		DefectSeriesShape9->Visible = false;
		DefectSeriesShape10->Visible = false;
		DefectSeriesShape11->Visible = false;


		DefectSeriesLabel1->Enabled = false;
		DefectSeriesShape1->Enabled = false;
		DefectSeriesLabel2->Enabled = false;
		DefectSeriesLabel3->Enabled = false;
		DefectSeriesLabel4->Enabled = false;
		DefectSeriesLabel5->Enabled = false;
		DefectSeriesLabel6->Enabled = false;
		DefectSeriesLabel7->Enabled = false;

		DefectNameLabel1->Enabled = false;
		DefectNameLabel2->Enabled = false;
		DefectNameLabel3->Enabled = false;
		DefectNameLabel4->Enabled = false;
		DefectNameLabel5->Enabled = false;
		DefectNameLabel6->Enabled = false;
		DefectNameLabel7->Enabled = false;
		DefectNameLabel8->Enabled = false;
		DefectNameLabel9->Enabled = false;
		DefectNameLabel10->Enabled = false;

		DefectCountLabel1->Enabled = false;
		DefectCountLabel2->Enabled = false;
		DefectCountLabel3->Enabled = false;
		DefectCountLabel4->Enabled = false;
		DefectCountLabel5->Enabled = false;
		DefectCountLabel6->Enabled = false;
		DefectCountLabel7->Enabled = false;
		DefectCountLabel8->Enabled = false;
		DefectCountLabel9->Enabled = false;
		DefectCountLabel10->Enabled = false;

		DefectRatioLabel1->Enabled = false;
		DefectRatioLabel2->Enabled = false;
		DefectRatioLabel3->Enabled = false;
		DefectRatioLabel4->Enabled = false;
		DefectRatioLabel5->Enabled = false;
		DefectRatioLabel6->Enabled = false;
		DefectRatioLabel7->Enabled = false;
		DefectRatioLabel8->Enabled = false;
		DefectRatioLabel9->Enabled = false;
		DefectRatioLabel10->Enabled = false;

		DefectSeriesShape2->Enabled = false;
		DefectSeriesShape3->Enabled = false;
		DefectSeriesShape4->Enabled = false;
		DefectSeriesShape5->Enabled = false;
		DefectSeriesShape6->Enabled = false;

		DefectSeriesShape7->Enabled = false;
		DefectSeriesShape8->Enabled = false;
		DefectSeriesShape9->Enabled = false;
		DefectSeriesShape10->Enabled = false;
		DefectSeriesShape11->Enabled = false;
	}
}

//---------------------------------------------------------------------------
void __fastcall TPrintInspectionResult_Ajanta_Form::TntFormActivate(
	TObject *Sender)
{
  SetScreenPosition(this);
	SetDetailReportOption(PCProgramOption.DetailRportView, 0);
}
//---------------------------------------------------------------------------

void __fastcall TPrintInspectionResult_Ajanta_Form::SetThroughtputChart(AnsiString productName, AnsiString lotName)
{
	double *ThroughputChartList;
	int ThroughputChartListSize;
	int ThroughputChartCount;

	ThroughputChartList = NULL;
	ThroughputChartListSize = 0;
	ThroughputChartCount = 0;

	AnsiString productPath;
	productPath = ProgramPath.Product + "\\" + productName + "\\result";

	AnsiString throughputFileName = productPath + "\\" + lotName + ".trp";
  TFileStream *fileStream;
  fileStream = NULL;

  try
  {
    if (!FileExists(throughputFileName))
    {
      throw("Throughput File Does Not Exist");
    }

    fileStream = new TFileStream(throughputFileName, fmOpenRead);
    unsigned int thorughputFileVerion;
    fileStream->Read(&thorughputFileVerion, sizeof(unsigned int));
    if (thorughputFileVerion != THROUGHPUT_FILE_VERSION)
    {
      throw("Throughput File Version Is Not Matched");
    }
    fileStream->Read(&ThroughputChartCount, sizeof(int));
    if (ThroughputChartCount <= 0)
    {
      throw("Wrong Throughput Data Count");
    }
    if (ThroughputChartListSize == 0) ThroughputChartListSize = THROUGHPUT_CHART_DEFAULT_SIZE;
    while (ThroughputChartListSize < ThroughputChartCount)
    {
      ThroughputChartListSize *= 2;
    }
    if (ThroughputChartList) delete[] ThroughputChartList;
    ThroughputChartList = new double[ThroughputChartListSize];
    memset(ThroughputChartList, 0, sizeof(double) * ThroughputChartListSize);
    fileStream->Read(ThroughputChartList, ThroughputChartCount * sizeof(double));
    delete fileStream;

    ThroughputChartDB->Series[0]->Clear();
    ThroughputChartDB->Series[0]->AddArray(ThroughputChartList, ThroughputChartCount);

    double fstAvgSpeed;
    double secAvgSpeed;
    double MaxSpeed;
    double UpperBoundary, LowerBoundary;
    int tempCount;

    fstAvgSpeed = secAvgSpeed = MaxSpeed = tempCount = 0;

    if (ThroughputChartCount)
    {
      for (int m = 0; m < ThroughputChartCount; m++)
      {
        fstAvgSpeed += ThroughputChartList[m];

        if (MaxSpeed < ThroughputChartList[m])
        {
          MaxSpeed = ThroughputChartList[m];
        }
      }

      fstAvgSpeed /= ThroughputChartCount;

      UpperBoundary = fstAvgSpeed + fstAvgSpeed * 0.5;
      LowerBoundary = fstAvgSpeed - fstAvgSpeed * 0.5;

      // 50%   ռӵ 
      for (int m = 0; m < ThroughputChartCount; m++)
      {
        if (ThroughputChartList[m] > LowerBoundary)// && ThroughputChartList[m] < UpperBoundary)
        {
          secAvgSpeed += ThroughputChartList[m];
          tempCount++;
        }
      }

      if (tempCount)
      {
        secAvgSpeed /= tempCount;
      }
    }

    AvgSpeedLabel->Caption = FloatToStrF(secAvgSpeed, ffFixed, 7, 1) + " T/H";
    MaxSpeedLabel->Caption = FloatToStrF(MaxSpeed, ffFixed, 7, 1) + " T/H";

    if (ThroughputChartCount >= 200)
    {
      ThroughputChartDB->BottomAxis->SetMinMax(ThroughputChartCount - 199, ThroughputChartCount + 1);
    }

    if (ThroughputChartCount + 1 >= ThroughputChartListSize)
    {
      double *tempArray = new double[ThroughputChartListSize];
      memcpy(tempArray, ThroughputChartList, ThroughputChartListSize);
      delete[] ThroughputChartList;
      ThroughputChartList = new double[ThroughputChartListSize * 2];
      memcpy(ThroughputChartList, tempArray, ThroughputChartListSize);
      delete[] tempArray;
      ThroughputChartListSize *= 2;
    }
  }
  catch(...)
  {
    WritePCProgramErrorLog(this->Name, __LINE__);
    
    if (fileStream) delete fileStream;

    if (ThroughputChartList) delete[] ThroughputChartList;
    ThroughputChartList = new double[THROUGHPUT_CHART_DEFAULT_SIZE];
    ThroughputChartListSize = THROUGHPUT_CHART_DEFAULT_SIZE;
    ThroughputChartCount = 0;
    ThroughputChartDB->Series[0]->Clear();
  }
}
//---------------------------------------------------------------------------
void __fastcall TPrintInspectionResult_Ajanta_Form::CalGoodRateOptionBoxClick(TObject *Sender)
{
	if (!Report.Data.ProductionCount)
	{
		if (CalGoodRateOptionBox->Checked)
		{
			ShowMessage(PRINTINSPECTIONRESULTFORM_UNKNOWN_66);

			CalGoodRateOptionBox->Checked = false;
			return;
		}
	}

	int TotalCnt = 0;

	if (!CalGoodRateOptionBox->Checked)
	{
		if (PCProgramOption.IncludeUnInsTabletCount)
			TotalCnt = Report.Data.GoodTabletCount + Report.Data.DefectTabletCount + Report.Data.UnInsTabletCount;
		else
			TotalCnt = Report.Data.GoodTabletCount + Report.Data.DefectTabletCount;

		bool ValidCheck = false; //  ׸   ǰ ˻  0 ū Ȯ
		ValidCheck = (TotalCnt > 0) ? true : false;

		if (ValidCheck)
		{
      if (PCProgramOption.IncludeUnInsTabletCount)
      {
			  RPassCntQRLabel3->Caption = Format("%.2f %%", ARRAYOFCONST(((double)Report.Data.GoodTabletCount * 100 / TotalCnt)));
			  RDefectCntQRLabel3->Caption = Format("%.2f %%", ARRAYOFCONST(((double)Report.Data.DefectTabletCount * 100 / TotalCnt)));

			  RPassCntQRLabel4->Caption = Format("%.2f %%", ARRAYOFCONST(((double)Report.Data.GoodTabletCount * 100 / TotalCnt)));
			  RDefectCntQRLabel4->Caption = Format("%.2f %%", ARRAYOFCONST(((double)Report.Data.DefectTabletCount * 100 / TotalCnt)));
      }
		}
		else
		{
			RDefectCntQRLabel3->Caption = "0%";
			RPassCntQRLabel3->Caption = "0%";

			RDefectCntQRLabel4->Caption = "0%";
			RPassCntQRLabel4->Caption = "0%";
		}
	}
	else
	{
		// 20180319
		// Ѿ û
		// Է    
		//     
		// ϴ ̰˻翡  ɼ ´ ϵ Ѵ

		TotalCnt = Report.Data.ProductionCount;

		bool ValidCheck = false; //  ׸   ǰ ˻  0 ū Ȯ
		ValidCheck = (TotalCnt > 0) ? true : false;

		if (ValidCheck)
		{
			RPassCntQRLabel3->Caption = Format("%.2f %%", ARRAYOFCONST(((double)Report.Data.GoodTabletCount * 100 / TotalCnt)));
			RDefectCntQRLabel3->Caption = Format("%.2f %%", ARRAYOFCONST(((double)(TotalCnt - Report.Data.GoodTabletCount) * 100 / TotalCnt)));

			RPassCntQRLabel4->Caption = Format("%.2f %%", ARRAYOFCONST(((double)Report.Data.GoodTabletCount * 100 / TotalCnt)));
			RDefectCntQRLabel4->Caption = Format("%.2f %%", ARRAYOFCONST(((double)(TotalCnt - Report.Data.GoodTabletCount) * 100 / TotalCnt)));
		}
		else
		{
			RDefectCntQRLabel3->Caption = "0%";
			RPassCntQRLabel3->Caption = "0%";

			RDefectCntQRLabel4->Caption = "0%";
			RPassCntQRLabel4->Caption = "0%";
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TPrintInspectionResult_Ajanta_Form::GroupBox1DblClick(
	TObject *Sender)
{
	if (!bYuhanOption)
	{
		CalGoodRateOptionBox->Visible = true;
		RemoveGradeInfoOptionBox->Visible = true;
		bYuhanOption = true;
	}
	else
	{
		CalGoodRateOptionBox->Visible = false;
		RemoveGradeInfoOptionBox->Visible = false;
		bYuhanOption = false;
	}
}
//---------------------------------------------------------------------------

void __fastcall TPrintInspectionResult_Ajanta_Form::RemoveGradeInfoOptionBoxClick(
	TObject *Sender)
{
	if (RemoveGradeInfoOptionBox->Checked)
	{
		QRBand5->Enabled = false;
		QRBand5->Visible = false;

		QRBand7->Enabled = false;
		QRBand7->Visible = false;
	}
	else
	{
		QRBand5->Enabled = true;
		QRBand5->Visible = true;

		QRBand7->Enabled = true;
		QRBand7->Visible = true;
	}
}
//---------------------------------------------------------------------------


void __fastcall TPrintInspectionResult_Ajanta_Form::TntFormClose(
      TObject *Sender, TCloseAction &Action)
{
   Action = caFree;
}
//---------------------------------------------------------------------------

void __fastcall TPrintInspectionResult_Ajanta_Form::TntFormShow(
      TObject *Sender)
{
  SetWindowPos(Handle, HWND_TOP, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
}
//---------------------------------------------------------------------------


void __fastcall TPrintInspectionResult_Ajanta_Form::Timer1Timer(
      TObject *Sender)
{
  HWND h_wnd = FindWindowW(NULL,L"Save As");
  if(h_wnd != NULL)
  {
        if(Zorder != 1)
        {
                SetWindowPos(h_wnd, HWND_TOP, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
                CloseHandle(h_wnd);
        }
  }
  else
  {

        if(Zorder != 2)
        {
                SetWindowPos(Handle, HWND_TOP, 0, 0, 0, 0, SWP_NOSIZE | SWP_NOMOVE);
                Zorder = 2;
        }
  }
}
//---------------------------------------------------------------------------
void __fastcall TPrintInspectionResult_Ajanta_Form::ControlInspectionResultChart()
{
  if(PCProgramOption.IncludeUnInsTabletCount)
  {
    QRLabel302->Visible = true;
    UninsCntQRLabel4->Visible = true;
    QRLabel301->Visible = true;
    UninsCntQRLabel3->Visible = true;
    QRLabel302->Enabled = true;
    UninsCntQRLabel4->Enabled = true;
    QRLabel301->Enabled = true;
    UninsCntQRLabel3->Enabled = true;

  }
  else
  {
    QRLabel302->Visible = false;
    UninsCntQRLabel4->Visible = false;
    QRLabel301->Visible = false;
    UninsCntQRLabel3->Visible = false;
    QRLabel302->Enabled = false;
    UninsCntQRLabel4->Enabled = false;
    QRLabel301->Enabled = false;
    UninsCntQRLabel3->Enabled = false;

    QRLabel142->Top -= 24;
    RDefectCntQRLabel3->Top -= 24;
    QRLabel136->Top -= 24;
    RPassCntQRLabel3->Top -= 24;
    QRShape87->Height -= 24;
    QRShape97->Height -= 25;

    QRLabel198->Top -= 24;
    RDefectCntQRLabel4->Top -= 24;
    QRLabel171->Top -= 24;
    RPassCntQRLabel4->Top -= 24;
    QRShape117->Height -= 25;
    QRShape129->Height -= 24;

    QRShape1->Visible = false;
    QRShape1->Enabled = false;
    QRShape2->Visible = false;
    QRShape2->Enabled = false;
  }
}
//---------------------------------------------------------------------------

