//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#include <inifiles.hpp>
#include <math.h>

#include <iostream>
#include <ole2.h>
#include <OleCtl.h>
#include <direct.h>

#pragma hdrstop

#include "ProductInput_Form.h"
#include "Message_Form.h"
#include "Keyboard_Form.h"
#include "Common_PC.h"
#include "ColorCode_Form.h"
#include "InputText_Dialog.h"
#include "LogIn_Form.h"
#include "MultiLanguage.h"
#include "CPB_Module.h"

#define MIN_TABLET_LENGTH			4
#define MIN_TABLET_WIDTH			3
#define MIN_TABLET_THICK			1.5

#define min(x, y)	(x < y ? x : y) 

#define EJECT_NORMAL_MODE      0
#define EJECT_SPECIAL_MODE     1
#define PRODUCT_NAME_LENGTH_LIMIT 63 
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntGrids"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TProductInputForm* ProductInputForm;
extern TMESProductData MESProductData;
//cjg OPC Test
HINSTANCE hOPC_DLL = NULL;
int (*pSetMESProductData)(TMESProductData*);
//---------------------------------------------------------------------------
__fastcall TProductInputForm::TProductInputForm(TComponent* Owner)
	: TTntForm(Owner)
{
	//cjg OPC Test
	AnsiString pstrSrc = ProgramPath.Root + "\\Lib\\SELMA_MES.dll";
	int nLen = strlen(pstrSrc.c_str()) + 1;

	wchar_t* pwstr = (LPWSTR)malloc(sizeof(wchar_t) * nLen);
	mbstowcs(pwstr, pstrSrc.c_str(), nLen);

	if (hOPC_DLL == NULL)
	{
		//                hOPC_DLL = ::LoadLibrary(TEXT("SELMA_MES.dll"));
		hOPC_DLL = ::LoadLibrary(pwstr);
	}
	free(pwstr);

	if (hOPC_DLL)
	{
		pSetMESProductData = (int(*)(TMESProductData*)) GetProcAddress(hOPC_DLL, "SetMESProductData");
	}
	free(pwstr);

	GetDefaultString();

	if (DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
		ComponentSetFontName(this, "SimSun");
	else if (DefaultLCID == 1041)
		ComponentSetFontName(this, "Meiryo UI");
	else if (DefaultLCID == 3082)
	{
		ComponentSetFontName(this, "Segoe UI");
		ComponentSetMultiLine(this);
	}

	TempProductData.ProductCode = "";
	TempProductData.ProductName = "";
	TempProductData.TabletType = TABLET_TYPE_UNKNOWN;
	TempProductData.TabletShape = TABLET_SHAPE_UNKNOWN;
	TempProductData.EngraveType = ENGRAVE_TYPE_UNKNOWN;
	TempProductData.EngravePos = ENGRAVE_POS_UNKNOWN;
	TempProductData.TabletColorCode = "";
	TempProductData.PrintColorCode = "";
	TempProductData.TabletLayerCount = 1;
	TempProductData.DivisionLineInfo = DIVISION_LINE_NONE;

	if (!PCProgramOption.ActiveResolutionSetting)
	{
		TntGroupBox1->Visible = false;
		TempProductData.SubSamplingMode = IMAGE_SUBSAMPLING_MODE;
	}
	else
	{
		TempProductData.SubSamplingMode = PCProgramOption.InitSubSamplingMode;
	}
	if (MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable == 1)
	{
		RecipeSelectBox->Visible = true;
		RecipeImageBox->Visible = true;
	}
	else
	{
		RecipeSelectBox->Visible = false;
		RecipeImageBox->Visible = false;
	}
	for (int layerIndex = 0; layerIndex < MAX_TABLET_LAYER_COUNT; layerIndex++)
	{
		TempProductData.MultiLayeredTabletColor[layerIndex] = clWhite;
	}

	SubProductSearchForm = new TProductSearchForm(this);
	SubProductSearchForm->OnClickOK = ProductSearchOKClick;
	SubProductSearchForm->OnClickCancel = ProductSearchCancelClick;
	//    SubProductSearchForm->Parent = TabletSearchPanel;

	TabletInfoPanel->Visible = false;
	TabletSearchPanel->Visible = false;

	ProductInputMode = PIM_NONE;

	RefreshSizeInputMenu();
	RefreshPrintingInputMenu();
	UpdateEditableComponents();
	RefreshTabletColor();
	RefreshDivisionLineInfoMenu();
	RefreshResolutionMenu();

	ProductSettingMode = PIM_NONE;
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::GetDefaultString()
{
	CancelBitBtn->Caption = PRODUCTINPUTFORM_BITBTN_CAPTION_01;
	OKBitBtn->Caption = PRODUCTINPUTFORM_BITBTN_CAPTION_02;
	ExsistTabletButton->Caption = PRODUCTINPUTFORM_BUTTON_CAPTION_01;
	DataDeleteButton->Caption = PRODUCTINPUTFORM_BUTTON_CAPTION_03;
	DataEditButton->Caption = PRODUCTINPUTFORM_BUTTON_CAPTION_04;
	GroupBox9->Caption = PRODUCTINPUTFORM_BUTTON_CAPTION_05;
	RenameButton->Caption = PRODUCTINPUTFORM_BUTTON_CAPTION_06;
	SaveAsButton->Caption = PRODUCTINPUTFORM_BUTTON_CAPTION_07;
	this->Caption = PRODUCTINPUTFORM_FORM_CAPTION_01;
	GroupBox5->Caption = PRODUCTINPUTFORM_GROUPBOX_CAPTION_01;
	GroupBox4->Caption = PRODUCTINPUTFORM_GROUPBOX_CAPTION_02;
	GroupBox10->Caption = PRODUCTINPUTFORM_GROUPBOX_CAPTION_03;
	ETCInfoGroupBox->Caption = PRODUCTINPUTFORM_GROUPBOX_CAPTION_04;
	GroupBox3->Caption = PRODUCTINPUTFORM_GROUPBOX_CAPTION_05;
	GroupBox11->Caption = PRODUCTINPUTFORM_GROUPBOX_CAPTION_06;
	GroupBox6->Caption = PRODUCTINPUTFORM_GROUPBOX_CAPTION_07;
	GroupBox7->Caption = PRODUCTINPUTFORM_GROUPBOX_CAPTION_08;
	GroupBox8->Caption = PRODUCTINPUTFORM_GROUPBOX_CAPTION_09;
	GroupBox1->Caption = PRODUCTINPUTFORM_GROUPBOX_CAPTION_10;
	TabletLengthLabel->Caption = PRODUCTINPUTFORM_LABEL_CAPTION_01;
	Label1->Caption = PRODUCTINPUTFORM_LABEL_CAPTION_03;
	TabletThickLabel->Caption = PRODUCTINPUTFORM_LABEL_CAPTION_06;
	TabletSideThickLabel->Caption = PRODUCTINPUTFORM_LABEL_CAPTION_07;
	Label8->Caption = PRODUCTINPUTFORM_LABEL_CAPTION_08;
	PrintColorCodeLabel->Caption = PRODUCTINPUTFORM_LABEL_CAPTION_08;
	TabletWidthLabel->Caption = PRODUCTINPUTFORM_LABEL_CAPTION_10;
	Label2->Caption = PRODUCTINPUTFORM_LABEL_CAPTION_11;

	if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
		Panel7->Caption = "Inspection History Each Batch";
	else
		Panel7->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_01;

	TabletShapePanel8->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_02;
	TabletTypePanel1->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_03;
	PlateTabletPanel2->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_04;
	TabletTypePanel4->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_05;
	TabletTypePanel3->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_06;
	LightPrintPanel->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_07;
	PlateTabletPanel1->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_08;
	ETCTabletSymmetricLinePanel2->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_09;
	ETCTabletSymmetricLinePanel3->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_02;
	EngraveTypePanel1->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_10;
	EngravePosPanel2->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_11;
	EngravePosPanel3->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_12;
	DarkPrintPanel->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_13;
	EngraveTypePanel4->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_14;
	TabletShapePanel1->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_15;
	EngraveTypePanel2->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_16;
	EngraveTypePanel3->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_17;
	TabletShapePanel2->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_18;
	ETCTabletArrangePanel->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_19;
	ETCTabletNotArrangePanel->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_20;
	TabletShapePanel6->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_21;
	TabletShapePanel5->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_22;
	TabletShapePanel4->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_23;
	TabletShapePanel7->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_24;
	ETCTabletSymmetricLinePanel1->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_25;
	TabletShapePanel3->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_26;
	TabletTypePanel2->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_27;
	EngravePosPanel1->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_28;

	//add
	NewTabletButton->Caption = PRODUCTINPUTFORM_FORM_CAPTION_01;
	GroupBox2->Caption = PRODUCTSEARCHFORM_PANEL_CAPTION_10;
	Label8->Caption = PRODUCTINPUTFORM_LABEL_CAPTION_08;

	MarvelingTabletCheckBox->Caption = PRODUCTINPUTFORM_ETC_CAPTION_01;
	FatTabletCaptureCheckBox1->Caption = "β   ĸó ";
	CurvedSurfaceTabletCheckBox->Caption = "ǥ  ";
	DivisionLineInfoGroupBox->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_29;
	DivisionLineSelectionPanel1->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_30;
	DivisionLineSelectionPanel2->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_31;
	DivisionLineSelectionPanel3->Caption = PRODUCTINPUTFORM_PANEL_CAPTION_32;

	TntGroupBox1->Caption = PRODUCTINPUTFORM_LABEL_CAPTION_12;
	SmallResolPanel->Caption = PRODUCTINPUTFORM_BUTTON_CAPTION_08;
	LargeResolPanel->Caption = PRODUCTINPUTFORM_BUTTON_CAPTION_09;

	ErrorMsg[0] = PRODUCTINPUTFORM_MSG_25; // ǰ Էµ ʾҽϴ.//00
	ErrorMsg[1] = PRODUCTINPUTFORM_MSG_24; // ǰ ó   Է  ϴ. //00
	ErrorMsg[2] = PRODUCTINPUTFORM_MSG_27; // ǰ ʹ ϴ.
	ErrorMsg[3] = PRODUCTINPUTFORM_MSG_23; // ǰ Ҽ  Ư // 00
	ErrorMsg[4] = PRODUCTINPUTFORM_MSG_20; //    ּ //00
	ErrorMsg[5] = PRODUCTINPUTFORM_MSG_17; //    ּ//00
	ErrorMsg[6] = PRODUCTINPUTFORM_MSG_21; //   ʹ ۽ϴ. ̾ƹ // 00
	ErrorMsg[7] = PRODUCTINPUTFORM_MSG_15; //  ̰ ʹ ªϴ.//00
	ErrorMsg[8] = PRODUCTINPUTFORM_MSG_22; //   ʹ ۽ϴ. //00
	ErrorMsg[9] = PRODUCTINPUTFORM_MSG_16; //  β ʹ ϴ.//00
	ErrorMsg[10] = PRODUCTINPUTFORM_MSG_03; //   ּ. // 00
	ErrorMsg[11] = PRODUCTINPUTFORM_MSG_02; //  ġ   ּ. //00
	ErrorMsg[12] = PRODUCTINPUTFORM_MSG_18; //     ּ // 00
	ErrorMsg[13] = PRODUCTINPUTFORM_MSG_12; // μ    ּ  // 00
	RecipeSelectBox->Caption = PRODUCTINPUTFORM_LABEL_CAPTION_14;
	RecipeImageBox->Caption = PRODUCTINPUTFORM_LABEL_CAPTION_15;

}
void __fastcall TProductInputForm::OKBitBtnClick(TObject* Sender)
{
	bool bError = false;

	if (ProductInputMode == PIM_NEW || ProductInputMode == PIM_EDIT)
	{
		/*
			TempProductData.ProductCode = ProductCodeEdit->Text.UpperCase();
			if (TempProductData.ProductCode == "")
			{
			MessageDlgFA("ǰ ڵ尡 Էµ ʾҽϴ.", mtError, TMsgDlgButtons() << mbOK);
			bError = true;
			}
			*/

		if (!bError)
		{
			TempProductData.ProductCode = TempProductData.ProductName = ProductNameEdit->Text;
			try
			{
				int newNameLength;
				newNameLength = TempProductData.ProductCode.Length();

				TempProductData.TabletLength = StrToFloat(TabletLengthEdit->Text);
				TempProductData.TabletWidth = StrToFloat(TabletWidthEdit->Text);
				TempProductData.TabletThick = StrToFloat(TabletThickEdit->Text);
				TempProductData.TabletSideThick = StrToFloat(TabletSideThickEdit->Text);

				if (TempProductData.ProductName.IsEmpty())
				{
					throw Exception(ErrorMsg[0]);
				}
				else if (TempProductData.ProductCode[1] == ' ' || TempProductData.ProductCode[newNameLength] == ' ')
				{
					throw Exception(ErrorMsg[1]);
				}
				else if (ProductNameEdit->Text.Length() > PRODUCT_NAME_LENGTH_LIMIT)
				{
					throw Exception(ErrorMsg[2]);
				}
				else if (TempProductData.ProductName.Pos("/") != 0 ||
					TempProductData.ProductName.Pos("\\") != 0 ||
					TempProductData.ProductName.Pos("*") != 0 ||
					TempProductData.ProductName.Pos("?") != 0 ||
					TempProductData.ProductName.Pos(":") != 0 ||
					TempProductData.ProductName.Pos("\"") != 0 ||
					TempProductData.ProductName.Pos("|") != 0 ||
					TempProductData.ProductName.Pos("<") != 0 ||
					TempProductData.ProductName.Pos(">") != 0 ||
					TempProductData.ProductName.Pos("[") != 0 ||
					TempProductData.ProductName.Pos("]") != 0)
				{
					throw Exception(ErrorMsg[3]);
				}
				else if (TempProductData.TabletType == TABLET_TYPE_UNKNOWN)
				{
					throw Exception(ErrorMsg[4]);
				}
				else if (TempProductData.TabletShape == TABLET_SHAPE_UNKNOWN)
				{
					throw Exception(ErrorMsg[5]);
				}
				else if (TempProductData.TabletLength < MIN_TABLET_LENGTH)
				{
					if (TempProductData.TabletShape == TABLET_SHAPE_CIRCLE)
					{
						throw Exception(ErrorMsg[6]);
					}
					else
					{
						throw Exception(ErrorMsg[7]);
					}
				}
				else if (TempProductData.TabletShape != TABLET_SHAPE_CIRCLE &&
					TempProductData.TabletShape != TABLET_SHAPE_TRIANGLE &&
					TempProductData.TabletShape != TABLET_SHAPE_HEXAGON &&
					TempProductData.TabletShape != TABLET_SHAPE_SQUARE &&
					TempProductData.TabletShape != TABLET_SHAPE_OCTAGON &&
					TempProductData.TabletWidth < MIN_TABLET_WIDTH)
				{
					throw Exception(ErrorMsg[8]);
				}
				else if (TempProductData.TabletThick < MIN_TABLET_THICK)
				{
					throw Exception(ErrorMsg[9]);
				}
				else if (TempProductData.TabletType != TABLET_TYPE_MULTI_LAYERED && TempProductData.TabletColorCode == "")
				{
					throw Exception(ErrorMsg[12]);
				}
				else if (TempProductData.EngraveType == ENGRAVE_TYPE_UNKNOWN)
				{
					throw Exception(ErrorMsg[10]);
				}
				else if (TempProductData.EngraveType != ENGRAVE_TYPE_EMPTY && TempProductData.EngravePos == ENGRAVE_POS_UNKNOWN)
				{
					throw Exception(ErrorMsg[11]);
				}
				else if (TempProductData.EngraveType == ENGRAVE_TYPE_PRINT && TempProductData.PrintColorCode == "")
				{
					throw Exception(ErrorMsg[13]);
				}
				else if (TempProductData.SubSamplingMode == RESOLUTION_HIGH_QUALITY)
				{
					throw Exception("Invalid option : High resolution & Image Offset");
				}
			}
			catch (Exception& ec)
			{
				if (ec.Message != "")
				{
					MessageDlgFA(ec.Message, mtError, TMsgDlgButtons() << mbOK);
				}
				bError = true;
			}
		}

		if (!bError)
		{
			if (ProductInputMode == PIM_NEW)
			{
				AnsiString productFolder = ProgramPath.Product + "\\" + TempProductData.ProductCode;
				if (DirectoryExists(ProgramPath.Product + "\\" + TempProductData.ProductCode))
				{
					if (MessageDlgFA(PRODUCTINPUTFORM_MSG_26, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) != mrOk)
					{
						bError = true;
					}
				}
				else
				{
					if (!CreateDir(productFolder))
					{
						MessageDlgFA(PRODUCTINPUTFORM_MSG_07, mtError, TMsgDlgButtons() << mbOK);
						bError = true;
					}
				}
			}
		}

		if (!bError)
		{
			AnsiString fileName = GetProductDataFileName(TempProductData.ProductCode);
			if (TempProductData.TabletShape == TABLET_SHAPE_CIRCLE ||
				TempProductData.TabletShape == TABLET_SHAPE_HEXAGON ||
				TempProductData.TabletShape == TABLET_SHAPE_TRIANGLE ||
				TempProductData.TabletShape == TABLET_SHAPE_SQUARE ||
				TempProductData.TabletShape == TABLET_SHAPE_OCTAGON)
			{
				TempProductData.TabletWidth = TempProductData.TabletLength;
			}
			if (TempProductData.EngraveType == ENGRAVE_TYPE_EMPTY)
			{
				TempProductData.EngravePos = ENGRAVE_POS_SAME;
			}

			if (ProductInputMode == PIM_NEW)
			{
				TempProductData.ProcessingStep = TABLET_PROCESSING_STEP_CALIBRATION_REQUIRED;

				TempProductData.LastInspectionTime = 0;

				TempProductData.Disk1ThreeDImageCenterXForLaser = 0;
				TempProductData.Disk1ThreeDImageCenterYForLaser = 0;
				TempProductData.Disk2ThreeDImageCenterXForLaser = 0;
				TempProductData.Disk2ThreeDImageCenterYForLaser = 0;

				TempProductData.Disk1ThreeDImageLengthForLaser = 0;
				TempProductData.Disk2ThreeDImageLengthForLaser = 0;

				// set motor speed info
				int msTabletTypeIndex = GetMSTabletTypeIndex(TempProductData.TabletType);
				int msTabletShapeIndex = GetMSTabletShapeIndex(TempProductData.TabletShape);

				for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
				{
					for (int speedIndex = 0; speedIndex < MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT; speedIndex++)
					{
						TempProductData.MotorSpeedList[motorIndex][speedIndex] = MachineParams.MotorSpeedList[msTabletTypeIndex][msTabletShapeIndex][motorIndex][speedIndex];
					}
				}

				/// studyspeed khs
				int msStudyIndex = 7;
				int studySpeedIndex = 0;

				if (MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
				{
					for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
					{
						if (motorIndex == SD1_MOTOR_INDEX || motorIndex == SD2_MOTOR_INDEX || motorIndex == BF_ID_MOTOR_INDEX)
						{
							TempProductData.StudyMotorSpeedList[motorIndex][studySpeedIndex] = MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / 100;
						}
						else
						{
							TempProductData.StudyMotorSpeedList[motorIndex][studySpeedIndex] = MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / 35; // ldh
						}
					}
				}
				else
				{
					for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
					{
						if (motorIndex == SD1_MOTOR_INDEX || motorIndex == SD2_MOTOR_INDEX || motorIndex == BF_ID_MOTOR_INDEX)
						{
							TempProductData.StudyMotorSpeedList[motorIndex][studySpeedIndex] = MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / 100;
						}
						else
						{
							TempProductData.StudyMotorSpeedList[motorIndex][studySpeedIndex] = MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / 50; // ldh
						}
					}
				}

				TempProductData.MachineRunOption.AirKnifeSpeed = GetDefaultAirKnifeSpeed();
				GetDefaultSuctionSpeed(TempProductData, TempProductData.MachineRunOption.SuctionDisk1InverterSpeed, TempProductData.MachineRunOption.SuctionDisk2InverterSpeed);

				//  45   
				// ⺻ ý۰ ϰ ο
				TempProductData.MachineRunOption.applyEjectorDelay = 0;
				TempProductData.MachineRunOption.adjustUnInsDelay = MachineSetupData.EjectorInfo.UnInsEjectorDelay;
				TempProductData.MachineRunOption.adjustDefectDelay = MachineSetupData.EjectorInfo.DefectEjectorDelay;
				//Q
				//TempProductData.MachineRunOption.adjustGoodDelay = MachineSetupData.EjectorInfo.GoodEjectorDelay;
//TempProductData.MachineRunOption.adjustEjectorWindStrength = MachineSetupData.EjectorInfo.EjectorWindStrength;
				int nVal;
				if ((TempProductData.TabletShape == TABLET_SHAPE_OBLONG) || (TempProductData.TabletShape == TABLET_SHAPE_OVAL))
				{
					if (TempProductData.TabletLength >= 20)
						nVal = 180 + 50;
					else if (TempProductData.TabletLength >= 18 && TempProductData.TabletLength < 20)
						nVal = 165 + 50;
					else if (TempProductData.TabletLength >= 16 && TempProductData.TabletLength < 18)
						nVal = 153 + 50;
					else if (TempProductData.TabletLength >= 14 && TempProductData.TabletLength < 16)
						nVal = 134 + 50;
					else if (TempProductData.TabletLength >= 12 && TempProductData.TabletLength < 14)
						nVal = 122 + 50;
					else
						nVal = 115 + 50;
				}
				else
				{
					if (TempProductData.TabletWidth >= 12)
						nVal = 165 + 50;
					else if (TempProductData.TabletWidth >= 10 && TempProductData.TabletWidth < 12)
						nVal = 153 + 50;
					else if (TempProductData.TabletWidth >= 8 && TempProductData.TabletWidth < 10)
						nVal = 134 + 50;
					else if (TempProductData.TabletWidth >= 6 && TempProductData.TabletWidth < 8)
						nVal = 122 + 50;
					else
						nVal = 115 + 50;
				}
				TempProductData.MachineRunOption.adjustEjectorWindStrength = nVal;

				TempProductData.StudiedSensor1Length = TempProductData.TabletLength / MOTOR_SPEED_TO_LENGTH_CONSTANT_DISC_1 * 20.0 * 1090;
				TempProductData.StudiedSensor2Length = TempProductData.TabletLength / MOTOR_SPEED_TO_LENGTH_CONSTANT_DISC_2 * 20.0 * 1090;

				TempProductData.StudiedSensorIntervalA = MachineSetupData.SensorIntervalA;
				TempProductData.StudiedSensorIntervalB = MachineSetupData.SensorIntervalB;

				// set shutter speed info
				AnsiString shutterSpeedFileName = ProgramPath.Env + "\\ShutterSpeedInfor.ini";
				AnsiString threeDParameterInfoFileName = ProgramPath.Env + "\\ThreeDParamInfor.ini";

				unsigned int twoDCameraMap = 0;
				unsigned int threeDCameraMap = 0;
				for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
				{
					if (CameraMapInfo[globalCameraIndex].CameraInspectPosition != CAMERA_POSITION_3D)
					{
						twoDCameraMap |= (0x0001 << globalCameraIndex);
					}
					else
					{
						threeDCameraMap |= (0x0001 << globalCameraIndex);
					}
				}

				if (TempProductData.TabletType != TABLET_TYPE_MULTI_LAYERED)
				{
					LoadShutterSpeedInfo(shutterSpeedFileName, TempProductData.TabletColorCode, GetColorByCode(TempProductData.TabletColorCode), TempProductData.ShutterSpeed, twoDCameraMap, TempProductData.DigitalGainV);
					Load3DParameterInfo(threeDParameterInfoFileName, TempProductData.TabletColorCode, GetColorByCode(TempProductData.TabletColorCode), TempProductData.ShutterSpeed, TempProductData.ThresholdFor3D, threeDCameraMap);
				}
				else
				{
					LoadShutterSpeedInfo(shutterSpeedFileName, "", TempProductData.MultiLayeredTabletColor[0], TempProductData.ShutterSpeed, twoDCameraMap, TempProductData.DigitalGainV);
					Load3DParameterInfo(threeDParameterInfoFileName, "", TempProductData.MultiLayeredTabletColor[0], TempProductData.ShutterSpeed, TempProductData.ThresholdFor3D, threeDCameraMap);
				}


				TempProductData.MachineRunOption.EmptySensorActiveRatio = MachineSetupData.VFInfo.EmptySensorActiveRatio;
				TempProductData.MachineRunOption.FullSensorActiveRatio = MachineSetupData.VFInfo.FullSensorActiveRatio;
				TempProductData.MachineRunOption.ManualMaxSpeed = 100;
				TempProductData.MachineRunOption.ManualModeSensorIndex = 0;
				TempProductData.MachineRunOption.ManualModeSensorActiveRatio = MachineSetupData.VFInfo.ManualModeSensorActiveRatio;
				TempProductData.MachineRunOption.ManualLimitSpeed = 60;
				TempProductData.MachineRunOption.ManualModeLimitSensorIndex = 1;
				TempProductData.MachineRunOption.ManualModeLimitSensorActiveRatio = MachineSetupData.VFInfo.ManualModeLimitSensorActiveRatio;
				TempProductData.MachineRunOption.MaxSpeedTrainingMode = MAX_SPEED_TRAINING_MODE_AUTO;
				TempProductData.MachineRunOption.StartSpeed = MachineSetupData.VFInfo.MechanicalMinSpeed;
				TempProductData.RotatingGuideKind = GetDefaultGuideKind(0, TempProductData.TabletWidth);
				TempProductData.FixedGuideKind = GetDefaultGuideKind(1, TempProductData.TabletWidth);
				TempProductData.VerticalGate2Kind = GetDefaultVGateKind(1, TempProductData.TabletWidth);

				TempProductData.MachineRunOption.EnabledSensorType = 0; // Sensor A 

				GetDefaultNCPosition(TempProductData, TempProductData.NCMotorPos, MachineSetupData.InterlockInfo.NCInterlockAValue /
					100.0 - MachineSetupData.ZeroPositionValue[3] + MachineSetupData.ZeroPositionValue[0]);
				for (int i = 0; i < 2; ++i)
				{
					TempProductData.ExposureTime3D[i] = -1;
					TempProductData.AnalogGain3D[i] = -1;
				}
			}

			if (ProductInputMode == PIM_EDIT)
			{
				AnsiString shutterSpeedFileName = ProgramPath.Env + "\\ShutterSpeedInfor.ini";
				AnsiString threeDParameterInfoFileName = ProgramPath.Env + "\\ThreeDParamInfor.ini";

				unsigned int twoDCameraMap = 0;
				unsigned int threeDCameraMap = 0;
				for (int globalCameraIndex = 0; globalCameraIndex < SYSTEM_TOTAL_CAMERA_COUNT; globalCameraIndex++)
				{
					if (CameraMapInfo[globalCameraIndex].CameraInspectPosition != CAMERA_POSITION_3D)
					{
						twoDCameraMap |= (0x0001 << globalCameraIndex);
					}
					else
					{
						threeDCameraMap |= (0x0001 << globalCameraIndex);
					}
				}

				NewColorCode = TempProductData.TabletColorCode;

				int oldShutterSpeedList[SYSTEM_TOTAL_CAMERA_COUNT];
				int newShutterSpeedList[SYSTEM_TOTAL_CAMERA_COUNT];

				int oldThresholdFor3D[SYSTEM_TOTAL_CAMERA_COUNT];
				int newThresholdFor3D[SYSTEM_TOTAL_CAMERA_COUNT];

				int oldShutterGainList[SYSTEM_TOTAL_CAMERA_COUNT];
				int newShutterGainList[SYSTEM_TOTAL_CAMERA_COUNT];

				memcpy(oldShutterSpeedList, TempProductData.ShutterSpeed, sizeof(int) * SYSTEM_TOTAL_CAMERA_COUNT);
				memcpy(oldThresholdFor3D, TempProductData.ThresholdFor3D, sizeof(int) * SYSTEM_TOTAL_CAMERA_COUNT);
				memcpy(oldShutterGainList, TempProductData.DigitalGainV, sizeof(int) * SYSTEM_TOTAL_CAMERA_COUNT);

				if (OldColorCode != NewColorCode)
				{
					if (TempProductData.TabletType != TABLET_TYPE_MULTI_LAYERED)
					{
						LoadShutterSpeedInfo(shutterSpeedFileName, TempProductData.TabletColorCode, GetColorByCode(TempProductData.TabletColorCode), TempProductData.ShutterSpeed, twoDCameraMap, TempProductData.DigitalGainV);
						Load3DParameterInfo(threeDParameterInfoFileName, TempProductData.TabletColorCode, GetColorByCode(TempProductData.TabletColorCode), TempProductData.ShutterSpeed, TempProductData.ThresholdFor3D, threeDCameraMap);
					}
					else
					{
						LoadShutterSpeedInfo(shutterSpeedFileName, "", TempProductData.MultiLayeredTabletColor[0], TempProductData.ShutterSpeed, twoDCameraMap, TempProductData.DigitalGainV);
						Load3DParameterInfo(threeDParameterInfoFileName, "", TempProductData.MultiLayeredTabletColor[0], TempProductData.ShutterSpeed, TempProductData.ThresholdFor3D, threeDCameraMap);
					}
				}

				memcpy(newShutterSpeedList, TempProductData.ShutterSpeed, sizeof(int) * SYSTEM_TOTAL_CAMERA_COUNT);
				memcpy(newThresholdFor3D, TempProductData.ThresholdFor3D, sizeof(int) * SYSTEM_TOTAL_CAMERA_COUNT);
				memcpy(newShutterGainList, TempProductData.DigitalGainV, sizeof(int) * SYSTEM_TOTAL_CAMERA_COUNT);

				int reviseSW = 0;
				for (int m = 0; m < SYSTEM_TOTAL_CAMERA_COUNT; m++)
				{
					if (oldShutterSpeedList[m] != newShutterSpeedList[m])
					{
						reviseSW = 1;
						break;
					}
				}

				for (int m = 0; m < SYSTEM_TOTAL_CAMERA_COUNT; m++)
				{
					if (oldThresholdFor3D[m] != newThresholdFor3D[m])
					{
						reviseSW = 1;
						break;
					}
				}

				for (int m = 0; m < SYSTEM_TOTAL_CAMERA_COUNT; m++)
				{
					if (oldShutterGainList[m] != newShutterGainList[m])
					{
						reviseSW = 1;
						break;
					}
				}

				if (reviseSW)
				{
					ShowMessage(NEW_ADD_STRING_59);
				}
			}

			if (TempProductData.TabletType == TABLET_TYPE_SUGAR_COATED)
			{
				TempProductData.LampKind = MACHINE_LAMP_KIND_SUGAR_COATED_TABLET;
			}
			else
			{
				TempProductData.LampKind = MACHINE_LAMP_KIND_NORMAL_TABLET;
			}

			if (MarvelingTabletCheckBox->Checked)
				TempProductData.MarvelingTabletSW = 1;
			else
				TempProductData.MarvelingTabletSW = 0;
			
			if(FatTabletCaptureCheckBox1->Checked)
				TempProductData.FatTabletCapture = 1;
			else		
				TempProductData.FatTabletCapture = 0;
			if (CurvedSurfaceTabletCheckBox->Checked)
				TempProductData.CurvedSurfaceTabletSW = 1;
			else
				TempProductData.CurvedSurfaceTabletSW = 0;

			TTntComboBox* RecipeSel = (TTntComboBox*)FindComponent("RecipeSelect");
			if (RecipeSel)
			{
				TempProductData.RecipeName = RecipeSel->Text;

			}

			if (!bError)
			{
				if (ProductInputMode == PIM_NEW)
				{
					AddCSVActionLog(ECSV_ACTION_PRODUCT_ADD, UserInfo.Name, TempProductData.ProductName, NULL, 0);
				}
					
				if (ProductInputMode == PIM_EDIT)
				{
          		bool tabletInfoModified, machineInfoModified, inspectionInfoModified;
			    	GetDataModificationInfo(TempProductData, &tabletInfoModified, &machineInfoModified, &inspectionInfoModified);
      
					if (tabletInfoModified == true)
          		{
						AddCSVActionLog(ECSV_ACTION_PRODUCT_EDIT, UserInfo.Name, TempProductData.ProductName, NULL, 0);

		              if (LastSelectSubSamplingMode != TempProductData.SubSamplingMode)
		              {
		                AnsiString productFolder = ProgramPath.Product + "\\" + TempProductData.ProductCode;
		                AnsiString ImageFolder = productFolder + "\\Image";

		                TempProductData.ProcessingStep = TABLET_PROCESSING_STEP_CALIBRATION_REQUIRED;

			                try
			                {
			                  if (DirectoryExists(ImageFolder))
			                  {
			                    RemoveWholeDir(ImageFolder);
			                    CreateDir(ImageFolder);
			                  }
			                  else
			                  {
			                    CreateDir(ImageFolder);
			                  }
			                  if (FileExists(productFolder + "\\" + TempProductData.ProductCode + ".grd"))
			                    DeleteFileW(productFolder + "\\" + TempProductData.ProductCode + ".grd");
			                  if (FileExists(productFolder + "\\" + TempProductData.ProductCode + ".sdt"))
			                    DeleteFileW(productFolder + "\\" + TempProductData.ProductCode + ".sdt");
			                  if (FileExists(productFolder + "\\" + TempProductData.ProductCode + ".sdt_3D"))
			                    DeleteFileW(productFolder + "\\" + TempProductData.ProductCode + ".sdt_3D");
			                  if (FileExists(productFolder + "\\" + TempProductData.ProductCode + ".stl"))
			                    DeleteFileW(productFolder + "\\" + TempProductData.ProductCode + ".stl");
			                  if (FileExists(productFolder + "\\" + TempProductData.ProductCode + ".stu"))
			                    DeleteFileW(productFolder + "\\" + TempProductData.ProductCode + ".stu");

			                }
			                catch (...)
			                {
			                }
            				}							
          			}
				}
			
			}

			if (!WriteProductData(fileName, TempProductData))
			{
				MessageDlgFA(PRODUCTINPUTFORM_MSG_14, mtError, TMsgDlgButtons() << mbOK);
				bError = true;
			}	
			
		}
		if(TempProductData.EngraveType != ENGRAVE_TYPE_PRINT && MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable==1)
		{
			MessageDlgFA("ش ǰ μ⸦    ǰԴϴ.   Laser complexer Enable   ϼ", mtConfirmation, TMsgDlgButtons() << mbOK);
		}
		
	}
	NFALaserinfo.SendDLLCommand = CMD_LASER_RECIPE_SELECT;
	if (!bError)
	{
		ProductSettingMode = ProductInputMode;
		/// studyspeed khs
		int msStudyIndex = 7;
		int studySpeedIndex = 0;
		int motorIndex = 0;

		if (MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / TempProductData.StudyMotorSpeedList[motorIndex][studySpeedIndex] < 10)
		{
			for (motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
			{
				if (motorIndex == SD1_MOTOR_INDEX || motorIndex == SD2_MOTOR_INDEX || motorIndex == BF_ID_MOTOR_INDEX)
				{
					TempProductData.StudyMotorSpeedList[motorIndex][studySpeedIndex] = MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / 100;
				}
				else
				{
					TempProductData.StudyMotorSpeedList[motorIndex][studySpeedIndex] = MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / 50;
				}
			}
		}


		ColorCountClear_Func(); //for PC_SIM
		CopyProductData(ProductData, TempProductData);

		if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
		{
			TIniFile* iniFile = new TIniFile(ProgramPath.Env + "\\UserSetting.ini");
			if (iniFile)
			{
				WideString lastProductName = iniFile->ReadString("Quick Start", "Recent Product", "");
				WideString lastInspectionLot = iniFile->ReadString("Quick Start", "Recent Lot", "");
				delete iniFile;

				if (!lastProductName.IsEmpty() && !ProductData.ProductCode.IsEmpty())
				{
					WideString PName = ProductData.ProductName;
					WideString LastPName = lastProductName;
					if (_tcscmp(_tcslwr(PName), _tcslwr(LastPName)) == 0)
					{
						ProductData.LOTName = lastInspectionLot;
					}
				}
			}
		}
		else
		{
			ProductData.LOTName = "Test";
		}


		if (ProductData.ProductionCount <= 0)
			ProductData.ProductionCount = 0;
		UpdateLookupTable(TempProductData.ProductCode);
		WriteDefaultEjectInformation();
		ModalResult = mrOk;
		//cjg OPC Test
		MakeMESProductDat();
		if (hOPC_DLL) (*pSetMESProductData)(&MESProductData);
	}
	//      

	AddCSVActionLog(ECSV_ACTION_PRODUCT_SELECTION, UserInfo.Name, TempProductData.ProductName, NULL, 0);
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::RefreshSizeInputMenu(void)
{
	if (TempProductData.TabletShape == TABLET_SHAPE_UNKNOWN)
	{
		TabletLengthLabel->Visible = false;
		TabletLengthEdit->Visible = false;
		TabletWidthLabel->Visible = false;
		TabletWidthEdit->Visible = false;
		TabletThickLabel->Visible = false;
		TabletThickEdit->Visible = false;
		TabletSideThickLabel->Visible = false;
		TabletSideThickEdit->Visible = false;
	}
	else if (TempProductData.TabletShape == TABLET_SHAPE_CIRCLE)
	{
		TabletLengthLabel->Visible = true;
		TabletLengthEdit->Visible = true;
		TabletWidthLabel->Visible = false;
		TabletWidthEdit->Visible = false;
		TabletThickLabel->Visible = true;
		TabletThickEdit->Visible = true;
		TabletSideThickLabel->Visible = true;
		TabletSideThickEdit->Visible = true;

		TabletLengthLabel->Caption = PRODUCTINPUTFORM_LABEL_CAPTION_09;
	}
	else if (TempProductData.TabletShape == TABLET_SHAPE_HEXAGON ||
		TempProductData.TabletShape == TABLET_SHAPE_SQUARE ||
		TempProductData.TabletShape == TABLET_SHAPE_OCTAGON)
	{
		TabletLengthLabel->Visible = true;
		TabletLengthEdit->Visible = true;
		TabletWidthLabel->Visible = false;
		TabletWidthEdit->Visible = false;
		TabletThickLabel->Visible = true;
		TabletThickEdit->Visible = true;
		TabletSideThickLabel->Visible = true;
		TabletSideThickEdit->Visible = true;

		TabletLengthLabel->Caption = PRODUCTINPUTFORM_LABEL_CAPTION_04;
	}
	else if (TempProductData.TabletShape == TABLET_SHAPE_TRIANGLE)
	{
		TabletLengthLabel->Visible = true;
		TabletLengthEdit->Visible = true;
		TabletWidthLabel->Visible = false;
		TabletWidthEdit->Visible = false;
		TabletThickLabel->Visible = true;
		TabletThickEdit->Visible = true;
		TabletSideThickLabel->Visible = true;
		TabletSideThickEdit->Visible = true;

		TabletLengthLabel->Caption = PRODUCTINPUTFORM_LABEL_CAPTION_05;
	}
	else
	{
		TabletLengthLabel->Visible = true;
		TabletLengthEdit->Visible = true;
		TabletWidthLabel->Visible = true;
		TabletWidthEdit->Visible = true;
		TabletThickLabel->Visible = true;
		TabletThickEdit->Visible = true;
		TabletSideThickLabel->Visible = true;
		TabletSideThickEdit->Visible = true;

		TabletLengthLabel->Caption = PRODUCTINPUTFORM_LABEL_CAPTION_02;
	}
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::RefreshPrintingInputMenu(void)
{
	if (TempProductData.EngraveType == ENGRAVE_TYPE_EMPTY ||
		TempProductData.EngraveType == ENGRAVE_TYPE_UNKNOWN)
	{
		EngravePosPanel1->Visible = false;
		EngravePosPanel2->Visible = false;
		EngravePosPanel3->Visible = false;
	}
	else
	{
		EngravePosPanel1->Visible = true;
		EngravePosPanel2->Visible = true;
		EngravePosPanel3->Visible = true;
	}


	if (TempProductData.EngraveType == ENGRAVE_TYPE_PRINT)
	{
		LightPrintPanel->Visible = true;
		DarkPrintPanel->Visible = true;
		PrintColorCodeLabel->Visible = true;
		PrintColorCodeEdit->Visible = true;
		PrintColorShape->Visible = true;
	}
	else
	{
		LightPrintPanel->Visible = false;
		DarkPrintPanel->Visible = false;
		PrintColorCodeLabel->Visible = false;
		PrintColorCodeEdit->Visible = false;
		PrintColorShape->Visible = false;
	}
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::ProductTextEditClick(TObject* Sender)
{
	TTntEdit* theEdit = (TTntEdit*)Sender;

	/*
	if(DefaultLCID != 1042 && DefaultLCID != 2066 && DefaultLCID != 1033)
	{
	KeyboardForm->SetWindowsKeyboard();
	}
	else*/
	{
		KeyboardForm->Text = theEdit->Text;
		if (KeyboardForm->ShowKeyboard() == mrOk)
		{
			theEdit->Text = KeyboardForm->Text;
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TProductInputForm::ProductNumEditClick(TObject* Sender)
{
	TTntEdit* theEdit = (TTntEdit*)Sender;

	/*
	if(DefaultLCID != 1042 && DefaultLCID != 2066 && DefaultLCID != 1033)
	{
	KeyboardForm->SetWindowsKeyboard();
	}
	else*/
	{
		KeyboardForm->Text = theEdit->Text;
		if (KeyboardForm->ShowKeypad() == mrOk)
		{
			theEdit->Text = KeyboardForm->Text;
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TProductInputForm::NewTabletButtonClick(TObject* Sender)
{
	TabletInfoPanel->Visible = true;
	TabletSearchPanel->Visible = false;
	SubProductSearchForm->Hide();

	ClearTabletInfo();
	ProductInputMode = PIM_NEW;
	UpdateEditableComponents();
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::ClearTabletInfo(void)
{
	TempProductData.ProductCode = "";
	TempProductData.ProductName = "";
	TempProductData.LOTName = "";
	TempProductData.TabletLength = 0;
	TempProductData.TabletWidth = 0;
	TempProductData.TabletThick = 0;
	TempProductData.TabletSideThick = 0;
	TempProductData.TabletType = TABLET_TYPE_UNKNOWN;
	TempProductData.TabletShape = TABLET_SHAPE_UNKNOWN;
	TempProductData.EngraveType = ENGRAVE_TYPE_UNKNOWN;
	TempProductData.EngravePos = ENGRAVE_POS_UNKNOWN;
	TempProductData.TabletColorCode = "";
	TempProductData.PrintColorCode = "";
	TempProductData.ProductionCount = 0;
	TempProductData.DivisionLineInfo = DIVISION_LINE_NONE;

	if (!PCProgramOption.ActiveResolutionSetting)
	{
		TntGroupBox1->Visible = false;
		TempProductData.SubSamplingMode = IMAGE_SUBSAMPLING_MODE;
	}
	else
	{
		TempProductData.SubSamplingMode = PCProgramOption.InitSubSamplingMode;
	}

	RefreshProductData();
}
//---------------------------------------------------------------------------


void __fastcall TProductInputForm::ExsistTabletButtonClick(TObject* Sender)
{
	TabletSearchPanel->Visible = true;
	TabletInfoPanel->Visible = false;
	SubProductSearchForm->RefreshProductList();
	SubProductSearchForm->Search("");
	//    SubProductSearchForm->Show();
	SubProductSearchForm->ShowModal();
	LastSelectSubSamplingMode = TempProductData.SubSamplingMode;
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::FormDestroy(TObject* Sender)
{
	delete SubProductSearchForm;
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::ProductSearchOKClick(TObject* Sender)
{
	AnsiString productCode = SubProductSearchForm->GetSelectedProductCode();
	//ProductCodeEdit->Text = productCode;
	if (LoadProductData(productCode))
	{
		ProductInputMode = PIM_EXIST;
		RefreshProductData();
		//        UpdateInspectionResult();
		UpdateEditableComponents();
	}
	else
	{
		ShowMessageFA(PRODUCTINPUTFORM_MSG_04);
		ProductInputMode = PIM_NEW;
		UpdateEditableComponents();
	}
	TabletInfoPanel->Visible = true;
	TabletSearchPanel->Visible = false;
	SubProductSearchForm->Hide();


}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::ProductSearchCancelClick(TObject* Sender)
{
	SubProductSearchForm->Hide();
	TabletSearchPanel->Visible = false;
	if (ProductInputMode != PIM_NONE)
	{
		TabletInfoPanel->Visible = true;
	}
	UpdateEditableComponents();
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::TabletTypePanelClick(TObject* Sender)
{
	TTntPanel* thePanel = (TTntPanel*)Sender;

	if (TempProductData.SubSamplingMode == RESOLUTION_HIGH_QUALITY)
	{
		if (thePanel->Tag == 2)
		{
			ShowMessage(PRODUCTINPUTFORM_MSG_28);

			TempProductData.TabletType = TABLET_TYPE_SUGAR_COATED;
			RefreshTypeSelectionMenu();

			TempProductData.SubSamplingMode = RESOLUTION_NORMAL_QUALITY;
			RefreshResolutionMenu();
			return;
		}
	}

	switch (thePanel->Tag)
	{
	case 0:
		TempProductData.TabletType = TABLET_TYPE_UNCOATED;
		break;
	case 1:
		TempProductData.TabletType = TABLET_TYPE_FILM_COATED;
		break;
	case 2:
		TempProductData.TabletType = TABLET_TYPE_SUGAR_COATED;
		break;
	case 3:
		TempProductData.TabletType = TABLET_TYPE_MULTI_LAYERED;
		if (TempProductData.TabletLayerCount < 2) TempProductData.TabletLayerCount = 2;
		else if (TempProductData.TabletLayerCount > 3) TempProductData.TabletLayerCount = 3;
		break;
	case 255:
		TempProductData.TabletType = TABLET_TYPE_OTHER;
		break;
	default:
		TempProductData.TabletType = TABLET_TYPE_UNKNOWN;
		break;
	}
	RefreshTypeSelectionMenu();
}
//---------------------------------------------------------------------------

void __fastcall TProductInputForm::TabletShapePanelClick(TObject* Sender)
{
	TTntPanel* thePanel = (TTntPanel*)Sender;
	switch (thePanel->Tag)
	{
	case 0:
		TempProductData.TabletShape = TABLET_SHAPE_CIRCLE;
		TempProductData.SymmetricLineCount = 0;
		break;
	case 1:
		TempProductData.TabletShape = TABLET_SHAPE_OBLONG;
		TempProductData.SymmetricLineCount = 0;
		break;
	case 2:
		TempProductData.TabletShape = TABLET_SHAPE_OVAL;
		TempProductData.SymmetricLineCount = 0;
		break;
	case 3:
		TempProductData.TabletShape = TABLET_SHAPE_HEXAGON;
		TempProductData.SymmetricLineCount = 0;
		break;
	case 4:
		TempProductData.TabletShape = TABLET_SHAPE_TRIANGLE;
		TempProductData.SymmetricLineCount = 0;
		break;
	case 5:
		TempProductData.TabletShape = TABLET_SHAPE_SQUARE;
		TempProductData.SymmetricLineCount = 0;
		break;
	case 6:
		TempProductData.TabletShape = TABLET_SHAPE_OCTAGON;
		TempProductData.SymmetricLineCount = 0;
		break;
	case 10:
		TempProductData.TabletShape = TABLET_SHAPE_ETC;
		TempProductData.SymmetricLineCount = 2;
		break;
	default:
		TempProductData.TabletShape = TABLET_SHAPE_UNKNOWN;
		TempProductData.SymmetricLineCount = 0;
		break;
	}

	RefreshShapeSelectionMenu();
	RefreshETCInputMenu();
}
//---------------------------------------------------------------------------

void __fastcall TProductInputForm::EngraveTypePanelClick(TObject* Sender)
{
	TTntPanel* thePanel = (TTntPanel*)Sender;
	switch (thePanel->Tag)
	{
	case 0:
		TempProductData.EngraveType = ENGRAVE_TYPE_RELIEF;
		break;
	case 1:
		TempProductData.EngraveType = ENGRAVE_TYPE_INTAGLIO;
		break;
	case 2:
		TempProductData.EngraveType = ENGRAVE_TYPE_PRINT;
		break;
	case 3:
		TempProductData.EngraveType = ENGRAVE_TYPE_EMPTY;
		break;
	default:
		TempProductData.EngraveType = ENGRAVE_TYPE_UNKNOWN;
		break;
	}

	if (TempProductData.EngraveType == ENGRAVE_TYPE_PRINT)
		GroupBox5->Caption = PRODUCTINPUTFORM_GROUPBOX_CAPTION_11;
	else
		GroupBox5->Caption = PRODUCTINPUTFORM_GROUPBOX_CAPTION_01;

	RefreshEngraveTypeSelectionMenu();
	RefreshDivisionLineInfoMenu();
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::EngravePosPanelClick(TObject* Sender)
{
	TTntPanel* thePanel = (TTntPanel*)Sender;
	switch (thePanel->Tag)
	{
	case 0:
		TempProductData.EngravePos = ENGRAVE_POS_ONESIDE;
		break;
	case 1:
		TempProductData.EngravePos = ENGRAVE_POS_SAME;
		break;
	case 2:
		TempProductData.EngravePos = ENGRAVE_POS_DIFF;
		break;
	default:
		TempProductData.EngravePos = ENGRAVE_TYPE_UNKNOWN;
		break;
	}
	RefreshEngravePosSelectionMenu();
}
//---------------------------------------------------------------------------
bool __fastcall TProductInputForm::LoadProductData(WideString productCode)
{
	AnsiString productFileName = GetProductDataFileName(productCode);
	return ReadProductData(productFileName, TempProductData, MachineParams, MachineSetupData);
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::RefreshProductData(void)
{
	RefreshTypeSelectionMenu();
	RefreshShapeSelectionMenu();
	RefreshEngraveTypeSelectionMenu();
	RefreshEngravePosSelectionMenu();
	RefreshDivisionLineInfoMenu();
	RefreshSubDivisionLineInfoMenu();
	RefreshPrintBrightnessSelectionMenu();
	RefreshPlateSelectionMenu();
	RefreshETCInputMenu();
	RefreshResolutionMenu();

	if (MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable == 1)
	{
		RefreshRecipeSelectMenu();
	}
	//ProductCodeEdit->Text = TempProductData.ProductCode;
	ProductNameEdit->Text = TempProductData.ProductName;
	TabletLengthEdit->Text = FloatToStr(TempProductData.TabletLength);
	TabletWidthEdit->Text = FloatToStr(TempProductData.TabletWidth);
	TabletThickEdit->Text = FloatToStr(TempProductData.TabletThick);
	TabletSideThickEdit->Text = FloatToStr(TempProductData.TabletSideThick);

	if (TempProductData.MarvelingTabletSW)
		MarvelingTabletCheckBox->Checked = true;
	else
		MarvelingTabletCheckBox->Checked = false;
	
	if(TempProductData.FatTabletCapture)
		FatTabletCaptureCheckBox1->Checked = true;
	else		
		FatTabletCaptureCheckBox1->Checked = false;
	if (TempProductData.CurvedSurfaceTabletSW)
		CurvedSurfaceTabletCheckBox->Checked = true;
	else
		CurvedSurfaceTabletCheckBox->Checked = false;
	RefreshTabletColor();
	PrintColorCodeEdit->Text = TempProductData.PrintColorCode;
	PrintColorShape->Brush->Color = GetColorByCode(TempProductData.PrintColorCode);
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::RefreshRecipeSelectMenu(void)
{
	WideString RecipeName;
	TTntComboBox* RecipeSel = (TTntComboBox*)FindComponent("RecipeSelect");
	int RecipeImgIndex;
	int temp_itemsel = -1;
	if (RecipeSel)
	{
		for (int i = 0; i < (int)RecipeInfo.RecipeCount; i++)
		{
			RecipeName.operator =(RecipeInfo.RecipeName[i]);
			RecipeSel->Items->Add(RecipeName);
			if (TempProductData.RecipeName != NULL)
			{
				if (RecipeName == TempProductData.RecipeName)
				{
					temp_itemsel = i;
				}
			}
			else
			{
				RecipeSel->ItemIndex = i;
			}
		}
		if (RecipeInfo.RecipeCount > 0)
		{
			if (temp_itemsel != -1)
			{
				RecipeSel->ItemIndex = temp_itemsel;
				AnsiString filePath = "D:\\Project\\sLaser\\Res\\Resource\\" + RecipeSelect->Text + ".bmp";
				UpdateRecipeImage(filePath);
			}
			else
			{
				RecipeSel->ItemIndex = 0;
			}
		}
	}
	if (RecipeInfo.RecipeCount <= 0)
	{
		ShowMessageFA("Recipe do not exist");
	}


}
void __fastcall TProductInputForm::RefreshTypeSelectionMenu(void)
{
	for (int typeIndex = 0; typeIndex < 4; typeIndex++)
	{
		TTntPanel* typePanel = (TTntPanel*)FindComponent("TabletTypePanel" + IntToStr(typeIndex + 1));
		typePanel->Color = clWhite;
		typePanel->Font->Color = clBlack;
		typePanel->Font->Style = typePanel->Font->Style >> fsBold;
	}
	TTntPanel* selectedPanel = NULL;
	switch (TempProductData.TabletType)
	{
	case TABLET_TYPE_UNCOATED:
		selectedPanel = TabletTypePanel1;
		break;
	case TABLET_TYPE_FILM_COATED:
		selectedPanel = TabletTypePanel2;
		break;
	case TABLET_TYPE_SUGAR_COATED:
		selectedPanel = TabletTypePanel3;
		break;
	case TABLET_TYPE_MULTI_LAYERED:
		selectedPanel = TabletTypePanel4;
		break;
	case TABLET_TYPE_UNKNOWN:
	default:
		selectedPanel = NULL;
		break;
	}
	if (selectedPanel)
	{
		selectedPanel->Color = clBlue;
		selectedPanel->Font->Color = clWhite;
		selectedPanel->Font->Style = selectedPanel->Font->Style << fsBold;
	}
	if (TempProductData.TabletType == TABLET_TYPE_MULTI_LAYERED)
	{
		MultiLayeredTabletPanel->Visible = true;
		TabletColorCodeEdit->Enabled = false;
		TabletLayerCountEdit->Text = IntToStr(TempProductData.TabletLayerCount);
	}
	else
	{
		MultiLayeredTabletPanel->Visible = false;
		TabletColorCodeEdit->Enabled = true;
		TabletLayerCountEdit->Text = IntToStr(1);
	}
	RefreshTabletColor();
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::RefreshShapeSelectionMenu(void)
{
	for (int typeIndex = 0; typeIndex < 8; typeIndex++)
	{
		TTntPanel* typePanel = (TTntPanel*)FindComponent("TabletShapePanel" + IntToStr(typeIndex + 1));
		typePanel->Color = clWhite;
		typePanel->Font->Color = clBlack;
		typePanel->Font->Style = typePanel->Font->Style >> fsBold;
	}

	TTntPanel* selectedPanel = NULL;
	switch (TempProductData.TabletShape)
	{
	case TABLET_SHAPE_CIRCLE:
		selectedPanel = TabletShapePanel1;
		break;
	case TABLET_SHAPE_OBLONG:
		selectedPanel = TabletShapePanel2;
		break;
	case TABLET_SHAPE_OVAL:
		selectedPanel = TabletShapePanel3;
		break;
	case TABLET_SHAPE_HEXAGON:
		selectedPanel = TabletShapePanel4;
		break;
	case TABLET_SHAPE_TRIANGLE:
		selectedPanel = TabletShapePanel5;
		break;
	case TABLET_SHAPE_SQUARE:
		selectedPanel = TabletShapePanel6;
		break;
	case TABLET_SHAPE_OCTAGON:
		selectedPanel = TabletShapePanel7;
		break;
	case TABLET_SHAPE_ETC:
		selectedPanel = TabletShapePanel8;
		break;
	case TABLET_SHAPE_UNKNOWN:
	default:
		selectedPanel = NULL;
		break;
	}
	if (selectedPanel)
	{
		selectedPanel->Color = clBlue;
		selectedPanel->Font->Color = clWhite;
		selectedPanel->Font->Style = selectedPanel->Font->Style << fsBold;
	}

	RefreshSizeInputMenu();
	RefreshETCInputMenu();
	UpdateTabletImage();
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::RefreshEngraveTypeSelectionMenu(void)
{
	for (int typeIndex = 0; typeIndex < 4; typeIndex++)
	{
		TTntPanel* typePanel = (TTntPanel*)FindComponent("EngraveTypePanel" + IntToStr(typeIndex + 1));

		if (typeIndex != 0) // 2019-06-19 簢  
			typePanel->Color = clWhite;
		typePanel->Font->Color = clBlack;
		typePanel->Font->Style = typePanel->Font->Style >> fsBold;
	}

	TTntPanel* selectedPanel = NULL;
	switch (TempProductData.EngraveType)
	{
	case ENGRAVE_TYPE_RELIEF:
		selectedPanel = EngraveTypePanel1;
		break;
	case ENGRAVE_TYPE_INTAGLIO:
		selectedPanel = EngraveTypePanel2;
		break;
	case ENGRAVE_TYPE_PRINT:
		selectedPanel = EngraveTypePanel3;
		break;
	case ENGRAVE_TYPE_EMPTY:
		selectedPanel = EngraveTypePanel4;
		break;
	case ENGRAVE_TYPE_UNKNOWN:
	default:
		selectedPanel = NULL;
		break;
	}
	if (selectedPanel)
	{
		selectedPanel->Color = clBlue;
		selectedPanel->Font->Color = clWhite;
		selectedPanel->Font->Style = selectedPanel->Font->Style << fsBold;
	}

	RefreshPrintingInputMenu();
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::RefreshEngravePosSelectionMenu(void)
{
	for (int typeIndex = 0; typeIndex < 3; typeIndex++)
	{
		TTntPanel* typePanel = (TTntPanel*)FindComponent("EngravePosPanel" + IntToStr(typeIndex + 1));
		typePanel->Color = clWhite;
		typePanel->Font->Color = clBlack;
		typePanel->Font->Style = typePanel->Font->Style >> fsBold;
	}

	TTntPanel* selectedPanel = NULL;
	switch (TempProductData.EngravePos)
	{
	case ENGRAVE_POS_ONESIDE:
		selectedPanel = EngravePosPanel1;
		break;
	case ENGRAVE_POS_SAME:
		selectedPanel = EngravePosPanel2;
		break;
	case ENGRAVE_POS_DIFF:
		selectedPanel = EngravePosPanel3;
		break;
	case ENGRAVE_TYPE_UNKNOWN:
	default:
		selectedPanel = NULL;
		break;
	}
	if (selectedPanel)
	{
		selectedPanel->Color = clBlue;
		selectedPanel->Font->Color = clWhite;
		selectedPanel->Font->Style = selectedPanel->Font->Style << fsBold;
	}

}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::RefreshPrintBrightnessSelectionMenu(void)
{
	LightPrintPanel->Color = clWhite;
	LightPrintPanel->Font->Color = clBlack;
	LightPrintPanel->Font->Style = LightPrintPanel->Font->Style >> fsBold;

	DarkPrintPanel->Color = clWhite;
	DarkPrintPanel->Font->Color = clBlack;
	DarkPrintPanel->Font->Style = DarkPrintPanel->Font->Style >> fsBold;

	TTntPanel* selectedPanel = NULL;
	switch (TempProductData.PrintBrightness)
	{
	case PRINT_BRIGHTNESS_LIGHT:
		selectedPanel = LightPrintPanel;
		break;
	case PRINT_BRIGHTNESS_DARK:
		selectedPanel = DarkPrintPanel;
		break;
	case ENGRAVE_TYPE_UNKNOWN:
	default:
		selectedPanel = NULL;
		break;
	}
	if (selectedPanel)
	{
		selectedPanel->Color = clBlue;
		selectedPanel->Font->Color = clWhite;
		selectedPanel->Font->Style = selectedPanel->Font->Style << fsBold;
	}
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::RefreshPlateSelectionMenu(void)
{
	for (int typeIndex = 0; typeIndex < 2; typeIndex++)
	{
		TTntPanel* typePanel = (TTntPanel*)FindComponent("PlateTabletPanel" + IntToStr(typeIndex + 1));
		typePanel->Color = clWhite;
		typePanel->Font->Color = clBlack;
		typePanel->Font->Style = typePanel->Font->Style >> fsBold;
	}

	TTntPanel* selectedPanel = NULL;
	if (TempProductData.PlateTablet)
	{
		selectedPanel = PlateTabletPanel2;
	}
	else
	{
		selectedPanel = PlateTabletPanel1;
	}
	if (selectedPanel)
	{
		selectedPanel->Color = clBlue;
		selectedPanel->Font->Color = clWhite;
		selectedPanel->Font->Style = selectedPanel->Font->Style << fsBold;
	}
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::UpdateEditableComponents(void)
{
	if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_PRODUCTINPUTFORM_MAKE_NEW_PRODUCT])
		NewTabletButton->Visible = true;
	else
		NewTabletButton->Visible = false;

	if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_PRODUCTINPUTFORM_SEARCH_PRODUCT])
		ExsistTabletButton->Visible = true;
	else
		ExsistTabletButton->Visible = false;

	if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_PRODUCTINPUTFORM_CHANGE_NAME])
		RenameButton->Visible = true;
	else
		RenameButton->Visible = false;

	if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_PRODUCTINPUTFORM_CHANGE_DATA_INFO])
		DataEditButton->Visible = true;
	else
		DataEditButton->Visible = false;

	if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_PRODUCTINPUTFORM_MAKE_CLONE])
		SaveAsButton->Visible = true;
	else
		SaveAsButton->Visible = false;

	if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_PRODUCTINPUTFORM_DELETE_DATA_INFO])
		DataDeleteButton->Visible = true;
	else
		DataDeleteButton->Visible = false;

	if (ProductInputMode == PIM_EXIST)
	{
		UpperEditPanel->Enabled = false;
		LowerEditPanel->Enabled = false;
		TopEditPanel->Enabled = false;
		RightEditPanel->Enabled = false;
		Panel5->Enabled = false;

		if (MachineSetupData.CompanyID == INTERNATIONAL_MACHINE2)
		{
			PrintButton->Visible = true;
		}

		UpperEditPanel->Color = clGray;
		LowerEditPanel->Color = clGray;
		TopEditPanel->Color = clGray;
		RightEditPanel->Color = clGray;
		Panel5->Color = clGray;

		InspectionRecordPanel->Visible = false;
		TabletImagePanel->Visible = false;
	}
	else
	{
		if (ProductInputMode == PIM_EDIT)
		{
			TopEditPanel->Enabled = false;
			TopEditPanel->Color = clGray;
			SubSamplingModeModifyCheck = true;
		}
		else    // new, none
		{
			TopEditPanel->Enabled = true;
			TopEditPanel->Color = clBlack;
			SubSamplingModeModifyCheck = false;
		}
		InspectionRecordPanel->Visible = false;
		UpperEditPanel->Enabled = true;
		LowerEditPanel->Enabled = true;
		RightEditPanel->Enabled = true;
		Panel5->Enabled = true;

		UpperEditPanel->Color = clBlack;
		LowerEditPanel->Color = clBlack;
		RightEditPanel->Color = clBlack;
		Panel5->Color = clBlack;

		TabletImagePanel->Visible = true;
		RenameButton->Visible = false;
		SaveAsButton->Visible = false;
		DataEditButton->Visible = false;
		DataDeleteButton->Visible = false;
		PrintButton->Visible = false;

		UpdateTabletImage();
	}
	if (ProductInputMode == PIM_NONE)
	{
		OKBitBtn->Visible = false;
	}
	else
	{
		OKBitBtn->Visible = true;
	}
}
//---------------------------------------------------------------------------

void __fastcall TProductInputForm::DataEditButtonClick(TObject* Sender)
{
	if (MessageDlgFA(PRODUCTINPUTFORM_MSG_19, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
	{
		ProductInputMode = PIM_EDIT;
		UpdateEditableComponents();

		OldColorCode = TempProductData.TabletColorCode;
	}
}
//---------------------------------------------------------------------------


void __fastcall TProductInputForm::PrintColorCodeEditClick(TObject* Sender)
{
	TColorCodeForm* colorCodeForm = new TColorCodeForm(this);
	if (colorCodeForm->ShowModal() == mrOk)
	{
		TempProductData.PrintColorCode = colorCodeForm->GetColorCodeName();
		PrintColorCodeEdit->Text = TempProductData.PrintColorCode;
		PrintColorShape->Brush->Color = GetColorByCode(TempProductData.PrintColorCode);
	}
	delete colorCodeForm;
}
//---------------------------------------------------------------------------

void __fastcall TProductInputForm::TabletColorCodeEditClick(
	TObject* Sender)
{
	TColorCodeForm* colorCodeForm = new TColorCodeForm(this);
	if (colorCodeForm->ShowModal() == mrOk)
	{
		TempProductData.TabletColorCode = colorCodeForm->GetColorCodeName();
		RefreshTabletColor();
	}
	delete colorCodeForm;
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::DataDeleteButtonClick(TObject* Sender)
{
	if (MessageDlgFA(PRODUCTINPUTFORM_MSG_13, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
	{
		TInputTextDialog* inputTextDialog = new TInputTextDialog(this);
		if (inputTextDialog->ExecutePassword())
		{
			AnsiString passwordStr = inputTextDialog->InputText;
			if (CheckPassword(UserInfo.Name, passwordStr))
			{
				// delete data
				ProductInputMode = PIM_NONE;
				UpdateEditableComponents();
				TabletInfoPanel->Visible = false;
				RemoveProduct(TempProductData.ProductCode);
				DeleteFromLookupTable(TempProductData.ProductCode);
				AddCSVActionLog(ECSV_ACTION_PRODUCT_DELETE, UserInfo.Name, TempProductData.ProductName, NULL, 0);
			}
			else
			{
				ShowMessageFA(PRODUCTINPUTFORM_MSG_06);
			}
		}
		delete inputTextDialog;
	}
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::RemoveProduct(WideString productCode)
{
	// remove folder
	AnsiString productFolderName = ProgramPath.Product + "\\" + productCode;
	RemoveWholeDir(productFolderName);
	AnsiString productNozzLogFolderName = ProgramPath.Root + "\\HCB Monitoring\\" + productCode;
	RemoveWholeDir(productNozzLogFolderName);
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::RemoveWholeDir(AnsiString folderName)
{
	TSearchRec sr;
	int iAttributes = faAnyFile;
	if (FindFirst(folderName + "\\*.*", iAttributes, sr) == 0)
	{
		do
		{
			if (sr.Name == "." || sr.Name == "..") continue;
			if (sr.Attr & faDirectory)
			{
				RemoveWholeDir(folderName + "\\" + sr.Name);
			}
			else
			{
				//                if (MessageDlgFA(folderName + "\\" + sr.Name + "   ϰڽϱ?", mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
				{
					DeleteFile(folderName + "\\" + sr.Name);
				}
			}

		} while (FindNext(sr) == 0);
		FindClose(sr);
		//        if (MessageDlgFA(folderName + "   ϰڽϱ?", mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
		{
			RemoveDir(folderName);
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::UpdateInspectionResult(void)
{
	/*
		InspectionReportStringGrid->Cells[0][0] = "LOT";
		//    InspectionReportStringGrid->Cells[1][0] = "˻";
		InspectionReportStringGrid->Cells[1][0] = "˻  ð";
		InspectionReportStringGrid->Cells[2][0] = "˻  ð";
		InspectionReportStringGrid->Cells[3][0] = "˻ ";
		InspectionReportStringGrid->Cells[4][0] = "ǰ ";
		InspectionReportStringGrid->Cells[5][0] = "ҷ ";
		InspectionReportStringGrid->Cells[6][0] = "";
		InspectionReportStringGrid->Cells[7][0] = "ֺҷ 1";
		InspectionReportStringGrid->Cells[8][0] = "ֺҷ 2";
		InspectionReportStringGrid->Cells[9][0] = "ֺҷ 3";
		InspectionReportStringGrid->ColWidths[1] = 200;
		InspectionReportStringGrid->ColWidths[2] = 200;

		// make inspection result list
		TSearchRec sr;
		int iAttributes = faAnyFile;

		InspectionReportList.clear();
		AnsiString resultDir = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\Result";
		if (FindFirst(resultDir + "\\*.dat", iAttributes, sr) == 0)
		{
		do
		{
		AnsiString inspectionReportFileName = resultDir + "\\" + sr.Name;
		TFileStream *fileStream = new TFileStream(inspectionReportFileName, fmOpenRead);
		TTabletInspectReport tabletInspectReport;
		fileStream->Read(&tabletInspectReport, sizeof(TTabletInspectReport));
		delete fileStream;
		} while (FindNext(sr) == 0);
		FindClose(sr);
		}



		//	inspectionReportFileName = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\Result" + "\\" + ProductData.LOTName + ".dat";
		*/








}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::UpdateTabletImage(void)
{
	AnsiString frontImageFileName, sideImageFileName;
	switch (TempProductData.TabletShape)
	{
	case TABLET_SHAPE_CIRCLE:
		frontImageFileName = "Round_Front.bmp";
		sideImageFileName = "Round_Side.bmp";
		break;
	case TABLET_SHAPE_OBLONG:
		frontImageFileName = "Oblong_Front.bmp";
		sideImageFileName = "Oblong_Side.bmp";
		break;
	case TABLET_SHAPE_OVAL:
		frontImageFileName = "Oval_Front.bmp";
		sideImageFileName = "Oval_Side.bmp";
		break;
	case TABLET_SHAPE_HEXAGON:
		frontImageFileName = "Hexagon_Front.bmp";
		sideImageFileName = "Hexagon_Side.bmp";
		break;
	case TABLET_SHAPE_TRIANGLE:
		frontImageFileName = "Triangle_Front.bmp";
		sideImageFileName = "Triangle_Side.bmp";
		break;
	case TABLET_SHAPE_SQUARE:
		frontImageFileName = "Square_Front.bmp";
		sideImageFileName = "Square_Side.bmp";
		break;
	case TABLET_SHAPE_OCTAGON:
		frontImageFileName = "Octagon_Front.bmp";
		sideImageFileName = "Octagon_Side.bmp";
		break;
	default:
		frontImageFileName = "";
		sideImageFileName = "";
		break;

	}


	if (DefaultLCID == 1042 || DefaultLCID == 2066)
	{
		if (frontImageFileName == "" || !FileExists(ProgramPath.Env + "\\" + frontImageFileName))
		{
			TabletFrontImage->Picture->Bitmap->Canvas->Brush->Color = clBlack;
			TabletFrontImage->Picture->Bitmap->Canvas->Brush->Style = bsSolid;
			TabletFrontImage->Picture->Bitmap->Canvas->FillRect(Rect(0, 0, TabletFrontImage->Picture->Bitmap->Width, TabletFrontImage->Picture->Bitmap->Height));
		}
		else
		{
			TabletFrontImage->Picture->Bitmap->LoadFromFile(ProgramPath.Env + "\\" + frontImageFileName);
		}
		if (sideImageFileName == "" || !FileExists(ProgramPath.Env + "\\" + sideImageFileName))
		{
			TabletSideImage->Picture->Bitmap->Canvas->Brush->Color = clBlack;
			TabletSideImage->Picture->Bitmap->Canvas->Brush->Style = bsSolid;
			TabletSideImage->Picture->Bitmap->Canvas->FillRect(Rect(0, 0, TabletSideImage->Picture->Bitmap->Width, TabletSideImage->Picture->Bitmap->Height));
		}
		else
		{
			TabletSideImage->Picture->Bitmap->LoadFromFile(ProgramPath.Env + "\\" + sideImageFileName);
		}
	}
	else if (DefaultLCID == 1033)
	{
		if (frontImageFileName == "" || !FileExists(ProgramPath.Env + "\\" + "En\\" + frontImageFileName))
		{
			TabletFrontImage->Picture->Bitmap->Canvas->Brush->Color = clBlack;
			TabletFrontImage->Picture->Bitmap->Canvas->Brush->Style = bsSolid;
			TabletFrontImage->Picture->Bitmap->Canvas->FillRect(Rect(0, 0, TabletFrontImage->Picture->Bitmap->Width, TabletFrontImage->Picture->Bitmap->Height));
		}
		else
		{
			TabletFrontImage->Picture->Bitmap->LoadFromFile(ProgramPath.Env + "\\" + "En\\" + frontImageFileName);
		}
		if (sideImageFileName == "" || !FileExists(ProgramPath.Env + "\\" + sideImageFileName))
		{
			TabletSideImage->Picture->Bitmap->Canvas->Brush->Color = clBlack;
			TabletSideImage->Picture->Bitmap->Canvas->Brush->Style = bsSolid;
			TabletSideImage->Picture->Bitmap->Canvas->FillRect(Rect(0, 0, TabletSideImage->Picture->Bitmap->Width, TabletSideImage->Picture->Bitmap->Height));
		}
		else
		{
			TabletSideImage->Picture->Bitmap->LoadFromFile(ProgramPath.Env + "\\" + "En\\" + sideImageFileName);
		}
	}
	else if (DefaultLCID == 1041)
	{
		if (frontImageFileName == "" || !FileExists(ProgramPath.Env + "\\" + "Jp\\" + frontImageFileName))
		{
			TabletFrontImage->Picture->Bitmap->Canvas->Brush->Color = clBlack;
			TabletFrontImage->Picture->Bitmap->Canvas->Brush->Style = bsSolid;
			TabletFrontImage->Picture->Bitmap->Canvas->FillRect(Rect(0, 0, TabletFrontImage->Picture->Bitmap->Width, TabletFrontImage->Picture->Bitmap->Height));
		}
		else
		{
			TabletFrontImage->Picture->Bitmap->LoadFromFile(ProgramPath.Env + "\\" + "Jp\\" + frontImageFileName);
		}
		if (sideImageFileName == "" || !FileExists(ProgramPath.Env + "\\" + sideImageFileName))
		{
			TabletSideImage->Picture->Bitmap->Canvas->Brush->Color = clBlack;
			TabletSideImage->Picture->Bitmap->Canvas->Brush->Style = bsSolid;
			TabletSideImage->Picture->Bitmap->Canvas->FillRect(Rect(0, 0, TabletSideImage->Picture->Bitmap->Width, TabletSideImage->Picture->Bitmap->Height));
		}
		else
		{
			TabletSideImage->Picture->Bitmap->LoadFromFile(ProgramPath.Env + "\\" + "Jp\\" + sideImageFileName);
		}
	}
	else if (DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
	{
		if (frontImageFileName == "" || !FileExists(ProgramPath.Env + "\\" + frontImageFileName))
		{
			TabletFrontImage->Picture->Bitmap->Canvas->Brush->Color = clBlack;
			TabletFrontImage->Picture->Bitmap->Canvas->Brush->Style = bsSolid;
			TabletFrontImage->Picture->Bitmap->Canvas->FillRect(Rect(0, 0, TabletFrontImage->Picture->Bitmap->Width, TabletFrontImage->Picture->Bitmap->Height));
		}
		else
		{
			TabletFrontImage->Picture->Bitmap->LoadFromFile(ProgramPath.Env + "\\" + "Ch\\" + frontImageFileName);
		}
		if (sideImageFileName == "" || !FileExists(ProgramPath.Env + "\\" + "Ch\\" + sideImageFileName))
		{
			TabletSideImage->Picture->Bitmap->Canvas->Brush->Color = clBlack;
			TabletSideImage->Picture->Bitmap->Canvas->Brush->Style = bsSolid;
			TabletSideImage->Picture->Bitmap->Canvas->FillRect(Rect(0, 0, TabletSideImage->Picture->Bitmap->Width, TabletSideImage->Picture->Bitmap->Height));
		}
		else
		{
			TabletSideImage->Picture->Bitmap->LoadFromFile(ProgramPath.Env + "\\" + "Ch\\" + sideImageFileName);
		}
	}
	else if (DefaultLCID == 3082)
	{
		if (frontImageFileName == "" || !FileExists(ProgramPath.Env + "\\" + frontImageFileName))
		{
			TabletFrontImage->Picture->Bitmap->Canvas->Brush->Color = clBlack;
			TabletFrontImage->Picture->Bitmap->Canvas->Brush->Style = bsSolid;
			TabletFrontImage->Picture->Bitmap->Canvas->FillRect(Rect(0, 0, TabletFrontImage->Picture->Bitmap->Width, TabletFrontImage->Picture->Bitmap->Height));
		}
		else
		{
			TabletFrontImage->Picture->Bitmap->LoadFromFile(ProgramPath.Env + "\\" + "Sp\\" + frontImageFileName);
		}
		if (sideImageFileName == "" || !FileExists(ProgramPath.Env + "\\" + "Sp\\" + sideImageFileName))
		{
			TabletSideImage->Picture->Bitmap->Canvas->Brush->Color = clBlack;
			TabletSideImage->Picture->Bitmap->Canvas->Brush->Style = bsSolid;
			TabletSideImage->Picture->Bitmap->Canvas->FillRect(Rect(0, 0, TabletSideImage->Picture->Bitmap->Width, TabletSideImage->Picture->Bitmap->Height));
		}
		else
		{
			TabletSideImage->Picture->Bitmap->LoadFromFile(ProgramPath.Env + "\\" + "Sp\\" + sideImageFileName);
		}
	}

}
//---------------------------------------------------------------------------

void __fastcall TProductInputForm::PrintBrightnessPanelClick(TObject* Sender)
{
	TTntPanel* thePanel = (TTntPanel*)Sender;
	switch (thePanel->Tag)
	{
	case 0:
		TempProductData.PrintBrightness = PRINT_BRIGHTNESS_LIGHT;
		break;
	case 1:
		TempProductData.PrintBrightness = PRINT_BRIGHTNESS_DARK;
		break;
	default:
		TempProductData.EngraveType = PRINT_BRIGHTNESS_UNKNOWN;
		break;
	}

	RefreshPrintBrightnessSelectionMenu();
}
//---------------------------------------------------------------------------

void __fastcall TProductInputForm::RenameButtonClick(TObject* Sender)
{
	TInputTextDialog* inputTextDialog = new TInputTextDialog(this);
	AnsiString oldProductCode = TempProductData.ProductCode;
	inputTextDialog->Message = PRODUCTINPUTFORM_MSG_09;
	if (inputTextDialog->Execute())
	{
		AnsiString newProductCode = inputTextDialog->InputText;
		AnsiString activeProductCode = ProductData.ProductCode;

		AnsiString tempString;

		if (oldProductCode == activeProductCode)
		{
			if (DefaultLCID == 1042)
				tempString = "ش ǰ Ȱȭ Ǿ Ƿ  ۾ Ϸ  ϴ. Ȱ·   ٽ õϽʽÿ.";
			else
				tempString = "This action can not be completed because the product information is enabled. Please change it to inactive state and try again.";

			ShowMessage(tempString);
			return;
		}

		// Rename data
		try
		{
			int newNameLength;
			newNameLength = newProductCode.Length();

			if (newProductCode == "")
			{
				if (DefaultLCID == 1042)
					tempString = "ǰ Էֽʽÿ.";
				else
					tempString = "Product name is not entered.";

				throw Exception(tempString);
			}
			else if (newProductCode[1] == ' ' || newProductCode[newNameLength] == ' ')
			{
				if (DefaultLCID == 1042)
					tempString = "ǰ ù Ȥ  ڿ  ԵǾֽϴ.";
				else
					tempString = "Product name first letter and last letter can not use a space.";

				throw Exception(tempString);
			}
			else if (newProductCode.Length() > PRODUCT_NAME_LENGTH_LIMIT)
			{
				throw Exception("Product Name is Too long.");
			}
			else if (newProductCode.AnsiPos("/") != 0 ||
				newProductCode.AnsiPos("\\") != 0 ||
				newProductCode.AnsiPos("*") != 0 ||
				newProductCode.AnsiPos("?") != 0 ||
				newProductCode.AnsiPos(":") != 0 ||
				newProductCode.AnsiPos("\"") != 0 ||
				newProductCode.AnsiPos("|") != 0 ||
				newProductCode.AnsiPos("<") != 0 ||
				newProductCode.AnsiPos(">") != 0 ||
				newProductCode.AnsiPos("[") != 0 ||
				newProductCode.AnsiPos("]") != 0)
			{
				if (DefaultLCID == 1042)
					tempString = "ǰ /, \\, *,,:?, \ , |, <,>, [,]  Է  ϴ.";
				else
					tempString = "Product name /, \\, *,,:?, \ , |, <,>, [,] is not available.";

				throw Exception(tempString);
			}

			if (DefaultLCID == 1042)
				tempString = "ǰ   ϴ.";
			else
				tempString = "Product name can not be changed.";

			AnsiString productFolderName = ProgramPath.Product + "\\" + oldProductCode;
			AnsiString newProductFolderName = ProgramPath.Product + "\\" + newProductCode;
			if (!RenameFile(productFolderName, newProductFolderName))throw Exception(tempString);

			TProductData tempProductData;
			AnsiString productFileName = newProductFolderName + "\\" + oldProductCode + ".dat";
			ReadProductData(productFileName, tempProductData, MachineParams, MachineSetupData);
			tempProductData.ProductName = newProductCode;
			tempProductData.ProductCode = newProductCode;
			WriteProductData(productFileName, tempProductData);
			TCSVRenameActionLogData csvRenameActionLogData;
			strncpy(csvRenameActionLogData.OldName, oldProductCode.c_str(), 64);
			strncpy(csvRenameActionLogData.NewName, newProductCode.c_str(), 64);
			AddCSVActionLog(ECSV_ACTION_PRODUCT_RENAME, UserInfo.Name, newProductCode, (unsigned char*)&csvRenameActionLogData, sizeof(csvRenameActionLogData));


			TSearchRec sr;
			int iAttributes = faAnyFile;

			if (FindFirst(newProductFolderName + "\\" + oldProductCode + ".*", iAttributes, sr) == 0)
			{
				do
				{
					AnsiString oldFileName = sr.Name;
					AnsiString newFileName = newProductCode + oldFileName.SubString(oldProductCode.Length() + 1, oldFileName.Length());
					if (!RenameFile(newProductFolderName + "\\" + oldFileName, newProductFolderName + "\\" + newFileName)) throw Exception(tempString);

				} while (FindNext(sr) == 0);
				FindClose(sr);
			}

			AnsiString oldDefectFolderName = GetDefectDataPath(oldProductCode);
			AnsiString newDefectFolderName = GetDefectDataPath(newProductCode);
			RenameFile(oldDefectFolderName, newDefectFolderName); // ص ׳ 

			DeleteFromLookupTable(oldProductCode);
			UpdateLookupTable(newProductCode);

			ShowMessageFA(PRODUCTINPUTFORM_MSG_05);
			if (LoadProductData(newProductCode))
			{
				ProductInputMode = PIM_EXIST;
				RefreshProductData();
				UpdateEditableComponents();
			}
		}
		catch (Exception& ec)
		{
			ShowMessageFA(ec.Message);
		}
	}
	delete inputTextDialog;
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::SaveAsButtonClick(TObject* Sender)
{
	TInputTextDialog* inputTextDialog = new TInputTextDialog(this);
	AnsiString oldProductCode = TempProductData.ProductCode;
	inputTextDialog->Message = PRODUCTINPUTFORM_MSG_09;
	if (inputTextDialog->Execute())
	{
		AnsiString newProductCode = inputTextDialog->InputText;
		// Rename data
		if (newProductCode.Length() > PRODUCT_NAME_LENGTH_LIMIT)
		{
			ShowMessage("Product Name is Too long.");
			return;
		}
		if (MakeCloneProduct(newProductCode, oldProductCode))
		{
			UpdateLookupTable(newProductCode);
			ShowMessageFA(PRODUCTINPUTFORM_MSG_10);
			if (LoadProductData(newProductCode))
			{
				ProductInputMode = PIM_EXIST;
				RefreshProductData();
				UpdateEditableComponents();
			}
		}
		/*
		try
		{
		AnsiString productFolderName = ProgramPath.Product + "\\" + oldProductCode;
		AnsiString newProductFolderName = ProgramPath.Product + "\\" + newProductCode;
		if (!CreateDir(newProductFolderName)) throw Exception("Can Not Create A New Data.");
		TSearchRec sr;
		int iAttributes = faAnyFile;

		CopyDir(newProductFolderName, productFolderName);

		if (FindFirst(newProductFolderName + "\\" + oldProductCode + ".*", iAttributes, sr) == 0)
		{
		do
		{
		AnsiString oldFileName = sr.Name;
		AnsiString newFileName = newProductCode + oldFileName.SubString(oldProductCode.Length() + 1, oldFileName.Length());
		if (!RenameFile(newProductFolderName + "\\" + oldFileName, newProductFolderName + "\\" + newFileName)) throw Exception("Name Can Not Be Changed.");

		} while (FindNext(sr) == 0);
		FindClose(sr);
		}

		TProductData tempProductData;
		AnsiString productFileName = newProductFolderName + "\\" + newProductCode + ".dat";
		ReadProductData(productFileName, tempProductData, MachineParams);
		tempProductData.ProductName = newProductCode;
		tempProductData.ProductCode = newProductCode;
		tempProductData.ProcessingStep = TABLET_PROCESSING_STEP_CALIBRATION_REQUIRED;
		WriteProductData(productFileName, tempProductData);

		ShowMessageFA(" ϷǾϴ.");
		if (LoadProductData(newProductCode))
		{
		ProductInputMode = PIM_EXIST;
		RefreshProductData();
		UpdateEditableComponents();
		}
		}
		catch(Exception &ec)
		{
		ShowMessageFA(ec.Message);
		}
		*/
	}
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::CopyDir(AnsiString destDir, AnsiString srcDir)
{
	TSearchRec sr;
	int iAttributes = faAnyFile;
	CreateDir(destDir);
	if (FindFirst(srcDir + "\\*.*", iAttributes, sr) == 0)
	{
		do
		{
			if (sr.Name == "." || sr.Name == "..") continue;
			if ((sr.Attr & faDirectory))
			{
				//	            CopyDir(destDir + "\\" + sr.Name, srcDir + "\\" + sr.Name);		// sub dir copy  
			}
			else
			{
				AnsiString sourceFileName = srcDir + "\\" + sr.Name;
				AnsiString destFileName = destDir + "\\" + sr.Name;
				CopyFileA(sourceFileName.c_str(), destFileName.c_str(), FALSE);
			}
		} while (FindNext(sr) == 0);
		FindClose(sr);
	}
}
//---------------------------------------------------------------------------
bool __fastcall TProductInputForm::MakeCloneProduct(WideString newProductCode, WideString oldProductCode)
{
	bool returnValue = true;
	AnsiString productFolderName = ProgramPath.Product + "\\" + oldProductCode;
	AnsiString newProductFolderName = ProgramPath.Product + "\\" + newProductCode;
	try
	{
		if (!CreateDir(newProductFolderName)) throw Exception("Can Not Create A New Data.");
		TSearchRec sr;
		int iAttributes = faAnyFile;

		if (FindFirst(productFolderName + "\\" + oldProductCode + ".*", iAttributes, sr) == 0)
		{
			do
			{
				char file_ext[50];
				_splitpath(sr.Name.c_str(), NULL, NULL, NULL, file_ext);
				AnsiString AnsiExt = AnsiString(file_ext);
				AnsiString oldFileName = productFolderName + "\\" + sr.Name;
				AnsiString newFileName = newProductFolderName + "\\" + newProductCode + AnsiExt;
				CopyFileA(oldFileName.c_str(), newFileName.c_str(), FALSE);
			} while (FindNext(sr) == 0);
			FindClose(sr);
		}

		TProductData tempProductData;
		AnsiString productFileName = newProductFolderName + "\\" + newProductCode + ".dat";
		ReadProductData(productFileName, tempProductData, MachineParams, MachineSetupData);
		tempProductData.ProductName = newProductCode;
		tempProductData.ProductCode = newProductCode;
		tempProductData.ProcessingStep = TABLET_PROCESSING_STEP_CALIBRATION_REQUIRED;
		tempProductData.LastInspectionTime.Val = 0;
		WriteProductData(productFileName, tempProductData);

		TCSVRenameActionLogData csvRenameActionLogData;

		char ProductName_old[64] = { 0, };
		char ProductName_new[64] = { 0, };
		WideCharToMultiByte(CP_ACP, 0, oldProductCode.c_bstr(), -1, ProductName_old, 64, NULL, NULL);
		WideCharToMultiByte(CP_ACP, 0, newProductCode.c_bstr(), -1, ProductName_new, 64, NULL, NULL);


		strncpy(csvRenameActionLogData.OldName, ProductName_old, 64);
		strncpy(csvRenameActionLogData.NewName, ProductName_new, 64);
		AddCSVActionLog(ECSV_ACTION_PRODUCT_CLONE, UserInfo.Name, newProductCode, (unsigned char*)&csvRenameActionLogData, sizeof(csvRenameActionLogData));
	}
	catch (Exception& ec)
	{
		returnValue = false;
		ShowMessageFA(ec.Message);
	}
	return returnValue;
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::TabletColorShapeMouseUp(TObject* Sender,
	TMouseButton Button, TShiftState Shift, int X, int Y)
{
	TColorCodeForm* colorCodeForm = new TColorCodeForm(this);
	if (colorCodeForm->ShowModal() == mrOk)
	{
		TempProductData.TabletColorCode = colorCodeForm->GetColorCodeName();
		RefreshTabletColor();
	}
	delete colorCodeForm;
}
//---------------------------------------------------------------------------

void __fastcall TProductInputForm::PlateTabletPanelClick(TObject* Sender)
{
	TTntPanel* thePanel = (TTntPanel*)Sender;
	switch (thePanel->Tag)
	{
	case 0:
		TempProductData.PlateTablet = false;
		break;
	case 1:
		TempProductData.PlateTablet = true;
		break;
	default:
		TempProductData.PlateTablet = false;
		break;
	}
	RefreshPlateSelectionMenu();
}
//---------------------------------------------------------------------------


void __fastcall TProductInputForm::TabletLayerCountEditClick(
	TObject* Sender)
{
	TTntEdit* theEdit = (TTntEdit*)Sender;



	KeyboardForm->Text = theEdit->Text;
	if (KeyboardForm->ShowKeypad() == mrOk)
	{
		if (StrToInt(KeyboardForm->Text) < 2 || StrToInt(KeyboardForm->Text) > 3)
		{
			ShowMessageFA(PRODUCTINPUTFORM_MSG_01);
		}
		else
		{
			theEdit->Text = KeyboardForm->Text;
			TempProductData.TabletLayerCount = StrToInt(TabletLayerCountEdit->Text);
			RefreshTypeSelectionMenu();
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::RefreshTabletColor(void)
{
	if (TempProductData.TabletType != TABLET_TYPE_MULTI_LAYERED)
	{
		TabletColorCodeEdit->Text = TempProductData.TabletColorCode;
		//		TabletColorShape->Brush->Color = GetColorByCode(TempProductData.TabletColorCode);
		TabletColorImage->Canvas->Brush->Style = bsSolid;
		TabletColorImage->Canvas->Brush->Color = GetColorByCode(TempProductData.TabletColorCode);
		TabletColorImage->Canvas->FillRect(Rect(0, 0, TabletColorImage->Width, TabletColorImage->Height));
	}
	else
	{
		TabletColorCodeEdit->Text = "Multiple";
		TabletColorImage->Canvas->Brush->Style = bsSolid;
		TabletColorImage->Canvas->Brush->Color = ((TTntPanel*)TabletColorImage->Parent)->Color;
		TabletColorImage->Canvas->FillRect(Rect(0, 0, TabletColorImage->Width, TabletColorImage->Height));

		for (int layerIndex = 0; layerIndex < TempProductData.TabletLayerCount; layerIndex++)
		{
			TabletColorImage->Canvas->Brush->Color = TempProductData.MultiLayeredTabletColor[layerIndex];
			TabletColorImage->Canvas->FillRect(
				Rect(layerIndex * (TabletColorImage->Width / TempProductData.TabletLayerCount) + 1,
					1,
					(layerIndex + 1) * (TabletColorImage->Width / TempProductData.TabletLayerCount) - 1,
					TabletColorImage->Height - 1));
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::TabletColorImageMouseDown(
	TObject* Sender, TMouseButton Button, TShiftState Shift, int X,
	int Y)
{
	if (TempProductData.TabletType != TABLET_TYPE_MULTI_LAYERED)
	{
		TColorCodeForm* colorCodeForm = new TColorCodeForm(this);
		if (colorCodeForm->ShowModal() == mrOk)
		{
			TempProductData.TabletColorCode = colorCodeForm->GetColorCodeName();
			RefreshTabletColor();
		}
		delete colorCodeForm;
	}
	else
	{
		int layerIndex = X / (TabletColorImage->Width / TempProductData.TabletLayerCount);
		TColorCodeForm* colorCodeForm = new TColorCodeForm(this);
		if (colorCodeForm->ShowModal() == mrOk)
		{
			TempProductData.MultiLayeredTabletColor[layerIndex] = GetColorByCode(colorCodeForm->GetColorCodeName());
			RefreshTabletColor();
		}
		delete colorCodeForm;
	}
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::OnUserChange(void)
{
	if (ProgramAccessAuthorityData.ProgramAccessAuthorityTable[UserInfo.AccessLevel][ACCESS_PGM_EVT_MAINFORM_PRODUCT_INFO])
	{
		UpdateEditableComponents();
	}
	else
	{
		this->Close();
	}
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::RefreshETCInputMenu(void)
{
	if (TempProductData.TabletShape == TABLET_SHAPE_ETC)
	{
		ETCInfoGroupBox->Visible = true;
	}
	else
	{
		ETCInfoGroupBox->Visible = false;
	}

	if (TempProductData.Arrange)
	{
		ETCTabletArrangePanel->Color = clBlue;
		ETCTabletArrangePanel->Font->Color = clWhite;
		ETCTabletArrangePanel->Font->Style = ETCTabletArrangePanel->Font->Style << fsBold;

		ETCTabletNotArrangePanel->Color = clWhite;
		ETCTabletNotArrangePanel->Font->Color = clBlack;
		ETCTabletNotArrangePanel->Font->Style = ETCTabletArrangePanel->Font->Style >> fsBold;

		ETCTabletSymmetricLinePanel1->Enabled = true;
		ETCTabletSymmetricLinePanel2->Enabled = true;

		if (TempProductData.SymmetricLineCount == 1)
		{
			ETCTabletSymmetricLinePanel1->Color = clBlue;
			ETCTabletSymmetricLinePanel1->Font->Color = clWhite;
			ETCTabletSymmetricLinePanel1->Font->Style = ETCTabletSymmetricLinePanel1->Font->Style << fsBold;

			ETCTabletSymmetricLinePanel2->Color = clWhite;
			ETCTabletSymmetricLinePanel2->Font->Color = clBlack;
			ETCTabletSymmetricLinePanel2->Font->Style = ETCTabletSymmetricLinePanel2->Font->Style >> fsBold;

			ETCTabletSymmetricLinePanel3->Color = clWhite;
			ETCTabletSymmetricLinePanel3->Font->Color = clBlack;
			ETCTabletSymmetricLinePanel3->Font->Style = ETCTabletSymmetricLinePanel1->Font->Style >> fsBold;
		}
		else if (TempProductData.SymmetricLineCount == 2)
		{
			ETCTabletSymmetricLinePanel2->Color = clBlue;
			ETCTabletSymmetricLinePanel2->Font->Color = clWhite;
			ETCTabletSymmetricLinePanel2->Font->Style = ETCTabletArrangePanel->Font->Style << fsBold;

			ETCTabletSymmetricLinePanel1->Color = clWhite;
			ETCTabletSymmetricLinePanel1->Font->Color = clBlack;
			ETCTabletSymmetricLinePanel1->Font->Style = ETCTabletSymmetricLinePanel1->Font->Style >> fsBold;

			ETCTabletSymmetricLinePanel3->Color = clWhite;
			ETCTabletSymmetricLinePanel3->Font->Color = clBlack;
			ETCTabletSymmetricLinePanel3->Font->Style = ETCTabletSymmetricLinePanel1->Font->Style >> fsBold;
		}
		else if (TempProductData.SymmetricLineCount == 3)
		{
			ETCTabletSymmetricLinePanel3->Color = clBlue;
			ETCTabletSymmetricLinePanel3->Font->Color = clWhite;
			ETCTabletSymmetricLinePanel3->Font->Style = ETCTabletArrangePanel->Font->Style << fsBold;

			ETCTabletSymmetricLinePanel1->Color = clWhite;
			ETCTabletSymmetricLinePanel1->Font->Color = clBlack;
			ETCTabletSymmetricLinePanel1->Font->Style = ETCTabletSymmetricLinePanel1->Font->Style >> fsBold;

			ETCTabletSymmetricLinePanel2->Color = clWhite;
			ETCTabletSymmetricLinePanel2->Font->Color = clBlack;
			ETCTabletSymmetricLinePanel2->Font->Style = ETCTabletSymmetricLinePanel1->Font->Style >> fsBold;
		}
	}
	else
	{
		ETCTabletNotArrangePanel->Color = clBlue;
		ETCTabletNotArrangePanel->Font->Color = clWhite;
		ETCTabletNotArrangePanel->Font->Style = ETCTabletArrangePanel->Font->Style << fsBold;

		ETCTabletArrangePanel->Color = clWhite;
		ETCTabletArrangePanel->Font->Color = clBlack;
		ETCTabletArrangePanel->Font->Style = ETCTabletArrangePanel->Font->Style >> fsBold;

		if (TempProductData.TabletShape == TABLET_SHAPE_ETC)
		{
			ETCTabletSymmetricLinePanel1->Enabled = false;
			ETCTabletSymmetricLinePanel2->Enabled = false;

			if (TempProductData.SymmetricLineCount >= 1 && TempProductData.SymmetricLineCount < 3)
			{
				TempProductData.SymmetricLineCount = 3;
			}

			ETCTabletSymmetricLinePanel3->Color = clBlue;
			ETCTabletSymmetricLinePanel3->Font->Color = clWhite;
			ETCTabletSymmetricLinePanel3->Font->Style = ETCTabletArrangePanel->Font->Style << fsBold;

			ETCTabletSymmetricLinePanel1->Color = clGray;
			ETCTabletSymmetricLinePanel1->Font->Color = clBlack;
			ETCTabletSymmetricLinePanel1->Font->Style = ETCTabletSymmetricLinePanel1->Font->Style >> fsBold;

			ETCTabletSymmetricLinePanel2->Color = clGray;
			ETCTabletSymmetricLinePanel2->Font->Color = clBlack;
			ETCTabletSymmetricLinePanel2->Font->Style = ETCTabletSymmetricLinePanel1->Font->Style >> fsBold;
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TProductInputForm::TabletArrangePanelClick(
	TObject* Sender)
{
	TTntPanel* thePanel = (TTntPanel*)Sender;
	switch (thePanel->Tag)
	{
	case 0:
		TempProductData.Arrange = true;
		break;
	case 1:
		TempProductData.Arrange = false;
		break;
	default:
		TempProductData.Arrange = true;
		break;
	}
	RefreshETCInputMenu();
}
//---------------------------------------------------------------------------

void __fastcall TProductInputForm::TabletSymmetricLinePanelClick(TObject* Sender)
{
	TTntPanel* thePanel = (TTntPanel*)Sender;
	TempProductData.SymmetricLineCount = thePanel->Tag;
	RefreshETCInputMenu();
}
//---------------------------------------------------------------------------

void __fastcall TProductInputForm::PrintColorShapeMouseDown(
	TObject* Sender, TMouseButton Button, TShiftState Shift, int X,
	int Y)
{
	TColorCodeForm* colorCodeForm = new TColorCodeForm(this);
	if (colorCodeForm->ShowModal() == mrOk)
	{
		TempProductData.PrintColorCode = colorCodeForm->GetColorCodeName();
		PrintColorCodeEdit->Text = TempProductData.PrintColorCode;
		PrintColorShape->Brush->Color = GetColorByCode(TempProductData.PrintColorCode);
	}
	delete colorCodeForm;
}
//---------------------------------------------------------------------------

void __fastcall TProductInputForm::WriteDefaultEjectInformation()
{

	try
	{
		AnsiString fileName;
		int EjectMode;
		int BlowInterval;
		int BlowStart;
		int BlowLength;
		int UnInsBlowCheck;

		fileName = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\EjectInformation.ini";

		if (!FileExists(fileName))
		{
			TIniFile* iniFile = new TIniFile(fileName);
			if (iniFile)
			{
				EjectMode = MachineSetupData.EjectorInfo.EjectorDefaultMode; //EJECT_SPECIAL_MODE; 
				BlowStart = 0;
				BlowLength = 0;
				BlowInterval = 0;
				UnInsBlowCheck = 0;

				iniFile->WriteInteger("EjectInformation", "Mode", EjectMode);
				iniFile->WriteInteger("EjectInformation", "Interval", BlowInterval);
				iniFile->WriteInteger("EjectInformation", "Start", BlowStart);
				iniFile->WriteInteger("EjectInformation", "Length", BlowLength);
				iniFile->WriteInteger("EjectInformation", "UnInspection Blow", UnInsBlowCheck);
				delete iniFile;
			}
		}
	}
	catch (...)
	{

	}
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::PrintButtonClick(TObject* Sender)
{
	HWND hWnd = GetConsoleWindow();
	ShowWindow(hWnd, SW_HIDE);
	Sleep(1000);

	int x1, y1, x2, y2, w, h;

	x1 = GetSystemMetrics(SM_XVIRTUALSCREEN);
	y1 = GetSystemMetrics(SM_YVIRTUALSCREEN);
	x2 = GetSystemMetrics(SM_CXVIRTUALSCREEN);
	y2 = GetSystemMetrics(SM_CYVIRTUALSCREEN);

	w = x2 - x1;
	h = y2 - y1;

	HDC hScreen = GetDC(NULL);
	HDC hDC = CreateCompatibleDC(hScreen);
	HBITMAP hBitmap = CreateCompatibleBitmap(hScreen, w, h);
	HGDIOBJ old_obj = SelectObject(hDC, hBitmap);
	BOOL bRet = BitBlt(hDC, 0, 0, w, h, hScreen, x1, y1, SRCCOPY);

	OpenClipboard(NULL);
	EmptyClipboard();
	SetClipboardData(CF_BITMAP, hBitmap);

	CloseClipboard();

	HPALETTE hpal = NULL;
	AnsiString fname = "PRINT_BITMAP_FILE.bmp";
	saveBitmap(fname.c_str(), hBitmap, hpal);

	system("PRINT_BITMAP_FILE.bmp");
}



/*
# include <OleCtl.h>

typedef struct tagPICTDESC {
	UINT  cbSizeofstruct;
	UINT  picType;
	union {
		struct {
			HBITMAP  hbitmap;
			HPALETTE hpal;
		} bmp;
		struct {
			HMETAFILE hmeta;
			int       xExt;
			int       yExt;
		} wmf;
		struct {
			HICON hicon;
		} icon;
		struct {
			HENHMETAFILE hemf;
		} emf;
	};
} PICTDESC, *LPPICTDESC;

public class Ole {
						public const int PICTYPE_UNINITIALIZED = -1;
						public const int PICTYPE_NONE          =  0;
						public const int PICTYPE_BITMAP        =  1;
						public const int PICTYPE_METAFILE      =  2;
						public const int PICTYPE_ICON          =  3;
						public const int PICTYPE_ENHMETAFILE   =  4;
						public const int STATFLAG_DEFAULT = 0;
						public const int STATFLAG_NONAME = 1;
				}      */



bool TProductInputForm::saveBitmap(LPCSTR filename, HBITMAP bmp, HPALETTE pal)
{
	bool result = false;
	PICTDESC pd;

	pd.cbSizeofstruct = sizeof(PICTDESC);
	pd.picType = 1;
	pd.bmp.hbitmap = bmp;
	pd.bmp.hpal = pal;

	LPPICTURE picture;
	HRESULT res = OleCreatePictureIndirect(&pd, IID_IPicture, false,
		reinterpret_cast<void**>(&picture));

	if (!SUCCEEDED(res))
		return false;

	LPSTREAM stream;
	res = CreateStreamOnHGlobal(0, true, &stream);

	if (!SUCCEEDED(res))
	{
		picture->Release();
		return false;
	}

	LONG bytes_streamed;
	res = picture->SaveAsFile(stream, true, &bytes_streamed);

	HANDLE file = CreateFileA(filename, GENERIC_WRITE, FILE_SHARE_READ, 0,
		CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0);

	if (!SUCCEEDED(res) || !file)
	{
		stream->Release();
		picture->Release();
		return false;
	}

	HGLOBAL mem = 0;
	GetHGlobalFromStream(stream, &mem);
	LPVOID data = GlobalLock(mem);

	DWORD bytes_written;

	result = !!WriteFile(file, data, bytes_streamed, &bytes_written, 0);
	result &= (bytes_written == static_cast<DWORD>(bytes_streamed));

	GlobalUnlock(mem);
	CloseHandle(file);

	stream->Release();
	picture->Release();

	return result;
}

//---------------------------------------------------------------------------
void __fastcall TProductInputForm::RefreshDivisionLineInfoMenu(void)
{
	if (TempProductData.EngraveType != ENGRAVE_TYPE_UNKNOWN && TempProductData.EngraveType != ENGRAVE_TYPE_EMPTY)
	{
		DivisionLineInfoGroupBox->Visible = true;
	}
	else
	{
		DivisionLineInfoGroupBox->Visible = false;
	}
}

//---------------------------------------------------------------------------
void __fastcall TProductInputForm::RefreshSubDivisionLineInfoMenu(void)
{
	for (int typeIndex = 0; typeIndex < 3; typeIndex++)
	{
		TTntPanel* typePanel = (TTntPanel*)FindComponent("DivisionLineSelectionPanel" + IntToStr(typeIndex + 1));
		typePanel->Color = clWhite;
		typePanel->Font->Color = clBlack;
		typePanel->Font->Style = typePanel->Font->Style >> fsBold;
	}

	TTntPanel* selectedPanel = NULL;
	switch (TempProductData.DivisionLineInfo)
	{
	case DIVISION_LINE_NONE:
		selectedPanel = DivisionLineSelectionPanel1;
		break;
	case DIVISION_LINE_ONE_SIDE:
		selectedPanel = DivisionLineSelectionPanel2;
		break;
	case DIVISION_LINE_BOTH_SIDE:
		selectedPanel = DivisionLineSelectionPanel3;
		break;
	default:
		selectedPanel = NULL;
		break;
	}
	if (selectedPanel)
	{
		selectedPanel->Color = clBlue;
		selectedPanel->Font->Color = clWhite;
		selectedPanel->Font->Style = selectedPanel->Font->Style << fsBold;
	}
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::DivisionLineSelectionPanel1Click(
	TObject* Sender)
{
	TTntPanel* thePanel = (TTntPanel*)Sender;
	switch (thePanel->Tag)
	{
	case 0:
		TempProductData.DivisionLineInfo = DIVISION_LINE_NONE;
		break;
	case 1:
		TempProductData.DivisionLineInfo = DIVISION_LINE_ONE_SIDE;
		break;
	case 2:
		TempProductData.DivisionLineInfo = DIVISION_LINE_BOTH_SIDE;
		break;
	default:
		TempProductData.DivisionLineInfo = DIVISION_LINE_NONE;
		break;
	}

	RefreshSubDivisionLineInfoMenu();
}
//---------------------------------------------------------------------------

void __fastcall TProductInputForm::SmallResolPanelClick(TObject* Sender)
{
	TTntPanel* thePanel = (TTntPanel*)Sender;

	if (TempProductData.TabletType == TABLET_TYPE_SUGAR_COATED)
	{
		if (thePanel->Tag == 1)
		{
			ShowMessage(PRODUCTINPUTFORM_MSG_28);

			TempProductData.SubSamplingMode = RESOLUTION_NORMAL_QUALITY;
			RefreshResolutionMenu();
			return;
		}
	}

	switch (thePanel->Tag)
	{
	case 0:
		TempProductData.SubSamplingMode = RESOLUTION_NORMAL_QUALITY;
		break;
	case 1:
		TempProductData.SubSamplingMode = RESOLUTION_HIGH_QUALITY;
		break;
	default:
		TempProductData.SubSamplingMode = RESOLUTION_NORMAL_QUALITY;
		break;
	}

	RefreshResolutionMenu();
}

void __fastcall TProductInputForm::RefreshResolutionMenu(void)
{
	if (TempProductData.SubSamplingMode == RESOLUTION_NORMAL_QUALITY)
	{
		SmallResolPanel->Color = clBlue;
		SmallResolPanel->Font->Color = clWhite;
		SmallResolPanel->Font->Style = SmallResolPanel->Font->Style << fsBold;
		LargeResolPanel->Color = clWhite;
		LargeResolPanel->Font->Color = clBlack;
		LargeResolPanel->Font->Style = LargeResolPanel->Font->Style >> fsBold;
	}
	else
	{
		LargeResolPanel->Color = clBlue;
		LargeResolPanel->Font->Color = clWhite;
		LargeResolPanel->Font->Style = LargeResolPanel->Font->Style << fsBold;
		SmallResolPanel->Color = clWhite;
		SmallResolPanel->Font->Color = clBlack;
		SmallResolPanel->Font->Style = SmallResolPanel->Font->Style >> fsBold;
	}

	if (SubSamplingModeModifyCheck)
	{
		if (LastSelectSubSamplingMode != TempProductData.SubSamplingMode)
		{
			ShowMessageFA(PRODUCTINPUTFORM_LABEL_CAPTION_13);
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TProductInputForm::RecipeSelectChange(TObject* Sender)
{
	AnsiString filePath = "D:\\Project\\sLaser\\Res\\Resource\\" + RecipeSelect->Text + ".bmp";
	UpdateRecipeImage(filePath);
}
//---------------------------------------------------------------------------

void __fastcall TProductInputForm::UpdateRecipeImage(AnsiString filePath)
{
	if (FileExists(filePath))
	{
		Graphics::TBitmap* tempImage = new Graphics::TBitmap;
		tempImage->LoadFromFile(filePath);
		tempImage->PixelFormat = pf24bit;

		int minX, maxX, minY, maxY;
		minX = tempImage->Width;
		maxX = 0;
		minY = tempImage->Height;
		maxY = 0;

		unsigned char* ImageBuffer = new unsigned char[tempImage->Width * tempImage->Height * 3];
		memset(ImageBuffer, 0, tempImage->Width * tempImage->Height * 3);

		for (int y = 10; y < tempImage->Height - 10; y++)
		{
			Byte* ptr = (Byte*)tempImage->ScanLine[y];
			for (int x = 10; x < tempImage->Width - 10; x++)
			{
				if (ptr[3 * x + 1])
				{
					if (minX > x) minX = x;
					if (maxX < x) maxX = x;
					if (minY > y) minY = y;
					if (maxY < y) maxY = y;
				}

				int tempAddress = y * tempImage->Width + x;
				ImageBuffer[tempAddress * 3 + 0] = ptr[3 * x + 0];
				ImageBuffer[tempAddress * 3 + 1] = ptr[3 * x + 1];
				ImageBuffer[tempAddress * 3 + 2] = ptr[3 * x + 2];
			}
		}

		if (maxX != 0 && maxY != 0)
		{
			int realWidth = maxX - minX;
			int realHeight = maxY - minY;

			Graphics::TBitmap* tempImage2 = new Graphics::TBitmap;
			tempImage2->Width = realWidth;
			tempImage2->Height = realHeight;
			tempImage2->PixelFormat = pf24bit;

			for (int y = 0; y < realHeight; y++)
			{
				Byte* ptr = (Byte*)tempImage2->ScanLine[y];
				for (int x = 0; x < realWidth; x++)
				{
					int tempAddress = (y + minY) * tempImage->Width + (x + minX);

					ptr[3 * x + 0] = ImageBuffer[tempAddress * 3 + 0];
					ptr[3 * x + 1] = ImageBuffer[tempAddress * 3 + 1];
					ptr[3 * x + 2] = ImageBuffer[tempAddress * 3 + 2];
				}
			}

			if (realWidth > RECIPE_IMAGE_SIZE || realHeight > RECIPE_IMAGE_SIZE)
			{
				if (realWidth > realHeight)
				{
					RecipeImage->Width = RECIPE_IMAGE_SIZE;
					RecipeImage->Height = RECIPE_IMAGE_SIZE * realHeight / realWidth;

					RecipeImage->Top = 24 + RECIPE_IMAGE_SIZE / 2 - RecipeImage->Height / 2;
					RecipeImage->Left = 16;
				}
				else
				{
					RecipeImage->Width = RECIPE_IMAGE_SIZE * realWidth / realHeight;
					RecipeImage->Height = RECIPE_IMAGE_SIZE;

					RecipeImage->Top = 24;
					RecipeImage->Left = 16 + RECIPE_IMAGE_SIZE / 2 - RecipeImage->Width / 2;
				}
			}
			else
			{
				RecipeImage->Width = realWidth;
				RecipeImage->Height = realHeight;

				RecipeImage->Top = 24 + RECIPE_IMAGE_SIZE / 2 - RecipeImage->Height / 2;
				RecipeImage->Left = 16 + RECIPE_IMAGE_SIZE / 2 - RecipeImage->Width / 2;
			}

			RecipeImage->Picture->Bitmap->Width = RecipeImage->Width;
			RecipeImage->Picture->Bitmap->Height = RecipeImage->Height;
			RecipeImage->Picture->Bitmap->PixelFormat = pf24bit;

			HDC srcDC = tempImage2->Canvas->Handle;
			HDC dstDC = RecipeImage->Canvas->Handle;

			SetStretchBltMode(dstDC, HALFTONE);
			StretchBlt(dstDC, 0, 0, RecipeImage->Width, RecipeImage->Height, srcDC, 0, 0, tempImage2->Width, tempImage2->Height, SRCCOPY);

			RecipeImage->Refresh();

			delete tempImage2;
		}

		delete[] ImageBuffer;
		delete tempImage;
	}
}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::MakeMESProductDat()
{
	char Temp[128] = { 0, };
	char Temp2[128] = { 0, };
	char Temp3[128] = { 0, };
	WideCharToMultiByte(CP_ACP, 0, ProductData.ProductCode.c_bstr(), -1, Temp, 128, NULL, NULL);
	WideCharToMultiByte(CP_ACP, 0, ProductData.ProductName.c_bstr(), -1, Temp2, 128, NULL, NULL);
	WideCharToMultiByte(CP_ACP, 0, ProductData.LOTName.c_bstr(), -1, Temp3, 128, NULL, NULL);
	strncpy(MESProductData.ProductCode, Temp, 128);
	strncpy(MESProductData.ProductName, Temp2, 128);
	strncpy(MESProductData.LOTName, Temp3, 128);
	strncpy(MESProductData.TabletColorCode, ProductData.TabletColorCode.c_str(), 128);
	strncpy(MESProductData.PrintColorCode, ProductData.PrintColorCode.c_str(), 128);

	MESProductData.TabletType = ProductData.TabletType;
	MESProductData.TabletShape = ProductData.TabletShape;
	MESProductData.StudyStep = ProductData.StudyStep;
	MESProductData.TabletLength = ProductData.TabletLength;
	MESProductData.TabletWidth = ProductData.TabletWidth;
	MESProductData.TabletThick = ProductData.TabletThick;
	MESProductData.TabletSideThick = ProductData.TabletSideThick;
	MESProductData.EngraveType = ProductData.EngraveType;
	MESProductData.EngravePos = ProductData.EngravePos;
	MESProductData.PrintBrightness = ProductData.PrintBrightness;

	for (int i = 0; i < SYSTEM_TOTAL_CAMERA_COUNT; i++)
	{
		MESProductData.BoundaryLeft[i] = ProductData.BoundaryLeft[i];
		MESProductData.BoundaryTop[i] = ProductData.BoundaryTop[i];
		MESProductData.BoundaryRight[i] = ProductData.BoundaryRight[i];
		MESProductData.BoundaryBottom[i] = ProductData.BoundaryBottom[i];
		MESProductData.ShutterSpeed[i] = ProductData.ShutterSpeed[i];
		MESProductData.DigitalGainV[i] = ProductData.DigitalGainV[i];
		MESProductData.LineScanFrequency[i] = 0;
	}

	MESProductData.ProcessingStep = ProductData.ProcessingStep;
	memcpy(MESProductData.MotorSpeedList, ProductData.MotorSpeedList, sizeof(ProductData.MotorSpeedList));
	MESProductData.ProductionCount = ProductData.ProductionCount;
	MESProductData.PlateTablet = ProductData.PlateTablet;
	MESProductData.TabletLayerCount = ProductData.TabletLayerCount;

	MESProductData.StudiedSensor1Length = ProductData.StudiedSensor1Length;
	MESProductData.StudiedSensor2Length = ProductData.StudiedSensor2Length;
	MESProductData.StudiedSensorIntervalA = ProductData.StudiedSensorIntervalA;
	MESProductData.StudiedSensorIntervalB = ProductData.StudiedSensorIntervalB;

	MESProductData.NCMotorPos[0] = ProductData.NCMotorPos[0];
	MESProductData.NCMotorPos[1] = ProductData.NCMotorPos[1];
	MESProductData.NCMotorPos[2] = ProductData.NCMotorPos[2];
	MESProductData.NCMotorPos[3] = ProductData.NCMotorPos[3];
	MESProductData.NCMotorPos[4] = ProductData.NCMotorPos[4];

	MESProductData.RotatingGuideKind = ProductData.RotatingGuideKind;
	MESProductData.FixedGuideKind = ProductData.FixedGuideKind;
	MESProductData.VerticalGate2Kind = ProductData.VerticalGate2Kind;
	MESProductData.Arrange = ProductData.Arrange;
	MESProductData.SymmetricLineCount = ProductData.SymmetricLineCount;
	MESProductData.LampKind = ProductData.LampKind;
	MESProductData.SpecialInsCount[0] = ProductData.SpecialInsCount[0];
	MESProductData.SpecialInsCount[1] = ProductData.SpecialInsCount[1];
	MESProductData.SpecialInsCount[2] = ProductData.SpecialInsCount[2];
	MESProductData.SpecialInsCount[3] = ProductData.SpecialInsCount[3];
	MESProductData.SpecialInsCount[4] = ProductData.SpecialInsCount[4];
	MESProductData.SpecialInsCount[5] = ProductData.SpecialInsCount[5];
	MESProductData.SpecialInsCheckbox = ProductData.SpecialInsCheckbox;

	MESProductData.MarvelingTabletSW = ProductData.MarvelingTabletSW;
	//sjm add
	MESProductData.StudiedSensor3Length = ProductData.StudiedSensor3Length;
	MESProductData.DivisionLineInfo = ProductData.DivisionLineInfo;
	MESProductData.SubSamplingMode = ProductData.SubSamplingMode;

	MESProductData.ExposureTime3D[0] = ProductData.ExposureTime3D[0];
	MESProductData.AnalogGain3D[0] = ProductData.AnalogGain3D[0];
	MESProductData.ExposureTime3D[1] = ProductData.ExposureTime3D[1];
	MESProductData.AnalogGain3D[1] = ProductData.AnalogGain3D[1];

	MESProductData.DischargeCountSetValue = ProductData.DischargeCountSetValue;
	MESProductData.DischargeCount = ProductData.DischargeCount;

}
//---------------------------------------------------------------------------
void __fastcall TProductInputForm::TntFormActivate(TObject* Sender)
{
	SetScreenPosition(this);
}
//---------------------------------------------------------------------------
