//---------------------------------------------------------------------------

#ifndef ProductInput_FormH
#define ProductInput_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Buttons.hpp>
#include <ExtCtrls.hpp>

#include "Environment.h"
#include "ProductSearch_Form.h"
#include <Grids.hpp>
#include "TntButtons.hpp"
#include "TntExtCtrls.hpp"
#include "TntGrids.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
#include <Dialogs.hpp>
//---------------------------------------------------------------------------
#define MAX_PRODUCT_NAME_SIZE		64

#define RECIPE_IMAGE_SIZE    200

//---------------------------------------------------------------------------
typedef struct
{
	AnsiString LOTName;
} TInspectionResultUnit;
//---------------------------------------------------------------------------
typedef enum {PIM_NONE, PIM_NEW, PIM_EXIST, PIM_EDIT} EProductInputMode;


class TProductInputForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *TopEditPanel;
	TTntLabel *Label2;
	TTntEdit *ProductNameEdit;
	TTntPanel *UpperEditPanel;
	TTntGroupBox *GroupBox9;
	TTntGroupBox *GroupBox2;
	TTntGroupBox *GroupBox1;
	TTntLabel *TabletLengthLabel;
	TTntLabel *TabletWidthLabel;
	TTntLabel *TabletThickLabel;
	TTntLabel *TabletSideThickLabel;
	TTntEdit *TabletLengthEdit;
	TTntEdit *TabletWidthEdit;
	TTntEdit *TabletThickEdit;
	TTntEdit *TabletSideThickEdit;
	TTntGroupBox *GroupBox3;
	TTntGroupBox *GroupBox8;
	TTntLabel *Label8;
	TTntEdit *TabletColorCodeEdit;
	TTntPanel *Panel4;
	TTntPanel *TopMenuPanel;
	TTntButton *NewTabletButton;
	TTntButton *ExsistTabletButton;
	TTntPanel *TabletInfoPanel;
	TTntPanel *TabletSearchPanel;
	TTntPanel *TabletTypePanel1;
	TTntPanel *TabletTypePanel2;
	TTntPanel *TabletTypePanel3;
	TTntPanel *TabletShapePanel1;
	TTntPanel *TabletShapePanel2;
	TTntPanel *TabletShapePanel3;
	TTntPanel *TabletShapePanel4;
	TTntPanel *InspectionRecordPanel;
	TTntPanel *Panel7;
	TTntPanel *Panel8;
	TTntPanel *Panel9;
	TTntPanel *Panel1;
	TTntBitBtn *OKBitBtn;
	TTntBitBtn *CancelBitBtn;
	TTntButton *DataEditButton;
	TTntButton *DataDeleteButton;
	TTntPanel *TabletShapePanel5;
	TTntPanel *TabletImagePanel;
	TTntImage *TabletFrontImage;
	TTntImage *TabletSideImage;
	TTntButton *SaveAsButton;
	TTntButton *RenameButton;
	TTntPanel *TabletShapePanel8;
	TTntStringGrid *InspectionReportStringGrid;
	TTntPanel *RightEditPanel;
    TTntPanel *Panel2;
	TTntPanel *Panel3;
	TTntPanel *LowerEditPanel;
	TTntGroupBox *GroupBox10;
	TTntGroupBox *GroupBox4;
	TTntPanel *EngraveTypePanel1;
	TTntPanel *EngraveTypePanel3;
	TTntPanel *EngraveTypePanel4;
	TTntPanel *EngraveTypePanel2;
	TTntGroupBox *GroupBox5;
	TTntPanel *EngravePosPanel2;
	TTntPanel *EngravePosPanel1;
	TTntPanel *EngravePosPanel3;
	TTntGroupBox *GroupBox6;
	TTntPanel *LightPrintPanel;
	TTntPanel *DarkPrintPanel;
	TTntGroupBox *GroupBox7;
	TTntLabel *PrintColorCodeLabel;
	TTntShape *PrintColorShape;
	TTntEdit *PrintColorCodeEdit;
	TTntGroupBox *GroupBox11;
	TTntPanel *PlateTabletPanel1;
	TTntPanel *PlateTabletPanel2;
	TTntPanel *TabletTypePanel4;
	TTntImage *TabletColorImage;
	TTntPanel *MultiLayeredTabletPanel;
	TTntLabel *Label1;
	TTntEdit *TabletLayerCountEdit;
	TTntGroupBox *ETCInfoGroupBox;
	TTntPanel *ETCTabletArrangePanel;
	TTntPanel *ETCTabletNotArrangePanel;
	TTntPanel *ETCTabletSymmetricLinePanel1;
	TTntPanel *ETCTabletSymmetricLinePanel2;
	TTntPanel *TabletShapePanel6;
	TTntPanel *TabletShapePanel7;
  TPanel *Panel5;
  TTntPanel *ETCTabletSymmetricLinePanel3;
  TCheckBox *MarvelingTabletCheckBox;
  TTntButton *PrintButton;
  TTntGroupBox *DivisionLineInfoGroupBox;
  TTntPanel *DivisionLineSelectionPanel2;
  TTntPanel *DivisionLineSelectionPanel1;
  TTntPanel *DivisionLineSelectionPanel3;
  TTntGroupBox *TntGroupBox1;
  TTntPanel *SmallResolPanel;
  TTntPanel *LargeResolPanel;
  TGroupBox *RecipeSelectBox;
  TTntComboBox *RecipeSelect;
        TGroupBox *RecipeImageBox;
        TTntImage *RecipeImage;
	TCheckBox *FatTabletCaptureCheckBox1;
	TCheckBox *CurvedSurfaceTabletCheckBox;
	void __fastcall OKBitBtnClick(TObject *Sender);
	void __fastcall ProductTextEditClick(TObject *Sender);
	void __fastcall ProductNumEditClick(TObject *Sender);
	void __fastcall NewTabletButtonClick(TObject *Sender);
	void __fastcall ExsistTabletButtonClick(TObject *Sender);
	void __fastcall FormDestroy(TObject *Sender);
	void __fastcall TabletTypePanelClick(TObject *Sender);
	void __fastcall TabletShapePanelClick(TObject *Sender);
	void __fastcall EngraveTypePanelClick(TObject *Sender);
	void __fastcall EngravePosPanelClick(TObject *Sender);
	void __fastcall DataEditButtonClick(TObject *Sender);
	void __fastcall PrintColorCodeEditClick(TObject *Sender);
	void __fastcall TabletColorCodeEditClick(TObject *Sender);
	void __fastcall DataDeleteButtonClick(TObject *Sender);
	void __fastcall PrintBrightnessPanelClick(TObject *Sender);
	void __fastcall RenameButtonClick(TObject *Sender);
	void __fastcall SaveAsButtonClick(TObject *Sender);
	void __fastcall TabletColorShapeMouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall PlateTabletPanelClick(TObject *Sender);
	void __fastcall TabletLayerCountEditClick(TObject *Sender);
	void __fastcall TabletColorImageMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall TabletArrangePanelClick(TObject *Sender);
	void __fastcall TabletSymmetricLinePanelClick(TObject *Sender);
	void __fastcall PrintColorShapeMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall PrintButtonClick(TObject *Sender);
  void __fastcall DivisionLineSelectionPanel1Click(TObject *Sender);
  void __fastcall SmallResolPanelClick(TObject *Sender);
        void __fastcall RecipeSelectChange(TObject *Sender);
  void __fastcall TntFormActivate(TObject *Sender);
private:	// User declarations
	TProductData TempProductData;
    TProductSearchForm *SubProductSearchForm;
	EProductInputMode ProductInputMode;

    void __fastcall GetDefaultString();

      AnsiString OldColorCode;
    AnsiString NewColorCode;

    void __fastcall RefreshSizeInputMenu(void);
    void __fastcall RefreshPrintingInputMenu(void);
    void __fastcall ClearTabletInfo(void);
    void __fastcall ProductSearchOKClick(TObject *Sender);
    void __fastcall ProductSearchCancelClick(TObject *Sender);
    bool __fastcall LoadProductData(WideString productCode);
    void __fastcall RefreshTypeSelectionMenu(void);
    void __fastcall RefreshShapeSelectionMenu(void);
    void __fastcall RefreshEngraveTypeSelectionMenu(void);
    void __fastcall RefreshEngravePosSelectionMenu(void);
    void __fastcall RefreshPrintBrightnessSelectionMenu(void);
    void __fastcall RefreshPlateSelectionMenu(void);
    void __fastcall RefreshProductData(void);
    void __fastcall UpdateEditableComponents(void);
    void __fastcall UpdateInspectionResult(void);
    void __fastcall UpdateTabletImage(void);
    void __fastcall RemoveProduct(WideString productCode);
    void __fastcall RemoveWholeDir(AnsiString folderName);
    bool __fastcall MakeCloneProduct(WideString newProductCode, WideString oldProductCode);
    void __fastcall CopyDir(AnsiString destDir, AnsiString srcDir);
    void __fastcall RefreshTabletColor(void);
    void __fastcall RefreshETCInputMenu(void);
    void __fastcall WriteDefaultEjectInformation(void);
    void __fastcall RefreshDivisionLineInfoMenu(void);
    void __fastcall RefreshSubDivisionLineInfoMenu(void);
    void __fastcall RefreshResolutionMenu(void);
    void __fastcall RefreshRecipeSelectMenu(void);
    void __fastcall UpdateRecipeImage(AnsiString filePath);
    bool saveBitmap(LPCSTR filename, HBITMAP bmp, HPALETTE pal);
    bool SubSamplingModeModifyCheck;
    int LastSelectSubSamplingMode;
public:		// User declarations
	__fastcall TProductInputForm(TComponent* Owner);
	void __fastcall OnUserChange(void);
        void __fastcall MakeMESProductDat();

  int ProductSettingMode;
  WideString ErrorMsg[20];
};
//---------------------------------------------------------------------------
extern PACKAGE TProductInputForm *ProductInputForm;
//---------------------------------------------------------------------------
#endif
