//---------------------------------------------------------------------------

#ifndef ProductSearch_FormH
#define ProductSearch_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Grids.hpp>
#include <Buttons.hpp>
#include <ExtCtrls.hpp>
#include <vector.h>
#include "TntButtons.hpp"
#include "TntExtCtrls.hpp"
#include "TntGrids.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
//---------------------------------------------------------------------------
typedef enum {NOT_SORT, SORT_BY_NAME, SORT_BY_KIND, SORT_BY_SHAPE, SORT_BY_SIZE, SORT_BY_INSP_TIME} ESortBy;
//---------------------------------------------------------------------------
typedef struct
{
  WideString Name;
  int TabletKind;
  int TabletShape;
  double TabletSize;
  double LastInspectionTime;
  bool newTabletUnit;
} TTabletListUnit;
//---------------------------------------------------------------------------
class TProductSearchForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *Panel1;
	TTntPanel *Panel2;
	TTntPanel *Panel3;
	TTntBitBtn *CancelBitBtn;
	TTntBitBtn *OkBitBtn;
	TTntPanel *Panel4;
	TTntGroupBox *GroupBox1;
	TTntPanel *SortByNamePanel;
	TTntPanel *SortByKindPanel;
	TTntPanel *SortByShapePanel;
	TTntPanel *SortBySizePanel;
	TTntPanel *SortByInspTimePanel;
	TTntGroupBox *ScrollGroupBox;
	TTntImage *ScrollImage;
	TTntPanel *TabletImagePanel;
	TTntImage *TabletTopImage;
	TTntImage *TabletBottomImage;
	TTimer *ScrollTimer;
	TTntPanel *Panel5;
	TTntStringGrid *ProductListStringGrid;
	TTntPanel *Panel6;
	TTntLabel *Label1;
	TTntEdit *TabletNameEdit;
	TTntButton *SearchButton;
	void __fastcall OkBitBtnClick(TObject *Sender);
	void __fastcall CancelBitBtnClick(TObject *Sender);
	void __fastcall ScrollImageMouseDown(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
	void __fastcall ScrollImageMouseMove(TObject *Sender, TShiftState Shift,
          int X, int Y);
	void __fastcall ScrollImageMouseUp(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
	void __fastcall ScrollImageDblClick(TObject *Sender);
	void __fastcall ProductListStringGridSelectCell(TObject *Sender, int ACol,
          int ARow, bool &CanSelect);
	void __fastcall ScrollTimerTimer(TObject *Sender);
	void __fastcall SortByNamePanelClick(TObject *Sender);
	void __fastcall SortByKindPanelClick(TObject *Sender);
	void __fastcall SortByShapePanelClick(TObject *Sender);
	void __fastcall SortBySizePanelClick(TObject *Sender);
	void __fastcall TabletNameEditClick(TObject *Sender);
	void __fastcall SearchButtonClick(TObject *Sender);
    void __fastcall SortByInspTimePanelClick(TObject *Sender);
    void __fastcall DiscReSearchButtonClick(TObject *Sender);
  void __fastcall TntFormActivate(TObject *Sender);
private:	// User declarations
	TNotifyEvent FOnClickOK;
    TNotifyEvent FOnClickCancel;

    vector<TTabletListUnit> TotalTabletList;        // ϴ ü tablet list
    vector<TTabletListUnit> TabletList;             // ˻ tablet list

    TPoint ScrollImageMouseDownPos;
    TPoint ScrollImageMouseMovePos;
    bool IsScrollImageMouseDown;
    int StringGridMouseDownPos;
    unsigned int LastScrollTime;

    ESortBy SortBy;
	bool SortAscendingOrder;
    void __fastcall DiscSearch(void);
    void __fastcall SaveTabletLookupTable(void);
    void __fastcall LoadTabletLookupTable(void);

    void __fastcall ArrangeProductList(void);
    void __fastcall RefreshSelectedTablet(int row);

    void __fastcall ClearSortingComponent(void);
	void __fastcall SortByName_Ascending(void);
	void __fastcall SortByName_Descending(void);
	void __fastcall SortByKind_Ascending(void);
	void __fastcall SortByKind_Descending(void);
	void __fastcall SortByShape_Ascending(void);
	void __fastcall SortByShape_Descending(void);
	void __fastcall SortBySize_Ascending(void);
	void __fastcall SortBySize_Descending(void);
	void __fastcall SortByInspTime_Ascending(void);
	void __fastcall SortByInspTime_Descending(void);
  void __fastcall GetDefaultString();
public:		// User declarations
	__fastcall TProductSearchForm(TComponent* Owner);

    void __fastcall RefreshProductList(void);
    void __fastcall Search(WideString codeStr);
    WideString __fastcall GetSelectedProductCode(void);
    __property TNotifyEvent OnClickOK = {read = FOnClickOK, write = FOnClickOK};
    __property TNotifyEvent OnClickCancel = {read = FOnClickCancel, write = FOnClickCancel};
    WideString TabletSelectName;
};
//---------------------------------------------------------------------------
extern PACKAGE TProductSearchForm *ProductSearchForm;
extern void __fastcall UpdateLookupTable(WideString productCode);
extern void __fastcall DeleteFromLookupTable(WideString productCode);
//---------------------------------------------------------------------------
#endif
