//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop


//---------------------------------------------------------------------------
#pragma package(smart_init)

#include "RS232PC.h"

RS232PC::RS232PC()
{
  m_hComm = NULL;
}  
  
RS232PC::~RS232PC()  
{
}
  
bool RS232PC::OpenPort(String portname)
{
    m_hComm = CreateFileA(portname.c_str(),
            GENERIC_READ | GENERIC_WRITE,  
            0,  
            0,  
            OPEN_EXISTING,
            0,
            0);

        if(m_hComm == INVALID_HANDLE_VALUE)
        {
            return false;
        }  
        else
        {
          DWORD dwEvtMask=EV_RXCHAR | EV_BREAK | EV_ERR | EV_RING | EV_RXFLAG | EV_TXEMPTY;
          SetCommMask(m_hComm,dwEvtMask);
          SetupComm(m_hComm, 300, 300 );

          PurgeComm(m_hComm, PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR );
          return true;
          
        }

}  
  
bool RS232PC::ConfigurePort(DWORD BaudRate, BYTE ByteSize, DWORD fParity,
        BYTE Parity, BYTE StopBits)  
{  
    if((m_bPortReady = GetCommState(m_hComm, &m_dcb))==0)
    {
      if(m_hComm != NULL)
      {
        CloseHandle(m_hComm);
        m_hComm = NULL;
      }

      return false;
    }  
  
    m_dcb.BaudRate          = BaudRate;  
    m_dcb.ByteSize          = ByteSize;  
    m_dcb.Parity            = Parity ;  
    m_dcb.StopBits          = StopBits;  
    m_dcb.fBinary           = true;  
    m_dcb.fDsrSensitivity   = false;  
    m_dcb.fParity           = fParity;  
    m_dcb.fOutX             = false;  
    m_dcb.fInX              = false;  
    m_dcb.fNull             = false;  
    m_dcb.fAbortOnError     = true;  
    m_dcb.fOutxCtsFlow      = false;  
    m_dcb.fOutxDsrFlow      = false;  
    m_dcb.fDtrControl       = DTR_CONTROL_DISABLE;
    m_dcb.fDsrSensitivity   = false;  
    m_dcb.fRtsControl       = DTR_CONTROL_DISABLE;
    m_dcb.fOutxCtsFlow      = false;  
    m_dcb.fOutxCtsFlow      = false;
    m_dcb.DCBlength = sizeof(m_dcb);
    m_dcb.XoffChar = ! m_dcb.XonChar;
  
    m_bPortReady = SetCommState(m_hComm, &m_dcb);  
  
    if(m_bPortReady == 0)  
    {
        if(m_hComm != NULL)
        {
          CloseHandle(m_hComm);
          m_hComm = NULL;
        }
        return false;
    }  
  
    return true;
}  
  
bool RS232PC::SetCommunicationTimeouts(DWORD ReadIntervalTimeout,
        DWORD ReadTotalTimeoutMultiplier, DWORD ReadTotalTimeoutConstant,  
        DWORD WriteTotalTimeoutMultiplier, DWORD WriteTotalTimeoutConstant)  
{  
    if((m_bPortReady = GetCommTimeouts(m_hComm, &m_CommTimeouts)) == 0)  
        return false;  
  
    m_CommTimeouts.ReadIntervalTimeout          = ReadIntervalTimeout;  
    m_CommTimeouts.ReadTotalTimeoutConstant     = ReadTotalTimeoutConstant;  
    m_CommTimeouts.ReadTotalTimeoutMultiplier   = ReadTotalTimeoutMultiplier;  
    m_CommTimeouts.WriteTotalTimeoutConstant    = WriteTotalTimeoutConstant;  
    m_CommTimeouts.WriteTotalTimeoutMultiplier  = WriteTotalTimeoutMultiplier;  
      
    m_bPortReady = SetCommTimeouts(m_hComm, &m_CommTimeouts);  
          
    if(m_bPortReady == 0)  
    {
        if(m_hComm != NULL)
        {
          CloseHandle(m_hComm);
          m_hComm = NULL;
        }
        return false;
    }  
  
    return true;  
}

String CommPortName="";
 

void RS232PC::UpdateComName()
{

}

int __fastcall RS232PC::_FindCommPortReg(String* NameList , int& Count)
{
  HKEY hKey;
  LONG Result;
  char lpValue[10];
  DWORD dwType, dwByte;
  const char* Path = "HARDWARE\\DEVICEMAP\\SERIALCOMM";
  int nCount = 0;
  // Ʈ 
  Result = RegOpenKeyExA(HKEY_LOCAL_MACHINE,
              Path,
              0, KEY_ALL_ACCESS, &hKey);

  /*Result = RegOpenKey(HKEY_LOCAL_MACHINE,
  TEXT("HARDWARE\\DEVICEMAP\\SERIALCOMM"),&hKey);*/
              
  TCHAR szData[20], szName[100];
  DWORD index = 0, dwSize=100, dwSize2 = 20;
  memset(szData, 0x00, sizeof(szData));
  memset(szName, 0x00, sizeof(szName));
  
  if(Result == ERROR_SUCCESS)
  {
    for(int i = 0; i < 30; ++i)
    {
      if(ERROR_SUCCESS == RegEnumValue(hKey, i, szName, &dwSize, NULL, NULL, NULL, NULL))
      {
        Result = RegQueryValueEx(hKey, szName, 0, &dwType, (LPBYTE)szData, &dwSize2);
        String name = szName;
        String Data = szData;
        String Temp = "\\Device\\VCP";
        if(Result == ERROR_SUCCESS)
        {
          NameList[nCount] = Data;
          nCount++;
        }

        /*if(Result == ERROR_SUCCESS && Temp == name.SubString(0,name.Length()-1))
        {
          NameList[nCount] = Data;
          nCount++;
        }*/


        memset(szData, 0x00, sizeof(szData));
        memset(szName, 0x00, sizeof(szName));
        dwSize=100, dwSize2 = 20;
      }
    }
    Count = nCount;
    return 1;
  }

  return 0;
}

bool RS232PC::WriteByte(BYTE bybyte)
{  
    m_iBytesWritten=0;  
    if(WriteFile(m_hComm, &bybyte, 1, &m_iBytesWritten, NULL) == 0)  
        return false;  
    else  
        return true;  
}

bool RS232PC::WriteByte(BYTE* &resp, UINT size)
{
    m_iBytesWritten=0;  
    if(WriteFile(m_hComm, resp, size, &m_iBytesWritten, NULL) == 0)
        return false;
    else  
        return true;  
}
  
bool RS232PC::ReadByte(BYTE &resp)
{  
    BYTE rx;  
    resp=0;  
  
    DWORD dwBytesTransferred=0;  
  
    if(ReadFile(m_hComm, &rx, 1, &dwBytesTransferred, 0))  
    {  
        if(dwBytesTransferred == 1)  
        {  
            resp=rx;
            return true;
        }
    }
    return false;
}  
  
bool RS232PC::ReadByte(BYTE* &resp, UINT size)
{  
    DWORD dwBytesTransferred=0;
    OVERLAPPED overlapped;

    if(ReadFile(m_hComm,resp,size,&dwBytesTransferred,0))
    {
        if(dwBytesTransferred == size)
        {
          return true;
        }
    }

   return false;
}  
  
void RS232PC::ClosePort()
{
    if(m_hComm != NULL)
    {
      CloseHandle(m_hComm);
    }
    m_hComm = NULL;
}

void RS232PC::ClearBuff()
{
  PurgeComm(m_hComm, PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR );
}
void RS232PC::RXClearBuff()
{
  PurgeComm(m_hComm,  PURGE_RXABORT | PURGE_RXCLEAR );
}

