//---------------------------------------------------------------------------

#ifndef RS232PCH
#define RS232PCH
//---------------------------------------------------------------------------
class RS232PC
{
	public:  
    RS232PC(void);
    virtual ~RS232PC(void);  
  
private:  
    HANDLE  m_hComm;  
    DCB     m_dcb;  
    COMMTIMEOUTS m_CommTimeouts;  
    bool    m_bPortReady;  
    bool    m_bWriteRC;  
    bool    m_bReadRC;  
    DWORD   m_iBytesWritten;  
    DWORD   m_iBytesRead;  
    DWORD   m_dwBytesRead;  
  
public:
    bool State; // 0: Close , 1: Open 
    void ClosePort();  
    bool ReadByte(BYTE &resp);
    bool ReadByte(BYTE* &resp, UINT size);  
    bool WriteByte(BYTE bybyte);
    bool WriteByte(BYTE* &resp, UINT size);  
    bool OpenPort(String portname);  
    bool SetCommunicationTimeouts(DWORD ReadIntervalTimeout,  
        DWORD ReadTotalTimeoutMultiplier, DWORD ReadTotalTimeoutConstant,  
        DWORD WriteTotalTimeoutMultiplier,DWORD WriteTotalTimeoutConstant);  
    bool ConfigurePort(DWORD BaudRate, BYTE ByteSize, DWORD fParity,   
        BYTE  Parity,BYTE StopBits);
    DCB _dcb;
    int __fastcall _FindCommPortReg(String* NameList, int& Count);
    void ClearBuff();
    void RXClearBuff();
    void UpdateComName();
};
#endif
