//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "RealSizeImage_Form.h"
#include "Message_Form.h"
#include "Environment.h"
#include "MultiLanguage.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TRealSizeImageForm *RealSizeImageForm;
//---------------------------------------------------------------------------
__fastcall TRealSizeImageForm::TRealSizeImageForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  prevLeftPos = TntImage1->Left;

  displayImageWidth = 1000;
    
  originLeftPos = LeftPos = 0;
  originRightPos = RightPos = displayImageWidth * TntImage2->Width / SYSTEM_CAMERA_HD_WIDTH;

  MouseDownSW = false;

  Panel1->DoubleBuffered = true;
  Panel3->DoubleBuffered = true;
}
//---------------------------------------------------------------------------
void __fastcall TRealSizeImageForm::SetImage(TTntImage *ImageData)
{
  TntImage1->Picture->Bitmap->Assign(ImageData->Picture->Bitmap);
  TntImage1->Repaint();

  ImageNavigatorDisplay();
}
//---------------------------------------------------------------------------

void __fastcall TRealSizeImageForm::TntButton1Click(TObject *Sender)
{
  this->Close();  
}
//---------------------------------------------------------------------------

void __fastcall TRealSizeImageForm::ImageNavigatorDisplay(void)
{
	TntImage2->Canvas->Brush->Style = bsSolid;
	TntImage2->Canvas->Brush->Color = clBlack;
	TntImage2->Canvas->Pen->Color = clBlack;
	TntImage2->Canvas->Rectangle(0, 0, TntImage2->Width, TntImage2->Height);

	TntImage2->Canvas->Brush->Style = bsSolid;
	TntImage2->Canvas->Brush->Color = (TColor)0x656596;
	TntImage2->Canvas->Rectangle(LeftPos + shiftX, 0, RightPos + shiftX, TntImage2->Height);

  TntImage1->Left = prevLeftPos - shiftX * SYSTEM_CAMERA_HD_WIDTH / displayImageWidth;
}
//---------------------------------------------------------------------------

void __fastcall TRealSizeImageForm::TntImage2MouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  prevX = X;
  MouseDownSW = true;
}
//---------------------------------------------------------------------------

void __fastcall TRealSizeImageForm::TntImage2MouseMove(TObject *Sender,
      TShiftState Shift, int X, int Y)
{
  if(MouseDownSW)
  {
    shiftX = X - prevX;

    if(LeftPos + shiftX < 0)
    {
      shiftX = -LeftPos;
    }
    else if(RightPos + shiftX > TntImage2->Width)
    {
      shiftX = TntImage2->Width - RightPos;
    }

    ImageNavigatorDisplay();
  }
}
//---------------------------------------------------------------------------

void __fastcall TRealSizeImageForm::TntImage2MouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  MouseDownSW = false;

  LeftPos += shiftX;
  RightPos += shiftX;

  prevLeftPos = TntImage1->Left;
}
//---------------------------------------------------------------------------

void __fastcall TRealSizeImageForm::TntButton2Click(TObject *Sender)
{
  SavePictureDialog1->FileName = "";

  if(SavePictureDialog1->Execute())
  {
    AnsiString filename;
    filename = SavePictureDialog1->FileName + ".bmp";

    TntImage1->Picture->Bitmap->SaveToFile(filename);
  }
}
//---------------------------------------------------------------------------

