//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "SelectDefectImage_Form.h"  
#include "PrintInspectionResult_Form.h"    
#include "Environment.h"
#include "DefectInfo_Form.h"    
#include "Progress_Form.h"         
#include "AbstractDB.h"     
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma link "TntButtons"
#pragma resource "*.dfm"
TSelectDefectImageForm *SelectDefectImageForm;
//---------------------------------------------------------------------------
__fastcall TSelectDefectImageForm::TSelectDefectImageForm(TComponent* Owner)
	: TForm(Owner)
{
  if (DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
		ComponentSetFontName(this, "SimSun");
	else if (DefaultLCID == 1041)
		ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }
    
	DefectImagePanel[0] = ImagePanel1;
	DefectImagePanel[1] = ImagePanel2;
	DefectImagePanel[2] = ImagePanel3;
	DefectImagePanel[3] = ImagePanel4;
	DefectImagePanel[4] = ImagePanel5;
	DefectImagePanel[5] = ImagePanel6;
	DefectImagePanel[6] = ImagePanel7;
	DefectImagePanel[7] = ImagePanel8;
	DefectImagePanel[8] = ImagePanel9;
	DefectImagePanel[9] = ImagePanel10;
	DefectImagePanel[10] = ImagePanel11;
	DefectImagePanel[11] = ImagePanel12;

	DefectImage[0] = Image1;
	DefectImage[1] = Image2;
	DefectImage[2] = Image3;
	DefectImage[3] = Image4;
	DefectImage[4] = Image5;
	DefectImage[5] = Image6;
	DefectImage[6] = Image7;
	DefectImage[7] = Image8;
	DefectImage[8] = Image9;
	DefectImage[9] = Image10;
	DefectImage[10] = Image11;
	DefectImage[11] = Image12;

	ErrorTypeBox[0] = ErrorType1;
	ErrorTypeBox[1] = ErrorType2;
	ErrorTypeBox[2] = ErrorType3;
	ErrorTypeBox[3] = ErrorType4;
	ErrorTypeBox[4] = ErrorType5;
	ErrorTypeBox[5] = ErrorType6;
	ErrorTypeBox[6] = ErrorType7;
	ErrorTypeBox[7] = ErrorType8;
	ErrorTypeBox[8] = ErrorType9;
	ErrorTypeBox[9] = ErrorType10;
	ErrorTypeBox[10] = ErrorType11;
	ErrorTypeBox[11] = ErrorType12;

	ErrorTypeImage[0] = ErrorTypeImage1;
	ErrorTypeImage[1] = ErrorTypeImage2;
	ErrorTypeImage[2] = ErrorTypeImage3;
	ErrorTypeImage[3] = ErrorTypeImage4;
	ErrorTypeImage[4] = ErrorTypeImage5;
	ErrorTypeImage[5] = ErrorTypeImage6;
	ErrorTypeImage[6] = ErrorTypeImage7;
	ErrorTypeImage[7] = ErrorTypeImage8;
	ErrorTypeImage[8] = ErrorTypeImage9;
	ErrorTypeImage[9] = ErrorTypeImage10;
	ErrorTypeImage[10] = ErrorTypeImage11;
	ErrorTypeImage[11] = ErrorTypeImage12;

	ProductCode = ProductData.ProductCode;

	for (int i = 0; i < 12; i++)
	{
		PrintDefectImageInfo.DefectImageIndex[i] = 0xAAAA;
		PrintDefectImageInfo.DefectSeries[i] = 0;
		PrintDefectImageInfo.DefectSize[i] = 0;
		SelectedPanel[i] = 0;
	}

	DefectDataList = new TList;
	DefectViewList = new TList;

	ScrollBar1->Position = 0;
	ScrollBar1->Min = 0;
	ScrollBar1->Max = 0;

	ErrorTypeBox[0]->Color = clGreen;
	DefectType[0] = true;

	//  InitSelectDefect();

	//  DefectImageLoad();
	//  DrawDefectImage();
}

void __fastcall TSelectDefectImageForm::InitSelectDefect()
{

	while (DefectDataList->Count)
	{
		TDefectDataUnit *aDefectDataUnit = (TDefectDataUnit *)DefectDataList->First();
		DefectDataList->Remove(aDefectDataUnit);
		delete aDefectDataUnit;
	}

	if (!DefectDataDB.ConnectTable(ProductCode, LOTName,false,true))
	{
		return;
	}


	TProgressForm *progressForm = new TProgressForm(this, true);
	progressForm->Text = DEFECTINFOFORM_PROGRESSBAR_TEXT_01;
	progressForm->Show();
	progressForm->Repaint();

	progressForm->Max = DefectDataDB.DataCount;
	progressForm->Position = 0;

	int readDefectDataCount = 0;
	for (int defectDataIndex = DefectDataDB.DataCount - 1; defectDataIndex >= 0; defectDataIndex--)
	{
		TDefectDataUnit *aDefectData = new TDefectDataUnit;
		if (DefectDataDB.GetDefectData(&(aDefectData->DefectData), defectDataIndex))
		{
			aDefectData->DefectIndex = defectDataIndex + 1;
			DefectDataList->Add(aDefectData);
		}
		else
		{
			delete aDefectData;
		}
		progressForm->Position++;
		readDefectDataCount++;
		Application->ProcessMessages();
		if (progressForm->Break)
		{
			break;
		}
	}

	progressForm->Close();
	delete progressForm;

	ScrollBar1->Max = DefectDataDB.DataCount / 12;
	OkBitBtn->Caption = V6_SELECT_DEFLECT_IMAGE_FORM_TEXT_01;
	CancelBitBtn->Caption = V6_SELECT_DEFLECT_IMAGE_FORM_TEXT_02;
	Label1->Caption = V6_SELECT_DEFLECT_IMAGE_FORM_TEXT_03;
	Label2->Caption = V6_SELECT_DEFLECT_IMAGE_FORM_TEXT_04;

	DrawDefectImage();
}
void __fastcall TSelectDefectImageForm::DefectImageLoad(AnsiString lOTName, int* defectlist)
{
	int DefectCountList[MAX_DEFECT_SERIES_COUNT + 1];
	int DefectSeriesList[MAX_DEFECT_SERIES_COUNT + 1];

	LOTName = lOTName;
	AnsiString FilePath = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\Report";
	AnsiString SelectDataFileName = FilePath + "\\" + lOTName + ".dsi";

	if (FileExists(SelectDataFileName))
	{
		TFileStream *fileStream = new TFileStream(SelectDataFileName, fmOpenRead);
		fileStream->Read(&PrintDefectImageInfo, sizeof(PrintDefectImageInfo));
		delete fileStream;
	}
	else
	{
		DefectDataDB.ConnectTable(ProductData.ProductCode, lOTName,false,true);
		int readDefectDataCount = 0;
		for (int defectDataIndex = DefectDataDB.DataCount - 1; defectDataIndex >= 0; defectDataIndex--)
		{
			TDefectDataUnit *aDefectData = new TDefectDataUnit;
			if (DefectDataDB.GetDefectData(&(aDefectData->DefectData), defectDataIndex))
			{
				aDefectData->DefectIndex = defectDataIndex + 1;
				DefectDataList->Add(aDefectData);
			}
			else
			{
				delete aDefectData;
			}
			readDefectDataCount++;
		}

		/*
		AnsiString resultDir = ProgramPath.Product + "\\" + ProductCode + "\\Result";
		AnsiString inspectionReportFileName = resultDir + "\\" + lOTName + ".dat";
		TFileStream *fileStream = new TFileStream(inspectionReportFileName, fmOpenRead);
		fileStream->Position = sizeof(TTabletInspectReport) + sizeof(TTabletInspectGradeData);
		fileStream->Read(DefectSeriesCount, (MAX_DEFECT_SERIES_COUNT + 1) * sizeof(int));
		delete fileStream;*/
		memcpy(DefectSeriesCount, defectlist, sizeof(DefectSeriesCount));
		for (int defectSeriesIndex = 0; defectSeriesIndex < MAX_DEFECT_SERIES_COUNT + 1; defectSeriesIndex++)
		{
			DefectCountList[defectSeriesIndex] = DefectSeriesCount[defectSeriesIndex];
			if (defectSeriesIndex < MAX_CPB_DEFECT_SERIES_COUNT)
			{
				DefectSeriesList[defectSeriesIndex] = defectSeriesIndex;
			}
			else
			{
				DefectSeriesList[defectSeriesIndex] = defectSeriesIndex - MAX_CPB_DEFECT_SERIES_COUNT + THIN_TALBET;
			}
		}

		for (int i = 0; i < MAX_DEFECT_SERIES_COUNT; i++)
		{
			for (int j = i; j < MAX_DEFECT_SERIES_COUNT; j++)
			{
				if (DefectCountList[i] < DefectCountList[j])
				{
					int temp = DefectCountList[i];
					DefectCountList[i] = DefectCountList[j];
					DefectCountList[j] = temp;

					temp = DefectSeriesList[i];
					DefectSeriesList[i] = DefectSeriesList[j];
					DefectSeriesList[j] = temp;
				}
			}
		}

		int pos = 0;
		for (int i = 0; i < MAX_DEFECT_SERIES_COUNT; i++)
		{
			for (int j = 0; j < DefectDataList->Count; j++)
			{
				TDefectDataUnit *aDefectDataUnit = (TDefectDataUnit *)DefectDataList->Items[DefectDataList->Count - 1 - j];
				if ((DefectSeriesList[i] == aDefectDataUnit->DefectData.CPBDefectInfo.defectSeries)
					&& DefectCountList[i])
				{
					PrintDefectImageInfo.DefectImageIndex[pos] = j;
					PrintDefectImageInfo.DefectSeries[pos] = aDefectDataUnit->DefectData.CPBDefectInfo.defectSeries;
					PrintDefectImageInfo.DefectSize[pos] = aDefectDataUnit->DefectData.CPBDefectInfo.size;
					pos++;
					break;
				}
			}

			if (pos >= 12)
				break;
		}
	}
}
//---------------------------------------------------------------------------------------------
void __fastcall TSelectDefectImageForm::SelectionInfoSorting()
{
	int i;
	int flag = 0xff;

	for (i = 0; i < 12; i++)
	{
		if ((PrintDefectImageInfo.DefectImageIndex[i] == 0xAAAA) && (flag == 0xff))
			flag = i;

		if (flag != 0xff)
		{
			if (PrintDefectImageInfo.DefectImageIndex[i] != 0xAAAA)
			{
				PrintDefectImageInfo.DefectImageIndex[flag] = PrintDefectImageInfo.DefectImageIndex[i];
				PrintDefectImageInfo.DefectSeries[flag] = PrintDefectImageInfo.DefectSeries[i];
				PrintDefectImageInfo.DefectSize[flag] = PrintDefectImageInfo.DefectSize[i];

				PrintDefectImageInfo.DefectImageIndex[i] = 0xAAAA;
				PrintDefectImageInfo.DefectSeries[i] = 0;
				PrintDefectImageInfo.DefectSize[i] = 0;
				i = 0;
				flag = 0xff;
			}
		}
	}
}
//---------------------------------------------------------------------------------------------
bool  __fastcall TSelectDefectImageForm::WriteDefectSelectionData(AnsiString lOTName)
{
	AnsiString FilePath = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\Report";

	if (!DirectoryExists(FilePath))
		ForceDirectories(FilePath);

	AnsiString SelectDataFileName = FilePath + "\\" + lOTName + ".dsi";

	TFileStream *fileStream = new TFileStream(SelectDataFileName, fmCreate);
	//fileStream->Write(&SelectionIndex, sizeof(SelectionIndex));
	fileStream->Write(&PrintDefectImageInfo, sizeof(PrintDefectImageInfo));
	delete fileStream;
}
//---------------------------------------------------------------------------------------------
void __fastcall TSelectDefectImageForm::DrawDefectImage()
{
	int defectIndex = 0;//aDefectViewUnit->DefectDataIndex[aDefectViewUnit->MajorCamIndex];
	int ImageIndex;
	int defectDataIndex;
	int i;
	AnsiString saveImageFileName;
	AnsiString saveDir = GetDefectDataPath(ProductCode, LOTName);

	for (ImageIndex = 0; ImageIndex < 12; ImageIndex++)
	{
		SelectedPanel[ImageIndex] = 0;
		defectIndex = ScrollBar1->Position * 12 + ImageIndex;
		saveImageFileName = "Image" + IntToStr(defectIndex + 1) + ".fbm";
		if (ExtractImageFromContainer(DefectImage[ImageIndex]->Picture->Bitmap, GetDefectContainerFileName(defectIndex), saveImageFileName, false, NULL, ProductData.SubSamplingMode))
		{
			DefectImage[ImageIndex]->Repaint();
			defectDataIndex = DefectDataList->Count - 1 - defectIndex;
			TDefectDataUnit *aDefectDataUnit = (TDefectDataUnit *)DefectDataList->Items[defectDataIndex];
			TTntLabel *tempLabel = (TTntLabel *)FindComponent("ImageLabel" + IntToStr(ImageIndex + 1));
			tempLabel->Caption = GetDefectSeriesStr(aDefectDataUnit->DefectData.CPBDefectInfo.defectSeries);
			tempLabel->Width = 230;

			TTntLabel *tempTypeLabel = (TTntLabel *)FindComponent("TypeLabel" + IntToStr(ImageIndex + 1));
			tempTypeLabel->Caption = "";
			DefectImagePanel[ImageIndex]->Color = clBlack;

			for (i = 0; i < 12; i++)
			{
				if (PrintDefectImageInfo.DefectImageIndex[i] != 0xAAAA)
				{
					if (PrintDefectImageInfo.DefectImageIndex[i] == defectIndex)
					{
						if (DefectType[i])
						{
							DefectImagePanel[ImageIndex]->Color = clGreen;
						}
						else
						{
							DefectImagePanel[ImageIndex]->Color = clBlue;
						}
						tempTypeLabel->Caption = IntToStr(i + 1);
						SelectedPanel[ImageIndex] = i + 1;
					}
				}
			}
		}
		else
		{
			DefectImage[ImageIndex]->Canvas->Brush->Color = clBlack;
			DefectImage[ImageIndex]->Canvas->FillRect(Rect(0, 0, 640, 480));
			DefectImage[ImageIndex]->Repaint();
			DefectImagePanel[ImageIndex]->Color = clBlack;
			TTntLabel *tempLabel = (TTntLabel *)FindComponent("ImageLabel" + IntToStr(ImageIndex + 1));
			TTntLabel *tempTypeLabel = (TTntLabel *)FindComponent("TypeLabel" + IntToStr(ImageIndex + 1));
			tempLabel->Caption = "";
			tempTypeLabel->Caption = "";
		}
	}

	for (ImageIndex = 0; ImageIndex < 12; ImageIndex++)
	{
		if (PrintDefectImageInfo.DefectImageIndex[ImageIndex] != 0xaaaa)
		{
			defectIndex = PrintDefectImageInfo.DefectImageIndex[ImageIndex];
			saveImageFileName = "Image" + IntToStr(defectIndex + 1) + ".fbm";
			if (ExtractImageFromContainer(ErrorTypeImage[ImageIndex]->Picture->Bitmap, GetDefectContainerFileName(defectIndex), saveImageFileName, false, NULL, ProductData.SubSamplingMode))
			{
				ErrorTypeImage[ImageIndex]->Repaint();
				defectDataIndex = DefectDataList->Count - 1 - defectIndex;
				TDefectDataUnit *aDefectDataUnit = (TDefectDataUnit *)DefectDataList->Items[defectDataIndex];
				TTntLabel *tempLabel = (TTntLabel *)FindComponent("ErrorLabel" + IntToStr(ImageIndex + 1));
				tempLabel->Caption = GetDefectSeriesStr(aDefectDataUnit->DefectData.CPBDefectInfo.defectSeries);
				tempLabel->Width = 120;
			}
			else
			{
				ErrorTypeImage[ImageIndex]->Canvas->Brush->Color = clBlack;
				ErrorTypeImage[ImageIndex]->Canvas->FillRect(Rect(0, 0, 640, 480));
				ErrorTypeImage[ImageIndex]->Repaint();
				TTntLabel *tempLabel = (TTntLabel *)FindComponent("ErrorLabel" + IntToStr(ImageIndex + 1));
				tempLabel->Caption = "";
			}
		}
		else
		{
			ErrorTypeImage[ImageIndex]->Canvas->Brush->Color = clBlack;
			ErrorTypeImage[ImageIndex]->Canvas->FillRect(Rect(0, 0, 640, 480));
			ErrorTypeImage[ImageIndex]->Repaint();
			TTntLabel *tempLabel = (TTntLabel *)FindComponent("ErrorLabel" + IntToStr(ImageIndex + 1));
			tempLabel->Caption = "";
		}
	}
}

AnsiString __fastcall TSelectDefectImageForm::GetDefectContainerFileName(int defectIndex)
{
	int containerIndex = defectIndex / DEFECT_DATA_CONTAINER_SIZE;
	AnsiString saveDir = ProgramPath.Defect + "\\" + ProductCode + "\\" + LOTName;
	return saveDir + "\\DefectImage" + IntToStr(containerIndex + 1) + ".FAC";
}

void __fastcall TSelectDefectImageForm::ErrorType1Click(TObject *Sender)
{
	int i;

	for (i = 0; i < 12; i++)
	{
		if (i != 0)
		{
			ErrorTypeBox[i]->Color = clBlack;
			DefectType[i] = false;
		}
		else
		{
			ErrorTypeBox[i]->Color = clGreen;
			DefectType[i] = true;
		}
	}

	DrawDefectImage();
}

void __fastcall TSelectDefectImageForm::ErrorType2Click(TObject *Sender)
{
	int i;

	for (i = 0; i < 12; i++)
	{
		if (i != 1)
		{
			ErrorTypeBox[i]->Color = clBlack;
			DefectType[i] = false;
		}
		else
		{
			ErrorTypeBox[i]->Color = clGreen;
			DefectType[i] = true;
		}
	}

	DrawDefectImage();
}


//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::ErrorType3Click(TObject *Sender)
{
	int i;

	for (i = 0; i < 12; i++)
	{
		if (i != 2)
		{
			ErrorTypeBox[i]->Color = clBlack;
			DefectType[i] = false;
		}
		else
		{
			ErrorTypeBox[i]->Color = clGreen;
			DefectType[i] = true;
		}
	}

	DrawDefectImage();
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::ErrorType4Click(TObject *Sender)
{
	int i;

	for (i = 0; i < 12; i++)
	{
		if (i != 3)
		{
			ErrorTypeBox[i]->Color = clBlack;
			DefectType[i] = false;
		}
		else
		{
			ErrorTypeBox[i]->Color = clGreen;
			DefectType[i] = true;
		}
	}

	DrawDefectImage();
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::ErrorType5Click(TObject *Sender)
{
	int i;

	for (i = 0; i < 12; i++)
	{
		if (i != 4)
		{
			ErrorTypeBox[i]->Color = clBlack;
			DefectType[i] = false;
		}
		else
		{
			ErrorTypeBox[i]->Color = clGreen;
			DefectType[i] = true;
		}
	}

	DrawDefectImage();
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::ErrorType6Click(TObject *Sender)
{
	int i;

	for (i = 0; i < 12; i++)
	{
		if (i != 5)
		{
			ErrorTypeBox[i]->Color = clBlack;
			DefectType[i] = false;
		}
		else
		{
			ErrorTypeBox[i]->Color = clGreen;
			DefectType[i] = true;
		}
	}

	DrawDefectImage();
}
//---------------------------------------------------------------------------


void __fastcall TSelectDefectImageForm::ErrorType7Click(TObject *Sender)
{
	int i;

	for (i = 0; i < 12; i++)
	{
		if (i != 6)
		{
			ErrorTypeBox[i]->Color = clBlack;
			DefectType[i] = false;
		}
		else
		{
			ErrorTypeBox[i]->Color = clGreen;
			DefectType[i] = true;
		}
	}

	DrawDefectImage();
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::ErrorType8Click(TObject *Sender)
{
	int i;

	for (i = 0; i < 12; i++)
	{
		if (i != 7)
		{
			ErrorTypeBox[i]->Color = clBlack;
			DefectType[i] = false;
		}
		else
		{
			ErrorTypeBox[i]->Color = clGreen;
			DefectType[i] = true;
		}
	}

	DrawDefectImage();
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::ErrorType9Click(TObject *Sender)
{
	int i;

	for (i = 0; i < 12; i++)
	{
		if (i != 8)
		{
			ErrorTypeBox[i]->Color = clBlack;
			DefectType[i] = false;
		}
		else
		{
			ErrorTypeBox[i]->Color = clGreen;
			DefectType[i] = true;
		}
	}

	DrawDefectImage();
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::ErrorType10Click(TObject *Sender)
{
	int i;

	for (i = 0; i < 12; i++)
	{
		if (i != 9)
		{
			ErrorTypeBox[i]->Color = clBlack;
			DefectType[i] = false;
		}
		else
		{
			ErrorTypeBox[i]->Color = clGreen;
			DefectType[i] = true;
		}
	}

	DrawDefectImage();
}
//---------------------------------------------------------------------------
void __fastcall TSelectDefectImageForm::ErrorType11Click(TObject *Sender)
{
	int i;

	for (i = 0; i < 12; i++)
	{
		if (i != 10)
		{
			ErrorTypeBox[i]->Color = clBlack;
			DefectType[i] = false;
		}
		else
		{
			ErrorTypeBox[i]->Color = clGreen;
			DefectType[i] = true;
		}
	}

	DrawDefectImage();
}
//---------------------------------------------------------------------------
void __fastcall TSelectDefectImageForm::ErrorType12Click(TObject *Sender)
{
	int i;

	for (i = 0; i < 12; i++)
	{
		if (i != 11)
		{
			ErrorTypeBox[i]->Color = clBlack;
			DefectType[i] = false;
		}
		else
		{
			ErrorTypeBox[i]->Color = clGreen;
			DefectType[i] = true;
		}
	}

	DrawDefectImage();
}
//---------------------------------------------------------------------------


void __fastcall TSelectDefectImageForm::ErrorTypeImage1Click(
	TObject *Sender)
{
	TSelectDefectImageForm::ErrorType1Click(Sender);
}


void __fastcall TSelectDefectImageForm::ErrorTypeImage2Click(
	TObject *Sender)
{
	TSelectDefectImageForm::ErrorType2Click(Sender);
}
void __fastcall TSelectDefectImageForm::ErrorTypeImage3Click(
	TObject *Sender)
{
	TSelectDefectImageForm::ErrorType3Click(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::ErrorTypeImage4Click(
	TObject *Sender)
{
	TSelectDefectImageForm::ErrorType4Click(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::ErrorTypeImage5Click(
	TObject *Sender)
{
	TSelectDefectImageForm::ErrorType5Click(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::ErrorTypeImage6Click(
	TObject *Sender)
{
	TSelectDefectImageForm::ErrorType6Click(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::ErrorTypeImage7Click(
	TObject *Sender)
{
	TSelectDefectImageForm::ErrorType7Click(Sender);

}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::ErrorTypeImage8Click(
	TObject *Sender)
{
	TSelectDefectImageForm::ErrorType8Click(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::ErrorTypeImage9Click(
	TObject *Sender)
{
	TSelectDefectImageForm::ErrorType9Click(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::ErrorTypeImage10Click(
	TObject *Sender)
{
	TSelectDefectImageForm::ErrorType10Click(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::ErrorTypeImage11Click(
	TObject *Sender)
{
	TSelectDefectImageForm::ErrorType11Click(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TSelectDefectImageForm::ErrorTypeImage12Click(
	TObject *Sender)
{
	TSelectDefectImageForm::ErrorType12Click(Sender);
}
//---------------------------------------------------------------------------



void __fastcall TSelectDefectImageForm::ScrollBar1Change(TObject *Sender)
{
	DrawDefectImage();
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::SelectionDefectSeries(int panelNum)
{
	int i, pos;

	pos = ScrollBar1->Position * 12 + panelNum;
	for (i = 0; i < 12; i++)
	{
		if (DefectType[i])
		{
			if (PrintDefectImageInfo.DefectImageIndex[i] != pos)
			{
				if (SelectedPanel[panelNum])
				{
					PrintDefectImageInfo.DefectImageIndex[SelectedPanel[panelNum] - 1] = 0xAAAA;
					PrintDefectImageInfo.DefectSeries[SelectedPanel[panelNum] - 1] = 0;
					PrintDefectImageInfo.DefectSize[SelectedPanel[panelNum] - 1] = 0;
					SelectedPanel[SelectedPanel[panelNum] - 1] = 0;
				}
				PrintDefectImageInfo.DefectImageIndex[i] = pos;//ScrollBar1->Position * 12 + panelNum;
				TDefectDataUnit *aDefectDataUnit = (TDefectDataUnit *)DefectDataList->Items[DefectDataList->Count - 1 - PrintDefectImageInfo.DefectImageIndex[i]];
				PrintDefectImageInfo.DefectSeries[i] = aDefectDataUnit->DefectData.CPBDefectInfo.defectSeries;
				PrintDefectImageInfo.DefectSize[i] = aDefectDataUnit->DefectData.CPBDefectInfo.size;
			}
			else
			{
				PrintDefectImageInfo.DefectImageIndex[i] = 0xAAAA;
				PrintDefectImageInfo.DefectSeries[i] = 0;
				PrintDefectImageInfo.DefectSize[i] = 0;
				SelectedPanel[i] = 0;
			}
		}
	}
}

void __fastcall TSelectDefectImageForm::Image1DblClick(TObject *Sender)
{
	SelectionDefectSeries(0);
	DrawDefectImage();
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::Image2DblClick(TObject *Sender)
{
	SelectionDefectSeries(1);
	DrawDefectImage();
}
//---------------------------------------------------------------------------


void __fastcall TSelectDefectImageForm::Image3DblClick(TObject *Sender)
{
	SelectionDefectSeries(2);
	DrawDefectImage();
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::Image4DblClick(TObject *Sender)
{
	SelectionDefectSeries(3);
	DrawDefectImage();
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::Image5DblClick(TObject *Sender)
{
	SelectionDefectSeries(4);
	DrawDefectImage();

}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::Image6DblClick(TObject *Sender)
{
	SelectionDefectSeries(5);
	DrawDefectImage();
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::Image7DblClick(TObject *Sender)
{
	SelectionDefectSeries(6);
	DrawDefectImage();
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::Image8DblClick(TObject *Sender)
{
	SelectionDefectSeries(7);
	DrawDefectImage();
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::Image9DblClick(TObject *Sender)
{
	SelectionDefectSeries(8);
	DrawDefectImage();
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::Image10DblClick(TObject *Sender)
{
	SelectionDefectSeries(9);
	DrawDefectImage();
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::Image11DblClick(TObject *Sender)
{
	SelectionDefectSeries(10);
	DrawDefectImage();
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::Image12DblClick(TObject *Sender)
{
	SelectionDefectSeries(11);
	DrawDefectImage();
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::OkBitBtnClick(TObject *Sender)
{
	int i;

	SelectionInfoSorting();
	WriteDefectSelectionData(LOTName);
	ModalStat = mrOk;
	this->Close();
}
//---------------------------------------------------------------------------

void __fastcall TSelectDefectImageForm::CancelBitBtnClick(TObject *Sender)
{
	ModalStat = mrCancel;
	this->Close();
}
//---------------------------------------------------------------------------


