//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------

#include <vcl.h>
#include <registry.hpp>
#pragma hdrstop

#include "SetPath_Form.h"
#include "Environment.h"
#include "Common_PC.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"

TSetPathForm *SetPathForm;
//---------------------------------------------------------------------------
__fastcall TSetPathForm::TSetPathForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }

  FolderGroupBox->Caption = SETPATHFORM_GROUPBOX_CAPTION_01;

  this->Caption 		= SETPATHFORM_LABEL_CAPTION_01;
  Label6->Caption 			= SETPATHFORM_LABEL_CAPTION_02;
  Label3->Caption 			= SETPATHFORM_LABEL_CAPTION_03;

  ApplyButton->Caption 		= SETPATHFORM_BUTTON_CAPTION_01;
  NewFolderButton->Caption 	= SETPATHFORM_BUTTON_CAPTION_02;
  CancelBitBtn->Caption 	= SETPATHFORM_BUTTON_CAPTION_03;
  SaveBitBtn->Caption 		= SETPATHFORM_BUTTON_CAPTION_04;

}
//---------------------------------------------------------------------------
void __fastcall TSetPathForm::ApplyButtonClick(TObject *Sender)
{
    AnsiString temp;
    RootDirectoryListBox->Update();
    temp = RootDirectoryListBox->Directory;

    Folder.root     = temp;
    Folder.hex      = temp + "\\Hex";
    Folder.env      = temp + "\\Env";
    Folder.image    = temp + "\\Image";
    Folder.product  = temp + "\\Product";
    Folder.log      = temp + "\\Log";
    DisplayFolders();
}
//---------------------------------------------------------------------------
void __fastcall TSetPathForm::DisplayFolders(void)
{
    RootFolderStaticText->Caption = Folder.root;
    HexFolderStaticText->Caption = Folder.hex;
    EnvFolderStaticText->Caption = Folder.env;
	ImageFolderStaticText->Caption = Folder.image;
    ProductFolderStaticText->Caption = Folder.product;
    LogFolderStaticText->Caption = Folder.log;
}
//---------------------------------------------------------------------------
bool __fastcall TSetPathForm::SaveFolderData(void)
{
    bool rtn = true;
    TRegIniFile *regIniFile = new TRegIniFile("Application");

    regIniFile->RootKey = HKEY_LOCAL_MACHINE;
    regIniFile->OpenKey(PROGRAM_REGISTRY_KEY, true);

    regIniFile->WriteString("Folder", "Root_Tablet", Folder.root);

    if (!DirectoryExists(Folder.hex))
    {
        if (!CreateDir(Folder.hex))
        {
            rtn = false;
        }
    }
    if (!DirectoryExists(Folder.env))
    {
        if (!CreateDir(Folder.env))
        {
            rtn =  false;
        }
    }
    if (!DirectoryExists(Folder.image))
    {
        if (!CreateDir(Folder.image))
        {
            rtn =  false;
        }
    }
    if (!DirectoryExists(Folder.product))
    {
        if (!CreateDir(Folder.product))
        {
            rtn =  false;
        }
    }
    if (!DirectoryExists(Folder.log))
    {
        if (!CreateDir(Folder.log))
        {
            rtn =  false;
        }
    }

    delete regIniFile;
    return rtn;
}
//---------------------------------------------------------------------------
void __fastcall TSetPathForm::SaveBitBtnClick(TObject *Sender)
{
    if (SaveFolderData())
    {
        // if success
        ShowMessageW(SETPATHFORM_MSG_01);
        this->Close();
    }
    else
    {
        // if fail
        ShowMessageW(SETPATHFORM_MSG_02);
    }
}
//---------------------------------------------------------------------------
void __fastcall TSetPathForm::NewFolderButtonClick(TObject *Sender)
{
    AnsiString Dir = RootDirectoryListBox->Directory;
    if (SelectDirectory(Dir, TSelectDirOpts() << sdAllowCreate << sdPerformCreate << sdPrompt,0 ))
    {
        RootDirectoryListBox->Directory = Dir;
    }	
}
//---------------------------------------------------------------------------

void __fastcall TSetPathForm::CancelBitBtnClick(TObject *Sender)
{
	this->Close();	
}
//---------------------------------------------------------------------------

