//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------
#include <vcl.h>
#include <inifiles.hpp>
#pragma hdrstop

#include "SpeedControl_Form.h"
#include "Message_Form.h"
#include "Keyboard_Form.h"
#include "MachineControl.h"
#include "MultiLanguage.h"
#include "Environment.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntGrids"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TSpeedControlForm *SpeedControlForm;
//---------------------------------------------------------------------------
__fastcall TSpeedControlForm::TSpeedControlForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }
  GetDefaultString();
	for (int speedControlIndex = 0; speedControlIndex < MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT; speedControlIndex++)
	{
		for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
		{
      if(MachineSetupData.SimpleSpeedControlOption)
      {
        if( motorIndex == 0 || motorIndex == 1)
        {
          // SimpleMotorSpeedList
          CurrentMotorSpeedList[motorIndex][speedControlIndex] = MachineParams.MotorSimpleSpeedList[ProductData.SimpleMotorSpeedList[motorIndex][speedControlIndex]];
          OldMotorSpeedList[motorIndex][speedControlIndex] = MachineParams.MotorSimpleSpeedList[ProductData.SimpleMotorSpeedList[motorIndex][speedControlIndex]];

          // VD Speed Step Info
          CurrentSimpleSpeedIndex[motorIndex][speedControlIndex] = ProductData.SimpleMotorSpeedList[motorIndex][speedControlIndex];
          OldSimpleSpeedIndex[motorIndex][speedControlIndex]= ProductData.SimpleMotorSpeedList[motorIndex][speedControlIndex];
        }
        else
        {
          CurrentMotorSpeedList[motorIndex][speedControlIndex] = ProductData.MotorSpeedList[motorIndex][speedControlIndex];
          OldMotorSpeedList[motorIndex][speedControlIndex] = ProductData.MotorSpeedList[motorIndex][speedControlIndex];
        }
      }
      else
      {
        CurrentMotorSpeedList[motorIndex][speedControlIndex] = ProductData.MotorSpeedList[motorIndex][speedControlIndex];
  			OldMotorSpeedList[motorIndex][speedControlIndex] = ProductData.MotorSpeedList[motorIndex][speedControlIndex];
      }
		}
	}

	for (int speedControlIndex = 0; speedControlIndex < MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT; speedControlIndex++)
	{
		CurrentMotorSpeedRatioList[SD1_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[SD1_MOTOR_INDEX][speedControlIndex];
		CurrentMotorSpeedRatioList[SD2_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[SD2_MOTOR_INDEX][speedControlIndex];
		CurrentMotorSpeedRatioList[BF_ID_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_ID_MOTOR_INDEX][speedControlIndex];
		CurrentMotorSpeedRatioList[BF_OD_IN_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_OD_IN_MOTOR_INDEX][speedControlIndex];

		if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
		{
			CurrentMotorSpeedRatioList[BF_OD_OUT_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_OD_OUT_MOTOR_INDEX][speedControlIndex];
		}
	}

    OldVFAutoTrainingMode = ProductData.MachineRunOption.MaxSpeedTrainingMode;
    OldVFManualSpeed = ProductData.MachineRunOption.ManualMaxSpeed;
	OldVFManualLimitSpeed = ProductData.MachineRunOption.ManualLimitSpeed;
    OldVFSensor1Ratio = ProductData.MachineRunOption.EmptySensorActiveRatio;
    OldVFSensor2Ratio = ProductData.MachineRunOption.FullSensorActiveRatio;
    OldVFStartSpeed = ProductData.MachineRunOption.StartSpeed;

	SpeedBackupDataIndex = 0;
	LoadOldSpeedValues();

	CurrentMotorSpeedIndex = MachineOperationInfo.SpeedIndex;
    ApplyMotorSpeed();

    if(PCProgramOption.VibratorFeederSpeedControlOpt == true)
    {
    	VFSpeedAutoTrainingPanel->Visible = true;
    	VFSpeedManualTrainingPanel->Visible = true;
//	if (MachineSetupData.VFInfo.MaxSpeedTrainingMode == MAX_SPEED_TRAINING_MODE_AUTO)
	if (ProductData.MachineRunOption.MaxSpeedTrainingMode == MAX_SPEED_TRAINING_MODE_AUTO)
	{
		VFSpeedAutoTrainingPanel->Color = clBlue;
		VFSpeedAutoTrainingPanel->Font->Color = clWhite;
		VFSpeedManualTrainingPanel->Color = clWhite;
		VFSpeedManualTrainingPanel->Font->Color = clBlack;
		VFSpeedAutoTraining = true;

    VFAutoModeGroupBox->Visible = true;
    VFManualModeGroupBox->Visible = false;

    VibMaxSpeedEdit->Enabled = false;
    VibLimitSpeedEdit->Enabled = false;
  }
	else
	{
		VFSpeedAutoTrainingPanel->Color = clWhite;
		VFSpeedAutoTrainingPanel->Font->Color = clBlack;
		VFSpeedManualTrainingPanel->Color = clBlue;
		VFSpeedManualTrainingPanel->Font->Color = clWhite;
    VFSpeedAutoTraining = false;

		VFAutoModeGroupBox->Visible = false;
    VFManualModeGroupBox->Visible = true;

    VibMaxSpeedEdit->Enabled = true;
    VibLimitSpeedEdit->Enabled = true;
	}
  }
  else
  {
//    VibMaxSpeedEdit->Text = IntToStr(MachineSetupData.VFInfo.ManualMaxSpeed);
	//Auto
    // Delete Auto Mode
    VFSpeedAutoTrainingPanel->Visible = false;
    VFSpeedManualTrainingPanel->Visible = false;
    VFSpeedAutoTraining = false;
    VFAutoModeGroupBox->Visible = false;
    VFManualModeGroupBox->Visible = true;
    VibMaxSpeedEdit->Enabled = true;
    VibLimitSpeedEdit->Enabled = true;
  }

    VFAutoStartSpeedEdit->Text = IntToStr(ProductData.MachineRunOption.StartSpeed);
    VFAutoSensor1RatioEdit->Text = IntToStr(ProductData.MachineRunOption.EmptySensorActiveRatio);
    VFAutoSensor2RatioEdit->Text = IntToStr(ProductData.MachineRunOption.FullSensorActiveRatio);

    //Manual
    VibMaxSpeedEdit->Text = IntToStr(ProductData.MachineRunOption.ManualMaxSpeed);
    VFManualSensorComboBox->ItemIndex = ProductData.MachineRunOption.ManualModeSensorIndex;
    VFManualSensorRatioEdit->Text = IntToStr(ProductData.MachineRunOption.ManualModeSensorActiveRatio);
    VibLimitSpeedEdit->Text = IntToStr(ProductData.MachineRunOption.ManualLimitSpeed);
    VFManualLimitSensorComboBox->ItemIndex = ProductData.MachineRunOption.ManualModeLimitSensorIndex;
	VFManualLimitSensorRatioEdit->Text = IntToStr(ProductData.MachineRunOption.ManualModeLimitSensorActiveRatio);

  if(MachineSetupData.SimpleSpeedControlOption)
  {
    SimpleVDPanel->BringToFront();
    LoadOldSpeedButton->Visible = false;
  }
  else
  {
    SimpleVDPanel->SendToBack();
    LoadOldSpeedButton->Visible = true;
  }

  this->Width = 580;
	//this->Height = 1164;
	
  if(MachineSetupData.LasercomplexerInfo.Laser_complexer_Enable)
  {
    innerDiskRSpeed->Visible = true;
    OutDiskRSpeed->Visible = true;
    SucktionDiskRSpeed->Visible = true;

    if(0 < NFALaserinfo.LaserMackingTime && NFALaserinfo.LaserMackingTime<= 4000)
    {
      innerDiskRSpeed->Caption = " μ  ǵ120~150%";
      innerDiskRSpeed->Font->Color = clLime;
      OutDiskRSpeed->Caption = " μ  ǵ120~140%";
      OutDiskRSpeed->Font->Color = clLime;
      SucktionDiskRSpeed->Caption = " μ  ǵ130~150%";
      SucktionDiskRSpeed->Font->Color = clLime;
    }
    else if(4000 < NFALaserinfo.LaserMackingTime && NFALaserinfo.LaserMackingTime <= 6000)
    {
      innerDiskRSpeed->Caption = " μ  ǵ100~130%";
      innerDiskRSpeed->Font->Color = clLime;
      OutDiskRSpeed->Caption = " μ  ǵ100~120%";
      OutDiskRSpeed->Font->Color = clLime;
      SucktionDiskRSpeed->Caption = " μ  ǵ110~130%";
      SucktionDiskRSpeed->Font->Color = clLime;
    }
    else if(6000 < NFALaserinfo.LaserMackingTime && NFALaserinfo.LaserMackingTime <= 8000)
    {
      innerDiskRSpeed->Caption = " μ  ǵ90~120%";
      innerDiskRSpeed->Font->Color = clLime;
      OutDiskRSpeed->Caption = " μ  ǵ90~110%";
      OutDiskRSpeed->Font->Color = clLime;
      SucktionDiskRSpeed->Caption = " μ  ǵ100~120%";
      SucktionDiskRSpeed->Font->Color = clLime;
    }
    else if(8000 < NFALaserinfo.LaserMackingTime && NFALaserinfo.LaserMackingTime<= 10000)
    {
      innerDiskRSpeed->Caption = " μ  ǵ80~110%";
      innerDiskRSpeed->Font->Color = clLime;
      OutDiskRSpeed->Caption = " μ  ǵ80~100%";
      OutDiskRSpeed->Font->Color = clLime;
      SucktionDiskRSpeed->Caption = " μ  ǵ90~110%";
      SucktionDiskRSpeed->Font->Color = clLime;
    }
    else if(10000 < NFALaserinfo.LaserMackingTime && NFALaserinfo.LaserMackingTime <= 12000)
    {
      innerDiskRSpeed->Caption = " μ  ǵ70~100%";
      innerDiskRSpeed->Font->Color = clLime;
      OutDiskRSpeed->Caption = " μ  ǵ70~90%";
      OutDiskRSpeed->Font->Color = clLime;
      SucktionDiskRSpeed->Caption = " μ  ǵ80~100%";
      SucktionDiskRSpeed->Font->Color = clLime;
    }
    else if(13000 < NFALaserinfo.LaserMackingTime && NFALaserinfo.LaserMackingTime<= 16000)
    {
      innerDiskRSpeed->Caption = " μ  ǵ60~100%";
      innerDiskRSpeed->Font->Color = clLime;
      OutDiskRSpeed->Caption = " μ  ǵ60~80%";
      OutDiskRSpeed->Font->Color = clLime;
      SucktionDiskRSpeed->Caption = " μ  ǵ70~90%";
      SucktionDiskRSpeed->Font->Color = clLime;
    }
    else if(16000 < NFALaserinfo.LaserMackingTime && NFALaserinfo.LaserMackingTime<= 20000)
    {
      innerDiskRSpeed->Caption = " μ  ǵ50~80%";
      innerDiskRSpeed->Font->Color = clLime;
      OutDiskRSpeed->Caption = " μ  ǵ50~70%";
      OutDiskRSpeed->Font->Color = clLime;
      SucktionDiskRSpeed->Caption = " μ  ǵ60~70%";
      SucktionDiskRSpeed->Font->Color = clLime;
    }
    else if(20000 < NFALaserinfo.LaserMackingTime )
    {
      innerDiskRSpeed->Caption = "̼ μⰡ Ұ  Դϴ.";
      innerDiskRSpeed->Font->Color = clRed;
      OutDiskRSpeed->Caption = "̼ μⰡ Ұ  Դϴ.";
      OutDiskRSpeed->Font->Color = clRed;
      SucktionDiskRSpeed->Caption = "̼ μⰡ Ұ  Դϴ.";
      SucktionDiskRSpeed->Font->Color = clRed;
    }
    else
    {

      innerDiskRSpeed->Caption = "ǰ õ ʾҽϴ.";
      innerDiskRSpeed->Font->Color = clBlue;
      OutDiskRSpeed->Caption = "ǰ õ ʾҽϴ.";
      OutDiskRSpeed->Font->Color = clBlue;
      SucktionDiskRSpeed->Caption = "ǰ õ ʾҽϴ.";
      SucktionDiskRSpeed->Font->Color = clBlue;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TSpeedControlForm::GetDefaultString()
{
	CancelBitBtn->Caption = SPEEDCONTROLFORM_BITBTN_CAPTION_01;
	OkBitBtn->Caption = SPEEDCONTROLFORM_BITBTN_CAPTION_02;
	RestoreSpeedButton->Caption = SPEEDCONTROLFORM_BUTTON_CAPTION_01;
	MotorSpeedResetButton->Caption = SPEEDCONTROLFORM_BUTTON_CAPTION_02;
	LoadOldSpeedButton->Caption = SPEEDCONTROLFORM_BUTTON_CAPTION_03;
	ApplyMachineSpeedButton->Caption = SPEEDCONTROLFORM_BUTTON_CAPTION_04;
	GroupBox1->Caption = SPEEDCONTROLFORM_GROUPBOX_CAPTION_01;
	VFAutoModeGroupBox->Caption = SPEEDCONTROLFORM_GROUPBOX_CAPTION_02;
	GroupBox2->Caption = SPEEDCONTROLFORM_GROUPBOX_CAPTION_03;
	Label1->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_01;
	Label10->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_02;
  TntLabel6->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_02;
	Label4->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_03;
	Label6->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_04;
	Label7->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_05;
	Label16->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_06;
	Label8->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_07;
	
	MotorSpeedPanel2->Caption = SPEEDCONTROLFORM_PANEL_CAPTION_01;
	MotorSpeedPanel1->Caption = SPEEDCONTROLFORM_PANEL_CAPTION_02;
	Panel6->Caption = SPEEDCONTROLFORM_PANEL_CAPTION_03;
	VFSpeedManualTrainingPanel->Caption = SPEEDCONTROLFORM_PANEL_CAPTION_04;
	VFSpeedAutoTrainingPanel->Caption = SPEEDCONTROLFORM_PANEL_CAPTION_05;
	MotorSpeedPanel3->Caption = SPEEDCONTROLFORM_PANEL_CAPTION_06;

  //add
  VFManualModeGroupBox->Caption = NEW_ADD_STRING_19;
  Label3->Caption = NEW_ADD_STRING_20;
  TntLabel1->Caption = NEW_ADD_STRING_21;
  Label14->Caption = NEW_ADD_STRING_22;
  TntLabel2->Caption = NEW_ADD_STRING_22;
  Label12->Caption = NEW_ADD_STRING_23;
  TntLabel3->Caption = NEW_ADD_STRING_23;
  VFManualSensorComboBox->Items->Strings[0] = NEW_ADD_STRING_24;
  VFManualSensorComboBox->Items->Strings[1] = NEW_ADD_STRING_25;
  VFManualLimitSensorComboBox->Items->Strings[0] = NEW_ADD_STRING_24;
  VFManualLimitSensorComboBox->Items->Strings[1] = NEW_ADD_STRING_25;

  this->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_09; 
  
	if(MachineSetupData.MachineType < 2)
	{
		Label9->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_08;
		TntLabel7->Caption = "ȸ̵ ";
		Panel9->Visible = false;
	}
	else
	{
		Label9->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_10;
		TntLabel7->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_11;
		Panel9->Visible = true;	
	}

}
//---------------------------------------------------------------------------
void __fastcall TSpeedControlForm::MotorSpeedResetButtonClick(
      TObject *Sender)
{
	if (MessageDlgFA(SPEEDCONTROLFORM_MSG_03, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
	{
	    // set motor params
		int tabletType = 0, tabletShape = 0;

		if (ProductData.TabletType < TABLET_TYPE_COUNT)
	    {
	    	tabletType = ProductData.TabletType;
	    }

	    if (ProductData.TabletShape < TABLET_SHAPE_COUNT)
	    {
			tabletShape = ProductData.TabletShape;
	    }
	    else if (ProductData.TabletShape == TABLET_SHAPE_TRIANGLE)
	    {
			tabletShape = TABLET_SHAPE_CIRCLE;
	    }
/*
		for (int motorIndex = 0; motorIndex < MAX_STEP_MOTOR_COUNT; motorIndex++)
	    {
	    	for (int speedIndex = 0; speedIndex < MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT; speedIndex++)
	        {
				ProductData.MotorSpeedList[motorIndex][speedIndex] = MachineParams.MotorSpeedList[tabletType][tabletShape][motorIndex][speedIndex];
	        }
	    }
*/
		int msTabletTypeIndex = GetMSTabletTypeIndex(ProductData.TabletType);
		int msTabletShapeIndex = GetMSTabletShapeIndex(ProductData.TabletShape);
		for (int speedControlIndex = 0; speedControlIndex < MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT; speedControlIndex++)
    {
      for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
      {
        if(MachineSetupData.SimpleSpeedControlOption)
        {
          if( motorIndex == 0 || motorIndex == 1)
          {
            CurrentMotorSpeedList[motorIndex][speedControlIndex] = MachineParams.MotorSimpleSpeedList[3];
            CurrentSimpleSpeedIndex[motorIndex][speedControlIndex] = 3;
          }
          else
          {
            CurrentMotorSpeedList[motorIndex][speedControlIndex] = MachineParams.MotorSpeedList[msTabletTypeIndex][msTabletShapeIndex][motorIndex][speedControlIndex];
          }
        }
        else
        {
          CurrentMotorSpeedList[motorIndex][speedControlIndex] = MachineParams.MotorSpeedList[msTabletTypeIndex][msTabletShapeIndex][motorIndex][speedControlIndex];
        }
      }
    }

    for (int speedControlIndex = 0; speedControlIndex < MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT; speedControlIndex++)
    {
	CurrentMotorSpeedRatioList[SD1_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[SD1_MOTOR_INDEX][speedControlIndex];
	CurrentMotorSpeedRatioList[SD2_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[SD2_MOTOR_INDEX][speedControlIndex];
	CurrentMotorSpeedRatioList[BF_ID_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_ID_MOTOR_INDEX][speedControlIndex];
	CurrentMotorSpeedRatioList[BF_OD_IN_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_OD_IN_MOTOR_INDEX][speedControlIndex];
	if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
	{
		CurrentMotorSpeedRatioList[BF_OD_OUT_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_OD_OUT_MOTOR_INDEX][speedControlIndex];
	}
    }

    ApplyMotorSpeed();
  }
}
//---------------------------------------------------------------------------
void __fastcall TSpeedControlForm::MotorSpeedPanelClick(TObject *Sender)
{
	TTntPanel *thePanel = (TTntPanel *) Sender;
	CurrentMotorSpeedIndex = thePanel->Tag;
    ApplyMotorSpeed();
}
//---------------------------------------------------------------------------
void __fastcall TSpeedControlForm::ApplyMotorSpeed(void)
{
	for (int speedControlIndex = 0; speedControlIndex < MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT; speedControlIndex++)
  {
	  TTntPanel *motorSpeedPanel = (TTntPanel *)FindComponent("MotorSpeedPanel" + IntToStr(speedControlIndex + 1));
    if(speedControlIndex == CurrentMotorSpeedIndex)
    {
		motorSpeedPanel->Color = clBlue;
		motorSpeedPanel->Font->Color = clWhite;
		BFIDSpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 60 / CurrentMotorSpeedList[BF_ID_MOTOR_INDEX][speedControlIndex]) + "RPM (" + IntToStr(MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_ID_MOTOR_INDEX][speedControlIndex]) + "%)";
		BFODInSpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 36 / CurrentMotorSpeedList[BF_OD_IN_MOTOR_INDEX][speedControlIndex]) + "RPM (" + IntToStr(MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_OD_IN_MOTOR_INDEX][speedControlIndex]) + "%)";
		if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
		{
			BFODOutSpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 36 / CurrentMotorSpeedList[BF_OD_OUT_MOTOR_INDEX][speedControlIndex]) + "RPM (" + IntToStr(MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_OD_OUT_MOTOR_INDEX][speedControlIndex]) + "%)";
		}
		VDSpeedLabel->Caption = IntToStr((int)(MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * SUCTION_DISK_100P_RPM / CurrentMotorSpeedList[SD1_MOTOR_INDEX][speedControlIndex])) + "RPM (" + IntToStr(MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[SD1_MOTOR_INDEX][speedControlIndex]) + "%)";

		int SimpleSpeedValue = CurrentSimpleSpeedIndex[0][CurrentMotorSpeedIndex];
		VDSimpleSpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 60 / MachineParams.MotorSimpleSpeedList[SimpleSpeedValue])+ "RPM ( No. "+IntToStr(SimpleSpeedValue+1)+" )";
		}
		else
		{
			motorSpeedPanel->Color = clWhite;
			motorSpeedPanel->Font->Color = clBlack;
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TSpeedControlForm::OkBitBtnClick(TObject *Sender)
{
	ApplyMachineSpeedChange();
//SaveVFSpeedParam();
	BackupModifiedSpeed();

    bool VFSpeedChanged = false;
    if (OldVFAutoTrainingMode   != ProductData.MachineRunOption.MaxSpeedTrainingMode)						VFSpeedChanged = true;
    if (OldVFSensor1Ratio       != ProductData.MachineRunOption.EmptySensorActiveRatio) 	        		VFSpeedChanged = true;
    if (OldVFSensor2Ratio       != ProductData.MachineRunOption.FullSensorActiveRatio)						VFSpeedChanged = true;
    if (OldVFStartSpeed         != ProductData.MachineRunOption.StartSpeed)									VFSpeedChanged = true;
    if (OldVFManualSpeed        != ProductData.MachineRunOption.ManualMaxSpeed)                           	VFSpeedChanged = true;
    if (OldVFManualSensorIndex  != ProductData.MachineRunOption.ManualModeSensorIndex)                  	VFSpeedChanged = true;
    if (OldVFManualSensorActiveRatio != ProductData.MachineRunOption.ManualModeSensorActiveRatio)       	VFSpeedChanged = true;
    if (OldVFManualLimitSpeed   != ProductData.MachineRunOption.ManualLimitSpeed)                       	VFSpeedChanged = true;
    if (OldVFManualLimitSensorIndex  != ProductData.MachineRunOption.ManualModeLimitSensorIndex)            VFSpeedChanged = true;
    if (OldVFManualLimitSensorActiveRatio != ProductData.MachineRunOption.ManualModeLimitSensorActiveRatio) VFSpeedChanged = true;
    if (VFSpeedChanged)
    {
		Machine.VFSpeedChange(&(ProductData.MachineRunOption));
    }

}
//---------------------------------------------------------------------------
void __fastcall TSpeedControlForm::FeederInnerDiscSpeedUpButtonClick(
	  TObject *Sender)
{
	int newSpeedRatio, newSpeed, calculatedSpeedRatio;
  
  TImage *tempImage;
  tempImage = (TImage*)Sender;

  int step;
  if(tempImage->Tag == 0)
    step = 1;
  else
    step = 10;

    newSpeedRatio = CurrentMotorSpeedRatioList[BF_ID_MOTOR_INDEX][CurrentMotorSpeedIndex];
	do
    {
		newSpeedRatio = newSpeedRatio + 1 * step;
		newSpeed = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
		if (newSpeed == 0) return;
		calculatedSpeedRatio = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / newSpeed;
		if (calculatedSpeedRatio > PCProgramOption.MotorMaxSpeed[1]) return;
	}
	while (calculatedSpeedRatio == CurrentMotorSpeedRatioList[BF_ID_MOTOR_INDEX][CurrentMotorSpeedIndex]);
	CurrentMotorSpeedRatioList[BF_ID_MOTOR_INDEX][CurrentMotorSpeedIndex] = calculatedSpeedRatio;
	CurrentMotorSpeedList[BF_ID_MOTOR_INDEX][CurrentMotorSpeedIndex] = newSpeed;
	ApplyMotorSpeed();
}
//---------------------------------------------------------------------------
void __fastcall TSpeedControlForm::FeederInnerDiscSpeedDownButtonClick(
      TObject *Sender)
{
	int newSpeedRatio, newSpeed, calculatedSpeedRatio;

  TImage *tempImage;
  tempImage = (TImage*)Sender;

  int step;
  if(tempImage->Tag == 0)
    step = 1;
  else
    step = 10;

    newSpeedRatio = CurrentMotorSpeedRatioList[BF_ID_MOTOR_INDEX][CurrentMotorSpeedIndex];
	do
    {
		newSpeedRatio = newSpeedRatio - 1 * step;
        if (newSpeedRatio <= 0) return;
		newSpeed = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
		calculatedSpeedRatio = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / newSpeed;
		if (calculatedSpeedRatio < PCProgramOption.MotorMinSpeed[1]) return;
	}
	while (calculatedSpeedRatio == CurrentMotorSpeedRatioList[BF_ID_MOTOR_INDEX][CurrentMotorSpeedIndex]);
	CurrentMotorSpeedRatioList[BF_ID_MOTOR_INDEX][CurrentMotorSpeedIndex] = calculatedSpeedRatio;
	CurrentMotorSpeedList[BF_ID_MOTOR_INDEX][CurrentMotorSpeedIndex] = newSpeed;
    ApplyMotorSpeed();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::VacuumDiscSpeedUpButtonClick(
      TObject *Sender)
{
	int newSpeedRatio, newSpeed1, newSpeed2;
	int calculatedSpeedRatio1, calculatedSpeedRatio2;

  TImage *tempImage;
  tempImage = (TImage*)Sender;

  int step;
  if(tempImage->Tag == 0)
    step = 1;
  else
    step = 10;

	newSpeedRatio = CurrentMotorSpeedRatioList[SD1_MOTOR_INDEX][CurrentMotorSpeedIndex];
	do
	{
		newSpeedRatio = newSpeedRatio + 1 * step;
		newSpeed1 = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
		newSpeed2 = newSpeed1;
		if (newSpeed1 == 0 || newSpeed2 == 0) return;
		calculatedSpeedRatio1 = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / newSpeed1;
		calculatedSpeedRatio2 = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / newSpeed2;

#ifdef ELMA100_TABLET
    // ELMA  α׷   ӵ  (130ۼƮ)
		if (calculatedSpeedRatio1 > 130 || calculatedSpeedRatio2 > 130) return;
#else
    // SELMA   ӵ  .  PC α׷  ӵ  ӵ ø  
    //    150ۼƮ  ӵ ˻簡   
    // Ǽӵ  йȣ Էؾ  
		if (calculatedSpeedRatio1 > PCProgramOption.MotorMaxSpeed[0] ||
			calculatedSpeedRatio2 > PCProgramOption.MotorMaxSpeed[0]) return;
#endif
	}
	while (calculatedSpeedRatio2 == CurrentMotorSpeedRatioList[SD2_MOTOR_INDEX][CurrentMotorSpeedIndex]);
	CurrentMotorSpeedRatioList[SD1_MOTOR_INDEX][CurrentMotorSpeedIndex] = calculatedSpeedRatio1;
	CurrentMotorSpeedRatioList[SD2_MOTOR_INDEX][CurrentMotorSpeedIndex] = calculatedSpeedRatio2;
	CurrentMotorSpeedList[SD1_MOTOR_INDEX][CurrentMotorSpeedIndex] = newSpeed1;
	CurrentMotorSpeedList[SD2_MOTOR_INDEX][CurrentMotorSpeedIndex] = newSpeed2;
	ApplyMotorSpeed();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::VacuumDiscSpeedDownButtonClick(
	  TObject *Sender)
{
	int newSpeedRatio, newSpeed1, newSpeed2;
    int calculatedSpeedRatio1, calculatedSpeedRatio2;

    TImage *tempImage;
  tempImage = (TImage*)Sender;

  int step;
  if(tempImage->Tag == 0)
    step = 1;
  else
    step = 10;

    newSpeedRatio = CurrentMotorSpeedRatioList[SD1_MOTOR_INDEX][CurrentMotorSpeedIndex];
	do
    {
		newSpeedRatio = newSpeedRatio - 1 * step;
        if (newSpeedRatio <= 0) return;
		newSpeed1 = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
		newSpeed2 = newSpeed1;

		calculatedSpeedRatio1 = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / newSpeed1;
		calculatedSpeedRatio2 = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / newSpeed2;
		/*
		if (calculatedSpeedRatio2 * 1.2 < CurrentMotorSpeedRatioList[2][CurrentMotorSpeedIndex])
		{
			ShowMessageFA("Ǵ  ӵ ̼ ũ ӵ 1.2 踦 ʰ  ϴ.");
			return;
		}
		*/

		if (calculatedSpeedRatio1 < PCProgramOption.MotorMinSpeed[0] ||
			calculatedSpeedRatio2 < PCProgramOption.MotorMinSpeed[0]) return;
    }
    while (calculatedSpeedRatio2 == CurrentMotorSpeedRatioList[SD2_MOTOR_INDEX][CurrentMotorSpeedIndex]);
	CurrentMotorSpeedRatioList[SD1_MOTOR_INDEX][CurrentMotorSpeedIndex] = calculatedSpeedRatio1;
	CurrentMotorSpeedRatioList[SD2_MOTOR_INDEX][CurrentMotorSpeedIndex] = calculatedSpeedRatio2;
	CurrentMotorSpeedList[SD1_MOTOR_INDEX][CurrentMotorSpeedIndex] = newSpeed1;
	CurrentMotorSpeedList[SD2_MOTOR_INDEX][CurrentMotorSpeedIndex] = newSpeed2;
	ApplyMotorSpeed();
}
//---------------------------------------------------------------------------

bool __fastcall TSpeedControlForm::ApplyMachineSpeedChange(void)
{
	for (int speedControlIndex = 0; speedControlIndex < MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT; speedControlIndex++)
  {
    for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
    {
        ProductData.MotorSpeedList[motorIndex][speedControlIndex] = CurrentMotorSpeedList[motorIndex][speedControlIndex];
        ProductData.SimpleMotorSpeedList[motorIndex][speedControlIndex] = CurrentSimpleSpeedIndex[motorIndex][speedControlIndex];
    }
  }

  int manualSpeed = 100;
  int manualModeSensorIndex = 0;
  int manualModeSensorActiveRatio = 0;
	int manualLimitSpeed = 60;
  int manualModeLimitSensorIndex = 0;
  int manualModeLimitSensorActiveRatio = 0;

  bool bSpeedValueError = false;

  if (!VFSpeedAutoTraining)
  {
    try
    {
      manualSpeed = StrToInt(VibMaxSpeedEdit->Text);
      manualModeSensorIndex = VFManualSensorComboBox->ItemIndex;
      manualModeSensorActiveRatio = StrToInt(VFManualSensorRatioEdit->Text);
      manualLimitSpeed = StrToInt(VibLimitSpeedEdit->Text);
      manualModeLimitSensorIndex = VFManualLimitSensorComboBox->ItemIndex;
              manualModeLimitSensorActiveRatio = StrToInt(VFManualLimitSensorRatioEdit->Text);
    }
      catch(...)
      {
          bSpeedValueError = true;
      }
  }
	if (!bSpeedValueError)
    {
        if (manualSpeed < 1 || manualSpeed > 255)
        {
                bSpeedValueError = true;
        }
    }
    if (bSpeedValueError)
    {
    	ShowMessageFA(SPEEDCONTROLFORM_MSG_02);
		VibMaxSpeedEdit->Text = IntToStr(100);
        VibLimitSpeedEdit->Text = IntToStr(100);
        return false;
	}

    if (VFSpeedAutoTraining)
    {
	    bool bRatioValueError = false;
	    int sensor1Ratio = 100;
	    int sensor2Ratio = 100;
            int startSpeed = 40;
            
	    try
	    {
			    sensor1Ratio = StrToInt(VFAutoSensor1RatioEdit->Text);
	        sensor2Ratio = StrToInt(VFAutoSensor2RatioEdit->Text);
          startSpeed   = StrToInt(VFAutoStartSpeedEdit->Text);

	    	ProductData.MachineRunOption.EmptySensorActiveRatio = sensor1Ratio;
	    	ProductData.MachineRunOption.FullSensorActiveRatio  = sensor2Ratio;
        ProductData.MachineRunOption.StartSpeed             = startSpeed;
	    }
	    catch (...)
	    {
                bRatioValueError = true;
	    }
	    
	    if (bRatioValueError)
	    {
	    	ShowMessageFA(SPEEDCONTROLFORM_MSG_01);
                return false;
            }
    }

	if (VFSpeedAutoTraining)
	{
		ProductData.MachineRunOption.MaxSpeedTrainingMode = MAX_SPEED_TRAINING_MODE_AUTO;
	}
	else
	{
		ProductData.MachineRunOption.MaxSpeedTrainingMode = MAX_SPEED_TRAINING_MODE_MANUAL;
		ProductData.MachineRunOption.ManualMaxSpeed = manualSpeed;
		ProductData.MachineRunOption.ManualModeSensorIndex = manualModeSensorIndex;
		ProductData.MachineRunOption.ManualModeSensorActiveRatio = manualModeSensorActiveRatio;
		ProductData.MachineRunOption.ManualLimitSpeed = manualLimitSpeed;
		ProductData.MachineRunOption.ManualModeLimitSensorIndex = manualModeLimitSensorIndex;
		ProductData.MachineRunOption.ManualModeLimitSensorActiveRatio = manualModeLimitSensorActiveRatio;
	}

	AnsiString fileName = GetProductDataFileName(ProductData.ProductCode);
	WriteProductData(fileName, ProductData);
	return true;
}
//---------------------------------------------------------------------------


void __fastcall TSpeedControlForm::VFSpeedAutoTrainingPanelClick(
      TObject *Sender)
{
    VFSpeedAutoTrainingPanel->Color = clBlue;
    VFSpeedAutoTrainingPanel->Font->Color = clWhite;
    VFSpeedManualTrainingPanel->Color = clWhite;
    VFSpeedManualTrainingPanel->Font->Color = clBlack;
    VFSpeedAutoTraining = true;
    VibMaxSpeedEdit->Enabled = false;
    VibLimitSpeedEdit->Enabled = false;
    VFAutoModeGroupBox->Visible = true;
    VFManualModeGroupBox->Visible = false;
}
//---------------------------------------------------------------------------
void __fastcall TSpeedControlForm::VFSpeedManualTrainingPanelClick(
      TObject *Sender)
{
	VFSpeedAutoTrainingPanel->Color = clWhite;
    VFSpeedAutoTrainingPanel->Font->Color = clBlack;
	VFSpeedManualTrainingPanel->Color = clBlue;
    VFSpeedManualTrainingPanel->Font->Color = clWhite;
	  VFSpeedAutoTraining = false;
    VibMaxSpeedEdit->Enabled = true;
    VibLimitSpeedEdit->Enabled = true;
    VFAutoModeGroupBox->Visible = false;
    VFManualModeGroupBox->Visible = true;
}
//---------------------------------------------------------------------------
void __fastcall TSpeedControlForm::SaveVFSpeedParam(void)
{
	if (!Comm_Request(COMM_HCB, CMD_MACHINE_PARAM_SETUP, &MachineSetupData, sizeof(TMachineSetupData)))
	{
    	//ShowMessageW(HCBConnection.GetLastErrorMessage());
    }
}
//---------------------------------------------------------------------------
void __fastcall TSpeedControlForm::ApplyMachineSpeedButtonClick(TObject *Sender)
{
  //ApplyMotorSpeed();
	if (ApplyMachineSpeedChange())
	{
		if (Machine.Status.OperationState == MACHINE_STATE_RUN)
		{
			int motorSpeedList[MAX_SERVO_MOTOR_COUNT];
			for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
			{
				motorSpeedList[motorIndex] = CurrentMotorSpeedList[motorIndex][CurrentMotorSpeedIndex];
			}

			Machine.SpeedChange(motorSpeedList);
		}
        Machine.VFSpeedChange(&(ProductData.MachineRunOption));
	}
	BackupModifiedSpeed();
	for (int speedControlIndex = 0; speedControlIndex < MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT; speedControlIndex++)
	{
		for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
		{
			OldMotorSpeedList[motorIndex][speedControlIndex] = CurrentMotorSpeedList[motorIndex][speedControlIndex];
      OldSimpleSpeedIndex[motorIndex][speedControlIndex] = CurrentSimpleSpeedIndex[motorIndex][speedControlIndex];
		}
	}
	LoadOldSpeedValues();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::NumEditClick(TObject *Sender)
{
	TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
	if (KeyboardForm->ShowKeypad() == mrOk)
	{
		theEdit->Text = KeyboardForm->Text;
	}
}
//---------------------------------------------------------------------------
void __fastcall TSpeedControlForm::BackupModifiedSpeed(void)
{
	AnsiString backupPath = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\Backup";
	ForceDirectories(backupPath);
	AnsiString fileName = backupPath + "\\MotorSpeedBackup.fbk";
	TIniFile *iniFile = new TIniFile(fileName);
	if (iniFile)
	{
		// check motor speed modification
		for (int speedControlIndex = 0; speedControlIndex < MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT; speedControlIndex++)
		{
			bool motorSpeedChanged = false;
			for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
			{
				if (CurrentMotorSpeedList[motorIndex][speedControlIndex] != OldMotorSpeedList[motorIndex][speedControlIndex])
				{
					motorSpeedChanged = true;
					break;
				}
			}
			if (motorSpeedChanged)
			{
				iniFile->WriteFloat("Speed Backup " + IntToStr(SpeedBackupDataIndex + 1), "Time", Now().Val);
				iniFile->WriteString("Speed Backup " + IntToStr(SpeedBackupDataIndex + 1), "Operator", UserInfo.Name);
				iniFile->WriteInteger("Speed Backup " + IntToStr(SpeedBackupDataIndex + 1), "Speed Index", speedControlIndex);
				for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
				{
					iniFile->WriteInteger("Speed Backup " + IntToStr(SpeedBackupDataIndex + 1), "Motor Speed " + IntToStr(motorIndex + 1),
						OldMotorSpeedList[motorIndex][speedControlIndex]);
				}
				SpeedBackupDataIndex++;
				if (SpeedBackupDataIndex >= MAX_SPEED_BACKUP_COUNT)
				{
					SpeedBackupDataIndex = 0;
				}
				iniFile->WriteInteger("Speed Backup Global", "Speed Backup Index", SpeedBackupDataIndex);
			}
		}
		delete iniFile;
	}
}
//---------------------------------------------------------------------------
void __fastcall TSpeedControlForm::LoadOldSpeedValues(void)
{
	SpeedBackupList.clear();
	AnsiString backupPath = ProgramPath.Product + "\\" + ProductData.ProductCode + "\\Backup";
	AnsiString fileName = backupPath + "\\MotorSpeedBackup.fbk";
	if (!FileExists(fileName)) return;
	TIniFile *iniFile = new TIniFile(fileName);
	if (iniFile)
	{
		SpeedBackupDataIndex = iniFile->ReadInteger("Speed Backup Global", "Speed Backup Index", 0);
		int backupIndex = SpeedBackupDataIndex - 1;
		if (backupIndex < 0)
		{
			backupIndex = MAX_SPEED_BACKUP_COUNT - 1;
		}
		int readBackupDataCount = 0;
		while (true)
		{
			TSpeedBackupUnit speedBackupUnit;
			speedBackupUnit.BackupTime = iniFile->ReadFloat("Speed Backup " + IntToStr(backupIndex + 1), "Time", Now().Val);
			speedBackupUnit.OperatorName = iniFile->ReadString("Speed Backup " + IntToStr(backupIndex + 1), "Operator", "");
			speedBackupUnit.SpeedControlIndex = iniFile->ReadInteger("Speed Backup " + IntToStr(backupIndex + 1), "Speed Index", -1);
			for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
			{
				speedBackupUnit.MotorSpeed[motorIndex] = iniFile->ReadInteger("Speed Backup " + IntToStr(backupIndex + 1), "Motor Speed " + IntToStr(motorIndex + 1),
					MachineSetupData.ServoMotorData[motorIndex].BaseSpeed);
			}
			if (speedBackupUnit.SpeedControlIndex >= 0)
			{
				SpeedBackupList.push_back(speedBackupUnit);
			}
			else
			{
				break;
			}
			backupIndex--;
			if (backupIndex < 0)
			{
				backupIndex = MAX_SPEED_BACKUP_COUNT - 1;
			}
			readBackupDataCount++;
			if (readBackupDataCount == MAX_SPEED_BACKUP_COUNT) break;
		}
		delete iniFile;
		if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
		{
			SpeedBackupListStringGrid->ColCount = 7;
			SpeedBackupListStringGrid->RowCount = max(2, SpeedBackupList.size() + 1);
			SpeedBackupListStringGrid->ColWidths[0] = 170;
			SpeedBackupListStringGrid->Cells[0][0] = SPEEDCONTROLFORM_STRGRID_CELL_01;
			SpeedBackupListStringGrid->Cells[1][0] = SPEEDCONTROLFORM_STRGRID_CELL_02;
			SpeedBackupListStringGrid->Cells[2][0] = SPEEDCONTROLFORM_STRGRID_CELL_05;
			SpeedBackupListStringGrid->Cells[3][0] = SPEEDCONTROLFORM_STRGRID_CELL_06;
			SpeedBackupListStringGrid->Cells[4][0] = SPEEDCONTROLFORM_STRGRID_CELL_06;
			SpeedBackupListStringGrid->Cells[5][0] = SPEEDCONTROLFORM_STRGRID_CELL_03;
			SpeedBackupListStringGrid->Cells[6][0] = SPEEDCONTROLFORM_STRGRID_CELL_04;
			vector <TSpeedBackupUnit> :: iterator it;
			int rowIndex = 1;
			for (it = SpeedBackupList.begin(); it < SpeedBackupList.end(); it++)
			{
				SpeedBackupListStringGrid->Cells[0][rowIndex] = TDateTime(it->BackupTime).DateTimeString();
				SpeedBackupListStringGrid->Cells[1][rowIndex] = GetSpeedIndexStr(it->SpeedControlIndex);
				SpeedBackupListStringGrid->Cells[2][rowIndex] = IntToStr(
					MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / it->MotorSpeed[BF_ID_MOTOR_INDEX]) + "%";
				SpeedBackupListStringGrid->Cells[3][rowIndex] = IntToStr(
					MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / it->MotorSpeed[BF_OD_IN_MOTOR_INDEX]) + "%";			
				SpeedBackupListStringGrid->Cells[4][rowIndex] = IntToStr(
					MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / it->MotorSpeed[BF_OD_OUT_MOTOR_INDEX]) + "%";
				SpeedBackupListStringGrid->Cells[5][rowIndex] = IntToStr(
					MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / it->MotorSpeed[SD1_MOTOR_INDEX]) + "%";
				SpeedBackupListStringGrid->Cells[6][rowIndex] = it->OperatorName;
				
				rowIndex++;
			}		
		}
		else
		{
			SpeedBackupListStringGrid->ColCount = 6;
			SpeedBackupListStringGrid->RowCount = max(2, SpeedBackupList.size() + 1);
			SpeedBackupListStringGrid->ColWidths[0] = 180;
			SpeedBackupListStringGrid->Cells[0][0] = SPEEDCONTROLFORM_STRGRID_CELL_01;
			SpeedBackupListStringGrid->Cells[1][0] = SPEEDCONTROLFORM_STRGRID_CELL_02;
			SpeedBackupListStringGrid->Cells[2][0] = SPEEDCONTROLFORM_STRGRID_CELL_05;
			SpeedBackupListStringGrid->Cells[3][0] = SPEEDCONTROLFORM_STRGRID_CELL_06;
			SpeedBackupListStringGrid->Cells[4][0] = SPEEDCONTROLFORM_STRGRID_CELL_03;
			SpeedBackupListStringGrid->Cells[5][0] = SPEEDCONTROLFORM_STRGRID_CELL_04;

			vector <TSpeedBackupUnit> :: iterator it;
			int rowIndex = 1;
			for (it = SpeedBackupList.begin(); it < SpeedBackupList.end(); it++)
			{
				SpeedBackupListStringGrid->Cells[0][rowIndex] = TDateTime(it->BackupTime).DateTimeString();
				SpeedBackupListStringGrid->Cells[1][rowIndex] = GetSpeedIndexStr(it->SpeedControlIndex);
				SpeedBackupListStringGrid->Cells[2][rowIndex] = IntToStr(
					MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / it->MotorSpeed[BF_ID_MOTOR_INDEX]) + "%";
				SpeedBackupListStringGrid->Cells[3][rowIndex] = IntToStr(
					MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / it->MotorSpeed[BF_OD_IN_MOTOR_INDEX]) + "%";
				SpeedBackupListStringGrid->Cells[4][rowIndex] = IntToStr(
					MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / it->MotorSpeed[SD1_MOTOR_INDEX]) + "%";
				SpeedBackupListStringGrid->Cells[5][rowIndex] = it->OperatorName;
				rowIndex++;
			}
		}

	}
}
//---------------------------------------------------------------------------
WideString TSpeedControlForm::GetSpeedIndexStr(int speedControlIndex)
{
	WideString retStr = SPEEDCONTROLFORM_RETURNSTR_01;
	switch (speedControlIndex)
	{
		case 0:
			retStr = SPEEDCONTROLFORM_PANEL_CAPTION_02;
			break;
		case 1:
			retStr = SPEEDCONTROLFORM_PANEL_CAPTION_01;
			break;
		case 2:
			retStr = SPEEDCONTROLFORM_PANEL_CAPTION_06;
			break;
	}
	return retStr;
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::LoadOldSpeedButtonClick(TObject *Sender)
{
	if (!SpeedBackupPanel->Visible)
	{
		SpeedBackupPanel->Visible = true;
		this->Width = 1040;
		this->Left = (Screen->Width - this->Width) / 2;
	}
	else
	{
		SpeedBackupPanel->Visible = false;
		this->Width = 580;
		this->Left = (Screen->Width - this->Width) / 2;
	}
}
//---------------------------------------------------------------------------
void __fastcall TSpeedControlForm::RestoreSpeedButtonClick(TObject *Sender)
{
	int selectedDataIndex = SpeedBackupListStringGrid->Row - 1;
	if (selectedDataIndex >= 0 && selectedDataIndex < SpeedBackupList.size())
	{
		for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
		{
			CurrentMotorSpeedList[motorIndex][CurrentMotorSpeedIndex] = SpeedBackupList[selectedDataIndex].MotorSpeed[motorIndex];
		}

		for (int speedControlIndex = 0; speedControlIndex < MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT; speedControlIndex++)
		{
			CurrentMotorSpeedRatioList[SD1_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[SD1_MOTOR_INDEX][speedControlIndex];
			CurrentMotorSpeedRatioList[SD2_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[SD2_MOTOR_INDEX][speedControlIndex];
			CurrentMotorSpeedRatioList[BF_ID_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_ID_MOTOR_INDEX][speedControlIndex];
			CurrentMotorSpeedRatioList[BF_OD_IN_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_OD_IN_MOTOR_INDEX][speedControlIndex];
			if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
			{
				CurrentMotorSpeedRatioList[BF_OD_OUT_MOTOR_INDEX][speedControlIndex] = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_OD_OUT_MOTOR_INDEX][speedControlIndex];	
			}
		}
		ApplyMotorSpeed();
	}
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::FeederInnerDiscSpeedDownButton1MouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  FeederInnerDiscSpeedDownButton1->Picture->Bitmap->Assign(tempGrayDown1->Picture->Bitmap);
  FeederInnerDiscSpeedDownButton1->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::FeederInnerDiscSpeedDownButton1MouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  FeederInnerDiscSpeedDownButton1->Picture->Bitmap->Assign(tempWhiteDown1->Picture->Bitmap);
  FeederInnerDiscSpeedDownButton1->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::RotationInSpeedDownButton1MouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  RotationInSpeedDownButton1->Picture->Bitmap->Assign(tempGrayDown1->Picture->Bitmap);
  RotationInSpeedDownButton1->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::RotationInSpeedDownButton1MouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  RotationInSpeedDownButton1->Picture->Bitmap->Assign(tempWhiteDown1->Picture->Bitmap);
  RotationInSpeedDownButton1->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::VacuumDiscSpeedDownButton1MouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  VacuumDiscSpeedDownButton1->Picture->Bitmap->Assign(tempGrayDown1->Picture->Bitmap);
  VacuumDiscSpeedDownButton1->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::VacuumDiscSpeedDownButton1MouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  VacuumDiscSpeedDownButton1->Picture->Bitmap->Assign(tempWhiteDown1->Picture->Bitmap);
  VacuumDiscSpeedDownButton1->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::FeederInnerDiscSpeedDownButto2MouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  FeederInnerDiscSpeedDownButto2->Picture->Bitmap->Assign(tempGrayDown2->Picture->Bitmap);
  FeederInnerDiscSpeedDownButto2->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::FeederInnerDiscSpeedDownButto2MouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  FeederInnerDiscSpeedDownButto2->Picture->Bitmap->Assign(tempWhiteDown2->Picture->Bitmap);
  FeederInnerDiscSpeedDownButto2->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::RotationInSpeedDownButton2MouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  RotationInSpeedDownButton2->Picture->Bitmap->Assign(tempGrayDown2->Picture->Bitmap);
  RotationInSpeedDownButton2->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::RotationInSpeedDownButton2MouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  RotationInSpeedDownButton2->Picture->Bitmap->Assign(tempWhiteDown2->Picture->Bitmap);
  RotationInSpeedDownButton2->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::VacuumDiscSpeedDownButton2MouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  VacuumDiscSpeedDownButton2->Picture->Bitmap->Assign(tempGrayDown2->Picture->Bitmap);
  VacuumDiscSpeedDownButton2->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::VacuumDiscSpeedDownButton2MouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  VacuumDiscSpeedDownButton2->Picture->Bitmap->Assign(tempWhiteDown2->Picture->Bitmap);
  VacuumDiscSpeedDownButton2->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::FeederInnerDiscSpeedUpButton1MouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  FeederInnerDiscSpeedUpButton1->Picture->Bitmap->Assign(tempGrayUp1->Picture->Bitmap);
  FeederInnerDiscSpeedUpButton1->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::FeederInnerDiscSpeedUpButton1MouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  FeederInnerDiscSpeedUpButton1->Picture->Bitmap->Assign(tempWhiteUp1->Picture->Bitmap);
  FeederInnerDiscSpeedUpButton1->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::RotationInSpeedUpButton1MouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  RotationInSpeedUpButton1->Picture->Bitmap->Assign(tempWhiteUp1->Picture->Bitmap);
  RotationInSpeedUpButton1->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::VacuumDiscSpeedUpButton1MouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  VacuumDiscSpeedUpButton1->Picture->Bitmap->Assign(tempGrayUp1->Picture->Bitmap);
  VacuumDiscSpeedUpButton1->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::VacuumDiscSpeedUpButton1MouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  VacuumDiscSpeedUpButton1->Picture->Bitmap->Assign(tempWhiteUp1->Picture->Bitmap);
  VacuumDiscSpeedUpButton1->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::FeederInnerDiscSpeedUpButton2MouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  FeederInnerDiscSpeedUpButton2->Picture->Bitmap->Assign(tempGrayUp2->Picture->Bitmap);
  FeederInnerDiscSpeedUpButton2->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::FeederInnerDiscSpeedUpButton2MouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  FeederInnerDiscSpeedUpButton2->Picture->Bitmap->Assign(tempWhiteUp2->Picture->Bitmap);
  FeederInnerDiscSpeedUpButton2->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::RotationInSpeedUpButton2MouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  RotationInSpeedUpButton2->Picture->Bitmap->Assign(tempGrayUp2->Picture->Bitmap);
  RotationInSpeedUpButton2->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::RotationInSpeedUpButton2MouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  RotationInSpeedUpButton2->Picture->Bitmap->Assign(tempWhiteUp2->Picture->Bitmap);
  RotationInSpeedUpButton2->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::VacuumDiscSpeedUpButton2MouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  VacuumDiscSpeedUpButton2->Picture->Bitmap->Assign(tempGrayUp2->Picture->Bitmap);
  VacuumDiscSpeedUpButton2->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::VacuumDiscSpeedUpButton2MouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  VacuumDiscSpeedUpButton2->Picture->Bitmap->Assign(tempWhiteUp2->Picture->Bitmap);
  VacuumDiscSpeedUpButton2->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::VDSimpleSpeedDownButtonMouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  VDSimpleSpeedDownButton->Picture->Bitmap->Assign(tempGrayDown1->Picture->Bitmap);
  VDSimpleSpeedDownButton->Refresh();
}
//---------------------------------------------------------------------------


void __fastcall TSpeedControlForm::VDSimpleSpeedUpButtonMouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  VDSimpleSpeedUpButton->Picture->Bitmap->Assign(tempGrayUp1->Picture->Bitmap);
  VDSimpleSpeedUpButton->Refresh();
}
//---------------------------------------------------------------------------


void __fastcall TSpeedControlForm::VDSimpleSpeedDownButtonMouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  int CurrentVDStep = CurrentSimpleSpeedIndex[0][CurrentMotorSpeedIndex];
  int NewVDStep = CurrentVDStep;
  TImage* UpDownBtn =  (TImage*)Sender;
  // 1 : Step up , 2: Step Down
  if(UpDownBtn->Tag)
  {
    VDSimpleSpeedUpButton->Picture->Bitmap->Assign(tempWhiteUp1->Picture->Bitmap);
    VDSimpleSpeedUpButton->Refresh();
    if(NewVDStep + 1 < 18)
      NewVDStep += 1;
  }
  else
  {
     VDSimpleSpeedDownButton->Picture->Bitmap->Assign(tempWhiteDown1->Picture->Bitmap);
    VDSimpleSpeedDownButton->Refresh();
    if(NewVDStep - 1 >= 0)
      NewVDStep -= 1;
  }

 	int newSpeed1, newSpeed2;
	int calculatedSpeedRatio1, calculatedSpeedRatio2;

  newSpeed1 = newSpeed2 = MachineParams.MotorSimpleSpeedList[NewVDStep];

  if (newSpeed1 == 0 || newSpeed2 == 0) return;
  calculatedSpeedRatio1 = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / newSpeed1;
  calculatedSpeedRatio2 = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / newSpeed2;

	CurrentMotorSpeedRatioList[SD1_MOTOR_INDEX][CurrentMotorSpeedIndex] = calculatedSpeedRatio2;
	CurrentMotorSpeedRatioList[SD2_MOTOR_INDEX][CurrentMotorSpeedIndex] = calculatedSpeedRatio2;

	CurrentMotorSpeedList[SD1_MOTOR_INDEX][CurrentMotorSpeedIndex] = newSpeed1;
	CurrentMotorSpeedList[SD2_MOTOR_INDEX][CurrentMotorSpeedIndex] = newSpeed2;

	CurrentSimpleSpeedIndex[SD1_MOTOR_INDEX][CurrentMotorSpeedIndex]  =  NewVDStep;
	CurrentSimpleSpeedIndex[SD2_MOTOR_INDEX][CurrentMotorSpeedIndex]  =  NewVDStep;

	ApplyMotorSpeed();

}
//---------------------------------------------------------------------------


void __fastcall TSpeedControlForm::RotationInSpeedDownButtonClick(
      TObject *Sender)
{
	int newSpeedRatio, newSpeed, calculatedSpeedRatio;

  TImage *tempImage;
  tempImage = (TImage*)Sender;

  int step;
  if(tempImage->Tag == 0)
    step = 1;
  else
    step = 10;

    newSpeedRatio = CurrentMotorSpeedRatioList[BF_OD_IN_MOTOR_INDEX][CurrentMotorSpeedIndex];
	do
    {
		newSpeedRatio = newSpeedRatio - 1 * step;
        if (newSpeedRatio <= 0) return;
		newSpeed = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
		calculatedSpeedRatio = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / newSpeed;
		if (calculatedSpeedRatio < PCProgramOption.MotorMinSpeed[2]) return;
	}
	while (calculatedSpeedRatio == CurrentMotorSpeedRatioList[BF_OD_IN_MOTOR_INDEX][CurrentMotorSpeedIndex]);
	CurrentMotorSpeedRatioList[BF_OD_IN_MOTOR_INDEX][CurrentMotorSpeedIndex] = calculatedSpeedRatio;
	CurrentMotorSpeedList[BF_OD_IN_MOTOR_INDEX][CurrentMotorSpeedIndex] = newSpeed;
    ApplyMotorSpeed();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::RotationInSpeedUpButtonClick(
      TObject *Sender)
{
	int newSpeedRatio, newSpeed, calculatedSpeedRatio;

  TImage *tempImage;
  tempImage = (TImage*)Sender;

  int step;
  if(tempImage->Tag == 0)
    step = 1;
  else
    step = 10;

    newSpeedRatio = CurrentMotorSpeedRatioList[BF_OD_IN_MOTOR_INDEX][CurrentMotorSpeedIndex];	// third operating module
	do
    {
		newSpeedRatio = newSpeedRatio + 1 * step;
		newSpeed = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;		// fifth motor
		if (newSpeed == 0) return;
		calculatedSpeedRatio = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / newSpeed;		// fifth motor
		/*
		if (calculatedSpeedRatio > CurrentMotorSpeedRatioList[0][CurrentMotorSpeedIndex] * 1.2)
		{
			ShowMessageFA("Ǵ  ӵ ̼ ũ ӵ 1.2 踦 ʰ  ϴ.");
			return;
		}
		*/
		if (calculatedSpeedRatio > PCProgramOption.MotorMaxSpeed[2]) return;
	}
	while (calculatedSpeedRatio == CurrentMotorSpeedRatioList[BF_OD_IN_MOTOR_INDEX][CurrentMotorSpeedIndex]);
	CurrentMotorSpeedRatioList[BF_OD_IN_MOTOR_INDEX][CurrentMotorSpeedIndex] = calculatedSpeedRatio;
	CurrentMotorSpeedList[BF_OD_IN_MOTOR_INDEX][CurrentMotorSpeedIndex] = newSpeed;
	ApplyMotorSpeed();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::RotationOutSpeedDownButtonClick(
      TObject *Sender)
{
	int newSpeedRatio, newSpeed, calculatedSpeedRatio;

  TImage *tempImage;
  tempImage = (TImage*)Sender;

  int step;
  if(tempImage->Tag == 0)
    step = 1;
  else
    step = 10;

    newSpeedRatio = CurrentMotorSpeedRatioList[BF_OD_OUT_MOTOR_INDEX][CurrentMotorSpeedIndex];
	do
    {
		newSpeedRatio = newSpeedRatio - 1 * step;
        if (newSpeedRatio <= 0) return;
		newSpeed = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
		calculatedSpeedRatio = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / newSpeed;
		if (calculatedSpeedRatio < PCProgramOption.MotorMinSpeed[2]) return;
	}
	while (calculatedSpeedRatio == CurrentMotorSpeedRatioList[BF_OD_OUT_MOTOR_INDEX][CurrentMotorSpeedIndex]);
	CurrentMotorSpeedRatioList[BF_OD_OUT_MOTOR_INDEX][CurrentMotorSpeedIndex] = calculatedSpeedRatio;
	CurrentMotorSpeedList[BF_OD_OUT_MOTOR_INDEX][CurrentMotorSpeedIndex] = newSpeed;
    ApplyMotorSpeed();
}
//---------------------------------------------------------------------------


void __fastcall TSpeedControlForm::RotationOutSpeedUpButtonClick(
      TObject *Sender)
{
	int newSpeedRatio, newSpeed, calculatedSpeedRatio;

  TImage *tempImage;
  tempImage = (TImage*)Sender;

  int step;
  if(tempImage->Tag == 0)
    step = 1;
  else
    step = 10;

    newSpeedRatio = CurrentMotorSpeedRatioList[BF_OD_OUT_MOTOR_INDEX][CurrentMotorSpeedIndex];	// third operating module
	do
    {
		newSpeedRatio = newSpeedRatio + 1 * step;
		newSpeed = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;		// fifth motor
		if (newSpeed == 0) return;
		calculatedSpeedRatio = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / newSpeed;		// fifth motor
		if (calculatedSpeedRatio > PCProgramOption.MotorMaxSpeed[2]) return;
	}
	while (calculatedSpeedRatio == CurrentMotorSpeedRatioList[BF_OD_OUT_MOTOR_INDEX][CurrentMotorSpeedIndex]);
	CurrentMotorSpeedRatioList[BF_OD_OUT_MOTOR_INDEX][CurrentMotorSpeedIndex] = calculatedSpeedRatio;
	CurrentMotorSpeedList[BF_OD_OUT_MOTOR_INDEX][CurrentMotorSpeedIndex] = newSpeed;
	ApplyMotorSpeed();
}
//---------------------------------------------------------------------------


void __fastcall TSpeedControlForm::RotationOutSpeedUpButton1MouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  RotationOutSpeedUpButton1->Picture->Bitmap->Assign(tempGrayUp1->Picture->Bitmap);
  RotationOutSpeedUpButton1->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::RotationOutSpeedUpButton1MouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  RotationOutSpeedUpButton1->Picture->Bitmap->Assign(tempWhiteUp1->Picture->Bitmap);
  RotationOutSpeedUpButton1->Refresh();
}

//---------------------------------------------------------------------------
void __fastcall TSpeedControlForm::RotationOutSpeedUpButton2MouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  RotationOutSpeedUpButton2->Picture->Bitmap->Assign(tempGrayUp2->Picture->Bitmap);
  RotationOutSpeedUpButton2->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::RotationOutSpeedUpButton2MouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  RotationOutSpeedUpButton2->Picture->Bitmap->Assign(tempWhiteUp2->Picture->Bitmap);
  RotationOutSpeedUpButton2->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::RotationOutSpeedDownButton1MouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  RotationOutSpeedDownButton1->Picture->Bitmap->Assign(tempGrayDown1->Picture->Bitmap);
  RotationOutSpeedDownButton1->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::RotationOutSpeedDownButton1MouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  RotationOutSpeedDownButton1->Picture->Bitmap->Assign(tempWhiteDown1->Picture->Bitmap);
  RotationOutSpeedDownButton1->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::RotationOutSpeedDownButton2MouseDown(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  RotationOutSpeedDownButton2->Picture->Bitmap->Assign(tempGrayDown2->Picture->Bitmap);
  RotationOutSpeedDownButton2->Refresh();
}

//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::RotationOutSpeedDownButton2MouseUp(
      TObject *Sender, TMouseButton Button, TShiftState Shift, int X,
      int Y)
{
  RotationOutSpeedDownButton2->Picture->Bitmap->Assign(tempWhiteDown2->Picture->Bitmap);
  RotationOutSpeedDownButton2->Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TSpeedControlForm::TntFormCreate(TObject *Sender)
{
	if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
    {
     	Panel7->Top = 533;
        SimpleVDPanel->Top = 533;
    }
    else
    {
     	Panel7->Top = 388;
        SimpleVDPanel->Top  = 388;
    }
}
//---------------------------------------------------------------------------

