//---------------------------------------------------------------------------

#ifndef SpeedControl_FormH
#define SpeedControl_FormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <Buttons.hpp>

#include "Environment.h"
#include <Grids.hpp>
#include "TntButtons.hpp"
#include "TntExtCtrls.hpp"
#include "TntGrids.hpp"
#include "TntStdCtrls.hpp"
#include "TntForms.hpp"
#include <Graphics.hpp>

#define MAX_SPEED_BACKUP_COUNT				100

//---------------------------------------------------------------------------
typedef struct
{
	double BackupTime;
	AnsiString OperatorName;
	int SpeedControlIndex;
	int MotorSpeed[MAX_SERVO_MOTOR_COUNT];
} TSpeedBackupUnit;
//---------------------------------------------------------------------------
class TSpeedControlForm : public TTntForm
{
__published:	// IDE-managed Components
	TTntPanel *Panel8;
	TTntGroupBox *GroupBox1;
	TTntLabel *Label7;
	TTntPanel *MotorSpeedPanel1;
	TTntPanel *MotorSpeedPanel2;
	TTntPanel *MotorSpeedPanel3;
	TTntButton *MotorSpeedResetButton;
	TTntLabel *Label1;
	TTntPanel *Panel3;
	TTntPanel *FeederSpeedControlPanel;
	TTntGroupBox *GroupBox2;
	TTntPanel *VFSpeedAutoTrainingPanel;
	TTntPanel *VFSpeedManualTrainingPanel;
	TTntPanel *SpeedBackupPanel;
	TTntPanel *SpeedControlPanel;
	TTntButton *LoadOldSpeedButton;
	TTntPanel *Panel5;
	TTntButton *ApplyMachineSpeedButton;
	TTntBitBtn *OkBitBtn;
	TTntBitBtn *CancelBitBtn;
	TTntStringGrid *SpeedBackupListStringGrid;
	TTntPanel *Panel6;
	TTntPanel *Panel1;
	TTntButton *RestoreSpeedButton;
	TTntGroupBox *VFManualModeGroupBox;
	TTntLabel *Label5;
	TTntLabel *Label12;
	TTntLabel *Label13;
	TTntLabel *Label14;
	TTntEdit *VibMaxSpeedEdit;
	TTntEdit *VFManualSensorRatioEdit;
	TTntComboBox *VFManualSensorComboBox;
	TTntLabel *Label3;
	TTntGroupBox *VFAutoModeGroupBox;
	TTntLabel *Label4;
	TTntLabel *Label2;
	TTntLabel *Label6;
	TTntLabel *Label11;
	TTntLabel *Label15;
	TTntLabel *Label16;
	TTntEdit *VFAutoSensor1RatioEdit;
	TTntEdit *VFAutoSensor2RatioEdit;
	TTntEdit *VFAutoStartSpeedEdit;
  TTntLabel *TntLabel1;
  TTntLabel *TntLabel2;
  TTntLabel *TntLabel3;
  TTntComboBox *VFManualLimitSensorComboBox;
  TTntEdit *VFManualLimitSensorRatioEdit;
  TTntEdit *VibLimitSpeedEdit;
  TTntLabel *TntLabel4;
  TTntLabel *TntLabel5;
  TPanel *Panel2;
  TTntLabel *BFIDSpeedLabel;
  TImage *FeederInnerDiscSpeedDownButton1;
  TImage *FeederInnerDiscSpeedDownButto2;
  TTntLabel *Label8;
  TImage *FeederInnerDiscSpeedUpButton2;
  TImage *FeederInnerDiscSpeedUpButton1;
  TPanel *Panel4;
	TImage *RotationInSpeedDownButton1;
	TImage *RotationInSpeedDownButton2;
	TImage *RotationInSpeedUpButton2;
	TImage *RotationInSpeedUpButton1;
  TTntLabel *Label9;
	TTntLabel *BFODInSpeedLabel;
  TPanel *Panel7;
  TImage *VacuumDiscSpeedDownButton1;
  TImage *VacuumDiscSpeedDownButton2;
  TImage *VacuumDiscSpeedUpButton2;
  TImage *VacuumDiscSpeedUpButton1;
  TTntLabel *Label10;
  TTntLabel *VDSpeedLabel;
  TImage *tempWhiteDown2;
  TImage *tempWhiteDown1;
  TImage *tempWhiteUp1;
  TImage *tempWhiteUp2;
  TImage *tempGrayDown2;
  TImage *tempGrayDown1;
  TImage *tempGrayUp1;
  TImage *tempGrayUp2;
  TPanel *SimpleVDPanel;
  TTntLabel *TntLabel6;
  TImage *VDSimpleSpeedUpButton;
  TImage *VDSimpleSpeedDownButton;
  TTntLabel *VDSimpleSpeedLabel;
  TTntLabel *innerDiskRSpeed;
  TTntLabel *OutDiskRSpeed;
  TTntLabel *SucktionDiskRSpeed;
	TPanel *Panel9;
	TImage *RotationOutSpeedDownButton1;
	TImage *RotationOutSpeedDownButton2;
	TImage *RotationOutSpeedUpButton2;
	TImage *RotationOutSpeedUpButton1;
	TTntLabel *TntLabel7;
	TTntLabel *BFODOutSpeedLabel;
	TTntLabel *TntLabel9;
	void __fastcall MotorSpeedResetButtonClick(TObject *Sender);
	void __fastcall MotorSpeedPanelClick(TObject *Sender);
	void __fastcall OkBitBtnClick(TObject *Sender);
	void __fastcall FeederInnerDiscSpeedUpButtonClick(TObject *Sender);
	void __fastcall FeederInnerDiscSpeedDownButtonClick(TObject *Sender);
	void __fastcall VacuumDiscSpeedUpButtonClick(TObject *Sender);
	void __fastcall VacuumDiscSpeedDownButtonClick(TObject *Sender);
	void __fastcall VFSpeedAutoTrainingPanelClick(TObject *Sender);
	void __fastcall VFSpeedManualTrainingPanelClick(TObject *Sender);
	void __fastcall ApplyMachineSpeedButtonClick(TObject *Sender);
	void __fastcall NumEditClick(TObject *Sender);
	void __fastcall LoadOldSpeedButtonClick(TObject *Sender);
	void __fastcall RestoreSpeedButtonClick(TObject *Sender);
  void __fastcall FeederInnerDiscSpeedDownButton1MouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall FeederInnerDiscSpeedDownButton1MouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall RotationInSpeedDownButton1MouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall RotationInSpeedDownButton1MouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall VacuumDiscSpeedDownButton1MouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall VacuumDiscSpeedDownButton1MouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall FeederInnerDiscSpeedDownButto2MouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall FeederInnerDiscSpeedDownButto2MouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall RotationInSpeedDownButton2MouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall RotationInSpeedDownButton2MouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall VacuumDiscSpeedDownButton2MouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall VacuumDiscSpeedDownButton2MouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall FeederInnerDiscSpeedUpButton1MouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall FeederInnerDiscSpeedUpButton1MouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall RotationInSpeedUpButton1MouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall VacuumDiscSpeedUpButton1MouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall VacuumDiscSpeedUpButton1MouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall FeederInnerDiscSpeedUpButton2MouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall FeederInnerDiscSpeedUpButton2MouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall RotationInSpeedUpButton2MouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall RotationInSpeedUpButton2MouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall VacuumDiscSpeedUpButton2MouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall VacuumDiscSpeedUpButton2MouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall VDSimpleSpeedDownButtonMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall VDSimpleSpeedUpButtonMouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
  void __fastcall VDSimpleSpeedDownButtonMouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall RotationInSpeedDownButtonClick(TObject *Sender);
	void __fastcall RotationInSpeedUpButtonClick(TObject *Sender);
	void __fastcall RotationOutSpeedDownButtonClick(TObject *Sender);
	void __fastcall RotationOutSpeedUpButtonClick(TObject *Sender);
	void __fastcall RotationOutSpeedUpButton1MouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall RotationOutSpeedUpButton1MouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall RotationOutSpeedUpButton2MouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall RotationOutSpeedUpButton2MouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall RotationOutSpeedDownButton1MouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall RotationOutSpeedDownButton1MouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall RotationOutSpeedDownButton2MouseDown(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall RotationOutSpeedDownButton2MouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
	void __fastcall TntFormCreate(TObject *Sender);
private:	// User declarations
	int CurrentMotorSpeedIndex;
  int CurrentMotorSpeedList[MAX_SERVO_MOTOR_COUNT][MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT];
	int CurrentMotorSpeedRatioList[MAX_SERVO_MOTOR_COUNT][MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT];
	int OldMotorSpeedList[MAX_SERVO_MOTOR_COUNT][MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT];

  int CurrentSimpleSpeedIndex[MAX_SERVO_MOTOR_COUNT][MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT];
  int OldSimpleSpeedIndex[MAX_SERVO_MOTOR_COUNT][MOTOR_SPEED_STEP_COUNT_FOR_PRODUCT];

	int SpeedBackupDataIndex;
	bool VFSpeedAutoTraining;
	vector <TSpeedBackupUnit> SpeedBackupList;

    int OldVFAutoTrainingMode;
    int OldVFManualSpeed;
    int OldVFManualSensorIndex;
    int OldVFManualSensorActiveRatio;
    int OldVFManualLimitSpeed;
    int OldVFManualLimitSensorIndex;
    int OldVFManualLimitSensorActiveRatio;
    int OldVFSensor1Ratio;
    int OldVFSensor2Ratio;
    int OldVFStartSpeed;

	void __fastcall ApplyMotorSpeed(void);
	bool __fastcall ApplyMachineSpeedChange(void);
	void __fastcall SaveVFSpeedParam(void);
	void __fastcall BackupModifiedSpeed(void);
	void __fastcall LoadOldSpeedValues(void);
	WideString GetSpeedIndexStr(int speedControlIndex);
  void __fastcall TSpeedControlForm::GetDefaultString();
public:		// User declarations
	__fastcall TSpeedControlForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TSpeedControlForm *SpeedControlForm;
//---------------------------------------------------------------------------
#endif
