//---------------------------------------------------------------------------
// For SELMA200, 20180223, moon,  
//---------------------------------------------------------------------------
#include <vcl.h>
#include <inifiles.hpp>
#pragma hdrstop

#include "StudySpeedControl_Form.h"
#include "Message_Form.h"
#include "Keyboard_Form.h"
#include "MachineControl.h"
#include "MultiLanguage.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "TntButtons"
#pragma link "TntExtCtrls"
#pragma link "TntGrids"
#pragma link "TntStdCtrls"
#pragma resource "*.dfm"
TStudySpeedControlForm *StudySpeedControlForm;
//---------------------------------------------------------------------------
__fastcall TStudySpeedControlForm::TStudySpeedControlForm(TComponent* Owner)
	: TTntForm(Owner)
{
  if(DefaultLCID == 1028 || DefaultLCID == 2052 || DefaultLCID == 3076 || DefaultLCID == 4100)
    ComponentSetFontName(this, "SimSun");
  else if(DefaultLCID == 1041)
    ComponentSetFontName(this, "Meiryo UI");
  else if(DefaultLCID == 3082)
  {
    ComponentSetFontName(this, "Segoe UI");
    ComponentSetMultiLine(this);
  }
  GetDefaultString();
  int motorIndex = 0;
  for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
  {
    if(MachineSetupData.SimpleSpeedControlOption)
    {
      if( motorIndex == 0 || motorIndex == 1)
      {
        // SimpleMotorSpeedList
        CurrentMotorSpeedList[motorIndex][_STUDY_SPEED_CONTROL_INDEX] = ProductData.SimpleStudyMotorSpeedList[motorIndex][_STUDY_SPEED_CONTROL_INDEX];
        // VD Speed Step Info
        CurrentSimpleSpeedIndex[motorIndex][_STUDY_SPEED_CONTROL_INDEX] = ProductData.SimpleStudyMotorSpeedList[motorIndex][_STUDY_SPEED_CONTROL_INDEX];
      }
      else
      {
        CurrentMotorSpeedList[motorIndex][_STUDY_SPEED_CONTROL_INDEX] = ProductData.StudyMotorSpeedList[motorIndex][_STUDY_SPEED_CONTROL_INDEX];
      }
    }
    else
    {
      CurrentMotorSpeedList[motorIndex][_STUDY_SPEED_CONTROL_INDEX] = ProductData.StudyMotorSpeedList[motorIndex][_STUDY_SPEED_CONTROL_INDEX];
    }
  }


  if(CurrentMotorSpeedList[motorIndex][_STUDY_SPEED_CONTROL_INDEX] < 1000)
  {
	CurrentMotorSpeedList[SD1_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / 100;
	CurrentMotorSpeedList[SD2_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / 100;
	CurrentMotorSpeedList[BF_ID_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / 100;
	CurrentMotorSpeedList[BF_OD_IN_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / 50;
	CurrentMotorSpeedList[BF_OD_OUT_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / 50;

	CurrentMotorSpeedRatioList[SD1_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[SD1_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
	CurrentMotorSpeedRatioList[SD2_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[SD2_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
	CurrentMotorSpeedRatioList[BF_ID_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_ID_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
	CurrentMotorSpeedRatioList[BF_OD_IN_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_OD_IN_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
	if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
	{
		CurrentMotorSpeedRatioList[BF_OD_OUT_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_OD_OUT_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
	}
  }
  else
  {
      CurrentMotorSpeedRatioList[SD1_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[SD1_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
      CurrentMotorSpeedRatioList[SD2_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[SD2_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
      CurrentMotorSpeedRatioList[BF_ID_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_ID_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
      CurrentMotorSpeedRatioList[BF_OD_IN_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_OD_IN_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
      if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
      {
      	CurrentMotorSpeedRatioList[BF_OD_OUT_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_OD_OUT_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
      }
  }

	OldVFAutoTrainingMode = ProductData.MachineRunOption.MaxSpeedTrainingMode;
	OldVFManualSpeed = ProductData.MachineRunOption.ManualMaxSpeed;
	OldVFManualLimitSpeed = ProductData.MachineRunOption.ManualLimitSpeed;
	OldVFSensor1Ratio = ProductData.MachineRunOption.EmptySensorActiveRatio;
	OldVFSensor2Ratio = ProductData.MachineRunOption.FullSensorActiveRatio;
	OldVFStartSpeed = ProductData.MachineRunOption.StartSpeed;
	SpeedBackupDataIndex = 0;
	ApplyMotorSpeed();
	VFSpeedAutoTrainingPanel->Visible = false;
	VFSpeedManualTrainingPanel->Visible = false;
	VFSpeedAutoTraining = false;
	VFAutoModeGroupBox->Visible = false;
	VFManualModeGroupBox->Visible = true;
	VibMaxSpeedEdit->Enabled = true;
	VibLimitSpeedEdit->Enabled = true;
	//Auto
	VFAutoStartSpeedEdit->Text = IntToStr(ProductData.MachineRunOption.StartSpeed);
	VFAutoSensor1RatioEdit->Text = IntToStr(ProductData.MachineRunOption.EmptySensorActiveRatio);
	VFAutoSensor2RatioEdit->Text = IntToStr(ProductData.MachineRunOption.FullSensorActiveRatio);

	//Manual
	VibMaxSpeedEdit->Text = IntToStr(ProductData.MachineRunOption.ManualMaxSpeed);
	VFManualSensorComboBox->ItemIndex = ProductData.MachineRunOption.ManualModeSensorIndex;
	VFManualSensorRatioEdit->Text = IntToStr(ProductData.MachineRunOption.ManualModeSensorActiveRatio);
	VibLimitSpeedEdit->Text = IntToStr(ProductData.MachineRunOption.ManualLimitSpeed);
	VFManualLimitSensorComboBox->ItemIndex = ProductData.MachineRunOption.ManualModeLimitSensorIndex;
	VFManualLimitSensorRatioEdit->Text = IntToStr(ProductData.MachineRunOption.ManualModeLimitSensorActiveRatio);

  if(MachineSetupData.SimpleSpeedControlOption)
  {
    SimpleVDPanel->BringToFront();
  }
  else
  {
    VDSpeedLabelPanel->BringToFront();
  }
}
//---------------------------------------------------------------------------
void __fastcall TStudySpeedControlForm::GetDefaultString()
{
	CancelBitBtn->Caption = COMPUTERSYSTEMSETTINGFORM_BUTTON_CAPTION_03;
	OkBitBtn->Caption =  SPEEDCONTROLFORM_BITBTN_CAPTION_02;
	MotorSpeedResetButton->Caption = SPEEDCONTROLFORM_BUTTON_CAPTION_02;
	ApplyMachineSpeedButton->Caption = SPEEDCONTROLFORM_BUTTON_CAPTION_04;
	GroupBox1->Caption = SPEEDCONTROLFORM_GROUPBOX_CAPTION_01;
	VFAutoModeGroupBox->Caption = SPEEDCONTROLFORM_GROUPBOX_CAPTION_02;
	GroupBox2->Caption = SPEEDCONTROLFORM_GROUPBOX_CAPTION_03;
	Label1->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_01;
	Label10->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_02;
	Label4->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_03;
	Label6->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_04;
	Label7->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_05;
	Label16->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_06;
	Label8->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_07;
	Label9->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_08;
	MotorSpeedPanel1->Caption = NEW_ADD_STRING_19;
	  VFSpeedManualTrainingPanel->Caption = SPEEDCONTROLFORM_PANEL_CAPTION_04;
	  VFSpeedAutoTrainingPanel->Caption = SPEEDCONTROLFORM_PANEL_CAPTION_05;
	VFManualModeGroupBox->Caption = NEW_ADD_STRING_19;
	Label3->Caption = NEW_ADD_STRING_20;
	TntLabel1->Caption = NEW_ADD_STRING_21;
	Label14->Caption = NEW_ADD_STRING_22;
	TntLabel2->Caption = NEW_ADD_STRING_22;
	Label12->Caption = NEW_ADD_STRING_23;
	TntLabel3->Caption = NEW_ADD_STRING_23;

	VFManualModeGroupBox->Caption = NEW_ADD_STRING_19;
	VFManualSensorComboBox->Items->Strings[0] = NEW_ADD_STRING_24;
	VFManualSensorComboBox->Items->Strings[1] = NEW_ADD_STRING_25;

	VFManualLimitSensorComboBox->Items->Strings[0] = NEW_ADD_STRING_24;
	VFManualLimitSensorComboBox->Items->Strings[1] = NEW_ADD_STRING_25;

    this->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_09;
	if(MachineSetupData.MachineType < 2)
	{
		Label9->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_08;
		TntLabel6->Caption = "ȸ̵ ";
		TntLabel6->Visible = false;
		BFODOutSpeedLabel->Visible = false;
		RotationOutSpeedUpButton->Visible = false;
		RotationOutSpeedDownButton->Visible = false;
	}
	else
	{
		Label9->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_10;
		TntLabel6->Caption = SPEEDCONTROLFORM_LABEL_CAPTION_11;
		TntLabel6->Visible = true;
		BFODOutSpeedLabel->Visible = true;
		RotationOutSpeedUpButton->Visible = true;
		RotationOutSpeedDownButton->Visible = true;	
	}
	
}
//---------------------------------------------------------------------------
void __fastcall TStudySpeedControlForm::MotorSpeedResetButtonClick(
      TObject *Sender)
{
	if (MessageDlgFA(SPEEDCONTROLFORM_MSG_03, mtConfirmation, TMsgDlgButtons() << mbOK << mbCancel) == mrOk)
	{
    	int msTabletTypeIndex = _STUDY_MS_SPEED_INDEX;
		  int msTabletShapeIndex = _STUDY_MS_SHAPE_INDEX;
    	int motorIndex = 0;

    	for (motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
		  {
         if(MachineSetupData.SimpleSpeedControlOption)
        {
          if( motorIndex == 0 || motorIndex == 1)
          {
            CurrentMotorSpeedList[motorIndex][_STUDY_SPEED_CONTROL_INDEX] = MachineParams.MotorSimpleSpeedList[3];
            CurrentSimpleSpeedIndex[motorIndex][_STUDY_SPEED_CONTROL_INDEX] = 3;
          }
          else
          {
            CurrentMotorSpeedList[motorIndex][_STUDY_SPEED_CONTROL_INDEX] = MachineParams.MotorSpeedList[msTabletTypeIndex][msTabletShapeIndex][motorIndex][_STUDY_SPEED_CONTROL_INDEX];
          }
        }
        else
        {
          CurrentMotorSpeedList[motorIndex][_STUDY_SPEED_CONTROL_INDEX] = MachineParams.MotorSpeedList[msTabletTypeIndex][msTabletShapeIndex][motorIndex][_STUDY_SPEED_CONTROL_INDEX];
        }

		  }

    	motorIndex = 0;


    	if(MachineSetupData.ServoMotorData[motorIndex].BaseSpeed * 100 / CurrentMotorSpeedList[motorIndex][_STUDY_SPEED_CONTROL_INDEX] < 10)
    	{
       		CurrentMotorSpeedList[SD1_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / 100;
       		CurrentMotorSpeedList[SD2_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / 100;
       		CurrentMotorSpeedList[BF_ID_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / 70;
       		CurrentMotorSpeedList[BF_OD_IN_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / 70;
		if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
		{
			CurrentMotorSpeedList[BF_OD_OUT_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / 70;
		}
    	}

      CurrentMotorSpeedRatioList[SD1_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[SD1_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
      CurrentMotorSpeedRatioList[SD2_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[SD2_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
      CurrentMotorSpeedRatioList[BF_ID_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_ID_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
      CurrentMotorSpeedRatioList[BF_OD_IN_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_OD_IN_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
      if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
      {
      	CurrentMotorSpeedRatioList[BF_OD_OUT_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_OD_OUT_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
      }

	    ApplyMotorSpeed();

	}
}
//---------------------------------------------------------------------------
void __fastcall TStudySpeedControlForm::MotorSpeedPanelClick(TObject *Sender)
{
  ApplyMotorSpeed();
}
//---------------------------------------------------------------------------
void __fastcall TStudySpeedControlForm::ApplyMotorSpeed(void)
{
  TTntPanel *motorSpeedPanel = (TTntPanel *)FindComponent("MotorSpeedPanel" + IntToStr(_STUDY_SPEED_CONTROL_INDEX + 1));

  motorSpeedPanel->Color = clBlue;
  motorSpeedPanel->Font->Color = clWhite;

  BFIDSpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 60 / CurrentMotorSpeedList[BF_ID_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX])
  										+ "RPM (" + IntToStr(MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_ID_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX]) + "%)";

  BFODInSpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 36 / CurrentMotorSpeedList[BF_OD_IN_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX])
  										+ "RPM (" + IntToStr(MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_OD_IN_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX]) + "%)";
  if(MachineSetupData.MachineType == MACHINE_TYPE_SELMA_ADVANCED || MachineSetupData.MachineType == MACHINE_TYPE_LIMA_ADVANCED)
  {
  BFODOutSpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 36 / CurrentMotorSpeedList[BF_OD_OUT_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX])
  										+ "RPM (" + IntToStr(MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[BF_OD_OUT_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX]) + "%)";
  }
  VDSpeedLabel->Caption = IntToStr((int)(MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * SUCTION_DISK_100P_RPM / CurrentMotorSpeedList[SD1_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX]))  	
  										+ "RPM (" + IntToStr(MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / CurrentMotorSpeedList[SD1_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX]) + "%)";

  int SimpleSpeedValue = CurrentSimpleSpeedIndex[SD1_MOTOR_INDEX][CurrentMotorSpeedIndex];
  VDSimpleSpeedLabel->Caption = IntToStr(MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 60 / MachineParams.MotorSimpleSpeedList[SimpleSpeedValue])+ "RPM ( No."+IntToStr(SimpleSpeedValue+1)+" )";
  
}
//---------------------------------------------------------------------------
void __fastcall TStudySpeedControlForm::OkBitBtnClick(TObject *Sender)
{
	ApplyMachineSpeedChange();

  bool VFSpeedChanged = false;
  if (OldVFAutoTrainingMode   != ProductData.MachineRunOption.MaxSpeedTrainingMode)						VFSpeedChanged = true;
  if (OldVFSensor1Ratio       != ProductData.MachineRunOption.EmptySensorActiveRatio) 	        		VFSpeedChanged = true;
  if (OldVFSensor2Ratio       != ProductData.MachineRunOption.FullSensorActiveRatio)						VFSpeedChanged = true;
  if (OldVFStartSpeed         != ProductData.MachineRunOption.StartSpeed)									VFSpeedChanged = true;
  if (OldVFManualSpeed        != ProductData.MachineRunOption.ManualMaxSpeed)                           	VFSpeedChanged = true;
  if (OldVFManualSensorIndex  != ProductData.MachineRunOption.ManualModeSensorIndex)                  	VFSpeedChanged = true;
  if (OldVFManualSensorActiveRatio != ProductData.MachineRunOption.ManualModeSensorActiveRatio)       	VFSpeedChanged = true;
  if (OldVFManualLimitSpeed   != ProductData.MachineRunOption.ManualLimitSpeed)                       	VFSpeedChanged = true;
  if (OldVFManualLimitSensorIndex  != ProductData.MachineRunOption.ManualModeLimitSensorIndex)            VFSpeedChanged = true;
  if (OldVFManualLimitSensorActiveRatio != ProductData.MachineRunOption.ManualModeLimitSensorActiveRatio) VFSpeedChanged = true;
  if (VFSpeedChanged)
  {
    Machine.VFSpeedChange(&(ProductData.MachineRunOption));
  }

}
//---------------------------------------------------------------------------
void __fastcall TStudySpeedControlForm::FeederInnerDiscSpeedUpButtonClick(
	  TObject *Sender)
{
	int newSpeedRatio, newSpeed, calculatedSpeedRatio;

    newSpeedRatio = CurrentMotorSpeedRatioList[BF_ID_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
	do
    {
		newSpeedRatio = newSpeedRatio + 1;
		newSpeed = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
		if (newSpeed == 0) return;
		calculatedSpeedRatio = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / newSpeed;
		if (calculatedSpeedRatio > PCProgramOption.MotorMaxSpeed[1]) return;
	}
	while (calculatedSpeedRatio == CurrentMotorSpeedRatioList[BF_ID_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX]);
	CurrentMotorSpeedRatioList[BF_ID_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = calculatedSpeedRatio;
	CurrentMotorSpeedList[BF_ID_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = newSpeed;
	ApplyMotorSpeed();
}
//---------------------------------------------------------------------------
void __fastcall TStudySpeedControlForm::FeederInnerDiscSpeedDownButtonClick(
      TObject *Sender)
{
	int newSpeedRatio, newSpeed, calculatedSpeedRatio;

    newSpeedRatio = CurrentMotorSpeedRatioList[BF_ID_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
	do
    {
		newSpeedRatio = newSpeedRatio - 1;
        if (newSpeedRatio <= 0) return;
		newSpeed = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
		calculatedSpeedRatio = MachineSetupData.ServoMotorData[BF_ID_MOTOR_INDEX].BaseSpeed * 100 / newSpeed;
		if (calculatedSpeedRatio < PCProgramOption.MotorMinSpeed[1]) return;
	}
	while (calculatedSpeedRatio == CurrentMotorSpeedRatioList[BF_ID_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX]);
	CurrentMotorSpeedRatioList[BF_ID_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = calculatedSpeedRatio;
	CurrentMotorSpeedList[BF_ID_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = newSpeed;
  ApplyMotorSpeed();
}
//---------------------------------------------------------------------------

void __fastcall TStudySpeedControlForm::RotationInSpeedUpButtonClick(
      TObject *Sender)
{
	int newSpeedRatio, newSpeed, calculatedSpeedRatio;

    newSpeedRatio = CurrentMotorSpeedRatioList[BF_OD_IN_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];	// third operating module
	do
    {
		newSpeedRatio = newSpeedRatio + 1;
		newSpeed = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;		// fifth motor
		if (newSpeed == 0) return;
		calculatedSpeedRatio = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / newSpeed;		// fifth motor
		/*
		if (calculatedSpeedRatio > CurrentMotorSpeedRatioList[0][_STUDY_SPEED_CONTROL_INDEX] * 1.2)
		{
			ShowMessageFA("Ǵ  ӵ ̼ ũ ӵ 1.2 踦 ʰ  ϴ.");
			return;
		}
		*/
		if (calculatedSpeedRatio > PCProgramOption.MotorMaxSpeed[2]) return;
	}
	while (calculatedSpeedRatio == CurrentMotorSpeedRatioList[BF_OD_IN_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX]);
	CurrentMotorSpeedRatioList[BF_OD_IN_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = calculatedSpeedRatio;
	CurrentMotorSpeedList[BF_OD_IN_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = newSpeed;
	ApplyMotorSpeed();
}
//---------------------------------------------------------------------------

void __fastcall TStudySpeedControlForm::RotationInSpeedDownButtonClick(
      TObject *Sender)
{
	int newSpeedRatio, newSpeed, calculatedSpeedRatio;

    newSpeedRatio = CurrentMotorSpeedRatioList[BF_OD_IN_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
	do
    {
		newSpeedRatio = newSpeedRatio - 1;
        if (newSpeedRatio <= 0) return;
		newSpeed = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
		calculatedSpeedRatio = MachineSetupData.ServoMotorData[BF_OD_IN_MOTOR_INDEX].BaseSpeed * 100 / newSpeed;
		if (calculatedSpeedRatio < PCProgramOption.MotorMinSpeed[2]) return;
	}
	while (calculatedSpeedRatio == CurrentMotorSpeedRatioList[BF_OD_IN_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX]);
	CurrentMotorSpeedRatioList[BF_OD_IN_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = calculatedSpeedRatio;
	CurrentMotorSpeedList[BF_OD_IN_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = newSpeed;
    ApplyMotorSpeed();
}
//---------------------------------------------------------------------------

void __fastcall TStudySpeedControlForm::VacuumDiscSpeedUpButtonClick(
      TObject *Sender)
{
	int newSpeedRatio, newSpeed1, newSpeed2;
	int calculatedSpeedRatio1, calculatedSpeedRatio2;

  if(MachineSetupData.SimpleSpeedControlOption)
  {
    int CurrentVDStep = CurrentSimpleSpeedIndex[SD1_MOTOR_INDEX][0];
    int NewVDStep = CurrentVDStep;

    if(NewVDStep + 1 < 18)
      NewVDStep += 1;

    newSpeed1 = newSpeed2 = MachineParams.MotorSimpleSpeedList[NewVDStep];

    if (newSpeed1 == 0 || newSpeed2 == 0) return;
    calculatedSpeedRatio1 = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / newSpeed1;
    calculatedSpeedRatio2 = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / newSpeed2;

    CurrentSimpleSpeedIndex[SD1_MOTOR_INDEX][0]  =  NewVDStep;
    CurrentSimpleSpeedIndex[SD2_MOTOR_INDEX][0]  =  NewVDStep;
  }
  else
  {
    newSpeedRatio = CurrentMotorSpeedRatioList[0][_STUDY_SPEED_CONTROL_INDEX];

    do
    {
      newSpeedRatio = newSpeedRatio + 1;
      newSpeed2 = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
      newSpeed1 = newSpeed2;
      if (newSpeed1 == 0 || newSpeed2 == 0) return;
      calculatedSpeedRatio1 = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / newSpeed1;
      calculatedSpeedRatio2 = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / newSpeed2;

      if (calculatedSpeedRatio1 > PCProgramOption.MotorMaxSpeed[0] ||
        calculatedSpeedRatio2 > PCProgramOption.MotorMaxSpeed[0]) return;
      //if (calculatedSpeedRatio1 > 150 || calculatedSpeedRatio2 > 150) return;
    }
    while (calculatedSpeedRatio2 == CurrentMotorSpeedRatioList[SD1_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX]);
  }

	CurrentMotorSpeedRatioList[SD1_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = calculatedSpeedRatio1;
  	CurrentMotorSpeedRatioList[SD2_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = calculatedSpeedRatio2;

	CurrentMotorSpeedList[SD1_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = newSpeed1;
	CurrentMotorSpeedList[SD2_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = newSpeed2;
	ApplyMotorSpeed();
}
//---------------------------------------------------------------------------

void __fastcall TStudySpeedControlForm::VacuumDiscSpeedDownButtonClick(
	  TObject *Sender)
{
	int newSpeedRatio, newSpeed1, newSpeed2;
  int calculatedSpeedRatio1, calculatedSpeedRatio2;

  if(MachineSetupData.SimpleSpeedControlOption)
  {
    int CurrentVDStep = CurrentSimpleSpeedIndex[0][0];
    int NewVDStep = CurrentVDStep;

    if(NewVDStep - 1 >= 0)
      NewVDStep -= 1;

    newSpeed1 = newSpeed2 = MachineParams.MotorSimpleSpeedList[NewVDStep];

    if (newSpeed1 == 0 || newSpeed2 == 0) return;
    calculatedSpeedRatio1 = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / newSpeed1;
    calculatedSpeedRatio2 = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / newSpeed2;

    CurrentSimpleSpeedIndex[SD1_MOTOR_INDEX][0]  =  NewVDStep;
    CurrentSimpleSpeedIndex[SD2_MOTOR_INDEX][0]  =  NewVDStep;
  }
  else
  {
    newSpeedRatio = CurrentMotorSpeedRatioList[SD1_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
	  do
    {
		  newSpeedRatio = newSpeedRatio - 1;
      if (newSpeedRatio <= 0) return;
      if(newSpeedRatio < 100)
      {
      	ShowMessageFA(SPEEDCONTROLFORM_MSG_04);
        return;
      }

		newSpeed2 = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
		newSpeed1 = newSpeed2;

		calculatedSpeedRatio1 = MachineSetupData.ServoMotorData[SD1_MOTOR_INDEX].BaseSpeed * 100 / newSpeed1;
		calculatedSpeedRatio2 = MachineSetupData.ServoMotorData[SD2_MOTOR_INDEX].BaseSpeed * 100 / newSpeed2;

		if (calculatedSpeedRatio1 < PCProgramOption.MotorMinSpeed[0] ||
			calculatedSpeedRatio2 < PCProgramOption.MotorMinSpeed[0]) return;
    }
    while (calculatedSpeedRatio2 == CurrentMotorSpeedRatioList[SD2_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX]);
  }

	CurrentMotorSpeedRatioList[SD1_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = calculatedSpeedRatio1;
	CurrentMotorSpeedRatioList[SD2_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = calculatedSpeedRatio2;
	CurrentMotorSpeedList[SD1_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = newSpeed1;
	CurrentMotorSpeedList[SD2_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = newSpeed2;
	ApplyMotorSpeed();
}
//---------------------------------------------------------------------------

bool __fastcall TStudySpeedControlForm::ApplyMachineSpeedChange(void)
{
  for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
  {
    ProductData.StudyMotorSpeedList[motorIndex][_STUDY_SPEED_CONTROL_INDEX] = CurrentMotorSpeedList[motorIndex][_STUDY_SPEED_CONTROL_INDEX];
    ProductData.SimpleStudyMotorSpeedList[motorIndex][_STUDY_SPEED_CONTROL_INDEX] = CurrentSimpleSpeedIndex[motorIndex][_STUDY_SPEED_CONTROL_INDEX];
  }

  int manualSpeed = 100;
  int manualModeSensorIndex = 0;
  int manualModeSensorActiveRatio = 0;
	int manualLimitSpeed = 60;
  int manualModeLimitSensorIndex = 0;
  int manualModeLimitSensorActiveRatio = 0;

  bool bSpeedValueError = false;

  if (!VFSpeedAutoTraining)
  {
	  try
	  {
      manualSpeed = StrToInt(VibMaxSpeedEdit->Text);
      manualModeSensorIndex = VFManualSensorComboBox->ItemIndex;
			manualModeSensorActiveRatio = StrToInt(VFManualSensorRatioEdit->Text);
			manualLimitSpeed = StrToInt(VibLimitSpeedEdit->Text);
			manualModeLimitSensorIndex = VFManualLimitSensorComboBox->ItemIndex;
      manualModeLimitSensorActiveRatio = StrToInt(VFManualLimitSensorRatioEdit->Text);
    }
    catch(...)
    {
      bSpeedValueError = true;
    }
  }

	if (!bSpeedValueError)
  {
    if (manualSpeed < 1 || manualSpeed > 255)
    {
      bSpeedValueError = true;
    }
  }

  if (bSpeedValueError)
  {
    ShowMessageFA(SPEEDCONTROLFORM_MSG_02);
		VibMaxSpeedEdit->Text = IntToStr(100);
    VibLimitSpeedEdit->Text = IntToStr(100);
    return false;
	}

  if (VFSpeedAutoTraining)
  {
	  bool bRatioValueError = false;
	  int sensor1Ratio = 100;
	  int sensor2Ratio = 100;
    int startSpeed = 40;

	  try
	  {
		  sensor1Ratio = StrToInt(VFAutoSensor1RatioEdit->Text);
	    sensor2Ratio = StrToInt(VFAutoSensor2RatioEdit->Text);
      startSpeed   = StrToInt(VFAutoStartSpeedEdit->Text);

	    ProductData.MachineRunOption.EmptySensorActiveRatio = sensor1Ratio;
	    ProductData.MachineRunOption.FullSensorActiveRatio  = sensor2Ratio;
      ProductData.MachineRunOption.StartSpeed             = startSpeed;
    }
    catch (...)
    {
      bRatioValueError = true;
    }

	  if (bRatioValueError)
	  {
	    ShowMessageFA(SPEEDCONTROLFORM_MSG_01);
      return false;
    }
  }

	if (VFSpeedAutoTraining)
	{
		ProductData.MachineRunOption.MaxSpeedTrainingMode = MAX_SPEED_TRAINING_MODE_AUTO;
	}
	else
	{
		ProductData.MachineRunOption.MaxSpeedTrainingMode = MAX_SPEED_TRAINING_MODE_MANUAL;
		ProductData.MachineRunOption.ManualMaxSpeed = manualSpeed;
		ProductData.MachineRunOption.ManualModeSensorIndex = manualModeSensorIndex;
		ProductData.MachineRunOption.ManualModeSensorActiveRatio = manualModeSensorActiveRatio;
		ProductData.MachineRunOption.ManualLimitSpeed = manualLimitSpeed;
		ProductData.MachineRunOption.ManualModeLimitSensorIndex = manualModeLimitSensorIndex;
		ProductData.MachineRunOption.ManualModeLimitSensorActiveRatio = manualModeLimitSensorActiveRatio;
	}

	AnsiString fileName = GetProductDataFileName(ProductData.ProductCode);
	WriteProductData(fileName, ProductData);
	return true;
}
//---------------------------------------------------------------------------


void __fastcall TStudySpeedControlForm::VFSpeedAutoTrainingPanelClick(
      TObject *Sender)
{
  VFSpeedAutoTrainingPanel->Color = clBlue;
  VFSpeedAutoTrainingPanel->Font->Color = clWhite;
  VFSpeedManualTrainingPanel->Color = clWhite;
  VFSpeedManualTrainingPanel->Font->Color = clBlack;
  VFSpeedAutoTraining = true;
  VibMaxSpeedEdit->Enabled = false;
  VibLimitSpeedEdit->Enabled = false;
  VFAutoModeGroupBox->Visible = true;
  VFManualModeGroupBox->Visible = false;
}
//---------------------------------------------------------------------------
void __fastcall TStudySpeedControlForm::VFSpeedManualTrainingPanelClick(
      TObject *Sender)
{
	VFSpeedAutoTrainingPanel->Color = clWhite;
  VFSpeedAutoTrainingPanel->Font->Color = clBlack;
	VFSpeedManualTrainingPanel->Color = clBlue;
  VFSpeedManualTrainingPanel->Font->Color = clWhite;
  VFSpeedAutoTraining = false;
  VibMaxSpeedEdit->Enabled = true;
  VibLimitSpeedEdit->Enabled = true;
  VFAutoModeGroupBox->Visible = false;
  VFManualModeGroupBox->Visible = true;
}
//---------------------------------------------------------------------------
void __fastcall TStudySpeedControlForm::SaveVFSpeedParam(void)
{
	if (!Comm_Request(COMM_HCB, CMD_MACHINE_PARAM_SETUP, &MachineSetupData, sizeof(TMachineSetupData)))
	{
  }
}
//---------------------------------------------------------------------------
void __fastcall TStudySpeedControlForm::ApplyMachineSpeedButtonClick(TObject *Sender)
{
	if (ApplyMachineSpeedChange())
	{
		if (Machine.Status.OperationState == MACHINE_STATE_RUN)
		{
			int motorSpeedList[MAX_SERVO_MOTOR_COUNT];
			for (int motorIndex = 0; motorIndex < MAX_SERVO_MOTOR_COUNT; motorIndex++)
			{
				motorSpeedList[motorIndex] = CurrentMotorSpeedList[motorIndex][_STUDY_SPEED_CONTROL_INDEX];
			}

			Machine.SpeedChange(motorSpeedList);
		}

    Machine.VFSpeedChange(&(ProductData.MachineRunOption));
	}
}
//---------------------------------------------------------------------------

void __fastcall TStudySpeedControlForm::NumEdit(TObject *Sender)
{
  TTntEdit *theEdit = (TTntEdit *) Sender;
	KeyboardForm->Text = theEdit->Text;
	if (KeyboardForm->ShowKeypad() == mrOk)
	{
		theEdit->Text = KeyboardForm->Text;
	}
}
//---------------------------------------------------------------------------
void __fastcall TStudySpeedControlForm::RotationOutSpeedUpButtonClick(
      TObject *Sender)
{
	int newSpeedRatio, newSpeed, calculatedSpeedRatio;

    newSpeedRatio = CurrentMotorSpeedRatioList[BF_OD_OUT_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];	// third operating module
	do
    {
		newSpeedRatio = newSpeedRatio + 1;
		newSpeed = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;		// fifth motor
		if (newSpeed == 0) return;
		calculatedSpeedRatio = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / newSpeed;		// fifth motor
		if (calculatedSpeedRatio > PCProgramOption.MotorMaxSpeed[0]) return;
	}
	while (calculatedSpeedRatio == CurrentMotorSpeedRatioList[BF_OD_OUT_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX]);
	CurrentMotorSpeedRatioList[BF_OD_OUT_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = calculatedSpeedRatio;
	CurrentMotorSpeedList[BF_OD_OUT_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = newSpeed;
	ApplyMotorSpeed();
}
//---------------------------------------------------------------------------

void __fastcall TStudySpeedControlForm::RotationOutSpeedDownButtonClick(
      TObject *Sender)
{
	int newSpeedRatio, newSpeed, calculatedSpeedRatio;

    newSpeedRatio = CurrentMotorSpeedRatioList[BF_OD_OUT_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX];
	do
    {
		newSpeedRatio = newSpeedRatio - 1;
        if (newSpeedRatio <= 0) return;
		newSpeed = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / newSpeedRatio;
		calculatedSpeedRatio = MachineSetupData.ServoMotorData[BF_OD_OUT_MOTOR_INDEX].BaseSpeed * 100 / newSpeed;
		if (calculatedSpeedRatio < PCProgramOption.MotorMinSpeed[2]) return;
	}
	while (calculatedSpeedRatio == CurrentMotorSpeedRatioList[BF_OD_OUT_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX]);
	CurrentMotorSpeedRatioList[BF_OD_OUT_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = calculatedSpeedRatio;
	CurrentMotorSpeedList[BF_OD_OUT_MOTOR_INDEX][_STUDY_SPEED_CONTROL_INDEX] = newSpeed;
    ApplyMotorSpeed();
}
//---------------------------------------------------------------------------

